(ns nl.jomco.http-status-codes)

;; source: https://www.iana.org/assignments/http-status-codes/http-status-codes.txt

(def continue 100)
(def switching-protocols 101)
(def processing 102)
(def early-hints 103)
(def ok 200)
(def created 201)
(def accepted 202)
(def non-authoritative-information 203)
(def no-content 204)
(def reset-content 205)
(def partial-content 206)
(def multi-status 207)
(def already-reported 208)
(def im-used 226)
(def multiple-choices 300)
(def moved-permanently 301)
(def found 302)
(def see-other 303)
(def not-modified 304)
(def use-proxy 305)
(def temporary-redirect 307)
(def permanent-redirect 308)
(def bad-request 400)
(def unauthorized 401)
(def payment-required 402)
(def forbidden 403)
(def not-found 404)
(def method-not-allowed 405)
(def not-acceptable 406)
(def proxy-authentication-required 407)
(def request-timeout 408)
(def conflict 409)
(def gone 410)
(def length-required 411)
(def precondition-failed 412)
(def content-too-large 413)
(def uri-too-long 414)
(def unsupported-media-type 415)
(def range-not-satisfiable 416)
(def expectation-failed 417)
(def misdirected-request 421)
(def unprocessable-content 422)
(def locked 423)
(def failed-dependency 424)
(def too-early 425)
(def upgrade-required 426)
(def precondition-required 428)
(def too-many-requests 429)
(def request-header-fields-too-large 431)
(def unavailable-for-legal-reasons 451)
(def internal-server-error 500)
(def not-implemented 501)
(def bad-gateway 502)
(def service-unavailable 503)
(def gateway-timeout 504)
(def http-version-not-supported 505)
(def variant-also-negotiates 506)
(def insufficient-storage 507)
(def loop-detected 508)
(def not-extended 510)
(def network-authentication-required 511)

(def informational-status? (set (range 100 200)))
(def success-status? (set (range 200 300)))
(def redirection-status? (set (range 300 400)))
(def client-error-status? (set (range 400 500)))
(def server-error-status? (set (range 500 600)))
