/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import com.aphyr.riemann.Proto;
import com.aphyr.riemann.client.ExceptionReporter;
import com.aphyr.riemann.client.Promise;
import com.aphyr.riemann.client.Write;
import com.aphyr.riemann.client.WriteQueue;
import java.io.IOException;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;

public class TcpHandler
extends SimpleChannelHandler {
    public final WriteQueue queue = new WriteQueue();
    public volatile IOException lastError = new IOException("Channel closed.");
    public final ChannelGroup channelGroup;
    public final ExceptionReporter exceptionReporter;

    public TcpHandler(ChannelGroup channelGroup, ExceptionReporter exceptionReporter) {
        this.channelGroup = channelGroup;
        this.exceptionReporter = exceptionReporter;
    }

    public void channelOpen(ChannelHandlerContext c, ChannelStateEvent e) throws Exception {
        this.channelGroup.add((Object)e.getChannel());
        super.channelOpen(c, e);
    }

    public void channelConnected(ChannelHandlerContext c, ChannelStateEvent e) throws Exception {
        this.queue.open();
        super.channelConnected(c, e);
    }

    public void channelClosed(ChannelHandlerContext c, ChannelStateEvent e) throws Exception {
        this.channelGroup.remove((Object)e.getChannel());
        this.queue.close();
        super.channelClosed(c, e);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (!(e instanceof MessageEvent)) {
            ctx.sendDownstream(e);
            return;
        }
        MessageEvent me = (MessageEvent)e;
        if (!(me.getMessage() instanceof Write)) {
            ctx.sendUpstream((ChannelEvent)me);
            return;
        }
        Write write = (Write)me.getMessage();
        Proto.Msg message = write.message;
        final Promise<Proto.Msg> promise = write.promise;
        me.getFuture().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    TcpHandler.this.queue.put(promise);
                } else if (future.getCause() != null) {
                    promise.deliver(new IOException("Write failed.", future.getCause()));
                } else {
                    promise.deliver(new IOException("Write failed."));
                }
            }
        });
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)me.getFuture(), (Object)message);
    }

    public void messageReceived(ChannelHandlerContext c, MessageEvent e) {
        Proto.Msg message = (Proto.Msg)e.getMessage();
        this.queue.take().deliver(message);
    }

    public void exceptionCaught(ChannelHandlerContext c, ExceptionEvent e) {
        try {
            this.exceptionReporter.reportException(e.getCause());
        }
        catch (Exception exception) {
            // empty catch block
        }
        e.getChannel().close();
    }
}

