(ns nl.epij.gcp.gcf.message
  (:require [cheshire.core :as json])
  (:import [java.util Base64]))

(defn parse
  [message]
  (let [{message-type        "@type"
         attributes          "attributes"
         ^String data-base64 "data"}
        (json/parse-string-strict message)

        data (String. (.decode (Base64/getDecoder) data-base64))]
    {::type       message-type
     ::attributes attributes
     ::data       data}))

(comment

 (parse "{\"@type\" : \"type.googleapis.com/google.pubsub.v1.PubsubMessage\", \"attributes\" : {\"buildId\" : \"2410f12d-cf3f-41bd-98fe-e1e6146e4975\", \"status\" : \"QUEUED\"}, \"data\" : \"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\\u003d\\u003d\"}")
 )
