/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.apache.logging.log4j.util.TriConsumer;

public class JdkMapAdapterStringMap
implements StringMap {
    private static final long serialVersionUID = -7348247784983193612L;
    private static final String FROZEN = "Frozen collection cannot be modified";
    private static final Comparator<? super String> NULL_FIRST_COMPARATOR = (left2, right2) -> {
        if (left2 == null) {
            return -1;
        }
        if (right2 == null) {
            return 1;
        }
        return left2.compareTo((String)right2);
    };
    private final Map<String, String> map;
    private boolean immutable = false;
    private transient String[] sortedKeys;
    private static TriConsumer<String, String, Map<String, String>> PUT_ALL = (key2, value, stringStringMap) -> stringStringMap.put(key2, value);

    public JdkMapAdapterStringMap() {
        this(new HashMap<String, String>());
    }

    public JdkMapAdapterStringMap(Map<String, String> map2) {
        this.map = Objects.requireNonNull(map2, "map");
    }

    @Override
    public Map<String, String> toMap() {
        return this.map;
    }

    private void assertNotFrozen() {
        if (this.immutable) {
            throw new UnsupportedOperationException(FROZEN);
        }
    }

    @Override
    public boolean containsKey(String key2) {
        return this.map.containsKey(key2);
    }

    @Override
    public <V> void forEach(BiConsumer<String, ? super V> action) {
        String[] keys2 = this.getSortedKeys();
        for (int i = 0; i < keys2.length; ++i) {
            action.accept(keys2[i], this.map.get(keys2[i]));
        }
    }

    @Override
    public <V, S> void forEach(TriConsumer<String, ? super V, S> action, S state) {
        String[] keys2 = this.getSortedKeys();
        for (int i = 0; i < keys2.length; ++i) {
            action.accept(keys2[i], this.map.get(keys2[i]), state);
        }
    }

    private String[] getSortedKeys() {
        if (this.sortedKeys == null) {
            this.sortedKeys = this.map.keySet().toArray(new String[this.map.size()]);
            Arrays.sort(this.sortedKeys, NULL_FIRST_COMPARATOR);
        }
        return this.sortedKeys;
    }

    @Override
    public <V> V getValue(String key2) {
        return (V)this.map.get(key2);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void clear() {
        if (this.map.isEmpty()) {
            return;
        }
        this.assertNotFrozen();
        this.map.clear();
        this.sortedKeys = null;
    }

    @Override
    public void freeze() {
        this.immutable = true;
    }

    @Override
    public boolean isFrozen() {
        return this.immutable;
    }

    @Override
    public void putAll(ReadOnlyStringMap source2) {
        this.assertNotFrozen();
        source2.forEach(PUT_ALL, this.map);
        this.sortedKeys = null;
    }

    @Override
    public void putValue(String key2, Object value) {
        this.assertNotFrozen();
        this.map.put(key2, value == null ? null : String.valueOf(value));
        this.sortedKeys = null;
    }

    @Override
    public void remove(String key2) {
        if (!this.map.containsKey(key2)) {
            return;
        }
        this.assertNotFrozen();
        this.map.remove(key2);
        this.sortedKeys = null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.map.size() * 13);
        result.append('{');
        String[] keys2 = this.getSortedKeys();
        for (int i = 0; i < keys2.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(keys2[i]).append('=').append(this.map.get(keys2[i]));
        }
        result.append('}');
        return result.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JdkMapAdapterStringMap)) {
            return false;
        }
        JdkMapAdapterStringMap other = (JdkMapAdapterStringMap)object;
        return this.map.equals(other.map) && this.immutable == other.immutable;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode() + (this.immutable ? 31 : 0);
    }
}

