/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertiesPropertySource;
import org.apache.logging.log4j.util.PropertyFilePropertySource;
import org.apache.logging.log4j.util.PropertySource;
import org.apache.logging.log4j.util.Supplier;

public final class PropertiesUtil {
    private static final String LOG4J_PROPERTIES_FILE_NAME = "log4j2.component.properties";
    private static final String LOG4J_SYSTEM_PROPERTIES_FILE_NAME = "log4j2.system.properties";
    private static final String SYSTEM = "system:";
    private static final PropertiesUtil LOG4J_PROPERTIES = new PropertiesUtil("log4j2.component.properties");
    private final Environment environment;

    public PropertiesUtil(Properties props) {
        this.environment = new Environment(new PropertiesPropertySource(props));
    }

    public PropertiesUtil(String propertiesFileName) {
        this.environment = new Environment(new PropertyFilePropertySource(propertiesFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadClose(InputStream in, Object source2) {
        Properties props = new Properties();
        if (null != in) {
            try {
                props.load(in);
            }
            catch (IOException e2) {
                LowLevelLogUtil.logException("Unable to read " + source2, e2);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e3) {
                    LowLevelLogUtil.logException("Unable to close " + source2, e3);
                }
            }
        }
        return props;
    }

    public static PropertiesUtil getProperties() {
        return LOG4J_PROPERTIES;
    }

    public boolean hasProperty(String name2) {
        return this.environment.containsKey(name2);
    }

    public boolean getBooleanProperty(String name2) {
        return this.getBooleanProperty(name2, false);
    }

    public boolean getBooleanProperty(String name2, boolean defaultValue) {
        String prop = this.getStringProperty(name2);
        return prop == null ? defaultValue : "true".equalsIgnoreCase(prop);
    }

    public boolean getBooleanProperty(String name2, boolean defaultValueIfAbsent, boolean defaultValueIfPresent) {
        String prop = this.getStringProperty(name2);
        return prop == null ? defaultValueIfAbsent : (prop.isEmpty() ? defaultValueIfPresent : "true".equalsIgnoreCase(prop));
    }

    public Boolean getBooleanProperty(String[] prefixes, String key2, Supplier<Boolean> supplier) {
        for (String prefix : prefixes) {
            if (!this.hasProperty(prefix + key2)) continue;
            return this.getBooleanProperty(prefix + key2);
        }
        return supplier != null ? supplier.get() : null;
    }

    public Charset getCharsetProperty(String name2) {
        return this.getCharsetProperty(name2, Charset.defaultCharset());
    }

    public Charset getCharsetProperty(String name2, Charset defaultValue) {
        String mapped;
        String charsetName = this.getStringProperty(name2);
        if (charsetName == null) {
            return defaultValue;
        }
        if (Charset.isSupported(charsetName)) {
            return Charset.forName(charsetName);
        }
        ResourceBundle bundle = PropertiesUtil.getCharsetsResourceBundle();
        if (bundle.containsKey(name2) && Charset.isSupported(mapped = bundle.getString(name2))) {
            return Charset.forName(mapped);
        }
        LowLevelLogUtil.log("Unable to get Charset '" + charsetName + "' for property '" + name2 + "', using default " + defaultValue + " and continuing.");
        return defaultValue;
    }

    public double getDoubleProperty(String name2, double defaultValue) {
        String prop = this.getStringProperty(name2);
        if (prop != null) {
            try {
                return Double.parseDouble(prop);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public int getIntegerProperty(String name2, int defaultValue) {
        String prop = this.getStringProperty(name2);
        if (prop != null) {
            try {
                return Integer.parseInt(prop);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public Integer getIntegerProperty(String[] prefixes, String key2, Supplier<Integer> supplier) {
        for (String prefix : prefixes) {
            if (!this.hasProperty(prefix + key2)) continue;
            return this.getIntegerProperty(prefix + key2, 0);
        }
        return supplier != null ? supplier.get() : null;
    }

    public long getLongProperty(String name2, long defaultValue) {
        String prop = this.getStringProperty(name2);
        if (prop != null) {
            try {
                return Long.parseLong(prop);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public Long getLongProperty(String[] prefixes, String key2, Supplier<Long> supplier) {
        for (String prefix : prefixes) {
            if (!this.hasProperty(prefix + key2)) continue;
            return this.getLongProperty(prefix + key2, 0L);
        }
        return supplier != null ? supplier.get() : null;
    }

    public Duration getDurationProperty(String name2, Duration defaultValue) {
        String prop = this.getStringProperty(name2);
        if (prop != null) {
            return TimeUnit.getDuration(prop);
        }
        return defaultValue;
    }

    public Duration getDurationProperty(String[] prefixes, String key2, Supplier<Duration> supplier) {
        for (String prefix : prefixes) {
            if (!this.hasProperty(prefix + key2)) continue;
            return this.getDurationProperty(prefix + key2, null);
        }
        return supplier != null ? supplier.get() : null;
    }

    public String getStringProperty(String[] prefixes, String key2, Supplier<String> supplier) {
        for (String prefix : prefixes) {
            String result = this.getStringProperty(prefix + key2);
            if (result == null) continue;
            return result;
        }
        return supplier != null ? supplier.get() : null;
    }

    public String getStringProperty(String name2) {
        return this.environment.get(name2);
    }

    public String getStringProperty(String name2, String defaultValue) {
        String prop = this.getStringProperty(name2);
        return prop == null ? defaultValue : prop;
    }

    public static Properties getSystemProperties() {
        try {
            return new Properties(System.getProperties());
        }
        catch (SecurityException ex) {
            LowLevelLogUtil.logException("Unable to access system properties.", ex);
            return new Properties();
        }
    }

    public void reload() {
        this.environment.reload();
    }

    public static Properties extractSubset(Properties properties, String prefix) {
        Properties subset = new Properties();
        if (prefix == null || prefix.length() == 0) {
            return subset;
        }
        String prefixToMatch = prefix.charAt(prefix.length() - 1) != '.' ? prefix + '.' : prefix;
        ArrayList<String> keys2 = new ArrayList<String>();
        for (String key2 : properties.stringPropertyNames()) {
            if (!key2.startsWith(prefixToMatch)) continue;
            subset.setProperty(key2.substring(prefixToMatch.length()), properties.getProperty(key2));
            keys2.add(key2);
        }
        for (String key2 : keys2) {
            properties.remove(key2);
        }
        return subset;
    }

    static ResourceBundle getCharsetsResourceBundle() {
        return ResourceBundle.getBundle("Log4j-charsets");
    }

    public static Map<String, Properties> partitionOnCommonPrefixes(Properties properties) {
        ConcurrentHashMap<String, Properties> parts = new ConcurrentHashMap<String, Properties>();
        for (String key2 : properties.stringPropertyNames()) {
            String prefix = key2.substring(0, key2.indexOf(46));
            if (!parts.containsKey(prefix)) {
                parts.put(prefix, new Properties());
            }
            ((Properties)parts.get(prefix)).setProperty(key2.substring(key2.indexOf(46) + 1), properties.getProperty(key2));
        }
        return parts;
    }

    public boolean isOsWindows() {
        return this.getStringProperty("os.name", "").startsWith("Windows");
    }

    private static enum TimeUnit {
        NANOS("ns,nano,nanos,nanosecond,nanoseconds", ChronoUnit.NANOS),
        MICROS("us,micro,micros,microsecond,microseconds", ChronoUnit.MICROS),
        MILLIS("ms,milli,millis,millsecond,milliseconds", ChronoUnit.MILLIS),
        SECONDS("s,second,seconds", ChronoUnit.SECONDS),
        MINUTES("m,minute,minutes", ChronoUnit.MINUTES),
        HOURS("h,hour,hours", ChronoUnit.HOURS),
        DAYS("d,day,days", ChronoUnit.DAYS);

        private final String[] descriptions;
        private final ChronoUnit timeUnit;

        private TimeUnit(String descriptions, ChronoUnit timeUnit) {
            this.descriptions = descriptions.split(",");
            this.timeUnit = timeUnit;
        }

        ChronoUnit getTimeUnit() {
            return this.timeUnit;
        }

        static Duration getDuration(String time2) {
            String value = time2.trim();
            ChronoUnit temporalUnit = ChronoUnit.MILLIS;
            long timeVal = 0L;
            for (TimeUnit timeUnit : TimeUnit.values()) {
                for (String suffix : timeUnit.descriptions) {
                    if (!value.endsWith(suffix)) continue;
                    temporalUnit = timeUnit.timeUnit;
                    timeVal = Long.parseLong(value.substring(0, value.length() - suffix.length()));
                }
            }
            return Duration.of(timeVal, temporalUnit);
        }
    }

    private static class Environment {
        private final Set<PropertySource> sources = new TreeSet<PropertySource>(new PropertySource.Comparator());
        private final Map<CharSequence, String> literal = new ConcurrentHashMap<CharSequence, String>();
        private final Map<CharSequence, String> normalized = new ConcurrentHashMap<CharSequence, String>();
        private final Map<List<CharSequence>, String> tokenized = new ConcurrentHashMap<List<CharSequence>, String>();

        private Environment(PropertySource propertySource) {
            PropertyFilePropertySource sysProps = new PropertyFilePropertySource(PropertiesUtil.LOG4J_SYSTEM_PROPERTIES_FILE_NAME);
            try {
                sysProps.forEach((key2, value) -> {
                    if (System.getProperty(key2) == null) {
                        System.setProperty(key2, value);
                    }
                });
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.sources.add(propertySource);
            for (ClassLoader classLoader : LoaderUtil.getClassLoaders()) {
                try {
                    for (PropertySource source2 : ServiceLoader.load(PropertySource.class, classLoader)) {
                        this.sources.add(source2);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.reload();
        }

        private synchronized void reload() {
            this.literal.clear();
            this.normalized.clear();
            this.tokenized.clear();
            for (PropertySource source2 : this.sources) {
                source2.forEach((key2, value) -> {
                    if (key2 != null && value != null) {
                        this.literal.put((CharSequence)key2, (String)value);
                        List<CharSequence> tokens = PropertySource.Util.tokenize(key2);
                        if (tokens.isEmpty()) {
                            this.normalized.put(source2.getNormalForm(Collections.singleton(key2)), (String)value);
                        } else {
                            this.normalized.put(source2.getNormalForm(tokens), (String)value);
                            this.tokenized.put(tokens, (String)value);
                        }
                    }
                });
            }
        }

        private static boolean hasSystemProperty(String key2) {
            try {
                return System.getProperties().containsKey(key2);
            }
            catch (SecurityException ignored) {
                return false;
            }
        }

        private String get(String key2) {
            if (this.normalized.containsKey(key2)) {
                return this.normalized.get(key2);
            }
            if (this.literal.containsKey(key2)) {
                return this.literal.get(key2);
            }
            if (Environment.hasSystemProperty(key2)) {
                return System.getProperty(key2);
            }
            for (PropertySource source2 : this.sources) {
                if (!source2.containsProperty(key2)) continue;
                return source2.getProperty(key2);
            }
            return this.tokenized.get(PropertySource.Util.tokenize(key2));
        }

        private boolean containsKey(String key2) {
            return this.normalized.containsKey(key2) || this.literal.containsKey(key2) || Environment.hasSystemProperty(key2) || this.tokenized.containsKey(PropertySource.Util.tokenize(key2));
        }
    }
}

