/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.osgi;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.core.selector.ClassLoaderContextSelector;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkUtil;

public class BundleContextSelector
extends ClassLoaderContextSelector {
    @Override
    public void shutdown(String fqcn, ClassLoader loader, boolean currentContext, boolean allContexts) {
        Class<?> callerClass;
        LoggerContext ctx = null;
        Bundle bundle = null;
        if (currentContext) {
            ctx = ContextAnchor.THREAD_CONTEXT.get();
            ContextAnchor.THREAD_CONTEXT.remove();
        }
        if (ctx == null && loader instanceof BundleReference) {
            bundle = ((BundleReference)loader).getBundle();
            ctx = this.getLoggerContext(bundle);
            this.removeLoggerContext(ctx);
        }
        if (ctx == null && (callerClass = StackLocatorUtil.getCallerClass(fqcn)) != null) {
            bundle = FrameworkUtil.getBundle(callerClass);
            ctx = this.getLoggerContext(FrameworkUtil.getBundle(callerClass));
            this.removeLoggerContext(ctx);
        }
        if (ctx == null) {
            ctx = ContextAnchor.THREAD_CONTEXT.get();
            ContextAnchor.THREAD_CONTEXT.remove();
        }
        if (ctx != null) {
            ctx.stop(50L, TimeUnit.MILLISECONDS);
        }
        if (bundle != null && allContexts) {
            Bundle[] bundles;
            for (Bundle bdl : bundles = bundle.getBundleContext().getBundles()) {
                ctx = this.getLoggerContext(bdl);
                if (ctx == null) continue;
                ctx.stop(50L, TimeUnit.MILLISECONDS);
            }
        }
    }

    private LoggerContext getLoggerContext(Bundle bundle) {
        String name2 = Objects.requireNonNull(bundle, "No Bundle provided").getSymbolicName();
        AtomicReference ref2 = (AtomicReference)CONTEXT_MAP.get(name2);
        if (ref2 != null && ref2.get() != null) {
            return (LoggerContext)((WeakReference)ref2.get()).get();
        }
        return null;
    }

    private void removeLoggerContext(LoggerContext context) {
        CONTEXT_MAP.remove(context.getName());
    }

    @Override
    public boolean hasContext(String fqcn, ClassLoader loader, boolean currentContext) {
        if (currentContext && ContextAnchor.THREAD_CONTEXT.get() != null) {
            return ContextAnchor.THREAD_CONTEXT.get().isStarted();
        }
        if (loader instanceof BundleReference) {
            return BundleContextSelector.hasContext(((BundleReference)loader).getBundle());
        }
        Class<?> callerClass = StackLocatorUtil.getCallerClass(fqcn);
        if (callerClass != null) {
            return BundleContextSelector.hasContext(FrameworkUtil.getBundle(callerClass));
        }
        return ContextAnchor.THREAD_CONTEXT.get() != null && ContextAnchor.THREAD_CONTEXT.get().isStarted();
    }

    @Override
    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext, URI configLocation) {
        if (currentContext) {
            LoggerContext ctx = ContextAnchor.THREAD_CONTEXT.get();
            if (ctx != null) {
                return ctx;
            }
            return this.getDefault();
        }
        if (loader instanceof BundleReference) {
            return BundleContextSelector.locateContext(((BundleReference)loader).getBundle(), configLocation);
        }
        Class<?> callerClass = StackLocatorUtil.getCallerClass(fqcn);
        if (callerClass != null) {
            return BundleContextSelector.locateContext(FrameworkUtil.getBundle(callerClass), configLocation);
        }
        LoggerContext lc = ContextAnchor.THREAD_CONTEXT.get();
        return lc == null ? this.getDefault() : lc;
    }

    private static boolean hasContext(Bundle bundle) {
        String name2 = Objects.requireNonNull(bundle, "No Bundle provided").getSymbolicName();
        AtomicReference ref2 = (AtomicReference)CONTEXT_MAP.get(name2);
        return ref2 != null && ref2.get() != null && ((WeakReference)ref2.get()).get() != null && ((LoggerContext)((WeakReference)ref2.get()).get()).isStarted();
    }

    private static LoggerContext locateContext(Bundle bundle, URI configLocation) {
        String name2 = Objects.requireNonNull(bundle, "No Bundle provided").getSymbolicName();
        AtomicReference ref2 = (AtomicReference)CONTEXT_MAP.get(name2);
        if (ref2 == null) {
            LoggerContext context = new LoggerContext(name2, (Object)bundle, configLocation);
            CONTEXT_MAP.putIfAbsent(name2, new AtomicReference<WeakReference<LoggerContext>>(new WeakReference<LoggerContext>(context)));
            return (LoggerContext)((WeakReference)((AtomicReference)CONTEXT_MAP.get(name2)).get()).get();
        }
        WeakReference r = (WeakReference)ref2.get();
        LoggerContext ctx = (LoggerContext)r.get();
        if (ctx == null) {
            LoggerContext context = new LoggerContext(name2, (Object)bundle, configLocation);
            ref2.compareAndSet(r, new WeakReference<LoggerContext>(context));
            return (LoggerContext)((WeakReference)ref2.get()).get();
        }
        URI oldConfigLocation = ctx.getConfigLocation();
        if (oldConfigLocation == null && configLocation != null) {
            LOGGER.debug("Setting bundle ({}) configuration to {}", (Object)name2, (Object)configLocation);
            ctx.setConfigLocation(configLocation);
        } else if (oldConfigLocation != null && configLocation != null && !configLocation.equals(oldConfigLocation)) {
            LOGGER.warn("locateContext called with URI [{}], but existing LoggerContext has URI [{}]", (Object)configLocation, (Object)oldConfigLocation);
        }
        return ctx;
    }
}

