(ns {{name}}.core
  (:use [compojure.core]
        [ring.adapter.jetty :only [run-jetty]]
        [hiccup.core]
        [hiccup.middleware :only (wrap-base-url)])
  (:require [compojure.handler :as handler]
            [compojure.route :as route]
            [{{name}}.crossover.views.layout.application :as layout]))


(defroutes {{name}}
  (GET "/" [] (html (layout/layout "Hello World!")))
  (route/resources "/")
  (route/not-found "Not Found"))

(def ^:private ring-app*
  (-> #'{{name}}
    handler/site
    wrap-base-url))

(defn -main []
  (println "Starting jetty server...")
  (run-jetty #'ring-app* {:port 8080 :join? false}))
