goog.provide('fetch.core');
goog.require('cljs.core');
goog.require('goog.structs');
goog.require('goog.Uri.QueryData');
goog.require('goog.events');
goog.require('cljs.reader');
goog.require('fetch.util');
goog.require('clojure.string');
goog.require('goog.net.XhrIo');
fetch.core.__GT_method = (function __GT_method(m){
return clojure.string.upper_case.call(null,cljs.core.name.call(null,m));
});
fetch.core.parse_route = (function parse_route(route){
if(cljs.core.string_QMARK_.call(null,route))
{return cljs.core.PersistentVector.fromArray(["GET",route], true);
} else
{if(cljs.core.vector_QMARK_.call(null,route))
{var vec__16353__16354 = route;
var m__16355 = cljs.core.nth.call(null,vec__16353__16354,0,null);
var u__16356 = cljs.core.nth.call(null,vec__16353__16354,1,null);
return cljs.core.PersistentVector.fromArray([fetch.core.__GT_method.call(null,m__16355),u__16356], true);
} else
{if("\uFDD0'else")
{return cljs.core.PersistentVector.fromArray(["GET",route], true);
} else
{return null;
}
}
}
});
fetch.core.__GT_data = (function __GT_data(d){
var cur__16359 = fetch.util.clj__GT_js.call(null,d);
var query__16360 = goog.Uri.QueryData.createFromMap((new goog.structs.Map(cur__16359)));
return [cljs.core.str(query__16360)].join('');
});
fetch.core.__GT_callback = (function __GT_callback(callback){
if(cljs.core.truth_(callback))
{return (function (req){
var data__16362 = req.getResponseText();
return callback.call(null,data__16362);
});
} else
{return null;
}
});
/**
* @param {...*} var_args
*/
fetch.core.xhr = (function() { 
var xhr__delegate = function (route,content,callback,p__16363){
var vec__16374__16375 = p__16363;
var opts__16376 = cljs.core.nth.call(null,vec__16374__16375,0,null);
var req__16378 = (new goog.net.XhrIo());
var vec__16377__16379 = fetch.core.parse_route.call(null,route);
var method__16380 = cljs.core.nth.call(null,vec__16377__16379,0,null);
var uri__16381 = cljs.core.nth.call(null,vec__16377__16379,1,null);
var data__16382 = fetch.core.__GT_data.call(null,content);
var callback__16383 = fetch.core.__GT_callback.call(null,callback);
if(cljs.core.truth_(callback__16383))
{goog.events.listen(req__16378,goog.net.EventType.COMPLETE,(function (){
return callback__16383.call(null,req__16378);
}));
} else
{}
return req__16378.send(uri__16381,method__16380,data__16382,(cljs.core.truth_(opts__16376)?fetch.util.clj__GT_js.call(null,opts__16376):null));
};
var xhr = function (route,content,callback,var_args){
var p__16363 = null;
if (goog.isDef(var_args)) {
  p__16363 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return xhr__delegate.call(this, route, content, callback, p__16363);
};
xhr.cljs$lang$maxFixedArity = 3;
xhr.cljs$lang$applyTo = (function (arglist__16384){
var route = cljs.core.first(arglist__16384);
var content = cljs.core.first(cljs.core.next(arglist__16384));
var callback = cljs.core.first(cljs.core.next(cljs.core.next(arglist__16384)));
var p__16363 = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__16384)));
return xhr__delegate(route, content, callback, p__16363);
});
xhr.cljs$lang$arity$variadic = xhr__delegate;
return xhr;
})()
;
