goog.provide('crate.binding');
goog.require('cljs.core');
goog.require('clojure.set');

/**
* @constructor
*/
crate.binding.SubAtom = (function (atm,path,prevhash,watches,key){
this.atm = atm;
this.path = path;
this.prevhash = prevhash;
this.watches = watches;
this.key = key;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2153807872;
})
crate.binding.SubAtom.cljs$lang$type = true;
crate.binding.SubAtom.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"crate.binding/SubAtom");
});
crate.binding.SubAtom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this__15907 = this;
return goog.getUid(this$);
});
crate.binding.SubAtom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var this__15908 = this;
var G__15909__15910 = cljs.core.seq.call(null,this__15908.watches);
if(G__15909__15910)
{var G__15912__15914 = cljs.core.first.call(null,G__15909__15910);
var vec__15913__15915 = G__15912__15914;
var key__15916 = cljs.core.nth.call(null,vec__15913__15915,0,null);
var f__15917 = cljs.core.nth.call(null,vec__15913__15915,1,null);
var G__15909__15918 = G__15909__15910;
var G__15912__15919 = G__15912__15914;
var G__15909__15920 = G__15909__15918;
while(true){
var vec__15921__15922 = G__15912__15919;
var key__15923 = cljs.core.nth.call(null,vec__15921__15922,0,null);
var f__15924 = cljs.core.nth.call(null,vec__15921__15922,1,null);
var G__15909__15925 = G__15909__15920;
f__15924.call(null,key__15923,this$,oldval,newval);
var temp__3974__auto____15926 = cljs.core.next.call(null,G__15909__15925);
if(temp__3974__auto____15926)
{var G__15909__15927 = temp__3974__auto____15926;
{
var G__15933 = cljs.core.first.call(null,G__15909__15927);
var G__15934 = G__15909__15927;
G__15912__15919 = G__15933;
G__15909__15920 = G__15934;
continue;
}
} else
{return null;
}
break;
}
} else
{return null;
}
});
crate.binding.SubAtom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var this__15928 = this;
if(cljs.core.truth_(f))
{return this$.watches = cljs.core.assoc.call(null,this__15928.watches,key,f);
} else
{return null;
}
});
crate.binding.SubAtom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var this__15929 = this;
return this$.watches = cljs.core.dissoc.call(null,this__15929.watches,key);
});
crate.binding.SubAtom.prototype.crate$binding$IPrintWithWriter$ = true;
crate.binding.SubAtom.prototype.crate$binding$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){
var this__15930 = this;
return crate.binding._write.call(null,writer,[cljs.core.str("#<SubAtom: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,this__15930.atm),this__15930.path))),cljs.core.str(">")].join(''));
});
crate.binding.SubAtom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var this__15931 = this;
return cljs.core.get_in.call(null,cljs.core.deref.call(null,this__15931.atm),this__15931.path);
});
crate.binding.SubAtom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var this__15932 = this;
return (o === other);
});
crate.binding.SubAtom;
crate.binding.subatom = (function subatom(atm,path){
var path__15948 = ((cljs.core.coll_QMARK_.call(null,path))?path:cljs.core.PersistentVector.fromArray([path], true));
var vec__15947__15949 = ((cljs.core.instance_QMARK_.call(null,crate.binding.SubAtom,atm))?cljs.core.PersistentVector.fromArray([atm.atm,cljs.core.concat.call(null,atm.path,path__15948)], true):cljs.core.PersistentVector.fromArray([atm,path__15948], true));
var atm__15950 = cljs.core.nth.call(null,vec__15947__15949,0,null);
var path__15951 = cljs.core.nth.call(null,vec__15947__15949,1,null);
var k__15952 = cljs.core.gensym.call(null,"subatom");
var sa__15953 = (new crate.binding.SubAtom(atm__15950,path__15951,cljs.core.hash.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,atm__15950),path__15951)),null,k__15952));
cljs.core.add_watch.call(null,atm__15950,k__15952,(function (_15954,_,ov,nv){
var latest__15955 = cljs.core.get_in.call(null,nv,path__15951);
var prev__15956 = cljs.core.get_in.call(null,ov,path__15951);
var latest_hash__15957 = cljs.core.hash.call(null,latest__15955);
if((function (){var and__3822__auto____15958 = cljs.core.not_EQ_.call(null,sa__15953.prevhash,latest_hash__15957);
if(and__3822__auto____15958)
{return cljs.core.not_EQ_.call(null,prev__15956,latest__15955);
} else
{return and__3822__auto____15958;
}
})())
{sa__15953.prevhash = latest_hash__15957;
return cljs.core._notify_watches.call(null,sa__15953,cljs.core.get_in.call(null,ov,path__15951),latest__15955);
} else
{return null;
}
}));
return sa__15953;
});
/**
* Sets the value of atom to newval without regard for the
* current value. Returns newval.
*/
crate.binding.sub_reset_BANG_ = (function sub_reset_BANG_(sa,new_value){
cljs.core.swap_BANG_.call(null,sa.atm,cljs.core.assoc_in,sa.path,new_value);
return new_value;
});
/**
* Atomically swaps the value of atom to be:
* (apply f current-value-of-atom args). Note that f may be called
* multiple times, and thus should be free of side effects.  Returns
* the value that was swapped in.
* @param {...*} var_args
*/
crate.binding.sub_swap_BANG_ = (function() {
var sub_swap_BANG_ = null;
var sub_swap_BANG___2 = (function (sa,f){
return crate.binding.sub_reset_BANG_.call(null,sa,f.call(null,cljs.core.deref.call(null,sa)));
});
var sub_swap_BANG___3 = (function (sa,f,x){
return crate.binding.sub_reset_BANG_.call(null,sa,f.call(null,cljs.core.deref.call(null,sa),x));
});
var sub_swap_BANG___4 = (function (sa,f,x,y){
return crate.binding.sub_reset_BANG_.call(null,sa,f.call(null,cljs.core.deref.call(null,sa),x,y));
});
var sub_swap_BANG___5 = (function (sa,f,x,y,z){
return crate.binding.sub_reset_BANG_.call(null,sa,f.call(null,cljs.core.deref.call(null,sa),x,y,z));
});
var sub_swap_BANG___6 = (function() { 
var G__15959__delegate = function (sa,f,x,y,z,more){
return crate.binding.sub_reset_BANG_.call(null,sa,cljs.core.apply.call(null,f,cljs.core.deref.call(null,sa),x,y,z,more));
};
var G__15959 = function (sa,f,x,y,z,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5),0);
} 
return G__15959__delegate.call(this, sa, f, x, y, z, more);
};
G__15959.cljs$lang$maxFixedArity = 5;
G__15959.cljs$lang$applyTo = (function (arglist__15960){
var sa = cljs.core.first(arglist__15960);
var f = cljs.core.first(cljs.core.next(arglist__15960));
var x = cljs.core.first(cljs.core.next(cljs.core.next(arglist__15960)));
var y = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__15960))));
var z = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__15960)))));
var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__15960)))));
return G__15959__delegate(sa, f, x, y, z, more);
});
G__15959.cljs$lang$arity$variadic = G__15959__delegate;
return G__15959;
})()
;
sub_swap_BANG_ = function(sa,f,x,y,z,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return sub_swap_BANG___2.call(this,sa,f);
case 3:
return sub_swap_BANG___3.call(this,sa,f,x);
case 4:
return sub_swap_BANG___4.call(this,sa,f,x,y);
case 5:
return sub_swap_BANG___5.call(this,sa,f,x,y,z);
default:
return sub_swap_BANG___6.cljs$lang$arity$variadic(sa,f,x,y,z, cljs.core.array_seq(arguments, 5));
}
throw('Invalid arity: ' + arguments.length);
};
sub_swap_BANG_.cljs$lang$maxFixedArity = 5;
sub_swap_BANG_.cljs$lang$applyTo = sub_swap_BANG___6.cljs$lang$applyTo;
sub_swap_BANG_.cljs$lang$arity$2 = sub_swap_BANG___2;
sub_swap_BANG_.cljs$lang$arity$3 = sub_swap_BANG___3;
sub_swap_BANG_.cljs$lang$arity$4 = sub_swap_BANG___4;
sub_swap_BANG_.cljs$lang$arity$5 = sub_swap_BANG___5;
sub_swap_BANG_.cljs$lang$arity$variadic = sub_swap_BANG___6.cljs$lang$arity$variadic;
return sub_swap_BANG_;
})()
;
crate.binding.sub_destroy_BANG_ = (function sub_destroy_BANG_(sa){
cljs.core.remove_watch.call(null,sa.atm,sa.key);
sa.watches = null;
return sa.atm = null;
});
crate.binding.notify = (function notify(w,o,v){
return cljs.core._notify_watches.call(null,w,o,v);
});
crate.binding.bindable_coll = {};
crate.binding.bindable = {};
crate.binding._value = (function _value(this$){
if((function (){var and__3822__auto____15965 = this$;
if(and__3822__auto____15965)
{return this$.crate$binding$bindable$_value$arity$1;
} else
{return and__3822__auto____15965;
}
})())
{return this$.crate$binding$bindable$_value$arity$1(this$);
} else
{var x__4885__auto____15966 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____15967 = (crate.binding._value[goog.typeOf(x__4885__auto____15966)]);
if(or__3824__auto____15967)
{return or__3824__auto____15967;
} else
{var or__3824__auto____15968 = (crate.binding._value["_"]);
if(or__3824__auto____15968)
{return or__3824__auto____15968;
} else
{throw cljs.core.missing_protocol.call(null,"bindable.-value",this$);
}
}
})().call(null,this$);
}
});
crate.binding._on_change = (function _on_change(this$,func){
if((function (){var and__3822__auto____15973 = this$;
if(and__3822__auto____15973)
{return this$.crate$binding$bindable$_on_change$arity$2;
} else
{return and__3822__auto____15973;
}
})())
{return this$.crate$binding$bindable$_on_change$arity$2(this$,func);
} else
{var x__4885__auto____15974 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____15975 = (crate.binding._on_change[goog.typeOf(x__4885__auto____15974)]);
if(or__3824__auto____15975)
{return or__3824__auto____15975;
} else
{var or__3824__auto____15976 = (crate.binding._on_change["_"]);
if(or__3824__auto____15976)
{return or__3824__auto____15976;
} else
{throw cljs.core.missing_protocol.call(null,"bindable.-on-change",this$);
}
}
})().call(null,this$,func);
}
});

/**
* @constructor
*/
crate.binding.atom_binding = (function (atm,value_func){
this.atm = atm;
this.value_func = value_func;
})
crate.binding.atom_binding.cljs$lang$type = true;
crate.binding.atom_binding.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"crate.binding/atom-binding");
});
crate.binding.atom_binding.prototype.crate$binding$bindable$ = true;
crate.binding.atom_binding.prototype.crate$binding$bindable$_value$arity$1 = (function (this$){
var this__15977 = this;
return this__15977.value_func.call(null,cljs.core.deref.call(null,this__15977.atm));
});
crate.binding.atom_binding.prototype.crate$binding$bindable$_on_change$arity$2 = (function (this$,func){
var this__15978 = this;
return cljs.core.add_watch.call(null,this__15978.atm,cljs.core.gensym.call(null,"atom-binding"),(function (){
return func.call(null,crate.binding._value.call(null,this$));
}));
});
crate.binding.atom_binding;

/**
* @constructor
*/
crate.binding.notifier = (function (watches){
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2147483648;
})
crate.binding.notifier.cljs$lang$type = true;
crate.binding.notifier.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"crate.binding/notifier");
});
crate.binding.notifier.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var this__15979 = this;
var G__15980__15981 = cljs.core.seq.call(null,this__15979.watches);
if(G__15980__15981)
{var G__15983__15985 = cljs.core.first.call(null,G__15980__15981);
var vec__15984__15986 = G__15983__15985;
var key__15987 = cljs.core.nth.call(null,vec__15984__15986,0,null);
var f__15988 = cljs.core.nth.call(null,vec__15984__15986,1,null);
var G__15980__15989 = G__15980__15981;
var G__15983__15990 = G__15983__15985;
var G__15980__15991 = G__15980__15989;
while(true){
var vec__15992__15993 = G__15983__15990;
var key__15994 = cljs.core.nth.call(null,vec__15992__15993,0,null);
var f__15995 = cljs.core.nth.call(null,vec__15992__15993,1,null);
var G__15980__15996 = G__15980__15991;
f__15995.call(null,key__15994,this$,oldval,newval);
var temp__3974__auto____15997 = cljs.core.next.call(null,G__15980__15996);
if(temp__3974__auto____15997)
{var G__15980__15998 = temp__3974__auto____15997;
{
var G__16001 = cljs.core.first.call(null,G__15980__15998);
var G__16002 = G__15980__15998;
G__15983__15990 = G__16001;
G__15980__15991 = G__16002;
continue;
}
} else
{return null;
}
break;
}
} else
{return null;
}
});
crate.binding.notifier.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var this__15999 = this;
return this$.watches = cljs.core.assoc.call(null,this__15999.watches,key,f);
});
crate.binding.notifier.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var this__16000 = this;
return this$.watches = cljs.core.dissoc.call(null,this__16000.watches,key);
});
crate.binding.notifier;

/**
* @constructor
*/
crate.binding.bound_collection = (function (atm,notif,opts,stuff){
this.atm = atm;
this.notif = notif;
this.opts = opts;
this.stuff = stuff;
})
crate.binding.bound_collection.cljs$lang$type = true;
crate.binding.bound_collection.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"crate.binding/bound-collection");
});
crate.binding.bound_collection.prototype.crate$binding$bindable$ = true;
crate.binding.bound_collection.prototype.crate$binding$bindable$_value$arity$1 = (function (this$){
var this__16003 = this;
return cljs.core.map.call(null,"\uFDD0'elem",cljs.core.vals.call(null,this$.stuff));
});
crate.binding.bound_collection.prototype.crate$binding$bindable$_on_change$arity$2 = (function (this$,func){
var this__16004 = this;
return cljs.core.add_watch.call(null,this__16004.notif,cljs.core.gensym.call(null,"bound-coll"),(function (_16006,_16007,_,p__16005){
var vec__16008__16009 = p__16005;
var event__16010 = cljs.core.nth.call(null,vec__16008__16009,0,null);
var el__16011 = cljs.core.nth.call(null,vec__16008__16009,1,null);
var v__16012 = cljs.core.nth.call(null,vec__16008__16009,2,null);
return func.call(null,event__16010,el__16011,v__16012);
}));
});
crate.binding.bound_collection.prototype.crate$binding$bindable_coll$ = true;
crate.binding.bound_collection;
crate.binding.opt = (function opt(bc,k){
return bc.opts.call(null,k);
});
crate.binding.bc_add = (function bc_add(bc,path,key){
var sa__16015 = crate.binding.subatom.call(null,bc.atm,path);
var elem__16016 = crate.binding.opt.call(null,bc,"\uFDD0'as").call(null,sa__16015);
bc.stuff = cljs.core.assoc.call(null,bc.stuff,key,cljs.core.ObjMap.fromObject(["\uFDD0'elem","\uFDD0'subatom"],{"\uFDD0'elem":elem__16016,"\uFDD0'subatom":sa__16015}));
return crate.binding.notify.call(null,bc.notif,null,cljs.core.PersistentVector.fromArray(["\uFDD0'add",elem__16016,cljs.core.deref.call(null,sa__16015)], true));
});
crate.binding.bc_remove = (function bc_remove(bc,key){
var notif__16019 = bc.notif;
var prev__16020 = bc.stuff.call(null,key);
bc.stuff = cljs.core.dissoc.call(null,bc.stuff,key);
crate.binding.notify.call(null,bc.notif,null,cljs.core.PersistentVector.fromArray(["\uFDD0'remove",(new cljs.core.Keyword("\uFDD0'elem")).call(null,prev__16020),null], true));
return crate.binding.sub_destroy_BANG_.call(null,(new cljs.core.Keyword("\uFDD0'subatom")).call(null,prev__16020));
});
crate.binding.__GT_indexed = (function __GT_indexed(coll){
if(cljs.core.map_QMARK_.call(null,coll))
{return cljs.core.seq.call(null,coll);
} else
{if(cljs.core.set_QMARK_.call(null,coll))
{return cljs.core.map.call(null,cljs.core.juxt.call(null,cljs.core.identity,cljs.core.identity),coll);
} else
{if("\uFDD0'else")
{return cljs.core.map_indexed.call(null,cljs.core.vector,coll);
} else
{return null;
}
}
}
});
crate.binding.__GT_keyed = (function __GT_keyed(coll,keyfn){
return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,keyfn,crate.binding.__GT_indexed.call(null,coll)));
});
/**
* @param {...*} var_args
*/
crate.binding.__GT_path = (function() { 
var __GT_path__delegate = function (bc,segs){
return cljs.core.concat.call(null,(function (){var or__3824__auto____16022 = crate.binding.opt.call(null,bc,"\uFDD0'path");
if(cljs.core.truth_(or__3824__auto____16022))
{return or__3824__auto____16022;
} else
{return cljs.core.PersistentVector.EMPTY;
}
})(),segs);
};
var __GT_path = function (bc,var_args){
var segs = null;
if (goog.isDef(var_args)) {
  segs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);
} 
return __GT_path__delegate.call(this, bc, segs);
};
__GT_path.cljs$lang$maxFixedArity = 1;
__GT_path.cljs$lang$applyTo = (function (arglist__16023){
var bc = cljs.core.first(arglist__16023);
var segs = cljs.core.rest(arglist__16023);
return __GT_path__delegate(bc, segs);
});
__GT_path.cljs$lang$arity$variadic = __GT_path__delegate;
return __GT_path;
})()
;
crate.binding.bc_compare = (function bc_compare(bc,neue){
var prev__16041 = bc.stuff;
var pset__16042 = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.keys.call(null,prev__16041));
var nset__16043 = crate.binding.__GT_keyed.call(null,neue,crate.binding.opt.call(null,bc,"\uFDD0'keyfn"));
var added__16044 = cljs.core.into.call(null,cljs.core.sorted_set.call(null),clojure.set.difference.call(null,nset__16043,pset__16042));
var removed__16045 = cljs.core.into.call(null,cljs.core.sorted_set.call(null),clojure.set.difference.call(null,pset__16042,nset__16043));
var G__16046__16047 = cljs.core.seq.call(null,added__16044);
if(G__16046__16047)
{var a__16048 = cljs.core.first.call(null,G__16046__16047);
var G__16046__16049 = G__16046__16047;
while(true){
crate.binding.bc_add.call(null,bc,a__16048,a__16048);
var temp__3974__auto____16050 = cljs.core.next.call(null,G__16046__16049);
if(temp__3974__auto____16050)
{var G__16046__16051 = temp__3974__auto____16050;
{
var G__16058 = cljs.core.first.call(null,G__16046__16051);
var G__16059 = G__16046__16051;
a__16048 = G__16058;
G__16046__16049 = G__16059;
continue;
}
} else
{}
break;
}
} else
{}
var G__16052__16053 = cljs.core.seq.call(null,removed__16045);
if(G__16052__16053)
{var r__16054 = cljs.core.first.call(null,G__16052__16053);
var G__16052__16055 = G__16052__16053;
while(true){
crate.binding.bc_remove.call(null,bc,r__16054);
var temp__3974__auto____16056 = cljs.core.next.call(null,G__16052__16055);
if(temp__3974__auto____16056)
{var G__16052__16057 = temp__3974__auto____16056;
{
var G__16060 = cljs.core.first.call(null,G__16052__16057);
var G__16061 = G__16052__16057;
r__16054 = G__16060;
G__16052__16055 = G__16061;
continue;
}
} else
{return null;
}
break;
}
} else
{return null;
}
});
/**
* @param {...*} var_args
*/
crate.binding.bound_coll = (function() { 
var bound_coll__delegate = function (atm,p__16062){
var vec__16077__16078 = p__16062;
var path__16079 = cljs.core.nth.call(null,vec__16077__16078,0,null);
var opts__16080 = cljs.core.nth.call(null,vec__16077__16078,1,null);
var vec__16081__16082 = (cljs.core.truth_(opts__16080)?cljs.core.PersistentVector.fromArray([path__16079,opts__16080], true):cljs.core.PersistentVector.fromArray([null,path__16079], true));
var path__16083 = cljs.core.nth.call(null,vec__16081__16082,0,null);
var opts__16084 = cljs.core.nth.call(null,vec__16081__16082,1,null);
var atm__16085 = ((cljs.core.not.call(null,path__16083))?atm:crate.binding.subatom.call(null,atm,path__16083));
var opts__16086 = cljs.core.assoc.call(null,opts__16084,"\uFDD0'path",path__16083);
var opts__16087 = ((cljs.core.not.call(null,(new cljs.core.Keyword("\uFDD0'keyfn")).call(null,opts__16086)))?cljs.core.assoc.call(null,opts__16086,"\uFDD0'keyfn",cljs.core.first):cljs.core.assoc.call(null,opts__16086,"\uFDD0'keyfn",cljs.core.comp.call(null,(new cljs.core.Keyword("\uFDD0'keyfn")).call(null,opts__16086),cljs.core.second)));
var bc__16088 = (new crate.binding.bound_collection(atm__16085,(new crate.binding.notifier(null)),opts__16087,cljs.core.sorted_map.call(null)));
cljs.core.add_watch.call(null,atm__16085,cljs.core.gensym.call(null,"bound-coll"),(function (_16089,_16090,_,neue){
return crate.binding.bc_compare.call(null,bc__16088,neue);
}));
crate.binding.bc_compare.call(null,bc__16088,cljs.core.deref.call(null,atm__16085));
return bc__16088;
};
var bound_coll = function (atm,var_args){
var p__16062 = null;
if (goog.isDef(var_args)) {
  p__16062 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);
} 
return bound_coll__delegate.call(this, atm, p__16062);
};
bound_coll.cljs$lang$maxFixedArity = 1;
bound_coll.cljs$lang$applyTo = (function (arglist__16091){
var atm = cljs.core.first(arglist__16091);
var p__16062 = cljs.core.rest(arglist__16091);
return bound_coll__delegate(atm, p__16062);
});
bound_coll.cljs$lang$arity$variadic = bound_coll__delegate;
return bound_coll;
})()
;
/**
* @param {...*} var_args
*/
crate.binding.map_bound = (function() { 
var map_bound__delegate = function (as,atm,p__16092){
var vec__16102__16103 = p__16092;
var opts__16104 = cljs.core.nth.call(null,vec__16102__16103,0,null);
var opts__16105 = cljs.core.assoc.call(null,opts__16104,"\uFDD0'as",as);
var atm__16106 = ((cljs.core.not.call(null,(new cljs.core.Keyword("\uFDD0'path")).call(null,opts__16105)))?atm:crate.binding.subatom.call(null,atm,(new cljs.core.Keyword("\uFDD0'path")).call(null,opts__16105)));
var opts__16107 = ((cljs.core.not.call(null,(new cljs.core.Keyword("\uFDD0'keyfn")).call(null,opts__16105)))?cljs.core.assoc.call(null,opts__16105,"\uFDD0'keyfn",cljs.core.first):cljs.core.assoc.call(null,opts__16105,"\uFDD0'keyfn",cljs.core.comp.call(null,(new cljs.core.Keyword("\uFDD0'keyfn")).call(null,opts__16105),cljs.core.second)));
var bc__16108 = (new crate.binding.bound_collection(atm__16106,(new crate.binding.notifier(null)),opts__16107,cljs.core.sorted_map.call(null)));
cljs.core.add_watch.call(null,atm__16106,cljs.core.gensym.call(null,"bound-coll"),(function (_16109,_16110,_,neue){
return crate.binding.bc_compare.call(null,bc__16108,neue);
}));
crate.binding.bc_compare.call(null,bc__16108,cljs.core.deref.call(null,atm__16106));
return bc__16108;
};
var map_bound = function (as,atm,var_args){
var p__16092 = null;
if (goog.isDef(var_args)) {
  p__16092 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return map_bound__delegate.call(this, as, atm, p__16092);
};
map_bound.cljs$lang$maxFixedArity = 2;
map_bound.cljs$lang$applyTo = (function (arglist__16111){
var as = cljs.core.first(arglist__16111);
var atm = cljs.core.first(cljs.core.next(arglist__16111));
var p__16092 = cljs.core.rest(cljs.core.next(arglist__16111));
return map_bound__delegate(as, atm, p__16092);
});
map_bound.cljs$lang$arity$variadic = map_bound__delegate;
return map_bound;
})()
;
crate.binding.binding_QMARK_ = (function binding_QMARK_(b){
var G__16115__16116 = b;
if(G__16115__16116)
{if(cljs.core.truth_((function (){var or__3824__auto____16117 = null;
if(cljs.core.truth_(or__3824__auto____16117))
{return or__3824__auto____16117;
} else
{return G__16115__16116.crate$binding$bindable$;
}
})()))
{return true;
} else
{if((!G__16115__16116.cljs$lang$protocol_mask$partition$))
{return cljs.core.type_satisfies_.call(null,crate.binding.bindable,G__16115__16116);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,crate.binding.bindable,G__16115__16116);
}
});
crate.binding.binding_coll_QMARK_ = (function binding_coll_QMARK_(b){
var G__16121__16122 = b;
if(G__16121__16122)
{if(cljs.core.truth_((function (){var or__3824__auto____16123 = null;
if(cljs.core.truth_(or__3824__auto____16123))
{return or__3824__auto____16123;
} else
{return G__16121__16122.crate$binding$bindable_coll$;
}
})()))
{return true;
} else
{if((!G__16121__16122.cljs$lang$protocol_mask$partition$))
{return cljs.core.type_satisfies_.call(null,crate.binding.bindable_coll,G__16121__16122);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,crate.binding.bindable_coll,G__16121__16122);
}
});
crate.binding.deref_QMARK_ = (function deref_QMARK_(atm){
var G__16127__16128 = atm;
if(G__16127__16128)
{if((function (){var or__3824__auto____16129 = (G__16127__16128.cljs$lang$protocol_mask$partition0$ & 32768);
if(or__3824__auto____16129)
{return or__3824__auto____16129;
} else
{return G__16127__16128.cljs$core$IDeref$;
}
})())
{return true;
} else
{if((!G__16127__16128.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IDeref,G__16127__16128);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IDeref,G__16127__16128);
}
});
crate.binding.value = (function value(b){
return crate.binding._value.call(null,b);
});
crate.binding.index = (function index(sub_atom){
return cljs.core.last.call(null,sub_atom.path);
});
crate.binding.on_change = (function on_change(b,func){
return crate.binding._on_change.call(null,b,func);
});
/**
* @param {...*} var_args
*/
crate.binding.bound = (function() { 
var bound__delegate = function (atm,p__16130){
var vec__16136__16137 = p__16130;
var func__16138 = cljs.core.nth.call(null,vec__16136__16137,0,null);
var func__16140 = (function (){var or__3824__auto____16139 = func__16138;
if(cljs.core.truth_(or__3824__auto____16139))
{return or__3824__auto____16139;
} else
{return cljs.core.identity;
}
})();
return (new crate.binding.atom_binding(atm,func__16140));
};
var bound = function (atm,var_args){
var p__16130 = null;
if (goog.isDef(var_args)) {
  p__16130 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);
} 
return bound__delegate.call(this, atm, p__16130);
};
bound.cljs$lang$maxFixedArity = 1;
bound.cljs$lang$applyTo = (function (arglist__16141){
var atm = cljs.core.first(arglist__16141);
var p__16130 = cljs.core.rest(arglist__16141);
return bound__delegate(atm, p__16130);
});
bound.cljs$lang$arity$variadic = bound__delegate;
return bound;
})()
;
