goog.provide('cljs.reader');
goog.require('cljs.core');
goog.require('goog.string');
cljs.reader.PushbackReader = {};
cljs.reader.read_char = (function read_char(reader){
if((function (){var and__3822__auto____16429 = reader;
if(and__3822__auto____16429)
{return reader.cljs$reader$PushbackReader$read_char$arity$1;
} else
{return and__3822__auto____16429;
}
})())
{return reader.cljs$reader$PushbackReader$read_char$arity$1(reader);
} else
{var x__4885__auto____16430 = (((reader == null))?null:reader);
return (function (){var or__3824__auto____16431 = (cljs.reader.read_char[goog.typeOf(x__4885__auto____16430)]);
if(or__3824__auto____16431)
{return or__3824__auto____16431;
} else
{var or__3824__auto____16432 = (cljs.reader.read_char["_"]);
if(or__3824__auto____16432)
{return or__3824__auto____16432;
} else
{throw cljs.core.missing_protocol.call(null,"PushbackReader.read-char",reader);
}
}
})().call(null,reader);
}
});
cljs.reader.unread = (function unread(reader,ch){
if((function (){var and__3822__auto____16437 = reader;
if(and__3822__auto____16437)
{return reader.cljs$reader$PushbackReader$unread$arity$2;
} else
{return and__3822__auto____16437;
}
})())
{return reader.cljs$reader$PushbackReader$unread$arity$2(reader,ch);
} else
{var x__4885__auto____16438 = (((reader == null))?null:reader);
return (function (){var or__3824__auto____16439 = (cljs.reader.unread[goog.typeOf(x__4885__auto____16438)]);
if(or__3824__auto____16439)
{return or__3824__auto____16439;
} else
{var or__3824__auto____16440 = (cljs.reader.unread["_"]);
if(or__3824__auto____16440)
{return or__3824__auto____16440;
} else
{throw cljs.core.missing_protocol.call(null,"PushbackReader.unread",reader);
}
}
})().call(null,reader,ch);
}
});

/**
* @constructor
*/
cljs.reader.StringPushbackReader = (function (s,index_atom,buffer_atom){
this.s = s;
this.index_atom = index_atom;
this.buffer_atom = buffer_atom;
})
cljs.reader.StringPushbackReader.cljs$lang$type = true;
cljs.reader.StringPushbackReader.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.reader/StringPushbackReader");
});
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$ = true;
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$read_char$arity$1 = (function (reader){
var this__16441 = this;
if(cljs.core.empty_QMARK_.call(null,cljs.core.deref.call(null,this__16441.buffer_atom)))
{var idx__16442 = cljs.core.deref.call(null,this__16441.index_atom);
cljs.core.swap_BANG_.call(null,this__16441.index_atom,cljs.core.inc);
return (this__16441.s[idx__16442]);
} else
{var buf__16443 = cljs.core.deref.call(null,this__16441.buffer_atom);
cljs.core.swap_BANG_.call(null,this__16441.buffer_atom,cljs.core.rest);
return cljs.core.first.call(null,buf__16443);
}
});
cljs.reader.StringPushbackReader.prototype.cljs$reader$PushbackReader$unread$arity$2 = (function (reader,ch){
var this__16444 = this;
return cljs.core.swap_BANG_.call(null,this__16444.buffer_atom,(function (p1__16424_SHARP_){
return cljs.core.cons.call(null,ch,p1__16424_SHARP_);
}));
});
cljs.reader.StringPushbackReader;
cljs.reader.push_back_reader = (function push_back_reader(s){
return (new cljs.reader.StringPushbackReader(s,cljs.core.atom.call(null,0),cljs.core.atom.call(null,null)));
});
/**
* Checks whether a given character is whitespace
*/
cljs.reader.whitespace_QMARK_ = (function whitespace_QMARK_(ch){
var or__3824__auto____16446 = goog.string.isBreakingWhitespace(ch);
if(cljs.core.truth_(or__3824__auto____16446))
{return or__3824__auto____16446;
} else
{return ("," === ch);
}
});
/**
* Checks whether a given character is numeric
*/
cljs.reader.numeric_QMARK_ = (function numeric_QMARK_(ch){
return goog.string.isNumeric(ch);
});
/**
* Checks whether the character begins a comment.
*/
cljs.reader.comment_prefix_QMARK_ = (function comment_prefix_QMARK_(ch){
return (";" === ch);
});
/**
* Checks whether the reader is at the start of a number literal
*/
cljs.reader.number_literal_QMARK_ = (function number_literal_QMARK_(reader,initch){
var or__3824__auto____16451 = cljs.reader.numeric_QMARK_.call(null,initch);
if(or__3824__auto____16451)
{return or__3824__auto____16451;
} else
{var and__3822__auto____16453 = (function (){var or__3824__auto____16452 = ("+" === initch);
if(or__3824__auto____16452)
{return or__3824__auto____16452;
} else
{return ("-" === initch);
}
})();
if(cljs.core.truth_(and__3822__auto____16453))
{return cljs.reader.numeric_QMARK_.call(null,(function (){var next_ch__16454 = cljs.reader.read_char.call(null,reader);
cljs.reader.unread.call(null,reader,next_ch__16454);
return next_ch__16454;
})());
} else
{return and__3822__auto____16453;
}
}
});
/**
* @param {...*} var_args
*/
cljs.reader.reader_error = (function() { 
var reader_error__delegate = function (rdr,msg){
throw (new Error(cljs.core.apply.call(null,cljs.core.str,msg)));
};
var reader_error = function (rdr,var_args){
var msg = null;
if (goog.isDef(var_args)) {
  msg = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);
} 
return reader_error__delegate.call(this, rdr, msg);
};
reader_error.cljs$lang$maxFixedArity = 1;
reader_error.cljs$lang$applyTo = (function (arglist__16455){
var rdr = cljs.core.first(arglist__16455);
var msg = cljs.core.rest(arglist__16455);
return reader_error__delegate(rdr, msg);
});
reader_error.cljs$lang$arity$variadic = reader_error__delegate;
return reader_error;
})()
;
cljs.reader.macro_terminating_QMARK_ = (function macro_terminating_QMARK_(ch){
var and__3822__auto____16459 = !((ch === "#"));
if(and__3822__auto____16459)
{var and__3822__auto____16460 = !((ch === "'"));
if(and__3822__auto____16460)
{var and__3822__auto____16461 = !((ch === ":"));
if(and__3822__auto____16461)
{return cljs.reader.macros.call(null,ch);
} else
{return and__3822__auto____16461;
}
} else
{return and__3822__auto____16460;
}
} else
{return and__3822__auto____16459;
}
});
cljs.reader.read_token = (function read_token(rdr,initch){
var sb__16466 = (new goog.string.StringBuffer(initch));
var ch__16467 = cljs.reader.read_char.call(null,rdr);
while(true){
if((function (){var or__3824__auto____16468 = (ch__16467 == null);
if(or__3824__auto____16468)
{return or__3824__auto____16468;
} else
{var or__3824__auto____16469 = cljs.reader.whitespace_QMARK_.call(null,ch__16467);
if(or__3824__auto____16469)
{return or__3824__auto____16469;
} else
{return cljs.reader.macro_terminating_QMARK_.call(null,ch__16467);
}
}
})())
{cljs.reader.unread.call(null,rdr,ch__16467);
return sb__16466.toString();
} else
{{
var G__16470 = (function (){sb__16466.append(ch__16467);
return sb__16466;
})();
var G__16471 = cljs.reader.read_char.call(null,rdr);
sb__16466 = G__16470;
ch__16467 = G__16471;
continue;
}
}
break;
}
});
/**
* Advances the reader to the end of a line. Returns the reader
*/
cljs.reader.skip_line = (function skip_line(reader,_){
while(true){
var ch__16475 = cljs.reader.read_char.call(null,reader);
if((function (){var or__3824__auto____16476 = (ch__16475 === "n");
if(or__3824__auto____16476)
{return or__3824__auto____16476;
} else
{var or__3824__auto____16477 = (ch__16475 === "r");
if(or__3824__auto____16477)
{return or__3824__auto____16477;
} else
{return (ch__16475 == null);
}
}
})())
{return reader;
} else
{{
continue;
}
}
break;
}
});
cljs.reader.int_pattern = cljs.core.re_pattern.call(null,"([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?");
cljs.reader.ratio_pattern = cljs.core.re_pattern.call(null,"([-+]?[0-9]+)/([0-9]+)");
cljs.reader.float_pattern = cljs.core.re_pattern.call(null,"([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?");
cljs.reader.symbol_pattern = cljs.core.re_pattern.call(null,"[:]?([^0-9/].*/)?([^0-9/][^/]*)");
cljs.reader.re_find_STAR_ = (function re_find_STAR_(re,s){
var matches__16479 = re.exec(s);
if((matches__16479 == null))
{return null;
} else
{if((matches__16479.length === 1))
{return (matches__16479[0]);
} else
{return matches__16479;
}
}
});
cljs.reader.match_int = (function match_int(s){
var groups__16487 = cljs.reader.re_find_STAR_.call(null,cljs.reader.int_pattern,s);
var group3__16488 = (groups__16487[2]);
if(!((function (){var or__3824__auto____16489 = (group3__16488 == null);
if(or__3824__auto____16489)
{return or__3824__auto____16489;
} else
{return (group3__16488.length < 1);
}
})()))
{return 0;
} else
{var negate__16490 = ((("-" === (groups__16487[1])))?-1:1);
var a__16491 = (cljs.core.truth_((groups__16487[3]))?[(groups__16487[3]),10]:(cljs.core.truth_((groups__16487[4]))?[(groups__16487[4]),16]:(cljs.core.truth_((groups__16487[5]))?[(groups__16487[5]),8]:(cljs.core.truth_((groups__16487[7]))?[(groups__16487[7]),parseInt((groups__16487[7]))]:(("\uFDD0'default")?[null,null]:null)))));
var n__16492 = (a__16491[0]);
var radix__16493 = (a__16491[1]);
if((n__16492 == null))
{return null;
} else
{return (negate__16490 * parseInt(n__16492,radix__16493));
}
}
});
cljs.reader.match_ratio = (function match_ratio(s){
var groups__16497 = cljs.reader.re_find_STAR_.call(null,cljs.reader.ratio_pattern,s);
var numinator__16498 = (groups__16497[1]);
var denominator__16499 = (groups__16497[2]);
return (parseInt(numinator__16498) / parseInt(denominator__16499));
});
cljs.reader.match_float = (function match_float(s){
return parseFloat(s);
});
cljs.reader.re_matches_STAR_ = (function re_matches_STAR_(re,s){
var matches__16502 = re.exec(s);
if((function (){var and__3822__auto____16503 = !((matches__16502 == null));
if(and__3822__auto____16503)
{return ((matches__16502[0]) === s);
} else
{return and__3822__auto____16503;
}
})())
{if((matches__16502.length === 1))
{return (matches__16502[0]);
} else
{return matches__16502;
}
} else
{return null;
}
});
cljs.reader.match_number = (function match_number(s){
if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null,cljs.reader.int_pattern,s)))
{return cljs.reader.match_int.call(null,s);
} else
{if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null,cljs.reader.ratio_pattern,s)))
{return cljs.reader.match_ratio.call(null,s);
} else
{if(cljs.core.truth_(cljs.reader.re_matches_STAR_.call(null,cljs.reader.float_pattern,s)))
{return cljs.reader.match_float.call(null,s);
} else
{return null;
}
}
}
});
cljs.reader.escape_char_map = (function escape_char_map(c){
if((c === "t"))
{return "\t";
} else
{if((c === "r"))
{return "\r";
} else
{if((c === "n"))
{return "\n";
} else
{if((c === "\\"))
{return "\\";
} else
{if((c === "\""))
{return "\"";
} else
{if((c === "b"))
{return "\b";
} else
{if((c === "f"))
{return "\f";
} else
{if("\uFDD0'else")
{return null;
} else
{return null;
}
}
}
}
}
}
}
}
});
cljs.reader.read_2_chars = (function read_2_chars(reader){
return (new goog.string.StringBuffer(cljs.reader.read_char.call(null,reader),cljs.reader.read_char.call(null,reader))).toString();
});
cljs.reader.read_4_chars = (function read_4_chars(reader){
return (new goog.string.StringBuffer(cljs.reader.read_char.call(null,reader),cljs.reader.read_char.call(null,reader),cljs.reader.read_char.call(null,reader),cljs.reader.read_char.call(null,reader))).toString();
});
cljs.reader.unicode_2_pattern = cljs.core.re_pattern.call(null,"[0-9A-Fa-f]{2}");
cljs.reader.unicode_4_pattern = cljs.core.re_pattern.call(null,"[0-9A-Fa-f]{4}");
cljs.reader.validate_unicode_escape = (function validate_unicode_escape(unicode_pattern,reader,escape_char,unicode_str){
if(cljs.core.truth_(cljs.core.re_matches.call(null,unicode_pattern,unicode_str)))
{return unicode_str;
} else
{return cljs.reader.reader_error.call(null,reader,"Unexpected unicode escape \\",escape_char,unicode_str);
}
});
cljs.reader.make_unicode_char = (function make_unicode_char(code_str){
var code__16505 = parseInt(code_str,16);
return String.fromCharCode(code__16505);
});
cljs.reader.escape_char = (function escape_char(buffer,reader){
var ch__16508 = cljs.reader.read_char.call(null,reader);
var mapresult__16509 = cljs.reader.escape_char_map.call(null,ch__16508);
if(cljs.core.truth_(mapresult__16509))
{return mapresult__16509;
} else
{if((ch__16508 === "x"))
{return cljs.reader.make_unicode_char.call(null,cljs.reader.validate_unicode_escape.call(null,cljs.reader.unicode_2_pattern,reader,ch__16508,cljs.reader.read_2_chars.call(null,reader)));
} else
{if((ch__16508 === "u"))
{return cljs.reader.make_unicode_char.call(null,cljs.reader.validate_unicode_escape.call(null,cljs.reader.unicode_4_pattern,reader,ch__16508,cljs.reader.read_4_chars.call(null,reader)));
} else
{if(cljs.reader.numeric_QMARK_.call(null,ch__16508))
{return String.fromCharCode(ch__16508);
} else
{if("\uFDD0'else")
{return cljs.reader.reader_error.call(null,reader,"Unexpected unicode escape \\",ch__16508);
} else
{return null;
}
}
}
}
}
});
/**
* Read until first character that doesn't match pred, returning
* char.
*/
cljs.reader.read_past = (function read_past(pred,rdr){
var ch__16511 = cljs.reader.read_char.call(null,rdr);
while(true){
if(cljs.core.truth_(pred.call(null,ch__16511)))
{{
var G__16512 = cljs.reader.read_char.call(null,rdr);
ch__16511 = G__16512;
continue;
}
} else
{return ch__16511;
}
break;
}
});
cljs.reader.read_delimited_list = (function read_delimited_list(delim,rdr,recursive_QMARK_){
var a__16519 = cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY);
while(true){
var ch__16520 = cljs.reader.read_past.call(null,cljs.reader.whitespace_QMARK_,rdr);
if(cljs.core.truth_(ch__16520))
{} else
{cljs.reader.reader_error.call(null,rdr,"EOF");
}
if((delim === ch__16520))
{return cljs.core.persistent_BANG_.call(null,a__16519);
} else
{var temp__3971__auto____16521 = cljs.reader.macros.call(null,ch__16520);
if(cljs.core.truth_(temp__3971__auto____16521))
{var macrofn__16522 = temp__3971__auto____16521;
var mret__16523 = macrofn__16522.call(null,rdr,ch__16520);
{
var G__16525 = (((mret__16523 === rdr))?a__16519:cljs.core.conj_BANG_.call(null,a__16519,mret__16523));
a__16519 = G__16525;
continue;
}
} else
{cljs.reader.unread.call(null,rdr,ch__16520);
var o__16524 = cljs.reader.read.call(null,rdr,true,null,recursive_QMARK_);
{
var G__16526 = (((o__16524 === rdr))?a__16519:cljs.core.conj_BANG_.call(null,a__16519,o__16524));
a__16519 = G__16526;
continue;
}
}
}
break;
}
});
cljs.reader.not_implemented = (function not_implemented(rdr,ch){
return cljs.reader.reader_error.call(null,rdr,"Reader for ",ch," not implemented yet");
});
cljs.reader.read_dispatch = (function read_dispatch(rdr,_){
var ch__16531 = cljs.reader.read_char.call(null,rdr);
var dm__16532 = cljs.reader.dispatch_macros.call(null,ch__16531);
if(cljs.core.truth_(dm__16532))
{return dm__16532.call(null,rdr,_);
} else
{var temp__3971__auto____16533 = cljs.reader.maybe_read_tagged_type.call(null,rdr,ch__16531);
if(cljs.core.truth_(temp__3971__auto____16533))
{var obj__16534 = temp__3971__auto____16533;
return obj__16534;
} else
{return cljs.reader.reader_error.call(null,rdr,"No dispatch macro for ",ch__16531);
}
}
});
cljs.reader.read_unmatched_delimiter = (function read_unmatched_delimiter(rdr,ch){
return cljs.reader.reader_error.call(null,rdr,"Unmached delimiter ",ch);
});
cljs.reader.read_list = (function read_list(rdr,_){
return cljs.core.apply.call(null,cljs.core.list,cljs.reader.read_delimited_list.call(null,")",rdr,true));
});
cljs.reader.read_comment = cljs.reader.skip_line;
cljs.reader.read_vector = (function read_vector(rdr,_){
return cljs.reader.read_delimited_list.call(null,"]",rdr,true);
});
cljs.reader.read_map = (function read_map(rdr,_){
var l__16536 = cljs.reader.read_delimited_list.call(null,"}",rdr,true);
if(cljs.core.odd_QMARK_.call(null,cljs.core.count.call(null,l__16536)))
{cljs.reader.reader_error.call(null,rdr,"Map literal must contain an even number of forms");
} else
{}
return cljs.core.apply.call(null,cljs.core.hash_map,l__16536);
});
cljs.reader.read_number = (function read_number(reader,initch){
var buffer__16543 = (new goog.string.StringBuffer(initch));
var ch__16544 = cljs.reader.read_char.call(null,reader);
while(true){
if(cljs.core.truth_((function (){var or__3824__auto____16545 = (ch__16544 == null);
if(or__3824__auto____16545)
{return or__3824__auto____16545;
} else
{var or__3824__auto____16546 = cljs.reader.whitespace_QMARK_.call(null,ch__16544);
if(or__3824__auto____16546)
{return or__3824__auto____16546;
} else
{return cljs.reader.macros.call(null,ch__16544);
}
}
})()))
{cljs.reader.unread.call(null,reader,ch__16544);
var s__16547 = buffer__16543.toString();
var or__3824__auto____16548 = cljs.reader.match_number.call(null,s__16547);
if(cljs.core.truth_(or__3824__auto____16548))
{return or__3824__auto____16548;
} else
{return cljs.reader.reader_error.call(null,reader,"Invalid number format [",s__16547,"]");
}
} else
{{
var G__16549 = (function (){buffer__16543.append(ch__16544);
return buffer__16543;
})();
var G__16550 = cljs.reader.read_char.call(null,reader);
buffer__16543 = G__16549;
ch__16544 = G__16550;
continue;
}
}
break;
}
});
cljs.reader.read_string_STAR_ = (function read_string_STAR_(reader,_){
var buffer__16553 = (new goog.string.StringBuffer());
var ch__16554 = cljs.reader.read_char.call(null,reader);
while(true){
if((ch__16554 == null))
{return cljs.reader.reader_error.call(null,reader,"EOF while reading string");
} else
{if(("\\" === ch__16554))
{{
var G__16555 = (function (){buffer__16553.append(cljs.reader.escape_char.call(null,buffer__16553,reader));
return buffer__16553;
})();
var G__16556 = cljs.reader.read_char.call(null,reader);
buffer__16553 = G__16555;
ch__16554 = G__16556;
continue;
}
} else
{if(("\"" === ch__16554))
{return buffer__16553.toString();
} else
{if("\uFDD0'default")
{{
var G__16557 = (function (){buffer__16553.append(ch__16554);
return buffer__16553;
})();
var G__16558 = cljs.reader.read_char.call(null,reader);
buffer__16553 = G__16557;
ch__16554 = G__16558;
continue;
}
} else
{return null;
}
}
}
}
break;
}
});
cljs.reader.special_symbols = (function special_symbols(t,not_found){
if((t === "nil"))
{return null;
} else
{if((t === "true"))
{return true;
} else
{if((t === "false"))
{return false;
} else
{if("\uFDD0'else")
{return not_found;
} else
{return null;
}
}
}
}
});
cljs.reader.read_symbol = (function read_symbol(reader,initch){
var token__16560 = cljs.reader.read_token.call(null,reader,initch);
if(cljs.core.truth_(goog.string.contains(token__16560,"/")))
{return cljs.core.symbol.call(null,cljs.core.subs.call(null,token__16560,0,token__16560.indexOf("/")),cljs.core.subs.call(null,token__16560,(token__16560.indexOf("/") + 1),token__16560.length));
} else
{return cljs.reader.special_symbols.call(null,token__16560,cljs.core.symbol.call(null,token__16560));
}
});
cljs.reader.read_keyword = (function read_keyword(reader,initch){
var token__16570 = cljs.reader.read_token.call(null,reader,cljs.reader.read_char.call(null,reader));
var a__16571 = cljs.reader.re_matches_STAR_.call(null,cljs.reader.symbol_pattern,token__16570);
var token__16572 = (a__16571[0]);
var ns__16573 = (a__16571[1]);
var name__16574 = (a__16571[2]);
if(cljs.core.truth_((function (){var or__3824__auto____16576 = (function (){var and__3822__auto____16575 = !((void 0 === ns__16573));
if(and__3822__auto____16575)
{return (ns__16573.substring((ns__16573.length - 2),ns__16573.length) === ":/");
} else
{return and__3822__auto____16575;
}
})();
if(cljs.core.truth_(or__3824__auto____16576))
{return or__3824__auto____16576;
} else
{var or__3824__auto____16577 = ((name__16574[(name__16574.length - 1)]) === ":");
if(or__3824__auto____16577)
{return or__3824__auto____16577;
} else
{return !((token__16572.indexOf("::",1) === -1));
}
}
})()))
{return cljs.reader.reader_error.call(null,reader,"Invalid token: ",token__16572);
} else
{if((function (){var and__3822__auto____16578 = !((ns__16573 == null));
if(and__3822__auto____16578)
{return (ns__16573.length > 0);
} else
{return and__3822__auto____16578;
}
})())
{return cljs.core.keyword.call(null,ns__16573.substring(0,ns__16573.indexOf("/")),name__16574);
} else
{return cljs.core.keyword.call(null,token__16572);
}
}
});
cljs.reader.desugar_meta = (function desugar_meta(f){
if(cljs.core.symbol_QMARK_.call(null,f))
{return cljs.core.ObjMap.fromObject(["\uFDD0'tag"],{"\uFDD0'tag":f});
} else
{if(cljs.core.string_QMARK_.call(null,f))
{return cljs.core.ObjMap.fromObject(["\uFDD0'tag"],{"\uFDD0'tag":f});
} else
{if(cljs.core.keyword_QMARK_.call(null,f))
{return cljs.core.PersistentArrayMap.fromArrays([f],[true]);
} else
{if("\uFDD0'else")
{return f;
} else
{return null;
}
}
}
}
});
cljs.reader.wrapping_reader = (function wrapping_reader(sym){
return (function (rdr,_){
return cljs.core.list.call(null,sym,cljs.reader.read.call(null,rdr,true,null,true));
});
});
cljs.reader.throwing_reader = (function throwing_reader(msg){
return (function (rdr,_){
return cljs.reader.reader_error.call(null,rdr,msg);
});
});
cljs.reader.read_meta = (function read_meta(rdr,_){
var m__16584 = cljs.reader.desugar_meta.call(null,cljs.reader.read.call(null,rdr,true,null,true));
if(cljs.core.map_QMARK_.call(null,m__16584))
{} else
{cljs.reader.reader_error.call(null,rdr,"Metadata must be Symbol,Keyword,String or Map");
}
var o__16585 = cljs.reader.read.call(null,rdr,true,null,true);
if((function (){var G__16586__16587 = o__16585;
if(G__16586__16587)
{if((function (){var or__3824__auto____16588 = (G__16586__16587.cljs$lang$protocol_mask$partition0$ & 262144);
if(or__3824__auto____16588)
{return or__3824__auto____16588;
} else
{return G__16586__16587.cljs$core$IWithMeta$;
}
})())
{return true;
} else
{if((!G__16586__16587.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IWithMeta,G__16586__16587);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IWithMeta,G__16586__16587);
}
})())
{return cljs.core.with_meta.call(null,o__16585,cljs.core.merge.call(null,cljs.core.meta.call(null,o__16585),m__16584));
} else
{return cljs.reader.reader_error.call(null,rdr,"Metadata can only be applied to IWithMetas");
}
});
cljs.reader.read_set = (function read_set(rdr,_){
return cljs.core.set.call(null,cljs.reader.read_delimited_list.call(null,"}",rdr,true));
});
cljs.reader.read_regex = (function read_regex(rdr,ch){
return cljs.core.re_pattern.call(null,cljs.reader.read_string_STAR_.call(null,rdr,ch));
});
cljs.reader.read_discard = (function read_discard(rdr,_){
cljs.reader.read.call(null,rdr,true,null,true);
return rdr;
});
cljs.reader.macros = (function macros(c){
if((c === "\""))
{return cljs.reader.read_string_STAR_;
} else
{if((c === ":"))
{return cljs.reader.read_keyword;
} else
{if((c === ";"))
{return cljs.reader.not_implemented;
} else
{if((c === "'"))
{return cljs.reader.wrapping_reader.call(null,"\uFDD1'quote");
} else
{if((c === "@"))
{return cljs.reader.wrapping_reader.call(null,"\uFDD1'deref");
} else
{if((c === "^"))
{return cljs.reader.read_meta;
} else
{if((c === "`"))
{return cljs.reader.not_implemented;
} else
{if((c === "~"))
{return cljs.reader.not_implemented;
} else
{if((c === "("))
{return cljs.reader.read_list;
} else
{if((c === ")"))
{return cljs.reader.read_unmatched_delimiter;
} else
{if((c === "["))
{return cljs.reader.read_vector;
} else
{if((c === "]"))
{return cljs.reader.read_unmatched_delimiter;
} else
{if((c === "{"))
{return cljs.reader.read_map;
} else
{if((c === "}"))
{return cljs.reader.read_unmatched_delimiter;
} else
{if((c === "\\"))
{return cljs.reader.read_char;
} else
{if((c === "%"))
{return cljs.reader.not_implemented;
} else
{if((c === "#"))
{return cljs.reader.read_dispatch;
} else
{if("\uFDD0'else")
{return null;
} else
{return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
cljs.reader.dispatch_macros = (function dispatch_macros(s){
if((s === "{"))
{return cljs.reader.read_set;
} else
{if((s === "<"))
{return cljs.reader.throwing_reader.call(null,"Unreadable form");
} else
{if((s === "\""))
{return cljs.reader.read_regex;
} else
{if((s === "!"))
{return cljs.reader.read_comment;
} else
{if((s === "_"))
{return cljs.reader.read_discard;
} else
{if("\uFDD0'else")
{return null;
} else
{return null;
}
}
}
}
}
}
});
/**
* Reads the first object from a PushbackReader. Returns the object read.
* If EOF, throws if eof-is-error is true. Otherwise returns sentinel.
*/
cljs.reader.read = (function read(reader,eof_is_error,sentinel,is_recursive){
while(true){
var ch__16592 = cljs.reader.read_char.call(null,reader);
if((ch__16592 == null))
{if(cljs.core.truth_(eof_is_error))
{return cljs.reader.reader_error.call(null,reader,"EOF");
} else
{return sentinel;
}
} else
{if(cljs.reader.whitespace_QMARK_.call(null,ch__16592))
{{
var G__16595 = reader;
var G__16596 = eof_is_error;
var G__16597 = sentinel;
var G__16598 = is_recursive;
reader = G__16595;
eof_is_error = G__16596;
sentinel = G__16597;
is_recursive = G__16598;
continue;
}
} else
{if(cljs.reader.comment_prefix_QMARK_.call(null,ch__16592))
{{
var G__16599 = cljs.reader.read_comment.call(null,reader,ch__16592);
var G__16600 = eof_is_error;
var G__16601 = sentinel;
var G__16602 = is_recursive;
reader = G__16599;
eof_is_error = G__16600;
sentinel = G__16601;
is_recursive = G__16602;
continue;
}
} else
{if("\uFDD0'else")
{var f__16593 = cljs.reader.macros.call(null,ch__16592);
var res__16594 = (cljs.core.truth_(f__16593)?f__16593.call(null,reader,ch__16592):((cljs.reader.number_literal_QMARK_.call(null,reader,ch__16592))?cljs.reader.read_number.call(null,reader,ch__16592):(("\uFDD0'else")?cljs.reader.read_symbol.call(null,reader,ch__16592):null)));
if((res__16594 === reader))
{{
var G__16603 = reader;
var G__16604 = eof_is_error;
var G__16605 = sentinel;
var G__16606 = is_recursive;
reader = G__16603;
eof_is_error = G__16604;
sentinel = G__16605;
is_recursive = G__16606;
continue;
}
} else
{return res__16594;
}
} else
{return null;
}
}
}
}
break;
}
});
/**
* Reads one object from the string s
*/
cljs.reader.read_string = (function read_string(s){
var r__16608 = cljs.reader.push_back_reader.call(null,s);
return cljs.reader.read.call(null,r__16608,true,null,false);
});
cljs.reader.zero_fill_right = (function zero_fill_right(s,width){
if(cljs.core._EQ_.call(null,width,cljs.core.count.call(null,s)))
{return s;
} else
{if((width < cljs.core.count.call(null,s)))
{return s.substring(0,width);
} else
{if("\uFDD0'else")
{var b__16610 = (new goog.string.StringBuffer(s));
while(true){
if((b__16610.getLength() < width))
{{
var G__16611 = b__16610.append("0");
b__16610 = G__16611;
continue;
}
} else
{return b__16610.toString();
}
break;
}
} else
{return null;
}
}
}
});
cljs.reader.divisible_QMARK_ = (function divisible_QMARK_(num,div){
return ((num % div) === 0);
});
cljs.reader.indivisible_QMARK_ = (function indivisible_QMARK_(num,div){
return cljs.core.not.call(null,cljs.reader.divisible_QMARK_.call(null,num,div));
});
cljs.reader.leap_year_QMARK_ = (function leap_year_QMARK_(year){
var and__3822__auto____16614 = cljs.reader.divisible_QMARK_.call(null,year,4);
if(cljs.core.truth_(and__3822__auto____16614))
{var or__3824__auto____16615 = cljs.reader.indivisible_QMARK_.call(null,year,100);
if(cljs.core.truth_(or__3824__auto____16615))
{return or__3824__auto____16615;
} else
{return cljs.reader.divisible_QMARK_.call(null,year,400);
}
} else
{return and__3822__auto____16614;
}
});
cljs.reader.days_in_month = (function (){var dim_norm__16620 = cljs.core.PersistentVector.fromArray([null,31,28,31,30,31,30,31,31,30,31,30,31], true);
var dim_leap__16621 = cljs.core.PersistentVector.fromArray([null,31,29,31,30,31,30,31,31,30,31,30,31], true);
return (function (month,leap_year_QMARK_){
return cljs.core._lookup.call(null,(cljs.core.truth_(leap_year_QMARK_)?dim_leap__16621:dim_norm__16620),month,null);
});
})();
cljs.reader.parse_and_validate_timestamp = (function (){var timestamp__16622 = /(\d\d\d\d)(?:-(\d\d)(?:-(\d\d)(?:[T](\d\d)(?::(\d\d)(?::(\d\d)(?:[.](\d+))?)?)?)?)?)?(?:[Z]|([-+])(\d\d):(\d\d))?/;
var check__16624 = (function (low,n,high,msg){
if((function (){var and__3822__auto____16623 = (low <= n);
if(and__3822__auto____16623)
{return (n <= high);
} else
{return and__3822__auto____16623;
}
})())
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str(msg),cljs.core.str(" Failed:  "),cljs.core.str(low),cljs.core.str("<="),cljs.core.str(n),cljs.core.str("<="),cljs.core.str(high)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.with_meta(cljs.core.list("\uFDD1'<=","\uFDD1'low","\uFDD1'n","\uFDD1'high"),cljs.core.hash_map("\uFDD0'line",474))))].join('')));
}
return n;
});
return (function (ts){
var temp__3974__auto____16625 = cljs.core.map.call(null,cljs.core.vec,cljs.core.split_at.call(null,8,cljs.core.re_matches.call(null,timestamp__16622,ts)));
if(cljs.core.truth_(temp__3974__auto____16625))
{var vec__16626__16629 = temp__3974__auto____16625;
var vec__16627__16630 = cljs.core.nth.call(null,vec__16626__16629,0,null);
var ___16631 = cljs.core.nth.call(null,vec__16627__16630,0,null);
var years__16632 = cljs.core.nth.call(null,vec__16627__16630,1,null);
var months__16633 = cljs.core.nth.call(null,vec__16627__16630,2,null);
var days__16634 = cljs.core.nth.call(null,vec__16627__16630,3,null);
var hours__16635 = cljs.core.nth.call(null,vec__16627__16630,4,null);
var minutes__16636 = cljs.core.nth.call(null,vec__16627__16630,5,null);
var seconds__16637 = cljs.core.nth.call(null,vec__16627__16630,6,null);
var milliseconds__16638 = cljs.core.nth.call(null,vec__16627__16630,7,null);
var vec__16628__16639 = cljs.core.nth.call(null,vec__16626__16629,1,null);
var ___16640 = cljs.core.nth.call(null,vec__16628__16639,0,null);
var ___16641 = cljs.core.nth.call(null,vec__16628__16639,1,null);
var ___16642 = cljs.core.nth.call(null,vec__16628__16639,2,null);
var V__16643 = vec__16626__16629;
var vec__16644__16647 = cljs.core.map.call(null,(function (v){
return cljs.core.map.call(null,(function (p1__16619_SHARP_){
return parseInt(p1__16619_SHARP_,10);
}),v);
}),cljs.core.map.call(null,(function (p1__16617_SHARP_,p2__16616_SHARP_){
return cljs.core.update_in.call(null,p2__16616_SHARP_,cljs.core.PersistentVector.fromArray([0], true),p1__16617_SHARP_);
}),cljs.core.PersistentVector.fromArray([cljs.core.constantly.call(null,null),(function (p1__16618_SHARP_){
if(cljs.core._EQ_.call(null,p1__16618_SHARP_,"-"))
{return "-1";
} else
{return "1";
}
})], true),V__16643));
var vec__16645__16648 = cljs.core.nth.call(null,vec__16644__16647,0,null);
var ___16649 = cljs.core.nth.call(null,vec__16645__16648,0,null);
var y__16650 = cljs.core.nth.call(null,vec__16645__16648,1,null);
var mo__16651 = cljs.core.nth.call(null,vec__16645__16648,2,null);
var d__16652 = cljs.core.nth.call(null,vec__16645__16648,3,null);
var h__16653 = cljs.core.nth.call(null,vec__16645__16648,4,null);
var m__16654 = cljs.core.nth.call(null,vec__16645__16648,5,null);
var s__16655 = cljs.core.nth.call(null,vec__16645__16648,6,null);
var ms__16656 = cljs.core.nth.call(null,vec__16645__16648,7,null);
var vec__16646__16657 = cljs.core.nth.call(null,vec__16644__16647,1,null);
var offset_sign__16658 = cljs.core.nth.call(null,vec__16646__16657,0,null);
var offset_hours__16659 = cljs.core.nth.call(null,vec__16646__16657,1,null);
var offset_minutes__16660 = cljs.core.nth.call(null,vec__16646__16657,2,null);
var offset__16661 = (offset_sign__16658 * ((offset_hours__16659 * 60) + offset_minutes__16660));
return cljs.core.PersistentVector.fromArray([((cljs.core.not.call(null,years__16632))?1970:y__16650),((cljs.core.not.call(null,months__16633))?1:check__16624.call(null,1,mo__16651,12,"timestamp month field must be in range 1..12")),((cljs.core.not.call(null,days__16634))?1:check__16624.call(null,1,d__16652,cljs.reader.days_in_month.call(null,mo__16651,cljs.reader.leap_year_QMARK_.call(null,y__16650)),"timestamp day field must be in range 1..last day in month")),((cljs.core.not.call(null,hours__16635))?0:check__16624.call(null,0,h__16653,23,"timestamp hour field must be in range 0..23")),((cljs.core.not.call(null,minutes__16636))?0:check__16624.call(null,0,m__16654,59,"timestamp minute field must be in range 0..59")),((cljs.core.not.call(null,seconds__16637))?0:check__16624.call(null,0,s__16655,((cljs.core._EQ_.call(null,m__16654,59))?60:59),"timestamp second field must be in range 0..60")),((cljs.core.not.call(null,milliseconds__16638))?0:check__16624.call(null,0,ms__16656,999,"timestamp millisecond field must be in range 0..999")),offset__16661], true);
} else
{return null;
}
});
})();
cljs.reader.parse_timestamp = (function parse_timestamp(ts){
var temp__3971__auto____16673 = cljs.reader.parse_and_validate_timestamp.call(null,ts);
if(cljs.core.truth_(temp__3971__auto____16673))
{var vec__16674__16675 = temp__3971__auto____16673;
var years__16676 = cljs.core.nth.call(null,vec__16674__16675,0,null);
var months__16677 = cljs.core.nth.call(null,vec__16674__16675,1,null);
var days__16678 = cljs.core.nth.call(null,vec__16674__16675,2,null);
var hours__16679 = cljs.core.nth.call(null,vec__16674__16675,3,null);
var minutes__16680 = cljs.core.nth.call(null,vec__16674__16675,4,null);
var seconds__16681 = cljs.core.nth.call(null,vec__16674__16675,5,null);
var ms__16682 = cljs.core.nth.call(null,vec__16674__16675,6,null);
var offset__16683 = cljs.core.nth.call(null,vec__16674__16675,7,null);
return (new Date((Date.UTC(years__16676,(months__16677 - 1),days__16678,hours__16679,minutes__16680,seconds__16681,ms__16682) - ((offset__16683 * 60) * 1000))));
} else
{return cljs.reader.reader_error.call(null,null,[cljs.core.str("Unrecognized date/time syntax: "),cljs.core.str(ts)].join(''));
}
});
cljs.reader.read_date = (function read_date(s){
if(cljs.core.string_QMARK_.call(null,s))
{return cljs.reader.parse_timestamp.call(null,s);
} else
{return cljs.reader.reader_error.call(null,null,"Instance literal expects a string for its timestamp.");
}
});
cljs.reader.read_queue = (function read_queue(elems){
if(cljs.core.vector_QMARK_.call(null,elems))
{return cljs.core.into.call(null,cljs.core.PersistentQueue.EMPTY,elems);
} else
{return cljs.reader.reader_error.call(null,null,"Queue literal expects a vector for its elements.");
}
});
cljs.reader.read_uuid = (function read_uuid(uuid){
if(cljs.core.string_QMARK_.call(null,uuid))
{return (new cljs.core.UUID(uuid));
} else
{return cljs.reader.reader_error.call(null,null,"UUID literal expects a string as its representation.");
}
});
cljs.reader._STAR_tag_table_STAR_ = cljs.core.atom.call(null,cljs.core.ObjMap.fromObject(["inst","uuid","queue"],{"inst":cljs.reader.read_date,"uuid":cljs.reader.read_uuid,"queue":cljs.reader.read_queue}));
cljs.reader.maybe_read_tagged_type = (function maybe_read_tagged_type(rdr,initch){
var tag__16687 = cljs.reader.read_symbol.call(null,rdr,initch);
var temp__3971__auto____16688 = cljs.core._lookup.call(null,cljs.core.deref.call(null,cljs.reader._STAR_tag_table_STAR_),cljs.core.name.call(null,tag__16687),null);
if(cljs.core.truth_(temp__3971__auto____16688))
{var pfn__16689 = temp__3971__auto____16688;
return pfn__16689.call(null,cljs.reader.read.call(null,rdr,true,null,false));
} else
{return cljs.reader.reader_error.call(null,rdr,"Could not find tag parser for ",cljs.core.name.call(null,tag__16687)," in ",cljs.core.pr_str.call(null,cljs.core.keys.call(null,cljs.core.deref.call(null,cljs.reader._STAR_tag_table_STAR_))));
}
});
cljs.reader.register_tag_parser_BANG_ = (function register_tag_parser_BANG_(tag,f){
var tag__16692 = cljs.core.name.call(null,tag);
var old_parser__16693 = cljs.core._lookup.call(null,cljs.core.deref.call(null,cljs.reader._STAR_tag_table_STAR_),tag__16692,null);
cljs.core.swap_BANG_.call(null,cljs.reader._STAR_tag_table_STAR_,cljs.core.assoc,tag__16692,f);
return old_parser__16693;
});
cljs.reader.deregister_tag_parser_BANG_ = (function deregister_tag_parser_BANG_(tag){
var tag__16696 = cljs.core.name.call(null,tag);
var old_parser__16697 = cljs.core._lookup.call(null,cljs.core.deref.call(null,cljs.reader._STAR_tag_table_STAR_),tag__16696,null);
cljs.core.swap_BANG_.call(null,cljs.reader._STAR_tag_table_STAR_,cljs.core.dissoc,tag__16696);
return old_parser__16697;
});
