goog.provide('cljs.core');
goog.require('goog.array');
goog.require('goog.object');
goog.require('goog.string.format');
goog.require('goog.string.StringBuffer');
goog.require('goog.string');
cljs.core._STAR_unchecked_if_STAR_ = false;
/**
* Each runtime environment provides a diffenent way to print output.
* Whatever function *print-fn* is bound to will be passed any
* Strings which should be printed.
*/
cljs.core._STAR_print_fn_STAR_ = (function _STAR_print_fn_STAR_(_){
throw (new Error("No *print-fn* fn set for evaluation environment"));
});
/**
* Internal - do not use!
*/
cljs.core.truth_ = (function truth_(x){
return (x != null && x !== false);
});
/**
* Internal - do not use!
*/
cljs.core.type_satisfies_ = (function type_satisfies_(p,x){
var x__11531 = (((x == null))?null:x);
if((p[goog.typeOf(x__11531)]))
{return true;
} else
{if((p["_"]))
{return true;
} else
{if("\uFDD0'else")
{return false;
} else
{return null;
}
}
}
});
cljs.core.is_proto_ = (function is_proto_(x){
return (x.constructor.prototype === x);
});
/**
* When compiled for a command-line target, whatever
* function *main-fn* is set to will be called with the command-line
* argv as arguments
*/
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.missing_protocol = (function missing_protocol(proto,obj){
return Error(["No protocol method ",proto," defined for type ",goog.typeOf(obj),": ",obj].join(""));
});
/**
* Returns a javascript array, cloned from the passed in array
*/
cljs.core.aclone = (function aclone(array_like){
return array_like.slice();
});
/**
* Creates a new javascript array.
* @param {...*} var_args
*/
cljs.core.array = (function array(var_args){
return Array.prototype.slice.call(arguments);
});
cljs.core.make_array = (function() {
var make_array = null;
var make_array__1 = (function (size){
return (new Array(size));
});
var make_array__2 = (function (type,size){
return make_array.call(null,size);
});
make_array = function(type,size){
switch(arguments.length){
case 1:
return make_array__1.call(this,type);
case 2:
return make_array__2.call(this,type,size);
}
throw('Invalid arity: ' + arguments.length);
};
make_array.cljs$lang$arity$1 = make_array__1;
make_array.cljs$lang$arity$2 = make_array__2;
return make_array;
})()
;
/**
* Returns the value at the index.
* @param {...*} var_args
*/
cljs.core.aget = (function() {
var aget = null;
var aget__2 = (function (array,i){
return (array[i]);
});
var aget__3 = (function() { 
var G__11532__delegate = function (array,i,idxs){
return cljs.core.apply.call(null,aget,aget.call(null,array,i),idxs);
};
var G__11532 = function (array,i,var_args){
var idxs = null;
if (goog.isDef(var_args)) {
  idxs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__11532__delegate.call(this, array, i, idxs);
};
G__11532.cljs$lang$maxFixedArity = 2;
G__11532.cljs$lang$applyTo = (function (arglist__11533){
var array = cljs.core.first(arglist__11533);
var i = cljs.core.first(cljs.core.next(arglist__11533));
var idxs = cljs.core.rest(cljs.core.next(arglist__11533));
return G__11532__delegate(array, i, idxs);
});
G__11532.cljs$lang$arity$variadic = G__11532__delegate;
return G__11532;
})()
;
aget = function(array,i,var_args){
var idxs = var_args;
switch(arguments.length){
case 2:
return aget__2.call(this,array,i);
default:
return aget__3.cljs$lang$arity$variadic(array,i, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
aget.cljs$lang$maxFixedArity = 2;
aget.cljs$lang$applyTo = aget__3.cljs$lang$applyTo;
aget.cljs$lang$arity$2 = aget__2;
aget.cljs$lang$arity$variadic = aget__3.cljs$lang$arity$variadic;
return aget;
})()
;
/**
* Sets the value at the index.
*/
cljs.core.aset = (function aset(array,i,val){
return (array[i] = val);
});
/**
* Returns the length of the array. Works on arrays of all types.
*/
cljs.core.alength = (function alength(array){
return array.length;
});
cljs.core.into_array = (function() {
var into_array = null;
var into_array__1 = (function (aseq){
return into_array.call(null,null,aseq);
});
var into_array__2 = (function (type,aseq){
return cljs.core.reduce.call(null,(function (a,x){
a.push(x);
return a;
}),[],aseq);
});
into_array = function(type,aseq){
switch(arguments.length){
case 1:
return into_array__1.call(this,type);
case 2:
return into_array__2.call(this,type,aseq);
}
throw('Invalid arity: ' + arguments.length);
};
into_array.cljs$lang$arity$1 = into_array__1;
into_array.cljs$lang$arity$2 = into_array__2;
return into_array;
})()
;
cljs.core.IFn = {};
cljs.core._invoke = (function() {
var _invoke = null;
var _invoke__1 = (function (this$){
if((function (){var and__3822__auto____11618 = this$;
if(and__3822__auto____11618)
{return this$.cljs$core$IFn$_invoke$arity$1;
} else
{return and__3822__auto____11618;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else
{var x__4885__auto____11619 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11620 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11619)]);
if(or__3824__auto____11620)
{return or__3824__auto____11620;
} else
{var or__3824__auto____11621 = (cljs.core._invoke["_"]);
if(or__3824__auto____11621)
{return or__3824__auto____11621;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$);
}
});
var _invoke__2 = (function (this$,a){
if((function (){var and__3822__auto____11622 = this$;
if(and__3822__auto____11622)
{return this$.cljs$core$IFn$_invoke$arity$2;
} else
{return and__3822__auto____11622;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else
{var x__4885__auto____11623 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11624 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11623)]);
if(or__3824__auto____11624)
{return or__3824__auto____11624;
} else
{var or__3824__auto____11625 = (cljs.core._invoke["_"]);
if(or__3824__auto____11625)
{return or__3824__auto____11625;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a);
}
});
var _invoke__3 = (function (this$,a,b){
if((function (){var and__3822__auto____11626 = this$;
if(and__3822__auto____11626)
{return this$.cljs$core$IFn$_invoke$arity$3;
} else
{return and__3822__auto____11626;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else
{var x__4885__auto____11627 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11628 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11627)]);
if(or__3824__auto____11628)
{return or__3824__auto____11628;
} else
{var or__3824__auto____11629 = (cljs.core._invoke["_"]);
if(or__3824__auto____11629)
{return or__3824__auto____11629;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b);
}
});
var _invoke__4 = (function (this$,a,b,c){
if((function (){var and__3822__auto____11630 = this$;
if(and__3822__auto____11630)
{return this$.cljs$core$IFn$_invoke$arity$4;
} else
{return and__3822__auto____11630;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else
{var x__4885__auto____11631 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11632 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11631)]);
if(or__3824__auto____11632)
{return or__3824__auto____11632;
} else
{var or__3824__auto____11633 = (cljs.core._invoke["_"]);
if(or__3824__auto____11633)
{return or__3824__auto____11633;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c);
}
});
var _invoke__5 = (function (this$,a,b,c,d){
if((function (){var and__3822__auto____11634 = this$;
if(and__3822__auto____11634)
{return this$.cljs$core$IFn$_invoke$arity$5;
} else
{return and__3822__auto____11634;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else
{var x__4885__auto____11635 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11636 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11635)]);
if(or__3824__auto____11636)
{return or__3824__auto____11636;
} else
{var or__3824__auto____11637 = (cljs.core._invoke["_"]);
if(or__3824__auto____11637)
{return or__3824__auto____11637;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d);
}
});
var _invoke__6 = (function (this$,a,b,c,d,e){
if((function (){var and__3822__auto____11638 = this$;
if(and__3822__auto____11638)
{return this$.cljs$core$IFn$_invoke$arity$6;
} else
{return and__3822__auto____11638;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else
{var x__4885__auto____11639 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11640 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11639)]);
if(or__3824__auto____11640)
{return or__3824__auto____11640;
} else
{var or__3824__auto____11641 = (cljs.core._invoke["_"]);
if(or__3824__auto____11641)
{return or__3824__auto____11641;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e);
}
});
var _invoke__7 = (function (this$,a,b,c,d,e,f){
if((function (){var and__3822__auto____11642 = this$;
if(and__3822__auto____11642)
{return this$.cljs$core$IFn$_invoke$arity$7;
} else
{return and__3822__auto____11642;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else
{var x__4885__auto____11643 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11644 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11643)]);
if(or__3824__auto____11644)
{return or__3824__auto____11644;
} else
{var or__3824__auto____11645 = (cljs.core._invoke["_"]);
if(or__3824__auto____11645)
{return or__3824__auto____11645;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f);
}
});
var _invoke__8 = (function (this$,a,b,c,d,e,f,g){
if((function (){var and__3822__auto____11646 = this$;
if(and__3822__auto____11646)
{return this$.cljs$core$IFn$_invoke$arity$8;
} else
{return and__3822__auto____11646;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else
{var x__4885__auto____11647 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11648 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11647)]);
if(or__3824__auto____11648)
{return or__3824__auto____11648;
} else
{var or__3824__auto____11649 = (cljs.core._invoke["_"]);
if(or__3824__auto____11649)
{return or__3824__auto____11649;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g);
}
});
var _invoke__9 = (function (this$,a,b,c,d,e,f,g,h){
if((function (){var and__3822__auto____11650 = this$;
if(and__3822__auto____11650)
{return this$.cljs$core$IFn$_invoke$arity$9;
} else
{return and__3822__auto____11650;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else
{var x__4885__auto____11651 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11652 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11651)]);
if(or__3824__auto____11652)
{return or__3824__auto____11652;
} else
{var or__3824__auto____11653 = (cljs.core._invoke["_"]);
if(or__3824__auto____11653)
{return or__3824__auto____11653;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h);
}
});
var _invoke__10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((function (){var and__3822__auto____11654 = this$;
if(and__3822__auto____11654)
{return this$.cljs$core$IFn$_invoke$arity$10;
} else
{return and__3822__auto____11654;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else
{var x__4885__auto____11655 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11656 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11655)]);
if(or__3824__auto____11656)
{return or__3824__auto____11656;
} else
{var or__3824__auto____11657 = (cljs.core._invoke["_"]);
if(or__3824__auto____11657)
{return or__3824__auto____11657;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i);
}
});
var _invoke__11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((function (){var and__3822__auto____11658 = this$;
if(and__3822__auto____11658)
{return this$.cljs$core$IFn$_invoke$arity$11;
} else
{return and__3822__auto____11658;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else
{var x__4885__auto____11659 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11660 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11659)]);
if(or__3824__auto____11660)
{return or__3824__auto____11660;
} else
{var or__3824__auto____11661 = (cljs.core._invoke["_"]);
if(or__3824__auto____11661)
{return or__3824__auto____11661;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j);
}
});
var _invoke__12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((function (){var and__3822__auto____11662 = this$;
if(and__3822__auto____11662)
{return this$.cljs$core$IFn$_invoke$arity$12;
} else
{return and__3822__auto____11662;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else
{var x__4885__auto____11663 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11664 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11663)]);
if(or__3824__auto____11664)
{return or__3824__auto____11664;
} else
{var or__3824__auto____11665 = (cljs.core._invoke["_"]);
if(or__3824__auto____11665)
{return or__3824__auto____11665;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k);
}
});
var _invoke__13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((function (){var and__3822__auto____11666 = this$;
if(and__3822__auto____11666)
{return this$.cljs$core$IFn$_invoke$arity$13;
} else
{return and__3822__auto____11666;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else
{var x__4885__auto____11667 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11668 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11667)]);
if(or__3824__auto____11668)
{return or__3824__auto____11668;
} else
{var or__3824__auto____11669 = (cljs.core._invoke["_"]);
if(or__3824__auto____11669)
{return or__3824__auto____11669;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
});
var _invoke__14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((function (){var and__3822__auto____11670 = this$;
if(and__3822__auto____11670)
{return this$.cljs$core$IFn$_invoke$arity$14;
} else
{return and__3822__auto____11670;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else
{var x__4885__auto____11671 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11672 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11671)]);
if(or__3824__auto____11672)
{return or__3824__auto____11672;
} else
{var or__3824__auto____11673 = (cljs.core._invoke["_"]);
if(or__3824__auto____11673)
{return or__3824__auto____11673;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
});
var _invoke__15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((function (){var and__3822__auto____11674 = this$;
if(and__3822__auto____11674)
{return this$.cljs$core$IFn$_invoke$arity$15;
} else
{return and__3822__auto____11674;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else
{var x__4885__auto____11675 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11676 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11675)]);
if(or__3824__auto____11676)
{return or__3824__auto____11676;
} else
{var or__3824__auto____11677 = (cljs.core._invoke["_"]);
if(or__3824__auto____11677)
{return or__3824__auto____11677;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
});
var _invoke__16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((function (){var and__3822__auto____11678 = this$;
if(and__3822__auto____11678)
{return this$.cljs$core$IFn$_invoke$arity$16;
} else
{return and__3822__auto____11678;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else
{var x__4885__auto____11679 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11680 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11679)]);
if(or__3824__auto____11680)
{return or__3824__auto____11680;
} else
{var or__3824__auto____11681 = (cljs.core._invoke["_"]);
if(or__3824__auto____11681)
{return or__3824__auto____11681;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
});
var _invoke__17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((function (){var and__3822__auto____11682 = this$;
if(and__3822__auto____11682)
{return this$.cljs$core$IFn$_invoke$arity$17;
} else
{return and__3822__auto____11682;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else
{var x__4885__auto____11683 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11684 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11683)]);
if(or__3824__auto____11684)
{return or__3824__auto____11684;
} else
{var or__3824__auto____11685 = (cljs.core._invoke["_"]);
if(or__3824__auto____11685)
{return or__3824__auto____11685;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
});
var _invoke__18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((function (){var and__3822__auto____11686 = this$;
if(and__3822__auto____11686)
{return this$.cljs$core$IFn$_invoke$arity$18;
} else
{return and__3822__auto____11686;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else
{var x__4885__auto____11687 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11688 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11687)]);
if(or__3824__auto____11688)
{return or__3824__auto____11688;
} else
{var or__3824__auto____11689 = (cljs.core._invoke["_"]);
if(or__3824__auto____11689)
{return or__3824__auto____11689;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
});
var _invoke__19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,s){
if((function (){var and__3822__auto____11690 = this$;
if(and__3822__auto____11690)
{return this$.cljs$core$IFn$_invoke$arity$19;
} else
{return and__3822__auto____11690;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,s);
} else
{var x__4885__auto____11691 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11692 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11691)]);
if(or__3824__auto____11692)
{return or__3824__auto____11692;
} else
{var or__3824__auto____11693 = (cljs.core._invoke["_"]);
if(or__3824__auto____11693)
{return or__3824__auto____11693;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,s);
}
});
var _invoke__20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,s,t){
if((function (){var and__3822__auto____11694 = this$;
if(and__3822__auto____11694)
{return this$.cljs$core$IFn$_invoke$arity$20;
} else
{return and__3822__auto____11694;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,s,t);
} else
{var x__4885__auto____11695 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11696 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11695)]);
if(or__3824__auto____11696)
{return or__3824__auto____11696;
} else
{var or__3824__auto____11697 = (cljs.core._invoke["_"]);
if(or__3824__auto____11697)
{return or__3824__auto____11697;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,s,t);
}
});
var _invoke__21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,s,t,rest){
if((function (){var and__3822__auto____11698 = this$;
if(and__3822__auto____11698)
{return this$.cljs$core$IFn$_invoke$arity$21;
} else
{return and__3822__auto____11698;
}
})())
{return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,s,t,rest);
} else
{var x__4885__auto____11699 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11700 = (cljs.core._invoke[goog.typeOf(x__4885__auto____11699)]);
if(or__3824__auto____11700)
{return or__3824__auto____11700;
} else
{var or__3824__auto____11701 = (cljs.core._invoke["_"]);
if(or__3824__auto____11701)
{return or__3824__auto____11701;
} else
{throw cljs.core.missing_protocol.call(null,"IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,s,t,rest);
}
});
_invoke = function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,s,t,rest){
switch(arguments.length){
case 1:
return _invoke__1.call(this,this$);
case 2:
return _invoke__2.call(this,this$,a);
case 3:
return _invoke__3.call(this,this$,a,b);
case 4:
return _invoke__4.call(this,this$,a,b,c);
case 5:
return _invoke__5.call(this,this$,a,b,c,d);
case 6:
return _invoke__6.call(this,this$,a,b,c,d,e);
case 7:
return _invoke__7.call(this,this$,a,b,c,d,e,f);
case 8:
return _invoke__8.call(this,this$,a,b,c,d,e,f,g);
case 9:
return _invoke__9.call(this,this$,a,b,c,d,e,f,g,h);
case 10:
return _invoke__10.call(this,this$,a,b,c,d,e,f,g,h,i);
case 11:
return _invoke__11.call(this,this$,a,b,c,d,e,f,g,h,i,j);
case 12:
return _invoke__12.call(this,this$,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return _invoke__13.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return _invoke__14.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return _invoke__15.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return _invoke__16.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return _invoke__17.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return _invoke__18.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return _invoke__19.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,s);
case 20:
return _invoke__20.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,s,t);
case 21:
return _invoke__21.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,s,t,rest);
}
throw('Invalid arity: ' + arguments.length);
};
_invoke.cljs$lang$arity$1 = _invoke__1;
_invoke.cljs$lang$arity$2 = _invoke__2;
_invoke.cljs$lang$arity$3 = _invoke__3;
_invoke.cljs$lang$arity$4 = _invoke__4;
_invoke.cljs$lang$arity$5 = _invoke__5;
_invoke.cljs$lang$arity$6 = _invoke__6;
_invoke.cljs$lang$arity$7 = _invoke__7;
_invoke.cljs$lang$arity$8 = _invoke__8;
_invoke.cljs$lang$arity$9 = _invoke__9;
_invoke.cljs$lang$arity$10 = _invoke__10;
_invoke.cljs$lang$arity$11 = _invoke__11;
_invoke.cljs$lang$arity$12 = _invoke__12;
_invoke.cljs$lang$arity$13 = _invoke__13;
_invoke.cljs$lang$arity$14 = _invoke__14;
_invoke.cljs$lang$arity$15 = _invoke__15;
_invoke.cljs$lang$arity$16 = _invoke__16;
_invoke.cljs$lang$arity$17 = _invoke__17;
_invoke.cljs$lang$arity$18 = _invoke__18;
_invoke.cljs$lang$arity$19 = _invoke__19;
_invoke.cljs$lang$arity$20 = _invoke__20;
_invoke.cljs$lang$arity$21 = _invoke__21;
return _invoke;
})()
;
cljs.core.ICounted = {};
cljs.core._count = (function _count(coll){
if((function (){var and__3822__auto____11706 = coll;
if(and__3822__auto____11706)
{return coll.cljs$core$ICounted$_count$arity$1;
} else
{return and__3822__auto____11706;
}
})())
{return coll.cljs$core$ICounted$_count$arity$1(coll);
} else
{var x__4885__auto____11707 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11708 = (cljs.core._count[goog.typeOf(x__4885__auto____11707)]);
if(or__3824__auto____11708)
{return or__3824__auto____11708;
} else
{var or__3824__auto____11709 = (cljs.core._count["_"]);
if(or__3824__auto____11709)
{return or__3824__auto____11709;
} else
{throw cljs.core.missing_protocol.call(null,"ICounted.-count",coll);
}
}
})().call(null,coll);
}
});
cljs.core.IEmptyableCollection = {};
cljs.core._empty = (function _empty(coll){
if((function (){var and__3822__auto____11714 = coll;
if(and__3822__auto____11714)
{return coll.cljs$core$IEmptyableCollection$_empty$arity$1;
} else
{return and__3822__auto____11714;
}
})())
{return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else
{var x__4885__auto____11715 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11716 = (cljs.core._empty[goog.typeOf(x__4885__auto____11715)]);
if(or__3824__auto____11716)
{return or__3824__auto____11716;
} else
{var or__3824__auto____11717 = (cljs.core._empty["_"]);
if(or__3824__auto____11717)
{return or__3824__auto____11717;
} else
{throw cljs.core.missing_protocol.call(null,"IEmptyableCollection.-empty",coll);
}
}
})().call(null,coll);
}
});
cljs.core.ICollection = {};
cljs.core._conj = (function _conj(coll,o){
if((function (){var and__3822__auto____11722 = coll;
if(and__3822__auto____11722)
{return coll.cljs$core$ICollection$_conj$arity$2;
} else
{return and__3822__auto____11722;
}
})())
{return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else
{var x__4885__auto____11723 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11724 = (cljs.core._conj[goog.typeOf(x__4885__auto____11723)]);
if(or__3824__auto____11724)
{return or__3824__auto____11724;
} else
{var or__3824__auto____11725 = (cljs.core._conj["_"]);
if(or__3824__auto____11725)
{return or__3824__auto____11725;
} else
{throw cljs.core.missing_protocol.call(null,"ICollection.-conj",coll);
}
}
})().call(null,coll,o);
}
});
cljs.core.IIndexed = {};
cljs.core._nth = (function() {
var _nth = null;
var _nth__2 = (function (coll,n){
if((function (){var and__3822__auto____11734 = coll;
if(and__3822__auto____11734)
{return coll.cljs$core$IIndexed$_nth$arity$2;
} else
{return and__3822__auto____11734;
}
})())
{return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else
{var x__4885__auto____11735 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11736 = (cljs.core._nth[goog.typeOf(x__4885__auto____11735)]);
if(or__3824__auto____11736)
{return or__3824__auto____11736;
} else
{var or__3824__auto____11737 = (cljs.core._nth["_"]);
if(or__3824__auto____11737)
{return or__3824__auto____11737;
} else
{throw cljs.core.missing_protocol.call(null,"IIndexed.-nth",coll);
}
}
})().call(null,coll,n);
}
});
var _nth__3 = (function (coll,n,not_found){
if((function (){var and__3822__auto____11738 = coll;
if(and__3822__auto____11738)
{return coll.cljs$core$IIndexed$_nth$arity$3;
} else
{return and__3822__auto____11738;
}
})())
{return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else
{var x__4885__auto____11739 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11740 = (cljs.core._nth[goog.typeOf(x__4885__auto____11739)]);
if(or__3824__auto____11740)
{return or__3824__auto____11740;
} else
{var or__3824__auto____11741 = (cljs.core._nth["_"]);
if(or__3824__auto____11741)
{return or__3824__auto____11741;
} else
{throw cljs.core.missing_protocol.call(null,"IIndexed.-nth",coll);
}
}
})().call(null,coll,n,not_found);
}
});
_nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return _nth__2.call(this,coll,n);
case 3:
return _nth__3.call(this,coll,n,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
_nth.cljs$lang$arity$2 = _nth__2;
_nth.cljs$lang$arity$3 = _nth__3;
return _nth;
})()
;
cljs.core.ASeq = {};
cljs.core.ISeq = {};
cljs.core._first = (function _first(coll){
if((function (){var and__3822__auto____11746 = coll;
if(and__3822__auto____11746)
{return coll.cljs$core$ISeq$_first$arity$1;
} else
{return and__3822__auto____11746;
}
})())
{return coll.cljs$core$ISeq$_first$arity$1(coll);
} else
{var x__4885__auto____11747 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11748 = (cljs.core._first[goog.typeOf(x__4885__auto____11747)]);
if(or__3824__auto____11748)
{return or__3824__auto____11748;
} else
{var or__3824__auto____11749 = (cljs.core._first["_"]);
if(or__3824__auto____11749)
{return or__3824__auto____11749;
} else
{throw cljs.core.missing_protocol.call(null,"ISeq.-first",coll);
}
}
})().call(null,coll);
}
});
cljs.core._rest = (function _rest(coll){
if((function (){var and__3822__auto____11754 = coll;
if(and__3822__auto____11754)
{return coll.cljs$core$ISeq$_rest$arity$1;
} else
{return and__3822__auto____11754;
}
})())
{return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else
{var x__4885__auto____11755 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11756 = (cljs.core._rest[goog.typeOf(x__4885__auto____11755)]);
if(or__3824__auto____11756)
{return or__3824__auto____11756;
} else
{var or__3824__auto____11757 = (cljs.core._rest["_"]);
if(or__3824__auto____11757)
{return or__3824__auto____11757;
} else
{throw cljs.core.missing_protocol.call(null,"ISeq.-rest",coll);
}
}
})().call(null,coll);
}
});
cljs.core.INext = {};
cljs.core._next = (function _next(coll){
if((function (){var and__3822__auto____11762 = coll;
if(and__3822__auto____11762)
{return coll.cljs$core$INext$_next$arity$1;
} else
{return and__3822__auto____11762;
}
})())
{return coll.cljs$core$INext$_next$arity$1(coll);
} else
{var x__4885__auto____11763 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11764 = (cljs.core._next[goog.typeOf(x__4885__auto____11763)]);
if(or__3824__auto____11764)
{return or__3824__auto____11764;
} else
{var or__3824__auto____11765 = (cljs.core._next["_"]);
if(or__3824__auto____11765)
{return or__3824__auto____11765;
} else
{throw cljs.core.missing_protocol.call(null,"INext.-next",coll);
}
}
})().call(null,coll);
}
});
cljs.core.ILookup = {};
cljs.core._lookup = (function() {
var _lookup = null;
var _lookup__2 = (function (o,k){
if((function (){var and__3822__auto____11774 = o;
if(and__3822__auto____11774)
{return o.cljs$core$ILookup$_lookup$arity$2;
} else
{return and__3822__auto____11774;
}
})())
{return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else
{var x__4885__auto____11775 = (((o == null))?null:o);
return (function (){var or__3824__auto____11776 = (cljs.core._lookup[goog.typeOf(x__4885__auto____11775)]);
if(or__3824__auto____11776)
{return or__3824__auto____11776;
} else
{var or__3824__auto____11777 = (cljs.core._lookup["_"]);
if(or__3824__auto____11777)
{return or__3824__auto____11777;
} else
{throw cljs.core.missing_protocol.call(null,"ILookup.-lookup",o);
}
}
})().call(null,o,k);
}
});
var _lookup__3 = (function (o,k,not_found){
if((function (){var and__3822__auto____11778 = o;
if(and__3822__auto____11778)
{return o.cljs$core$ILookup$_lookup$arity$3;
} else
{return and__3822__auto____11778;
}
})())
{return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else
{var x__4885__auto____11779 = (((o == null))?null:o);
return (function (){var or__3824__auto____11780 = (cljs.core._lookup[goog.typeOf(x__4885__auto____11779)]);
if(or__3824__auto____11780)
{return or__3824__auto____11780;
} else
{var or__3824__auto____11781 = (cljs.core._lookup["_"]);
if(or__3824__auto____11781)
{return or__3824__auto____11781;
} else
{throw cljs.core.missing_protocol.call(null,"ILookup.-lookup",o);
}
}
})().call(null,o,k,not_found);
}
});
_lookup = function(o,k,not_found){
switch(arguments.length){
case 2:
return _lookup__2.call(this,o,k);
case 3:
return _lookup__3.call(this,o,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
_lookup.cljs$lang$arity$2 = _lookup__2;
_lookup.cljs$lang$arity$3 = _lookup__3;
return _lookup;
})()
;
cljs.core.IAssociative = {};
cljs.core._contains_key_QMARK_ = (function _contains_key_QMARK_(coll,k){
if((function (){var and__3822__auto____11786 = coll;
if(and__3822__auto____11786)
{return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2;
} else
{return and__3822__auto____11786;
}
})())
{return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else
{var x__4885__auto____11787 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11788 = (cljs.core._contains_key_QMARK_[goog.typeOf(x__4885__auto____11787)]);
if(or__3824__auto____11788)
{return or__3824__auto____11788;
} else
{var or__3824__auto____11789 = (cljs.core._contains_key_QMARK_["_"]);
if(or__3824__auto____11789)
{return or__3824__auto____11789;
} else
{throw cljs.core.missing_protocol.call(null,"IAssociative.-contains-key?",coll);
}
}
})().call(null,coll,k);
}
});
cljs.core._assoc = (function _assoc(coll,k,v){
if((function (){var and__3822__auto____11794 = coll;
if(and__3822__auto____11794)
{return coll.cljs$core$IAssociative$_assoc$arity$3;
} else
{return and__3822__auto____11794;
}
})())
{return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else
{var x__4885__auto____11795 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11796 = (cljs.core._assoc[goog.typeOf(x__4885__auto____11795)]);
if(or__3824__auto____11796)
{return or__3824__auto____11796;
} else
{var or__3824__auto____11797 = (cljs.core._assoc["_"]);
if(or__3824__auto____11797)
{return or__3824__auto____11797;
} else
{throw cljs.core.missing_protocol.call(null,"IAssociative.-assoc",coll);
}
}
})().call(null,coll,k,v);
}
});
cljs.core.IMap = {};
cljs.core._dissoc = (function _dissoc(coll,k){
if((function (){var and__3822__auto____11802 = coll;
if(and__3822__auto____11802)
{return coll.cljs$core$IMap$_dissoc$arity$2;
} else
{return and__3822__auto____11802;
}
})())
{return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else
{var x__4885__auto____11803 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11804 = (cljs.core._dissoc[goog.typeOf(x__4885__auto____11803)]);
if(or__3824__auto____11804)
{return or__3824__auto____11804;
} else
{var or__3824__auto____11805 = (cljs.core._dissoc["_"]);
if(or__3824__auto____11805)
{return or__3824__auto____11805;
} else
{throw cljs.core.missing_protocol.call(null,"IMap.-dissoc",coll);
}
}
})().call(null,coll,k);
}
});
cljs.core.IMapEntry = {};
cljs.core._key = (function _key(coll){
if((function (){var and__3822__auto____11810 = coll;
if(and__3822__auto____11810)
{return coll.cljs$core$IMapEntry$_key$arity$1;
} else
{return and__3822__auto____11810;
}
})())
{return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else
{var x__4885__auto____11811 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11812 = (cljs.core._key[goog.typeOf(x__4885__auto____11811)]);
if(or__3824__auto____11812)
{return or__3824__auto____11812;
} else
{var or__3824__auto____11813 = (cljs.core._key["_"]);
if(or__3824__auto____11813)
{return or__3824__auto____11813;
} else
{throw cljs.core.missing_protocol.call(null,"IMapEntry.-key",coll);
}
}
})().call(null,coll);
}
});
cljs.core._val = (function _val(coll){
if((function (){var and__3822__auto____11818 = coll;
if(and__3822__auto____11818)
{return coll.cljs$core$IMapEntry$_val$arity$1;
} else
{return and__3822__auto____11818;
}
})())
{return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else
{var x__4885__auto____11819 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11820 = (cljs.core._val[goog.typeOf(x__4885__auto____11819)]);
if(or__3824__auto____11820)
{return or__3824__auto____11820;
} else
{var or__3824__auto____11821 = (cljs.core._val["_"]);
if(or__3824__auto____11821)
{return or__3824__auto____11821;
} else
{throw cljs.core.missing_protocol.call(null,"IMapEntry.-val",coll);
}
}
})().call(null,coll);
}
});
cljs.core.ISet = {};
cljs.core._disjoin = (function _disjoin(coll,v){
if((function (){var and__3822__auto____11826 = coll;
if(and__3822__auto____11826)
{return coll.cljs$core$ISet$_disjoin$arity$2;
} else
{return and__3822__auto____11826;
}
})())
{return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else
{var x__4885__auto____11827 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11828 = (cljs.core._disjoin[goog.typeOf(x__4885__auto____11827)]);
if(or__3824__auto____11828)
{return or__3824__auto____11828;
} else
{var or__3824__auto____11829 = (cljs.core._disjoin["_"]);
if(or__3824__auto____11829)
{return or__3824__auto____11829;
} else
{throw cljs.core.missing_protocol.call(null,"ISet.-disjoin",coll);
}
}
})().call(null,coll,v);
}
});
cljs.core.IStack = {};
cljs.core._peek = (function _peek(coll){
if((function (){var and__3822__auto____11834 = coll;
if(and__3822__auto____11834)
{return coll.cljs$core$IStack$_peek$arity$1;
} else
{return and__3822__auto____11834;
}
})())
{return coll.cljs$core$IStack$_peek$arity$1(coll);
} else
{var x__4885__auto____11835 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11836 = (cljs.core._peek[goog.typeOf(x__4885__auto____11835)]);
if(or__3824__auto____11836)
{return or__3824__auto____11836;
} else
{var or__3824__auto____11837 = (cljs.core._peek["_"]);
if(or__3824__auto____11837)
{return or__3824__auto____11837;
} else
{throw cljs.core.missing_protocol.call(null,"IStack.-peek",coll);
}
}
})().call(null,coll);
}
});
cljs.core._pop = (function _pop(coll){
if((function (){var and__3822__auto____11842 = coll;
if(and__3822__auto____11842)
{return coll.cljs$core$IStack$_pop$arity$1;
} else
{return and__3822__auto____11842;
}
})())
{return coll.cljs$core$IStack$_pop$arity$1(coll);
} else
{var x__4885__auto____11843 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11844 = (cljs.core._pop[goog.typeOf(x__4885__auto____11843)]);
if(or__3824__auto____11844)
{return or__3824__auto____11844;
} else
{var or__3824__auto____11845 = (cljs.core._pop["_"]);
if(or__3824__auto____11845)
{return or__3824__auto____11845;
} else
{throw cljs.core.missing_protocol.call(null,"IStack.-pop",coll);
}
}
})().call(null,coll);
}
});
cljs.core.IVector = {};
cljs.core._assoc_n = (function _assoc_n(coll,n,val){
if((function (){var and__3822__auto____11850 = coll;
if(and__3822__auto____11850)
{return coll.cljs$core$IVector$_assoc_n$arity$3;
} else
{return and__3822__auto____11850;
}
})())
{return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else
{var x__4885__auto____11851 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11852 = (cljs.core._assoc_n[goog.typeOf(x__4885__auto____11851)]);
if(or__3824__auto____11852)
{return or__3824__auto____11852;
} else
{var or__3824__auto____11853 = (cljs.core._assoc_n["_"]);
if(or__3824__auto____11853)
{return or__3824__auto____11853;
} else
{throw cljs.core.missing_protocol.call(null,"IVector.-assoc-n",coll);
}
}
})().call(null,coll,n,val);
}
});
cljs.core.IDeref = {};
cljs.core._deref = (function _deref(o){
if((function (){var and__3822__auto____11858 = o;
if(and__3822__auto____11858)
{return o.cljs$core$IDeref$_deref$arity$1;
} else
{return and__3822__auto____11858;
}
})())
{return o.cljs$core$IDeref$_deref$arity$1(o);
} else
{var x__4885__auto____11859 = (((o == null))?null:o);
return (function (){var or__3824__auto____11860 = (cljs.core._deref[goog.typeOf(x__4885__auto____11859)]);
if(or__3824__auto____11860)
{return or__3824__auto____11860;
} else
{var or__3824__auto____11861 = (cljs.core._deref["_"]);
if(or__3824__auto____11861)
{return or__3824__auto____11861;
} else
{throw cljs.core.missing_protocol.call(null,"IDeref.-deref",o);
}
}
})().call(null,o);
}
});
cljs.core.IDerefWithTimeout = {};
cljs.core._deref_with_timeout = (function _deref_with_timeout(o,msec,timeout_val){
if((function (){var and__3822__auto____11866 = o;
if(and__3822__auto____11866)
{return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3;
} else
{return and__3822__auto____11866;
}
})())
{return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else
{var x__4885__auto____11867 = (((o == null))?null:o);
return (function (){var or__3824__auto____11868 = (cljs.core._deref_with_timeout[goog.typeOf(x__4885__auto____11867)]);
if(or__3824__auto____11868)
{return or__3824__auto____11868;
} else
{var or__3824__auto____11869 = (cljs.core._deref_with_timeout["_"]);
if(or__3824__auto____11869)
{return or__3824__auto____11869;
} else
{throw cljs.core.missing_protocol.call(null,"IDerefWithTimeout.-deref-with-timeout",o);
}
}
})().call(null,o,msec,timeout_val);
}
});
cljs.core.IMeta = {};
cljs.core._meta = (function _meta(o){
if((function (){var and__3822__auto____11874 = o;
if(and__3822__auto____11874)
{return o.cljs$core$IMeta$_meta$arity$1;
} else
{return and__3822__auto____11874;
}
})())
{return o.cljs$core$IMeta$_meta$arity$1(o);
} else
{var x__4885__auto____11875 = (((o == null))?null:o);
return (function (){var or__3824__auto____11876 = (cljs.core._meta[goog.typeOf(x__4885__auto____11875)]);
if(or__3824__auto____11876)
{return or__3824__auto____11876;
} else
{var or__3824__auto____11877 = (cljs.core._meta["_"]);
if(or__3824__auto____11877)
{return or__3824__auto____11877;
} else
{throw cljs.core.missing_protocol.call(null,"IMeta.-meta",o);
}
}
})().call(null,o);
}
});
cljs.core.IWithMeta = {};
cljs.core._with_meta = (function _with_meta(o,meta){
if((function (){var and__3822__auto____11882 = o;
if(and__3822__auto____11882)
{return o.cljs$core$IWithMeta$_with_meta$arity$2;
} else
{return and__3822__auto____11882;
}
})())
{return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else
{var x__4885__auto____11883 = (((o == null))?null:o);
return (function (){var or__3824__auto____11884 = (cljs.core._with_meta[goog.typeOf(x__4885__auto____11883)]);
if(or__3824__auto____11884)
{return or__3824__auto____11884;
} else
{var or__3824__auto____11885 = (cljs.core._with_meta["_"]);
if(or__3824__auto____11885)
{return or__3824__auto____11885;
} else
{throw cljs.core.missing_protocol.call(null,"IWithMeta.-with-meta",o);
}
}
})().call(null,o,meta);
}
});
cljs.core.IReduce = {};
cljs.core._reduce = (function() {
var _reduce = null;
var _reduce__2 = (function (coll,f){
if((function (){var and__3822__auto____11894 = coll;
if(and__3822__auto____11894)
{return coll.cljs$core$IReduce$_reduce$arity$2;
} else
{return and__3822__auto____11894;
}
})())
{return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else
{var x__4885__auto____11895 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11896 = (cljs.core._reduce[goog.typeOf(x__4885__auto____11895)]);
if(or__3824__auto____11896)
{return or__3824__auto____11896;
} else
{var or__3824__auto____11897 = (cljs.core._reduce["_"]);
if(or__3824__auto____11897)
{return or__3824__auto____11897;
} else
{throw cljs.core.missing_protocol.call(null,"IReduce.-reduce",coll);
}
}
})().call(null,coll,f);
}
});
var _reduce__3 = (function (coll,f,start){
if((function (){var and__3822__auto____11898 = coll;
if(and__3822__auto____11898)
{return coll.cljs$core$IReduce$_reduce$arity$3;
} else
{return and__3822__auto____11898;
}
})())
{return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else
{var x__4885__auto____11899 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11900 = (cljs.core._reduce[goog.typeOf(x__4885__auto____11899)]);
if(or__3824__auto____11900)
{return or__3824__auto____11900;
} else
{var or__3824__auto____11901 = (cljs.core._reduce["_"]);
if(or__3824__auto____11901)
{return or__3824__auto____11901;
} else
{throw cljs.core.missing_protocol.call(null,"IReduce.-reduce",coll);
}
}
})().call(null,coll,f,start);
}
});
_reduce = function(coll,f,start){
switch(arguments.length){
case 2:
return _reduce__2.call(this,coll,f);
case 3:
return _reduce__3.call(this,coll,f,start);
}
throw('Invalid arity: ' + arguments.length);
};
_reduce.cljs$lang$arity$2 = _reduce__2;
_reduce.cljs$lang$arity$3 = _reduce__3;
return _reduce;
})()
;
cljs.core.IKVReduce = {};
cljs.core._kv_reduce = (function _kv_reduce(coll,f,init){
if((function (){var and__3822__auto____11906 = coll;
if(and__3822__auto____11906)
{return coll.cljs$core$IKVReduce$_kv_reduce$arity$3;
} else
{return and__3822__auto____11906;
}
})())
{return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else
{var x__4885__auto____11907 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11908 = (cljs.core._kv_reduce[goog.typeOf(x__4885__auto____11907)]);
if(or__3824__auto____11908)
{return or__3824__auto____11908;
} else
{var or__3824__auto____11909 = (cljs.core._kv_reduce["_"]);
if(or__3824__auto____11909)
{return or__3824__auto____11909;
} else
{throw cljs.core.missing_protocol.call(null,"IKVReduce.-kv-reduce",coll);
}
}
})().call(null,coll,f,init);
}
});
cljs.core.IEquiv = {};
cljs.core._equiv = (function _equiv(o,other){
if((function (){var and__3822__auto____11914 = o;
if(and__3822__auto____11914)
{return o.cljs$core$IEquiv$_equiv$arity$2;
} else
{return and__3822__auto____11914;
}
})())
{return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else
{var x__4885__auto____11915 = (((o == null))?null:o);
return (function (){var or__3824__auto____11916 = (cljs.core._equiv[goog.typeOf(x__4885__auto____11915)]);
if(or__3824__auto____11916)
{return or__3824__auto____11916;
} else
{var or__3824__auto____11917 = (cljs.core._equiv["_"]);
if(or__3824__auto____11917)
{return or__3824__auto____11917;
} else
{throw cljs.core.missing_protocol.call(null,"IEquiv.-equiv",o);
}
}
})().call(null,o,other);
}
});
cljs.core.IHash = {};
cljs.core._hash = (function _hash(o){
if((function (){var and__3822__auto____11922 = o;
if(and__3822__auto____11922)
{return o.cljs$core$IHash$_hash$arity$1;
} else
{return and__3822__auto____11922;
}
})())
{return o.cljs$core$IHash$_hash$arity$1(o);
} else
{var x__4885__auto____11923 = (((o == null))?null:o);
return (function (){var or__3824__auto____11924 = (cljs.core._hash[goog.typeOf(x__4885__auto____11923)]);
if(or__3824__auto____11924)
{return or__3824__auto____11924;
} else
{var or__3824__auto____11925 = (cljs.core._hash["_"]);
if(or__3824__auto____11925)
{return or__3824__auto____11925;
} else
{throw cljs.core.missing_protocol.call(null,"IHash.-hash",o);
}
}
})().call(null,o);
}
});
cljs.core.ISeqable = {};
cljs.core._seq = (function _seq(o){
if((function (){var and__3822__auto____11930 = o;
if(and__3822__auto____11930)
{return o.cljs$core$ISeqable$_seq$arity$1;
} else
{return and__3822__auto____11930;
}
})())
{return o.cljs$core$ISeqable$_seq$arity$1(o);
} else
{var x__4885__auto____11931 = (((o == null))?null:o);
return (function (){var or__3824__auto____11932 = (cljs.core._seq[goog.typeOf(x__4885__auto____11931)]);
if(or__3824__auto____11932)
{return or__3824__auto____11932;
} else
{var or__3824__auto____11933 = (cljs.core._seq["_"]);
if(or__3824__auto____11933)
{return or__3824__auto____11933;
} else
{throw cljs.core.missing_protocol.call(null,"ISeqable.-seq",o);
}
}
})().call(null,o);
}
});
cljs.core.ISequential = {};
cljs.core.IList = {};
cljs.core.IRecord = {};
cljs.core.IReversible = {};
cljs.core._rseq = (function _rseq(coll){
if((function (){var and__3822__auto____11938 = coll;
if(and__3822__auto____11938)
{return coll.cljs$core$IReversible$_rseq$arity$1;
} else
{return and__3822__auto____11938;
}
})())
{return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else
{var x__4885__auto____11939 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11940 = (cljs.core._rseq[goog.typeOf(x__4885__auto____11939)]);
if(or__3824__auto____11940)
{return or__3824__auto____11940;
} else
{var or__3824__auto____11941 = (cljs.core._rseq["_"]);
if(or__3824__auto____11941)
{return or__3824__auto____11941;
} else
{throw cljs.core.missing_protocol.call(null,"IReversible.-rseq",coll);
}
}
})().call(null,coll);
}
});
cljs.core.ISorted = {};
cljs.core._sorted_seq = (function _sorted_seq(coll,ascending_QMARK_){
if((function (){var and__3822__auto____11946 = coll;
if(and__3822__auto____11946)
{return coll.cljs$core$ISorted$_sorted_seq$arity$2;
} else
{return and__3822__auto____11946;
}
})())
{return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else
{var x__4885__auto____11947 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11948 = (cljs.core._sorted_seq[goog.typeOf(x__4885__auto____11947)]);
if(or__3824__auto____11948)
{return or__3824__auto____11948;
} else
{var or__3824__auto____11949 = (cljs.core._sorted_seq["_"]);
if(or__3824__auto____11949)
{return or__3824__auto____11949;
} else
{throw cljs.core.missing_protocol.call(null,"ISorted.-sorted-seq",coll);
}
}
})().call(null,coll,ascending_QMARK_);
}
});
cljs.core._sorted_seq_from = (function _sorted_seq_from(coll,k,ascending_QMARK_){
if((function (){var and__3822__auto____11954 = coll;
if(and__3822__auto____11954)
{return coll.cljs$core$ISorted$_sorted_seq_from$arity$3;
} else
{return and__3822__auto____11954;
}
})())
{return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else
{var x__4885__auto____11955 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11956 = (cljs.core._sorted_seq_from[goog.typeOf(x__4885__auto____11955)]);
if(or__3824__auto____11956)
{return or__3824__auto____11956;
} else
{var or__3824__auto____11957 = (cljs.core._sorted_seq_from["_"]);
if(or__3824__auto____11957)
{return or__3824__auto____11957;
} else
{throw cljs.core.missing_protocol.call(null,"ISorted.-sorted-seq-from",coll);
}
}
})().call(null,coll,k,ascending_QMARK_);
}
});
cljs.core._entry_key = (function _entry_key(coll,entry){
if((function (){var and__3822__auto____11962 = coll;
if(and__3822__auto____11962)
{return coll.cljs$core$ISorted$_entry_key$arity$2;
} else
{return and__3822__auto____11962;
}
})())
{return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else
{var x__4885__auto____11963 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11964 = (cljs.core._entry_key[goog.typeOf(x__4885__auto____11963)]);
if(or__3824__auto____11964)
{return or__3824__auto____11964;
} else
{var or__3824__auto____11965 = (cljs.core._entry_key["_"]);
if(or__3824__auto____11965)
{return or__3824__auto____11965;
} else
{throw cljs.core.missing_protocol.call(null,"ISorted.-entry-key",coll);
}
}
})().call(null,coll,entry);
}
});
cljs.core._comparator = (function _comparator(coll){
if((function (){var and__3822__auto____11970 = coll;
if(and__3822__auto____11970)
{return coll.cljs$core$ISorted$_comparator$arity$1;
} else
{return and__3822__auto____11970;
}
})())
{return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else
{var x__4885__auto____11971 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____11972 = (cljs.core._comparator[goog.typeOf(x__4885__auto____11971)]);
if(or__3824__auto____11972)
{return or__3824__auto____11972;
} else
{var or__3824__auto____11973 = (cljs.core._comparator["_"]);
if(or__3824__auto____11973)
{return or__3824__auto____11973;
} else
{throw cljs.core.missing_protocol.call(null,"ISorted.-comparator",coll);
}
}
})().call(null,coll);
}
});
cljs.core.IPrintable = {};
cljs.core._pr_seq = (function _pr_seq(o,opts){
if((function (){var and__3822__auto____11978 = o;
if(and__3822__auto____11978)
{return o.cljs$core$IPrintable$_pr_seq$arity$2;
} else
{return and__3822__auto____11978;
}
})())
{return o.cljs$core$IPrintable$_pr_seq$arity$2(o,opts);
} else
{var x__4885__auto____11979 = (((o == null))?null:o);
return (function (){var or__3824__auto____11980 = (cljs.core._pr_seq[goog.typeOf(x__4885__auto____11979)]);
if(or__3824__auto____11980)
{return or__3824__auto____11980;
} else
{var or__3824__auto____11981 = (cljs.core._pr_seq["_"]);
if(or__3824__auto____11981)
{return or__3824__auto____11981;
} else
{throw cljs.core.missing_protocol.call(null,"IPrintable.-pr-seq",o);
}
}
})().call(null,o,opts);
}
});
cljs.core.IPending = {};
cljs.core._realized_QMARK_ = (function _realized_QMARK_(d){
if((function (){var and__3822__auto____11986 = d;
if(and__3822__auto____11986)
{return d.cljs$core$IPending$_realized_QMARK_$arity$1;
} else
{return and__3822__auto____11986;
}
})())
{return d.cljs$core$IPending$_realized_QMARK_$arity$1(d);
} else
{var x__4885__auto____11987 = (((d == null))?null:d);
return (function (){var or__3824__auto____11988 = (cljs.core._realized_QMARK_[goog.typeOf(x__4885__auto____11987)]);
if(or__3824__auto____11988)
{return or__3824__auto____11988;
} else
{var or__3824__auto____11989 = (cljs.core._realized_QMARK_["_"]);
if(or__3824__auto____11989)
{return or__3824__auto____11989;
} else
{throw cljs.core.missing_protocol.call(null,"IPending.-realized?",d);
}
}
})().call(null,d);
}
});
cljs.core.IWatchable = {};
cljs.core._notify_watches = (function _notify_watches(this$,oldval,newval){
if((function (){var and__3822__auto____11994 = this$;
if(and__3822__auto____11994)
{return this$.cljs$core$IWatchable$_notify_watches$arity$3;
} else
{return and__3822__auto____11994;
}
})())
{return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else
{var x__4885__auto____11995 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____11996 = (cljs.core._notify_watches[goog.typeOf(x__4885__auto____11995)]);
if(or__3824__auto____11996)
{return or__3824__auto____11996;
} else
{var or__3824__auto____11997 = (cljs.core._notify_watches["_"]);
if(or__3824__auto____11997)
{return or__3824__auto____11997;
} else
{throw cljs.core.missing_protocol.call(null,"IWatchable.-notify-watches",this$);
}
}
})().call(null,this$,oldval,newval);
}
});
cljs.core._add_watch = (function _add_watch(this$,key,f){
if((function (){var and__3822__auto____12002 = this$;
if(and__3822__auto____12002)
{return this$.cljs$core$IWatchable$_add_watch$arity$3;
} else
{return and__3822__auto____12002;
}
})())
{return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else
{var x__4885__auto____12003 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____12004 = (cljs.core._add_watch[goog.typeOf(x__4885__auto____12003)]);
if(or__3824__auto____12004)
{return or__3824__auto____12004;
} else
{var or__3824__auto____12005 = (cljs.core._add_watch["_"]);
if(or__3824__auto____12005)
{return or__3824__auto____12005;
} else
{throw cljs.core.missing_protocol.call(null,"IWatchable.-add-watch",this$);
}
}
})().call(null,this$,key,f);
}
});
cljs.core._remove_watch = (function _remove_watch(this$,key){
if((function (){var and__3822__auto____12010 = this$;
if(and__3822__auto____12010)
{return this$.cljs$core$IWatchable$_remove_watch$arity$2;
} else
{return and__3822__auto____12010;
}
})())
{return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else
{var x__4885__auto____12011 = (((this$ == null))?null:this$);
return (function (){var or__3824__auto____12012 = (cljs.core._remove_watch[goog.typeOf(x__4885__auto____12011)]);
if(or__3824__auto____12012)
{return or__3824__auto____12012;
} else
{var or__3824__auto____12013 = (cljs.core._remove_watch["_"]);
if(or__3824__auto____12013)
{return or__3824__auto____12013;
} else
{throw cljs.core.missing_protocol.call(null,"IWatchable.-remove-watch",this$);
}
}
})().call(null,this$,key);
}
});
cljs.core.IEditableCollection = {};
cljs.core._as_transient = (function _as_transient(coll){
if((function (){var and__3822__auto____12018 = coll;
if(and__3822__auto____12018)
{return coll.cljs$core$IEditableCollection$_as_transient$arity$1;
} else
{return and__3822__auto____12018;
}
})())
{return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else
{var x__4885__auto____12019 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____12020 = (cljs.core._as_transient[goog.typeOf(x__4885__auto____12019)]);
if(or__3824__auto____12020)
{return or__3824__auto____12020;
} else
{var or__3824__auto____12021 = (cljs.core._as_transient["_"]);
if(or__3824__auto____12021)
{return or__3824__auto____12021;
} else
{throw cljs.core.missing_protocol.call(null,"IEditableCollection.-as-transient",coll);
}
}
})().call(null,coll);
}
});
cljs.core.ITransientCollection = {};
cljs.core._conj_BANG_ = (function _conj_BANG_(tcoll,val){
if((function (){var and__3822__auto____12026 = tcoll;
if(and__3822__auto____12026)
{return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2;
} else
{return and__3822__auto____12026;
}
})())
{return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else
{var x__4885__auto____12027 = (((tcoll == null))?null:tcoll);
return (function (){var or__3824__auto____12028 = (cljs.core._conj_BANG_[goog.typeOf(x__4885__auto____12027)]);
if(or__3824__auto____12028)
{return or__3824__auto____12028;
} else
{var or__3824__auto____12029 = (cljs.core._conj_BANG_["_"]);
if(or__3824__auto____12029)
{return or__3824__auto____12029;
} else
{throw cljs.core.missing_protocol.call(null,"ITransientCollection.-conj!",tcoll);
}
}
})().call(null,tcoll,val);
}
});
cljs.core._persistent_BANG_ = (function _persistent_BANG_(tcoll){
if((function (){var and__3822__auto____12034 = tcoll;
if(and__3822__auto____12034)
{return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1;
} else
{return and__3822__auto____12034;
}
})())
{return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else
{var x__4885__auto____12035 = (((tcoll == null))?null:tcoll);
return (function (){var or__3824__auto____12036 = (cljs.core._persistent_BANG_[goog.typeOf(x__4885__auto____12035)]);
if(or__3824__auto____12036)
{return or__3824__auto____12036;
} else
{var or__3824__auto____12037 = (cljs.core._persistent_BANG_["_"]);
if(or__3824__auto____12037)
{return or__3824__auto____12037;
} else
{throw cljs.core.missing_protocol.call(null,"ITransientCollection.-persistent!",tcoll);
}
}
})().call(null,tcoll);
}
});
cljs.core.ITransientAssociative = {};
cljs.core._assoc_BANG_ = (function _assoc_BANG_(tcoll,key,val){
if((function (){var and__3822__auto____12042 = tcoll;
if(and__3822__auto____12042)
{return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3;
} else
{return and__3822__auto____12042;
}
})())
{return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else
{var x__4885__auto____12043 = (((tcoll == null))?null:tcoll);
return (function (){var or__3824__auto____12044 = (cljs.core._assoc_BANG_[goog.typeOf(x__4885__auto____12043)]);
if(or__3824__auto____12044)
{return or__3824__auto____12044;
} else
{var or__3824__auto____12045 = (cljs.core._assoc_BANG_["_"]);
if(or__3824__auto____12045)
{return or__3824__auto____12045;
} else
{throw cljs.core.missing_protocol.call(null,"ITransientAssociative.-assoc!",tcoll);
}
}
})().call(null,tcoll,key,val);
}
});
cljs.core.ITransientMap = {};
cljs.core._dissoc_BANG_ = (function _dissoc_BANG_(tcoll,key){
if((function (){var and__3822__auto____12050 = tcoll;
if(and__3822__auto____12050)
{return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2;
} else
{return and__3822__auto____12050;
}
})())
{return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else
{var x__4885__auto____12051 = (((tcoll == null))?null:tcoll);
return (function (){var or__3824__auto____12052 = (cljs.core._dissoc_BANG_[goog.typeOf(x__4885__auto____12051)]);
if(or__3824__auto____12052)
{return or__3824__auto____12052;
} else
{var or__3824__auto____12053 = (cljs.core._dissoc_BANG_["_"]);
if(or__3824__auto____12053)
{return or__3824__auto____12053;
} else
{throw cljs.core.missing_protocol.call(null,"ITransientMap.-dissoc!",tcoll);
}
}
})().call(null,tcoll,key);
}
});
cljs.core.ITransientVector = {};
cljs.core._assoc_n_BANG_ = (function _assoc_n_BANG_(tcoll,n,val){
if((function (){var and__3822__auto____12058 = tcoll;
if(and__3822__auto____12058)
{return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3;
} else
{return and__3822__auto____12058;
}
})())
{return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else
{var x__4885__auto____12059 = (((tcoll == null))?null:tcoll);
return (function (){var or__3824__auto____12060 = (cljs.core._assoc_n_BANG_[goog.typeOf(x__4885__auto____12059)]);
if(or__3824__auto____12060)
{return or__3824__auto____12060;
} else
{var or__3824__auto____12061 = (cljs.core._assoc_n_BANG_["_"]);
if(or__3824__auto____12061)
{return or__3824__auto____12061;
} else
{throw cljs.core.missing_protocol.call(null,"ITransientVector.-assoc-n!",tcoll);
}
}
})().call(null,tcoll,n,val);
}
});
cljs.core._pop_BANG_ = (function _pop_BANG_(tcoll){
if((function (){var and__3822__auto____12066 = tcoll;
if(and__3822__auto____12066)
{return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1;
} else
{return and__3822__auto____12066;
}
})())
{return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else
{var x__4885__auto____12067 = (((tcoll == null))?null:tcoll);
return (function (){var or__3824__auto____12068 = (cljs.core._pop_BANG_[goog.typeOf(x__4885__auto____12067)]);
if(or__3824__auto____12068)
{return or__3824__auto____12068;
} else
{var or__3824__auto____12069 = (cljs.core._pop_BANG_["_"]);
if(or__3824__auto____12069)
{return or__3824__auto____12069;
} else
{throw cljs.core.missing_protocol.call(null,"ITransientVector.-pop!",tcoll);
}
}
})().call(null,tcoll);
}
});
cljs.core.ITransientSet = {};
cljs.core._disjoin_BANG_ = (function _disjoin_BANG_(tcoll,v){
if((function (){var and__3822__auto____12074 = tcoll;
if(and__3822__auto____12074)
{return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2;
} else
{return and__3822__auto____12074;
}
})())
{return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else
{var x__4885__auto____12075 = (((tcoll == null))?null:tcoll);
return (function (){var or__3824__auto____12076 = (cljs.core._disjoin_BANG_[goog.typeOf(x__4885__auto____12075)]);
if(or__3824__auto____12076)
{return or__3824__auto____12076;
} else
{var or__3824__auto____12077 = (cljs.core._disjoin_BANG_["_"]);
if(or__3824__auto____12077)
{return or__3824__auto____12077;
} else
{throw cljs.core.missing_protocol.call(null,"ITransientSet.-disjoin!",tcoll);
}
}
})().call(null,tcoll,v);
}
});
cljs.core.IComparable = {};
cljs.core._compare = (function _compare(x,y){
if((function (){var and__3822__auto____12082 = x;
if(and__3822__auto____12082)
{return x.cljs$core$IComparable$_compare$arity$2;
} else
{return and__3822__auto____12082;
}
})())
{return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else
{var x__4885__auto____12083 = (((x == null))?null:x);
return (function (){var or__3824__auto____12084 = (cljs.core._compare[goog.typeOf(x__4885__auto____12083)]);
if(or__3824__auto____12084)
{return or__3824__auto____12084;
} else
{var or__3824__auto____12085 = (cljs.core._compare["_"]);
if(or__3824__auto____12085)
{return or__3824__auto____12085;
} else
{throw cljs.core.missing_protocol.call(null,"IComparable.-compare",x);
}
}
})().call(null,x,y);
}
});
cljs.core.IChunk = {};
cljs.core._drop_first = (function _drop_first(coll){
if((function (){var and__3822__auto____12090 = coll;
if(and__3822__auto____12090)
{return coll.cljs$core$IChunk$_drop_first$arity$1;
} else
{return and__3822__auto____12090;
}
})())
{return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else
{var x__4885__auto____12091 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____12092 = (cljs.core._drop_first[goog.typeOf(x__4885__auto____12091)]);
if(or__3824__auto____12092)
{return or__3824__auto____12092;
} else
{var or__3824__auto____12093 = (cljs.core._drop_first["_"]);
if(or__3824__auto____12093)
{return or__3824__auto____12093;
} else
{throw cljs.core.missing_protocol.call(null,"IChunk.-drop-first",coll);
}
}
})().call(null,coll);
}
});
cljs.core.IChunkedSeq = {};
cljs.core._chunked_first = (function _chunked_first(coll){
if((function (){var and__3822__auto____12098 = coll;
if(and__3822__auto____12098)
{return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1;
} else
{return and__3822__auto____12098;
}
})())
{return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else
{var x__4885__auto____12099 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____12100 = (cljs.core._chunked_first[goog.typeOf(x__4885__auto____12099)]);
if(or__3824__auto____12100)
{return or__3824__auto____12100;
} else
{var or__3824__auto____12101 = (cljs.core._chunked_first["_"]);
if(or__3824__auto____12101)
{return or__3824__auto____12101;
} else
{throw cljs.core.missing_protocol.call(null,"IChunkedSeq.-chunked-first",coll);
}
}
})().call(null,coll);
}
});
cljs.core._chunked_rest = (function _chunked_rest(coll){
if((function (){var and__3822__auto____12106 = coll;
if(and__3822__auto____12106)
{return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1;
} else
{return and__3822__auto____12106;
}
})())
{return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else
{var x__4885__auto____12107 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____12108 = (cljs.core._chunked_rest[goog.typeOf(x__4885__auto____12107)]);
if(or__3824__auto____12108)
{return or__3824__auto____12108;
} else
{var or__3824__auto____12109 = (cljs.core._chunked_rest["_"]);
if(or__3824__auto____12109)
{return or__3824__auto____12109;
} else
{throw cljs.core.missing_protocol.call(null,"IChunkedSeq.-chunked-rest",coll);
}
}
})().call(null,coll);
}
});
cljs.core.IChunkedNext = {};
cljs.core._chunked_next = (function _chunked_next(coll){
if((function (){var and__3822__auto____12114 = coll;
if(and__3822__auto____12114)
{return coll.cljs$core$IChunkedNext$_chunked_next$arity$1;
} else
{return and__3822__auto____12114;
}
})())
{return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else
{var x__4885__auto____12115 = (((coll == null))?null:coll);
return (function (){var or__3824__auto____12116 = (cljs.core._chunked_next[goog.typeOf(x__4885__auto____12115)]);
if(or__3824__auto____12116)
{return or__3824__auto____12116;
} else
{var or__3824__auto____12117 = (cljs.core._chunked_next["_"]);
if(or__3824__auto____12117)
{return or__3824__auto____12117;
} else
{throw cljs.core.missing_protocol.call(null,"IChunkedNext.-chunked-next",coll);
}
}
})().call(null,coll);
}
});
/**
* Tests if 2 arguments are the same object
*/
cljs.core.identical_QMARK_ = (function identical_QMARK_(x,y){
return (x === y);
});
/**
* Equality. Returns true if x equals y, false if not. Compares
* numbers and collections in a type-independent manner.  Clojure's immutable data
* structures define -equiv (and thus =) as a value, not an identity,
* comparison.
* @param {...*} var_args
*/
cljs.core._EQ_ = (function() {
var _EQ_ = null;
var _EQ___1 = (function (x){
return true;
});
var _EQ___2 = (function (x,y){
var or__3824__auto____12119 = (x === y);
if(or__3824__auto____12119)
{return or__3824__auto____12119;
} else
{return cljs.core._equiv.call(null,x,y);
}
});
var _EQ___3 = (function() { 
var G__12120__delegate = function (x,y,more){
while(true){
if(cljs.core.truth_(_EQ_.call(null,x,y)))
{if(cljs.core.next.call(null,more))
{{
var G__12121 = y;
var G__12122 = cljs.core.first.call(null,more);
var G__12123 = cljs.core.next.call(null,more);
x = G__12121;
y = G__12122;
more = G__12123;
continue;
}
} else
{return _EQ_.call(null,y,cljs.core.first.call(null,more));
}
} else
{return false;
}
break;
}
};
var G__12120 = function (x,y,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12120__delegate.call(this, x, y, more);
};
G__12120.cljs$lang$maxFixedArity = 2;
G__12120.cljs$lang$applyTo = (function (arglist__12124){
var x = cljs.core.first(arglist__12124);
var y = cljs.core.first(cljs.core.next(arglist__12124));
var more = cljs.core.rest(cljs.core.next(arglist__12124));
return G__12120__delegate(x, y, more);
});
G__12120.cljs$lang$arity$variadic = G__12120__delegate;
return G__12120;
})()
;
_EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _EQ___1.call(this,x);
case 2:
return _EQ___2.call(this,x,y);
default:
return _EQ___3.cljs$lang$arity$variadic(x,y, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
_EQ_.cljs$lang$maxFixedArity = 2;
_EQ_.cljs$lang$applyTo = _EQ___3.cljs$lang$applyTo;
_EQ_.cljs$lang$arity$1 = _EQ___1;
_EQ_.cljs$lang$arity$2 = _EQ___2;
_EQ_.cljs$lang$arity$variadic = _EQ___3.cljs$lang$arity$variadic;
return _EQ_;
})()
;
/**
* Returns true if x is nil, false otherwise.
*/
cljs.core.nil_QMARK_ = (function nil_QMARK_(x){
return (x == null);
});
cljs.core.type = (function type(x){
if((x == null))
{return null;
} else
{return x.constructor;
}
});
cljs.core.instance_QMARK_ = (function instance_QMARK_(t,o){
return (o instanceof t);
});
(cljs.core.IHash["null"] = true);
(cljs.core._hash["null"] = (function (o){
return 0;
}));
(cljs.core.ILookup["null"] = true);
(cljs.core._lookup["null"] = (function() {
var G__12125 = null;
var G__12125__2 = (function (o,k){
return null;
});
var G__12125__3 = (function (o,k,not_found){
return not_found;
});
G__12125 = function(o,k,not_found){
switch(arguments.length){
case 2:
return G__12125__2.call(this,o,k);
case 3:
return G__12125__3.call(this,o,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__12125;
})()
);
(cljs.core.IAssociative["null"] = true);
(cljs.core._assoc["null"] = (function (_,k,v){
return cljs.core.hash_map.call(null,k,v);
}));
(cljs.core.INext["null"] = true);
(cljs.core._next["null"] = (function (_){
return null;
}));
(cljs.core.ICollection["null"] = true);
(cljs.core._conj["null"] = (function (_,o){
return cljs.core.list.call(null,o);
}));
(cljs.core.IReduce["null"] = true);
(cljs.core._reduce["null"] = (function() {
var G__12126 = null;
var G__12126__2 = (function (_,f){
return f.call(null);
});
var G__12126__3 = (function (_,f,start){
return start;
});
G__12126 = function(_,f,start){
switch(arguments.length){
case 2:
return G__12126__2.call(this,_,f);
case 3:
return G__12126__3.call(this,_,f,start);
}
throw('Invalid arity: ' + arguments.length);
};
return G__12126;
})()
);
(cljs.core.IPrintable["null"] = true);
(cljs.core._pr_seq["null"] = (function (o){
return cljs.core.list.call(null,"nil");
}));
(cljs.core.ISet["null"] = true);
(cljs.core._disjoin["null"] = (function (_,v){
return null;
}));
(cljs.core.ICounted["null"] = true);
(cljs.core._count["null"] = (function (_){
return 0;
}));
(cljs.core.IStack["null"] = true);
(cljs.core._peek["null"] = (function (_){
return null;
}));
(cljs.core._pop["null"] = (function (_){
return null;
}));
(cljs.core.ISeq["null"] = true);
(cljs.core._first["null"] = (function (_){
return null;
}));
(cljs.core._rest["null"] = (function (_){
return cljs.core.list.call(null);
}));
(cljs.core.IEquiv["null"] = true);
(cljs.core._equiv["null"] = (function (_,o){
return (o == null);
}));
(cljs.core.IWithMeta["null"] = true);
(cljs.core._with_meta["null"] = (function (_,meta){
return null;
}));
(cljs.core.IMeta["null"] = true);
(cljs.core._meta["null"] = (function (_){
return null;
}));
(cljs.core.IIndexed["null"] = true);
(cljs.core._nth["null"] = (function() {
var G__12127 = null;
var G__12127__2 = (function (_,n){
return null;
});
var G__12127__3 = (function (_,n,not_found){
return not_found;
});
G__12127 = function(_,n,not_found){
switch(arguments.length){
case 2:
return G__12127__2.call(this,_,n);
case 3:
return G__12127__3.call(this,_,n,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__12127;
})()
);
(cljs.core.IEmptyableCollection["null"] = true);
(cljs.core._empty["null"] = (function (_){
return null;
}));
(cljs.core.IMap["null"] = true);
(cljs.core._dissoc["null"] = (function (_,k){
return null;
}));
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var and__3822__auto____12128 = cljs.core.instance_QMARK_.call(null,Date,other);
if(and__3822__auto____12128)
{return (o.toString() === other.toString());
} else
{return and__3822__auto____12128;
}
});
(cljs.core.IHash["number"] = true);
(cljs.core._hash["number"] = (function (o){
return o;
}));
(cljs.core.IEquiv["number"] = true);
(cljs.core._equiv["number"] = (function (x,o){
return (x === o);
}));
(cljs.core.IHash["boolean"] = true);
(cljs.core._hash["boolean"] = (function (o){
if((o === true))
{return 1;
} else
{return 0;
}
}));
(cljs.core.IHash["_"] = true);
(cljs.core._hash["_"] = (function (o){
return goog.getUid(o);
}));
/**
* Returns a number one greater than num.
*/
cljs.core.inc = (function inc(x){
return (x + 1);
});
/**
* Accepts any collection which satisfies the ICount and IIndexed protocols and
* reduces them without incurring seq initialization
*/
cljs.core.ci_reduce = (function() {
var ci_reduce = null;
var ci_reduce__2 = (function (cicoll,f){
var cnt__12141 = cljs.core._count.call(null,cicoll);
if((cnt__12141 === 0))
{return f.call(null);
} else
{var val__12142 = cljs.core._nth.call(null,cicoll,0);
var n__12143 = 1;
while(true){
if((n__12143 < cnt__12141))
{var nval__12144 = f.call(null,val__12142,cljs.core._nth.call(null,cicoll,n__12143));
if(cljs.core.reduced_QMARK_.call(null,nval__12144))
{return cljs.core.deref.call(null,nval__12144);
} else
{{
var G__12153 = nval__12144;
var G__12154 = (n__12143 + 1);
val__12142 = G__12153;
n__12143 = G__12154;
continue;
}
}
} else
{return val__12142;
}
break;
}
}
});
var ci_reduce__3 = (function (cicoll,f,val){
var cnt__12145 = cljs.core._count.call(null,cicoll);
var val__12146 = val;
var n__12147 = 0;
while(true){
if((n__12147 < cnt__12145))
{var nval__12148 = f.call(null,val__12146,cljs.core._nth.call(null,cicoll,n__12147));
if(cljs.core.reduced_QMARK_.call(null,nval__12148))
{return cljs.core.deref.call(null,nval__12148);
} else
{{
var G__12155 = nval__12148;
var G__12156 = (n__12147 + 1);
val__12146 = G__12155;
n__12147 = G__12156;
continue;
}
}
} else
{return val__12146;
}
break;
}
});
var ci_reduce__4 = (function (cicoll,f,val,idx){
var cnt__12149 = cljs.core._count.call(null,cicoll);
var val__12150 = val;
var n__12151 = idx;
while(true){
if((n__12151 < cnt__12149))
{var nval__12152 = f.call(null,val__12150,cljs.core._nth.call(null,cicoll,n__12151));
if(cljs.core.reduced_QMARK_.call(null,nval__12152))
{return cljs.core.deref.call(null,nval__12152);
} else
{{
var G__12157 = nval__12152;
var G__12158 = (n__12151 + 1);
val__12150 = G__12157;
n__12151 = G__12158;
continue;
}
}
} else
{return val__12150;
}
break;
}
});
ci_reduce = function(cicoll,f,val,idx){
switch(arguments.length){
case 2:
return ci_reduce__2.call(this,cicoll,f);
case 3:
return ci_reduce__3.call(this,cicoll,f,val);
case 4:
return ci_reduce__4.call(this,cicoll,f,val,idx);
}
throw('Invalid arity: ' + arguments.length);
};
ci_reduce.cljs$lang$arity$2 = ci_reduce__2;
ci_reduce.cljs$lang$arity$3 = ci_reduce__3;
ci_reduce.cljs$lang$arity$4 = ci_reduce__4;
return ci_reduce;
})()
;
cljs.core.array_reduce = (function() {
var array_reduce = null;
var array_reduce__2 = (function (arr,f){
var cnt__12171 = arr.length;
if((arr.length === 0))
{return f.call(null);
} else
{var val__12172 = (arr[0]);
var n__12173 = 1;
while(true){
if((n__12173 < cnt__12171))
{var nval__12174 = f.call(null,val__12172,(arr[n__12173]));
if(cljs.core.reduced_QMARK_.call(null,nval__12174))
{return cljs.core.deref.call(null,nval__12174);
} else
{{
var G__12183 = nval__12174;
var G__12184 = (n__12173 + 1);
val__12172 = G__12183;
n__12173 = G__12184;
continue;
}
}
} else
{return val__12172;
}
break;
}
}
});
var array_reduce__3 = (function (arr,f,val){
var cnt__12175 = arr.length;
var val__12176 = val;
var n__12177 = 0;
while(true){
if((n__12177 < cnt__12175))
{var nval__12178 = f.call(null,val__12176,(arr[n__12177]));
if(cljs.core.reduced_QMARK_.call(null,nval__12178))
{return cljs.core.deref.call(null,nval__12178);
} else
{{
var G__12185 = nval__12178;
var G__12186 = (n__12177 + 1);
val__12176 = G__12185;
n__12177 = G__12186;
continue;
}
}
} else
{return val__12176;
}
break;
}
});
var array_reduce__4 = (function (arr,f,val,idx){
var cnt__12179 = arr.length;
var val__12180 = val;
var n__12181 = idx;
while(true){
if((n__12181 < cnt__12179))
{var nval__12182 = f.call(null,val__12180,(arr[n__12181]));
if(cljs.core.reduced_QMARK_.call(null,nval__12182))
{return cljs.core.deref.call(null,nval__12182);
} else
{{
var G__12187 = nval__12182;
var G__12188 = (n__12181 + 1);
val__12180 = G__12187;
n__12181 = G__12188;
continue;
}
}
} else
{return val__12180;
}
break;
}
});
array_reduce = function(arr,f,val,idx){
switch(arguments.length){
case 2:
return array_reduce__2.call(this,arr,f);
case 3:
return array_reduce__3.call(this,arr,f,val);
case 4:
return array_reduce__4.call(this,arr,f,val,idx);
}
throw('Invalid arity: ' + arguments.length);
};
array_reduce.cljs$lang$arity$2 = array_reduce__2;
array_reduce.cljs$lang$arity$3 = array_reduce__3;
array_reduce.cljs$lang$arity$4 = array_reduce__4;
return array_reduce;
})()
;

/**
* @constructor
*/
cljs.core.IndexedSeq = (function (a,i){
this.a = a;
this.i = i;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 166199546;
})
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/IndexedSeq");
});
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__12189 = this;
return cljs.core.hash_coll.call(null,coll);
});
cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var this__12190 = this;
if(((this__12190.i + 1) < this__12190.a.length))
{return (new cljs.core.IndexedSeq(this__12190.a,(this__12190.i + 1)));
} else
{return null;
}
});
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var this__12191 = this;
return cljs.core.cons.call(null,o,coll);
});
cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var this__12192 = this;
var c__12193 = coll.cljs$core$ICounted$_count$arity$1(coll);
if((c__12193 > 0))
{return (new cljs.core.RSeq(coll,(c__12193 - 1),null));
} else
{return cljs.core.List.EMPTY;
}
});
cljs.core.IndexedSeq.prototype.toString = (function (){
var this__12194 = this;
var this__12195 = this;
return cljs.core.pr_str.call(null,this__12195);
});
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var this__12196 = this;
if(cljs.core.counted_QMARK_.call(null,this__12196.a))
{return cljs.core.ci_reduce.call(null,this__12196.a,f,(this__12196.a[this__12196.i]),(this__12196.i + 1));
} else
{return cljs.core.ci_reduce.call(null,coll,f,(this__12196.a[this__12196.i]),0);
}
});
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var this__12197 = this;
if(cljs.core.counted_QMARK_.call(null,this__12197.a))
{return cljs.core.ci_reduce.call(null,this__12197.a,f,start,this__12197.i);
} else
{return cljs.core.ci_reduce.call(null,coll,f,start,0);
}
});
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var this__12198 = this;
return this$;
});
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var this__12199 = this;
return (this__12199.a.length - this__12199.i);
});
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var this__12200 = this;
return (this__12200.a[this__12200.i]);
});
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var this__12201 = this;
if(((this__12201.i + 1) < this__12201.a.length))
{return (new cljs.core.IndexedSeq(this__12201.a,(this__12201.i + 1)));
} else
{return cljs.core.list.call(null);
}
});
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__12202 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var this__12203 = this;
var i__12204 = (n + this__12203.i);
if((i__12204 < this__12203.a.length))
{return (this__12203.a[i__12204]);
} else
{return null;
}
});
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var this__12205 = this;
var i__12206 = (n + this__12205.i);
if((i__12206 < this__12205.a.length))
{return (this__12205.a[i__12206]);
} else
{return not_found;
}
});
cljs.core.IndexedSeq;
cljs.core.prim_seq = (function() {
var prim_seq = null;
var prim_seq__1 = (function (prim){
return prim_seq.call(null,prim,0);
});
var prim_seq__2 = (function (prim,i){
if((prim.length === 0))
{return null;
} else
{return (new cljs.core.IndexedSeq(prim,i));
}
});
prim_seq = function(prim,i){
switch(arguments.length){
case 1:
return prim_seq__1.call(this,prim);
case 2:
return prim_seq__2.call(this,prim,i);
}
throw('Invalid arity: ' + arguments.length);
};
prim_seq.cljs$lang$arity$1 = prim_seq__1;
prim_seq.cljs$lang$arity$2 = prim_seq__2;
return prim_seq;
})()
;
cljs.core.array_seq = (function() {
var array_seq = null;
var array_seq__1 = (function (array){
return cljs.core.prim_seq.call(null,array,0);
});
var array_seq__2 = (function (array,i){
return cljs.core.prim_seq.call(null,array,i);
});
array_seq = function(array,i){
switch(arguments.length){
case 1:
return array_seq__1.call(this,array);
case 2:
return array_seq__2.call(this,array,i);
}
throw('Invalid arity: ' + arguments.length);
};
array_seq.cljs$lang$arity$1 = array_seq__1;
array_seq.cljs$lang$arity$2 = array_seq__2;
return array_seq;
})()
;
(cljs.core.IReduce["array"] = true);
(cljs.core._reduce["array"] = (function() {
var G__12207 = null;
var G__12207__2 = (function (array,f){
return cljs.core.ci_reduce.call(null,array,f);
});
var G__12207__3 = (function (array,f,start){
return cljs.core.ci_reduce.call(null,array,f,start);
});
G__12207 = function(array,f,start){
switch(arguments.length){
case 2:
return G__12207__2.call(this,array,f);
case 3:
return G__12207__3.call(this,array,f,start);
}
throw('Invalid arity: ' + arguments.length);
};
return G__12207;
})()
);
(cljs.core.ILookup["array"] = true);
(cljs.core._lookup["array"] = (function() {
var G__12208 = null;
var G__12208__2 = (function (array,k){
return (array[k]);
});
var G__12208__3 = (function (array,k,not_found){
return cljs.core._nth.call(null,array,k,not_found);
});
G__12208 = function(array,k,not_found){
switch(arguments.length){
case 2:
return G__12208__2.call(this,array,k);
case 3:
return G__12208__3.call(this,array,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__12208;
})()
);
(cljs.core.IIndexed["array"] = true);
(cljs.core._nth["array"] = (function() {
var G__12209 = null;
var G__12209__2 = (function (array,n){
if((n < array.length))
{return (array[n]);
} else
{return null;
}
});
var G__12209__3 = (function (array,n,not_found){
if((n < array.length))
{return (array[n]);
} else
{return not_found;
}
});
G__12209 = function(array,n,not_found){
switch(arguments.length){
case 2:
return G__12209__2.call(this,array,n);
case 3:
return G__12209__3.call(this,array,n,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__12209;
})()
);
(cljs.core.ICounted["array"] = true);
(cljs.core._count["array"] = (function (a){
return a.length;
}));
(cljs.core.ISeqable["array"] = true);
(cljs.core._seq["array"] = (function (array){
return cljs.core.array_seq.call(null,array,0);
}));

/**
* @constructor
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31850570;
})
cljs.core.RSeq.cljs$lang$type = true;
cljs.core.RSeq.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/RSeq");
});
cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__12210 = this;
return cljs.core.hash_coll.call(null,coll);
});
cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var this__12211 = this;
return cljs.core.cons.call(null,o,coll);
});
cljs.core.RSeq.prototype.toString = (function (){
var this__12212 = this;
var this__12213 = this;
return cljs.core.pr_str.call(null,this__12213);
});
cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__12214 = this;
return coll;
});
cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var this__12215 = this;
return (this__12215.i + 1);
});
cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var this__12216 = this;
return cljs.core._nth.call(null,this__12216.ci,this__12216.i);
});
cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var this__12217 = this;
if((this__12217.i > 0))
{return (new cljs.core.RSeq(this__12217.ci,(this__12217.i - 1),null));
} else
{return cljs.core.List.EMPTY;
}
});
cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__12218 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var this__12219 = this;
return (new cljs.core.RSeq(this__12219.ci,this__12219.i,new_meta));
});
cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__12220 = this;
return this__12220.meta;
});
cljs.core.RSeq;
/**
* Returns a seq on the collection. If the collection is
* empty, returns nil.  (seq nil) returns nil. seq also works on
* Strings.
*/
cljs.core.seq = (function seq(coll){
if((coll == null))
{return null;
} else
{if((function (){var G__12224__12225 = coll;
if(G__12224__12225)
{if((function (){var or__3824__auto____12226 = (G__12224__12225.cljs$lang$protocol_mask$partition0$ & 32);
if(or__3824__auto____12226)
{return or__3824__auto____12226;
} else
{return G__12224__12225.cljs$core$ASeq$;
}
})())
{return true;
} else
{if((!G__12224__12225.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.ASeq,G__12224__12225);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.ASeq,G__12224__12225);
}
})())
{return coll;
} else
{return cljs.core._seq.call(null,coll);
}
}
});
/**
* Returns the first item in the collection. Calls seq on its
* argument. If coll is nil, returns nil.
*/
cljs.core.first = (function first(coll){
if((coll == null))
{return null;
} else
{if((function (){var G__12231__12232 = coll;
if(G__12231__12232)
{if((function (){var or__3824__auto____12233 = (G__12231__12232.cljs$lang$protocol_mask$partition0$ & 64);
if(or__3824__auto____12233)
{return or__3824__auto____12233;
} else
{return G__12231__12232.cljs$core$ISeq$;
}
})())
{return true;
} else
{if((!G__12231__12232.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.ISeq,G__12231__12232);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.ISeq,G__12231__12232);
}
})())
{return cljs.core._first.call(null,coll);
} else
{var s__12234 = cljs.core.seq.call(null,coll);
if((s__12234 == null))
{return null;
} else
{return cljs.core._first.call(null,s__12234);
}
}
}
});
/**
* Returns a possibly empty seq of the items after the first. Calls seq on its
* argument.
*/
cljs.core.rest = (function rest(coll){
if(!((coll == null)))
{if((function (){var G__12239__12240 = coll;
if(G__12239__12240)
{if((function (){var or__3824__auto____12241 = (G__12239__12240.cljs$lang$protocol_mask$partition0$ & 64);
if(or__3824__auto____12241)
{return or__3824__auto____12241;
} else
{return G__12239__12240.cljs$core$ISeq$;
}
})())
{return true;
} else
{if((!G__12239__12240.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.ISeq,G__12239__12240);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.ISeq,G__12239__12240);
}
})())
{return cljs.core._rest.call(null,coll);
} else
{var s__12242 = cljs.core.seq.call(null,coll);
if(!((s__12242 == null)))
{return cljs.core._rest.call(null,s__12242);
} else
{return cljs.core.List.EMPTY;
}
}
} else
{return cljs.core.List.EMPTY;
}
});
/**
* Returns a seq of the items after the first. Calls seq on its
* argument.  If there are no more items, returns nil
*/
cljs.core.next = (function next(coll){
if((coll == null))
{return null;
} else
{if((function (){var G__12246__12247 = coll;
if(G__12246__12247)
{if((function (){var or__3824__auto____12248 = (G__12246__12247.cljs$lang$protocol_mask$partition0$ & 128);
if(or__3824__auto____12248)
{return or__3824__auto____12248;
} else
{return G__12246__12247.cljs$core$INext$;
}
})())
{return true;
} else
{if((!G__12246__12247.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.INext,G__12246__12247);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.INext,G__12246__12247);
}
})())
{return cljs.core._next.call(null,coll);
} else
{return cljs.core.seq.call(null,cljs.core.rest.call(null,coll));
}
}
});
/**
* Same as (first (next x))
*/
cljs.core.second = (function second(coll){
return cljs.core.first.call(null,cljs.core.next.call(null,coll));
});
/**
* Same as (first (first x))
*/
cljs.core.ffirst = (function ffirst(coll){
return cljs.core.first.call(null,cljs.core.first.call(null,coll));
});
/**
* Same as (next (first x))
*/
cljs.core.nfirst = (function nfirst(coll){
return cljs.core.next.call(null,cljs.core.first.call(null,coll));
});
/**
* Same as (first (next x))
*/
cljs.core.fnext = (function fnext(coll){
return cljs.core.first.call(null,cljs.core.next.call(null,coll));
});
/**
* Same as (next (next x))
*/
cljs.core.nnext = (function nnext(coll){
return cljs.core.next.call(null,cljs.core.next.call(null,coll));
});
/**
* Return the last item in coll, in linear time
*/
cljs.core.last = (function last(s){
while(true){
var sn__12250 = cljs.core.next.call(null,s);
if(!((sn__12250 == null)))
{{
var G__12251 = sn__12250;
s = G__12251;
continue;
}
} else
{return cljs.core.first.call(null,s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);
(cljs.core._equiv["_"] = (function (x,o){
return (x === o);
}));
/**
* Returns true if x is logical false, false otherwise.
*/
cljs.core.not = (function not(x){
if(cljs.core.truth_(x))
{return false;
} else
{return true;
}
});
/**
* conj[oin]. Returns a new collection with the xs
* 'added'. (conj nil item) returns (item).  The 'addition' may
* happen at different 'places' depending on the concrete type.
* @param {...*} var_args
*/
cljs.core.conj = (function() {
var conj = null;
var conj__2 = (function (coll,x){
return cljs.core._conj.call(null,coll,x);
});
var conj__3 = (function() { 
var G__12252__delegate = function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs))
{{
var G__12253 = conj.call(null,coll,x);
var G__12254 = cljs.core.first.call(null,xs);
var G__12255 = cljs.core.next.call(null,xs);
coll = G__12253;
x = G__12254;
xs = G__12255;
continue;
}
} else
{return conj.call(null,coll,x);
}
break;
}
};
var G__12252 = function (coll,x,var_args){
var xs = null;
if (goog.isDef(var_args)) {
  xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12252__delegate.call(this, coll, x, xs);
};
G__12252.cljs$lang$maxFixedArity = 2;
G__12252.cljs$lang$applyTo = (function (arglist__12256){
var coll = cljs.core.first(arglist__12256);
var x = cljs.core.first(cljs.core.next(arglist__12256));
var xs = cljs.core.rest(cljs.core.next(arglist__12256));
return G__12252__delegate(coll, x, xs);
});
G__12252.cljs$lang$arity$variadic = G__12252__delegate;
return G__12252;
})()
;
conj = function(coll,x,var_args){
var xs = var_args;
switch(arguments.length){
case 2:
return conj__2.call(this,coll,x);
default:
return conj__3.cljs$lang$arity$variadic(coll,x, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
conj.cljs$lang$maxFixedArity = 2;
conj.cljs$lang$applyTo = conj__3.cljs$lang$applyTo;
conj.cljs$lang$arity$2 = conj__2;
conj.cljs$lang$arity$variadic = conj__3.cljs$lang$arity$variadic;
return conj;
})()
;
/**
* Returns an empty collection of the same category as coll, or nil
*/
cljs.core.empty = (function empty(coll){
return cljs.core._empty.call(null,coll);
});
cljs.core.accumulating_seq_count = (function accumulating_seq_count(coll){
var s__12259 = cljs.core.seq.call(null,coll);
var acc__12260 = 0;
while(true){
if(cljs.core.counted_QMARK_.call(null,s__12259))
{return (acc__12260 + cljs.core._count.call(null,s__12259));
} else
{{
var G__12261 = cljs.core.next.call(null,s__12259);
var G__12262 = (acc__12260 + 1);
s__12259 = G__12261;
acc__12260 = G__12262;
continue;
}
}
break;
}
});
/**
* Returns the number of items in the collection. (count nil) returns
* 0.  Also works on strings, arrays, and Maps
*/
cljs.core.count = (function count(coll){
if(cljs.core.counted_QMARK_.call(null,coll))
{return cljs.core._count.call(null,coll);
} else
{return cljs.core.accumulating_seq_count.call(null,coll);
}
});
cljs.core.linear_traversal_nth = (function() {
var linear_traversal_nth = null;
var linear_traversal_nth__2 = (function (coll,n){
if((coll == null))
{throw (new Error("Index out of bounds"));
} else
{if((n === 0))
{if(cljs.core.seq.call(null,coll))
{return cljs.core.first.call(null,coll);
} else
{throw (new Error("Index out of bounds"));
}
} else
{if(cljs.core.indexed_QMARK_.call(null,coll))
{return cljs.core._nth.call(null,coll,n);
} else
{if(cljs.core.seq.call(null,coll))
{return linear_traversal_nth.call(null,cljs.core.next.call(null,coll),(n - 1));
} else
{if("\uFDD0'else")
{throw (new Error("Index out of bounds"));
} else
{return null;
}
}
}
}
}
});
var linear_traversal_nth__3 = (function (coll,n,not_found){
if((coll == null))
{return not_found;
} else
{if((n === 0))
{if(cljs.core.seq.call(null,coll))
{return cljs.core.first.call(null,coll);
} else
{return not_found;
}
} else
{if(cljs.core.indexed_QMARK_.call(null,coll))
{return cljs.core._nth.call(null,coll,n,not_found);
} else
{if(cljs.core.seq.call(null,coll))
{return linear_traversal_nth.call(null,cljs.core.next.call(null,coll),(n - 1),not_found);
} else
{if("\uFDD0'else")
{return not_found;
} else
{return null;
}
}
}
}
}
});
linear_traversal_nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return linear_traversal_nth__2.call(this,coll,n);
case 3:
return linear_traversal_nth__3.call(this,coll,n,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
linear_traversal_nth.cljs$lang$arity$2 = linear_traversal_nth__2;
linear_traversal_nth.cljs$lang$arity$3 = linear_traversal_nth__3;
return linear_traversal_nth;
})()
;
/**
* Returns the value at the index. get returns nil if index out of
* bounds, nth throws an exception unless not-found is supplied.  nth
* also works for strings, arrays, regex Matchers and Lists, and,
* in O(n) time, for sequences.
*/
cljs.core.nth = (function() {
var nth = null;
var nth__2 = (function (coll,n){
if((coll == null))
{return null;
} else
{if((function (){var G__12269__12270 = coll;
if(G__12269__12270)
{if((function (){var or__3824__auto____12271 = (G__12269__12270.cljs$lang$protocol_mask$partition0$ & 16);
if(or__3824__auto____12271)
{return or__3824__auto____12271;
} else
{return G__12269__12270.cljs$core$IIndexed$;
}
})())
{return true;
} else
{if((!G__12269__12270.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IIndexed,G__12269__12270);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IIndexed,G__12269__12270);
}
})())
{return cljs.core._nth.call(null,coll,Math.floor(n));
} else
{return cljs.core.linear_traversal_nth.call(null,coll,Math.floor(n));
}
}
});
var nth__3 = (function (coll,n,not_found){
if(!((coll == null)))
{if((function (){var G__12272__12273 = coll;
if(G__12272__12273)
{if((function (){var or__3824__auto____12274 = (G__12272__12273.cljs$lang$protocol_mask$partition0$ & 16);
if(or__3824__auto____12274)
{return or__3824__auto____12274;
} else
{return G__12272__12273.cljs$core$IIndexed$;
}
})())
{return true;
} else
{if((!G__12272__12273.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IIndexed,G__12272__12273);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IIndexed,G__12272__12273);
}
})())
{return cljs.core._nth.call(null,coll,Math.floor(n),not_found);
} else
{return cljs.core.linear_traversal_nth.call(null,coll,Math.floor(n),not_found);
}
} else
{return not_found;
}
});
nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return nth__2.call(this,coll,n);
case 3:
return nth__3.call(this,coll,n,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
nth.cljs$lang$arity$2 = nth__2;
nth.cljs$lang$arity$3 = nth__3;
return nth;
})()
;
/**
* Returns the value mapped to key, not-found or nil if key not present.
*/
cljs.core.get = (function() {
var get = null;
var get__2 = (function (o,k){
return cljs.core._lookup.call(null,o,k);
});
var get__3 = (function (o,k,not_found){
return cljs.core._lookup.call(null,o,k,not_found);
});
get = function(o,k,not_found){
switch(arguments.length){
case 2:
return get__2.call(this,o,k);
case 3:
return get__3.call(this,o,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
get.cljs$lang$arity$2 = get__2;
get.cljs$lang$arity$3 = get__3;
return get;
})()
;
/**
* assoc[iate]. When applied to a map, returns a new map of the
* same (hashed/sorted) type, that contains the mapping of key(s) to
* val(s). When applied to a vector, returns a new vector that
* contains val at index.
* @param {...*} var_args
*/
cljs.core.assoc = (function() {
var assoc = null;
var assoc__3 = (function (coll,k,v){
return cljs.core._assoc.call(null,coll,k,v);
});
var assoc__4 = (function() { 
var G__12277__delegate = function (coll,k,v,kvs){
while(true){
var ret__12276 = assoc.call(null,coll,k,v);
if(cljs.core.truth_(kvs))
{{
var G__12278 = ret__12276;
var G__12279 = cljs.core.first.call(null,kvs);
var G__12280 = cljs.core.second.call(null,kvs);
var G__12281 = cljs.core.nnext.call(null,kvs);
coll = G__12278;
k = G__12279;
v = G__12280;
kvs = G__12281;
continue;
}
} else
{return ret__12276;
}
break;
}
};
var G__12277 = function (coll,k,v,var_args){
var kvs = null;
if (goog.isDef(var_args)) {
  kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__12277__delegate.call(this, coll, k, v, kvs);
};
G__12277.cljs$lang$maxFixedArity = 3;
G__12277.cljs$lang$applyTo = (function (arglist__12282){
var coll = cljs.core.first(arglist__12282);
var k = cljs.core.first(cljs.core.next(arglist__12282));
var v = cljs.core.first(cljs.core.next(cljs.core.next(arglist__12282)));
var kvs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__12282)));
return G__12277__delegate(coll, k, v, kvs);
});
G__12277.cljs$lang$arity$variadic = G__12277__delegate;
return G__12277;
})()
;
assoc = function(coll,k,v,var_args){
var kvs = var_args;
switch(arguments.length){
case 3:
return assoc__3.call(this,coll,k,v);
default:
return assoc__4.cljs$lang$arity$variadic(coll,k,v, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
assoc.cljs$lang$maxFixedArity = 3;
assoc.cljs$lang$applyTo = assoc__4.cljs$lang$applyTo;
assoc.cljs$lang$arity$3 = assoc__3;
assoc.cljs$lang$arity$variadic = assoc__4.cljs$lang$arity$variadic;
return assoc;
})()
;
/**
* dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
* that does not contain a mapping for key(s).
* @param {...*} var_args
*/
cljs.core.dissoc = (function() {
var dissoc = null;
var dissoc__1 = (function (coll){
return coll;
});
var dissoc__2 = (function (coll,k){
return cljs.core._dissoc.call(null,coll,k);
});
var dissoc__3 = (function() { 
var G__12285__delegate = function (coll,k,ks){
while(true){
var ret__12284 = dissoc.call(null,coll,k);
if(cljs.core.truth_(ks))
{{
var G__12286 = ret__12284;
var G__12287 = cljs.core.first.call(null,ks);
var G__12288 = cljs.core.next.call(null,ks);
coll = G__12286;
k = G__12287;
ks = G__12288;
continue;
}
} else
{return ret__12284;
}
break;
}
};
var G__12285 = function (coll,k,var_args){
var ks = null;
if (goog.isDef(var_args)) {
  ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12285__delegate.call(this, coll, k, ks);
};
G__12285.cljs$lang$maxFixedArity = 2;
G__12285.cljs$lang$applyTo = (function (arglist__12289){
var coll = cljs.core.first(arglist__12289);
var k = cljs.core.first(cljs.core.next(arglist__12289));
var ks = cljs.core.rest(cljs.core.next(arglist__12289));
return G__12285__delegate(coll, k, ks);
});
G__12285.cljs$lang$arity$variadic = G__12285__delegate;
return G__12285;
})()
;
dissoc = function(coll,k,var_args){
var ks = var_args;
switch(arguments.length){
case 1:
return dissoc__1.call(this,coll);
case 2:
return dissoc__2.call(this,coll,k);
default:
return dissoc__3.cljs$lang$arity$variadic(coll,k, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
dissoc.cljs$lang$maxFixedArity = 2;
dissoc.cljs$lang$applyTo = dissoc__3.cljs$lang$applyTo;
dissoc.cljs$lang$arity$1 = dissoc__1;
dissoc.cljs$lang$arity$2 = dissoc__2;
dissoc.cljs$lang$arity$variadic = dissoc__3.cljs$lang$arity$variadic;
return dissoc;
})()
;
/**
* Returns an object of the same type and value as obj, with
* map m as its metadata.
*/
cljs.core.with_meta = (function with_meta(o,meta){
return cljs.core._with_meta.call(null,o,meta);
});
/**
* Returns the metadata of obj, returns nil if there is no metadata.
*/
cljs.core.meta = (function meta(o){
if((function (){var G__12293__12294 = o;
if(G__12293__12294)
{if((function (){var or__3824__auto____12295 = (G__12293__12294.cljs$lang$protocol_mask$partition0$ & 131072);
if(or__3824__auto____12295)
{return or__3824__auto____12295;
} else
{return G__12293__12294.cljs$core$IMeta$;
}
})())
{return true;
} else
{if((!G__12293__12294.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IMeta,G__12293__12294);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IMeta,G__12293__12294);
}
})())
{return cljs.core._meta.call(null,o);
} else
{return null;
}
});
/**
* For a list or queue, same as first, for a vector, same as, but much
* more efficient than, last. If the collection is empty, returns nil.
*/
cljs.core.peek = (function peek(coll){
return cljs.core._peek.call(null,coll);
});
/**
* For a list or queue, returns a new list/queue without the first
* item, for a vector, returns a new vector without the last item.
* Note - not the same as next/butlast.
*/
cljs.core.pop = (function pop(coll){
return cljs.core._pop.call(null,coll);
});
/**
* disj[oin]. Returns a new set of the same (hashed/sorted) type, that
* does not contain key(s).
* @param {...*} var_args
*/
cljs.core.disj = (function() {
var disj = null;
var disj__1 = (function (coll){
return coll;
});
var disj__2 = (function (coll,k){
return cljs.core._disjoin.call(null,coll,k);
});
var disj__3 = (function() { 
var G__12298__delegate = function (coll,k,ks){
while(true){
var ret__12297 = disj.call(null,coll,k);
if(cljs.core.truth_(ks))
{{
var G__12299 = ret__12297;
var G__12300 = cljs.core.first.call(null,ks);
var G__12301 = cljs.core.next.call(null,ks);
coll = G__12299;
k = G__12300;
ks = G__12301;
continue;
}
} else
{return ret__12297;
}
break;
}
};
var G__12298 = function (coll,k,var_args){
var ks = null;
if (goog.isDef(var_args)) {
  ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12298__delegate.call(this, coll, k, ks);
};
G__12298.cljs$lang$maxFixedArity = 2;
G__12298.cljs$lang$applyTo = (function (arglist__12302){
var coll = cljs.core.first(arglist__12302);
var k = cljs.core.first(cljs.core.next(arglist__12302));
var ks = cljs.core.rest(cljs.core.next(arglist__12302));
return G__12298__delegate(coll, k, ks);
});
G__12298.cljs$lang$arity$variadic = G__12298__delegate;
return G__12298;
})()
;
disj = function(coll,k,var_args){
var ks = var_args;
switch(arguments.length){
case 1:
return disj__1.call(this,coll);
case 2:
return disj__2.call(this,coll,k);
default:
return disj__3.cljs$lang$arity$variadic(coll,k, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
disj.cljs$lang$maxFixedArity = 2;
disj.cljs$lang$applyTo = disj__3.cljs$lang$applyTo;
disj.cljs$lang$arity$1 = disj__1;
disj.cljs$lang$arity$2 = disj__2;
disj.cljs$lang$arity$variadic = disj__3.cljs$lang$arity$variadic;
return disj;
})()
;
cljs.core.string_hash_cache = {};
cljs.core.string_hash_cache_count = 0;
cljs.core.add_to_string_hash_cache = (function add_to_string_hash_cache(k){
var h__12304 = goog.string.hashCode(k);
(cljs.core.string_hash_cache[k] = h__12304);
cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + 1);
return h__12304;
});
cljs.core.check_string_hash_cache = (function check_string_hash_cache(k){
if((cljs.core.string_hash_cache_count > 255))
{cljs.core.string_hash_cache = {};
cljs.core.string_hash_cache_count = 0;
} else
{}
var h__12306 = (cljs.core.string_hash_cache[k]);
if(!((h__12306 == null)))
{return h__12306;
} else
{return cljs.core.add_to_string_hash_cache.call(null,k);
}
});
cljs.core.hash = (function() {
var hash = null;
var hash__1 = (function (o){
return hash.call(null,o,true);
});
var hash__2 = (function (o,check_cache){
if((function (){var and__3822__auto____12308 = goog.isString(o);
if(and__3822__auto____12308)
{return check_cache;
} else
{return and__3822__auto____12308;
}
})())
{return cljs.core.check_string_hash_cache.call(null,o);
} else
{return cljs.core._hash.call(null,o);
}
});
hash = function(o,check_cache){
switch(arguments.length){
case 1:
return hash__1.call(this,o);
case 2:
return hash__2.call(this,o,check_cache);
}
throw('Invalid arity: ' + arguments.length);
};
hash.cljs$lang$arity$1 = hash__1;
hash.cljs$lang$arity$2 = hash__2;
return hash;
})()
;
/**
* Returns true if coll has no items - same as (not (seq coll)).
* Please use the idiom (seq x) rather than (not (empty? x))
*/
cljs.core.empty_QMARK_ = (function empty_QMARK_(coll){
return cljs.core.not.call(null,cljs.core.seq.call(null,coll));
});
/**
* Returns true if x satisfies ICollection
*/
cljs.core.coll_QMARK_ = (function coll_QMARK_(x){
if((x == null))
{return false;
} else
{var G__12312__12313 = x;
if(G__12312__12313)
{if((function (){var or__3824__auto____12314 = (G__12312__12313.cljs$lang$protocol_mask$partition0$ & 8);
if(or__3824__auto____12314)
{return or__3824__auto____12314;
} else
{return G__12312__12313.cljs$core$ICollection$;
}
})())
{return true;
} else
{if((!G__12312__12313.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.ICollection,G__12312__12313);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.ICollection,G__12312__12313);
}
}
});
/**
* Returns true if x satisfies ISet
*/
cljs.core.set_QMARK_ = (function set_QMARK_(x){
if((x == null))
{return false;
} else
{var G__12318__12319 = x;
if(G__12318__12319)
{if((function (){var or__3824__auto____12320 = (G__12318__12319.cljs$lang$protocol_mask$partition0$ & 4096);
if(or__3824__auto____12320)
{return or__3824__auto____12320;
} else
{return G__12318__12319.cljs$core$ISet$;
}
})())
{return true;
} else
{if((!G__12318__12319.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.ISet,G__12318__12319);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.ISet,G__12318__12319);
}
}
});
/**
* Returns true if coll implements Associative
*/
cljs.core.associative_QMARK_ = (function associative_QMARK_(x){
var G__12324__12325 = x;
if(G__12324__12325)
{if((function (){var or__3824__auto____12326 = (G__12324__12325.cljs$lang$protocol_mask$partition0$ & 512);
if(or__3824__auto____12326)
{return or__3824__auto____12326;
} else
{return G__12324__12325.cljs$core$IAssociative$;
}
})())
{return true;
} else
{if((!G__12324__12325.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IAssociative,G__12324__12325);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IAssociative,G__12324__12325);
}
});
/**
* Returns true if coll satisfies ISequential
*/
cljs.core.sequential_QMARK_ = (function sequential_QMARK_(x){
var G__12330__12331 = x;
if(G__12330__12331)
{if((function (){var or__3824__auto____12332 = (G__12330__12331.cljs$lang$protocol_mask$partition0$ & 16777216);
if(or__3824__auto____12332)
{return or__3824__auto____12332;
} else
{return G__12330__12331.cljs$core$ISequential$;
}
})())
{return true;
} else
{if((!G__12330__12331.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.ISequential,G__12330__12331);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.ISequential,G__12330__12331);
}
});
/**
* Returns true if coll implements count in constant time
*/
cljs.core.counted_QMARK_ = (function counted_QMARK_(x){
var G__12336__12337 = x;
if(G__12336__12337)
{if((function (){var or__3824__auto____12338 = (G__12336__12337.cljs$lang$protocol_mask$partition0$ & 2);
if(or__3824__auto____12338)
{return or__3824__auto____12338;
} else
{return G__12336__12337.cljs$core$ICounted$;
}
})())
{return true;
} else
{if((!G__12336__12337.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.ICounted,G__12336__12337);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.ICounted,G__12336__12337);
}
});
/**
* Returns true if coll implements nth in constant time
*/
cljs.core.indexed_QMARK_ = (function indexed_QMARK_(x){
var G__12342__12343 = x;
if(G__12342__12343)
{if((function (){var or__3824__auto____12344 = (G__12342__12343.cljs$lang$protocol_mask$partition0$ & 16);
if(or__3824__auto____12344)
{return or__3824__auto____12344;
} else
{return G__12342__12343.cljs$core$IIndexed$;
}
})())
{return true;
} else
{if((!G__12342__12343.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IIndexed,G__12342__12343);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IIndexed,G__12342__12343);
}
});
/**
* Returns true if coll satisfies IReduce
*/
cljs.core.reduceable_QMARK_ = (function reduceable_QMARK_(x){
var G__12348__12349 = x;
if(G__12348__12349)
{if((function (){var or__3824__auto____12350 = (G__12348__12349.cljs$lang$protocol_mask$partition0$ & 524288);
if(or__3824__auto____12350)
{return or__3824__auto____12350;
} else
{return G__12348__12349.cljs$core$IReduce$;
}
})())
{return true;
} else
{if((!G__12348__12349.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IReduce,G__12348__12349);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IReduce,G__12348__12349);
}
});
/**
* Return true if x satisfies IMap
*/
cljs.core.map_QMARK_ = (function map_QMARK_(x){
if((x == null))
{return false;
} else
{var G__12354__12355 = x;
if(G__12354__12355)
{if((function (){var or__3824__auto____12356 = (G__12354__12355.cljs$lang$protocol_mask$partition0$ & 1024);
if(or__3824__auto____12356)
{return or__3824__auto____12356;
} else
{return G__12354__12355.cljs$core$IMap$;
}
})())
{return true;
} else
{if((!G__12354__12355.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IMap,G__12354__12355);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IMap,G__12354__12355);
}
}
});
/**
* Return true if x satisfies IVector
*/
cljs.core.vector_QMARK_ = (function vector_QMARK_(x){
var G__12360__12361 = x;
if(G__12360__12361)
{if((function (){var or__3824__auto____12362 = (G__12360__12361.cljs$lang$protocol_mask$partition0$ & 16384);
if(or__3824__auto____12362)
{return or__3824__auto____12362;
} else
{return G__12360__12361.cljs$core$IVector$;
}
})())
{return true;
} else
{if((!G__12360__12361.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IVector,G__12360__12361);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IVector,G__12360__12361);
}
});
cljs.core.chunked_seq_QMARK_ = (function chunked_seq_QMARK_(x){
var G__12366__12367 = x;
if(G__12366__12367)
{if(cljs.core.truth_((function (){var or__3824__auto____12368 = null;
if(cljs.core.truth_(or__3824__auto____12368))
{return or__3824__auto____12368;
} else
{return G__12366__12367.cljs$core$IChunkedSeq$;
}
})()))
{return true;
} else
{if((!G__12366__12367.cljs$lang$protocol_mask$partition$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IChunkedSeq,G__12366__12367);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IChunkedSeq,G__12366__12367);
}
});
/**
* @param {...*} var_args
*/
cljs.core.js_obj = (function() {
var js_obj = null;
var js_obj__0 = (function (){
return {};
});
var js_obj__1 = (function() { 
var G__12369__delegate = function (keyvals){
return cljs.core.apply.call(null,goog.object.create,keyvals);
};
var G__12369 = function (var_args){
var keyvals = null;
if (goog.isDef(var_args)) {
  keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return G__12369__delegate.call(this, keyvals);
};
G__12369.cljs$lang$maxFixedArity = 0;
G__12369.cljs$lang$applyTo = (function (arglist__12370){
var keyvals = cljs.core.seq(arglist__12370);;
return G__12369__delegate(keyvals);
});
G__12369.cljs$lang$arity$variadic = G__12369__delegate;
return G__12369;
})()
;
js_obj = function(var_args){
var keyvals = var_args;
switch(arguments.length){
case 0:
return js_obj__0.call(this);
default:
return js_obj__1.cljs$lang$arity$variadic(cljs.core.array_seq(arguments, 0));
}
throw('Invalid arity: ' + arguments.length);
};
js_obj.cljs$lang$maxFixedArity = 0;
js_obj.cljs$lang$applyTo = js_obj__1.cljs$lang$applyTo;
js_obj.cljs$lang$arity$0 = js_obj__0;
js_obj.cljs$lang$arity$variadic = js_obj__1.cljs$lang$arity$variadic;
return js_obj;
})()
;
cljs.core.js_keys = (function js_keys(obj){
var keys__12372 = [];
goog.object.forEach(obj,(function (val,key,obj){
return keys__12372.push(key);
}));
return keys__12372;
});
cljs.core.js_delete = (function js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function array_copy(from,i,to,j,len){
var i__12376 = i;
var j__12377 = j;
var len__12378 = len;
while(true){
if((len__12378 === 0))
{return to;
} else
{(to[j__12377] = (from[i__12376]));
{
var G__12379 = (i__12376 + 1);
var G__12380 = (j__12377 + 1);
var G__12381 = (len__12378 - 1);
i__12376 = G__12379;
j__12377 = G__12380;
len__12378 = G__12381;
continue;
}
}
break;
}
});
cljs.core.array_copy_downward = (function array_copy_downward(from,i,to,j,len){
var i__12385 = (i + (len - 1));
var j__12386 = (j + (len - 1));
var len__12387 = len;
while(true){
if((len__12387 === 0))
{return to;
} else
{(to[j__12386] = (from[i__12385]));
{
var G__12388 = (i__12385 - 1);
var G__12389 = (j__12386 - 1);
var G__12390 = (len__12387 - 1);
i__12385 = G__12388;
j__12386 = G__12389;
len__12387 = G__12390;
continue;
}
}
break;
}
});
cljs.core.lookup_sentinel = {};
/**
* Returns true if x is the value false, false otherwise.
*/
cljs.core.false_QMARK_ = (function false_QMARK_(x){
return x === false;
});
/**
* Returns true if x is the value true, false otherwise.
*/
cljs.core.true_QMARK_ = (function true_QMARK_(x){
return x === true;
});
cljs.core.undefined_QMARK_ = (function undefined_QMARK_(x){
return (void 0 === x);
});
/**
* Return true if s satisfies ISeq
*/
cljs.core.seq_QMARK_ = (function seq_QMARK_(s){
if((s == null))
{return false;
} else
{var G__12394__12395 = s;
if(G__12394__12395)
{if((function (){var or__3824__auto____12396 = (G__12394__12395.cljs$lang$protocol_mask$partition0$ & 64);
if(or__3824__auto____12396)
{return or__3824__auto____12396;
} else
{return G__12394__12395.cljs$core$ISeq$;
}
})())
{return true;
} else
{if((!G__12394__12395.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.ISeq,G__12394__12395);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.ISeq,G__12394__12395);
}
}
});
/**
* Return true if s satisfies ISeqable
*/
cljs.core.seqable_QMARK_ = (function seqable_QMARK_(s){
var G__12400__12401 = s;
if(G__12400__12401)
{if((function (){var or__3824__auto____12402 = (G__12400__12401.cljs$lang$protocol_mask$partition0$ & 8388608);
if(or__3824__auto____12402)
{return or__3824__auto____12402;
} else
{return G__12400__12401.cljs$core$ISeqable$;
}
})())
{return true;
} else
{if((!G__12400__12401.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.ISeqable,G__12400__12401);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.ISeqable,G__12400__12401);
}
});
cljs.core.boolean$ = (function boolean$(x){
if(cljs.core.truth_(x))
{return true;
} else
{return false;
}
});
cljs.core.string_QMARK_ = (function string_QMARK_(x){
var and__3822__auto____12405 = goog.isString(x);
if(and__3822__auto____12405)
{return !((function (){var or__3824__auto____12406 = (x.charAt(0) === "\uFDD0");
if(or__3824__auto____12406)
{return or__3824__auto____12406;
} else
{return (x.charAt(0) === "\uFDD1");
}
})());
} else
{return and__3822__auto____12405;
}
});
cljs.core.keyword_QMARK_ = (function keyword_QMARK_(x){
var and__3822__auto____12408 = goog.isString(x);
if(and__3822__auto____12408)
{return (x.charAt(0) === "\uFDD0");
} else
{return and__3822__auto____12408;
}
});
cljs.core.symbol_QMARK_ = (function symbol_QMARK_(x){
var and__3822__auto____12410 = goog.isString(x);
if(and__3822__auto____12410)
{return (x.charAt(0) === "\uFDD1");
} else
{return and__3822__auto____12410;
}
});
cljs.core.number_QMARK_ = (function number_QMARK_(n){
return goog.isNumber(n);
});
cljs.core.fn_QMARK_ = (function fn_QMARK_(f){
return goog.isFunction(f);
});
cljs.core.ifn_QMARK_ = (function ifn_QMARK_(f){
var or__3824__auto____12415 = cljs.core.fn_QMARK_.call(null,f);
if(or__3824__auto____12415)
{return or__3824__auto____12415;
} else
{var G__12416__12417 = f;
if(G__12416__12417)
{if((function (){var or__3824__auto____12418 = (G__12416__12417.cljs$lang$protocol_mask$partition0$ & 1);
if(or__3824__auto____12418)
{return or__3824__auto____12418;
} else
{return G__12416__12417.cljs$core$IFn$;
}
})())
{return true;
} else
{if((!G__12416__12417.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IFn,G__12416__12417);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IFn,G__12416__12417);
}
}
});
/**
* Returns true if n is an integer.  Warning: returns true on underflow condition.
*/
cljs.core.integer_QMARK_ = (function integer_QMARK_(n){
var and__3822__auto____12420 = cljs.core.number_QMARK_.call(null,n);
if(and__3822__auto____12420)
{return (n == n.toFixed());
} else
{return and__3822__auto____12420;
}
});
/**
* Returns true if key is present in the given collection, otherwise
* returns false.  Note that for numerically indexed collections like
* vectors and arrays, this tests if the numeric key is within the
* range of indexes. 'contains?' operates constant or logarithmic time;
* it will not perform a linear search for a value.  See also 'some'.
*/
cljs.core.contains_QMARK_ = (function contains_QMARK_(coll,v){
if((cljs.core._lookup.call(null,coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel))
{return false;
} else
{return true;
}
});
/**
* Returns the map entry for key, or nil if key not present.
*/
cljs.core.find = (function find(coll,k){
if(cljs.core.truth_((function (){var and__3822__auto____12423 = coll;
if(cljs.core.truth_(and__3822__auto____12423))
{var and__3822__auto____12424 = cljs.core.associative_QMARK_.call(null,coll);
if(and__3822__auto____12424)
{return cljs.core.contains_QMARK_.call(null,coll,k);
} else
{return and__3822__auto____12424;
}
} else
{return and__3822__auto____12423;
}
})()))
{return cljs.core.PersistentVector.fromArray([k,cljs.core._lookup.call(null,coll,k)], true);
} else
{return null;
}
});
/**
* Returns true if no two of the arguments are =
* @param {...*} var_args
*/
cljs.core.distinct_QMARK_ = (function() {
var distinct_QMARK_ = null;
var distinct_QMARK___1 = (function (x){
return true;
});
var distinct_QMARK___2 = (function (x,y){
return !(cljs.core._EQ_.call(null,x,y));
});
var distinct_QMARK___3 = (function() { 
var G__12433__delegate = function (x,y,more){
if(!(cljs.core._EQ_.call(null,x,y)))
{var s__12429 = cljs.core.PersistentHashSet.fromArray([y,x]);
var xs__12430 = more;
while(true){
var x__12431 = cljs.core.first.call(null,xs__12430);
var etc__12432 = cljs.core.next.call(null,xs__12430);
if(cljs.core.truth_(xs__12430))
{if(cljs.core.contains_QMARK_.call(null,s__12429,x__12431))
{return false;
} else
{{
var G__12434 = cljs.core.conj.call(null,s__12429,x__12431);
var G__12435 = etc__12432;
s__12429 = G__12434;
xs__12430 = G__12435;
continue;
}
}
} else
{return true;
}
break;
}
} else
{return false;
}
};
var G__12433 = function (x,y,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12433__delegate.call(this, x, y, more);
};
G__12433.cljs$lang$maxFixedArity = 2;
G__12433.cljs$lang$applyTo = (function (arglist__12436){
var x = cljs.core.first(arglist__12436);
var y = cljs.core.first(cljs.core.next(arglist__12436));
var more = cljs.core.rest(cljs.core.next(arglist__12436));
return G__12433__delegate(x, y, more);
});
G__12433.cljs$lang$arity$variadic = G__12433__delegate;
return G__12433;
})()
;
distinct_QMARK_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return distinct_QMARK___1.call(this,x);
case 2:
return distinct_QMARK___2.call(this,x,y);
default:
return distinct_QMARK___3.cljs$lang$arity$variadic(x,y, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
distinct_QMARK_.cljs$lang$maxFixedArity = 2;
distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3.cljs$lang$applyTo;
distinct_QMARK_.cljs$lang$arity$1 = distinct_QMARK___1;
distinct_QMARK_.cljs$lang$arity$2 = distinct_QMARK___2;
distinct_QMARK_.cljs$lang$arity$variadic = distinct_QMARK___3.cljs$lang$arity$variadic;
return distinct_QMARK_;
})()
;
/**
* Comparator. Returns a negative number, zero, or a positive number
* when x is logically 'less than', 'equal to', or 'greater than'
* y. Uses IComparable if available and google.array.defaultCompare for objects
* of the same type and special-cases nil to be less than any other object.
*/
cljs.core.compare = (function compare(x,y){
if((x === y))
{return 0;
} else
{if((x == null))
{return -1;
} else
{if((y == null))
{return 1;
} else
{if((cljs.core.type.call(null,x) === cljs.core.type.call(null,y)))
{if((function (){var G__12440__12441 = x;
if(G__12440__12441)
{if(cljs.core.truth_((function (){var or__3824__auto____12442 = null;
if(cljs.core.truth_(or__3824__auto____12442))
{return or__3824__auto____12442;
} else
{return G__12440__12441.cljs$core$IComparable$;
}
})()))
{return true;
} else
{if((!G__12440__12441.cljs$lang$protocol_mask$partition$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IComparable,G__12440__12441);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IComparable,G__12440__12441);
}
})())
{return cljs.core._compare.call(null,x,y);
} else
{return goog.array.defaultCompare(x,y);
}
} else
{if("\uFDD0'else")
{throw (new Error("compare on non-nil objects of different types"));
} else
{return null;
}
}
}
}
}
});
/**
* Compare indexed collection.
*/
cljs.core.compare_indexed = (function() {
var compare_indexed = null;
var compare_indexed__2 = (function (xs,ys){
var xl__12447 = cljs.core.count.call(null,xs);
var yl__12448 = cljs.core.count.call(null,ys);
if((xl__12447 < yl__12448))
{return -1;
} else
{if((xl__12447 > yl__12448))
{return 1;
} else
{if("\uFDD0'else")
{return compare_indexed.call(null,xs,ys,xl__12447,0);
} else
{return null;
}
}
}
});
var compare_indexed__4 = (function (xs,ys,len,n){
while(true){
var d__12449 = cljs.core.compare.call(null,cljs.core.nth.call(null,xs,n),cljs.core.nth.call(null,ys,n));
if((function (){var and__3822__auto____12450 = (d__12449 === 0);
if(and__3822__auto____12450)
{return ((n + 1) < len);
} else
{return and__3822__auto____12450;
}
})())
{{
var G__12451 = xs;
var G__12452 = ys;
var G__12453 = len;
var G__12454 = (n + 1);
xs = G__12451;
ys = G__12452;
len = G__12453;
n = G__12454;
continue;
}
} else
{return d__12449;
}
break;
}
});
compare_indexed = function(xs,ys,len,n){
switch(arguments.length){
case 2:
return compare_indexed__2.call(this,xs,ys);
case 4:
return compare_indexed__4.call(this,xs,ys,len,n);
}
throw('Invalid arity: ' + arguments.length);
};
compare_indexed.cljs$lang$arity$2 = compare_indexed__2;
compare_indexed.cljs$lang$arity$4 = compare_indexed__4;
return compare_indexed;
})()
;
/**
* Given a fn that might be boolean valued or a comparator,
* return a fn that is a comparator.
*/
cljs.core.fn__GT_comparator = (function fn__GT_comparator(f){
if(cljs.core._EQ_.call(null,f,cljs.core.compare))
{return cljs.core.compare;
} else
{return (function (x,y){
var r__12456 = f.call(null,x,y);
if(cljs.core.number_QMARK_.call(null,r__12456))
{return r__12456;
} else
{if(cljs.core.truth_(r__12456))
{return -1;
} else
{if(cljs.core.truth_(f.call(null,y,x)))
{return 1;
} else
{return 0;
}
}
}
});
}
});
/**
* Returns a sorted sequence of the items in coll. Comp can be
* boolean-valued comparison funcion, or a -/0/+ valued comparator.
* Comp defaults to compare.
*/
cljs.core.sort = (function() {
var sort = null;
var sort__1 = (function (coll){
return sort.call(null,cljs.core.compare,coll);
});
var sort__2 = (function (comp,coll){
if(cljs.core.seq.call(null,coll))
{var a__12458 = cljs.core.to_array.call(null,coll);
goog.array.stableSort(a__12458,cljs.core.fn__GT_comparator.call(null,comp));
return cljs.core.seq.call(null,a__12458);
} else
{return cljs.core.List.EMPTY;
}
});
sort = function(comp,coll){
switch(arguments.length){
case 1:
return sort__1.call(this,comp);
case 2:
return sort__2.call(this,comp,coll);
}
throw('Invalid arity: ' + arguments.length);
};
sort.cljs$lang$arity$1 = sort__1;
sort.cljs$lang$arity$2 = sort__2;
return sort;
})()
;
/**
* Returns a sorted sequence of the items in coll, where the sort
* order is determined by comparing (keyfn item).  Comp can be
* boolean-valued comparison funcion, or a -/0/+ valued comparator.
* Comp defaults to compare.
*/
cljs.core.sort_by = (function() {
var sort_by = null;
var sort_by__2 = (function (keyfn,coll){
return sort_by.call(null,keyfn,cljs.core.compare,coll);
});
var sort_by__3 = (function (keyfn,comp,coll){
return cljs.core.sort.call(null,(function (x,y){
return cljs.core.fn__GT_comparator.call(null,comp).call(null,keyfn.call(null,x),keyfn.call(null,y));
}),coll);
});
sort_by = function(keyfn,comp,coll){
switch(arguments.length){
case 2:
return sort_by__2.call(this,keyfn,comp);
case 3:
return sort_by__3.call(this,keyfn,comp,coll);
}
throw('Invalid arity: ' + arguments.length);
};
sort_by.cljs$lang$arity$2 = sort_by__2;
sort_by.cljs$lang$arity$3 = sort_by__3;
return sort_by;
})()
;
cljs.core.seq_reduce = (function() {
var seq_reduce = null;
var seq_reduce__2 = (function (f,coll){
var temp__3971__auto____12464 = cljs.core.seq.call(null,coll);
if(temp__3971__auto____12464)
{var s__12465 = temp__3971__auto____12464;
return cljs.core.reduce.call(null,f,cljs.core.first.call(null,s__12465),cljs.core.next.call(null,s__12465));
} else
{return f.call(null);
}
});
var seq_reduce__3 = (function (f,val,coll){
var val__12466 = val;
var coll__12467 = cljs.core.seq.call(null,coll);
while(true){
if(coll__12467)
{var nval__12468 = f.call(null,val__12466,cljs.core.first.call(null,coll__12467));
if(cljs.core.reduced_QMARK_.call(null,nval__12468))
{return cljs.core.deref.call(null,nval__12468);
} else
{{
var G__12469 = nval__12468;
var G__12470 = cljs.core.next.call(null,coll__12467);
val__12466 = G__12469;
coll__12467 = G__12470;
continue;
}
}
} else
{return val__12466;
}
break;
}
});
seq_reduce = function(f,val,coll){
switch(arguments.length){
case 2:
return seq_reduce__2.call(this,f,val);
case 3:
return seq_reduce__3.call(this,f,val,coll);
}
throw('Invalid arity: ' + arguments.length);
};
seq_reduce.cljs$lang$arity$2 = seq_reduce__2;
seq_reduce.cljs$lang$arity$3 = seq_reduce__3;
return seq_reduce;
})()
;
/**
* Return a random permutation of coll
*/
cljs.core.shuffle = (function shuffle(coll){
var a__12472 = cljs.core.to_array.call(null,coll);
goog.array.shuffle(a__12472);
return cljs.core.vec.call(null,a__12472);
});
/**
* f should be a function of 2 arguments. If val is not supplied,
* returns the result of applying f to the first 2 items in coll, then
* applying f to that result and the 3rd item, etc. If coll contains no
* items, f must accept no arguments as well, and reduce returns the
* result of calling f with no arguments.  If coll has only 1 item, it
* is returned and f is not called.  If val is supplied, returns the
* result of applying f to val and the first item in coll, then
* applying f to that result and the 2nd item, etc. If coll contains no
* items, returns val and f is not called.
*/
cljs.core.reduce = (function() {
var reduce = null;
var reduce__2 = (function (f,coll){
if((function (){var G__12479__12480 = coll;
if(G__12479__12480)
{if((function (){var or__3824__auto____12481 = (G__12479__12480.cljs$lang$protocol_mask$partition0$ & 524288);
if(or__3824__auto____12481)
{return or__3824__auto____12481;
} else
{return G__12479__12480.cljs$core$IReduce$;
}
})())
{return true;
} else
{if((!G__12479__12480.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IReduce,G__12479__12480);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IReduce,G__12479__12480);
}
})())
{return cljs.core._reduce.call(null,coll,f);
} else
{return cljs.core.seq_reduce.call(null,f,coll);
}
});
var reduce__3 = (function (f,val,coll){
if((function (){var G__12482__12483 = coll;
if(G__12482__12483)
{if((function (){var or__3824__auto____12484 = (G__12482__12483.cljs$lang$protocol_mask$partition0$ & 524288);
if(or__3824__auto____12484)
{return or__3824__auto____12484;
} else
{return G__12482__12483.cljs$core$IReduce$;
}
})())
{return true;
} else
{if((!G__12482__12483.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IReduce,G__12482__12483);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IReduce,G__12482__12483);
}
})())
{return cljs.core._reduce.call(null,coll,f,val);
} else
{return cljs.core.seq_reduce.call(null,f,val,coll);
}
});
reduce = function(f,val,coll){
switch(arguments.length){
case 2:
return reduce__2.call(this,f,val);
case 3:
return reduce__3.call(this,f,val,coll);
}
throw('Invalid arity: ' + arguments.length);
};
reduce.cljs$lang$arity$2 = reduce__2;
reduce.cljs$lang$arity$3 = reduce__3;
return reduce;
})()
;
/**
* Reduces an associative collection. f should be a function of 3
* arguments. Returns the result of applying f to init, the first key
* and the first value in coll, then applying f to that result and the
* 2nd key and value, etc. If coll contains no entries, returns init
* and f is not called. Note that reduce-kv is supported on vectors,
* where the keys will be the ordinals.
*/
cljs.core.reduce_kv = (function reduce_kv(f,init,coll){
return cljs.core._kv_reduce.call(null,coll,f,init);
});

/**
* @constructor
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/Reduced");
});
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var this__12485 = this;
return this__12485.val;
});
cljs.core.Reduced;
/**
* Returns true if x is the result of a call to reduced
*/
cljs.core.reduced_QMARK_ = (function reduced_QMARK_(r){
return cljs.core.instance_QMARK_.call(null,cljs.core.Reduced,r);
});
/**
* Wraps x in a way such that a reduce will terminate with the value x
*/
cljs.core.reduced = (function reduced(x){
return (new cljs.core.Reduced(x));
});
/**
* Returns the sum of nums. (+) returns 0.
* @param {...*} var_args
*/
cljs.core._PLUS_ = (function() {
var _PLUS_ = null;
var _PLUS___0 = (function (){
return 0;
});
var _PLUS___1 = (function (x){
return x;
});
var _PLUS___2 = (function (x,y){
return (x + y);
});
var _PLUS___3 = (function() { 
var G__12486__delegate = function (x,y,more){
return cljs.core.reduce.call(null,_PLUS_,(x + y),more);
};
var G__12486 = function (x,y,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12486__delegate.call(this, x, y, more);
};
G__12486.cljs$lang$maxFixedArity = 2;
G__12486.cljs$lang$applyTo = (function (arglist__12487){
var x = cljs.core.first(arglist__12487);
var y = cljs.core.first(cljs.core.next(arglist__12487));
var more = cljs.core.rest(cljs.core.next(arglist__12487));
return G__12486__delegate(x, y, more);
});
G__12486.cljs$lang$arity$variadic = G__12486__delegate;
return G__12486;
})()
;
_PLUS_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return _PLUS___0.call(this);
case 1:
return _PLUS___1.call(this,x);
case 2:
return _PLUS___2.call(this,x,y);
default:
return _PLUS___3.cljs$lang$arity$variadic(x,y, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
_PLUS_.cljs$lang$maxFixedArity = 2;
_PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;
_PLUS_.cljs$lang$arity$0 = _PLUS___0;
_PLUS_.cljs$lang$arity$1 = _PLUS___1;
_PLUS_.cljs$lang$arity$2 = _PLUS___2;
_PLUS_.cljs$lang$arity$variadic = _PLUS___3.cljs$lang$arity$variadic;
return _PLUS_;
})()
;
/**
* If no ys are supplied, returns the negation of x, else subtracts
* the ys from x and returns the result.
* @param {...*} var_args
*/
cljs.core._ = (function() {
var _ = null;
var ___1 = (function (x){
return (- x);
});
var ___2 = (function (x,y){
return (x - y);
});
var ___3 = (function() { 
var G__12488__delegate = function (x,y,more){
return cljs.core.reduce.call(null,_,(x - y),more);
};
var G__12488 = function (x,y,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12488__delegate.call(this, x, y, more);
};
G__12488.cljs$lang$maxFixedArity = 2;
G__12488.cljs$lang$applyTo = (function (arglist__12489){
var x = cljs.core.first(arglist__12489);
var y = cljs.core.first(cljs.core.next(arglist__12489));
var more = cljs.core.rest(cljs.core.next(arglist__12489));
return G__12488__delegate(x, y, more);
});
G__12488.cljs$lang$arity$variadic = G__12488__delegate;
return G__12488;
})()
;
_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return ___1.call(this,x);
case 2:
return ___2.call(this,x,y);
default:
return ___3.cljs$lang$arity$variadic(x,y, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
_.cljs$lang$maxFixedArity = 2;
_.cljs$lang$applyTo = ___3.cljs$lang$applyTo;
_.cljs$lang$arity$1 = ___1;
_.cljs$lang$arity$2 = ___2;
_.cljs$lang$arity$variadic = ___3.cljs$lang$arity$variadic;
return _;
})()
;
/**
* Returns the product of nums. (*) returns 1.
* @param {...*} var_args
*/
cljs.core._STAR_ = (function() {
var _STAR_ = null;
var _STAR___0 = (function (){
return 1;
});
var _STAR___1 = (function (x){
return x;
});
var _STAR___2 = (function (x,y){
return (x * y);
});
var _STAR___3 = (function() { 
var G__12490__delegate = function (x,y,more){
return cljs.core.reduce.call(null,_STAR_,(x * y),more);
};
var G__12490 = function (x,y,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12490__delegate.call(this, x, y, more);
};
G__12490.cljs$lang$maxFixedArity = 2;
G__12490.cljs$lang$applyTo = (function (arglist__12491){
var x = cljs.core.first(arglist__12491);
var y = cljs.core.first(cljs.core.next(arglist__12491));
var more = cljs.core.rest(cljs.core.next(arglist__12491));
return G__12490__delegate(x, y, more);
});
G__12490.cljs$lang$arity$variadic = G__12490__delegate;
return G__12490;
})()
;
_STAR_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return _STAR___0.call(this);
case 1:
return _STAR___1.call(this,x);
case 2:
return _STAR___2.call(this,x,y);
default:
return _STAR___3.cljs$lang$arity$variadic(x,y, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
_STAR_.cljs$lang$maxFixedArity = 2;
_STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;
_STAR_.cljs$lang$arity$0 = _STAR___0;
_STAR_.cljs$lang$arity$1 = _STAR___1;
_STAR_.cljs$lang$arity$2 = _STAR___2;
_STAR_.cljs$lang$arity$variadic = _STAR___3.cljs$lang$arity$variadic;
return _STAR_;
})()
;
/**
* If no denominators are supplied, returns 1/numerator,
* else returns numerator divided by all of the denominators.
* @param {...*} var_args
*/
cljs.core._SLASH_ = (function() {
var _SLASH_ = null;
var _SLASH___1 = (function (x){
return _SLASH_.call(null,1,x);
});
var _SLASH___2 = (function (x,y){
return (x / y);
});
var _SLASH___3 = (function() { 
var G__12492__delegate = function (x,y,more){
return cljs.core.reduce.call(null,_SLASH_,_SLASH_.call(null,x,y),more);
};
var G__12492 = function (x,y,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12492__delegate.call(this, x, y, more);
};
G__12492.cljs$lang$maxFixedArity = 2;
G__12492.cljs$lang$applyTo = (function (arglist__12493){
var x = cljs.core.first(arglist__12493);
var y = cljs.core.first(cljs.core.next(arglist__12493));
var more = cljs.core.rest(cljs.core.next(arglist__12493));
return G__12492__delegate(x, y, more);
});
G__12492.cljs$lang$arity$variadic = G__12492__delegate;
return G__12492;
})()
;
_SLASH_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _SLASH___1.call(this,x);
case 2:
return _SLASH___2.call(this,x,y);
default:
return _SLASH___3.cljs$lang$arity$variadic(x,y, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
_SLASH_.cljs$lang$maxFixedArity = 2;
_SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;
_SLASH_.cljs$lang$arity$1 = _SLASH___1;
_SLASH_.cljs$lang$arity$2 = _SLASH___2;
_SLASH_.cljs$lang$arity$variadic = _SLASH___3.cljs$lang$arity$variadic;
return _SLASH_;
})()
;
/**
* Returns non-nil if nums are in monotonically increasing order,
* otherwise false.
* @param {...*} var_args
*/
cljs.core._LT_ = (function() {
var _LT_ = null;
var _LT___1 = (function (x){
return true;
});
var _LT___2 = (function (x,y){
return (x < y);
});
var _LT___3 = (function() { 
var G__12494__delegate = function (x,y,more){
while(true){
if((x < y))
{if(cljs.core.next.call(null,more))
{{
var G__12495 = y;
var G__12496 = cljs.core.first.call(null,more);
var G__12497 = cljs.core.next.call(null,more);
x = G__12495;
y = G__12496;
more = G__12497;
continue;
}
} else
{return (y < cljs.core.first.call(null,more));
}
} else
{return false;
}
break;
}
};
var G__12494 = function (x,y,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12494__delegate.call(this, x, y, more);
};
G__12494.cljs$lang$maxFixedArity = 2;
G__12494.cljs$lang$applyTo = (function (arglist__12498){
var x = cljs.core.first(arglist__12498);
var y = cljs.core.first(cljs.core.next(arglist__12498));
var more = cljs.core.rest(cljs.core.next(arglist__12498));
return G__12494__delegate(x, y, more);
});
G__12494.cljs$lang$arity$variadic = G__12494__delegate;
return G__12494;
})()
;
_LT_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _LT___1.call(this,x);
case 2:
return _LT___2.call(this,x,y);
default:
return _LT___3.cljs$lang$arity$variadic(x,y, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
_LT_.cljs$lang$maxFixedArity = 2;
_LT_.cljs$lang$applyTo = _LT___3.cljs$lang$applyTo;
_LT_.cljs$lang$arity$1 = _LT___1;
_LT_.cljs$lang$arity$2 = _LT___2;
_LT_.cljs$lang$arity$variadic = _LT___3.cljs$lang$arity$variadic;
return _LT_;
})()
;
/**
* Returns non-nil if nums are in monotonically non-decreasing order,
* otherwise false.
* @param {...*} var_args
*/
cljs.core._LT__EQ_ = (function() {
var _LT__EQ_ = null;
var _LT__EQ___1 = (function (x){
return true;
});
var _LT__EQ___2 = (function (x,y){
return (x <= y);
});
var _LT__EQ___3 = (function() { 
var G__12499__delegate = function (x,y,more){
while(true){
if((x <= y))
{if(cljs.core.next.call(null,more))
{{
var G__12500 = y;
var G__12501 = cljs.core.first.call(null,more);
var G__12502 = cljs.core.next.call(null,more);
x = G__12500;
y = G__12501;
more = G__12502;
continue;
}
} else
{return (y <= cljs.core.first.call(null,more));
}
} else
{return false;
}
break;
}
};
var G__12499 = function (x,y,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12499__delegate.call(this, x, y, more);
};
G__12499.cljs$lang$maxFixedArity = 2;
G__12499.cljs$lang$applyTo = (function (arglist__12503){
var x = cljs.core.first(arglist__12503);
var y = cljs.core.first(cljs.core.next(arglist__12503));
var more = cljs.core.rest(cljs.core.next(arglist__12503));
return G__12499__delegate(x, y, more);
});
G__12499.cljs$lang$arity$variadic = G__12499__delegate;
return G__12499;
})()
;
_LT__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _LT__EQ___1.call(this,x);
case 2:
return _LT__EQ___2.call(this,x,y);
default:
return _LT__EQ___3.cljs$lang$arity$variadic(x,y, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
_LT__EQ_.cljs$lang$maxFixedArity = 2;
_LT__EQ_.cljs$lang$applyTo = _LT__EQ___3.cljs$lang$applyTo;
_LT__EQ_.cljs$lang$arity$1 = _LT__EQ___1;
_LT__EQ_.cljs$lang$arity$2 = _LT__EQ___2;
_LT__EQ_.cljs$lang$arity$variadic = _LT__EQ___3.cljs$lang$arity$variadic;
return _LT__EQ_;
})()
;
/**
* Returns non-nil if nums are in monotonically decreasing order,
* otherwise false.
* @param {...*} var_args
*/
cljs.core._GT_ = (function() {
var _GT_ = null;
var _GT___1 = (function (x){
return true;
});
var _GT___2 = (function (x,y){
return (x > y);
});
var _GT___3 = (function() { 
var G__12504__delegate = function (x,y,more){
while(true){
if((x > y))
{if(cljs.core.next.call(null,more))
{{
var G__12505 = y;
var G__12506 = cljs.core.first.call(null,more);
var G__12507 = cljs.core.next.call(null,more);
x = G__12505;
y = G__12506;
more = G__12507;
continue;
}
} else
{return (y > cljs.core.first.call(null,more));
}
} else
{return false;
}
break;
}
};
var G__12504 = function (x,y,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12504__delegate.call(this, x, y, more);
};
G__12504.cljs$lang$maxFixedArity = 2;
G__12504.cljs$lang$applyTo = (function (arglist__12508){
var x = cljs.core.first(arglist__12508);
var y = cljs.core.first(cljs.core.next(arglist__12508));
var more = cljs.core.rest(cljs.core.next(arglist__12508));
return G__12504__delegate(x, y, more);
});
G__12504.cljs$lang$arity$variadic = G__12504__delegate;
return G__12504;
})()
;
_GT_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _GT___1.call(this,x);
case 2:
return _GT___2.call(this,x,y);
default:
return _GT___3.cljs$lang$arity$variadic(x,y, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
_GT_.cljs$lang$maxFixedArity = 2;
_GT_.cljs$lang$applyTo = _GT___3.cljs$lang$applyTo;
_GT_.cljs$lang$arity$1 = _GT___1;
_GT_.cljs$lang$arity$2 = _GT___2;
_GT_.cljs$lang$arity$variadic = _GT___3.cljs$lang$arity$variadic;
return _GT_;
})()
;
/**
* Returns non-nil if nums are in monotonically non-increasing order,
* otherwise false.
* @param {...*} var_args
*/
cljs.core._GT__EQ_ = (function() {
var _GT__EQ_ = null;
var _GT__EQ___1 = (function (x){
return true;
});
var _GT__EQ___2 = (function (x,y){
return (x >= y);
});
var _GT__EQ___3 = (function() { 
var G__12509__delegate = function (x,y,more){
while(true){
if((x >= y))
{if(cljs.core.next.call(null,more))
{{
var G__12510 = y;
var G__12511 = cljs.core.first.call(null,more);
var G__12512 = cljs.core.next.call(null,more);
x = G__12510;
y = G__12511;
more = G__12512;
continue;
}
} else
{return (y >= cljs.core.first.call(null,more));
}
} else
{return false;
}
break;
}
};
var G__12509 = function (x,y,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12509__delegate.call(this, x, y, more);
};
G__12509.cljs$lang$maxFixedArity = 2;
G__12509.cljs$lang$applyTo = (function (arglist__12513){
var x = cljs.core.first(arglist__12513);
var y = cljs.core.first(cljs.core.next(arglist__12513));
var more = cljs.core.rest(cljs.core.next(arglist__12513));
return G__12509__delegate(x, y, more);
});
G__12509.cljs$lang$arity$variadic = G__12509__delegate;
return G__12509;
})()
;
_GT__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _GT__EQ___1.call(this,x);
case 2:
return _GT__EQ___2.call(this,x,y);
default:
return _GT__EQ___3.cljs$lang$arity$variadic(x,y, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
_GT__EQ_.cljs$lang$maxFixedArity = 2;
_GT__EQ_.cljs$lang$applyTo = _GT__EQ___3.cljs$lang$applyTo;
_GT__EQ_.cljs$lang$arity$1 = _GT__EQ___1;
_GT__EQ_.cljs$lang$arity$2 = _GT__EQ___2;
_GT__EQ_.cljs$lang$arity$variadic = _GT__EQ___3.cljs$lang$arity$variadic;
return _GT__EQ_;
})()
;
/**
* Returns a number one less than num.
*/
cljs.core.dec = (function dec(x){
return (x - 1);
});
/**
* Returns the greatest of the nums.
* @param {...*} var_args
*/
cljs.core.max = (function() {
var max = null;
var max__1 = (function (x){
return x;
});
var max__2 = (function (x,y){
return ((x > y) ? x : y);
});
var max__3 = (function() { 
var G__12514__delegate = function (x,y,more){
return cljs.core.reduce.call(null,max,((x > y) ? x : y),more);
};
var G__12514 = function (x,y,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12514__delegate.call(this, x, y, more);
};
G__12514.cljs$lang$maxFixedArity = 2;
G__12514.cljs$lang$applyTo = (function (arglist__12515){
var x = cljs.core.first(arglist__12515);
var y = cljs.core.first(cljs.core.next(arglist__12515));
var more = cljs.core.rest(cljs.core.next(arglist__12515));
return G__12514__delegate(x, y, more);
});
G__12514.cljs$lang$arity$variadic = G__12514__delegate;
return G__12514;
})()
;
max = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return max__1.call(this,x);
case 2:
return max__2.call(this,x,y);
default:
return max__3.cljs$lang$arity$variadic(x,y, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
max.cljs$lang$maxFixedArity = 2;
max.cljs$lang$applyTo = max__3.cljs$lang$applyTo;
max.cljs$lang$arity$1 = max__1;
max.cljs$lang$arity$2 = max__2;
max.cljs$lang$arity$variadic = max__3.cljs$lang$arity$variadic;
return max;
})()
;
/**
* Returns the least of the nums.
* @param {...*} var_args
*/
cljs.core.min = (function() {
var min = null;
var min__1 = (function (x){
return x;
});
var min__2 = (function (x,y){
return ((x < y) ? x : y);
});
var min__3 = (function() { 
var G__12516__delegate = function (x,y,more){
return cljs.core.reduce.call(null,min,((x < y) ? x : y),more);
};
var G__12516 = function (x,y,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12516__delegate.call(this, x, y, more);
};
G__12516.cljs$lang$maxFixedArity = 2;
G__12516.cljs$lang$applyTo = (function (arglist__12517){
var x = cljs.core.first(arglist__12517);
var y = cljs.core.first(cljs.core.next(arglist__12517));
var more = cljs.core.rest(cljs.core.next(arglist__12517));
return G__12516__delegate(x, y, more);
});
G__12516.cljs$lang$arity$variadic = G__12516__delegate;
return G__12516;
})()
;
min = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return min__1.call(this,x);
case 2:
return min__2.call(this,x,y);
default:
return min__3.cljs$lang$arity$variadic(x,y, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
min.cljs$lang$maxFixedArity = 2;
min.cljs$lang$applyTo = min__3.cljs$lang$applyTo;
min.cljs$lang$arity$1 = min__1;
min.cljs$lang$arity$2 = min__2;
min.cljs$lang$arity$variadic = min__3.cljs$lang$arity$variadic;
return min;
})()
;
cljs.core.fix = (function fix(q){
if((q >= 0))
{return Math.floor.call(null,q);
} else
{return Math.ceil.call(null,q);
}
});
/**
* Coerce to int by stripping decimal places.
*/
cljs.core.int$ = (function int$(x){
return cljs.core.fix.call(null,x);
});
/**
* Coerce to long by stripping decimal places. Identical to `int'.
*/
cljs.core.long$ = (function long$(x){
return cljs.core.fix.call(null,x);
});
/**
* Modulus of num and div. Truncates toward negative infinity.
*/
cljs.core.mod = (function mod(n,d){
return (n % d);
});
/**
* quot[ient] of dividing numerator by denominator.
*/
cljs.core.quot = (function quot(n,d){
var rem__12519 = (n % d);
return cljs.core.fix.call(null,((n - rem__12519) / d));
});
/**
* remainder of dividing numerator by denominator.
*/
cljs.core.rem = (function rem(n,d){
var q__12521 = cljs.core.quot.call(null,n,d);
return (n - (d * q__12521));
});
/**
* Returns a random floating point number between 0 (inclusive) and n (default 1) (exclusive).
*/
cljs.core.rand = (function() {
var rand = null;
var rand__0 = (function (){
return Math.random.call(null);
});
var rand__1 = (function (n){
return (n * rand.call(null));
});
rand = function(n){
switch(arguments.length){
case 0:
return rand__0.call(this);
case 1:
return rand__1.call(this,n);
}
throw('Invalid arity: ' + arguments.length);
};
rand.cljs$lang$arity$0 = rand__0;
rand.cljs$lang$arity$1 = rand__1;
return rand;
})()
;
/**
* Returns a random integer between 0 (inclusive) and n (exclusive).
*/
cljs.core.rand_int = (function rand_int(n){
return cljs.core.fix.call(null,cljs.core.rand.call(null,n));
});
/**
* Bitwise exclusive or
*/
cljs.core.bit_xor = (function bit_xor(x,y){
return (x ^ y);
});
/**
* Bitwise and
*/
cljs.core.bit_and = (function bit_and(x,y){
return (x & y);
});
/**
* Bitwise or
*/
cljs.core.bit_or = (function bit_or(x,y){
return (x | y);
});
/**
* Bitwise and
*/
cljs.core.bit_and_not = (function bit_and_not(x,y){
return (x & ~y);
});
/**
* Clear bit at index n
*/
cljs.core.bit_clear = (function bit_clear(x,n){
return (x & ~(1 << n));
});
/**
* Flip bit at index n
*/
cljs.core.bit_flip = (function bit_flip(x,n){
return (x ^ (1 << n));
});
/**
* Bitwise complement
*/
cljs.core.bit_not = (function bit_not(x){
return (~ x);
});
/**
* Set bit at index n
*/
cljs.core.bit_set = (function bit_set(x,n){
return (x | (1 << n));
});
/**
* Test bit at index n
*/
cljs.core.bit_test = (function bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
* Bitwise shift left
*/
cljs.core.bit_shift_left = (function bit_shift_left(x,n){
return (x << n);
});
/**
* Bitwise shift right
*/
cljs.core.bit_shift_right = (function bit_shift_right(x,n){
return (x >> n);
});
/**
* Bitwise shift right with zero fill
*/
cljs.core.bit_shift_right_zero_fill = (function bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
* Counts the number of bits set in n
*/
cljs.core.bit_count = (function bit_count(v){
var v__12524 = (v - ((v >> 1) & 1431655765));
var v__12525 = ((v__12524 & 858993459) + ((v__12524 >> 2) & 858993459));
return ((((v__12525 + (v__12525 >> 4)) & 252645135) * 16843009) >> 24);
});
/**
* Returns non-nil if nums all have the equivalent
* value, otherwise false. Behavior on non nums is
* undefined.
* @param {...*} var_args
*/
cljs.core._EQ__EQ_ = (function() {
var _EQ__EQ_ = null;
var _EQ__EQ___1 = (function (x){
return true;
});
var _EQ__EQ___2 = (function (x,y){
return cljs.core._equiv.call(null,x,y);
});
var _EQ__EQ___3 = (function() { 
var G__12526__delegate = function (x,y,more){
while(true){
if(cljs.core.truth_(_EQ__EQ_.call(null,x,y)))
{if(cljs.core.next.call(null,more))
{{
var G__12527 = y;
var G__12528 = cljs.core.first.call(null,more);
var G__12529 = cljs.core.next.call(null,more);
x = G__12527;
y = G__12528;
more = G__12529;
continue;
}
} else
{return _EQ__EQ_.call(null,y,cljs.core.first.call(null,more));
}
} else
{return false;
}
break;
}
};
var G__12526 = function (x,y,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12526__delegate.call(this, x, y, more);
};
G__12526.cljs$lang$maxFixedArity = 2;
G__12526.cljs$lang$applyTo = (function (arglist__12530){
var x = cljs.core.first(arglist__12530);
var y = cljs.core.first(cljs.core.next(arglist__12530));
var more = cljs.core.rest(cljs.core.next(arglist__12530));
return G__12526__delegate(x, y, more);
});
G__12526.cljs$lang$arity$variadic = G__12526__delegate;
return G__12526;
})()
;
_EQ__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return _EQ__EQ___1.call(this,x);
case 2:
return _EQ__EQ___2.call(this,x,y);
default:
return _EQ__EQ___3.cljs$lang$arity$variadic(x,y, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
_EQ__EQ_.cljs$lang$maxFixedArity = 2;
_EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3.cljs$lang$applyTo;
_EQ__EQ_.cljs$lang$arity$1 = _EQ__EQ___1;
_EQ__EQ_.cljs$lang$arity$2 = _EQ__EQ___2;
_EQ__EQ_.cljs$lang$arity$variadic = _EQ__EQ___3.cljs$lang$arity$variadic;
return _EQ__EQ_;
})()
;
/**
* Returns true if num is greater than zero, else false
*/
cljs.core.pos_QMARK_ = (function pos_QMARK_(n){
return (n > 0);
});
cljs.core.zero_QMARK_ = (function zero_QMARK_(n){
return (n === 0);
});
/**
* Returns true if num is less than zero, else false
*/
cljs.core.neg_QMARK_ = (function neg_QMARK_(x){
return (x < 0);
});
/**
* Returns the nth next of coll, (seq coll) when n is 0.
*/
cljs.core.nthnext = (function nthnext(coll,n){
var n__12534 = n;
var xs__12535 = cljs.core.seq.call(null,coll);
while(true){
if(cljs.core.truth_((function (){var and__3822__auto____12536 = xs__12535;
if(and__3822__auto____12536)
{return (n__12534 > 0);
} else
{return and__3822__auto____12536;
}
})()))
{{
var G__12537 = (n__12534 - 1);
var G__12538 = cljs.core.next.call(null,xs__12535);
n__12534 = G__12537;
xs__12535 = G__12538;
continue;
}
} else
{return xs__12535;
}
break;
}
});
/**
* Internal - do not use!
* @param {...*} var_args
*/
cljs.core.str_STAR_ = (function() {
var str_STAR_ = null;
var str_STAR___0 = (function (){
return "";
});
var str_STAR___1 = (function (x){
if((x == null))
{return "";
} else
{if("\uFDD0'else")
{return x.toString();
} else
{return null;
}
}
});
var str_STAR___2 = (function() { 
var G__12539__delegate = function (x,ys){
return (function (sb,more){
while(true){
if(cljs.core.truth_(more))
{{
var G__12540 = sb.append(str_STAR_.call(null,cljs.core.first.call(null,more)));
var G__12541 = cljs.core.next.call(null,more);
sb = G__12540;
more = G__12541;
continue;
}
} else
{return str_STAR_.call(null,sb);
}
break;
}
}).call(null,(new goog.string.StringBuffer(str_STAR_.call(null,x))),ys);
};
var G__12539 = function (x,var_args){
var ys = null;
if (goog.isDef(var_args)) {
  ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);
} 
return G__12539__delegate.call(this, x, ys);
};
G__12539.cljs$lang$maxFixedArity = 1;
G__12539.cljs$lang$applyTo = (function (arglist__12542){
var x = cljs.core.first(arglist__12542);
var ys = cljs.core.rest(arglist__12542);
return G__12539__delegate(x, ys);
});
G__12539.cljs$lang$arity$variadic = G__12539__delegate;
return G__12539;
})()
;
str_STAR_ = function(x,var_args){
var ys = var_args;
switch(arguments.length){
case 0:
return str_STAR___0.call(this);
case 1:
return str_STAR___1.call(this,x);
default:
return str_STAR___2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1));
}
throw('Invalid arity: ' + arguments.length);
};
str_STAR_.cljs$lang$maxFixedArity = 1;
str_STAR_.cljs$lang$applyTo = str_STAR___2.cljs$lang$applyTo;
str_STAR_.cljs$lang$arity$0 = str_STAR___0;
str_STAR_.cljs$lang$arity$1 = str_STAR___1;
str_STAR_.cljs$lang$arity$variadic = str_STAR___2.cljs$lang$arity$variadic;
return str_STAR_;
})()
;
/**
* With no args, returns the empty string. With one arg x, returns
* x.toString().  (str nil) returns the empty string. With more than
* one arg, returns the concatenation of the str values of the args.
* @param {...*} var_args
*/
cljs.core.str = (function() {
var str = null;
var str__0 = (function (){
return "";
});
var str__1 = (function (x){
if(cljs.core.symbol_QMARK_.call(null,x))
{return x.substring(2,x.length);
} else
{if(cljs.core.keyword_QMARK_.call(null,x))
{return cljs.core.str_STAR_.call(null,":",x.substring(2,x.length));
} else
{if((x == null))
{return "";
} else
{if("\uFDD0'else")
{return x.toString();
} else
{return null;
}
}
}
}
});
var str__2 = (function() { 
var G__12543__delegate = function (x,ys){
return (function (sb,more){
while(true){
if(cljs.core.truth_(more))
{{
var G__12544 = sb.append(str.call(null,cljs.core.first.call(null,more)));
var G__12545 = cljs.core.next.call(null,more);
sb = G__12544;
more = G__12545;
continue;
}
} else
{return cljs.core.str_STAR_.call(null,sb);
}
break;
}
}).call(null,(new goog.string.StringBuffer(str.call(null,x))),ys);
};
var G__12543 = function (x,var_args){
var ys = null;
if (goog.isDef(var_args)) {
  ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);
} 
return G__12543__delegate.call(this, x, ys);
};
G__12543.cljs$lang$maxFixedArity = 1;
G__12543.cljs$lang$applyTo = (function (arglist__12546){
var x = cljs.core.first(arglist__12546);
var ys = cljs.core.rest(arglist__12546);
return G__12543__delegate(x, ys);
});
G__12543.cljs$lang$arity$variadic = G__12543__delegate;
return G__12543;
})()
;
str = function(x,var_args){
var ys = var_args;
switch(arguments.length){
case 0:
return str__0.call(this);
case 1:
return str__1.call(this,x);
default:
return str__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1));
}
throw('Invalid arity: ' + arguments.length);
};
str.cljs$lang$maxFixedArity = 1;
str.cljs$lang$applyTo = str__2.cljs$lang$applyTo;
str.cljs$lang$arity$0 = str__0;
str.cljs$lang$arity$1 = str__1;
str.cljs$lang$arity$variadic = str__2.cljs$lang$arity$variadic;
return str;
})()
;
/**
* Returns the substring of s beginning at start inclusive, and ending
* at end (defaults to length of string), exclusive.
*/
cljs.core.subs = (function() {
var subs = null;
var subs__2 = (function (s,start){
return s.substring(start);
});
var subs__3 = (function (s,start,end){
return s.substring(start,end);
});
subs = function(s,start,end){
switch(arguments.length){
case 2:
return subs__2.call(this,s,start);
case 3:
return subs__3.call(this,s,start,end);
}
throw('Invalid arity: ' + arguments.length);
};
subs.cljs$lang$arity$2 = subs__2;
subs.cljs$lang$arity$3 = subs__3;
return subs;
})()
;
/**
* Formats a string using goog.string.format.
* @param {...*} var_args
*/
cljs.core.format = (function() { 
var format__delegate = function (fmt,args){
return cljs.core.apply.call(null,goog.string.format,fmt,args);
};
var format = function (fmt,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);
} 
return format__delegate.call(this, fmt, args);
};
format.cljs$lang$maxFixedArity = 1;
format.cljs$lang$applyTo = (function (arglist__12547){
var fmt = cljs.core.first(arglist__12547);
var args = cljs.core.rest(arglist__12547);
return format__delegate(fmt, args);
});
format.cljs$lang$arity$variadic = format__delegate;
return format;
})()
;
/**
* Returns a Symbol with the given namespace and name.
*/
cljs.core.symbol = (function() {
var symbol = null;
var symbol__1 = (function (name){
if(cljs.core.symbol_QMARK_.call(null,name))
{name;
} else
{if(cljs.core.keyword_QMARK_.call(null,name))
{cljs.core.str_STAR_.call(null,"\uFDD1","'",cljs.core.subs.call(null,name,2));
} else
{}
}
return cljs.core.str_STAR_.call(null,"\uFDD1","'",name);
});
var symbol__2 = (function (ns,name){
return symbol.call(null,cljs.core.str_STAR_.call(null,ns,"/",name));
});
symbol = function(ns,name){
switch(arguments.length){
case 1:
return symbol__1.call(this,ns);
case 2:
return symbol__2.call(this,ns,name);
}
throw('Invalid arity: ' + arguments.length);
};
symbol.cljs$lang$arity$1 = symbol__1;
symbol.cljs$lang$arity$2 = symbol__2;
return symbol;
})()
;
/**
* Returns a Keyword with the given namespace and name.  Do not use :
* in the keyword strings, it will be added automatically.
*/
cljs.core.keyword = (function() {
var keyword = null;
var keyword__1 = (function (name){
if(cljs.core.keyword_QMARK_.call(null,name))
{return name;
} else
{if(cljs.core.symbol_QMARK_.call(null,name))
{return cljs.core.str_STAR_.call(null,"\uFDD0","'",cljs.core.subs.call(null,name,2));
} else
{if("\uFDD0'else")
{return cljs.core.str_STAR_.call(null,"\uFDD0","'",name);
} else
{return null;
}
}
}
});
var keyword__2 = (function (ns,name){
return keyword.call(null,cljs.core.str_STAR_.call(null,ns,"/",name));
});
keyword = function(ns,name){
switch(arguments.length){
case 1:
return keyword__1.call(this,ns);
case 2:
return keyword__2.call(this,ns,name);
}
throw('Invalid arity: ' + arguments.length);
};
keyword.cljs$lang$arity$1 = keyword__1;
keyword.cljs$lang$arity$2 = keyword__2;
return keyword;
})()
;
/**
* Assumes x is sequential. Returns true if x equals y, otherwise
* returns false.
*/
cljs.core.equiv_sequential = (function equiv_sequential(x,y){
return cljs.core.boolean$.call(null,((cljs.core.sequential_QMARK_.call(null,y))?(function (){var xs__12550 = cljs.core.seq.call(null,x);
var ys__12551 = cljs.core.seq.call(null,y);
while(true){
if((xs__12550 == null))
{return (ys__12551 == null);
} else
{if((ys__12551 == null))
{return false;
} else
{if(cljs.core._EQ_.call(null,cljs.core.first.call(null,xs__12550),cljs.core.first.call(null,ys__12551)))
{{
var G__12552 = cljs.core.next.call(null,xs__12550);
var G__12553 = cljs.core.next.call(null,ys__12551);
xs__12550 = G__12552;
ys__12551 = G__12553;
continue;
}
} else
{if("\uFDD0'else")
{return false;
} else
{return null;
}
}
}
}
break;
}
})():null));
});
cljs.core.hash_combine = (function hash_combine(seed,hash){
return (seed ^ (((hash + 2654435769) + (seed << 6)) + (seed >> 2)));
});
cljs.core.hash_coll = (function hash_coll(coll){
return cljs.core.reduce.call(null,(function (p1__12554_SHARP_,p2__12555_SHARP_){
return cljs.core.hash_combine.call(null,p1__12554_SHARP_,cljs.core.hash.call(null,p2__12555_SHARP_,false));
}),cljs.core.hash.call(null,cljs.core.first.call(null,coll),false),cljs.core.next.call(null,coll));
});
cljs.core.hash_imap = (function hash_imap(m){
var h__12559 = 0;
var s__12560 = cljs.core.seq.call(null,m);
while(true){
if(s__12560)
{var e__12561 = cljs.core.first.call(null,s__12560);
{
var G__12562 = ((h__12559 + (cljs.core.hash.call(null,cljs.core.key.call(null,e__12561)) ^ cljs.core.hash.call(null,cljs.core.val.call(null,e__12561)))) % 4503599627370496);
var G__12563 = cljs.core.next.call(null,s__12560);
h__12559 = G__12562;
s__12560 = G__12563;
continue;
}
} else
{return h__12559;
}
break;
}
});
cljs.core.hash_iset = (function hash_iset(s){
var h__12567 = 0;
var s__12568 = cljs.core.seq.call(null,s);
while(true){
if(s__12568)
{var e__12569 = cljs.core.first.call(null,s__12568);
{
var G__12570 = ((h__12567 + cljs.core.hash.call(null,e__12569)) % 4503599627370496);
var G__12571 = cljs.core.next.call(null,s__12568);
h__12567 = G__12570;
s__12568 = G__12571;
continue;
}
} else
{return h__12567;
}
break;
}
});
/**
* Takes a JavaScript object and a map of names to functions and
* attaches said functions as methods on the object.  Any references to
* JavaScript's implict this (via the this-as macro) will resolve to the
* object that the function is attached.
*/
cljs.core.extend_object_BANG_ = (function extend_object_BANG_(obj,fn_map){
var G__12592__12593 = cljs.core.seq.call(null,fn_map);
if(G__12592__12593)
{var G__12595__12597 = cljs.core.first.call(null,G__12592__12593);
var vec__12596__12598 = G__12595__12597;
var key_name__12599 = cljs.core.nth.call(null,vec__12596__12598,0,null);
var f__12600 = cljs.core.nth.call(null,vec__12596__12598,1,null);
var G__12592__12601 = G__12592__12593;
var G__12595__12602 = G__12595__12597;
var G__12592__12603 = G__12592__12601;
while(true){
var vec__12604__12605 = G__12595__12602;
var key_name__12606 = cljs.core.nth.call(null,vec__12604__12605,0,null);
var f__12607 = cljs.core.nth.call(null,vec__12604__12605,1,null);
var G__12592__12608 = G__12592__12603;
var str_name__12609 = cljs.core.name.call(null,key_name__12606);
(obj[str_name__12609] = f__12607);
var temp__3974__auto____12610 = cljs.core.next.call(null,G__12592__12608);
if(temp__3974__auto____12610)
{var G__12592__12611 = temp__3974__auto____12610;
{
var G__12612 = cljs.core.first.call(null,G__12592__12611);
var G__12613 = G__12592__12611;
G__12595__12602 = G__12612;
G__12592__12603 = G__12613;
continue;
}
} else
{}
break;
}
} else
{}
return obj;
});

/**
* @constructor
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 65413358;
})
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/List");
});
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__12614 = this;
var h__4714__auto____12615 = this__12614.__hash;
if(!((h__4714__auto____12615 == null)))
{return h__4714__auto____12615;
} else
{var h__4714__auto____12616 = cljs.core.hash_coll.call(null,coll);
this__12614.__hash = h__4714__auto____12616;
return h__4714__auto____12616;
}
});
cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var this__12617 = this;
if((this__12617.count === 1))
{return null;
} else
{return this__12617.rest;
}
});
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var this__12618 = this;
return (new cljs.core.List(this__12618.meta,o,coll,(this__12618.count + 1),null));
});
cljs.core.List.prototype.toString = (function (){
var this__12619 = this;
var this__12620 = this;
return cljs.core.pr_str.call(null,this__12620);
});
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__12621 = this;
return coll;
});
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var this__12622 = this;
return this__12622.count;
});
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var this__12623 = this;
return this__12623.first;
});
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var this__12624 = this;
return coll.cljs$core$ISeq$_rest$arity$1(coll);
});
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var this__12625 = this;
return this__12625.first;
});
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var this__12626 = this;
if((this__12626.count === 1))
{return cljs.core.List.EMPTY;
} else
{return this__12626.rest;
}
});
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__12627 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__12628 = this;
return (new cljs.core.List(meta,this__12628.first,this__12628.rest,this__12628.count,this__12628.__hash));
});
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__12629 = this;
return this__12629.meta;
});
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__12630 = this;
return cljs.core.List.EMPTY;
});
cljs.core.List;

/**
* @constructor
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 65413326;
})
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/EmptyList");
});
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__12631 = this;
return 0;
});
cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var this__12632 = this;
return null;
});
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var this__12633 = this;
return (new cljs.core.List(this__12633.meta,o,null,1,null));
});
cljs.core.EmptyList.prototype.toString = (function (){
var this__12634 = this;
var this__12635 = this;
return cljs.core.pr_str.call(null,this__12635);
});
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__12636 = this;
return null;
});
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var this__12637 = this;
return 0;
});
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var this__12638 = this;
return null;
});
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var this__12639 = this;
throw (new Error("Can't pop empty list"));
});
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var this__12640 = this;
return null;
});
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var this__12641 = this;
return cljs.core.List.EMPTY;
});
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__12642 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__12643 = this;
return (new cljs.core.EmptyList(meta));
});
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__12644 = this;
return this__12644.meta;
});
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__12645 = this;
return coll;
});
cljs.core.EmptyList;
cljs.core.List.EMPTY = (new cljs.core.EmptyList(null));
cljs.core.reversible_QMARK_ = (function reversible_QMARK_(coll){
var G__12649__12650 = coll;
if(G__12649__12650)
{if((function (){var or__3824__auto____12651 = (G__12649__12650.cljs$lang$protocol_mask$partition0$ & 134217728);
if(or__3824__auto____12651)
{return or__3824__auto____12651;
} else
{return G__12649__12650.cljs$core$IReversible$;
}
})())
{return true;
} else
{if((!G__12649__12650.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IReversible,G__12649__12650);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IReversible,G__12649__12650);
}
});
cljs.core.rseq = (function rseq(coll){
return cljs.core._rseq.call(null,coll);
});
/**
* Returns a seq of the items in coll in reverse order. Not lazy.
*/
cljs.core.reverse = (function reverse(coll){
if(cljs.core.reversible_QMARK_.call(null,coll))
{return cljs.core.rseq.call(null,coll);
} else
{return cljs.core.reduce.call(null,cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
* @param {...*} var_args
*/
cljs.core.list = (function() {
var list = null;
var list__0 = (function (){
return cljs.core.List.EMPTY;
});
var list__1 = (function (x){
return cljs.core.conj.call(null,cljs.core.List.EMPTY,x);
});
var list__2 = (function (x,y){
return cljs.core.conj.call(null,list.call(null,y),x);
});
var list__3 = (function (x,y,z){
return cljs.core.conj.call(null,list.call(null,y,z),x);
});
var list__4 = (function() { 
var G__12652__delegate = function (x,y,z,items){
return cljs.core.conj.call(null,cljs.core.conj.call(null,cljs.core.conj.call(null,cljs.core.reduce.call(null,cljs.core.conj,cljs.core.List.EMPTY,cljs.core.reverse.call(null,items)),z),y),x);
};
var G__12652 = function (x,y,z,var_args){
var items = null;
if (goog.isDef(var_args)) {
  items = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__12652__delegate.call(this, x, y, z, items);
};
G__12652.cljs$lang$maxFixedArity = 3;
G__12652.cljs$lang$applyTo = (function (arglist__12653){
var x = cljs.core.first(arglist__12653);
var y = cljs.core.first(cljs.core.next(arglist__12653));
var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__12653)));
var items = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__12653)));
return G__12652__delegate(x, y, z, items);
});
G__12652.cljs$lang$arity$variadic = G__12652__delegate;
return G__12652;
})()
;
list = function(x,y,z,var_args){
var items = var_args;
switch(arguments.length){
case 0:
return list__0.call(this);
case 1:
return list__1.call(this,x);
case 2:
return list__2.call(this,x,y);
case 3:
return list__3.call(this,x,y,z);
default:
return list__4.cljs$lang$arity$variadic(x,y,z, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
list.cljs$lang$maxFixedArity = 3;
list.cljs$lang$applyTo = list__4.cljs$lang$applyTo;
list.cljs$lang$arity$0 = list__0;
list.cljs$lang$arity$1 = list__1;
list.cljs$lang$arity$2 = list__2;
list.cljs$lang$arity$3 = list__3;
list.cljs$lang$arity$variadic = list__4.cljs$lang$arity$variadic;
return list;
})()
;

/**
* @constructor
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 65405164;
})
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/Cons");
});
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__12654 = this;
var h__4714__auto____12655 = this__12654.__hash;
if(!((h__4714__auto____12655 == null)))
{return h__4714__auto____12655;
} else
{var h__4714__auto____12656 = cljs.core.hash_coll.call(null,coll);
this__12654.__hash = h__4714__auto____12656;
return h__4714__auto____12656;
}
});
cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var this__12657 = this;
if((this__12657.rest == null))
{return null;
} else
{return cljs.core._seq.call(null,this__12657.rest);
}
});
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var this__12658 = this;
return (new cljs.core.Cons(null,o,coll,this__12658.__hash));
});
cljs.core.Cons.prototype.toString = (function (){
var this__12659 = this;
var this__12660 = this;
return cljs.core.pr_str.call(null,this__12660);
});
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__12661 = this;
return coll;
});
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var this__12662 = this;
return this__12662.first;
});
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var this__12663 = this;
if((this__12663.rest == null))
{return cljs.core.List.EMPTY;
} else
{return this__12663.rest;
}
});
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__12664 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__12665 = this;
return (new cljs.core.Cons(meta,this__12665.first,this__12665.rest,this__12665.__hash));
});
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__12666 = this;
return this__12666.meta;
});
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__12667 = this;
return cljs.core.with_meta.call(null,cljs.core.List.EMPTY,this__12667.meta);
});
cljs.core.Cons;
/**
* Returns a new seq where x is the first element and seq is the rest.
*/
cljs.core.cons = (function cons(x,coll){
if((function (){var or__3824__auto____12672 = (coll == null);
if(or__3824__auto____12672)
{return or__3824__auto____12672;
} else
{var G__12673__12674 = coll;
if(G__12673__12674)
{if((function (){var or__3824__auto____12675 = (G__12673__12674.cljs$lang$protocol_mask$partition0$ & 64);
if(or__3824__auto____12675)
{return or__3824__auto____12675;
} else
{return G__12673__12674.cljs$core$ISeq$;
}
})())
{return true;
} else
{if((!G__12673__12674.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.ISeq,G__12673__12674);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.ISeq,G__12673__12674);
}
}
})())
{return (new cljs.core.Cons(null,x,coll,null));
} else
{return (new cljs.core.Cons(null,x,cljs.core.seq.call(null,coll),null));
}
});
cljs.core.list_QMARK_ = (function list_QMARK_(x){
var G__12679__12680 = x;
if(G__12679__12680)
{if((function (){var or__3824__auto____12681 = (G__12679__12680.cljs$lang$protocol_mask$partition0$ & 33554432);
if(or__3824__auto____12681)
{return or__3824__auto____12681;
} else
{return G__12679__12680.cljs$core$IList$;
}
})())
{return true;
} else
{if((!G__12679__12680.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IList,G__12679__12680);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IList,G__12679__12680);
}
});
(cljs.core.IReduce["string"] = true);
(cljs.core._reduce["string"] = (function() {
var G__12682 = null;
var G__12682__2 = (function (string,f){
return cljs.core.ci_reduce.call(null,string,f);
});
var G__12682__3 = (function (string,f,start){
return cljs.core.ci_reduce.call(null,string,f,start);
});
G__12682 = function(string,f,start){
switch(arguments.length){
case 2:
return G__12682__2.call(this,string,f);
case 3:
return G__12682__3.call(this,string,f,start);
}
throw('Invalid arity: ' + arguments.length);
};
return G__12682;
})()
);
(cljs.core.ILookup["string"] = true);
(cljs.core._lookup["string"] = (function() {
var G__12683 = null;
var G__12683__2 = (function (string,k){
return cljs.core._nth.call(null,string,k);
});
var G__12683__3 = (function (string,k,not_found){
return cljs.core._nth.call(null,string,k,not_found);
});
G__12683 = function(string,k,not_found){
switch(arguments.length){
case 2:
return G__12683__2.call(this,string,k);
case 3:
return G__12683__3.call(this,string,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__12683;
})()
);
(cljs.core.IIndexed["string"] = true);
(cljs.core._nth["string"] = (function() {
var G__12684 = null;
var G__12684__2 = (function (string,n){
if((n < cljs.core._count.call(null,string)))
{return string.charAt(n);
} else
{return null;
}
});
var G__12684__3 = (function (string,n,not_found){
if((n < cljs.core._count.call(null,string)))
{return string.charAt(n);
} else
{return not_found;
}
});
G__12684 = function(string,n,not_found){
switch(arguments.length){
case 2:
return G__12684__2.call(this,string,n);
case 3:
return G__12684__3.call(this,string,n,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__12684;
})()
);
(cljs.core.ICounted["string"] = true);
(cljs.core._count["string"] = (function (s){
return s.length;
}));
(cljs.core.ISeqable["string"] = true);
(cljs.core._seq["string"] = (function (string){
return cljs.core.prim_seq.call(null,string,0);
}));
(cljs.core.IHash["string"] = true);
(cljs.core._hash["string"] = (function (o){
return goog.string.hashCode(o);
}));

/**
* @constructor
*/
cljs.core.Keyword = (function (k){
this.k = k;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 1;
})
cljs.core.Keyword.cljs$lang$type = true;
cljs.core.Keyword.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/Keyword");
});
cljs.core.Keyword.prototype.call = (function() {
var G__12696 = null;
var G__12696__2 = (function (this_sym12687,coll){
var this__12689 = this;
var this_sym12687__12690 = this;
var ___12691 = this_sym12687__12690;
if((coll == null))
{return null;
} else
{var strobj__12692 = coll.strobj;
if((strobj__12692 == null))
{return cljs.core._lookup.call(null,coll,this__12689.k,null);
} else
{return (strobj__12692[this__12689.k]);
}
}
});
var G__12696__3 = (function (this_sym12688,coll,not_found){
var this__12689 = this;
var this_sym12688__12693 = this;
var ___12694 = this_sym12688__12693;
if((coll == null))
{return not_found;
} else
{return cljs.core._lookup.call(null,coll,this__12689.k,not_found);
}
});
G__12696 = function(this_sym12688,coll,not_found){
switch(arguments.length){
case 2:
return G__12696__2.call(this,this_sym12688,coll);
case 3:
return G__12696__3.call(this,this_sym12688,coll,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__12696;
})()
;
cljs.core.Keyword.prototype.apply = (function (this_sym12685,args12686){
var this__12695 = this;
return this_sym12685.call.apply(this_sym12685,[this_sym12685].concat(args12686.slice()));
});
cljs.core.Keyword;
String.prototype.cljs$core$IFn$ = true;
String.prototype.call = (function() {
var G__12705 = null;
var G__12705__2 = (function (this_sym12699,coll){
var this_sym12699__12701 = this;
var this__12702 = this_sym12699__12701;
return cljs.core._lookup.call(null,coll,this__12702.toString(),null);
});
var G__12705__3 = (function (this_sym12700,coll,not_found){
var this_sym12700__12703 = this;
var this__12704 = this_sym12700__12703;
return cljs.core._lookup.call(null,coll,this__12704.toString(),not_found);
});
G__12705 = function(this_sym12700,coll,not_found){
switch(arguments.length){
case 2:
return G__12705__2.call(this,this_sym12700,coll);
case 3:
return G__12705__3.call(this,this_sym12700,coll,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__12705;
})()
;
String.prototype.apply = (function (this_sym12697,args12698){
return this_sym12697.call.apply(this_sym12697,[this_sym12697].concat(args12698.slice()));
});
String.prototype.apply = (function (s,args){
if((cljs.core.count.call(null,args) < 2))
{return cljs.core._lookup.call(null,(args[0]),s,null);
} else
{return cljs.core._lookup.call(null,(args[0]),s,(args[1]));
}
});
cljs.core.lazy_seq_value = (function lazy_seq_value(lazy_seq){
var x__12707 = lazy_seq.x;
if(lazy_seq.realized)
{return x__12707;
} else
{lazy_seq.x = x__12707.call(null);
lazy_seq.realized = true;
return lazy_seq.x;
}
});

/**
* @constructor
*/
cljs.core.LazySeq = (function (meta,realized,x,__hash){
this.meta = meta;
this.realized = realized;
this.x = x;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31850700;
})
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/LazySeq");
});
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__12708 = this;
var h__4714__auto____12709 = this__12708.__hash;
if(!((h__4714__auto____12709 == null)))
{return h__4714__auto____12709;
} else
{var h__4714__auto____12710 = cljs.core.hash_coll.call(null,coll);
this__12708.__hash = h__4714__auto____12710;
return h__4714__auto____12710;
}
});
cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var this__12711 = this;
return cljs.core._seq.call(null,coll.cljs$core$ISeq$_rest$arity$1(coll));
});
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var this__12712 = this;
return cljs.core.cons.call(null,o,coll);
});
cljs.core.LazySeq.prototype.toString = (function (){
var this__12713 = this;
var this__12714 = this;
return cljs.core.pr_str.call(null,this__12714);
});
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__12715 = this;
return cljs.core.seq.call(null,cljs.core.lazy_seq_value.call(null,coll));
});
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var this__12716 = this;
return cljs.core.first.call(null,cljs.core.lazy_seq_value.call(null,coll));
});
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var this__12717 = this;
return cljs.core.rest.call(null,cljs.core.lazy_seq_value.call(null,coll));
});
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__12718 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__12719 = this;
return (new cljs.core.LazySeq(meta,this__12719.realized,this__12719.x,this__12719.__hash));
});
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__12720 = this;
return this__12720.meta;
});
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__12721 = this;
return cljs.core.with_meta.call(null,cljs.core.List.EMPTY,this__12721.meta);
});
cljs.core.LazySeq;

/**
* @constructor
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2;
})
cljs.core.ChunkBuffer.cljs$lang$type = true;
cljs.core.ChunkBuffer.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/ChunkBuffer");
});
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var this__12722 = this;
return this__12722.end;
});
cljs.core.ChunkBuffer.prototype.add = (function (o){
var this__12723 = this;
var ___12724 = this;
(this__12723.buf[this__12723.end] = o);
return this__12723.end = (this__12723.end + 1);
});
cljs.core.ChunkBuffer.prototype.chunk = (function (o){
var this__12725 = this;
var ___12726 = this;
var ret__12727 = (new cljs.core.ArrayChunk(this__12725.buf,0,this__12725.end));
this__12725.buf = null;
return ret__12727;
});
cljs.core.ChunkBuffer;
cljs.core.chunk_buffer = (function chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer(cljs.core.make_array.call(null,capacity),0));
});

/**
* @constructor
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 524306;
})
cljs.core.ArrayChunk.cljs$lang$type = true;
cljs.core.ArrayChunk.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/ArrayChunk");
});
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var this__12728 = this;
return cljs.core.ci_reduce.call(null,coll,f,(this__12728.arr[this__12728.off]),(this__12728.off + 1));
});
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var this__12729 = this;
return cljs.core.ci_reduce.call(null,coll,f,start,this__12729.off);
});
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var this__12730 = this;
if((this__12730.off === this__12730.end))
{throw (new Error("-drop-first of empty chunk"));
} else
{return (new cljs.core.ArrayChunk(this__12730.arr,(this__12730.off + 1),this__12730.end));
}
});
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var this__12731 = this;
return (this__12731.arr[(this__12731.off + i)]);
});
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var this__12732 = this;
if((function (){var and__3822__auto____12733 = (i >= 0);
if(and__3822__auto____12733)
{return (i < (this__12732.end - this__12732.off));
} else
{return and__3822__auto____12733;
}
})())
{return (this__12732.arr[(this__12732.off + i)]);
} else
{return not_found;
}
});
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var this__12734 = this;
return (this__12734.end - this__12734.off);
});
cljs.core.ArrayChunk;
cljs.core.array_chunk = (function() {
var array_chunk = null;
var array_chunk__1 = (function (arr){
return array_chunk.call(null,arr,0,arr.length);
});
var array_chunk__2 = (function (arr,off){
return array_chunk.call(null,arr,off,arr.length);
});
var array_chunk__3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});
array_chunk = function(arr,off,end){
switch(arguments.length){
case 1:
return array_chunk__1.call(this,arr);
case 2:
return array_chunk__2.call(this,arr,off);
case 3:
return array_chunk__3.call(this,arr,off,end);
}
throw('Invalid arity: ' + arguments.length);
};
array_chunk.cljs$lang$arity$1 = array_chunk__1;
array_chunk.cljs$lang$arity$2 = array_chunk__2;
array_chunk.cljs$lang$arity$3 = array_chunk__3;
return array_chunk;
})()
;

/**
* @constructor
*/
cljs.core.ChunkedCons = (function (chunk,more,meta){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 27656296;
})
cljs.core.ChunkedCons.cljs$lang$type = true;
cljs.core.ChunkedCons.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/ChunkedCons");
});
cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var this__12735 = this;
return cljs.core.cons.call(null,o,this$);
});
cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__12736 = this;
return coll;
});
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var this__12737 = this;
return cljs.core._nth.call(null,this__12737.chunk,0);
});
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var this__12738 = this;
if((cljs.core._count.call(null,this__12738.chunk) > 1))
{return (new cljs.core.ChunkedCons(cljs.core._drop_first.call(null,this__12738.chunk),this__12738.more,this__12738.meta));
} else
{if((this__12738.more == null))
{return cljs.core.List.EMPTY;
} else
{return this__12738.more;
}
}
});
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$ = true;
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var this__12739 = this;
if((this__12739.more == null))
{return null;
} else
{return this__12739.more;
}
});
cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__12740 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var this__12741 = this;
return (new cljs.core.ChunkedCons(this__12741.chunk,this__12741.more,m));
});
cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__12742 = this;
return this__12742.meta;
});
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$ = true;
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var this__12743 = this;
return this__12743.chunk;
});
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var this__12744 = this;
if((this__12744.more == null))
{return cljs.core.List.EMPTY;
} else
{return this__12744.more;
}
});
cljs.core.ChunkedCons;
cljs.core.chunk_cons = (function chunk_cons(chunk,rest){
if((cljs.core._count.call(null,chunk) === 0))
{return rest;
} else
{return (new cljs.core.ChunkedCons(chunk,rest,null));
}
});
cljs.core.chunk_append = (function chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function chunk_first(s){
return cljs.core._chunked_first.call(null,s);
});
cljs.core.chunk_rest = (function chunk_rest(s){
return cljs.core._chunked_rest.call(null,s);
});
cljs.core.chunk_next = (function chunk_next(s){
if((function (){var G__12748__12749 = s;
if(G__12748__12749)
{if(cljs.core.truth_((function (){var or__3824__auto____12750 = null;
if(cljs.core.truth_(or__3824__auto____12750))
{return or__3824__auto____12750;
} else
{return G__12748__12749.cljs$core$IChunkedNext$;
}
})()))
{return true;
} else
{if((!G__12748__12749.cljs$lang$protocol_mask$partition$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IChunkedNext,G__12748__12749);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IChunkedNext,G__12748__12749);
}
})())
{return cljs.core._chunked_next.call(null,s);
} else
{return cljs.core.seq.call(null,cljs.core._chunked_rest.call(null,s));
}
});
/**
* Naive impl of to-array as a start.
*/
cljs.core.to_array = (function to_array(s){
var ary__12753 = [];
var s__12754 = s;
while(true){
if(cljs.core.seq.call(null,s__12754))
{ary__12753.push(cljs.core.first.call(null,s__12754));
{
var G__12755 = cljs.core.next.call(null,s__12754);
s__12754 = G__12755;
continue;
}
} else
{return ary__12753;
}
break;
}
});
/**
* Returns a (potentially-ragged) 2-dimensional array
* containing the contents of coll.
*/
cljs.core.to_array_2d = (function to_array_2d(coll){
var ret__12759 = cljs.core.make_array.call(null,cljs.core.count.call(null,coll));
var i__12760 = 0;
var xs__12761 = cljs.core.seq.call(null,coll);
while(true){
if(xs__12761)
{(ret__12759[i__12760] = cljs.core.to_array.call(null,cljs.core.first.call(null,xs__12761)));
{
var G__12762 = (i__12760 + 1);
var G__12763 = cljs.core.next.call(null,xs__12761);
i__12760 = G__12762;
xs__12761 = G__12763;
continue;
}
} else
{}
break;
}
return ret__12759;
});
cljs.core.long_array = (function() {
var long_array = null;
var long_array__1 = (function (size_or_seq){
if(cljs.core.number_QMARK_.call(null,size_or_seq))
{return long_array.call(null,size_or_seq,null);
} else
{if(cljs.core.seq_QMARK_.call(null,size_or_seq))
{return cljs.core.into_array.call(null,size_or_seq);
} else
{if("\uFDD0'else")
{throw (new Error("long-array called with something other than size or ISeq"));
} else
{return null;
}
}
}
});
var long_array__2 = (function (size,init_val_or_seq){
var a__12771 = cljs.core.make_array.call(null,size);
if(cljs.core.seq_QMARK_.call(null,init_val_or_seq))
{var s__12772 = cljs.core.seq.call(null,init_val_or_seq);
var i__12773 = 0;
var s__12774 = s__12772;
while(true){
if(cljs.core.truth_((function (){var and__3822__auto____12775 = s__12774;
if(and__3822__auto____12775)
{return (i__12773 < size);
} else
{return and__3822__auto____12775;
}
})()))
{(a__12771[i__12773] = cljs.core.first.call(null,s__12774));
{
var G__12778 = (i__12773 + 1);
var G__12779 = cljs.core.next.call(null,s__12774);
i__12773 = G__12778;
s__12774 = G__12779;
continue;
}
} else
{return a__12771;
}
break;
}
} else
{var n__5049__auto____12776 = size;
var i__12777 = 0;
while(true){
if((i__12777 < n__5049__auto____12776))
{(a__12771[i__12777] = init_val_or_seq);
{
var G__12780 = (i__12777 + 1);
i__12777 = G__12780;
continue;
}
} else
{}
break;
}
return a__12771;
}
});
long_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return long_array__1.call(this,size);
case 2:
return long_array__2.call(this,size,init_val_or_seq);
}
throw('Invalid arity: ' + arguments.length);
};
long_array.cljs$lang$arity$1 = long_array__1;
long_array.cljs$lang$arity$2 = long_array__2;
return long_array;
})()
;
cljs.core.double_array = (function() {
var double_array = null;
var double_array__1 = (function (size_or_seq){
if(cljs.core.number_QMARK_.call(null,size_or_seq))
{return double_array.call(null,size_or_seq,null);
} else
{if(cljs.core.seq_QMARK_.call(null,size_or_seq))
{return cljs.core.into_array.call(null,size_or_seq);
} else
{if("\uFDD0'else")
{throw (new Error("double-array called with something other than size or ISeq"));
} else
{return null;
}
}
}
});
var double_array__2 = (function (size,init_val_or_seq){
var a__12788 = cljs.core.make_array.call(null,size);
if(cljs.core.seq_QMARK_.call(null,init_val_or_seq))
{var s__12789 = cljs.core.seq.call(null,init_val_or_seq);
var i__12790 = 0;
var s__12791 = s__12789;
while(true){
if(cljs.core.truth_((function (){var and__3822__auto____12792 = s__12791;
if(and__3822__auto____12792)
{return (i__12790 < size);
} else
{return and__3822__auto____12792;
}
})()))
{(a__12788[i__12790] = cljs.core.first.call(null,s__12791));
{
var G__12795 = (i__12790 + 1);
var G__12796 = cljs.core.next.call(null,s__12791);
i__12790 = G__12795;
s__12791 = G__12796;
continue;
}
} else
{return a__12788;
}
break;
}
} else
{var n__5049__auto____12793 = size;
var i__12794 = 0;
while(true){
if((i__12794 < n__5049__auto____12793))
{(a__12788[i__12794] = init_val_or_seq);
{
var G__12797 = (i__12794 + 1);
i__12794 = G__12797;
continue;
}
} else
{}
break;
}
return a__12788;
}
});
double_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return double_array__1.call(this,size);
case 2:
return double_array__2.call(this,size,init_val_or_seq);
}
throw('Invalid arity: ' + arguments.length);
};
double_array.cljs$lang$arity$1 = double_array__1;
double_array.cljs$lang$arity$2 = double_array__2;
return double_array;
})()
;
cljs.core.object_array = (function() {
var object_array = null;
var object_array__1 = (function (size_or_seq){
if(cljs.core.number_QMARK_.call(null,size_or_seq))
{return object_array.call(null,size_or_seq,null);
} else
{if(cljs.core.seq_QMARK_.call(null,size_or_seq))
{return cljs.core.into_array.call(null,size_or_seq);
} else
{if("\uFDD0'else")
{throw (new Error("object-array called with something other than size or ISeq"));
} else
{return null;
}
}
}
});
var object_array__2 = (function (size,init_val_or_seq){
var a__12805 = cljs.core.make_array.call(null,size);
if(cljs.core.seq_QMARK_.call(null,init_val_or_seq))
{var s__12806 = cljs.core.seq.call(null,init_val_or_seq);
var i__12807 = 0;
var s__12808 = s__12806;
while(true){
if(cljs.core.truth_((function (){var and__3822__auto____12809 = s__12808;
if(and__3822__auto____12809)
{return (i__12807 < size);
} else
{return and__3822__auto____12809;
}
})()))
{(a__12805[i__12807] = cljs.core.first.call(null,s__12808));
{
var G__12812 = (i__12807 + 1);
var G__12813 = cljs.core.next.call(null,s__12808);
i__12807 = G__12812;
s__12808 = G__12813;
continue;
}
} else
{return a__12805;
}
break;
}
} else
{var n__5049__auto____12810 = size;
var i__12811 = 0;
while(true){
if((i__12811 < n__5049__auto____12810))
{(a__12805[i__12811] = init_val_or_seq);
{
var G__12814 = (i__12811 + 1);
i__12811 = G__12814;
continue;
}
} else
{}
break;
}
return a__12805;
}
});
object_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return object_array__1.call(this,size);
case 2:
return object_array__2.call(this,size,init_val_or_seq);
}
throw('Invalid arity: ' + arguments.length);
};
object_array.cljs$lang$arity$1 = object_array__1;
object_array.cljs$lang$arity$2 = object_array__2;
return object_array;
})()
;
cljs.core.bounded_count = (function bounded_count(s,n){
if(cljs.core.counted_QMARK_.call(null,s))
{return cljs.core.count.call(null,s);
} else
{var s__12819 = s;
var i__12820 = n;
var sum__12821 = 0;
while(true){
if(cljs.core.truth_((function (){var and__3822__auto____12822 = (i__12820 > 0);
if(and__3822__auto____12822)
{return cljs.core.seq.call(null,s__12819);
} else
{return and__3822__auto____12822;
}
})()))
{{
var G__12823 = cljs.core.next.call(null,s__12819);
var G__12824 = (i__12820 - 1);
var G__12825 = (sum__12821 + 1);
s__12819 = G__12823;
i__12820 = G__12824;
sum__12821 = G__12825;
continue;
}
} else
{return sum__12821;
}
break;
}
}
});
cljs.core.spread = (function spread(arglist){
if((arglist == null))
{return null;
} else
{if((cljs.core.next.call(null,arglist) == null))
{return cljs.core.seq.call(null,cljs.core.first.call(null,arglist));
} else
{if("\uFDD0'else")
{return cljs.core.cons.call(null,cljs.core.first.call(null,arglist),spread.call(null,cljs.core.next.call(null,arglist)));
} else
{return null;
}
}
}
});
/**
* Returns a lazy seq representing the concatenation of the elements in the supplied colls.
* @param {...*} var_args
*/
cljs.core.concat = (function() {
var concat = null;
var concat__0 = (function (){
return (new cljs.core.LazySeq(null,false,(function (){
return null;
}),null));
});
var concat__1 = (function (x){
return (new cljs.core.LazySeq(null,false,(function (){
return x;
}),null));
});
var concat__2 = (function (x,y){
return (new cljs.core.LazySeq(null,false,(function (){
var s__12830 = cljs.core.seq.call(null,x);
if(s__12830)
{if(cljs.core.chunked_seq_QMARK_.call(null,s__12830))
{return cljs.core.chunk_cons.call(null,cljs.core.chunk_first.call(null,s__12830),concat.call(null,cljs.core.chunk_rest.call(null,s__12830),y));
} else
{return cljs.core.cons.call(null,cljs.core.first.call(null,s__12830),concat.call(null,cljs.core.rest.call(null,s__12830),y));
}
} else
{return y;
}
}),null));
});
var concat__3 = (function() { 
var G__12834__delegate = function (x,y,zs){
var cat__12833 = (function cat(xys,zs){
return (new cljs.core.LazySeq(null,false,(function (){
var xys__12832 = cljs.core.seq.call(null,xys);
if(xys__12832)
{if(cljs.core.chunked_seq_QMARK_.call(null,xys__12832))
{return cljs.core.chunk_cons.call(null,cljs.core.chunk_first.call(null,xys__12832),cat.call(null,cljs.core.chunk_rest.call(null,xys__12832),zs));
} else
{return cljs.core.cons.call(null,cljs.core.first.call(null,xys__12832),cat.call(null,cljs.core.rest.call(null,xys__12832),zs));
}
} else
{if(cljs.core.truth_(zs))
{return cat.call(null,cljs.core.first.call(null,zs),cljs.core.next.call(null,zs));
} else
{return null;
}
}
}),null));
});
return cat__12833.call(null,concat.call(null,x,y),zs);
};
var G__12834 = function (x,y,var_args){
var zs = null;
if (goog.isDef(var_args)) {
  zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12834__delegate.call(this, x, y, zs);
};
G__12834.cljs$lang$maxFixedArity = 2;
G__12834.cljs$lang$applyTo = (function (arglist__12835){
var x = cljs.core.first(arglist__12835);
var y = cljs.core.first(cljs.core.next(arglist__12835));
var zs = cljs.core.rest(cljs.core.next(arglist__12835));
return G__12834__delegate(x, y, zs);
});
G__12834.cljs$lang$arity$variadic = G__12834__delegate;
return G__12834;
})()
;
concat = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return concat__0.call(this);
case 1:
return concat__1.call(this,x);
case 2:
return concat__2.call(this,x,y);
default:
return concat__3.cljs$lang$arity$variadic(x,y, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
concat.cljs$lang$maxFixedArity = 2;
concat.cljs$lang$applyTo = concat__3.cljs$lang$applyTo;
concat.cljs$lang$arity$0 = concat__0;
concat.cljs$lang$arity$1 = concat__1;
concat.cljs$lang$arity$2 = concat__2;
concat.cljs$lang$arity$variadic = concat__3.cljs$lang$arity$variadic;
return concat;
})()
;
/**
* Creates a new list containing the items prepended to the rest, the
* last of which will be treated as a sequence.
* @param {...*} var_args
*/
cljs.core.list_STAR_ = (function() {
var list_STAR_ = null;
var list_STAR___1 = (function (args){
return cljs.core.seq.call(null,args);
});
var list_STAR___2 = (function (a,args){
return cljs.core.cons.call(null,a,args);
});
var list_STAR___3 = (function (a,b,args){
return cljs.core.cons.call(null,a,cljs.core.cons.call(null,b,args));
});
var list_STAR___4 = (function (a,b,c,args){
return cljs.core.cons.call(null,a,cljs.core.cons.call(null,b,cljs.core.cons.call(null,c,args)));
});
var list_STAR___5 = (function() { 
var G__12836__delegate = function (a,b,c,d,more){
return cljs.core.cons.call(null,a,cljs.core.cons.call(null,b,cljs.core.cons.call(null,c,cljs.core.cons.call(null,d,cljs.core.spread.call(null,more)))));
};
var G__12836 = function (a,b,c,d,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4),0);
} 
return G__12836__delegate.call(this, a, b, c, d, more);
};
G__12836.cljs$lang$maxFixedArity = 4;
G__12836.cljs$lang$applyTo = (function (arglist__12837){
var a = cljs.core.first(arglist__12837);
var b = cljs.core.first(cljs.core.next(arglist__12837));
var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__12837)));
var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__12837))));
var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__12837))));
return G__12836__delegate(a, b, c, d, more);
});
G__12836.cljs$lang$arity$variadic = G__12836__delegate;
return G__12836;
})()
;
list_STAR_ = function(a,b,c,d,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return list_STAR___1.call(this,a);
case 2:
return list_STAR___2.call(this,a,b);
case 3:
return list_STAR___3.call(this,a,b,c);
case 4:
return list_STAR___4.call(this,a,b,c,d);
default:
return list_STAR___5.cljs$lang$arity$variadic(a,b,c,d, cljs.core.array_seq(arguments, 4));
}
throw('Invalid arity: ' + arguments.length);
};
list_STAR_.cljs$lang$maxFixedArity = 4;
list_STAR_.cljs$lang$applyTo = list_STAR___5.cljs$lang$applyTo;
list_STAR_.cljs$lang$arity$1 = list_STAR___1;
list_STAR_.cljs$lang$arity$2 = list_STAR___2;
list_STAR_.cljs$lang$arity$3 = list_STAR___3;
list_STAR_.cljs$lang$arity$4 = list_STAR___4;
list_STAR_.cljs$lang$arity$variadic = list_STAR___5.cljs$lang$arity$variadic;
return list_STAR_;
})()
;
cljs.core.transient$ = (function transient$(coll){
return cljs.core._as_transient.call(null,coll);
});
cljs.core.persistent_BANG_ = (function persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_.call(null,tcoll);
});
cljs.core.conj_BANG_ = (function conj_BANG_(tcoll,val){
return cljs.core._conj_BANG_.call(null,tcoll,val);
});
cljs.core.assoc_BANG_ = (function assoc_BANG_(tcoll,key,val){
return cljs.core._assoc_BANG_.call(null,tcoll,key,val);
});
cljs.core.dissoc_BANG_ = (function dissoc_BANG_(tcoll,key){
return cljs.core._dissoc_BANG_.call(null,tcoll,key);
});
cljs.core.pop_BANG_ = (function pop_BANG_(tcoll){
return cljs.core._pop_BANG_.call(null,tcoll);
});
cljs.core.disj_BANG_ = (function disj_BANG_(tcoll,val){
return cljs.core._disjoin_BANG_.call(null,tcoll,val);
});
cljs.core.apply_to = (function apply_to(f,argc,args){
var args__12879 = cljs.core.seq.call(null,args);
if((argc === 0))
{return f.call(null);
} else
{var a__12880 = cljs.core._first.call(null,args__12879);
var args__12881 = cljs.core._rest.call(null,args__12879);
if((argc === 1))
{if(f.cljs$lang$arity$1)
{return f.cljs$lang$arity$1(a__12880);
} else
{return f.call(null,a__12880);
}
} else
{var b__12882 = cljs.core._first.call(null,args__12881);
var args__12883 = cljs.core._rest.call(null,args__12881);
if((argc === 2))
{if(f.cljs$lang$arity$2)
{return f.cljs$lang$arity$2(a__12880,b__12882);
} else
{return f.call(null,a__12880,b__12882);
}
} else
{var c__12884 = cljs.core._first.call(null,args__12883);
var args__12885 = cljs.core._rest.call(null,args__12883);
if((argc === 3))
{if(f.cljs$lang$arity$3)
{return f.cljs$lang$arity$3(a__12880,b__12882,c__12884);
} else
{return f.call(null,a__12880,b__12882,c__12884);
}
} else
{var d__12886 = cljs.core._first.call(null,args__12885);
var args__12887 = cljs.core._rest.call(null,args__12885);
if((argc === 4))
{if(f.cljs$lang$arity$4)
{return f.cljs$lang$arity$4(a__12880,b__12882,c__12884,d__12886);
} else
{return f.call(null,a__12880,b__12882,c__12884,d__12886);
}
} else
{var e__12888 = cljs.core._first.call(null,args__12887);
var args__12889 = cljs.core._rest.call(null,args__12887);
if((argc === 5))
{if(f.cljs$lang$arity$5)
{return f.cljs$lang$arity$5(a__12880,b__12882,c__12884,d__12886,e__12888);
} else
{return f.call(null,a__12880,b__12882,c__12884,d__12886,e__12888);
}
} else
{var f__12890 = cljs.core._first.call(null,args__12889);
var args__12891 = cljs.core._rest.call(null,args__12889);
if((argc === 6))
{if(f__12890.cljs$lang$arity$6)
{return f__12890.cljs$lang$arity$6(a__12880,b__12882,c__12884,d__12886,e__12888,f__12890);
} else
{return f__12890.call(null,a__12880,b__12882,c__12884,d__12886,e__12888,f__12890);
}
} else
{var g__12892 = cljs.core._first.call(null,args__12891);
var args__12893 = cljs.core._rest.call(null,args__12891);
if((argc === 7))
{if(f__12890.cljs$lang$arity$7)
{return f__12890.cljs$lang$arity$7(a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892);
} else
{return f__12890.call(null,a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892);
}
} else
{var h__12894 = cljs.core._first.call(null,args__12893);
var args__12895 = cljs.core._rest.call(null,args__12893);
if((argc === 8))
{if(f__12890.cljs$lang$arity$8)
{return f__12890.cljs$lang$arity$8(a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894);
} else
{return f__12890.call(null,a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894);
}
} else
{var i__12896 = cljs.core._first.call(null,args__12895);
var args__12897 = cljs.core._rest.call(null,args__12895);
if((argc === 9))
{if(f__12890.cljs$lang$arity$9)
{return f__12890.cljs$lang$arity$9(a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896);
} else
{return f__12890.call(null,a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896);
}
} else
{var j__12898 = cljs.core._first.call(null,args__12897);
var args__12899 = cljs.core._rest.call(null,args__12897);
if((argc === 10))
{if(f__12890.cljs$lang$arity$10)
{return f__12890.cljs$lang$arity$10(a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898);
} else
{return f__12890.call(null,a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898);
}
} else
{var k__12900 = cljs.core._first.call(null,args__12899);
var args__12901 = cljs.core._rest.call(null,args__12899);
if((argc === 11))
{if(f__12890.cljs$lang$arity$11)
{return f__12890.cljs$lang$arity$11(a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900);
} else
{return f__12890.call(null,a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900);
}
} else
{var l__12902 = cljs.core._first.call(null,args__12901);
var args__12903 = cljs.core._rest.call(null,args__12901);
if((argc === 12))
{if(f__12890.cljs$lang$arity$12)
{return f__12890.cljs$lang$arity$12(a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902);
} else
{return f__12890.call(null,a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902);
}
} else
{var m__12904 = cljs.core._first.call(null,args__12903);
var args__12905 = cljs.core._rest.call(null,args__12903);
if((argc === 13))
{if(f__12890.cljs$lang$arity$13)
{return f__12890.cljs$lang$arity$13(a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902,m__12904);
} else
{return f__12890.call(null,a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902,m__12904);
}
} else
{var n__12906 = cljs.core._first.call(null,args__12905);
var args__12907 = cljs.core._rest.call(null,args__12905);
if((argc === 14))
{if(f__12890.cljs$lang$arity$14)
{return f__12890.cljs$lang$arity$14(a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902,m__12904,n__12906);
} else
{return f__12890.call(null,a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902,m__12904,n__12906);
}
} else
{var o__12908 = cljs.core._first.call(null,args__12907);
var args__12909 = cljs.core._rest.call(null,args__12907);
if((argc === 15))
{if(f__12890.cljs$lang$arity$15)
{return f__12890.cljs$lang$arity$15(a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902,m__12904,n__12906,o__12908);
} else
{return f__12890.call(null,a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902,m__12904,n__12906,o__12908);
}
} else
{var p__12910 = cljs.core._first.call(null,args__12909);
var args__12911 = cljs.core._rest.call(null,args__12909);
if((argc === 16))
{if(f__12890.cljs$lang$arity$16)
{return f__12890.cljs$lang$arity$16(a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902,m__12904,n__12906,o__12908,p__12910);
} else
{return f__12890.call(null,a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902,m__12904,n__12906,o__12908,p__12910);
}
} else
{var q__12912 = cljs.core._first.call(null,args__12911);
var args__12913 = cljs.core._rest.call(null,args__12911);
if((argc === 17))
{if(f__12890.cljs$lang$arity$17)
{return f__12890.cljs$lang$arity$17(a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902,m__12904,n__12906,o__12908,p__12910,q__12912);
} else
{return f__12890.call(null,a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902,m__12904,n__12906,o__12908,p__12910,q__12912);
}
} else
{var r__12914 = cljs.core._first.call(null,args__12913);
var args__12915 = cljs.core._rest.call(null,args__12913);
if((argc === 18))
{if(f__12890.cljs$lang$arity$18)
{return f__12890.cljs$lang$arity$18(a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902,m__12904,n__12906,o__12908,p__12910,q__12912,r__12914);
} else
{return f__12890.call(null,a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902,m__12904,n__12906,o__12908,p__12910,q__12912,r__12914);
}
} else
{var s__12916 = cljs.core._first.call(null,args__12915);
var args__12917 = cljs.core._rest.call(null,args__12915);
if((argc === 19))
{if(f__12890.cljs$lang$arity$19)
{return f__12890.cljs$lang$arity$19(a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902,m__12904,n__12906,o__12908,p__12910,q__12912,r__12914,s__12916);
} else
{return f__12890.call(null,a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902,m__12904,n__12906,o__12908,p__12910,q__12912,r__12914,s__12916);
}
} else
{var t__12918 = cljs.core._first.call(null,args__12917);
var args__12919 = cljs.core._rest.call(null,args__12917);
if((argc === 20))
{if(f__12890.cljs$lang$arity$20)
{return f__12890.cljs$lang$arity$20(a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902,m__12904,n__12906,o__12908,p__12910,q__12912,r__12914,s__12916,t__12918);
} else
{return f__12890.call(null,a__12880,b__12882,c__12884,d__12886,e__12888,f__12890,g__12892,h__12894,i__12896,j__12898,k__12900,l__12902,m__12904,n__12906,o__12908,p__12910,q__12912,r__12914,s__12916,t__12918);
}
} else
{throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
/**
* Applies fn f to the argument list formed by prepending intervening arguments to args.
* First cut.  Not lazy.  Needs to use emitted toApply.
* @param {...*} var_args
*/
cljs.core.apply = (function() {
var apply = null;
var apply__2 = (function (f,args){
var fixed_arity__12934 = f.cljs$lang$maxFixedArity;
if(cljs.core.truth_(f.cljs$lang$applyTo))
{var bc__12935 = cljs.core.bounded_count.call(null,args,(fixed_arity__12934 + 1));
if((bc__12935 <= fixed_arity__12934))
{return cljs.core.apply_to.call(null,f,bc__12935,args);
} else
{return f.cljs$lang$applyTo(args);
}
} else
{return f.apply(f,cljs.core.to_array.call(null,args));
}
});
var apply__3 = (function (f,x,args){
var arglist__12936 = cljs.core.list_STAR_.call(null,x,args);
var fixed_arity__12937 = f.cljs$lang$maxFixedArity;
if(cljs.core.truth_(f.cljs$lang$applyTo))
{var bc__12938 = cljs.core.bounded_count.call(null,arglist__12936,(fixed_arity__12937 + 1));
if((bc__12938 <= fixed_arity__12937))
{return cljs.core.apply_to.call(null,f,bc__12938,arglist__12936);
} else
{return f.cljs$lang$applyTo(arglist__12936);
}
} else
{return f.apply(f,cljs.core.to_array.call(null,arglist__12936));
}
});
var apply__4 = (function (f,x,y,args){
var arglist__12939 = cljs.core.list_STAR_.call(null,x,y,args);
var fixed_arity__12940 = f.cljs$lang$maxFixedArity;
if(cljs.core.truth_(f.cljs$lang$applyTo))
{var bc__12941 = cljs.core.bounded_count.call(null,arglist__12939,(fixed_arity__12940 + 1));
if((bc__12941 <= fixed_arity__12940))
{return cljs.core.apply_to.call(null,f,bc__12941,arglist__12939);
} else
{return f.cljs$lang$applyTo(arglist__12939);
}
} else
{return f.apply(f,cljs.core.to_array.call(null,arglist__12939));
}
});
var apply__5 = (function (f,x,y,z,args){
var arglist__12942 = cljs.core.list_STAR_.call(null,x,y,z,args);
var fixed_arity__12943 = f.cljs$lang$maxFixedArity;
if(cljs.core.truth_(f.cljs$lang$applyTo))
{var bc__12944 = cljs.core.bounded_count.call(null,arglist__12942,(fixed_arity__12943 + 1));
if((bc__12944 <= fixed_arity__12943))
{return cljs.core.apply_to.call(null,f,bc__12944,arglist__12942);
} else
{return f.cljs$lang$applyTo(arglist__12942);
}
} else
{return f.apply(f,cljs.core.to_array.call(null,arglist__12942));
}
});
var apply__6 = (function() { 
var G__12948__delegate = function (f,a,b,c,d,args){
var arglist__12945 = cljs.core.cons.call(null,a,cljs.core.cons.call(null,b,cljs.core.cons.call(null,c,cljs.core.cons.call(null,d,cljs.core.spread.call(null,args)))));
var fixed_arity__12946 = f.cljs$lang$maxFixedArity;
if(cljs.core.truth_(f.cljs$lang$applyTo))
{var bc__12947 = cljs.core.bounded_count.call(null,arglist__12945,(fixed_arity__12946 + 1));
if((bc__12947 <= fixed_arity__12946))
{return cljs.core.apply_to.call(null,f,bc__12947,arglist__12945);
} else
{return f.cljs$lang$applyTo(arglist__12945);
}
} else
{return f.apply(f,cljs.core.to_array.call(null,arglist__12945));
}
};
var G__12948 = function (f,a,b,c,d,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5),0);
} 
return G__12948__delegate.call(this, f, a, b, c, d, args);
};
G__12948.cljs$lang$maxFixedArity = 5;
G__12948.cljs$lang$applyTo = (function (arglist__12949){
var f = cljs.core.first(arglist__12949);
var a = cljs.core.first(cljs.core.next(arglist__12949));
var b = cljs.core.first(cljs.core.next(cljs.core.next(arglist__12949)));
var c = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__12949))));
var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__12949)))));
var args = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__12949)))));
return G__12948__delegate(f, a, b, c, d, args);
});
G__12948.cljs$lang$arity$variadic = G__12948__delegate;
return G__12948;
})()
;
apply = function(f,a,b,c,d,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return apply__2.call(this,f,a);
case 3:
return apply__3.call(this,f,a,b);
case 4:
return apply__4.call(this,f,a,b,c);
case 5:
return apply__5.call(this,f,a,b,c,d);
default:
return apply__6.cljs$lang$arity$variadic(f,a,b,c,d, cljs.core.array_seq(arguments, 5));
}
throw('Invalid arity: ' + arguments.length);
};
apply.cljs$lang$maxFixedArity = 5;
apply.cljs$lang$applyTo = apply__6.cljs$lang$applyTo;
apply.cljs$lang$arity$2 = apply__2;
apply.cljs$lang$arity$3 = apply__3;
apply.cljs$lang$arity$4 = apply__4;
apply.cljs$lang$arity$5 = apply__5;
apply.cljs$lang$arity$variadic = apply__6.cljs$lang$arity$variadic;
return apply;
})()
;
/**
* Returns an object of the same type and value as obj, with
* (apply f (meta obj) args) as its metadata.
* @param {...*} var_args
*/
cljs.core.vary_meta = (function() { 
var vary_meta__delegate = function (obj,f,args){
return cljs.core.with_meta.call(null,obj,cljs.core.apply.call(null,f,cljs.core.meta.call(null,obj),args));
};
var vary_meta = function (obj,f,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return vary_meta__delegate.call(this, obj, f, args);
};
vary_meta.cljs$lang$maxFixedArity = 2;
vary_meta.cljs$lang$applyTo = (function (arglist__12950){
var obj = cljs.core.first(arglist__12950);
var f = cljs.core.first(cljs.core.next(arglist__12950));
var args = cljs.core.rest(cljs.core.next(arglist__12950));
return vary_meta__delegate(obj, f, args);
});
vary_meta.cljs$lang$arity$variadic = vary_meta__delegate;
return vary_meta;
})()
;
/**
* Same as (not (= obj1 obj2))
* @param {...*} var_args
*/
cljs.core.not_EQ_ = (function() {
var not_EQ_ = null;
var not_EQ___1 = (function (x){
return false;
});
var not_EQ___2 = (function (x,y){
return !(cljs.core._EQ_.call(null,x,y));
});
var not_EQ___3 = (function() { 
var G__12951__delegate = function (x,y,more){
return cljs.core.not.call(null,cljs.core.apply.call(null,cljs.core._EQ_,x,y,more));
};
var G__12951 = function (x,y,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12951__delegate.call(this, x, y, more);
};
G__12951.cljs$lang$maxFixedArity = 2;
G__12951.cljs$lang$applyTo = (function (arglist__12952){
var x = cljs.core.first(arglist__12952);
var y = cljs.core.first(cljs.core.next(arglist__12952));
var more = cljs.core.rest(cljs.core.next(arglist__12952));
return G__12951__delegate(x, y, more);
});
G__12951.cljs$lang$arity$variadic = G__12951__delegate;
return G__12951;
})()
;
not_EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return not_EQ___1.call(this,x);
case 2:
return not_EQ___2.call(this,x,y);
default:
return not_EQ___3.cljs$lang$arity$variadic(x,y, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
not_EQ_.cljs$lang$maxFixedArity = 2;
not_EQ_.cljs$lang$applyTo = not_EQ___3.cljs$lang$applyTo;
not_EQ_.cljs$lang$arity$1 = not_EQ___1;
not_EQ_.cljs$lang$arity$2 = not_EQ___2;
not_EQ_.cljs$lang$arity$variadic = not_EQ___3.cljs$lang$arity$variadic;
return not_EQ_;
})()
;
/**
* If coll is empty, returns nil, else coll
*/
cljs.core.not_empty = (function not_empty(coll){
if(cljs.core.seq.call(null,coll))
{return coll;
} else
{return null;
}
});
/**
* Returns true if (pred x) is logical true for every x in coll, else
* false.
*/
cljs.core.every_QMARK_ = (function every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq.call(null,coll) == null))
{return true;
} else
{if(cljs.core.truth_(pred.call(null,cljs.core.first.call(null,coll))))
{{
var G__12953 = pred;
var G__12954 = cljs.core.next.call(null,coll);
pred = G__12953;
coll = G__12954;
continue;
}
} else
{if("\uFDD0'else")
{return false;
} else
{return null;
}
}
}
break;
}
});
/**
* Returns false if (pred x) is logical true for every x in
* coll, else true.
*/
cljs.core.not_every_QMARK_ = (function not_every_QMARK_(pred,coll){
return !(cljs.core.every_QMARK_.call(null,pred,coll));
});
/**
* Returns the first logical true value of (pred x) for any x in coll,
* else nil.  One common idiom is to use a set as pred, for example
* this will return :fred if :fred is in the sequence, otherwise nil:
* (some #{:fred} coll)
*/
cljs.core.some = (function some(pred,coll){
while(true){
if(cljs.core.seq.call(null,coll))
{var or__3824__auto____12956 = pred.call(null,cljs.core.first.call(null,coll));
if(cljs.core.truth_(or__3824__auto____12956))
{return or__3824__auto____12956;
} else
{{
var G__12957 = pred;
var G__12958 = cljs.core.next.call(null,coll);
pred = G__12957;
coll = G__12958;
continue;
}
}
} else
{return null;
}
break;
}
});
/**
* Returns false if (pred x) is logical true for any x in coll,
* else true.
*/
cljs.core.not_any_QMARK_ = (function not_any_QMARK_(pred,coll){
return cljs.core.not.call(null,cljs.core.some.call(null,pred,coll));
});
/**
* Returns true if n is even, throws an exception if n is not an integer
*/
cljs.core.even_QMARK_ = (function even_QMARK_(n){
if(cljs.core.integer_QMARK_.call(null,n))
{return ((n & 1) === 0);
} else
{throw (new Error([cljs.core.str("Argument must be an integer: "),cljs.core.str(n)].join('')));
}
});
/**
* Returns true if n is odd, throws an exception if n is not an integer
*/
cljs.core.odd_QMARK_ = (function odd_QMARK_(n){
return !(cljs.core.even_QMARK_.call(null,n));
});
cljs.core.identity = (function identity(x){
return x;
});
/**
* Takes a fn f and returns a fn that takes the same arguments as f,
* has the same effects, if any, and returns the opposite truth value.
*/
cljs.core.complement = (function complement(f){
return (function() {
var G__12959 = null;
var G__12959__0 = (function (){
return cljs.core.not.call(null,f.call(null));
});
var G__12959__1 = (function (x){
return cljs.core.not.call(null,f.call(null,x));
});
var G__12959__2 = (function (x,y){
return cljs.core.not.call(null,f.call(null,x,y));
});
var G__12959__3 = (function() { 
var G__12960__delegate = function (x,y,zs){
return cljs.core.not.call(null,cljs.core.apply.call(null,f,x,y,zs));
};
var G__12960 = function (x,y,var_args){
var zs = null;
if (goog.isDef(var_args)) {
  zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__12960__delegate.call(this, x, y, zs);
};
G__12960.cljs$lang$maxFixedArity = 2;
G__12960.cljs$lang$applyTo = (function (arglist__12961){
var x = cljs.core.first(arglist__12961);
var y = cljs.core.first(cljs.core.next(arglist__12961));
var zs = cljs.core.rest(cljs.core.next(arglist__12961));
return G__12960__delegate(x, y, zs);
});
G__12960.cljs$lang$arity$variadic = G__12960__delegate;
return G__12960;
})()
;
G__12959 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__12959__0.call(this);
case 1:
return G__12959__1.call(this,x);
case 2:
return G__12959__2.call(this,x,y);
default:
return G__12959__3.cljs$lang$arity$variadic(x,y, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
G__12959.cljs$lang$maxFixedArity = 2;
G__12959.cljs$lang$applyTo = G__12959__3.cljs$lang$applyTo;
return G__12959;
})()
});
/**
* Returns a function that takes any number of arguments and returns x.
*/
cljs.core.constantly = (function constantly(x){
return (function() { 
var G__12962__delegate = function (args){
return x;
};
var G__12962 = function (var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return G__12962__delegate.call(this, args);
};
G__12962.cljs$lang$maxFixedArity = 0;
G__12962.cljs$lang$applyTo = (function (arglist__12963){
var args = cljs.core.seq(arglist__12963);;
return G__12962__delegate(args);
});
G__12962.cljs$lang$arity$variadic = G__12962__delegate;
return G__12962;
})()
;
});
/**
* Takes a set of functions and returns a fn that is the composition
* of those fns.  The returned fn takes a variable number of args,
* applies the rightmost of fns to the args, the next
* fn (right-to-left) to the result, etc.
* @param {...*} var_args
*/
cljs.core.comp = (function() {
var comp = null;
var comp__0 = (function (){
return cljs.core.identity;
});
var comp__1 = (function (f){
return f;
});
var comp__2 = (function (f,g){
return (function() {
var G__12970 = null;
var G__12970__0 = (function (){
return f.call(null,g.call(null));
});
var G__12970__1 = (function (x){
return f.call(null,g.call(null,x));
});
var G__12970__2 = (function (x,y){
return f.call(null,g.call(null,x,y));
});
var G__12970__3 = (function (x,y,z){
return f.call(null,g.call(null,x,y,z));
});
var G__12970__4 = (function() { 
var G__12971__delegate = function (x,y,z,args){
return f.call(null,cljs.core.apply.call(null,g,x,y,z,args));
};
var G__12971 = function (x,y,z,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__12971__delegate.call(this, x, y, z, args);
};
G__12971.cljs$lang$maxFixedArity = 3;
G__12971.cljs$lang$applyTo = (function (arglist__12972){
var x = cljs.core.first(arglist__12972);
var y = cljs.core.first(cljs.core.next(arglist__12972));
var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__12972)));
var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__12972)));
return G__12971__delegate(x, y, z, args);
});
G__12971.cljs$lang$arity$variadic = G__12971__delegate;
return G__12971;
})()
;
G__12970 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__12970__0.call(this);
case 1:
return G__12970__1.call(this,x);
case 2:
return G__12970__2.call(this,x,y);
case 3:
return G__12970__3.call(this,x,y,z);
default:
return G__12970__4.cljs$lang$arity$variadic(x,y,z, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
G__12970.cljs$lang$maxFixedArity = 3;
G__12970.cljs$lang$applyTo = G__12970__4.cljs$lang$applyTo;
return G__12970;
})()
});
var comp__3 = (function (f,g,h){
return (function() {
var G__12973 = null;
var G__12973__0 = (function (){
return f.call(null,g.call(null,h.call(null)));
});
var G__12973__1 = (function (x){
return f.call(null,g.call(null,h.call(null,x)));
});
var G__12973__2 = (function (x,y){
return f.call(null,g.call(null,h.call(null,x,y)));
});
var G__12973__3 = (function (x,y,z){
return f.call(null,g.call(null,h.call(null,x,y,z)));
});
var G__12973__4 = (function() { 
var G__12974__delegate = function (x,y,z,args){
return f.call(null,g.call(null,cljs.core.apply.call(null,h,x,y,z,args)));
};
var G__12974 = function (x,y,z,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__12974__delegate.call(this, x, y, z, args);
};
G__12974.cljs$lang$maxFixedArity = 3;
G__12974.cljs$lang$applyTo = (function (arglist__12975){
var x = cljs.core.first(arglist__12975);
var y = cljs.core.first(cljs.core.next(arglist__12975));
var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__12975)));
var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__12975)));
return G__12974__delegate(x, y, z, args);
});
G__12974.cljs$lang$arity$variadic = G__12974__delegate;
return G__12974;
})()
;
G__12973 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__12973__0.call(this);
case 1:
return G__12973__1.call(this,x);
case 2:
return G__12973__2.call(this,x,y);
case 3:
return G__12973__3.call(this,x,y,z);
default:
return G__12973__4.cljs$lang$arity$variadic(x,y,z, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
G__12973.cljs$lang$maxFixedArity = 3;
G__12973.cljs$lang$applyTo = G__12973__4.cljs$lang$applyTo;
return G__12973;
})()
});
var comp__4 = (function() { 
var G__12976__delegate = function (f1,f2,f3,fs){
var fs__12967 = cljs.core.reverse.call(null,cljs.core.list_STAR_.call(null,f1,f2,f3,fs));
return (function() { 
var G__12977__delegate = function (args){
var ret__12968 = cljs.core.apply.call(null,cljs.core.first.call(null,fs__12967),args);
var fs__12969 = cljs.core.next.call(null,fs__12967);
while(true){
if(fs__12969)
{{
var G__12978 = cljs.core.first.call(null,fs__12969).call(null,ret__12968);
var G__12979 = cljs.core.next.call(null,fs__12969);
ret__12968 = G__12978;
fs__12969 = G__12979;
continue;
}
} else
{return ret__12968;
}
break;
}
};
var G__12977 = function (var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return G__12977__delegate.call(this, args);
};
G__12977.cljs$lang$maxFixedArity = 0;
G__12977.cljs$lang$applyTo = (function (arglist__12980){
var args = cljs.core.seq(arglist__12980);;
return G__12977__delegate(args);
});
G__12977.cljs$lang$arity$variadic = G__12977__delegate;
return G__12977;
})()
;
};
var G__12976 = function (f1,f2,f3,var_args){
var fs = null;
if (goog.isDef(var_args)) {
  fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__12976__delegate.call(this, f1, f2, f3, fs);
};
G__12976.cljs$lang$maxFixedArity = 3;
G__12976.cljs$lang$applyTo = (function (arglist__12981){
var f1 = cljs.core.first(arglist__12981);
var f2 = cljs.core.first(cljs.core.next(arglist__12981));
var f3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__12981)));
var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__12981)));
return G__12976__delegate(f1, f2, f3, fs);
});
G__12976.cljs$lang$arity$variadic = G__12976__delegate;
return G__12976;
})()
;
comp = function(f1,f2,f3,var_args){
var fs = var_args;
switch(arguments.length){
case 0:
return comp__0.call(this);
case 1:
return comp__1.call(this,f1);
case 2:
return comp__2.call(this,f1,f2);
case 3:
return comp__3.call(this,f1,f2,f3);
default:
return comp__4.cljs$lang$arity$variadic(f1,f2,f3, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
comp.cljs$lang$maxFixedArity = 3;
comp.cljs$lang$applyTo = comp__4.cljs$lang$applyTo;
comp.cljs$lang$arity$0 = comp__0;
comp.cljs$lang$arity$1 = comp__1;
comp.cljs$lang$arity$2 = comp__2;
comp.cljs$lang$arity$3 = comp__3;
comp.cljs$lang$arity$variadic = comp__4.cljs$lang$arity$variadic;
return comp;
})()
;
/**
* Takes a function f and fewer than the normal arguments to f, and
* returns a fn that takes a variable number of additional args. When
* called, the returned function calls f with args + additional args.
* @param {...*} var_args
*/
cljs.core.partial = (function() {
var partial = null;
var partial__2 = (function (f,arg1){
return (function() { 
var G__12982__delegate = function (args){
return cljs.core.apply.call(null,f,arg1,args);
};
var G__12982 = function (var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return G__12982__delegate.call(this, args);
};
G__12982.cljs$lang$maxFixedArity = 0;
G__12982.cljs$lang$applyTo = (function (arglist__12983){
var args = cljs.core.seq(arglist__12983);;
return G__12982__delegate(args);
});
G__12982.cljs$lang$arity$variadic = G__12982__delegate;
return G__12982;
})()
;
});
var partial__3 = (function (f,arg1,arg2){
return (function() { 
var G__12984__delegate = function (args){
return cljs.core.apply.call(null,f,arg1,arg2,args);
};
var G__12984 = function (var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return G__12984__delegate.call(this, args);
};
G__12984.cljs$lang$maxFixedArity = 0;
G__12984.cljs$lang$applyTo = (function (arglist__12985){
var args = cljs.core.seq(arglist__12985);;
return G__12984__delegate(args);
});
G__12984.cljs$lang$arity$variadic = G__12984__delegate;
return G__12984;
})()
;
});
var partial__4 = (function (f,arg1,arg2,arg3){
return (function() { 
var G__12986__delegate = function (args){
return cljs.core.apply.call(null,f,arg1,arg2,arg3,args);
};
var G__12986 = function (var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return G__12986__delegate.call(this, args);
};
G__12986.cljs$lang$maxFixedArity = 0;
G__12986.cljs$lang$applyTo = (function (arglist__12987){
var args = cljs.core.seq(arglist__12987);;
return G__12986__delegate(args);
});
G__12986.cljs$lang$arity$variadic = G__12986__delegate;
return G__12986;
})()
;
});
var partial__5 = (function() { 
var G__12988__delegate = function (f,arg1,arg2,arg3,more){
return (function() { 
var G__12989__delegate = function (args){
return cljs.core.apply.call(null,f,arg1,arg2,arg3,cljs.core.concat.call(null,more,args));
};
var G__12989 = function (var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return G__12989__delegate.call(this, args);
};
G__12989.cljs$lang$maxFixedArity = 0;
G__12989.cljs$lang$applyTo = (function (arglist__12990){
var args = cljs.core.seq(arglist__12990);;
return G__12989__delegate(args);
});
G__12989.cljs$lang$arity$variadic = G__12989__delegate;
return G__12989;
})()
;
};
var G__12988 = function (f,arg1,arg2,arg3,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4),0);
} 
return G__12988__delegate.call(this, f, arg1, arg2, arg3, more);
};
G__12988.cljs$lang$maxFixedArity = 4;
G__12988.cljs$lang$applyTo = (function (arglist__12991){
var f = cljs.core.first(arglist__12991);
var arg1 = cljs.core.first(cljs.core.next(arglist__12991));
var arg2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__12991)));
var arg3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__12991))));
var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__12991))));
return G__12988__delegate(f, arg1, arg2, arg3, more);
});
G__12988.cljs$lang$arity$variadic = G__12988__delegate;
return G__12988;
})()
;
partial = function(f,arg1,arg2,arg3,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return partial__2.call(this,f,arg1);
case 3:
return partial__3.call(this,f,arg1,arg2);
case 4:
return partial__4.call(this,f,arg1,arg2,arg3);
default:
return partial__5.cljs$lang$arity$variadic(f,arg1,arg2,arg3, cljs.core.array_seq(arguments, 4));
}
throw('Invalid arity: ' + arguments.length);
};
partial.cljs$lang$maxFixedArity = 4;
partial.cljs$lang$applyTo = partial__5.cljs$lang$applyTo;
partial.cljs$lang$arity$2 = partial__2;
partial.cljs$lang$arity$3 = partial__3;
partial.cljs$lang$arity$4 = partial__4;
partial.cljs$lang$arity$variadic = partial__5.cljs$lang$arity$variadic;
return partial;
})()
;
/**
* Takes a function f, and returns a function that calls f, replacing
* a nil first argument to f with the supplied value x. Higher arity
* versions can replace arguments in the second and third
* positions (y, z). Note that the function f can take any number of
* arguments, not just the one(s) being nil-patched.
*/
cljs.core.fnil = (function() {
var fnil = null;
var fnil__2 = (function (f,x){
return (function() {
var G__12992 = null;
var G__12992__1 = (function (a){
return f.call(null,(((a == null))?x:a));
});
var G__12992__2 = (function (a,b){
return f.call(null,(((a == null))?x:a),b);
});
var G__12992__3 = (function (a,b,c){
return f.call(null,(((a == null))?x:a),b,c);
});
var G__12992__4 = (function() { 
var G__12993__delegate = function (a,b,c,ds){
return cljs.core.apply.call(null,f,(((a == null))?x:a),b,c,ds);
};
var G__12993 = function (a,b,c,var_args){
var ds = null;
if (goog.isDef(var_args)) {
  ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__12993__delegate.call(this, a, b, c, ds);
};
G__12993.cljs$lang$maxFixedArity = 3;
G__12993.cljs$lang$applyTo = (function (arglist__12994){
var a = cljs.core.first(arglist__12994);
var b = cljs.core.first(cljs.core.next(arglist__12994));
var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__12994)));
var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__12994)));
return G__12993__delegate(a, b, c, ds);
});
G__12993.cljs$lang$arity$variadic = G__12993__delegate;
return G__12993;
})()
;
G__12992 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__12992__1.call(this,a);
case 2:
return G__12992__2.call(this,a,b);
case 3:
return G__12992__3.call(this,a,b,c);
default:
return G__12992__4.cljs$lang$arity$variadic(a,b,c, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
G__12992.cljs$lang$maxFixedArity = 3;
G__12992.cljs$lang$applyTo = G__12992__4.cljs$lang$applyTo;
return G__12992;
})()
});
var fnil__3 = (function (f,x,y){
return (function() {
var G__12995 = null;
var G__12995__2 = (function (a,b){
return f.call(null,(((a == null))?x:a),(((b == null))?y:b));
});
var G__12995__3 = (function (a,b,c){
return f.call(null,(((a == null))?x:a),(((b == null))?y:b),c);
});
var G__12995__4 = (function() { 
var G__12996__delegate = function (a,b,c,ds){
return cljs.core.apply.call(null,f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__12996 = function (a,b,c,var_args){
var ds = null;
if (goog.isDef(var_args)) {
  ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__12996__delegate.call(this, a, b, c, ds);
};
G__12996.cljs$lang$maxFixedArity = 3;
G__12996.cljs$lang$applyTo = (function (arglist__12997){
var a = cljs.core.first(arglist__12997);
var b = cljs.core.first(cljs.core.next(arglist__12997));
var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__12997)));
var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__12997)));
return G__12996__delegate(a, b, c, ds);
});
G__12996.cljs$lang$arity$variadic = G__12996__delegate;
return G__12996;
})()
;
G__12995 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__12995__2.call(this,a,b);
case 3:
return G__12995__3.call(this,a,b,c);
default:
return G__12995__4.cljs$lang$arity$variadic(a,b,c, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
G__12995.cljs$lang$maxFixedArity = 3;
G__12995.cljs$lang$applyTo = G__12995__4.cljs$lang$applyTo;
return G__12995;
})()
});
var fnil__4 = (function (f,x,y,z){
return (function() {
var G__12998 = null;
var G__12998__2 = (function (a,b){
return f.call(null,(((a == null))?x:a),(((b == null))?y:b));
});
var G__12998__3 = (function (a,b,c){
return f.call(null,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c));
});
var G__12998__4 = (function() { 
var G__12999__delegate = function (a,b,c,ds){
return cljs.core.apply.call(null,f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__12999 = function (a,b,c,var_args){
var ds = null;
if (goog.isDef(var_args)) {
  ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__12999__delegate.call(this, a, b, c, ds);
};
G__12999.cljs$lang$maxFixedArity = 3;
G__12999.cljs$lang$applyTo = (function (arglist__13000){
var a = cljs.core.first(arglist__13000);
var b = cljs.core.first(cljs.core.next(arglist__13000));
var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__13000)));
var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__13000)));
return G__12999__delegate(a, b, c, ds);
});
G__12999.cljs$lang$arity$variadic = G__12999__delegate;
return G__12999;
})()
;
G__12998 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__12998__2.call(this,a,b);
case 3:
return G__12998__3.call(this,a,b,c);
default:
return G__12998__4.cljs$lang$arity$variadic(a,b,c, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
G__12998.cljs$lang$maxFixedArity = 3;
G__12998.cljs$lang$applyTo = G__12998__4.cljs$lang$applyTo;
return G__12998;
})()
});
fnil = function(f,x,y,z){
switch(arguments.length){
case 2:
return fnil__2.call(this,f,x);
case 3:
return fnil__3.call(this,f,x,y);
case 4:
return fnil__4.call(this,f,x,y,z);
}
throw('Invalid arity: ' + arguments.length);
};
fnil.cljs$lang$arity$2 = fnil__2;
fnil.cljs$lang$arity$3 = fnil__3;
fnil.cljs$lang$arity$4 = fnil__4;
return fnil;
})()
;
/**
* Returns a lazy sequence consisting of the result of applying f to 0
* and the first item of coll, followed by applying f to 1 and the second
* item in coll, etc, until coll is exhausted. Thus function f should
* accept 2 arguments, index and item.
*/
cljs.core.map_indexed = (function map_indexed(f,coll){
var mapi__13016 = (function mapi(idx,coll){
return (new cljs.core.LazySeq(null,false,(function (){
var temp__3974__auto____13024 = cljs.core.seq.call(null,coll);
if(temp__3974__auto____13024)
{var s__13025 = temp__3974__auto____13024;
if(cljs.core.chunked_seq_QMARK_.call(null,s__13025))
{var c__13026 = cljs.core.chunk_first.call(null,s__13025);
var size__13027 = cljs.core.count.call(null,c__13026);
var b__13028 = cljs.core.chunk_buffer.call(null,size__13027);
var n__5049__auto____13029 = size__13027;
var i__13030 = 0;
while(true){
if((i__13030 < n__5049__auto____13029))
{cljs.core.chunk_append.call(null,b__13028,f.call(null,(idx + i__13030),cljs.core._nth.call(null,c__13026,i__13030)));
{
var G__13031 = (i__13030 + 1);
i__13030 = G__13031;
continue;
}
} else
{}
break;
}
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13028),mapi.call(null,(idx + size__13027),cljs.core.chunk_rest.call(null,s__13025)));
} else
{return cljs.core.cons.call(null,f.call(null,idx,cljs.core.first.call(null,s__13025)),mapi.call(null,(idx + 1),cljs.core.rest.call(null,s__13025)));
}
} else
{return null;
}
}),null));
});
return mapi__13016.call(null,0,coll);
});
/**
* Returns a lazy sequence of the non-nil results of (f item). Note,
* this means false return values will be included.  f must be free of
* side-effects.
*/
cljs.core.keep = (function keep(f,coll){
return (new cljs.core.LazySeq(null,false,(function (){
var temp__3974__auto____13041 = cljs.core.seq.call(null,coll);
if(temp__3974__auto____13041)
{var s__13042 = temp__3974__auto____13041;
if(cljs.core.chunked_seq_QMARK_.call(null,s__13042))
{var c__13043 = cljs.core.chunk_first.call(null,s__13042);
var size__13044 = cljs.core.count.call(null,c__13043);
var b__13045 = cljs.core.chunk_buffer.call(null,size__13044);
var n__5049__auto____13046 = size__13044;
var i__13047 = 0;
while(true){
if((i__13047 < n__5049__auto____13046))
{var x__13048 = f.call(null,cljs.core._nth.call(null,c__13043,i__13047));
if((x__13048 == null))
{} else
{cljs.core.chunk_append.call(null,b__13045,x__13048);
}
{
var G__13050 = (i__13047 + 1);
i__13047 = G__13050;
continue;
}
} else
{}
break;
}
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13045),keep.call(null,f,cljs.core.chunk_rest.call(null,s__13042)));
} else
{var x__13049 = f.call(null,cljs.core.first.call(null,s__13042));
if((x__13049 == null))
{return keep.call(null,f,cljs.core.rest.call(null,s__13042));
} else
{return cljs.core.cons.call(null,x__13049,keep.call(null,f,cljs.core.rest.call(null,s__13042)));
}
}
} else
{return null;
}
}),null));
});
/**
* Returns a lazy sequence of the non-nil results of (f index item). Note,
* this means false return values will be included.  f must be free of
* side-effects.
*/
cljs.core.keep_indexed = (function keep_indexed(f,coll){
var keepi__13076 = (function keepi(idx,coll){
return (new cljs.core.LazySeq(null,false,(function (){
var temp__3974__auto____13086 = cljs.core.seq.call(null,coll);
if(temp__3974__auto____13086)
{var s__13087 = temp__3974__auto____13086;
if(cljs.core.chunked_seq_QMARK_.call(null,s__13087))
{var c__13088 = cljs.core.chunk_first.call(null,s__13087);
var size__13089 = cljs.core.count.call(null,c__13088);
var b__13090 = cljs.core.chunk_buffer.call(null,size__13089);
var n__5049__auto____13091 = size__13089;
var i__13092 = 0;
while(true){
if((i__13092 < n__5049__auto____13091))
{var x__13093 = f.call(null,(idx + i__13092),cljs.core._nth.call(null,c__13088,i__13092));
if((x__13093 == null))
{} else
{cljs.core.chunk_append.call(null,b__13090,x__13093);
}
{
var G__13095 = (i__13092 + 1);
i__13092 = G__13095;
continue;
}
} else
{}
break;
}
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13090),keepi.call(null,(idx + size__13089),cljs.core.chunk_rest.call(null,s__13087)));
} else
{var x__13094 = f.call(null,idx,cljs.core.first.call(null,s__13087));
if((x__13094 == null))
{return keepi.call(null,(idx + 1),cljs.core.rest.call(null,s__13087));
} else
{return cljs.core.cons.call(null,x__13094,keepi.call(null,(idx + 1),cljs.core.rest.call(null,s__13087)));
}
}
} else
{return null;
}
}),null));
});
return keepi__13076.call(null,0,coll);
});
/**
* Takes a set of predicates and returns a function f that returns true if all of its
* composing predicates return a logical true value against all of its arguments, else it returns
* false. Note that f is short-circuiting in that it will stop execution on the first
* argument that triggers a logical false result against the original predicates.
* @param {...*} var_args
*/
cljs.core.every_pred = (function() {
var every_pred = null;
var every_pred__1 = (function (p){
return (function() {
var ep1 = null;
var ep1__0 = (function (){
return true;
});
var ep1__1 = (function (x){
return cljs.core.boolean$.call(null,p.call(null,x));
});
var ep1__2 = (function (x,y){
return cljs.core.boolean$.call(null,(function (){var and__3822__auto____13181 = p.call(null,x);
if(cljs.core.truth_(and__3822__auto____13181))
{return p.call(null,y);
} else
{return and__3822__auto____13181;
}
})());
});
var ep1__3 = (function (x,y,z){
return cljs.core.boolean$.call(null,(function (){var and__3822__auto____13182 = p.call(null,x);
if(cljs.core.truth_(and__3822__auto____13182))
{var and__3822__auto____13183 = p.call(null,y);
if(cljs.core.truth_(and__3822__auto____13183))
{return p.call(null,z);
} else
{return and__3822__auto____13183;
}
} else
{return and__3822__auto____13182;
}
})());
});
var ep1__4 = (function() { 
var G__13252__delegate = function (x,y,z,args){
return cljs.core.boolean$.call(null,(function (){var and__3822__auto____13184 = ep1.call(null,x,y,z);
if(cljs.core.truth_(and__3822__auto____13184))
{return cljs.core.every_QMARK_.call(null,p,args);
} else
{return and__3822__auto____13184;
}
})());
};
var G__13252 = function (x,y,z,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__13252__delegate.call(this, x, y, z, args);
};
G__13252.cljs$lang$maxFixedArity = 3;
G__13252.cljs$lang$applyTo = (function (arglist__13253){
var x = cljs.core.first(arglist__13253);
var y = cljs.core.first(cljs.core.next(arglist__13253));
var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__13253)));
var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__13253)));
return G__13252__delegate(x, y, z, args);
});
G__13252.cljs$lang$arity$variadic = G__13252__delegate;
return G__13252;
})()
;
ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return ep1__0.call(this);
case 1:
return ep1__1.call(this,x);
case 2:
return ep1__2.call(this,x,y);
case 3:
return ep1__3.call(this,x,y,z);
default:
return ep1__4.cljs$lang$arity$variadic(x,y,z, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
ep1.cljs$lang$maxFixedArity = 3;
ep1.cljs$lang$applyTo = ep1__4.cljs$lang$applyTo;
ep1.cljs$lang$arity$0 = ep1__0;
ep1.cljs$lang$arity$1 = ep1__1;
ep1.cljs$lang$arity$2 = ep1__2;
ep1.cljs$lang$arity$3 = ep1__3;
ep1.cljs$lang$arity$variadic = ep1__4.cljs$lang$arity$variadic;
return ep1;
})()
});
var every_pred__2 = (function (p1,p2){
return (function() {
var ep2 = null;
var ep2__0 = (function (){
return true;
});
var ep2__1 = (function (x){
return cljs.core.boolean$.call(null,(function (){var and__3822__auto____13196 = p1.call(null,x);
if(cljs.core.truth_(and__3822__auto____13196))
{return p2.call(null,x);
} else
{return and__3822__auto____13196;
}
})());
});
var ep2__2 = (function (x,y){
return cljs.core.boolean$.call(null,(function (){var and__3822__auto____13197 = p1.call(null,x);
if(cljs.core.truth_(and__3822__auto____13197))
{var and__3822__auto____13198 = p1.call(null,y);
if(cljs.core.truth_(and__3822__auto____13198))
{var and__3822__auto____13199 = p2.call(null,x);
if(cljs.core.truth_(and__3822__auto____13199))
{return p2.call(null,y);
} else
{return and__3822__auto____13199;
}
} else
{return and__3822__auto____13198;
}
} else
{return and__3822__auto____13197;
}
})());
});
var ep2__3 = (function (x,y,z){
return cljs.core.boolean$.call(null,(function (){var and__3822__auto____13200 = p1.call(null,x);
if(cljs.core.truth_(and__3822__auto____13200))
{var and__3822__auto____13201 = p1.call(null,y);
if(cljs.core.truth_(and__3822__auto____13201))
{var and__3822__auto____13202 = p1.call(null,z);
if(cljs.core.truth_(and__3822__auto____13202))
{var and__3822__auto____13203 = p2.call(null,x);
if(cljs.core.truth_(and__3822__auto____13203))
{var and__3822__auto____13204 = p2.call(null,y);
if(cljs.core.truth_(and__3822__auto____13204))
{return p2.call(null,z);
} else
{return and__3822__auto____13204;
}
} else
{return and__3822__auto____13203;
}
} else
{return and__3822__auto____13202;
}
} else
{return and__3822__auto____13201;
}
} else
{return and__3822__auto____13200;
}
})());
});
var ep2__4 = (function() { 
var G__13254__delegate = function (x,y,z,args){
return cljs.core.boolean$.call(null,(function (){var and__3822__auto____13205 = ep2.call(null,x,y,z);
if(cljs.core.truth_(and__3822__auto____13205))
{return cljs.core.every_QMARK_.call(null,(function (p1__13051_SHARP_){
var and__3822__auto____13206 = p1.call(null,p1__13051_SHARP_);
if(cljs.core.truth_(and__3822__auto____13206))
{return p2.call(null,p1__13051_SHARP_);
} else
{return and__3822__auto____13206;
}
}),args);
} else
{return and__3822__auto____13205;
}
})());
};
var G__13254 = function (x,y,z,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__13254__delegate.call(this, x, y, z, args);
};
G__13254.cljs$lang$maxFixedArity = 3;
G__13254.cljs$lang$applyTo = (function (arglist__13255){
var x = cljs.core.first(arglist__13255);
var y = cljs.core.first(cljs.core.next(arglist__13255));
var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__13255)));
var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__13255)));
return G__13254__delegate(x, y, z, args);
});
G__13254.cljs$lang$arity$variadic = G__13254__delegate;
return G__13254;
})()
;
ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return ep2__0.call(this);
case 1:
return ep2__1.call(this,x);
case 2:
return ep2__2.call(this,x,y);
case 3:
return ep2__3.call(this,x,y,z);
default:
return ep2__4.cljs$lang$arity$variadic(x,y,z, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
ep2.cljs$lang$maxFixedArity = 3;
ep2.cljs$lang$applyTo = ep2__4.cljs$lang$applyTo;
ep2.cljs$lang$arity$0 = ep2__0;
ep2.cljs$lang$arity$1 = ep2__1;
ep2.cljs$lang$arity$2 = ep2__2;
ep2.cljs$lang$arity$3 = ep2__3;
ep2.cljs$lang$arity$variadic = ep2__4.cljs$lang$arity$variadic;
return ep2;
})()
});
var every_pred__3 = (function (p1,p2,p3){
return (function() {
var ep3 = null;
var ep3__0 = (function (){
return true;
});
var ep3__1 = (function (x){
return cljs.core.boolean$.call(null,(function (){var and__3822__auto____13225 = p1.call(null,x);
if(cljs.core.truth_(and__3822__auto____13225))
{var and__3822__auto____13226 = p2.call(null,x);
if(cljs.core.truth_(and__3822__auto____13226))
{return p3.call(null,x);
} else
{return and__3822__auto____13226;
}
} else
{return and__3822__auto____13225;
}
})());
});
var ep3__2 = (function (x,y){
return cljs.core.boolean$.call(null,(function (){var and__3822__auto____13227 = p1.call(null,x);
if(cljs.core.truth_(and__3822__auto____13227))
{var and__3822__auto____13228 = p2.call(null,x);
if(cljs.core.truth_(and__3822__auto____13228))
{var and__3822__auto____13229 = p3.call(null,x);
if(cljs.core.truth_(and__3822__auto____13229))
{var and__3822__auto____13230 = p1.call(null,y);
if(cljs.core.truth_(and__3822__auto____13230))
{var and__3822__auto____13231 = p2.call(null,y);
if(cljs.core.truth_(and__3822__auto____13231))
{return p3.call(null,y);
} else
{return and__3822__auto____13231;
}
} else
{return and__3822__auto____13230;
}
} else
{return and__3822__auto____13229;
}
} else
{return and__3822__auto____13228;
}
} else
{return and__3822__auto____13227;
}
})());
});
var ep3__3 = (function (x,y,z){
return cljs.core.boolean$.call(null,(function (){var and__3822__auto____13232 = p1.call(null,x);
if(cljs.core.truth_(and__3822__auto____13232))
{var and__3822__auto____13233 = p2.call(null,x);
if(cljs.core.truth_(and__3822__auto____13233))
{var and__3822__auto____13234 = p3.call(null,x);
if(cljs.core.truth_(and__3822__auto____13234))
{var and__3822__auto____13235 = p1.call(null,y);
if(cljs.core.truth_(and__3822__auto____13235))
{var and__3822__auto____13236 = p2.call(null,y);
if(cljs.core.truth_(and__3822__auto____13236))
{var and__3822__auto____13237 = p3.call(null,y);
if(cljs.core.truth_(and__3822__auto____13237))
{var and__3822__auto____13238 = p1.call(null,z);
if(cljs.core.truth_(and__3822__auto____13238))
{var and__3822__auto____13239 = p2.call(null,z);
if(cljs.core.truth_(and__3822__auto____13239))
{return p3.call(null,z);
} else
{return and__3822__auto____13239;
}
} else
{return and__3822__auto____13238;
}
} else
{return and__3822__auto____13237;
}
} else
{return and__3822__auto____13236;
}
} else
{return and__3822__auto____13235;
}
} else
{return and__3822__auto____13234;
}
} else
{return and__3822__auto____13233;
}
} else
{return and__3822__auto____13232;
}
})());
});
var ep3__4 = (function() { 
var G__13256__delegate = function (x,y,z,args){
return cljs.core.boolean$.call(null,(function (){var and__3822__auto____13240 = ep3.call(null,x,y,z);
if(cljs.core.truth_(and__3822__auto____13240))
{return cljs.core.every_QMARK_.call(null,(function (p1__13052_SHARP_){
var and__3822__auto____13241 = p1.call(null,p1__13052_SHARP_);
if(cljs.core.truth_(and__3822__auto____13241))
{var and__3822__auto____13242 = p2.call(null,p1__13052_SHARP_);
if(cljs.core.truth_(and__3822__auto____13242))
{return p3.call(null,p1__13052_SHARP_);
} else
{return and__3822__auto____13242;
}
} else
{return and__3822__auto____13241;
}
}),args);
} else
{return and__3822__auto____13240;
}
})());
};
var G__13256 = function (x,y,z,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__13256__delegate.call(this, x, y, z, args);
};
G__13256.cljs$lang$maxFixedArity = 3;
G__13256.cljs$lang$applyTo = (function (arglist__13257){
var x = cljs.core.first(arglist__13257);
var y = cljs.core.first(cljs.core.next(arglist__13257));
var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__13257)));
var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__13257)));
return G__13256__delegate(x, y, z, args);
});
G__13256.cljs$lang$arity$variadic = G__13256__delegate;
return G__13256;
})()
;
ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return ep3__0.call(this);
case 1:
return ep3__1.call(this,x);
case 2:
return ep3__2.call(this,x,y);
case 3:
return ep3__3.call(this,x,y,z);
default:
return ep3__4.cljs$lang$arity$variadic(x,y,z, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
ep3.cljs$lang$maxFixedArity = 3;
ep3.cljs$lang$applyTo = ep3__4.cljs$lang$applyTo;
ep3.cljs$lang$arity$0 = ep3__0;
ep3.cljs$lang$arity$1 = ep3__1;
ep3.cljs$lang$arity$2 = ep3__2;
ep3.cljs$lang$arity$3 = ep3__3;
ep3.cljs$lang$arity$variadic = ep3__4.cljs$lang$arity$variadic;
return ep3;
})()
});
var every_pred__4 = (function() { 
var G__13258__delegate = function (p1,p2,p3,ps){
var ps__13243 = cljs.core.list_STAR_.call(null,p1,p2,p3,ps);
return (function() {
var epn = null;
var epn__0 = (function (){
return true;
});
var epn__1 = (function (x){
return cljs.core.every_QMARK_.call(null,(function (p1__13053_SHARP_){
return p1__13053_SHARP_.call(null,x);
}),ps__13243);
});
var epn__2 = (function (x,y){
return cljs.core.every_QMARK_.call(null,(function (p1__13054_SHARP_){
var and__3822__auto____13248 = p1__13054_SHARP_.call(null,x);
if(cljs.core.truth_(and__3822__auto____13248))
{return p1__13054_SHARP_.call(null,y);
} else
{return and__3822__auto____13248;
}
}),ps__13243);
});
var epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_.call(null,(function (p1__13055_SHARP_){
var and__3822__auto____13249 = p1__13055_SHARP_.call(null,x);
if(cljs.core.truth_(and__3822__auto____13249))
{var and__3822__auto____13250 = p1__13055_SHARP_.call(null,y);
if(cljs.core.truth_(and__3822__auto____13250))
{return p1__13055_SHARP_.call(null,z);
} else
{return and__3822__auto____13250;
}
} else
{return and__3822__auto____13249;
}
}),ps__13243);
});
var epn__4 = (function() { 
var G__13259__delegate = function (x,y,z,args){
return cljs.core.boolean$.call(null,(function (){var and__3822__auto____13251 = epn.call(null,x,y,z);
if(cljs.core.truth_(and__3822__auto____13251))
{return cljs.core.every_QMARK_.call(null,(function (p1__13056_SHARP_){
return cljs.core.every_QMARK_.call(null,p1__13056_SHARP_,args);
}),ps__13243);
} else
{return and__3822__auto____13251;
}
})());
};
var G__13259 = function (x,y,z,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__13259__delegate.call(this, x, y, z, args);
};
G__13259.cljs$lang$maxFixedArity = 3;
G__13259.cljs$lang$applyTo = (function (arglist__13260){
var x = cljs.core.first(arglist__13260);
var y = cljs.core.first(cljs.core.next(arglist__13260));
var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__13260)));
var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__13260)));
return G__13259__delegate(x, y, z, args);
});
G__13259.cljs$lang$arity$variadic = G__13259__delegate;
return G__13259;
})()
;
epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return epn__0.call(this);
case 1:
return epn__1.call(this,x);
case 2:
return epn__2.call(this,x,y);
case 3:
return epn__3.call(this,x,y,z);
default:
return epn__4.cljs$lang$arity$variadic(x,y,z, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
epn.cljs$lang$maxFixedArity = 3;
epn.cljs$lang$applyTo = epn__4.cljs$lang$applyTo;
epn.cljs$lang$arity$0 = epn__0;
epn.cljs$lang$arity$1 = epn__1;
epn.cljs$lang$arity$2 = epn__2;
epn.cljs$lang$arity$3 = epn__3;
epn.cljs$lang$arity$variadic = epn__4.cljs$lang$arity$variadic;
return epn;
})()
};
var G__13258 = function (p1,p2,p3,var_args){
var ps = null;
if (goog.isDef(var_args)) {
  ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__13258__delegate.call(this, p1, p2, p3, ps);
};
G__13258.cljs$lang$maxFixedArity = 3;
G__13258.cljs$lang$applyTo = (function (arglist__13261){
var p1 = cljs.core.first(arglist__13261);
var p2 = cljs.core.first(cljs.core.next(arglist__13261));
var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__13261)));
var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__13261)));
return G__13258__delegate(p1, p2, p3, ps);
});
G__13258.cljs$lang$arity$variadic = G__13258__delegate;
return G__13258;
})()
;
every_pred = function(p1,p2,p3,var_args){
var ps = var_args;
switch(arguments.length){
case 1:
return every_pred__1.call(this,p1);
case 2:
return every_pred__2.call(this,p1,p2);
case 3:
return every_pred__3.call(this,p1,p2,p3);
default:
return every_pred__4.cljs$lang$arity$variadic(p1,p2,p3, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
every_pred.cljs$lang$maxFixedArity = 3;
every_pred.cljs$lang$applyTo = every_pred__4.cljs$lang$applyTo;
every_pred.cljs$lang$arity$1 = every_pred__1;
every_pred.cljs$lang$arity$2 = every_pred__2;
every_pred.cljs$lang$arity$3 = every_pred__3;
every_pred.cljs$lang$arity$variadic = every_pred__4.cljs$lang$arity$variadic;
return every_pred;
})()
;
/**
* Takes a set of predicates and returns a function f that returns the first logical true value
* returned by one of its composing predicates against any of its arguments, else it returns
* logical false. Note that f is short-circuiting in that it will stop execution on the first
* argument that triggers a logical true result against the original predicates.
* @param {...*} var_args
*/
cljs.core.some_fn = (function() {
var some_fn = null;
var some_fn__1 = (function (p){
return (function() {
var sp1 = null;
var sp1__0 = (function (){
return null;
});
var sp1__1 = (function (x){
return p.call(null,x);
});
var sp1__2 = (function (x,y){
var or__3824__auto____13342 = p.call(null,x);
if(cljs.core.truth_(or__3824__auto____13342))
{return or__3824__auto____13342;
} else
{return p.call(null,y);
}
});
var sp1__3 = (function (x,y,z){
var or__3824__auto____13343 = p.call(null,x);
if(cljs.core.truth_(or__3824__auto____13343))
{return or__3824__auto____13343;
} else
{var or__3824__auto____13344 = p.call(null,y);
if(cljs.core.truth_(or__3824__auto____13344))
{return or__3824__auto____13344;
} else
{return p.call(null,z);
}
}
});
var sp1__4 = (function() { 
var G__13413__delegate = function (x,y,z,args){
var or__3824__auto____13345 = sp1.call(null,x,y,z);
if(cljs.core.truth_(or__3824__auto____13345))
{return or__3824__auto____13345;
} else
{return cljs.core.some.call(null,p,args);
}
};
var G__13413 = function (x,y,z,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__13413__delegate.call(this, x, y, z, args);
};
G__13413.cljs$lang$maxFixedArity = 3;
G__13413.cljs$lang$applyTo = (function (arglist__13414){
var x = cljs.core.first(arglist__13414);
var y = cljs.core.first(cljs.core.next(arglist__13414));
var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__13414)));
var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__13414)));
return G__13413__delegate(x, y, z, args);
});
G__13413.cljs$lang$arity$variadic = G__13413__delegate;
return G__13413;
})()
;
sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return sp1__0.call(this);
case 1:
return sp1__1.call(this,x);
case 2:
return sp1__2.call(this,x,y);
case 3:
return sp1__3.call(this,x,y,z);
default:
return sp1__4.cljs$lang$arity$variadic(x,y,z, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
sp1.cljs$lang$maxFixedArity = 3;
sp1.cljs$lang$applyTo = sp1__4.cljs$lang$applyTo;
sp1.cljs$lang$arity$0 = sp1__0;
sp1.cljs$lang$arity$1 = sp1__1;
sp1.cljs$lang$arity$2 = sp1__2;
sp1.cljs$lang$arity$3 = sp1__3;
sp1.cljs$lang$arity$variadic = sp1__4.cljs$lang$arity$variadic;
return sp1;
})()
});
var some_fn__2 = (function (p1,p2){
return (function() {
var sp2 = null;
var sp2__0 = (function (){
return null;
});
var sp2__1 = (function (x){
var or__3824__auto____13357 = p1.call(null,x);
if(cljs.core.truth_(or__3824__auto____13357))
{return or__3824__auto____13357;
} else
{return p2.call(null,x);
}
});
var sp2__2 = (function (x,y){
var or__3824__auto____13358 = p1.call(null,x);
if(cljs.core.truth_(or__3824__auto____13358))
{return or__3824__auto____13358;
} else
{var or__3824__auto____13359 = p1.call(null,y);
if(cljs.core.truth_(or__3824__auto____13359))
{return or__3824__auto____13359;
} else
{var or__3824__auto____13360 = p2.call(null,x);
if(cljs.core.truth_(or__3824__auto____13360))
{return or__3824__auto____13360;
} else
{return p2.call(null,y);
}
}
}
});
var sp2__3 = (function (x,y,z){
var or__3824__auto____13361 = p1.call(null,x);
if(cljs.core.truth_(or__3824__auto____13361))
{return or__3824__auto____13361;
} else
{var or__3824__auto____13362 = p1.call(null,y);
if(cljs.core.truth_(or__3824__auto____13362))
{return or__3824__auto____13362;
} else
{var or__3824__auto____13363 = p1.call(null,z);
if(cljs.core.truth_(or__3824__auto____13363))
{return or__3824__auto____13363;
} else
{var or__3824__auto____13364 = p2.call(null,x);
if(cljs.core.truth_(or__3824__auto____13364))
{return or__3824__auto____13364;
} else
{var or__3824__auto____13365 = p2.call(null,y);
if(cljs.core.truth_(or__3824__auto____13365))
{return or__3824__auto____13365;
} else
{return p2.call(null,z);
}
}
}
}
}
});
var sp2__4 = (function() { 
var G__13415__delegate = function (x,y,z,args){
var or__3824__auto____13366 = sp2.call(null,x,y,z);
if(cljs.core.truth_(or__3824__auto____13366))
{return or__3824__auto____13366;
} else
{return cljs.core.some.call(null,(function (p1__13096_SHARP_){
var or__3824__auto____13367 = p1.call(null,p1__13096_SHARP_);
if(cljs.core.truth_(or__3824__auto____13367))
{return or__3824__auto____13367;
} else
{return p2.call(null,p1__13096_SHARP_);
}
}),args);
}
};
var G__13415 = function (x,y,z,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__13415__delegate.call(this, x, y, z, args);
};
G__13415.cljs$lang$maxFixedArity = 3;
G__13415.cljs$lang$applyTo = (function (arglist__13416){
var x = cljs.core.first(arglist__13416);
var y = cljs.core.first(cljs.core.next(arglist__13416));
var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__13416)));
var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__13416)));
return G__13415__delegate(x, y, z, args);
});
G__13415.cljs$lang$arity$variadic = G__13415__delegate;
return G__13415;
})()
;
sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return sp2__0.call(this);
case 1:
return sp2__1.call(this,x);
case 2:
return sp2__2.call(this,x,y);
case 3:
return sp2__3.call(this,x,y,z);
default:
return sp2__4.cljs$lang$arity$variadic(x,y,z, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
sp2.cljs$lang$maxFixedArity = 3;
sp2.cljs$lang$applyTo = sp2__4.cljs$lang$applyTo;
sp2.cljs$lang$arity$0 = sp2__0;
sp2.cljs$lang$arity$1 = sp2__1;
sp2.cljs$lang$arity$2 = sp2__2;
sp2.cljs$lang$arity$3 = sp2__3;
sp2.cljs$lang$arity$variadic = sp2__4.cljs$lang$arity$variadic;
return sp2;
})()
});
var some_fn__3 = (function (p1,p2,p3){
return (function() {
var sp3 = null;
var sp3__0 = (function (){
return null;
});
var sp3__1 = (function (x){
var or__3824__auto____13386 = p1.call(null,x);
if(cljs.core.truth_(or__3824__auto____13386))
{return or__3824__auto____13386;
} else
{var or__3824__auto____13387 = p2.call(null,x);
if(cljs.core.truth_(or__3824__auto____13387))
{return or__3824__auto____13387;
} else
{return p3.call(null,x);
}
}
});
var sp3__2 = (function (x,y){
var or__3824__auto____13388 = p1.call(null,x);
if(cljs.core.truth_(or__3824__auto____13388))
{return or__3824__auto____13388;
} else
{var or__3824__auto____13389 = p2.call(null,x);
if(cljs.core.truth_(or__3824__auto____13389))
{return or__3824__auto____13389;
} else
{var or__3824__auto____13390 = p3.call(null,x);
if(cljs.core.truth_(or__3824__auto____13390))
{return or__3824__auto____13390;
} else
{var or__3824__auto____13391 = p1.call(null,y);
if(cljs.core.truth_(or__3824__auto____13391))
{return or__3824__auto____13391;
} else
{var or__3824__auto____13392 = p2.call(null,y);
if(cljs.core.truth_(or__3824__auto____13392))
{return or__3824__auto____13392;
} else
{return p3.call(null,y);
}
}
}
}
}
});
var sp3__3 = (function (x,y,z){
var or__3824__auto____13393 = p1.call(null,x);
if(cljs.core.truth_(or__3824__auto____13393))
{return or__3824__auto____13393;
} else
{var or__3824__auto____13394 = p2.call(null,x);
if(cljs.core.truth_(or__3824__auto____13394))
{return or__3824__auto____13394;
} else
{var or__3824__auto____13395 = p3.call(null,x);
if(cljs.core.truth_(or__3824__auto____13395))
{return or__3824__auto____13395;
} else
{var or__3824__auto____13396 = p1.call(null,y);
if(cljs.core.truth_(or__3824__auto____13396))
{return or__3824__auto____13396;
} else
{var or__3824__auto____13397 = p2.call(null,y);
if(cljs.core.truth_(or__3824__auto____13397))
{return or__3824__auto____13397;
} else
{var or__3824__auto____13398 = p3.call(null,y);
if(cljs.core.truth_(or__3824__auto____13398))
{return or__3824__auto____13398;
} else
{var or__3824__auto____13399 = p1.call(null,z);
if(cljs.core.truth_(or__3824__auto____13399))
{return or__3824__auto____13399;
} else
{var or__3824__auto____13400 = p2.call(null,z);
if(cljs.core.truth_(or__3824__auto____13400))
{return or__3824__auto____13400;
} else
{return p3.call(null,z);
}
}
}
}
}
}
}
}
});
var sp3__4 = (function() { 
var G__13417__delegate = function (x,y,z,args){
var or__3824__auto____13401 = sp3.call(null,x,y,z);
if(cljs.core.truth_(or__3824__auto____13401))
{return or__3824__auto____13401;
} else
{return cljs.core.some.call(null,(function (p1__13097_SHARP_){
var or__3824__auto____13402 = p1.call(null,p1__13097_SHARP_);
if(cljs.core.truth_(or__3824__auto____13402))
{return or__3824__auto____13402;
} else
{var or__3824__auto____13403 = p2.call(null,p1__13097_SHARP_);
if(cljs.core.truth_(or__3824__auto____13403))
{return or__3824__auto____13403;
} else
{return p3.call(null,p1__13097_SHARP_);
}
}
}),args);
}
};
var G__13417 = function (x,y,z,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__13417__delegate.call(this, x, y, z, args);
};
G__13417.cljs$lang$maxFixedArity = 3;
G__13417.cljs$lang$applyTo = (function (arglist__13418){
var x = cljs.core.first(arglist__13418);
var y = cljs.core.first(cljs.core.next(arglist__13418));
var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__13418)));
var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__13418)));
return G__13417__delegate(x, y, z, args);
});
G__13417.cljs$lang$arity$variadic = G__13417__delegate;
return G__13417;
})()
;
sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return sp3__0.call(this);
case 1:
return sp3__1.call(this,x);
case 2:
return sp3__2.call(this,x,y);
case 3:
return sp3__3.call(this,x,y,z);
default:
return sp3__4.cljs$lang$arity$variadic(x,y,z, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
sp3.cljs$lang$maxFixedArity = 3;
sp3.cljs$lang$applyTo = sp3__4.cljs$lang$applyTo;
sp3.cljs$lang$arity$0 = sp3__0;
sp3.cljs$lang$arity$1 = sp3__1;
sp3.cljs$lang$arity$2 = sp3__2;
sp3.cljs$lang$arity$3 = sp3__3;
sp3.cljs$lang$arity$variadic = sp3__4.cljs$lang$arity$variadic;
return sp3;
})()
});
var some_fn__4 = (function() { 
var G__13419__delegate = function (p1,p2,p3,ps){
var ps__13404 = cljs.core.list_STAR_.call(null,p1,p2,p3,ps);
return (function() {
var spn = null;
var spn__0 = (function (){
return null;
});
var spn__1 = (function (x){
return cljs.core.some.call(null,(function (p1__13098_SHARP_){
return p1__13098_SHARP_.call(null,x);
}),ps__13404);
});
var spn__2 = (function (x,y){
return cljs.core.some.call(null,(function (p1__13099_SHARP_){
var or__3824__auto____13409 = p1__13099_SHARP_.call(null,x);
if(cljs.core.truth_(or__3824__auto____13409))
{return or__3824__auto____13409;
} else
{return p1__13099_SHARP_.call(null,y);
}
}),ps__13404);
});
var spn__3 = (function (x,y,z){
return cljs.core.some.call(null,(function (p1__13100_SHARP_){
var or__3824__auto____13410 = p1__13100_SHARP_.call(null,x);
if(cljs.core.truth_(or__3824__auto____13410))
{return or__3824__auto____13410;
} else
{var or__3824__auto____13411 = p1__13100_SHARP_.call(null,y);
if(cljs.core.truth_(or__3824__auto____13411))
{return or__3824__auto____13411;
} else
{return p1__13100_SHARP_.call(null,z);
}
}
}),ps__13404);
});
var spn__4 = (function() { 
var G__13420__delegate = function (x,y,z,args){
var or__3824__auto____13412 = spn.call(null,x,y,z);
if(cljs.core.truth_(or__3824__auto____13412))
{return or__3824__auto____13412;
} else
{return cljs.core.some.call(null,(function (p1__13101_SHARP_){
return cljs.core.some.call(null,p1__13101_SHARP_,args);
}),ps__13404);
}
};
var G__13420 = function (x,y,z,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__13420__delegate.call(this, x, y, z, args);
};
G__13420.cljs$lang$maxFixedArity = 3;
G__13420.cljs$lang$applyTo = (function (arglist__13421){
var x = cljs.core.first(arglist__13421);
var y = cljs.core.first(cljs.core.next(arglist__13421));
var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__13421)));
var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__13421)));
return G__13420__delegate(x, y, z, args);
});
G__13420.cljs$lang$arity$variadic = G__13420__delegate;
return G__13420;
})()
;
spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return spn__0.call(this);
case 1:
return spn__1.call(this,x);
case 2:
return spn__2.call(this,x,y);
case 3:
return spn__3.call(this,x,y,z);
default:
return spn__4.cljs$lang$arity$variadic(x,y,z, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
spn.cljs$lang$maxFixedArity = 3;
spn.cljs$lang$applyTo = spn__4.cljs$lang$applyTo;
spn.cljs$lang$arity$0 = spn__0;
spn.cljs$lang$arity$1 = spn__1;
spn.cljs$lang$arity$2 = spn__2;
spn.cljs$lang$arity$3 = spn__3;
spn.cljs$lang$arity$variadic = spn__4.cljs$lang$arity$variadic;
return spn;
})()
};
var G__13419 = function (p1,p2,p3,var_args){
var ps = null;
if (goog.isDef(var_args)) {
  ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__13419__delegate.call(this, p1, p2, p3, ps);
};
G__13419.cljs$lang$maxFixedArity = 3;
G__13419.cljs$lang$applyTo = (function (arglist__13422){
var p1 = cljs.core.first(arglist__13422);
var p2 = cljs.core.first(cljs.core.next(arglist__13422));
var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__13422)));
var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__13422)));
return G__13419__delegate(p1, p2, p3, ps);
});
G__13419.cljs$lang$arity$variadic = G__13419__delegate;
return G__13419;
})()
;
some_fn = function(p1,p2,p3,var_args){
var ps = var_args;
switch(arguments.length){
case 1:
return some_fn__1.call(this,p1);
case 2:
return some_fn__2.call(this,p1,p2);
case 3:
return some_fn__3.call(this,p1,p2,p3);
default:
return some_fn__4.cljs$lang$arity$variadic(p1,p2,p3, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
some_fn.cljs$lang$maxFixedArity = 3;
some_fn.cljs$lang$applyTo = some_fn__4.cljs$lang$applyTo;
some_fn.cljs$lang$arity$1 = some_fn__1;
some_fn.cljs$lang$arity$2 = some_fn__2;
some_fn.cljs$lang$arity$3 = some_fn__3;
some_fn.cljs$lang$arity$variadic = some_fn__4.cljs$lang$arity$variadic;
return some_fn;
})()
;
/**
* Returns a lazy sequence consisting of the result of applying f to the
* set of first items of each coll, followed by applying f to the set
* of second items in each coll, until any one of the colls is
* exhausted.  Any remaining items in other colls are ignored. Function
* f should accept number-of-colls arguments.
* @param {...*} var_args
*/
cljs.core.map = (function() {
var map = null;
var map__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,false,(function (){
var temp__3974__auto____13441 = cljs.core.seq.call(null,coll);
if(temp__3974__auto____13441)
{var s__13442 = temp__3974__auto____13441;
if(cljs.core.chunked_seq_QMARK_.call(null,s__13442))
{var c__13443 = cljs.core.chunk_first.call(null,s__13442);
var size__13444 = cljs.core.count.call(null,c__13443);
var b__13445 = cljs.core.chunk_buffer.call(null,size__13444);
var n__5049__auto____13446 = size__13444;
var i__13447 = 0;
while(true){
if((i__13447 < n__5049__auto____13446))
{cljs.core.chunk_append.call(null,b__13445,f.call(null,cljs.core._nth.call(null,c__13443,i__13447)));
{
var G__13459 = (i__13447 + 1);
i__13447 = G__13459;
continue;
}
} else
{}
break;
}
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13445),map.call(null,f,cljs.core.chunk_rest.call(null,s__13442)));
} else
{return cljs.core.cons.call(null,f.call(null,cljs.core.first.call(null,s__13442)),map.call(null,f,cljs.core.rest.call(null,s__13442)));
}
} else
{return null;
}
}),null));
});
var map__3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,false,(function (){
var s1__13448 = cljs.core.seq.call(null,c1);
var s2__13449 = cljs.core.seq.call(null,c2);
if((function (){var and__3822__auto____13450 = s1__13448;
if(and__3822__auto____13450)
{return s2__13449;
} else
{return and__3822__auto____13450;
}
})())
{return cljs.core.cons.call(null,f.call(null,cljs.core.first.call(null,s1__13448),cljs.core.first.call(null,s2__13449)),map.call(null,f,cljs.core.rest.call(null,s1__13448),cljs.core.rest.call(null,s2__13449)));
} else
{return null;
}
}),null));
});
var map__4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,false,(function (){
var s1__13451 = cljs.core.seq.call(null,c1);
var s2__13452 = cljs.core.seq.call(null,c2);
var s3__13453 = cljs.core.seq.call(null,c3);
if((function (){var and__3822__auto____13454 = s1__13451;
if(and__3822__auto____13454)
{var and__3822__auto____13455 = s2__13452;
if(and__3822__auto____13455)
{return s3__13453;
} else
{return and__3822__auto____13455;
}
} else
{return and__3822__auto____13454;
}
})())
{return cljs.core.cons.call(null,f.call(null,cljs.core.first.call(null,s1__13451),cljs.core.first.call(null,s2__13452),cljs.core.first.call(null,s3__13453)),map.call(null,f,cljs.core.rest.call(null,s1__13451),cljs.core.rest.call(null,s2__13452),cljs.core.rest.call(null,s3__13453)));
} else
{return null;
}
}),null));
});
var map__5 = (function() { 
var G__13460__delegate = function (f,c1,c2,c3,colls){
var step__13458 = (function step(cs){
return (new cljs.core.LazySeq(null,false,(function (){
var ss__13457 = map.call(null,cljs.core.seq,cs);
if(cljs.core.every_QMARK_.call(null,cljs.core.identity,ss__13457))
{return cljs.core.cons.call(null,map.call(null,cljs.core.first,ss__13457),step.call(null,map.call(null,cljs.core.rest,ss__13457)));
} else
{return null;
}
}),null));
});
return map.call(null,(function (p1__13262_SHARP_){
return cljs.core.apply.call(null,f,p1__13262_SHARP_);
}),step__13458.call(null,cljs.core.conj.call(null,colls,c3,c2,c1)));
};
var G__13460 = function (f,c1,c2,c3,var_args){
var colls = null;
if (goog.isDef(var_args)) {
  colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4),0);
} 
return G__13460__delegate.call(this, f, c1, c2, c3, colls);
};
G__13460.cljs$lang$maxFixedArity = 4;
G__13460.cljs$lang$applyTo = (function (arglist__13461){
var f = cljs.core.first(arglist__13461);
var c1 = cljs.core.first(cljs.core.next(arglist__13461));
var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__13461)));
var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__13461))));
var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__13461))));
return G__13460__delegate(f, c1, c2, c3, colls);
});
G__13460.cljs$lang$arity$variadic = G__13460__delegate;
return G__13460;
})()
;
map = function(f,c1,c2,c3,var_args){
var colls = var_args;
switch(arguments.length){
case 2:
return map__2.call(this,f,c1);
case 3:
return map__3.call(this,f,c1,c2);
case 4:
return map__4.call(this,f,c1,c2,c3);
default:
return map__5.cljs$lang$arity$variadic(f,c1,c2,c3, cljs.core.array_seq(arguments, 4));
}
throw('Invalid arity: ' + arguments.length);
};
map.cljs$lang$maxFixedArity = 4;
map.cljs$lang$applyTo = map__5.cljs$lang$applyTo;
map.cljs$lang$arity$2 = map__2;
map.cljs$lang$arity$3 = map__3;
map.cljs$lang$arity$4 = map__4;
map.cljs$lang$arity$variadic = map__5.cljs$lang$arity$variadic;
return map;
})()
;
/**
* Returns a lazy sequence of the first n items in coll, or all items if
* there are fewer than n.
*/
cljs.core.take = (function take(n,coll){
return (new cljs.core.LazySeq(null,false,(function (){
if((n > 0))
{var temp__3974__auto____13464 = cljs.core.seq.call(null,coll);
if(temp__3974__auto____13464)
{var s__13465 = temp__3974__auto____13464;
return cljs.core.cons.call(null,cljs.core.first.call(null,s__13465),take.call(null,(n - 1),cljs.core.rest.call(null,s__13465)));
} else
{return null;
}
} else
{return null;
}
}),null));
});
/**
* Returns a lazy sequence of all but the first n items in coll.
*/
cljs.core.drop = (function drop(n,coll){
var step__13471 = (function (n,coll){
while(true){
var s__13469 = cljs.core.seq.call(null,coll);
if(cljs.core.truth_((function (){var and__3822__auto____13470 = (n > 0);
if(and__3822__auto____13470)
{return s__13469;
} else
{return and__3822__auto____13470;
}
})()))
{{
var G__13472 = (n - 1);
var G__13473 = cljs.core.rest.call(null,s__13469);
n = G__13472;
coll = G__13473;
continue;
}
} else
{return s__13469;
}
break;
}
});
return (new cljs.core.LazySeq(null,false,(function (){
return step__13471.call(null,n,coll);
}),null));
});
/**
* Return a lazy sequence of all but the last n (default 1) items in coll
*/
cljs.core.drop_last = (function() {
var drop_last = null;
var drop_last__1 = (function (s){
return drop_last.call(null,1,s);
});
var drop_last__2 = (function (n,s){
return cljs.core.map.call(null,(function (x,_){
return x;
}),s,cljs.core.drop.call(null,n,s));
});
drop_last = function(n,s){
switch(arguments.length){
case 1:
return drop_last__1.call(this,n);
case 2:
return drop_last__2.call(this,n,s);
}
throw('Invalid arity: ' + arguments.length);
};
drop_last.cljs$lang$arity$1 = drop_last__1;
drop_last.cljs$lang$arity$2 = drop_last__2;
return drop_last;
})()
;
/**
* Returns a seq of the last n items in coll.  Depending on the type
* of coll may be no better than linear time.  For vectors, see also subvec.
*/
cljs.core.take_last = (function take_last(n,coll){
var s__13476 = cljs.core.seq.call(null,coll);
var lead__13477 = cljs.core.seq.call(null,cljs.core.drop.call(null,n,coll));
while(true){
if(lead__13477)
{{
var G__13478 = cljs.core.next.call(null,s__13476);
var G__13479 = cljs.core.next.call(null,lead__13477);
s__13476 = G__13478;
lead__13477 = G__13479;
continue;
}
} else
{return s__13476;
}
break;
}
});
/**
* Returns a lazy sequence of the items in coll starting from the first
* item for which (pred item) returns nil.
*/
cljs.core.drop_while = (function drop_while(pred,coll){
var step__13485 = (function (pred,coll){
while(true){
var s__13483 = cljs.core.seq.call(null,coll);
if(cljs.core.truth_((function (){var and__3822__auto____13484 = s__13483;
if(and__3822__auto____13484)
{return pred.call(null,cljs.core.first.call(null,s__13483));
} else
{return and__3822__auto____13484;
}
})()))
{{
var G__13486 = pred;
var G__13487 = cljs.core.rest.call(null,s__13483);
pred = G__13486;
coll = G__13487;
continue;
}
} else
{return s__13483;
}
break;
}
});
return (new cljs.core.LazySeq(null,false,(function (){
return step__13485.call(null,pred,coll);
}),null));
});
/**
* Returns a lazy (infinite!) sequence of repetitions of the items in coll.
*/
cljs.core.cycle = (function cycle(coll){
return (new cljs.core.LazySeq(null,false,(function (){
var temp__3974__auto____13490 = cljs.core.seq.call(null,coll);
if(temp__3974__auto____13490)
{var s__13491 = temp__3974__auto____13490;
return cljs.core.concat.call(null,s__13491,cycle.call(null,s__13491));
} else
{return null;
}
}),null));
});
/**
* Returns a vector of [(take n coll) (drop n coll)]
*/
cljs.core.split_at = (function split_at(n,coll){
return cljs.core.PersistentVector.fromArray([cljs.core.take.call(null,n,coll),cljs.core.drop.call(null,n,coll)], true);
});
/**
* Returns a lazy (infinite!, or length n if supplied) sequence of xs.
*/
cljs.core.repeat = (function() {
var repeat = null;
var repeat__1 = (function (x){
return (new cljs.core.LazySeq(null,false,(function (){
return cljs.core.cons.call(null,x,repeat.call(null,x));
}),null));
});
var repeat__2 = (function (n,x){
return cljs.core.take.call(null,n,repeat.call(null,x));
});
repeat = function(n,x){
switch(arguments.length){
case 1:
return repeat__1.call(this,n);
case 2:
return repeat__2.call(this,n,x);
}
throw('Invalid arity: ' + arguments.length);
};
repeat.cljs$lang$arity$1 = repeat__1;
repeat.cljs$lang$arity$2 = repeat__2;
return repeat;
})()
;
/**
* Returns a lazy seq of n xs.
*/
cljs.core.replicate = (function replicate(n,x){
return cljs.core.take.call(null,n,cljs.core.repeat.call(null,x));
});
/**
* Takes a function of no args, presumably with side effects, and
* returns an infinite (or length n if supplied) lazy sequence of calls
* to it
*/
cljs.core.repeatedly = (function() {
var repeatedly = null;
var repeatedly__1 = (function (f){
return (new cljs.core.LazySeq(null,false,(function (){
return cljs.core.cons.call(null,f.call(null),repeatedly.call(null,f));
}),null));
});
var repeatedly__2 = (function (n,f){
return cljs.core.take.call(null,n,repeatedly.call(null,f));
});
repeatedly = function(n,f){
switch(arguments.length){
case 1:
return repeatedly__1.call(this,n);
case 2:
return repeatedly__2.call(this,n,f);
}
throw('Invalid arity: ' + arguments.length);
};
repeatedly.cljs$lang$arity$1 = repeatedly__1;
repeatedly.cljs$lang$arity$2 = repeatedly__2;
return repeatedly;
})()
;
/**
* Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
*/
cljs.core.iterate = (function iterate(f,x){
return cljs.core.cons.call(null,x,(new cljs.core.LazySeq(null,false,(function (){
return iterate.call(null,f,f.call(null,x));
}),null)));
});
/**
* Returns a lazy seq of the first item in each coll, then the second etc.
* @param {...*} var_args
*/
cljs.core.interleave = (function() {
var interleave = null;
var interleave__2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,false,(function (){
var s1__13496 = cljs.core.seq.call(null,c1);
var s2__13497 = cljs.core.seq.call(null,c2);
if((function (){var and__3822__auto____13498 = s1__13496;
if(and__3822__auto____13498)
{return s2__13497;
} else
{return and__3822__auto____13498;
}
})())
{return cljs.core.cons.call(null,cljs.core.first.call(null,s1__13496),cljs.core.cons.call(null,cljs.core.first.call(null,s2__13497),interleave.call(null,cljs.core.rest.call(null,s1__13496),cljs.core.rest.call(null,s2__13497))));
} else
{return null;
}
}),null));
});
var interleave__3 = (function() { 
var G__13500__delegate = function (c1,c2,colls){
return (new cljs.core.LazySeq(null,false,(function (){
var ss__13499 = cljs.core.map.call(null,cljs.core.seq,cljs.core.conj.call(null,colls,c2,c1));
if(cljs.core.every_QMARK_.call(null,cljs.core.identity,ss__13499))
{return cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.first,ss__13499),cljs.core.apply.call(null,interleave,cljs.core.map.call(null,cljs.core.rest,ss__13499)));
} else
{return null;
}
}),null));
};
var G__13500 = function (c1,c2,var_args){
var colls = null;
if (goog.isDef(var_args)) {
  colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__13500__delegate.call(this, c1, c2, colls);
};
G__13500.cljs$lang$maxFixedArity = 2;
G__13500.cljs$lang$applyTo = (function (arglist__13501){
var c1 = cljs.core.first(arglist__13501);
var c2 = cljs.core.first(cljs.core.next(arglist__13501));
var colls = cljs.core.rest(cljs.core.next(arglist__13501));
return G__13500__delegate(c1, c2, colls);
});
G__13500.cljs$lang$arity$variadic = G__13500__delegate;
return G__13500;
})()
;
interleave = function(c1,c2,var_args){
var colls = var_args;
switch(arguments.length){
case 2:
return interleave__2.call(this,c1,c2);
default:
return interleave__3.cljs$lang$arity$variadic(c1,c2, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
interleave.cljs$lang$maxFixedArity = 2;
interleave.cljs$lang$applyTo = interleave__3.cljs$lang$applyTo;
interleave.cljs$lang$arity$2 = interleave__2;
interleave.cljs$lang$arity$variadic = interleave__3.cljs$lang$arity$variadic;
return interleave;
})()
;
/**
* Returns a lazy seq of the elements of coll separated by sep
*/
cljs.core.interpose = (function interpose(sep,coll){
return cljs.core.drop.call(null,1,cljs.core.interleave.call(null,cljs.core.repeat.call(null,sep),coll));
});
/**
* Take a collection of collections, and return a lazy seq
* of items from the inner collection
*/
cljs.core.flatten1 = (function flatten1(colls){
var cat__13511 = (function cat(coll,colls){
return (new cljs.core.LazySeq(null,false,(function (){
var temp__3971__auto____13509 = cljs.core.seq.call(null,coll);
if(temp__3971__auto____13509)
{var coll__13510 = temp__3971__auto____13509;
return cljs.core.cons.call(null,cljs.core.first.call(null,coll__13510),cat.call(null,cljs.core.rest.call(null,coll__13510),colls));
} else
{if(cljs.core.seq.call(null,colls))
{return cat.call(null,cljs.core.first.call(null,colls),cljs.core.rest.call(null,colls));
} else
{return null;
}
}
}),null));
});
return cat__13511.call(null,null,colls);
});
/**
* Returns the result of applying concat to the result of applying map
* to f and colls.  Thus function f should return a collection.
* @param {...*} var_args
*/
cljs.core.mapcat = (function() {
var mapcat = null;
var mapcat__2 = (function (f,coll){
return cljs.core.flatten1.call(null,cljs.core.map.call(null,f,coll));
});
var mapcat__3 = (function() { 
var G__13512__delegate = function (f,coll,colls){
return cljs.core.flatten1.call(null,cljs.core.apply.call(null,cljs.core.map,f,coll,colls));
};
var G__13512 = function (f,coll,var_args){
var colls = null;
if (goog.isDef(var_args)) {
  colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return G__13512__delegate.call(this, f, coll, colls);
};
G__13512.cljs$lang$maxFixedArity = 2;
G__13512.cljs$lang$applyTo = (function (arglist__13513){
var f = cljs.core.first(arglist__13513);
var coll = cljs.core.first(cljs.core.next(arglist__13513));
var colls = cljs.core.rest(cljs.core.next(arglist__13513));
return G__13512__delegate(f, coll, colls);
});
G__13512.cljs$lang$arity$variadic = G__13512__delegate;
return G__13512;
})()
;
mapcat = function(f,coll,var_args){
var colls = var_args;
switch(arguments.length){
case 2:
return mapcat__2.call(this,f,coll);
default:
return mapcat__3.cljs$lang$arity$variadic(f,coll, cljs.core.array_seq(arguments, 2));
}
throw('Invalid arity: ' + arguments.length);
};
mapcat.cljs$lang$maxFixedArity = 2;
mapcat.cljs$lang$applyTo = mapcat__3.cljs$lang$applyTo;
mapcat.cljs$lang$arity$2 = mapcat__2;
mapcat.cljs$lang$arity$variadic = mapcat__3.cljs$lang$arity$variadic;
return mapcat;
})()
;
/**
* Returns a lazy sequence of the items in coll for which
* (pred item) returns true. pred must be free of side-effects.
*/
cljs.core.filter = (function filter(pred,coll){
return (new cljs.core.LazySeq(null,false,(function (){
var temp__3974__auto____13523 = cljs.core.seq.call(null,coll);
if(temp__3974__auto____13523)
{var s__13524 = temp__3974__auto____13523;
if(cljs.core.chunked_seq_QMARK_.call(null,s__13524))
{var c__13525 = cljs.core.chunk_first.call(null,s__13524);
var size__13526 = cljs.core.count.call(null,c__13525);
var b__13527 = cljs.core.chunk_buffer.call(null,size__13526);
var n__5049__auto____13528 = size__13526;
var i__13529 = 0;
while(true){
if((i__13529 < n__5049__auto____13528))
{if(cljs.core.truth_(pred.call(null,cljs.core._nth.call(null,c__13525,i__13529))))
{cljs.core.chunk_append.call(null,b__13527,cljs.core._nth.call(null,c__13525,i__13529));
} else
{}
{
var G__13532 = (i__13529 + 1);
i__13529 = G__13532;
continue;
}
} else
{}
break;
}
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__13527),filter.call(null,pred,cljs.core.chunk_rest.call(null,s__13524)));
} else
{var f__13530 = cljs.core.first.call(null,s__13524);
var r__13531 = cljs.core.rest.call(null,s__13524);
if(cljs.core.truth_(pred.call(null,f__13530)))
{return cljs.core.cons.call(null,f__13530,filter.call(null,pred,r__13531));
} else
{return filter.call(null,pred,r__13531);
}
}
} else
{return null;
}
}),null));
});
/**
* Returns a lazy sequence of the items in coll for which
* (pred item) returns false. pred must be free of side-effects.
*/
cljs.core.remove = (function remove(pred,coll){
return cljs.core.filter.call(null,cljs.core.complement.call(null,pred),coll);
});
/**
* Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
* branch? must be a fn of one arg that returns true if passed a node
* that can have children (but may not).  children must be a fn of one
* arg that returns a sequence of the children. Will only be called on
* nodes for which branch? returns true. Root is the root node of the
* tree.
*/
cljs.core.tree_seq = (function tree_seq(branch_QMARK_,children,root){
var walk__13535 = (function walk(node){
return (new cljs.core.LazySeq(null,false,(function (){
return cljs.core.cons.call(null,node,(cljs.core.truth_(branch_QMARK_.call(null,node))?cljs.core.mapcat.call(null,walk,children.call(null,node)):null));
}),null));
});
return walk__13535.call(null,root);
});
/**
* Takes any nested combination of sequential things (lists, vectors,
* etc.) and returns their contents as a single, flat sequence.
* (flatten nil) returns nil.
*/
cljs.core.flatten = (function flatten(x){
return cljs.core.filter.call(null,(function (p1__13533_SHARP_){
return !(cljs.core.sequential_QMARK_.call(null,p1__13533_SHARP_));
}),cljs.core.rest.call(null,cljs.core.tree_seq.call(null,cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
* Returns a new coll consisting of to-coll with all of the items of
* from-coll conjoined.
*/
cljs.core.into = (function into(to,from){
if((function (){var G__13539__13540 = to;
if(G__13539__13540)
{if((function (){var or__3824__auto____13541 = (G__13539__13540.cljs$lang$protocol_mask$partition1$ & 1);
if(or__3824__auto____13541)
{return or__3824__auto____13541;
} else
{return G__13539__13540.cljs$core$IEditableCollection$;
}
})())
{return true;
} else
{if((!G__13539__13540.cljs$lang$protocol_mask$partition1$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IEditableCollection,G__13539__13540);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IEditableCollection,G__13539__13540);
}
})())
{return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,cljs.core._conj_BANG_,cljs.core.transient$.call(null,to),from));
} else
{return cljs.core.reduce.call(null,cljs.core._conj,to,from);
}
});
/**
* Returns a vector consisting of the result of applying f to the
* set of first items of each coll, followed by applying f to the set
* of second items in each coll, until any one of the colls is
* exhausted.  Any remaining items in other colls are ignored. Function
* f should accept number-of-colls arguments.
* @param {...*} var_args
*/
cljs.core.mapv = (function() {
var mapv = null;
var mapv__2 = (function (f,coll){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (v,o){
return cljs.core.conj_BANG_.call(null,v,f.call(null,o));
}),cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY),coll));
});
var mapv__3 = (function (f,c1,c2){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,f,c1,c2));
});
var mapv__4 = (function (f,c1,c2,c3){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.map.call(null,f,c1,c2,c3));
});
var mapv__5 = (function() { 
var G__13542__delegate = function (f,c1,c2,c3,colls){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.apply.call(null,cljs.core.map,f,c1,c2,c3,colls));
};
var G__13542 = function (f,c1,c2,c3,var_args){
var colls = null;
if (goog.isDef(var_args)) {
  colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4),0);
} 
return G__13542__delegate.call(this, f, c1, c2, c3, colls);
};
G__13542.cljs$lang$maxFixedArity = 4;
G__13542.cljs$lang$applyTo = (function (arglist__13543){
var f = cljs.core.first(arglist__13543);
var c1 = cljs.core.first(cljs.core.next(arglist__13543));
var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__13543)));
var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__13543))));
var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__13543))));
return G__13542__delegate(f, c1, c2, c3, colls);
});
G__13542.cljs$lang$arity$variadic = G__13542__delegate;
return G__13542;
})()
;
mapv = function(f,c1,c2,c3,var_args){
var colls = var_args;
switch(arguments.length){
case 2:
return mapv__2.call(this,f,c1);
case 3:
return mapv__3.call(this,f,c1,c2);
case 4:
return mapv__4.call(this,f,c1,c2,c3);
default:
return mapv__5.cljs$lang$arity$variadic(f,c1,c2,c3, cljs.core.array_seq(arguments, 4));
}
throw('Invalid arity: ' + arguments.length);
};
mapv.cljs$lang$maxFixedArity = 4;
mapv.cljs$lang$applyTo = mapv__5.cljs$lang$applyTo;
mapv.cljs$lang$arity$2 = mapv__2;
mapv.cljs$lang$arity$3 = mapv__3;
mapv.cljs$lang$arity$4 = mapv__4;
mapv.cljs$lang$arity$variadic = mapv__5.cljs$lang$arity$variadic;
return mapv;
})()
;
/**
* Returns a vector of the items in coll for which
* (pred item) returns true. pred must be free of side-effects.
*/
cljs.core.filterv = (function filterv(pred,coll){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (v,o){
if(cljs.core.truth_(pred.call(null,o)))
{return cljs.core.conj_BANG_.call(null,v,o);
} else
{return v;
}
}),cljs.core.transient$.call(null,cljs.core.PersistentVector.EMPTY),coll));
});
/**
* Returns a lazy sequence of lists of n items each, at offsets step
* apart. If step is not supplied, defaults to n, i.e. the partitions
* do not overlap. If a pad collection is supplied, use its elements as
* necessary to complete last partition upto n items. In case there are
* not enough padding elements, return a partition with less than n items.
*/
cljs.core.partition = (function() {
var partition = null;
var partition__2 = (function (n,coll){
return partition.call(null,n,n,coll);
});
var partition__3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,false,(function (){
var temp__3974__auto____13550 = cljs.core.seq.call(null,coll);
if(temp__3974__auto____13550)
{var s__13551 = temp__3974__auto____13550;
var p__13552 = cljs.core.take.call(null,n,s__13551);
if((n === cljs.core.count.call(null,p__13552)))
{return cljs.core.cons.call(null,p__13552,partition.call(null,n,step,cljs.core.drop.call(null,step,s__13551)));
} else
{return null;
}
} else
{return null;
}
}),null));
});
var partition__4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,false,(function (){
var temp__3974__auto____13553 = cljs.core.seq.call(null,coll);
if(temp__3974__auto____13553)
{var s__13554 = temp__3974__auto____13553;
var p__13555 = cljs.core.take.call(null,n,s__13554);
if((n === cljs.core.count.call(null,p__13555)))
{return cljs.core.cons.call(null,p__13555,partition.call(null,n,step,pad,cljs.core.drop.call(null,step,s__13554)));
} else
{return cljs.core.list.call(null,cljs.core.take.call(null,n,cljs.core.concat.call(null,p__13555,pad)));
}
} else
{return null;
}
}),null));
});
partition = function(n,step,pad,coll){
switch(arguments.length){
case 2:
return partition__2.call(this,n,step);
case 3:
return partition__3.call(this,n,step,pad);
case 4:
return partition__4.call(this,n,step,pad,coll);
}
throw('Invalid arity: ' + arguments.length);
};
partition.cljs$lang$arity$2 = partition__2;
partition.cljs$lang$arity$3 = partition__3;
partition.cljs$lang$arity$4 = partition__4;
return partition;
})()
;
/**
* Returns the value in a nested associative structure,
* where ks is a sequence of keys. Returns nil if the key is not present,
* or the not-found value if supplied.
*/
cljs.core.get_in = (function() {
var get_in = null;
var get_in__2 = (function (m,ks){
return cljs.core.reduce.call(null,cljs.core.get,m,ks);
});
var get_in__3 = (function (m,ks,not_found){
var sentinel__13560 = cljs.core.lookup_sentinel;
var m__13561 = m;
var ks__13562 = cljs.core.seq.call(null,ks);
while(true){
if(ks__13562)
{var m__13563 = cljs.core._lookup.call(null,m__13561,cljs.core.first.call(null,ks__13562),sentinel__13560);
if((sentinel__13560 === m__13563))
{return not_found;
} else
{{
var G__13564 = sentinel__13560;
var G__13565 = m__13563;
var G__13566 = cljs.core.next.call(null,ks__13562);
sentinel__13560 = G__13564;
m__13561 = G__13565;
ks__13562 = G__13566;
continue;
}
}
} else
{return m__13561;
}
break;
}
});
get_in = function(m,ks,not_found){
switch(arguments.length){
case 2:
return get_in__2.call(this,m,ks);
case 3:
return get_in__3.call(this,m,ks,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
get_in.cljs$lang$arity$2 = get_in__2;
get_in.cljs$lang$arity$3 = get_in__3;
return get_in;
})()
;
/**
* Associates a value in a nested associative structure, where ks is a
* sequence of keys and v is the new value and returns a new nested structure.
* If any levels do not exist, hash-maps will be created.
*/
cljs.core.assoc_in = (function assoc_in(m,p__13567,v){
var vec__13572__13573 = p__13567;
var k__13574 = cljs.core.nth.call(null,vec__13572__13573,0,null);
var ks__13575 = cljs.core.nthnext.call(null,vec__13572__13573,1);
if(cljs.core.truth_(ks__13575))
{return cljs.core.assoc.call(null,m,k__13574,assoc_in.call(null,cljs.core._lookup.call(null,m,k__13574,null),ks__13575,v));
} else
{return cljs.core.assoc.call(null,m,k__13574,v);
}
});
/**
* 'Updates' a value in a nested associative structure, where ks is a
* sequence of keys and f is a function that will take the old value
* and any supplied args and return the new value, and returns a new
* nested structure.  If any levels do not exist, hash-maps will be
* created.
* @param {...*} var_args
*/
cljs.core.update_in = (function() { 
var update_in__delegate = function (m,p__13576,f,args){
var vec__13581__13582 = p__13576;
var k__13583 = cljs.core.nth.call(null,vec__13581__13582,0,null);
var ks__13584 = cljs.core.nthnext.call(null,vec__13581__13582,1);
if(cljs.core.truth_(ks__13584))
{return cljs.core.assoc.call(null,m,k__13583,cljs.core.apply.call(null,update_in,cljs.core._lookup.call(null,m,k__13583,null),ks__13584,f,args));
} else
{return cljs.core.assoc.call(null,m,k__13583,cljs.core.apply.call(null,f,cljs.core._lookup.call(null,m,k__13583,null),args));
}
};
var update_in = function (m,p__13576,f,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return update_in__delegate.call(this, m, p__13576, f, args);
};
update_in.cljs$lang$maxFixedArity = 3;
update_in.cljs$lang$applyTo = (function (arglist__13585){
var m = cljs.core.first(arglist__13585);
var p__13576 = cljs.core.first(cljs.core.next(arglist__13585));
var f = cljs.core.first(cljs.core.next(cljs.core.next(arglist__13585)));
var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__13585)));
return update_in__delegate(m, p__13576, f, args);
});
update_in.cljs$lang$arity$variadic = update_in__delegate;
return update_in;
})()
;

/**
* @constructor
*/
cljs.core.Vector = (function (meta,array,__hash){
this.meta = meta;
this.array = array;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32400159;
})
cljs.core.Vector.cljs$lang$type = true;
cljs.core.Vector.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/Vector");
});
cljs.core.Vector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__13588 = this;
var h__4714__auto____13589 = this__13588.__hash;
if(!((h__4714__auto____13589 == null)))
{return h__4714__auto____13589;
} else
{var h__4714__auto____13590 = cljs.core.hash_coll.call(null,coll);
this__13588.__hash = h__4714__auto____13590;
return h__4714__auto____13590;
}
});
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var this__13591 = this;
return coll.cljs$core$IIndexed$_nth$arity$3(coll,k,null);
});
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var this__13592 = this;
return coll.cljs$core$IIndexed$_nth$arity$3(coll,k,not_found);
});
cljs.core.Vector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var this__13593 = this;
var new_array__13594 = this__13593.array.slice();
(new_array__13594[k] = v);
return (new cljs.core.Vector(this__13593.meta,new_array__13594,null));
});
cljs.core.Vector.prototype.call = (function() {
var G__13625 = null;
var G__13625__2 = (function (this_sym13595,k){
var this__13597 = this;
var this_sym13595__13598 = this;
var coll__13599 = this_sym13595__13598;
return coll__13599.cljs$core$ILookup$_lookup$arity$2(coll__13599,k);
});
var G__13625__3 = (function (this_sym13596,k,not_found){
var this__13597 = this;
var this_sym13596__13600 = this;
var coll__13601 = this_sym13596__13600;
return coll__13601.cljs$core$ILookup$_lookup$arity$3(coll__13601,k,not_found);
});
G__13625 = function(this_sym13596,k,not_found){
switch(arguments.length){
case 2:
return G__13625__2.call(this,this_sym13596,k);
case 3:
return G__13625__3.call(this,this_sym13596,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__13625;
})()
;
cljs.core.Vector.prototype.apply = (function (this_sym13586,args13587){
var this__13602 = this;
return this_sym13586.call.apply(this_sym13586,[this_sym13586].concat(args13587.slice()));
});
cljs.core.Vector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var this__13603 = this;
var new_array__13604 = this__13603.array.slice();
new_array__13604.push(o);
return (new cljs.core.Vector(this__13603.meta,new_array__13604,null));
});
cljs.core.Vector.prototype.toString = (function (){
var this__13605 = this;
var this__13606 = this;
return cljs.core.pr_str.call(null,this__13606);
});
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var this__13607 = this;
return cljs.core.ci_reduce.call(null,this__13607.array,f);
});
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,start){
var this__13608 = this;
return cljs.core.ci_reduce.call(null,this__13608.array,f,start);
});
cljs.core.Vector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__13609 = this;
if((this__13609.array.length > 0))
{var vector_seq__13610 = (function vector_seq(i){
return (new cljs.core.LazySeq(null,false,(function (){
if((i < this__13609.array.length))
{return cljs.core.cons.call(null,(this__13609.array[i]),vector_seq.call(null,(i + 1)));
} else
{return null;
}
}),null));
});
return vector_seq__13610.call(null,0);
} else
{return null;
}
});
cljs.core.Vector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var this__13611 = this;
return this__13611.array.length;
});
cljs.core.Vector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var this__13612 = this;
var count__13613 = this__13612.array.length;
if((count__13613 > 0))
{return (this__13612.array[(count__13613 - 1)]);
} else
{return null;
}
});
cljs.core.Vector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var this__13614 = this;
if((this__13614.array.length > 0))
{var new_array__13615 = this__13614.array.slice();
new_array__13615.pop();
return (new cljs.core.Vector(this__13614.meta,new_array__13615,null));
} else
{throw (new Error("Can't pop empty vector"));
}
});
cljs.core.Vector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var this__13616 = this;
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,n,val);
});
cljs.core.Vector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__13617 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.Vector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__13618 = this;
return (new cljs.core.Vector(meta,this__13618.array,this__13618.__hash));
});
cljs.core.Vector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__13619 = this;
return this__13619.meta;
});
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var this__13620 = this;
if((function (){var and__3822__auto____13621 = (0 <= n);
if(and__3822__auto____13621)
{return (n < this__13620.array.length);
} else
{return and__3822__auto____13621;
}
})())
{return (this__13620.array[n]);
} else
{return null;
}
});
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var this__13622 = this;
if((function (){var and__3822__auto____13623 = (0 <= n);
if(and__3822__auto____13623)
{return (n < this__13622.array.length);
} else
{return and__3822__auto____13623;
}
})())
{return (this__13622.array[n]);
} else
{return not_found;
}
});
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__13624 = this;
return cljs.core.with_meta.call(null,cljs.core.Vector.EMPTY,this__13624.meta);
});
cljs.core.Vector;
cljs.core.Vector.EMPTY = (new cljs.core.Vector(null,[],0));
cljs.core.Vector.fromArray = (function (xs){
return (new cljs.core.Vector(null,xs,null));
});

/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
})
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorPrSeq = (function (this__4832__auto__){
return cljs.core.list.call(null,"cljs.core/VectorNode");
});
cljs.core.VectorNode;
cljs.core.pv_fresh_node = (function pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,cljs.core.make_array.call(null,32)));
});
cljs.core.pv_aget = (function pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,node.arr.slice()));
});
cljs.core.tail_off = (function tail_off(pv){
var cnt__13627 = pv.cnt;
if((cnt__13627 < 32))
{return 0;
} else
{return (((cnt__13627 - 1) >>> 5) << 5);
}
});
cljs.core.new_path = (function new_path(edit,level,node){
var ll__13633 = level;
var ret__13634 = node;
while(true){
if((ll__13633 === 0))
{return ret__13634;
} else
{var embed__13635 = ret__13634;
var r__13636 = cljs.core.pv_fresh_node.call(null,edit);
var ___13637 = cljs.core.pv_aset.call(null,r__13636,0,embed__13635);
{
var G__13638 = (ll__13633 - 5);
var G__13639 = r__13636;
ll__13633 = G__13638;
ret__13634 = G__13639;
continue;
}
}
break;
}
});
cljs.core.push_tail = (function push_tail(pv,level,parent,tailnode){
var ret__13645 = cljs.core.pv_clone_node.call(null,parent);
var subidx__13646 = (((pv.cnt - 1) >>> level) & 31);
if((5 === level))
{cljs.core.pv_aset.call(null,ret__13645,subidx__13646,tailnode);
return ret__13645;
} else
{var child__13647 = cljs.core.pv_aget.call(null,parent,subidx__13646);
if(!((child__13647 == null)))
{var node_to_insert__13648 = push_tail.call(null,pv,(level - 5),child__13647,tailnode);
cljs.core.pv_aset.call(null,ret__13645,subidx__13646,node_to_insert__13648);
return ret__13645;
} else
{var node_to_insert__13649 = cljs.core.new_path.call(null,null,(level - 5),tailnode);
cljs.core.pv_aset.call(null,ret__13645,subidx__13646,node_to_insert__13649);
return ret__13645;
}
}
});
cljs.core.array_for = (function array_for(pv,i){
if((function (){var and__3822__auto____13653 = (0 <= i);
if(and__3822__auto____13653)
{return (i < pv.cnt);
} else
{return and__3822__auto____13653;
}
})())
{if((i >= cljs.core.tail_off.call(null,pv)))
{return pv.tail;
} else
{var node__13654 = pv.root;
var level__13655 = pv.shift;
while(true){
if((level__13655 > 0))
{{
var G__13656 = cljs.core.pv_aget.call(null,node__13654,((i >>> level__13655) & 31));
var G__13657 = (level__13655 - 5);
node__13654 = G__13656;
level__13655 = G__13657;
continue;
}
} else
{return node__13654.arr;
}
break;
}
}
} else
{throw (new Error([cljs.core.str("No item "),cljs.core.str(i),cljs.core.str(" in vector of length "),cljs.core.str(pv.cnt)].join('')));
}
});
cljs.core.do_assoc = (function do_assoc(pv,level,node,i,val){
var ret__13660 = cljs.core.pv_clone_node.call(null,node);
if((level === 0))
{cljs.core.pv_aset.call(null,ret__13660,(i & 31),val);
return ret__13660;
} else
{var subidx__13661 = ((i >>> level) & 31);
cljs.core.pv_aset.call(null,ret__13660,subidx__13661,do_assoc.call(null,pv,(level - 5),cljs.core.pv_aget.call(null,node,subidx__13661),i,val));
return ret__13660;
}
});
cljs.core.pop_tail = (function pop_tail(pv,level,node){
var subidx__13667 = (((pv.cnt - 2) >>> level) & 31);
if((level > 5))
{var new_child__13668 = pop_tail.call(null,pv,(level - 5),cljs.core.pv_aget.call(null,node,subidx__13667));
if((function (){var and__3822__auto____13669 = (new_child__13668 == null);
if(and__3822__auto____13669)
{return (subidx__13667 === 0);
} else
{return and__3822__auto____13669;
}
})())
{return null;
} else
{var ret__13670 = cljs.core.pv_clone_node.call(null,node);
cljs.core.pv_aset.call(null,ret__13670,subidx__13667,new_child__13668);
return ret__13670;
}
} else
{if((subidx__13667 === 0))
{return null;
} else
{if("\uFDD0'else")
{var ret__13671 = cljs.core.pv_clone_node.call(null,node);
cljs.core.pv_aset.call(null,ret__13671,subidx__13667,null);
return ret__13671;
} else
{return null;
}
}
}
});

/**
* @constructor
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 1;
this.cljs$lang$protocol_mask$partition0$ = 167668511;
})
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/PersistentVector");
});
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var this__13674 = this;
return (new cljs.core.TransientVector(this__13674.cnt,this__13674.shift,cljs.core.tv_editable_root.call(null,this__13674.root),cljs.core.tv_editable_tail.call(null,this__13674.tail)));
});
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__13675 = this;
var h__4714__auto____13676 = this__13675.__hash;
if(!((h__4714__auto____13676 == null)))
{return h__4714__auto____13676;
} else
{var h__4714__auto____13677 = cljs.core.hash_coll.call(null,coll);
this__13675.__hash = h__4714__auto____13677;
return h__4714__auto____13677;
}
});
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var this__13678 = this;
return coll.cljs$core$IIndexed$_nth$arity$3(coll,k,null);
});
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var this__13679 = this;
return coll.cljs$core$IIndexed$_nth$arity$3(coll,k,not_found);
});
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var this__13680 = this;
if((function (){var and__3822__auto____13681 = (0 <= k);
if(and__3822__auto____13681)
{return (k < this__13680.cnt);
} else
{return and__3822__auto____13681;
}
})())
{if((cljs.core.tail_off.call(null,coll) <= k))
{var new_tail__13682 = this__13680.tail.slice();
(new_tail__13682[(k & 31)] = v);
return (new cljs.core.PersistentVector(this__13680.meta,this__13680.cnt,this__13680.shift,this__13680.root,new_tail__13682,null));
} else
{return (new cljs.core.PersistentVector(this__13680.meta,this__13680.cnt,this__13680.shift,cljs.core.do_assoc.call(null,coll,this__13680.shift,this__13680.root,k,v),this__13680.tail,null));
}
} else
{if((k === this__13680.cnt))
{return coll.cljs$core$ICollection$_conj$arity$2(coll,v);
} else
{if("\uFDD0'else")
{throw (new Error([cljs.core.str("Index "),cljs.core.str(k),cljs.core.str(" out of bounds  [0,"),cljs.core.str(this__13680.cnt),cljs.core.str("]")].join('')));
} else
{return null;
}
}
}
});
cljs.core.PersistentVector.prototype.call = (function() {
var G__13730 = null;
var G__13730__2 = (function (this_sym13683,k){
var this__13685 = this;
var this_sym13683__13686 = this;
var coll__13687 = this_sym13683__13686;
return coll__13687.cljs$core$ILookup$_lookup$arity$2(coll__13687,k);
});
var G__13730__3 = (function (this_sym13684,k,not_found){
var this__13685 = this;
var this_sym13684__13688 = this;
var coll__13689 = this_sym13684__13688;
return coll__13689.cljs$core$ILookup$_lookup$arity$3(coll__13689,k,not_found);
});
G__13730 = function(this_sym13684,k,not_found){
switch(arguments.length){
case 2:
return G__13730__2.call(this,this_sym13684,k);
case 3:
return G__13730__3.call(this,this_sym13684,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__13730;
})()
;
cljs.core.PersistentVector.prototype.apply = (function (this_sym13672,args13673){
var this__13690 = this;
return this_sym13672.call.apply(this_sym13672,[this_sym13672].concat(args13673.slice()));
});
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var this__13691 = this;
var step_init__13692 = [0,init];
var i__13693 = 0;
while(true){
if((i__13693 < this__13691.cnt))
{var arr__13694 = cljs.core.array_for.call(null,v,i__13693);
var len__13695 = arr__13694.length;
var init__13699 = (function (){var j__13696 = 0;
var init__13697 = (step_init__13692[1]);
while(true){
if((j__13696 < len__13695))
{var init__13698 = f.call(null,init__13697,(j__13696 + i__13693),(arr__13694[j__13696]));
if(cljs.core.reduced_QMARK_.call(null,init__13698))
{return init__13698;
} else
{{
var G__13731 = (j__13696 + 1);
var G__13732 = init__13698;
j__13696 = G__13731;
init__13697 = G__13732;
continue;
}
}
} else
{(step_init__13692[0] = len__13695);
(step_init__13692[1] = init__13697);
return init__13697;
}
break;
}
})();
if(cljs.core.reduced_QMARK_.call(null,init__13699))
{return cljs.core.deref.call(null,init__13699);
} else
{{
var G__13733 = (i__13693 + (step_init__13692[0]));
i__13693 = G__13733;
continue;
}
}
} else
{return (step_init__13692[1]);
}
break;
}
});
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var this__13700 = this;
if(((this__13700.cnt - cljs.core.tail_off.call(null,coll)) < 32))
{var new_tail__13701 = this__13700.tail.slice();
new_tail__13701.push(o);
return (new cljs.core.PersistentVector(this__13700.meta,(this__13700.cnt + 1),this__13700.shift,this__13700.root,new_tail__13701,null));
} else
{var root_overflow_QMARK___13702 = ((this__13700.cnt >>> 5) > (1 << this__13700.shift));
var new_shift__13703 = ((root_overflow_QMARK___13702)?(this__13700.shift + 5):this__13700.shift);
var new_root__13705 = ((root_overflow_QMARK___13702)?(function (){var n_r__13704 = cljs.core.pv_fresh_node.call(null,null);
cljs.core.pv_aset.call(null,n_r__13704,0,this__13700.root);
cljs.core.pv_aset.call(null,n_r__13704,1,cljs.core.new_path.call(null,null,this__13700.shift,(new cljs.core.VectorNode(null,this__13700.tail))));
return n_r__13704;
})():cljs.core.push_tail.call(null,coll,this__13700.shift,this__13700.root,(new cljs.core.VectorNode(null,this__13700.tail))));
return (new cljs.core.PersistentVector(this__13700.meta,(this__13700.cnt + 1),new_shift__13703,new_root__13705,[o],null));
}
});
cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var this__13706 = this;
if((this__13706.cnt > 0))
{return (new cljs.core.RSeq(coll,(this__13706.cnt - 1),null));
} else
{return cljs.core.List.EMPTY;
}
});
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (coll){
var this__13707 = this;
return coll.cljs$core$IIndexed$_nth$arity$2(coll,0);
});
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (coll){
var this__13708 = this;
return coll.cljs$core$IIndexed$_nth$arity$2(coll,1);
});
cljs.core.PersistentVector.prototype.toString = (function (){
var this__13709 = this;
var this__13710 = this;
return cljs.core.pr_str.call(null,this__13710);
});
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var this__13711 = this;
return cljs.core.ci_reduce.call(null,v,f);
});
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,start){
var this__13712 = this;
return cljs.core.ci_reduce.call(null,v,f,start);
});
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__13713 = this;
if((this__13713.cnt === 0))
{return null;
} else
{return cljs.core.chunked_seq.call(null,coll,0,0);
}
});
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var this__13714 = this;
return this__13714.cnt;
});
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var this__13715 = this;
if((this__13715.cnt > 0))
{return coll.cljs$core$IIndexed$_nth$arity$2(coll,(this__13715.cnt - 1));
} else
{return null;
}
});
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var this__13716 = this;
if((this__13716.cnt === 0))
{throw (new Error("Can't pop empty vector"));
} else
{if((1 === this__13716.cnt))
{return cljs.core._with_meta.call(null,cljs.core.PersistentVector.EMPTY,this__13716.meta);
} else
{if((1 < (this__13716.cnt - cljs.core.tail_off.call(null,coll))))
{return (new cljs.core.PersistentVector(this__13716.meta,(this__13716.cnt - 1),this__13716.shift,this__13716.root,this__13716.tail.slice(0,-1),null));
} else
{if("\uFDD0'else")
{var new_tail__13717 = cljs.core.array_for.call(null,coll,(this__13716.cnt - 2));
var nr__13718 = cljs.core.pop_tail.call(null,coll,this__13716.shift,this__13716.root);
var new_root__13719 = (((nr__13718 == null))?cljs.core.PersistentVector.EMPTY_NODE:nr__13718);
var cnt_1__13720 = (this__13716.cnt - 1);
if((function (){var and__3822__auto____13721 = (5 < this__13716.shift);
if(and__3822__auto____13721)
{return (cljs.core.pv_aget.call(null,new_root__13719,1) == null);
} else
{return and__3822__auto____13721;
}
})())
{return (new cljs.core.PersistentVector(this__13716.meta,cnt_1__13720,(this__13716.shift - 5),cljs.core.pv_aget.call(null,new_root__13719,0),new_tail__13717,null));
} else
{return (new cljs.core.PersistentVector(this__13716.meta,cnt_1__13720,this__13716.shift,new_root__13719,new_tail__13717,null));
}
} else
{return null;
}
}
}
}
});
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var this__13722 = this;
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,n,val);
});
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__13723 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__13724 = this;
return (new cljs.core.PersistentVector(meta,this__13724.cnt,this__13724.shift,this__13724.root,this__13724.tail,this__13724.__hash));
});
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__13725 = this;
return this__13725.meta;
});
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var this__13726 = this;
return (cljs.core.array_for.call(null,coll,n)[(n & 31)]);
});
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var this__13727 = this;
if((function (){var and__3822__auto____13728 = (0 <= n);
if(and__3822__auto____13728)
{return (n < this__13727.cnt);
} else
{return and__3822__auto____13728;
}
})())
{return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else
{return not_found;
}
});
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__13729 = this;
return cljs.core.with_meta.call(null,cljs.core.PersistentVector.EMPTY,this__13729.meta);
});
cljs.core.PersistentVector;
cljs.core.PersistentVector.EMPTY_NODE = cljs.core.pv_fresh_node.call(null,null);
cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,0,5,cljs.core.PersistentVector.EMPTY_NODE,[],0));
cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l__13734 = xs.length;
var xs__13735 = (((no_clone === true))?xs:xs.slice());
if((l__13734 < 32))
{return (new cljs.core.PersistentVector(null,l__13734,5,cljs.core.PersistentVector.EMPTY_NODE,xs__13735,null));
} else
{var node__13736 = xs__13735.slice(0,32);
var v__13737 = (new cljs.core.PersistentVector(null,32,5,cljs.core.PersistentVector.EMPTY_NODE,node__13736,null));
var i__13738 = 32;
var out__13739 = cljs.core._as_transient.call(null,v__13737);
while(true){
if((i__13738 < l__13734))
{{
var G__13740 = (i__13738 + 1);
var G__13741 = cljs.core.conj_BANG_.call(null,out__13739,(xs__13735[i__13738]));
i__13738 = G__13740;
out__13739 = G__13741;
continue;
}
} else
{return cljs.core.persistent_BANG_.call(null,out__13739);
}
break;
}
}
});
cljs.core.vec = (function vec(coll){
return cljs.core._persistent_BANG_.call(null,cljs.core.reduce.call(null,cljs.core._conj_BANG_,cljs.core._as_transient.call(null,cljs.core.PersistentVector.EMPTY),coll));
});
/**
* @param {...*} var_args
*/
cljs.core.vector = (function() { 
var vector__delegate = function (args){
return cljs.core.vec.call(null,args);
};
var vector = function (var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return vector__delegate.call(this, args);
};
vector.cljs$lang$maxFixedArity = 0;
vector.cljs$lang$applyTo = (function (arglist__13742){
var args = cljs.core.seq(arglist__13742);;
return vector__delegate(args);
});
vector.cljs$lang$arity$variadic = vector__delegate;
return vector;
})()
;

/**
* @constructor
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 27525356;
})
cljs.core.ChunkedSeq.cljs$lang$type = true;
cljs.core.ChunkedSeq.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/ChunkedSeq");
});
cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var this__13743 = this;
if(((this__13743.off + 1) < this__13743.node.length))
{var s__13744 = cljs.core.chunked_seq.call(null,this__13743.vec,this__13743.node,this__13743.i,(this__13743.off + 1));
if((s__13744 == null))
{return null;
} else
{return s__13744;
}
} else
{return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
}
});
cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var this__13745 = this;
return cljs.core.cons.call(null,o,coll);
});
cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__13746 = this;
return coll;
});
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var this__13747 = this;
return (this__13747.node[this__13747.off]);
});
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var this__13748 = this;
if(((this__13748.off + 1) < this__13748.node.length))
{var s__13749 = cljs.core.chunked_seq.call(null,this__13748.vec,this__13748.node,this__13748.i,(this__13748.off + 1));
if((s__13749 == null))
{return cljs.core.List.EMPTY;
} else
{return s__13749;
}
} else
{return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
}
});
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$ = true;
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var this__13750 = this;
var l__13751 = this__13750.node.length;
var s__13752 = ((((this__13750.i + l__13751) < cljs.core._count.call(null,this__13750.vec)))?cljs.core.chunked_seq.call(null,this__13750.vec,(this__13750.i + l__13751),0):null);
if((s__13752 == null))
{return null;
} else
{return s__13752;
}
});
cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__13753 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var this__13754 = this;
return cljs.core.chunked_seq.call(null,this__13754.vec,this__13754.node,this__13754.i,this__13754.off,m);
});
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_meta$arity$1 = (function (coll){
var this__13755 = this;
return this__13755.meta;
});
cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__13756 = this;
return cljs.core.with_meta.call(null,cljs.core.PersistentVector.EMPTY,this__13756.meta);
});
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$ = true;
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var this__13757 = this;
return cljs.core.array_chunk.call(null,this__13757.node,this__13757.off);
});
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var this__13758 = this;
var l__13759 = this__13758.node.length;
var s__13760 = ((((this__13758.i + l__13759) < cljs.core._count.call(null,this__13758.vec)))?cljs.core.chunked_seq.call(null,this__13758.vec,(this__13758.i + l__13759),0):null);
if((s__13760 == null))
{return cljs.core.List.EMPTY;
} else
{return s__13760;
}
});
cljs.core.ChunkedSeq;
cljs.core.chunked_seq = (function() {
var chunked_seq = null;
var chunked_seq__3 = (function (vec,i,off){
return chunked_seq.call(null,vec,cljs.core.array_for.call(null,vec,i),i,off,null);
});
var chunked_seq__4 = (function (vec,node,i,off){
return chunked_seq.call(null,vec,node,i,off,null);
});
var chunked_seq__5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta));
});
chunked_seq = function(vec,node,i,off,meta){
switch(arguments.length){
case 3:
return chunked_seq__3.call(this,vec,node,i);
case 4:
return chunked_seq__4.call(this,vec,node,i,off);
case 5:
return chunked_seq__5.call(this,vec,node,i,off,meta);
}
throw('Invalid arity: ' + arguments.length);
};
chunked_seq.cljs$lang$arity$3 = chunked_seq__3;
chunked_seq.cljs$lang$arity$4 = chunked_seq__4;
chunked_seq.cljs$lang$arity$5 = chunked_seq__5;
return chunked_seq;
})()
;

/**
* @constructor
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32400159;
})
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/Subvec");
});
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__13763 = this;
var h__4714__auto____13764 = this__13763.__hash;
if(!((h__4714__auto____13764 == null)))
{return h__4714__auto____13764;
} else
{var h__4714__auto____13765 = cljs.core.hash_coll.call(null,coll);
this__13763.__hash = h__4714__auto____13765;
return h__4714__auto____13765;
}
});
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var this__13766 = this;
return coll.cljs$core$IIndexed$_nth$arity$3(coll,k,null);
});
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var this__13767 = this;
return coll.cljs$core$IIndexed$_nth$arity$3(coll,k,not_found);
});
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var this__13768 = this;
var v_pos__13769 = (this__13768.start + key);
return (new cljs.core.Subvec(this__13768.meta,cljs.core._assoc.call(null,this__13768.v,v_pos__13769,val),this__13768.start,((this__13768.end > (v_pos__13769 + 1)) ? this__13768.end : (v_pos__13769 + 1)),null));
});
cljs.core.Subvec.prototype.call = (function() {
var G__13795 = null;
var G__13795__2 = (function (this_sym13770,k){
var this__13772 = this;
var this_sym13770__13773 = this;
var coll__13774 = this_sym13770__13773;
return coll__13774.cljs$core$ILookup$_lookup$arity$2(coll__13774,k);
});
var G__13795__3 = (function (this_sym13771,k,not_found){
var this__13772 = this;
var this_sym13771__13775 = this;
var coll__13776 = this_sym13771__13775;
return coll__13776.cljs$core$ILookup$_lookup$arity$3(coll__13776,k,not_found);
});
G__13795 = function(this_sym13771,k,not_found){
switch(arguments.length){
case 2:
return G__13795__2.call(this,this_sym13771,k);
case 3:
return G__13795__3.call(this,this_sym13771,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__13795;
})()
;
cljs.core.Subvec.prototype.apply = (function (this_sym13761,args13762){
var this__13777 = this;
return this_sym13761.call.apply(this_sym13761,[this_sym13761].concat(args13762.slice()));
});
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var this__13778 = this;
return (new cljs.core.Subvec(this__13778.meta,cljs.core._assoc_n.call(null,this__13778.v,this__13778.end,o),this__13778.start,(this__13778.end + 1),null));
});
cljs.core.Subvec.prototype.toString = (function (){
var this__13779 = this;
var this__13780 = this;
return cljs.core.pr_str.call(null,this__13780);
});
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var this__13781 = this;
return cljs.core.ci_reduce.call(null,coll,f);
});
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var this__13782 = this;
return cljs.core.ci_reduce.call(null,coll,f,start);
});
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__13783 = this;
var subvec_seq__13784 = (function subvec_seq(i){
if((i === this__13783.end))
{return null;
} else
{return cljs.core.cons.call(null,cljs.core._nth.call(null,this__13783.v,i),(new cljs.core.LazySeq(null,false,(function (){
return subvec_seq.call(null,(i + 1));
}),null)));
}
});
return subvec_seq__13784.call(null,this__13783.start);
});
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var this__13785 = this;
return (this__13785.end - this__13785.start);
});
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var this__13786 = this;
return cljs.core._nth.call(null,this__13786.v,(this__13786.end - 1));
});
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var this__13787 = this;
if((this__13787.start === this__13787.end))
{throw (new Error("Can't pop empty vector"));
} else
{return (new cljs.core.Subvec(this__13787.meta,this__13787.v,this__13787.start,(this__13787.end - 1),null));
}
});
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var this__13788 = this;
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,n,val);
});
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__13789 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__13790 = this;
return (new cljs.core.Subvec(meta,this__13790.v,this__13790.start,this__13790.end,this__13790.__hash));
});
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__13791 = this;
return this__13791.meta;
});
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var this__13792 = this;
return cljs.core._nth.call(null,this__13792.v,(this__13792.start + n));
});
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var this__13793 = this;
return cljs.core._nth.call(null,this__13793.v,(this__13793.start + n),not_found);
});
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__13794 = this;
return cljs.core.with_meta.call(null,cljs.core.Vector.EMPTY,this__13794.meta);
});
cljs.core.Subvec;
/**
* Returns a persistent vector of the items in vector from
* start (inclusive) to end (exclusive).  If end is not supplied,
* defaults to (count vector). This operation is O(1) and very fast, as
* the resulting vector shares structure with the original and no
* trimming is done.
*/
cljs.core.subvec = (function() {
var subvec = null;
var subvec__2 = (function (v,start){
return subvec.call(null,v,start,cljs.core.count.call(null,v));
});
var subvec__3 = (function (v,start,end){
return (new cljs.core.Subvec(null,v,start,end,null));
});
subvec = function(v,start,end){
switch(arguments.length){
case 2:
return subvec__2.call(this,v,start);
case 3:
return subvec__3.call(this,v,start,end);
}
throw('Invalid arity: ' + arguments.length);
};
subvec.cljs$lang$arity$2 = subvec__2;
subvec.cljs$lang$arity$3 = subvec__3;
return subvec;
})()
;
cljs.core.tv_ensure_editable = (function tv_ensure_editable(edit,node){
if((edit === node.edit))
{return node;
} else
{return (new cljs.core.VectorNode(edit,node.arr.slice()));
}
});
cljs.core.tv_editable_root = (function tv_editable_root(node){
return (new cljs.core.VectorNode({},node.arr.slice()));
});
cljs.core.tv_editable_tail = (function tv_editable_tail(tl){
var ret__13797 = cljs.core.make_array.call(null,32);
cljs.core.array_copy.call(null,tl,0,ret__13797,0,tl.length);
return ret__13797;
});
cljs.core.tv_push_tail = (function tv_push_tail(tv,level,parent,tail_node){
var ret__13801 = cljs.core.tv_ensure_editable.call(null,tv.root.edit,parent);
var subidx__13802 = (((tv.cnt - 1) >>> level) & 31);
cljs.core.pv_aset.call(null,ret__13801,subidx__13802,(((level === 5))?tail_node:(function (){var child__13803 = cljs.core.pv_aget.call(null,ret__13801,subidx__13802);
if(!((child__13803 == null)))
{return tv_push_tail.call(null,tv,(level - 5),child__13803,tail_node);
} else
{return cljs.core.new_path.call(null,tv.root.edit,(level - 5),tail_node);
}
})()));
return ret__13801;
});
cljs.core.tv_pop_tail = (function tv_pop_tail(tv,level,node){
var node__13808 = cljs.core.tv_ensure_editable.call(null,tv.root.edit,node);
var subidx__13809 = (((tv.cnt - 2) >>> level) & 31);
if((level > 5))
{var new_child__13810 = tv_pop_tail.call(null,tv,(level - 5),cljs.core.pv_aget.call(null,node__13808,subidx__13809));
if((function (){var and__3822__auto____13811 = (new_child__13810 == null);
if(and__3822__auto____13811)
{return (subidx__13809 === 0);
} else
{return and__3822__auto____13811;
}
})())
{return null;
} else
{cljs.core.pv_aset.call(null,node__13808,subidx__13809,new_child__13810);
return node__13808;
}
} else
{if((subidx__13809 === 0))
{return null;
} else
{if("\uFDD0'else")
{cljs.core.pv_aset.call(null,node__13808,subidx__13809,null);
return node__13808;
} else
{return null;
}
}
}
});
cljs.core.editable_array_for = (function editable_array_for(tv,i){
if((function (){var and__3822__auto____13816 = (0 <= i);
if(and__3822__auto____13816)
{return (i < tv.cnt);
} else
{return and__3822__auto____13816;
}
})())
{if((i >= cljs.core.tail_off.call(null,tv)))
{return tv.tail;
} else
{var root__13817 = tv.root;
var node__13818 = root__13817;
var level__13819 = tv.shift;
while(true){
if((level__13819 > 0))
{{
var G__13820 = cljs.core.tv_ensure_editable.call(null,root__13817.edit,cljs.core.pv_aget.call(null,node__13818,((i >>> level__13819) & 31)));
var G__13821 = (level__13819 - 5);
node__13818 = G__13820;
level__13819 = G__13821;
continue;
}
} else
{return node__13818.arr;
}
break;
}
}
} else
{throw (new Error([cljs.core.str("No item "),cljs.core.str(i),cljs.core.str(" in transient vector of length "),cljs.core.str(tv.cnt)].join('')));
}
});

/**
* @constructor
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition0$ = 275;
this.cljs$lang$protocol_mask$partition1$ = 22;
})
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/TransientVector");
});
cljs.core.TransientVector.prototype.call = (function() {
var G__13861 = null;
var G__13861__2 = (function (this_sym13824,k){
var this__13826 = this;
var this_sym13824__13827 = this;
var coll__13828 = this_sym13824__13827;
return coll__13828.cljs$core$ILookup$_lookup$arity$2(coll__13828,k);
});
var G__13861__3 = (function (this_sym13825,k,not_found){
var this__13826 = this;
var this_sym13825__13829 = this;
var coll__13830 = this_sym13825__13829;
return coll__13830.cljs$core$ILookup$_lookup$arity$3(coll__13830,k,not_found);
});
G__13861 = function(this_sym13825,k,not_found){
switch(arguments.length){
case 2:
return G__13861__2.call(this,this_sym13825,k);
case 3:
return G__13861__3.call(this,this_sym13825,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__13861;
})()
;
cljs.core.TransientVector.prototype.apply = (function (this_sym13822,args13823){
var this__13831 = this;
return this_sym13822.call.apply(this_sym13822,[this_sym13822].concat(args13823.slice()));
});
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var this__13832 = this;
return coll.cljs$core$IIndexed$_nth$arity$3(coll,k,null);
});
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var this__13833 = this;
return coll.cljs$core$IIndexed$_nth$arity$3(coll,k,not_found);
});
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var this__13834 = this;
if(this__13834.root.edit)
{return (cljs.core.array_for.call(null,coll,n)[(n & 31)]);
} else
{throw (new Error("nth after persistent!"));
}
});
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var this__13835 = this;
if((function (){var and__3822__auto____13836 = (0 <= n);
if(and__3822__auto____13836)
{return (n < this__13835.cnt);
} else
{return and__3822__auto____13836;
}
})())
{return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else
{return not_found;
}
});
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var this__13837 = this;
if(this__13837.root.edit)
{return this__13837.cnt;
} else
{throw (new Error("count after persistent!"));
}
});
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var this__13838 = this;
if(this__13838.root.edit)
{if((function (){var and__3822__auto____13839 = (0 <= n);
if(and__3822__auto____13839)
{return (n < this__13838.cnt);
} else
{return and__3822__auto____13839;
}
})())
{if((cljs.core.tail_off.call(null,tcoll) <= n))
{(this__13838.tail[(n & 31)] = val);
return tcoll;
} else
{var new_root__13844 = (function go(level,node){
var node__13842 = cljs.core.tv_ensure_editable.call(null,this__13838.root.edit,node);
if((level === 0))
{cljs.core.pv_aset.call(null,node__13842,(n & 31),val);
return node__13842;
} else
{var subidx__13843 = ((n >>> level) & 31);
cljs.core.pv_aset.call(null,node__13842,subidx__13843,go.call(null,(level - 5),cljs.core.pv_aget.call(null,node__13842,subidx__13843)));
return node__13842;
}
}).call(null,this__13838.shift,this__13838.root);
this__13838.root = new_root__13844;
return tcoll;
}
} else
{if((n === this__13838.cnt))
{return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else
{if("\uFDD0'else")
{throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds for TransientVector of length"),cljs.core.str(this__13838.cnt)].join('')));
} else
{return null;
}
}
}
} else
{throw (new Error("assoc! after persistent!"));
}
});
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var this__13845 = this;
if(this__13845.root.edit)
{if((this__13845.cnt === 0))
{throw (new Error("Can't pop empty vector"));
} else
{if((1 === this__13845.cnt))
{this__13845.cnt = 0;
return tcoll;
} else
{if((((this__13845.cnt - 1) & 31) > 0))
{this__13845.cnt = (this__13845.cnt - 1);
return tcoll;
} else
{if("\uFDD0'else")
{var new_tail__13846 = cljs.core.editable_array_for.call(null,tcoll,(this__13845.cnt - 2));
var new_root__13848 = (function (){var nr__13847 = cljs.core.tv_pop_tail.call(null,tcoll,this__13845.shift,this__13845.root);
if(!((nr__13847 == null)))
{return nr__13847;
} else
{return (new cljs.core.VectorNode(this__13845.root.edit,cljs.core.make_array.call(null,32)));
}
})();
if((function (){var and__3822__auto____13849 = (5 < this__13845.shift);
if(and__3822__auto____13849)
{return (cljs.core.pv_aget.call(null,new_root__13848,1) == null);
} else
{return and__3822__auto____13849;
}
})())
{var new_root__13850 = cljs.core.tv_ensure_editable.call(null,this__13845.root.edit,cljs.core.pv_aget.call(null,new_root__13848,0));
this__13845.root = new_root__13850;
this__13845.shift = (this__13845.shift - 5);
this__13845.cnt = (this__13845.cnt - 1);
this__13845.tail = new_tail__13846;
return tcoll;
} else
{this__13845.root = new_root__13848;
this__13845.cnt = (this__13845.cnt - 1);
this__13845.tail = new_tail__13846;
return tcoll;
}
} else
{return null;
}
}
}
}
} else
{throw (new Error("pop! after persistent!"));
}
});
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var this__13851 = this;
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,key,val);
});
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var this__13852 = this;
if(this__13852.root.edit)
{if(((this__13852.cnt - cljs.core.tail_off.call(null,tcoll)) < 32))
{(this__13852.tail[(this__13852.cnt & 31)] = o);
this__13852.cnt = (this__13852.cnt + 1);
return tcoll;
} else
{var tail_node__13853 = (new cljs.core.VectorNode(this__13852.root.edit,this__13852.tail));
var new_tail__13854 = cljs.core.make_array.call(null,32);
(new_tail__13854[0] = o);
this__13852.tail = new_tail__13854;
if(((this__13852.cnt >>> 5) > (1 << this__13852.shift)))
{var new_root_array__13855 = cljs.core.make_array.call(null,32);
var new_shift__13856 = (this__13852.shift + 5);
(new_root_array__13855[0] = this__13852.root);
(new_root_array__13855[1] = cljs.core.new_path.call(null,this__13852.root.edit,this__13852.shift,tail_node__13853));
this__13852.root = (new cljs.core.VectorNode(this__13852.root.edit,new_root_array__13855));
this__13852.shift = new_shift__13856;
this__13852.cnt = (this__13852.cnt + 1);
return tcoll;
} else
{var new_root__13857 = cljs.core.tv_push_tail.call(null,tcoll,this__13852.shift,this__13852.root,tail_node__13853);
this__13852.root = new_root__13857;
this__13852.cnt = (this__13852.cnt + 1);
return tcoll;
}
}
} else
{throw (new Error("conj! after persistent!"));
}
});
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var this__13858 = this;
if(this__13858.root.edit)
{this__13858.root.edit = null;
var len__13859 = (this__13858.cnt - cljs.core.tail_off.call(null,tcoll));
var trimmed_tail__13860 = cljs.core.make_array.call(null,len__13859);
cljs.core.array_copy.call(null,this__13858.tail,0,trimmed_tail__13860,0,len__13859);
return (new cljs.core.PersistentVector(null,this__13858.cnt,this__13858.shift,this__13858.root,trimmed_tail__13860,null));
} else
{throw (new Error("persistent! called twice"));
}
});
cljs.core.TransientVector;

/**
* @constructor
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31850572;
})
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/PersistentQueueSeq");
});
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__13862 = this;
var h__4714__auto____13863 = this__13862.__hash;
if(!((h__4714__auto____13863 == null)))
{return h__4714__auto____13863;
} else
{var h__4714__auto____13864 = cljs.core.hash_coll.call(null,coll);
this__13862.__hash = h__4714__auto____13864;
return h__4714__auto____13864;
}
});
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var this__13865 = this;
return cljs.core.cons.call(null,o,coll);
});
cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var this__13866 = this;
var this__13867 = this;
return cljs.core.pr_str.call(null,this__13867);
});
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__13868 = this;
return coll;
});
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var this__13869 = this;
return cljs.core._first.call(null,this__13869.front);
});
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var this__13870 = this;
var temp__3971__auto____13871 = cljs.core.next.call(null,this__13870.front);
if(temp__3971__auto____13871)
{var f1__13872 = temp__3971__auto____13871;
return (new cljs.core.PersistentQueueSeq(this__13870.meta,f1__13872,this__13870.rear,null));
} else
{if((this__13870.rear == null))
{return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else
{return (new cljs.core.PersistentQueueSeq(this__13870.meta,this__13870.rear,null,null));
}
}
});
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__13873 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__13874 = this;
return (new cljs.core.PersistentQueueSeq(meta,this__13874.front,this__13874.rear,this__13874.__hash));
});
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__13875 = this;
return this__13875.meta;
});
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__13876 = this;
return cljs.core.with_meta.call(null,cljs.core.List.EMPTY,this__13876.meta);
});
cljs.core.PersistentQueueSeq;

/**
* @constructor
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
})
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/PersistentQueue");
});
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__13877 = this;
var h__4714__auto____13878 = this__13877.__hash;
if(!((h__4714__auto____13878 == null)))
{return h__4714__auto____13878;
} else
{var h__4714__auto____13879 = cljs.core.hash_coll.call(null,coll);
this__13877.__hash = h__4714__auto____13879;
return h__4714__auto____13879;
}
});
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var this__13880 = this;
if(cljs.core.truth_(this__13880.front))
{return (new cljs.core.PersistentQueue(this__13880.meta,(this__13880.count + 1),this__13880.front,cljs.core.conj.call(null,(function (){var or__3824__auto____13881 = this__13880.rear;
if(cljs.core.truth_(or__3824__auto____13881))
{return or__3824__auto____13881;
} else
{return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else
{return (new cljs.core.PersistentQueue(this__13880.meta,(this__13880.count + 1),cljs.core.conj.call(null,this__13880.front,o),cljs.core.PersistentVector.EMPTY,null));
}
});
cljs.core.PersistentQueue.prototype.toString = (function (){
var this__13882 = this;
var this__13883 = this;
return cljs.core.pr_str.call(null,this__13883);
});
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__13884 = this;
var rear__13885 = cljs.core.seq.call(null,this__13884.rear);
if(cljs.core.truth_((function (){var or__3824__auto____13886 = this__13884.front;
if(cljs.core.truth_(or__3824__auto____13886))
{return or__3824__auto____13886;
} else
{return rear__13885;
}
})()))
{return (new cljs.core.PersistentQueueSeq(null,this__13884.front,cljs.core.seq.call(null,rear__13885),null));
} else
{return null;
}
});
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var this__13887 = this;
return this__13887.count;
});
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var this__13888 = this;
return cljs.core._first.call(null,this__13888.front);
});
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var this__13889 = this;
if(cljs.core.truth_(this__13889.front))
{var temp__3971__auto____13890 = cljs.core.next.call(null,this__13889.front);
if(temp__3971__auto____13890)
{var f1__13891 = temp__3971__auto____13890;
return (new cljs.core.PersistentQueue(this__13889.meta,(this__13889.count - 1),f1__13891,this__13889.rear,null));
} else
{return (new cljs.core.PersistentQueue(this__13889.meta,(this__13889.count - 1),cljs.core.seq.call(null,this__13889.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else
{return coll;
}
});
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var this__13892 = this;
return cljs.core.first.call(null,this__13892.front);
});
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var this__13893 = this;
return cljs.core.rest.call(null,cljs.core.seq.call(null,coll));
});
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__13894 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__13895 = this;
return (new cljs.core.PersistentQueue(meta,this__13895.count,this__13895.front,this__13895.rear,this__13895.__hash));
});
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__13896 = this;
return this__13896.meta;
});
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__13897 = this;
return cljs.core.PersistentQueue.EMPTY;
});
cljs.core.PersistentQueue;
cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,0,null,cljs.core.PersistentVector.EMPTY,0));

/**
* @constructor
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2097152;
})
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/NeverEquiv");
});
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var this__13898 = this;
return false;
});
cljs.core.NeverEquiv;
cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
* Assumes y is a map. Returns true if x equals y, otherwise returns
* false.
*/
cljs.core.equiv_map = (function equiv_map(x,y){
return cljs.core.boolean$.call(null,((cljs.core.map_QMARK_.call(null,y))?(((cljs.core.count.call(null,x) === cljs.core.count.call(null,y)))?cljs.core.every_QMARK_.call(null,cljs.core.identity,cljs.core.map.call(null,(function (xkv){
return cljs.core._EQ_.call(null,cljs.core._lookup.call(null,y,cljs.core.first.call(null,xkv),cljs.core.never_equiv),cljs.core.second.call(null,xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function scan_array(incr,k,array){
var len__13901 = array.length;
var i__13902 = 0;
while(true){
if((i__13902 < len__13901))
{if((k === (array[i__13902])))
{return i__13902;
} else
{{
var G__13903 = (i__13902 + incr);
i__13902 = G__13903;
continue;
}
}
} else
{return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function obj_map_compare_keys(a,b){
var a__13906 = cljs.core.hash.call(null,a);
var b__13907 = cljs.core.hash.call(null,b);
if((a__13906 < b__13907))
{return -1;
} else
{if((a__13906 > b__13907))
{return 1;
} else
{if("\uFDD0'else")
{return 0;
} else
{return null;
}
}
}
});
cljs.core.obj_map__GT_hash_map = (function obj_map__GT_hash_map(m,k,v){
var ks__13915 = m.keys;
var len__13916 = ks__13915.length;
var so__13917 = m.strobj;
var out__13918 = cljs.core.with_meta.call(null,cljs.core.PersistentHashMap.EMPTY,cljs.core.meta.call(null,m));
var i__13919 = 0;
var out__13920 = cljs.core.transient$.call(null,out__13918);
while(true){
if((i__13919 < len__13916))
{var k__13921 = (ks__13915[i__13919]);
{
var G__13922 = (i__13919 + 1);
var G__13923 = cljs.core.assoc_BANG_.call(null,out__13920,k__13921,(so__13917[k__13921]));
i__13919 = G__13922;
out__13920 = G__13923;
continue;
}
} else
{return cljs.core.persistent_BANG_.call(null,cljs.core.assoc_BANG_.call(null,out__13920,k,v));
}
break;
}
});
cljs.core.obj_clone = (function obj_clone(obj,ks){
var new_obj__13929 = {};
var l__13930 = ks.length;
var i__13931 = 0;
while(true){
if((i__13931 < l__13930))
{var k__13932 = (ks[i__13931]);
(new_obj__13929[k__13932] = (obj[k__13932]));
{
var G__13933 = (i__13931 + 1);
i__13931 = G__13933;
continue;
}
} else
{}
break;
}
return new_obj__13929;
});

/**
* @constructor
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 1;
this.cljs$lang$protocol_mask$partition0$ = 15075087;
})
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/ObjMap");
});
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var this__13936 = this;
return cljs.core.transient$.call(null,cljs.core.into.call(null,cljs.core.hash_map.call(null),coll));
});
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__13937 = this;
var h__4714__auto____13938 = this__13937.__hash;
if(!((h__4714__auto____13938 == null)))
{return h__4714__auto____13938;
} else
{var h__4714__auto____13939 = cljs.core.hash_imap.call(null,coll);
this__13937.__hash = h__4714__auto____13939;
return h__4714__auto____13939;
}
});
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var this__13940 = this;
return coll.cljs$core$ILookup$_lookup$arity$3(coll,k,null);
});
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var this__13941 = this;
if((function (){var and__3822__auto____13942 = goog.isString(k);
if(and__3822__auto____13942)
{return !((cljs.core.scan_array.call(null,1,k,this__13941.keys) == null));
} else
{return and__3822__auto____13942;
}
})())
{return (this__13941.strobj[k]);
} else
{return not_found;
}
});
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var this__13943 = this;
if(goog.isString(k))
{if((function (){var or__3824__auto____13944 = (this__13943.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD);
if(or__3824__auto____13944)
{return or__3824__auto____13944;
} else
{return (this__13943.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD);
}
})())
{return cljs.core.obj_map__GT_hash_map.call(null,coll,k,v);
} else
{if(!((cljs.core.scan_array.call(null,1,k,this__13943.keys) == null)))
{var new_strobj__13945 = cljs.core.obj_clone.call(null,this__13943.strobj,this__13943.keys);
(new_strobj__13945[k] = v);
return (new cljs.core.ObjMap(this__13943.meta,this__13943.keys,new_strobj__13945,(this__13943.update_count + 1),null));
} else
{var new_strobj__13946 = cljs.core.obj_clone.call(null,this__13943.strobj,this__13943.keys);
var new_keys__13947 = this__13943.keys.slice();
(new_strobj__13946[k] = v);
new_keys__13947.push(k);
return (new cljs.core.ObjMap(this__13943.meta,new_keys__13947,new_strobj__13946,(this__13943.update_count + 1),null));
}
}
} else
{return cljs.core.obj_map__GT_hash_map.call(null,coll,k,v);
}
});
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var this__13948 = this;
if((function (){var and__3822__auto____13949 = goog.isString(k);
if(and__3822__auto____13949)
{return !((cljs.core.scan_array.call(null,1,k,this__13948.keys) == null));
} else
{return and__3822__auto____13949;
}
})())
{return true;
} else
{return false;
}
});
cljs.core.ObjMap.prototype.call = (function() {
var G__13971 = null;
var G__13971__2 = (function (this_sym13950,k){
var this__13952 = this;
var this_sym13950__13953 = this;
var coll__13954 = this_sym13950__13953;
return coll__13954.cljs$core$ILookup$_lookup$arity$2(coll__13954,k);
});
var G__13971__3 = (function (this_sym13951,k,not_found){
var this__13952 = this;
var this_sym13951__13955 = this;
var coll__13956 = this_sym13951__13955;
return coll__13956.cljs$core$ILookup$_lookup$arity$3(coll__13956,k,not_found);
});
G__13971 = function(this_sym13951,k,not_found){
switch(arguments.length){
case 2:
return G__13971__2.call(this,this_sym13951,k);
case 3:
return G__13971__3.call(this,this_sym13951,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__13971;
})()
;
cljs.core.ObjMap.prototype.apply = (function (this_sym13934,args13935){
var this__13957 = this;
return this_sym13934.call.apply(this_sym13934,[this_sym13934].concat(args13935.slice()));
});
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var this__13958 = this;
if(cljs.core.vector_QMARK_.call(null,entry))
{return coll.cljs$core$IAssociative$_assoc$arity$3(coll,cljs.core._nth.call(null,entry,0),cljs.core._nth.call(null,entry,1));
} else
{return cljs.core.reduce.call(null,cljs.core._conj,coll,entry);
}
});
cljs.core.ObjMap.prototype.toString = (function (){
var this__13959 = this;
var this__13960 = this;
return cljs.core.pr_str.call(null,this__13960);
});
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__13961 = this;
if((this__13961.keys.length > 0))
{return cljs.core.map.call(null,(function (p1__13924_SHARP_){
return cljs.core.vector.call(null,p1__13924_SHARP_,(this__13961.strobj[p1__13924_SHARP_]));
}),this__13961.keys.sort(cljs.core.obj_map_compare_keys));
} else
{return null;
}
});
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var this__13962 = this;
return this__13962.keys.length;
});
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__13963 = this;
return cljs.core.equiv_map.call(null,coll,other);
});
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__13964 = this;
return (new cljs.core.ObjMap(meta,this__13964.keys,this__13964.strobj,this__13964.update_count,this__13964.__hash));
});
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__13965 = this;
return this__13965.meta;
});
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__13966 = this;
return cljs.core.with_meta.call(null,cljs.core.ObjMap.EMPTY,this__13966.meta);
});
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var this__13967 = this;
if((function (){var and__3822__auto____13968 = goog.isString(k);
if(and__3822__auto____13968)
{return !((cljs.core.scan_array.call(null,1,k,this__13967.keys) == null));
} else
{return and__3822__auto____13968;
}
})())
{var new_keys__13969 = this__13967.keys.slice();
var new_strobj__13970 = cljs.core.obj_clone.call(null,this__13967.strobj,this__13967.keys);
new_keys__13969.splice(cljs.core.scan_array.call(null,1,k,new_keys__13969),1);
cljs.core.js_delete.call(null,new_strobj__13970,k);
return (new cljs.core.ObjMap(this__13967.meta,new_keys__13969,new_strobj__13970,(this__13967.update_count + 1),null));
} else
{return coll;
}
});
cljs.core.ObjMap;
cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],{},0,0));
cljs.core.ObjMap.HASHMAP_THRESHOLD = 32;
cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,0,null));
});

/**
* @constructor
*/
cljs.core.HashMap = (function (meta,count,hashobj,__hash){
this.meta = meta;
this.count = count;
this.hashobj = hashobj;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 15075087;
})
cljs.core.HashMap.cljs$lang$type = true;
cljs.core.HashMap.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/HashMap");
});
cljs.core.HashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__13975 = this;
var h__4714__auto____13976 = this__13975.__hash;
if(!((h__4714__auto____13976 == null)))
{return h__4714__auto____13976;
} else
{var h__4714__auto____13977 = cljs.core.hash_imap.call(null,coll);
this__13975.__hash = h__4714__auto____13977;
return h__4714__auto____13977;
}
});
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var this__13978 = this;
return coll.cljs$core$ILookup$_lookup$arity$3(coll,k,null);
});
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var this__13979 = this;
var bucket__13980 = (this__13979.hashobj[cljs.core.hash.call(null,k)]);
var i__13981 = (cljs.core.truth_(bucket__13980)?cljs.core.scan_array.call(null,2,k,bucket__13980):null);
if(cljs.core.truth_(i__13981))
{return (bucket__13980[(i__13981 + 1)]);
} else
{return not_found;
}
});
cljs.core.HashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var this__13982 = this;
var h__13983 = cljs.core.hash.call(null,k);
var bucket__13984 = (this__13982.hashobj[h__13983]);
if(cljs.core.truth_(bucket__13984))
{var new_bucket__13985 = bucket__13984.slice();
var new_hashobj__13986 = goog.object.clone(this__13982.hashobj);
(new_hashobj__13986[h__13983] = new_bucket__13985);
var temp__3971__auto____13987 = cljs.core.scan_array.call(null,2,k,new_bucket__13985);
if(cljs.core.truth_(temp__3971__auto____13987))
{var i__13988 = temp__3971__auto____13987;
(new_bucket__13985[(i__13988 + 1)] = v);
return (new cljs.core.HashMap(this__13982.meta,this__13982.count,new_hashobj__13986,null));
} else
{new_bucket__13985.push(k,v);
return (new cljs.core.HashMap(this__13982.meta,(this__13982.count + 1),new_hashobj__13986,null));
}
} else
{var new_hashobj__13989 = goog.object.clone(this__13982.hashobj);
(new_hashobj__13989[h__13983] = [k,v]);
return (new cljs.core.HashMap(this__13982.meta,(this__13982.count + 1),new_hashobj__13989,null));
}
});
cljs.core.HashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var this__13990 = this;
var bucket__13991 = (this__13990.hashobj[cljs.core.hash.call(null,k)]);
var i__13992 = (cljs.core.truth_(bucket__13991)?cljs.core.scan_array.call(null,2,k,bucket__13991):null);
if(cljs.core.truth_(i__13992))
{return true;
} else
{return false;
}
});
cljs.core.HashMap.prototype.call = (function() {
var G__14017 = null;
var G__14017__2 = (function (this_sym13993,k){
var this__13995 = this;
var this_sym13993__13996 = this;
var coll__13997 = this_sym13993__13996;
return coll__13997.cljs$core$ILookup$_lookup$arity$2(coll__13997,k);
});
var G__14017__3 = (function (this_sym13994,k,not_found){
var this__13995 = this;
var this_sym13994__13998 = this;
var coll__13999 = this_sym13994__13998;
return coll__13999.cljs$core$ILookup$_lookup$arity$3(coll__13999,k,not_found);
});
G__14017 = function(this_sym13994,k,not_found){
switch(arguments.length){
case 2:
return G__14017__2.call(this,this_sym13994,k);
case 3:
return G__14017__3.call(this,this_sym13994,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__14017;
})()
;
cljs.core.HashMap.prototype.apply = (function (this_sym13973,args13974){
var this__14000 = this;
return this_sym13973.call.apply(this_sym13973,[this_sym13973].concat(args13974.slice()));
});
cljs.core.HashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var this__14001 = this;
if(cljs.core.vector_QMARK_.call(null,entry))
{return coll.cljs$core$IAssociative$_assoc$arity$3(coll,cljs.core._nth.call(null,entry,0),cljs.core._nth.call(null,entry,1));
} else
{return cljs.core.reduce.call(null,cljs.core._conj,coll,entry);
}
});
cljs.core.HashMap.prototype.toString = (function (){
var this__14002 = this;
var this__14003 = this;
return cljs.core.pr_str.call(null,this__14003);
});
cljs.core.HashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__14004 = this;
if((this__14004.count > 0))
{var hashes__14005 = cljs.core.js_keys.call(null,this__14004.hashobj).sort();
return cljs.core.mapcat.call(null,(function (p1__13972_SHARP_){
return cljs.core.map.call(null,cljs.core.vec,cljs.core.partition.call(null,2,(this__14004.hashobj[p1__13972_SHARP_])));
}),hashes__14005);
} else
{return null;
}
});
cljs.core.HashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var this__14006 = this;
return this__14006.count;
});
cljs.core.HashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__14007 = this;
return cljs.core.equiv_map.call(null,coll,other);
});
cljs.core.HashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__14008 = this;
return (new cljs.core.HashMap(meta,this__14008.count,this__14008.hashobj,this__14008.__hash));
});
cljs.core.HashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__14009 = this;
return this__14009.meta;
});
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__14010 = this;
return cljs.core.with_meta.call(null,cljs.core.HashMap.EMPTY,this__14010.meta);
});
cljs.core.HashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var this__14011 = this;
var h__14012 = cljs.core.hash.call(null,k);
var bucket__14013 = (this__14011.hashobj[h__14012]);
var i__14014 = (cljs.core.truth_(bucket__14013)?cljs.core.scan_array.call(null,2,k,bucket__14013):null);
if(cljs.core.not.call(null,i__14014))
{return coll;
} else
{var new_hashobj__14015 = goog.object.clone(this__14011.hashobj);
if((3 > bucket__14013.length))
{cljs.core.js_delete.call(null,new_hashobj__14015,h__14012);
} else
{var new_bucket__14016 = bucket__14013.slice();
new_bucket__14016.splice(i__14014,2);
(new_hashobj__14015[h__14012] = new_bucket__14016);
}
return (new cljs.core.HashMap(this__14011.meta,(this__14011.count - 1),new_hashobj__14015,null));
}
});
cljs.core.HashMap;
cljs.core.HashMap.EMPTY = (new cljs.core.HashMap(null,0,{},0));
cljs.core.HashMap.fromArrays = (function (ks,vs){
var len__14018 = ks.length;
var i__14019 = 0;
var out__14020 = cljs.core.HashMap.EMPTY;
while(true){
if((i__14019 < len__14018))
{{
var G__14021 = (i__14019 + 1);
var G__14022 = cljs.core.assoc.call(null,out__14020,(ks[i__14019]),(vs[i__14019]));
i__14019 = G__14021;
out__14020 = G__14022;
continue;
}
} else
{return out__14020;
}
break;
}
});
cljs.core.array_map_index_of = (function array_map_index_of(m,k){
var arr__14026 = m.arr;
var len__14027 = arr__14026.length;
var i__14028 = 0;
while(true){
if((len__14027 <= i__14028))
{return -1;
} else
{if(cljs.core._EQ_.call(null,(arr__14026[i__14028]),k))
{return i__14028;
} else
{if("\uFDD0'else")
{{
var G__14029 = (i__14028 + 2);
i__14028 = G__14029;
continue;
}
} else
{return null;
}
}
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 1;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
})
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/PersistentArrayMap");
});
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var this__14032 = this;
return (new cljs.core.TransientArrayMap({},this__14032.arr.length,this__14032.arr.slice()));
});
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__14033 = this;
var h__4714__auto____14034 = this__14033.__hash;
if(!((h__4714__auto____14034 == null)))
{return h__4714__auto____14034;
} else
{var h__4714__auto____14035 = cljs.core.hash_imap.call(null,coll);
this__14033.__hash = h__4714__auto____14035;
return h__4714__auto____14035;
}
});
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var this__14036 = this;
return coll.cljs$core$ILookup$_lookup$arity$3(coll,k,null);
});
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var this__14037 = this;
var idx__14038 = cljs.core.array_map_index_of.call(null,coll,k);
if((idx__14038 === -1))
{return not_found;
} else
{return (this__14037.arr[(idx__14038 + 1)]);
}
});
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var this__14039 = this;
var idx__14040 = cljs.core.array_map_index_of.call(null,coll,k);
if((idx__14040 === -1))
{if((this__14039.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))
{return (new cljs.core.PersistentArrayMap(this__14039.meta,(this__14039.cnt + 1),(function (){var G__14041__14042 = this__14039.arr.slice();
G__14041__14042.push(k);
G__14041__14042.push(v);
return G__14041__14042;
})(),null));
} else
{return cljs.core.persistent_BANG_.call(null,cljs.core.assoc_BANG_.call(null,cljs.core.transient$.call(null,cljs.core.into.call(null,cljs.core.PersistentHashMap.EMPTY,coll)),k,v));
}
} else
{if((v === (this__14039.arr[(idx__14040 + 1)])))
{return coll;
} else
{if("\uFDD0'else")
{return (new cljs.core.PersistentArrayMap(this__14039.meta,this__14039.cnt,(function (){var G__14043__14044 = this__14039.arr.slice();
(G__14043__14044[(idx__14040 + 1)] = v);
return G__14043__14044;
})(),null));
} else
{return null;
}
}
}
});
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var this__14045 = this;
return !((cljs.core.array_map_index_of.call(null,coll,k) === -1));
});
cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__14077 = null;
var G__14077__2 = (function (this_sym14046,k){
var this__14048 = this;
var this_sym14046__14049 = this;
var coll__14050 = this_sym14046__14049;
return coll__14050.cljs$core$ILookup$_lookup$arity$2(coll__14050,k);
});
var G__14077__3 = (function (this_sym14047,k,not_found){
var this__14048 = this;
var this_sym14047__14051 = this;
var coll__14052 = this_sym14047__14051;
return coll__14052.cljs$core$ILookup$_lookup$arity$3(coll__14052,k,not_found);
});
G__14077 = function(this_sym14047,k,not_found){
switch(arguments.length){
case 2:
return G__14077__2.call(this,this_sym14047,k);
case 3:
return G__14077__3.call(this,this_sym14047,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__14077;
})()
;
cljs.core.PersistentArrayMap.prototype.apply = (function (this_sym14030,args14031){
var this__14053 = this;
return this_sym14030.call.apply(this_sym14030,[this_sym14030].concat(args14031.slice()));
});
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var this__14054 = this;
var len__14055 = this__14054.arr.length;
var i__14056 = 0;
var init__14057 = init;
while(true){
if((i__14056 < len__14055))
{var init__14058 = f.call(null,init__14057,(this__14054.arr[i__14056]),(this__14054.arr[(i__14056 + 1)]));
if(cljs.core.reduced_QMARK_.call(null,init__14058))
{return cljs.core.deref.call(null,init__14058);
} else
{{
var G__14078 = (i__14056 + 2);
var G__14079 = init__14058;
i__14056 = G__14078;
init__14057 = G__14079;
continue;
}
}
} else
{return null;
}
break;
}
});
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var this__14059 = this;
if(cljs.core.vector_QMARK_.call(null,entry))
{return coll.cljs$core$IAssociative$_assoc$arity$3(coll,cljs.core._nth.call(null,entry,0),cljs.core._nth.call(null,entry,1));
} else
{return cljs.core.reduce.call(null,cljs.core._conj,coll,entry);
}
});
cljs.core.PersistentArrayMap.prototype.toString = (function (){
var this__14060 = this;
var this__14061 = this;
return cljs.core.pr_str.call(null,this__14061);
});
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__14062 = this;
if((this__14062.cnt > 0))
{var len__14063 = this__14062.arr.length;
var array_map_seq__14064 = (function array_map_seq(i){
return (new cljs.core.LazySeq(null,false,(function (){
if((i < len__14063))
{return cljs.core.cons.call(null,cljs.core.PersistentVector.fromArray([(this__14062.arr[i]),(this__14062.arr[(i + 1)])], true),array_map_seq.call(null,(i + 2)));
} else
{return null;
}
}),null));
});
return array_map_seq__14064.call(null,0);
} else
{return null;
}
});
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var this__14065 = this;
return this__14065.cnt;
});
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__14066 = this;
return cljs.core.equiv_map.call(null,coll,other);
});
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__14067 = this;
return (new cljs.core.PersistentArrayMap(meta,this__14067.cnt,this__14067.arr,this__14067.__hash));
});
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__14068 = this;
return this__14068.meta;
});
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__14069 = this;
return cljs.core._with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,this__14069.meta);
});
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var this__14070 = this;
var idx__14071 = cljs.core.array_map_index_of.call(null,coll,k);
if((idx__14071 >= 0))
{var len__14072 = this__14070.arr.length;
var new_len__14073 = (len__14072 - 2);
if((new_len__14073 === 0))
{return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else
{var new_arr__14074 = cljs.core.make_array.call(null,new_len__14073);
var s__14075 = 0;
var d__14076 = 0;
while(true){
if((s__14075 >= len__14072))
{return (new cljs.core.PersistentArrayMap(this__14070.meta,(this__14070.cnt - 1),new_arr__14074,null));
} else
{if(cljs.core._EQ_.call(null,k,(this__14070.arr[s__14075])))
{{
var G__14080 = (s__14075 + 2);
var G__14081 = d__14076;
s__14075 = G__14080;
d__14076 = G__14081;
continue;
}
} else
{if("\uFDD0'else")
{(new_arr__14074[d__14076] = (this__14070.arr[s__14075]));
(new_arr__14074[(d__14076 + 1)] = (this__14070.arr[(s__14075 + 1)]));
{
var G__14082 = (s__14075 + 2);
var G__14083 = (d__14076 + 2);
s__14075 = G__14082;
d__14076 = G__14083;
continue;
}
} else
{return null;
}
}
}
break;
}
}
} else
{return coll;
}
});
cljs.core.PersistentArrayMap;
cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,0,[],null));
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 16;
cljs.core.PersistentArrayMap.fromArrays = (function (ks,vs){
var len__14084 = cljs.core.count.call(null,ks);
var i__14085 = 0;
var out__14086 = cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i__14085 < len__14084))
{{
var G__14087 = (i__14085 + 1);
var G__14088 = cljs.core.assoc_BANG_.call(null,out__14086,(ks[i__14085]),(vs[i__14085]));
i__14085 = G__14087;
out__14086 = G__14088;
continue;
}
} else
{return cljs.core.persistent_BANG_.call(null,out__14086);
}
break;
}
});

/**
* @constructor
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 14;
this.cljs$lang$protocol_mask$partition0$ = 258;
})
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/TransientArrayMap");
});
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var this__14089 = this;
if(cljs.core.truth_(this__14089.editable_QMARK_))
{var idx__14090 = cljs.core.array_map_index_of.call(null,tcoll,key);
if((idx__14090 >= 0))
{(this__14089.arr[idx__14090] = (this__14089.arr[(this__14089.len - 2)]));
(this__14089.arr[(idx__14090 + 1)] = (this__14089.arr[(this__14089.len - 1)]));
var G__14091__14092 = this__14089.arr;
G__14091__14092.pop();
G__14091__14092.pop();
G__14091__14092;
this__14089.len = (this__14089.len - 2);
} else
{}
return tcoll;
} else
{throw (new Error("dissoc! after persistent!"));
}
});
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var this__14093 = this;
if(cljs.core.truth_(this__14093.editable_QMARK_))
{var idx__14094 = cljs.core.array_map_index_of.call(null,tcoll,key);
if((idx__14094 === -1))
{if(((this__14093.len + 2) <= (2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)))
{this__14093.len = (this__14093.len + 2);
this__14093.arr.push(key);
this__14093.arr.push(val);
return tcoll;
} else
{return cljs.core.assoc_BANG_.call(null,cljs.core.array__GT_transient_hash_map.call(null,this__14093.len,this__14093.arr),key,val);
}
} else
{if((val === (this__14093.arr[(idx__14094 + 1)])))
{return tcoll;
} else
{(this__14093.arr[(idx__14094 + 1)] = val);
return tcoll;
}
}
} else
{throw (new Error("assoc! after persistent!"));
}
});
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var this__14095 = this;
if(cljs.core.truth_(this__14095.editable_QMARK_))
{if((function (){var G__14096__14097 = o;
if(G__14096__14097)
{if((function (){var or__3824__auto____14098 = (G__14096__14097.cljs$lang$protocol_mask$partition0$ & 2048);
if(or__3824__auto____14098)
{return or__3824__auto____14098;
} else
{return G__14096__14097.cljs$core$IMapEntry$;
}
})())
{return true;
} else
{if((!G__14096__14097.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IMapEntry,G__14096__14097);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IMapEntry,G__14096__14097);
}
})())
{return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,cljs.core.key.call(null,o),cljs.core.val.call(null,o));
} else
{var es__14099 = cljs.core.seq.call(null,o);
var tcoll__14100 = tcoll;
while(true){
var temp__3971__auto____14101 = cljs.core.first.call(null,es__14099);
if(cljs.core.truth_(temp__3971__auto____14101))
{var e__14102 = temp__3971__auto____14101;
{
var G__14108 = cljs.core.next.call(null,es__14099);
var G__14109 = tcoll__14100.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll__14100,cljs.core.key.call(null,e__14102),cljs.core.val.call(null,e__14102));
es__14099 = G__14108;
tcoll__14100 = G__14109;
continue;
}
} else
{return tcoll__14100;
}
break;
}
}
} else
{throw (new Error("conj! after persistent!"));
}
});
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var this__14103 = this;
if(cljs.core.truth_(this__14103.editable_QMARK_))
{this__14103.editable_QMARK_ = false;
return (new cljs.core.PersistentArrayMap(null,cljs.core.quot.call(null,this__14103.len,2),this__14103.arr,null));
} else
{throw (new Error("persistent! called twice"));
}
});
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var this__14104 = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(tcoll,k,null);
});
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var this__14105 = this;
if(cljs.core.truth_(this__14105.editable_QMARK_))
{var idx__14106 = cljs.core.array_map_index_of.call(null,tcoll,k);
if((idx__14106 === -1))
{return not_found;
} else
{return (this__14105.arr[(idx__14106 + 1)]);
}
} else
{throw (new Error("lookup after persistent!"));
}
});
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var this__14107 = this;
if(cljs.core.truth_(this__14107.editable_QMARK_))
{return cljs.core.quot.call(null,this__14107.len,2);
} else
{throw (new Error("count after persistent!"));
}
});
cljs.core.TransientArrayMap;
cljs.core.array__GT_transient_hash_map = (function array__GT_transient_hash_map(len,arr){
var out__14112 = cljs.core.transient$.call(null,cljs.core.ObjMap.EMPTY);
var i__14113 = 0;
while(true){
if((i__14113 < len))
{{
var G__14114 = cljs.core.assoc_BANG_.call(null,out__14112,(arr[i__14113]),(arr[(i__14113 + 1)]));
var G__14115 = (i__14113 + 2);
out__14112 = G__14114;
i__14113 = G__14115;
continue;
}
} else
{return out__14112;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
})
cljs.core.Box.cljs$lang$type = true;
cljs.core.Box.cljs$lang$ctorPrSeq = (function (this__4832__auto__){
return cljs.core.list.call(null,"cljs.core/Box");
});
cljs.core.Box;
cljs.core.key_test = (function key_test(key,other){
if(goog.isString(key))
{return (key === other);
} else
{return cljs.core._EQ_.call(null,key,other);
}
});
cljs.core.mask = (function mask(hash,shift){
return ((hash >>> shift) & 31);
});
cljs.core.clone_and_set = (function() {
var clone_and_set = null;
var clone_and_set__3 = (function (arr,i,a){
var G__14120__14121 = arr.slice();
(G__14120__14121[i] = a);
return G__14120__14121;
});
var clone_and_set__5 = (function (arr,i,a,j,b){
var G__14122__14123 = arr.slice();
(G__14122__14123[i] = a);
(G__14122__14123[j] = b);
return G__14122__14123;
});
clone_and_set = function(arr,i,a,j,b){
switch(arguments.length){
case 3:
return clone_and_set__3.call(this,arr,i,a);
case 5:
return clone_and_set__5.call(this,arr,i,a,j,b);
}
throw('Invalid arity: ' + arguments.length);
};
clone_and_set.cljs$lang$arity$3 = clone_and_set__3;
clone_and_set.cljs$lang$arity$5 = clone_and_set__5;
return clone_and_set;
})()
;
cljs.core.remove_pair = (function remove_pair(arr,i){
var new_arr__14125 = cljs.core.make_array.call(null,(arr.length - 2));
cljs.core.array_copy.call(null,arr,0,new_arr__14125,0,(2 * i));
cljs.core.array_copy.call(null,arr,(2 * (i + 1)),new_arr__14125,(2 * i),(new_arr__14125.length - (2 * i)));
return new_arr__14125;
});
cljs.core.bitmap_indexed_node_index = (function bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count.call(null,(bitmap & (bit - 1)));
});
cljs.core.bitpos = (function bitpos(hash,shift){
return (1 << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function() {
var edit_and_set = null;
var edit_and_set__4 = (function (inode,edit,i,a){
var editable__14128 = inode.ensure_editable(edit);
(editable__14128.arr[i] = a);
return editable__14128;
});
var edit_and_set__6 = (function (inode,edit,i,a,j,b){
var editable__14129 = inode.ensure_editable(edit);
(editable__14129.arr[i] = a);
(editable__14129.arr[j] = b);
return editable__14129;
});
edit_and_set = function(inode,edit,i,a,j,b){
switch(arguments.length){
case 4:
return edit_and_set__4.call(this,inode,edit,i,a);
case 6:
return edit_and_set__6.call(this,inode,edit,i,a,j,b);
}
throw('Invalid arity: ' + arguments.length);
};
edit_and_set.cljs$lang$arity$4 = edit_and_set__4;
edit_and_set.cljs$lang$arity$6 = edit_and_set__6;
return edit_and_set;
})()
;
cljs.core.inode_kv_reduce = (function inode_kv_reduce(arr,f,init){
var len__14136 = arr.length;
var i__14137 = 0;
var init__14138 = init;
while(true){
if((i__14137 < len__14136))
{var init__14141 = (function (){var k__14139 = (arr[i__14137]);
if(!((k__14139 == null)))
{return f.call(null,init__14138,k__14139,(arr[(i__14137 + 1)]));
} else
{var node__14140 = (arr[(i__14137 + 1)]);
if(!((node__14140 == null)))
{return node__14140.kv_reduce(f,init__14138);
} else
{return init__14138;
}
}
})();
if(cljs.core.reduced_QMARK_.call(null,init__14141))
{return cljs.core.deref.call(null,init__14141);
} else
{{
var G__14142 = (i__14137 + 2);
var G__14143 = init__14141;
i__14137 = G__14142;
init__14138 = G__14143;
continue;
}
}
} else
{return init__14138;
}
break;
}
});

/**
* @constructor
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
})
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/BitmapIndexedNode");
});
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var this__14144 = this;
var inode__14145 = this;
if((this__14144.bitmap === bit))
{return null;
} else
{var editable__14146 = inode__14145.ensure_editable(e);
var earr__14147 = editable__14146.arr;
var len__14148 = earr__14147.length;
editable__14146.bitmap = (bit ^ editable__14146.bitmap);
cljs.core.array_copy.call(null,earr__14147,(2 * (i + 1)),earr__14147,(2 * i),(len__14148 - (2 * (i + 1))));
(earr__14147[(len__14148 - 2)] = null);
(earr__14147[(len__14148 - 1)] = null);
return editable__14146;
}
});
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit,shift,hash,key,val,added_leaf_QMARK_){
var this__14149 = this;
var inode__14150 = this;
var bit__14151 = (1 << ((hash >>> shift) & 0x01f));
var idx__14152 = cljs.core.bitmap_indexed_node_index.call(null,this__14149.bitmap,bit__14151);
if(((this__14149.bitmap & bit__14151) === 0))
{var n__14153 = cljs.core.bit_count.call(null,this__14149.bitmap);
if(((2 * n__14153) < this__14149.arr.length))
{var editable__14154 = inode__14150.ensure_editable(edit);
var earr__14155 = editable__14154.arr;
added_leaf_QMARK_.val = true;
cljs.core.array_copy_downward.call(null,earr__14155,(2 * idx__14152),earr__14155,(2 * (idx__14152 + 1)),(2 * (n__14153 - idx__14152)));
(earr__14155[(2 * idx__14152)] = key);
(earr__14155[((2 * idx__14152) + 1)] = val);
editable__14154.bitmap = (editable__14154.bitmap | bit__14151);
return editable__14154;
} else
{if((n__14153 >= 16))
{var nodes__14156 = cljs.core.make_array.call(null,32);
var jdx__14157 = ((hash >>> shift) & 0x01f);
(nodes__14156[jdx__14157] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,(shift + 5),hash,key,val,added_leaf_QMARK_));
var i__14158 = 0;
var j__14159 = 0;
while(true){
if((i__14158 < 32))
{if((((this__14149.bitmap >>> i__14158) & 1) === 0))
{{
var G__14212 = (i__14158 + 1);
var G__14213 = j__14159;
i__14158 = G__14212;
j__14159 = G__14213;
continue;
}
} else
{(nodes__14156[i__14158] = ((!(((this__14149.arr[j__14159]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,(shift + 5),cljs.core.hash.call(null,(this__14149.arr[j__14159])),(this__14149.arr[j__14159]),(this__14149.arr[(j__14159 + 1)]),added_leaf_QMARK_):(this__14149.arr[(j__14159 + 1)])));
{
var G__14214 = (i__14158 + 1);
var G__14215 = (j__14159 + 2);
i__14158 = G__14214;
j__14159 = G__14215;
continue;
}
}
} else
{}
break;
}
return (new cljs.core.ArrayNode(edit,(n__14153 + 1),nodes__14156));
} else
{if("\uFDD0'else")
{var new_arr__14160 = cljs.core.make_array.call(null,(2 * (n__14153 + 4)));
cljs.core.array_copy.call(null,this__14149.arr,0,new_arr__14160,0,(2 * idx__14152));
(new_arr__14160[(2 * idx__14152)] = key);
(new_arr__14160[((2 * idx__14152) + 1)] = val);
cljs.core.array_copy.call(null,this__14149.arr,(2 * idx__14152),new_arr__14160,(2 * (idx__14152 + 1)),(2 * (n__14153 - idx__14152)));
added_leaf_QMARK_.val = true;
var editable__14161 = inode__14150.ensure_editable(edit);
editable__14161.arr = new_arr__14160;
editable__14161.bitmap = (editable__14161.bitmap | bit__14151);
return editable__14161;
} else
{return null;
}
}
}
} else
{var key_or_nil__14162 = (this__14149.arr[(2 * idx__14152)]);
var val_or_node__14163 = (this__14149.arr[((2 * idx__14152) + 1)]);
if((key_or_nil__14162 == null))
{var n__14164 = val_or_node__14163.inode_assoc_BANG_(edit,(shift + 5),hash,key,val,added_leaf_QMARK_);
if((n__14164 === val_or_node__14163))
{return inode__14150;
} else
{return cljs.core.edit_and_set.call(null,inode__14150,edit,((2 * idx__14152) + 1),n__14164);
}
} else
{if(cljs.core.key_test.call(null,key,key_or_nil__14162))
{if((val === val_or_node__14163))
{return inode__14150;
} else
{return cljs.core.edit_and_set.call(null,inode__14150,edit,((2 * idx__14152) + 1),val);
}
} else
{if("\uFDD0'else")
{added_leaf_QMARK_.val = true;
return cljs.core.edit_and_set.call(null,inode__14150,edit,(2 * idx__14152),null,((2 * idx__14152) + 1),cljs.core.create_node.call(null,edit,(shift + 5),key_or_nil__14162,val_or_node__14163,hash,key,val));
} else
{return null;
}
}
}
}
});
cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var this__14165 = this;
var inode__14166 = this;
return cljs.core.create_inode_seq.call(null,this__14165.arr);
});
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit,shift,hash,key,removed_leaf_QMARK_){
var this__14167 = this;
var inode__14168 = this;
var bit__14169 = (1 << ((hash >>> shift) & 0x01f));
if(((this__14167.bitmap & bit__14169) === 0))
{return inode__14168;
} else
{var idx__14170 = cljs.core.bitmap_indexed_node_index.call(null,this__14167.bitmap,bit__14169);
var key_or_nil__14171 = (this__14167.arr[(2 * idx__14170)]);
var val_or_node__14172 = (this__14167.arr[((2 * idx__14170) + 1)]);
if((key_or_nil__14171 == null))
{var n__14173 = val_or_node__14172.inode_without_BANG_(edit,(shift + 5),hash,key,removed_leaf_QMARK_);
if((n__14173 === val_or_node__14172))
{return inode__14168;
} else
{if(!((n__14173 == null)))
{return cljs.core.edit_and_set.call(null,inode__14168,edit,((2 * idx__14170) + 1),n__14173);
} else
{if((this__14167.bitmap === bit__14169))
{return null;
} else
{if("\uFDD0'else")
{return inode__14168.edit_and_remove_pair(edit,bit__14169,idx__14170);
} else
{return null;
}
}
}
}
} else
{if(cljs.core.key_test.call(null,key,key_or_nil__14171))
{(removed_leaf_QMARK_[0] = true);
return inode__14168.edit_and_remove_pair(edit,bit__14169,idx__14170);
} else
{if("\uFDD0'else")
{return inode__14168;
} else
{return null;
}
}
}
}
});
cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var this__14174 = this;
var inode__14175 = this;
if((e === this__14174.edit))
{return inode__14175;
} else
{var n__14176 = cljs.core.bit_count.call(null,this__14174.bitmap);
var new_arr__14177 = cljs.core.make_array.call(null,(((n__14176 < 0))?4:(2 * (n__14176 + 1))));
cljs.core.array_copy.call(null,this__14174.arr,0,new_arr__14177,0,(2 * n__14176));
return (new cljs.core.BitmapIndexedNode(e,this__14174.bitmap,new_arr__14177));
}
});
cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var this__14178 = this;
var inode__14179 = this;
return cljs.core.inode_kv_reduce.call(null,this__14178.arr,f,init);
});
cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var this__14180 = this;
var inode__14181 = this;
var bit__14182 = (1 << ((hash >>> shift) & 0x01f));
if(((this__14180.bitmap & bit__14182) === 0))
{return not_found;
} else
{var idx__14183 = cljs.core.bitmap_indexed_node_index.call(null,this__14180.bitmap,bit__14182);
var key_or_nil__14184 = (this__14180.arr[(2 * idx__14183)]);
var val_or_node__14185 = (this__14180.arr[((2 * idx__14183) + 1)]);
if((key_or_nil__14184 == null))
{return val_or_node__14185.inode_find((shift + 5),hash,key,not_found);
} else
{if(cljs.core.key_test.call(null,key,key_or_nil__14184))
{return cljs.core.PersistentVector.fromArray([key_or_nil__14184,val_or_node__14185], true);
} else
{if("\uFDD0'else")
{return not_found;
} else
{return null;
}
}
}
}
});
cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var this__14186 = this;
var inode__14187 = this;
var bit__14188 = (1 << ((hash >>> shift) & 0x01f));
if(((this__14186.bitmap & bit__14188) === 0))
{return inode__14187;
} else
{var idx__14189 = cljs.core.bitmap_indexed_node_index.call(null,this__14186.bitmap,bit__14188);
var key_or_nil__14190 = (this__14186.arr[(2 * idx__14189)]);
var val_or_node__14191 = (this__14186.arr[((2 * idx__14189) + 1)]);
if((key_or_nil__14190 == null))
{var n__14192 = val_or_node__14191.inode_without((shift + 5),hash,key);
if((n__14192 === val_or_node__14191))
{return inode__14187;
} else
{if(!((n__14192 == null)))
{return (new cljs.core.BitmapIndexedNode(null,this__14186.bitmap,cljs.core.clone_and_set.call(null,this__14186.arr,((2 * idx__14189) + 1),n__14192)));
} else
{if((this__14186.bitmap === bit__14188))
{return null;
} else
{if("\uFDD0'else")
{return (new cljs.core.BitmapIndexedNode(null,(this__14186.bitmap ^ bit__14188),cljs.core.remove_pair.call(null,this__14186.arr,idx__14189)));
} else
{return null;
}
}
}
}
} else
{if(cljs.core.key_test.call(null,key,key_or_nil__14190))
{return (new cljs.core.BitmapIndexedNode(null,(this__14186.bitmap ^ bit__14188),cljs.core.remove_pair.call(null,this__14186.arr,idx__14189)));
} else
{if("\uFDD0'else")
{return inode__14187;
} else
{return null;
}
}
}
}
});
cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var this__14193 = this;
var inode__14194 = this;
var bit__14195 = (1 << ((hash >>> shift) & 0x01f));
var idx__14196 = cljs.core.bitmap_indexed_node_index.call(null,this__14193.bitmap,bit__14195);
if(((this__14193.bitmap & bit__14195) === 0))
{var n__14197 = cljs.core.bit_count.call(null,this__14193.bitmap);
if((n__14197 >= 16))
{var nodes__14198 = cljs.core.make_array.call(null,32);
var jdx__14199 = ((hash >>> shift) & 0x01f);
(nodes__14198[jdx__14199] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + 5),hash,key,val,added_leaf_QMARK_));
var i__14200 = 0;
var j__14201 = 0;
while(true){
if((i__14200 < 32))
{if((((this__14193.bitmap >>> i__14200) & 1) === 0))
{{
var G__14216 = (i__14200 + 1);
var G__14217 = j__14201;
i__14200 = G__14216;
j__14201 = G__14217;
continue;
}
} else
{(nodes__14198[i__14200] = ((!(((this__14193.arr[j__14201]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + 5),cljs.core.hash.call(null,(this__14193.arr[j__14201])),(this__14193.arr[j__14201]),(this__14193.arr[(j__14201 + 1)]),added_leaf_QMARK_):(this__14193.arr[(j__14201 + 1)])));
{
var G__14218 = (i__14200 + 1);
var G__14219 = (j__14201 + 2);
i__14200 = G__14218;
j__14201 = G__14219;
continue;
}
}
} else
{}
break;
}
return (new cljs.core.ArrayNode(null,(n__14197 + 1),nodes__14198));
} else
{var new_arr__14202 = cljs.core.make_array.call(null,(2 * (n__14197 + 1)));
cljs.core.array_copy.call(null,this__14193.arr,0,new_arr__14202,0,(2 * idx__14196));
(new_arr__14202[(2 * idx__14196)] = key);
(new_arr__14202[((2 * idx__14196) + 1)] = val);
cljs.core.array_copy.call(null,this__14193.arr,(2 * idx__14196),new_arr__14202,(2 * (idx__14196 + 1)),(2 * (n__14197 - idx__14196)));
added_leaf_QMARK_.val = true;
return (new cljs.core.BitmapIndexedNode(null,(this__14193.bitmap | bit__14195),new_arr__14202));
}
} else
{var key_or_nil__14203 = (this__14193.arr[(2 * idx__14196)]);
var val_or_node__14204 = (this__14193.arr[((2 * idx__14196) + 1)]);
if((key_or_nil__14203 == null))
{var n__14205 = val_or_node__14204.inode_assoc((shift + 5),hash,key,val,added_leaf_QMARK_);
if((n__14205 === val_or_node__14204))
{return inode__14194;
} else
{return (new cljs.core.BitmapIndexedNode(null,this__14193.bitmap,cljs.core.clone_and_set.call(null,this__14193.arr,((2 * idx__14196) + 1),n__14205)));
}
} else
{if(cljs.core.key_test.call(null,key,key_or_nil__14203))
{if((val === val_or_node__14204))
{return inode__14194;
} else
{return (new cljs.core.BitmapIndexedNode(null,this__14193.bitmap,cljs.core.clone_and_set.call(null,this__14193.arr,((2 * idx__14196) + 1),val)));
}
} else
{if("\uFDD0'else")
{added_leaf_QMARK_.val = true;
return (new cljs.core.BitmapIndexedNode(null,this__14193.bitmap,cljs.core.clone_and_set.call(null,this__14193.arr,(2 * idx__14196),null,((2 * idx__14196) + 1),cljs.core.create_node.call(null,(shift + 5),key_or_nil__14203,val_or_node__14204,hash,key,val))));
} else
{return null;
}
}
}
}
});
cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var this__14206 = this;
var inode__14207 = this;
var bit__14208 = (1 << ((hash >>> shift) & 0x01f));
if(((this__14206.bitmap & bit__14208) === 0))
{return not_found;
} else
{var idx__14209 = cljs.core.bitmap_indexed_node_index.call(null,this__14206.bitmap,bit__14208);
var key_or_nil__14210 = (this__14206.arr[(2 * idx__14209)]);
var val_or_node__14211 = (this__14206.arr[((2 * idx__14209) + 1)]);
if((key_or_nil__14210 == null))
{return val_or_node__14211.inode_lookup((shift + 5),hash,key,not_found);
} else
{if(cljs.core.key_test.call(null,key,key_or_nil__14210))
{return val_or_node__14211;
} else
{if("\uFDD0'else")
{return not_found;
} else
{return null;
}
}
}
}
});
cljs.core.BitmapIndexedNode;
cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,0,cljs.core.make_array.call(null,0)));
cljs.core.pack_array_node = (function pack_array_node(array_node,edit,idx){
var arr__14227 = array_node.arr;
var len__14228 = (2 * (array_node.cnt - 1));
var new_arr__14229 = cljs.core.make_array.call(null,len__14228);
var i__14230 = 0;
var j__14231 = 1;
var bitmap__14232 = 0;
while(true){
if((i__14230 < len__14228))
{if((function (){var and__3822__auto____14233 = !((i__14230 === idx));
if(and__3822__auto____14233)
{return !(((arr__14227[i__14230]) == null));
} else
{return and__3822__auto____14233;
}
})())
{(new_arr__14229[j__14231] = (arr__14227[i__14230]));
{
var G__14234 = (i__14230 + 1);
var G__14235 = (j__14231 + 2);
var G__14236 = (bitmap__14232 | (1 << i__14230));
i__14230 = G__14234;
j__14231 = G__14235;
bitmap__14232 = G__14236;
continue;
}
} else
{{
var G__14237 = (i__14230 + 1);
var G__14238 = j__14231;
var G__14239 = bitmap__14232;
i__14230 = G__14237;
j__14231 = G__14238;
bitmap__14232 = G__14239;
continue;
}
}
} else
{return (new cljs.core.BitmapIndexedNode(edit,bitmap__14232,new_arr__14229));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/ArrayNode");
});
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit,shift,hash,key,val,added_leaf_QMARK_){
var this__14240 = this;
var inode__14241 = this;
var idx__14242 = ((hash >>> shift) & 0x01f);
var node__14243 = (this__14240.arr[idx__14242]);
if((node__14243 == null))
{var editable__14244 = cljs.core.edit_and_set.call(null,inode__14241,edit,idx__14242,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,(shift + 5),hash,key,val,added_leaf_QMARK_));
editable__14244.cnt = (editable__14244.cnt + 1);
return editable__14244;
} else
{var n__14245 = node__14243.inode_assoc_BANG_(edit,(shift + 5),hash,key,val,added_leaf_QMARK_);
if((n__14245 === node__14243))
{return inode__14241;
} else
{return cljs.core.edit_and_set.call(null,inode__14241,edit,idx__14242,n__14245);
}
}
});
cljs.core.ArrayNode.prototype.inode_seq = (function (){
var this__14246 = this;
var inode__14247 = this;
return cljs.core.create_array_node_seq.call(null,this__14246.arr);
});
cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit,shift,hash,key,removed_leaf_QMARK_){
var this__14248 = this;
var inode__14249 = this;
var idx__14250 = ((hash >>> shift) & 0x01f);
var node__14251 = (this__14248.arr[idx__14250]);
if((node__14251 == null))
{return inode__14249;
} else
{var n__14252 = node__14251.inode_without_BANG_(edit,(shift + 5),hash,key,removed_leaf_QMARK_);
if((n__14252 === node__14251))
{return inode__14249;
} else
{if((n__14252 == null))
{if((this__14248.cnt <= 8))
{return cljs.core.pack_array_node.call(null,inode__14249,edit,idx__14250);
} else
{var editable__14253 = cljs.core.edit_and_set.call(null,inode__14249,edit,idx__14250,n__14252);
editable__14253.cnt = (editable__14253.cnt - 1);
return editable__14253;
}
} else
{if("\uFDD0'else")
{return cljs.core.edit_and_set.call(null,inode__14249,edit,idx__14250,n__14252);
} else
{return null;
}
}
}
}
});
cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var this__14254 = this;
var inode__14255 = this;
if((e === this__14254.edit))
{return inode__14255;
} else
{return (new cljs.core.ArrayNode(e,this__14254.cnt,this__14254.arr.slice()));
}
});
cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var this__14256 = this;
var inode__14257 = this;
var len__14258 = this__14256.arr.length;
var i__14259 = 0;
var init__14260 = init;
while(true){
if((i__14259 < len__14258))
{var node__14261 = (this__14256.arr[i__14259]);
if(!((node__14261 == null)))
{var init__14262 = node__14261.kv_reduce(f,init__14260);
if(cljs.core.reduced_QMARK_.call(null,init__14262))
{return cljs.core.deref.call(null,init__14262);
} else
{{
var G__14281 = (i__14259 + 1);
var G__14282 = init__14262;
i__14259 = G__14281;
init__14260 = G__14282;
continue;
}
}
} else
{return null;
}
} else
{return init__14260;
}
break;
}
});
cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var this__14263 = this;
var inode__14264 = this;
var idx__14265 = ((hash >>> shift) & 0x01f);
var node__14266 = (this__14263.arr[idx__14265]);
if(!((node__14266 == null)))
{return node__14266.inode_find((shift + 5),hash,key,not_found);
} else
{return not_found;
}
});
cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var this__14267 = this;
var inode__14268 = this;
var idx__14269 = ((hash >>> shift) & 0x01f);
var node__14270 = (this__14267.arr[idx__14269]);
if(!((node__14270 == null)))
{var n__14271 = node__14270.inode_without((shift + 5),hash,key);
if((n__14271 === node__14270))
{return inode__14268;
} else
{if((n__14271 == null))
{if((this__14267.cnt <= 8))
{return cljs.core.pack_array_node.call(null,inode__14268,null,idx__14269);
} else
{return (new cljs.core.ArrayNode(null,(this__14267.cnt - 1),cljs.core.clone_and_set.call(null,this__14267.arr,idx__14269,n__14271)));
}
} else
{if("\uFDD0'else")
{return (new cljs.core.ArrayNode(null,this__14267.cnt,cljs.core.clone_and_set.call(null,this__14267.arr,idx__14269,n__14271)));
} else
{return null;
}
}
}
} else
{return inode__14268;
}
});
cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var this__14272 = this;
var inode__14273 = this;
var idx__14274 = ((hash >>> shift) & 0x01f);
var node__14275 = (this__14272.arr[idx__14274]);
if((node__14275 == null))
{return (new cljs.core.ArrayNode(null,(this__14272.cnt + 1),cljs.core.clone_and_set.call(null,this__14272.arr,idx__14274,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + 5),hash,key,val,added_leaf_QMARK_))));
} else
{var n__14276 = node__14275.inode_assoc((shift + 5),hash,key,val,added_leaf_QMARK_);
if((n__14276 === node__14275))
{return inode__14273;
} else
{return (new cljs.core.ArrayNode(null,this__14272.cnt,cljs.core.clone_and_set.call(null,this__14272.arr,idx__14274,n__14276)));
}
}
});
cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var this__14277 = this;
var inode__14278 = this;
var idx__14279 = ((hash >>> shift) & 0x01f);
var node__14280 = (this__14277.arr[idx__14279]);
if(!((node__14280 == null)))
{return node__14280.inode_lookup((shift + 5),hash,key,not_found);
} else
{return not_found;
}
});
cljs.core.ArrayNode;
cljs.core.hash_collision_node_find_index = (function hash_collision_node_find_index(arr,cnt,key){
var lim__14285 = (2 * cnt);
var i__14286 = 0;
while(true){
if((i__14286 < lim__14285))
{if(cljs.core.key_test.call(null,key,(arr[i__14286])))
{return i__14286;
} else
{{
var G__14287 = (i__14286 + 2);
i__14286 = G__14287;
continue;
}
}
} else
{return -1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/HashCollisionNode");
});
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit,shift,hash,key,val,added_leaf_QMARK_){
var this__14288 = this;
var inode__14289 = this;
if((hash === this__14288.collision_hash))
{var idx__14290 = cljs.core.hash_collision_node_find_index.call(null,this__14288.arr,this__14288.cnt,key);
if((idx__14290 === -1))
{if((this__14288.arr.length > (2 * this__14288.cnt)))
{var editable__14291 = cljs.core.edit_and_set.call(null,inode__14289,edit,(2 * this__14288.cnt),key,((2 * this__14288.cnt) + 1),val);
added_leaf_QMARK_.val = true;
editable__14291.cnt = (editable__14291.cnt + 1);
return editable__14291;
} else
{var len__14292 = this__14288.arr.length;
var new_arr__14293 = cljs.core.make_array.call(null,(len__14292 + 2));
cljs.core.array_copy.call(null,this__14288.arr,0,new_arr__14293,0,len__14292);
(new_arr__14293[len__14292] = key);
(new_arr__14293[(len__14292 + 1)] = val);
added_leaf_QMARK_.val = true;
return inode__14289.ensure_editable_array(edit,(this__14288.cnt + 1),new_arr__14293);
}
} else
{if(((this__14288.arr[(idx__14290 + 1)]) === val))
{return inode__14289;
} else
{return cljs.core.edit_and_set.call(null,inode__14289,edit,(idx__14290 + 1),val);
}
}
} else
{return (new cljs.core.BitmapIndexedNode(edit,(1 << ((this__14288.collision_hash >>> shift) & 0x01f)),[null,inode__14289,null,null])).inode_assoc_BANG_(edit,shift,hash,key,val,added_leaf_QMARK_);
}
});
cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var this__14294 = this;
var inode__14295 = this;
return cljs.core.create_inode_seq.call(null,this__14294.arr);
});
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit,shift,hash,key,removed_leaf_QMARK_){
var this__14296 = this;
var inode__14297 = this;
var idx__14298 = cljs.core.hash_collision_node_find_index.call(null,this__14296.arr,this__14296.cnt,key);
if((idx__14298 === -1))
{return inode__14297;
} else
{(removed_leaf_QMARK_[0] = true);
if((this__14296.cnt === 1))
{return null;
} else
{var editable__14299 = inode__14297.ensure_editable(edit);
var earr__14300 = editable__14299.arr;
(earr__14300[idx__14298] = (earr__14300[((2 * this__14296.cnt) - 2)]));
(earr__14300[(idx__14298 + 1)] = (earr__14300[((2 * this__14296.cnt) - 1)]));
(earr__14300[((2 * this__14296.cnt) - 1)] = null);
(earr__14300[((2 * this__14296.cnt) - 2)] = null);
editable__14299.cnt = (editable__14299.cnt - 1);
return editable__14299;
}
}
});
cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var this__14301 = this;
var inode__14302 = this;
if((e === this__14301.edit))
{return inode__14302;
} else
{var new_arr__14303 = cljs.core.make_array.call(null,(2 * (this__14301.cnt + 1)));
cljs.core.array_copy.call(null,this__14301.arr,0,new_arr__14303,0,(2 * this__14301.cnt));
return (new cljs.core.HashCollisionNode(e,this__14301.collision_hash,this__14301.cnt,new_arr__14303));
}
});
cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var this__14304 = this;
var inode__14305 = this;
return cljs.core.inode_kv_reduce.call(null,this__14304.arr,f,init);
});
cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var this__14306 = this;
var inode__14307 = this;
var idx__14308 = cljs.core.hash_collision_node_find_index.call(null,this__14306.arr,this__14306.cnt,key);
if((idx__14308 < 0))
{return not_found;
} else
{if(cljs.core.key_test.call(null,key,(this__14306.arr[idx__14308])))
{return cljs.core.PersistentVector.fromArray([(this__14306.arr[idx__14308]),(this__14306.arr[(idx__14308 + 1)])], true);
} else
{if("\uFDD0'else")
{return not_found;
} else
{return null;
}
}
}
});
cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var this__14309 = this;
var inode__14310 = this;
var idx__14311 = cljs.core.hash_collision_node_find_index.call(null,this__14309.arr,this__14309.cnt,key);
if((idx__14311 === -1))
{return inode__14310;
} else
{if((this__14309.cnt === 1))
{return null;
} else
{if("\uFDD0'else")
{return (new cljs.core.HashCollisionNode(null,this__14309.collision_hash,(this__14309.cnt - 1),cljs.core.remove_pair.call(null,this__14309.arr,cljs.core.quot.call(null,idx__14311,2))));
} else
{return null;
}
}
}
});
cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var this__14312 = this;
var inode__14313 = this;
if((hash === this__14312.collision_hash))
{var idx__14314 = cljs.core.hash_collision_node_find_index.call(null,this__14312.arr,this__14312.cnt,key);
if((idx__14314 === -1))
{var len__14315 = this__14312.arr.length;
var new_arr__14316 = cljs.core.make_array.call(null,(len__14315 + 2));
cljs.core.array_copy.call(null,this__14312.arr,0,new_arr__14316,0,len__14315);
(new_arr__14316[len__14315] = key);
(new_arr__14316[(len__14315 + 1)] = val);
added_leaf_QMARK_.val = true;
return (new cljs.core.HashCollisionNode(null,this__14312.collision_hash,(this__14312.cnt + 1),new_arr__14316));
} else
{if(cljs.core._EQ_.call(null,(this__14312.arr[idx__14314]),val))
{return inode__14313;
} else
{return (new cljs.core.HashCollisionNode(null,this__14312.collision_hash,this__14312.cnt,cljs.core.clone_and_set.call(null,this__14312.arr,(idx__14314 + 1),val)));
}
}
} else
{return (new cljs.core.BitmapIndexedNode(null,(1 << ((this__14312.collision_hash >>> shift) & 0x01f)),[null,inode__14313])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
});
cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var this__14317 = this;
var inode__14318 = this;
var idx__14319 = cljs.core.hash_collision_node_find_index.call(null,this__14317.arr,this__14317.cnt,key);
if((idx__14319 < 0))
{return not_found;
} else
{if(cljs.core.key_test.call(null,key,(this__14317.arr[idx__14319])))
{return (this__14317.arr[(idx__14319 + 1)]);
} else
{if("\uFDD0'else")
{return not_found;
} else
{return null;
}
}
}
});
cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var this__14320 = this;
var inode__14321 = this;
if((e === this__14320.edit))
{this__14320.arr = array;
this__14320.cnt = count;
return inode__14321;
} else
{return (new cljs.core.HashCollisionNode(this__14320.edit,this__14320.collision_hash,count,array));
}
});
cljs.core.HashCollisionNode;
cljs.core.create_node = (function() {
var create_node = null;
var create_node__6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash__14326 = cljs.core.hash.call(null,key1);
if((key1hash__14326 === key2hash))
{return (new cljs.core.HashCollisionNode(null,key1hash__14326,2,[key1,val1,key2,val2]));
} else
{var added_leaf_QMARK___14327 = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash__14326,key1,val1,added_leaf_QMARK___14327).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK___14327);
}
});
var create_node__7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash__14328 = cljs.core.hash.call(null,key1);
if((key1hash__14328 === key2hash))
{return (new cljs.core.HashCollisionNode(null,key1hash__14328,2,[key1,val1,key2,val2]));
} else
{var added_leaf_QMARK___14329 = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash__14328,key1,val1,added_leaf_QMARK___14329).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK___14329);
}
});
create_node = function(edit,shift,key1,val1,key2hash,key2,val2){
switch(arguments.length){
case 6:
return create_node__6.call(this,edit,shift,key1,val1,key2hash,key2);
case 7:
return create_node__7.call(this,edit,shift,key1,val1,key2hash,key2,val2);
}
throw('Invalid arity: ' + arguments.length);
};
create_node.cljs$lang$arity$6 = create_node__6;
create_node.cljs$lang$arity$7 = create_node__7;
return create_node;
})()
;

/**
* @constructor
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31850572;
})
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/NodeSeq");
});
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__14330 = this;
var h__4714__auto____14331 = this__14330.__hash;
if(!((h__4714__auto____14331 == null)))
{return h__4714__auto____14331;
} else
{var h__4714__auto____14332 = cljs.core.hash_coll.call(null,coll);
this__14330.__hash = h__4714__auto____14332;
return h__4714__auto____14332;
}
});
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var this__14333 = this;
return cljs.core.cons.call(null,o,coll);
});
cljs.core.NodeSeq.prototype.toString = (function (){
var this__14334 = this;
var this__14335 = this;
return cljs.core.pr_str.call(null,this__14335);
});
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var this__14336 = this;
return this$;
});
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var this__14337 = this;
if((this__14337.s == null))
{return cljs.core.PersistentVector.fromArray([(this__14337.nodes[this__14337.i]),(this__14337.nodes[(this__14337.i + 1)])], true);
} else
{return cljs.core.first.call(null,this__14337.s);
}
});
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var this__14338 = this;
if((this__14338.s == null))
{return cljs.core.create_inode_seq.call(null,this__14338.nodes,(this__14338.i + 2),null);
} else
{return cljs.core.create_inode_seq.call(null,this__14338.nodes,this__14338.i,cljs.core.next.call(null,this__14338.s));
}
});
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__14339 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__14340 = this;
return (new cljs.core.NodeSeq(meta,this__14340.nodes,this__14340.i,this__14340.s,this__14340.__hash));
});
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__14341 = this;
return this__14341.meta;
});
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__14342 = this;
return cljs.core.with_meta.call(null,cljs.core.List.EMPTY,this__14342.meta);
});
cljs.core.NodeSeq;
cljs.core.create_inode_seq = (function() {
var create_inode_seq = null;
var create_inode_seq__1 = (function (nodes){
return create_inode_seq.call(null,nodes,0,null);
});
var create_inode_seq__3 = (function (nodes,i,s){
if((s == null))
{var len__14349 = nodes.length;
var j__14350 = i;
while(true){
if((j__14350 < len__14349))
{if(!(((nodes[j__14350]) == null)))
{return (new cljs.core.NodeSeq(null,nodes,j__14350,null,null));
} else
{var temp__3971__auto____14351 = (nodes[(j__14350 + 1)]);
if(cljs.core.truth_(temp__3971__auto____14351))
{var node__14352 = temp__3971__auto____14351;
var temp__3971__auto____14353 = node__14352.inode_seq();
if(cljs.core.truth_(temp__3971__auto____14353))
{var node_seq__14354 = temp__3971__auto____14353;
return (new cljs.core.NodeSeq(null,nodes,(j__14350 + 2),node_seq__14354,null));
} else
{{
var G__14355 = (j__14350 + 2);
j__14350 = G__14355;
continue;
}
}
} else
{{
var G__14356 = (j__14350 + 2);
j__14350 = G__14356;
continue;
}
}
}
} else
{return null;
}
break;
}
} else
{return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
});
create_inode_seq = function(nodes,i,s){
switch(arguments.length){
case 1:
return create_inode_seq__1.call(this,nodes);
case 3:
return create_inode_seq__3.call(this,nodes,i,s);
}
throw('Invalid arity: ' + arguments.length);
};
create_inode_seq.cljs$lang$arity$1 = create_inode_seq__1;
create_inode_seq.cljs$lang$arity$3 = create_inode_seq__3;
return create_inode_seq;
})()
;

/**
* @constructor
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31850572;
})
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/ArrayNodeSeq");
});
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__14357 = this;
var h__4714__auto____14358 = this__14357.__hash;
if(!((h__4714__auto____14358 == null)))
{return h__4714__auto____14358;
} else
{var h__4714__auto____14359 = cljs.core.hash_coll.call(null,coll);
this__14357.__hash = h__4714__auto____14359;
return h__4714__auto____14359;
}
});
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var this__14360 = this;
return cljs.core.cons.call(null,o,coll);
});
cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var this__14361 = this;
var this__14362 = this;
return cljs.core.pr_str.call(null,this__14362);
});
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var this__14363 = this;
return this$;
});
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var this__14364 = this;
return cljs.core.first.call(null,this__14364.s);
});
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var this__14365 = this;
return cljs.core.create_array_node_seq.call(null,null,this__14365.nodes,this__14365.i,cljs.core.next.call(null,this__14365.s));
});
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__14366 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__14367 = this;
return (new cljs.core.ArrayNodeSeq(meta,this__14367.nodes,this__14367.i,this__14367.s,this__14367.__hash));
});
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__14368 = this;
return this__14368.meta;
});
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__14369 = this;
return cljs.core.with_meta.call(null,cljs.core.List.EMPTY,this__14369.meta);
});
cljs.core.ArrayNodeSeq;
cljs.core.create_array_node_seq = (function() {
var create_array_node_seq = null;
var create_array_node_seq__1 = (function (nodes){
return create_array_node_seq.call(null,null,nodes,0,null);
});
var create_array_node_seq__4 = (function (meta,nodes,i,s){
if((s == null))
{var len__14376 = nodes.length;
var j__14377 = i;
while(true){
if((j__14377 < len__14376))
{var temp__3971__auto____14378 = (nodes[j__14377]);
if(cljs.core.truth_(temp__3971__auto____14378))
{var nj__14379 = temp__3971__auto____14378;
var temp__3971__auto____14380 = nj__14379.inode_seq();
if(cljs.core.truth_(temp__3971__auto____14380))
{var ns__14381 = temp__3971__auto____14380;
return (new cljs.core.ArrayNodeSeq(meta,nodes,(j__14377 + 1),ns__14381,null));
} else
{{
var G__14382 = (j__14377 + 1);
j__14377 = G__14382;
continue;
}
}
} else
{{
var G__14383 = (j__14377 + 1);
j__14377 = G__14383;
continue;
}
}
} else
{return null;
}
break;
}
} else
{return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,null));
}
});
create_array_node_seq = function(meta,nodes,i,s){
switch(arguments.length){
case 1:
return create_array_node_seq__1.call(this,meta);
case 4:
return create_array_node_seq__4.call(this,meta,nodes,i,s);
}
throw('Invalid arity: ' + arguments.length);
};
create_array_node_seq.cljs$lang$arity$1 = create_array_node_seq__1;
create_array_node_seq.cljs$lang$arity$4 = create_array_node_seq__4;
return create_array_node_seq;
})()
;

/**
* @constructor
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 1;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
})
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/PersistentHashMap");
});
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var this__14386 = this;
return (new cljs.core.TransientHashMap({},this__14386.root,this__14386.cnt,this__14386.has_nil_QMARK_,this__14386.nil_val));
});
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__14387 = this;
var h__4714__auto____14388 = this__14387.__hash;
if(!((h__4714__auto____14388 == null)))
{return h__4714__auto____14388;
} else
{var h__4714__auto____14389 = cljs.core.hash_imap.call(null,coll);
this__14387.__hash = h__4714__auto____14389;
return h__4714__auto____14389;
}
});
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var this__14390 = this;
return coll.cljs$core$ILookup$_lookup$arity$3(coll,k,null);
});
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var this__14391 = this;
if((k == null))
{if(this__14391.has_nil_QMARK_)
{return this__14391.nil_val;
} else
{return not_found;
}
} else
{if((this__14391.root == null))
{return not_found;
} else
{if("\uFDD0'else")
{return this__14391.root.inode_lookup(0,cljs.core.hash.call(null,k),k,not_found);
} else
{return null;
}
}
}
});
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var this__14392 = this;
if((k == null))
{if((function (){var and__3822__auto____14393 = this__14392.has_nil_QMARK_;
if(and__3822__auto____14393)
{return (v === this__14392.nil_val);
} else
{return and__3822__auto____14393;
}
})())
{return coll;
} else
{return (new cljs.core.PersistentHashMap(this__14392.meta,((this__14392.has_nil_QMARK_)?this__14392.cnt:(this__14392.cnt + 1)),this__14392.root,true,v,null));
}
} else
{var added_leaf_QMARK___14394 = (new cljs.core.Box(false));
var new_root__14395 = (((this__14392.root == null))?cljs.core.BitmapIndexedNode.EMPTY:this__14392.root).inode_assoc(0,cljs.core.hash.call(null,k),k,v,added_leaf_QMARK___14394);
if((new_root__14395 === this__14392.root))
{return coll;
} else
{return (new cljs.core.PersistentHashMap(this__14392.meta,((added_leaf_QMARK___14394.val)?(this__14392.cnt + 1):this__14392.cnt),new_root__14395,this__14392.has_nil_QMARK_,this__14392.nil_val,null));
}
}
});
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var this__14396 = this;
if((k == null))
{return this__14396.has_nil_QMARK_;
} else
{if((this__14396.root == null))
{return false;
} else
{if("\uFDD0'else")
{return !((this__14396.root.inode_lookup(0,cljs.core.hash.call(null,k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel));
} else
{return null;
}
}
}
});
cljs.core.PersistentHashMap.prototype.call = (function() {
var G__14419 = null;
var G__14419__2 = (function (this_sym14397,k){
var this__14399 = this;
var this_sym14397__14400 = this;
var coll__14401 = this_sym14397__14400;
return coll__14401.cljs$core$ILookup$_lookup$arity$2(coll__14401,k);
});
var G__14419__3 = (function (this_sym14398,k,not_found){
var this__14399 = this;
var this_sym14398__14402 = this;
var coll__14403 = this_sym14398__14402;
return coll__14403.cljs$core$ILookup$_lookup$arity$3(coll__14403,k,not_found);
});
G__14419 = function(this_sym14398,k,not_found){
switch(arguments.length){
case 2:
return G__14419__2.call(this,this_sym14398,k);
case 3:
return G__14419__3.call(this,this_sym14398,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__14419;
})()
;
cljs.core.PersistentHashMap.prototype.apply = (function (this_sym14384,args14385){
var this__14404 = this;
return this_sym14384.call.apply(this_sym14384,[this_sym14384].concat(args14385.slice()));
});
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var this__14405 = this;
var init__14406 = ((this__14405.has_nil_QMARK_)?f.call(null,init,null,this__14405.nil_val):init);
if(cljs.core.reduced_QMARK_.call(null,init__14406))
{return cljs.core.deref.call(null,init__14406);
} else
{if(!((this__14405.root == null)))
{return this__14405.root.kv_reduce(f,init__14406);
} else
{if("\uFDD0'else")
{return init__14406;
} else
{return null;
}
}
}
});
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var this__14407 = this;
if(cljs.core.vector_QMARK_.call(null,entry))
{return coll.cljs$core$IAssociative$_assoc$arity$3(coll,cljs.core._nth.call(null,entry,0),cljs.core._nth.call(null,entry,1));
} else
{return cljs.core.reduce.call(null,cljs.core._conj,coll,entry);
}
});
cljs.core.PersistentHashMap.prototype.toString = (function (){
var this__14408 = this;
var this__14409 = this;
return cljs.core.pr_str.call(null,this__14409);
});
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__14410 = this;
if((this__14410.cnt > 0))
{var s__14411 = ((!((this__14410.root == null)))?this__14410.root.inode_seq():null);
if(this__14410.has_nil_QMARK_)
{return cljs.core.cons.call(null,cljs.core.PersistentVector.fromArray([null,this__14410.nil_val], true),s__14411);
} else
{return s__14411;
}
} else
{return null;
}
});
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var this__14412 = this;
return this__14412.cnt;
});
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__14413 = this;
return cljs.core.equiv_map.call(null,coll,other);
});
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__14414 = this;
return (new cljs.core.PersistentHashMap(meta,this__14414.cnt,this__14414.root,this__14414.has_nil_QMARK_,this__14414.nil_val,this__14414.__hash));
});
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__14415 = this;
return this__14415.meta;
});
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__14416 = this;
return cljs.core._with_meta.call(null,cljs.core.PersistentHashMap.EMPTY,this__14416.meta);
});
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var this__14417 = this;
if((k == null))
{if(this__14417.has_nil_QMARK_)
{return (new cljs.core.PersistentHashMap(this__14417.meta,(this__14417.cnt - 1),this__14417.root,false,null,null));
} else
{return coll;
}
} else
{if((this__14417.root == null))
{return coll;
} else
{if("\uFDD0'else")
{var new_root__14418 = this__14417.root.inode_without(0,cljs.core.hash.call(null,k),k);
if((new_root__14418 === this__14417.root))
{return coll;
} else
{return (new cljs.core.PersistentHashMap(this__14417.meta,(this__14417.cnt - 1),new_root__14418,this__14417.has_nil_QMARK_,this__14417.nil_val,null));
}
} else
{return null;
}
}
}
});
cljs.core.PersistentHashMap;
cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,0,null,false,null,0));
cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len__14420 = ks.length;
var i__14421 = 0;
var out__14422 = cljs.core.transient$.call(null,cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i__14421 < len__14420))
{{
var G__14423 = (i__14421 + 1);
var G__14424 = cljs.core.assoc_BANG_.call(null,out__14422,(ks[i__14421]),(vs[i__14421]));
i__14421 = G__14423;
out__14422 = G__14424;
continue;
}
} else
{return cljs.core.persistent_BANG_.call(null,out__14422);
}
break;
}
});

/**
* @constructor
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition1$ = 14;
this.cljs$lang$protocol_mask$partition0$ = 258;
})
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/TransientHashMap");
});
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var this__14425 = this;
return tcoll.without_BANG_(key);
});
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var this__14426 = this;
return tcoll.assoc_BANG_(key,val);
});
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var this__14427 = this;
return tcoll.conj_BANG_(val);
});
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var this__14428 = this;
return tcoll.persistent_BANG_();
});
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var this__14429 = this;
if((k == null))
{if(this__14429.has_nil_QMARK_)
{return this__14429.nil_val;
} else
{return null;
}
} else
{if((this__14429.root == null))
{return null;
} else
{return this__14429.root.inode_lookup(0,cljs.core.hash.call(null,k),k);
}
}
});
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var this__14430 = this;
if((k == null))
{if(this__14430.has_nil_QMARK_)
{return this__14430.nil_val;
} else
{return not_found;
}
} else
{if((this__14430.root == null))
{return not_found;
} else
{return this__14430.root.inode_lookup(0,cljs.core.hash.call(null,k),k,not_found);
}
}
});
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var this__14431 = this;
if(this__14431.edit)
{return this__14431.count;
} else
{throw (new Error("count after persistent!"));
}
});
cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var this__14432 = this;
var tcoll__14433 = this;
if(this__14432.edit)
{if((function (){var G__14434__14435 = o;
if(G__14434__14435)
{if((function (){var or__3824__auto____14436 = (G__14434__14435.cljs$lang$protocol_mask$partition0$ & 2048);
if(or__3824__auto____14436)
{return or__3824__auto____14436;
} else
{return G__14434__14435.cljs$core$IMapEntry$;
}
})())
{return true;
} else
{if((!G__14434__14435.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IMapEntry,G__14434__14435);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IMapEntry,G__14434__14435);
}
})())
{return tcoll__14433.assoc_BANG_(cljs.core.key.call(null,o),cljs.core.val.call(null,o));
} else
{var es__14437 = cljs.core.seq.call(null,o);
var tcoll__14438 = tcoll__14433;
while(true){
var temp__3971__auto____14439 = cljs.core.first.call(null,es__14437);
if(cljs.core.truth_(temp__3971__auto____14439))
{var e__14440 = temp__3971__auto____14439;
{
var G__14451 = cljs.core.next.call(null,es__14437);
var G__14452 = tcoll__14438.assoc_BANG_(cljs.core.key.call(null,e__14440),cljs.core.val.call(null,e__14440));
es__14437 = G__14451;
tcoll__14438 = G__14452;
continue;
}
} else
{return tcoll__14438;
}
break;
}
}
} else
{throw (new Error("conj! after persistent"));
}
});
cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var this__14441 = this;
var tcoll__14442 = this;
if(this__14441.edit)
{if((k == null))
{if((this__14441.nil_val === v))
{} else
{this__14441.nil_val = v;
}
if(this__14441.has_nil_QMARK_)
{} else
{this__14441.count = (this__14441.count + 1);
this__14441.has_nil_QMARK_ = true;
}
return tcoll__14442;
} else
{var added_leaf_QMARK___14443 = (new cljs.core.Box(false));
var node__14444 = (((this__14441.root == null))?cljs.core.BitmapIndexedNode.EMPTY:this__14441.root).inode_assoc_BANG_(this__14441.edit,0,cljs.core.hash.call(null,k),k,v,added_leaf_QMARK___14443);
if((node__14444 === this__14441.root))
{} else
{this__14441.root = node__14444;
}
if(added_leaf_QMARK___14443.val)
{this__14441.count = (this__14441.count + 1);
} else
{}
return tcoll__14442;
}
} else
{throw (new Error("assoc! after persistent!"));
}
});
cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var this__14445 = this;
var tcoll__14446 = this;
if(this__14445.edit)
{if((k == null))
{if(this__14445.has_nil_QMARK_)
{this__14445.has_nil_QMARK_ = false;
this__14445.nil_val = null;
this__14445.count = (this__14445.count - 1);
return tcoll__14446;
} else
{return tcoll__14446;
}
} else
{if((this__14445.root == null))
{return tcoll__14446;
} else
{var removed_leaf_QMARK___14447 = (new cljs.core.Box(false));
var node__14448 = this__14445.root.inode_without_BANG_(this__14445.edit,0,cljs.core.hash.call(null,k),k,removed_leaf_QMARK___14447);
if((node__14448 === this__14445.root))
{} else
{this__14445.root = node__14448;
}
if(cljs.core.truth_((removed_leaf_QMARK___14447[0])))
{this__14445.count = (this__14445.count - 1);
} else
{}
return tcoll__14446;
}
}
} else
{throw (new Error("dissoc! after persistent!"));
}
});
cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var this__14449 = this;
var tcoll__14450 = this;
if(this__14449.edit)
{this__14449.edit = null;
return (new cljs.core.PersistentHashMap(null,this__14449.count,this__14449.root,this__14449.has_nil_QMARK_,this__14449.nil_val,null));
} else
{throw (new Error("persistent! called twice"));
}
});
cljs.core.TransientHashMap;
cljs.core.tree_map_seq_push = (function tree_map_seq_push(node,stack,ascending_QMARK_){
var t__14455 = node;
var stack__14456 = stack;
while(true){
if(!((t__14455 == null)))
{{
var G__14457 = ((ascending_QMARK_)?t__14455.left:t__14455.right);
var G__14458 = cljs.core.conj.call(null,stack__14456,t__14455);
t__14455 = G__14457;
stack__14456 = G__14458;
continue;
}
} else
{return stack__14456;
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31850570;
})
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/PersistentTreeMapSeq");
});
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__14459 = this;
var h__4714__auto____14460 = this__14459.__hash;
if(!((h__4714__auto____14460 == null)))
{return h__4714__auto____14460;
} else
{var h__4714__auto____14461 = cljs.core.hash_coll.call(null,coll);
this__14459.__hash = h__4714__auto____14461;
return h__4714__auto____14461;
}
});
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var this__14462 = this;
return cljs.core.cons.call(null,o,coll);
});
cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var this__14463 = this;
var this__14464 = this;
return cljs.core.pr_str.call(null,this__14464);
});
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var this__14465 = this;
return this$;
});
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var this__14466 = this;
if((this__14466.cnt < 0))
{return (cljs.core.count.call(null,cljs.core.next.call(null,coll)) + 1);
} else
{return this__14466.cnt;
}
});
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var this__14467 = this;
return cljs.core.peek.call(null,this__14467.stack);
});
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var this__14468 = this;
var t__14469 = cljs.core.first.call(null,this__14468.stack);
var next_stack__14470 = cljs.core.tree_map_seq_push.call(null,((this__14468.ascending_QMARK_)?t__14469.right:t__14469.left),cljs.core.next.call(null,this__14468.stack),this__14468.ascending_QMARK_);
if(!((next_stack__14470 == null)))
{return (new cljs.core.PersistentTreeMapSeq(null,next_stack__14470,this__14468.ascending_QMARK_,(this__14468.cnt - 1),null));
} else
{return cljs.core.List.EMPTY;
}
});
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__14471 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__14472 = this;
return (new cljs.core.PersistentTreeMapSeq(meta,this__14472.stack,this__14472.ascending_QMARK_,this__14472.cnt,this__14472.__hash));
});
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__14473 = this;
return this__14473.meta;
});
cljs.core.PersistentTreeMapSeq;
cljs.core.create_tree_map_seq = (function create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push.call(null,tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});
cljs.core.balance_left = (function balance_left(key,val,ins,right){
if(cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,ins))
{if(cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,ins.left))
{return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else
{if(cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,ins.right))
{return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else
{if("\uFDD0'else")
{return (new cljs.core.BlackNode(key,val,ins,right,null));
} else
{return null;
}
}
}
} else
{return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function balance_right(key,val,left,ins){
if(cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,ins))
{if(cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,ins.right))
{return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else
{if(cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,ins.left))
{return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else
{if("\uFDD0'else")
{return (new cljs.core.BlackNode(key,val,left,ins,null));
} else
{return null;
}
}
}
} else
{return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function balance_left_del(key,val,del,right){
if(cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,del))
{return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else
{if(cljs.core.instance_QMARK_.call(null,cljs.core.BlackNode,right))
{return cljs.core.balance_right.call(null,key,val,del,right.redden());
} else
{if((function (){var and__3822__auto____14475 = cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,right);
if(and__3822__auto____14475)
{return cljs.core.instance_QMARK_.call(null,cljs.core.BlackNode,right.left);
} else
{return and__3822__auto____14475;
}
})())
{return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right.call(null,right.key,right.val,right.left.right,right.right.redden()),null));
} else
{if("\uFDD0'else")
{throw (new Error("red-black tree invariant violation"));
} else
{return null;
}
}
}
}
});
cljs.core.balance_right_del = (function balance_right_del(key,val,left,del){
if(cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,del))
{return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else
{if(cljs.core.instance_QMARK_.call(null,cljs.core.BlackNode,left))
{return cljs.core.balance_left.call(null,key,val,left.redden(),del);
} else
{if((function (){var and__3822__auto____14477 = cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,left);
if(and__3822__auto____14477)
{return cljs.core.instance_QMARK_.call(null,cljs.core.BlackNode,left.right);
} else
{return and__3822__auto____14477;
}
})())
{return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left.call(null,left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else
{if("\uFDD0'else")
{throw (new Error("red-black tree invariant violation"));
} else
{return null;
}
}
}
}
});
cljs.core.tree_map_kv_reduce = (function tree_map_kv_reduce(node,f,init){
var init__14481 = f.call(null,init,node.key,node.val);
if(cljs.core.reduced_QMARK_.call(null,init__14481))
{return cljs.core.deref.call(null,init__14481);
} else
{var init__14482 = ((!((node.left == null)))?tree_map_kv_reduce.call(null,node.left,f,init__14481):init__14481);
if(cljs.core.reduced_QMARK_.call(null,init__14482))
{return cljs.core.deref.call(null,init__14482);
} else
{var init__14483 = ((!((node.right == null)))?tree_map_kv_reduce.call(null,node.right,f,init__14482):init__14482);
if(cljs.core.reduced_QMARK_.call(null,init__14483))
{return cljs.core.deref.call(null,init__14483);
} else
{return init__14483;
}
}
}
});

/**
* @constructor
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
})
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/BlackNode");
});
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__14486 = this;
var h__4714__auto____14487 = this__14486.__hash;
if(!((h__4714__auto____14487 == null)))
{return h__4714__auto____14487;
} else
{var h__4714__auto____14488 = cljs.core.hash_coll.call(null,coll);
this__14486.__hash = h__4714__auto____14488;
return h__4714__auto____14488;
}
});
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var this__14489 = this;
return node.cljs$core$IIndexed$_nth$arity$3(node,k,null);
});
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var this__14490 = this;
return node.cljs$core$IIndexed$_nth$arity$3(node,k,not_found);
});
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var this__14491 = this;
return cljs.core.assoc.call(null,cljs.core.PersistentVector.fromArray([this__14491.key,this__14491.val], true),k,v);
});
cljs.core.BlackNode.prototype.call = (function() {
var G__14539 = null;
var G__14539__2 = (function (this_sym14492,k){
var this__14494 = this;
var this_sym14492__14495 = this;
var node__14496 = this_sym14492__14495;
return node__14496.cljs$core$ILookup$_lookup$arity$2(node__14496,k);
});
var G__14539__3 = (function (this_sym14493,k,not_found){
var this__14494 = this;
var this_sym14493__14497 = this;
var node__14498 = this_sym14493__14497;
return node__14498.cljs$core$ILookup$_lookup$arity$3(node__14498,k,not_found);
});
G__14539 = function(this_sym14493,k,not_found){
switch(arguments.length){
case 2:
return G__14539__2.call(this,this_sym14493,k);
case 3:
return G__14539__3.call(this,this_sym14493,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__14539;
})()
;
cljs.core.BlackNode.prototype.apply = (function (this_sym14484,args14485){
var this__14499 = this;
return this_sym14484.call.apply(this_sym14484,[this_sym14484].concat(args14485.slice()));
});
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var this__14500 = this;
return cljs.core.PersistentVector.fromArray([this__14500.key,this__14500.val,o], true);
});
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var this__14501 = this;
return this__14501.key;
});
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var this__14502 = this;
return this__14502.val;
});
cljs.core.BlackNode.prototype.add_right = (function (ins){
var this__14503 = this;
var node__14504 = this;
return ins.balance_right(node__14504);
});
cljs.core.BlackNode.prototype.redden = (function (){
var this__14505 = this;
var node__14506 = this;
return (new cljs.core.RedNode(this__14505.key,this__14505.val,this__14505.left,this__14505.right,null));
});
cljs.core.BlackNode.prototype.remove_right = (function (del){
var this__14507 = this;
var node__14508 = this;
return cljs.core.balance_right_del.call(null,this__14507.key,this__14507.val,this__14507.left,del);
});
cljs.core.BlackNode.prototype.replace = (function (key,val,left,right){
var this__14509 = this;
var node__14510 = this;
return (new cljs.core.BlackNode(key,val,left,right,null));
});
cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var this__14511 = this;
var node__14512 = this;
return cljs.core.tree_map_kv_reduce.call(null,node__14512,f,init);
});
cljs.core.BlackNode.prototype.remove_left = (function (del){
var this__14513 = this;
var node__14514 = this;
return cljs.core.balance_left_del.call(null,this__14513.key,this__14513.val,del,this__14513.right);
});
cljs.core.BlackNode.prototype.add_left = (function (ins){
var this__14515 = this;
var node__14516 = this;
return ins.balance_left(node__14516);
});
cljs.core.BlackNode.prototype.balance_left = (function (parent){
var this__14517 = this;
var node__14518 = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node__14518,parent.right,null));
});
cljs.core.BlackNode.prototype.toString = (function() {
var G__14540 = null;
var G__14540__0 = (function (){
var this__14519 = this;
var this__14521 = this;
return cljs.core.pr_str.call(null,this__14521);
});
G__14540 = function(){
switch(arguments.length){
case 0:
return G__14540__0.call(this);
}
throw('Invalid arity: ' + arguments.length);
};
return G__14540;
})()
;
cljs.core.BlackNode.prototype.balance_right = (function (parent){
var this__14522 = this;
var node__14523 = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node__14523,null));
});
cljs.core.BlackNode.prototype.blacken = (function (){
var this__14524 = this;
var node__14525 = this;
return node__14525;
});
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var this__14526 = this;
return cljs.core.ci_reduce.call(null,node,f);
});
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var this__14527 = this;
return cljs.core.ci_reduce.call(null,node,f,start);
});
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var this__14528 = this;
return cljs.core.list.call(null,this__14528.key,this__14528.val);
});
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var this__14529 = this;
return 2;
});
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var this__14530 = this;
return this__14530.val;
});
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var this__14531 = this;
return cljs.core.PersistentVector.fromArray([this__14531.key], true);
});
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var this__14532 = this;
return cljs.core._assoc_n.call(null,cljs.core.PersistentVector.fromArray([this__14532.key,this__14532.val], true),n,v);
});
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__14533 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var this__14534 = this;
return cljs.core.with_meta.call(null,cljs.core.PersistentVector.fromArray([this__14534.key,this__14534.val], true),meta);
});
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var this__14535 = this;
return null;
});
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var this__14536 = this;
if((n === 0))
{return this__14536.key;
} else
{if((n === 1))
{return this__14536.val;
} else
{if("\uFDD0'else")
{return null;
} else
{return null;
}
}
}
});
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var this__14537 = this;
if((n === 0))
{return this__14537.key;
} else
{if((n === 1))
{return this__14537.val;
} else
{if("\uFDD0'else")
{return not_found;
} else
{return null;
}
}
}
});
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var this__14538 = this;
return cljs.core.PersistentVector.EMPTY;
});
cljs.core.BlackNode;

/**
* @constructor
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
})
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/RedNode");
});
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__14543 = this;
var h__4714__auto____14544 = this__14543.__hash;
if(!((h__4714__auto____14544 == null)))
{return h__4714__auto____14544;
} else
{var h__4714__auto____14545 = cljs.core.hash_coll.call(null,coll);
this__14543.__hash = h__4714__auto____14545;
return h__4714__auto____14545;
}
});
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var this__14546 = this;
return node.cljs$core$IIndexed$_nth$arity$3(node,k,null);
});
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var this__14547 = this;
return node.cljs$core$IIndexed$_nth$arity$3(node,k,not_found);
});
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var this__14548 = this;
return cljs.core.assoc.call(null,cljs.core.PersistentVector.fromArray([this__14548.key,this__14548.val], true),k,v);
});
cljs.core.RedNode.prototype.call = (function() {
var G__14596 = null;
var G__14596__2 = (function (this_sym14549,k){
var this__14551 = this;
var this_sym14549__14552 = this;
var node__14553 = this_sym14549__14552;
return node__14553.cljs$core$ILookup$_lookup$arity$2(node__14553,k);
});
var G__14596__3 = (function (this_sym14550,k,not_found){
var this__14551 = this;
var this_sym14550__14554 = this;
var node__14555 = this_sym14550__14554;
return node__14555.cljs$core$ILookup$_lookup$arity$3(node__14555,k,not_found);
});
G__14596 = function(this_sym14550,k,not_found){
switch(arguments.length){
case 2:
return G__14596__2.call(this,this_sym14550,k);
case 3:
return G__14596__3.call(this,this_sym14550,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__14596;
})()
;
cljs.core.RedNode.prototype.apply = (function (this_sym14541,args14542){
var this__14556 = this;
return this_sym14541.call.apply(this_sym14541,[this_sym14541].concat(args14542.slice()));
});
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var this__14557 = this;
return cljs.core.PersistentVector.fromArray([this__14557.key,this__14557.val,o], true);
});
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var this__14558 = this;
return this__14558.key;
});
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var this__14559 = this;
return this__14559.val;
});
cljs.core.RedNode.prototype.add_right = (function (ins){
var this__14560 = this;
var node__14561 = this;
return (new cljs.core.RedNode(this__14560.key,this__14560.val,this__14560.left,ins,null));
});
cljs.core.RedNode.prototype.redden = (function (){
var this__14562 = this;
var node__14563 = this;
throw (new Error("red-black tree invariant violation"));
});
cljs.core.RedNode.prototype.remove_right = (function (del){
var this__14564 = this;
var node__14565 = this;
return (new cljs.core.RedNode(this__14564.key,this__14564.val,this__14564.left,del,null));
});
cljs.core.RedNode.prototype.replace = (function (key,val,left,right){
var this__14566 = this;
var node__14567 = this;
return (new cljs.core.RedNode(key,val,left,right,null));
});
cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var this__14568 = this;
var node__14569 = this;
return cljs.core.tree_map_kv_reduce.call(null,node__14569,f,init);
});
cljs.core.RedNode.prototype.remove_left = (function (del){
var this__14570 = this;
var node__14571 = this;
return (new cljs.core.RedNode(this__14570.key,this__14570.val,del,this__14570.right,null));
});
cljs.core.RedNode.prototype.add_left = (function (ins){
var this__14572 = this;
var node__14573 = this;
return (new cljs.core.RedNode(this__14572.key,this__14572.val,ins,this__14572.right,null));
});
cljs.core.RedNode.prototype.balance_left = (function (parent){
var this__14574 = this;
var node__14575 = this;
if(cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,this__14574.left))
{return (new cljs.core.RedNode(this__14574.key,this__14574.val,this__14574.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,this__14574.right,parent.right,null)),null));
} else
{if(cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,this__14574.right))
{return (new cljs.core.RedNode(this__14574.right.key,this__14574.right.val,(new cljs.core.BlackNode(this__14574.key,this__14574.val,this__14574.left,this__14574.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,this__14574.right.right,parent.right,null)),null));
} else
{if("\uFDD0'else")
{return (new cljs.core.BlackNode(parent.key,parent.val,node__14575,parent.right,null));
} else
{return null;
}
}
}
});
cljs.core.RedNode.prototype.toString = (function() {
var G__14597 = null;
var G__14597__0 = (function (){
var this__14576 = this;
var this__14578 = this;
return cljs.core.pr_str.call(null,this__14578);
});
G__14597 = function(){
switch(arguments.length){
case 0:
return G__14597__0.call(this);
}
throw('Invalid arity: ' + arguments.length);
};
return G__14597;
})()
;
cljs.core.RedNode.prototype.balance_right = (function (parent){
var this__14579 = this;
var node__14580 = this;
if(cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,this__14579.right))
{return (new cljs.core.RedNode(this__14579.key,this__14579.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,this__14579.left,null)),this__14579.right.blacken(),null));
} else
{if(cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,this__14579.left))
{return (new cljs.core.RedNode(this__14579.left.key,this__14579.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,this__14579.left.left,null)),(new cljs.core.BlackNode(this__14579.key,this__14579.val,this__14579.left.right,this__14579.right,null)),null));
} else
{if("\uFDD0'else")
{return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node__14580,null));
} else
{return null;
}
}
}
});
cljs.core.RedNode.prototype.blacken = (function (){
var this__14581 = this;
var node__14582 = this;
return (new cljs.core.BlackNode(this__14581.key,this__14581.val,this__14581.left,this__14581.right,null));
});
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var this__14583 = this;
return cljs.core.ci_reduce.call(null,node,f);
});
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var this__14584 = this;
return cljs.core.ci_reduce.call(null,node,f,start);
});
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var this__14585 = this;
return cljs.core.list.call(null,this__14585.key,this__14585.val);
});
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var this__14586 = this;
return 2;
});
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var this__14587 = this;
return this__14587.val;
});
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var this__14588 = this;
return cljs.core.PersistentVector.fromArray([this__14588.key], true);
});
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var this__14589 = this;
return cljs.core._assoc_n.call(null,cljs.core.PersistentVector.fromArray([this__14589.key,this__14589.val], true),n,v);
});
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__14590 = this;
return cljs.core.equiv_sequential.call(null,coll,other);
});
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var this__14591 = this;
return cljs.core.with_meta.call(null,cljs.core.PersistentVector.fromArray([this__14591.key,this__14591.val], true),meta);
});
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var this__14592 = this;
return null;
});
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var this__14593 = this;
if((n === 0))
{return this__14593.key;
} else
{if((n === 1))
{return this__14593.val;
} else
{if("\uFDD0'else")
{return null;
} else
{return null;
}
}
}
});
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var this__14594 = this;
if((n === 0))
{return this__14594.key;
} else
{if((n === 1))
{return this__14594.val;
} else
{if("\uFDD0'else")
{return not_found;
} else
{return null;
}
}
}
});
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var this__14595 = this;
return cljs.core.PersistentVector.EMPTY;
});
cljs.core.RedNode;
cljs.core.tree_map_add = (function tree_map_add(comp,tree,k,v,found){
if((tree == null))
{return (new cljs.core.RedNode(k,v,null,null,null));
} else
{var c__14601 = comp.call(null,k,tree.key);
if((c__14601 === 0))
{(found[0] = tree);
return null;
} else
{if((c__14601 < 0))
{var ins__14602 = tree_map_add.call(null,comp,tree.left,k,v,found);
if(!((ins__14602 == null)))
{return tree.add_left(ins__14602);
} else
{return null;
}
} else
{if("\uFDD0'else")
{var ins__14603 = tree_map_add.call(null,comp,tree.right,k,v,found);
if(!((ins__14603 == null)))
{return tree.add_right(ins__14603);
} else
{return null;
}
} else
{return null;
}
}
}
}
});
cljs.core.tree_map_append = (function tree_map_append(left,right){
if((left == null))
{return right;
} else
{if((right == null))
{return left;
} else
{if(cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,left))
{if(cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,right))
{var app__14606 = tree_map_append.call(null,left.right,right.left);
if(cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,app__14606))
{return (new cljs.core.RedNode(app__14606.key,app__14606.val,(new cljs.core.RedNode(left.key,left.val,left.left,app__14606.left,null)),(new cljs.core.RedNode(right.key,right.val,app__14606.right,right.right,null)),null));
} else
{return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app__14606,right.right,null)),null));
}
} else
{return (new cljs.core.RedNode(left.key,left.val,left.left,tree_map_append.call(null,left.right,right),null));
}
} else
{if(cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,right))
{return (new cljs.core.RedNode(right.key,right.val,tree_map_append.call(null,left,right.left),right.right,null));
} else
{if("\uFDD0'else")
{var app__14607 = tree_map_append.call(null,left.right,right.left);
if(cljs.core.instance_QMARK_.call(null,cljs.core.RedNode,app__14607))
{return (new cljs.core.RedNode(app__14607.key,app__14607.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app__14607.left,null)),(new cljs.core.BlackNode(right.key,right.val,app__14607.right,right.right,null)),null));
} else
{return cljs.core.balance_left_del.call(null,left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app__14607,right.right,null)));
}
} else
{return null;
}
}
}
}
}
});
cljs.core.tree_map_remove = (function tree_map_remove(comp,tree,k,found){
if(!((tree == null)))
{var c__14613 = comp.call(null,k,tree.key);
if((c__14613 === 0))
{(found[0] = tree);
return cljs.core.tree_map_append.call(null,tree.left,tree.right);
} else
{if((c__14613 < 0))
{var del__14614 = tree_map_remove.call(null,comp,tree.left,k,found);
if((function (){var or__3824__auto____14615 = !((del__14614 == null));
if(or__3824__auto____14615)
{return or__3824__auto____14615;
} else
{return !(((found[0]) == null));
}
})())
{if(cljs.core.instance_QMARK_.call(null,cljs.core.BlackNode,tree.left))
{return cljs.core.balance_left_del.call(null,tree.key,tree.val,del__14614,tree.right);
} else
{return (new cljs.core.RedNode(tree.key,tree.val,del__14614,tree.right,null));
}
} else
{return null;
}
} else
{if("\uFDD0'else")
{var del__14616 = tree_map_remove.call(null,comp,tree.right,k,found);
if((function (){var or__3824__auto____14617 = !((del__14616 == null));
if(or__3824__auto____14617)
{return or__3824__auto____14617;
} else
{return !(((found[0]) == null));
}
})())
{if(cljs.core.instance_QMARK_.call(null,cljs.core.BlackNode,tree.right))
{return cljs.core.balance_right_del.call(null,tree.key,tree.val,tree.left,del__14616);
} else
{return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del__14616,null));
}
} else
{return null;
}
} else
{return null;
}
}
}
} else
{return null;
}
});
cljs.core.tree_map_replace = (function tree_map_replace(comp,tree,k,v){
var tk__14620 = tree.key;
var c__14621 = comp.call(null,k,tk__14620);
if((c__14621 === 0))
{return tree.replace(tk__14620,v,tree.left,tree.right);
} else
{if((c__14621 < 0))
{return tree.replace(tk__14620,tree.val,tree_map_replace.call(null,comp,tree.left,k,v),tree.right);
} else
{if("\uFDD0'else")
{return tree.replace(tk__14620,tree.val,tree.left,tree_map_replace.call(null,comp,tree.right,k,v));
} else
{return null;
}
}
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
})
cljs.core.PersistentTreeMap.cljs$lang$type = true;
cljs.core.PersistentTreeMap.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/PersistentTreeMap");
});
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__14624 = this;
var h__4714__auto____14625 = this__14624.__hash;
if(!((h__4714__auto____14625 == null)))
{return h__4714__auto____14625;
} else
{var h__4714__auto____14626 = cljs.core.hash_imap.call(null,coll);
this__14624.__hash = h__4714__auto____14626;
return h__4714__auto____14626;
}
});
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var this__14627 = this;
return coll.cljs$core$ILookup$_lookup$arity$3(coll,k,null);
});
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var this__14628 = this;
var n__14629 = coll.entry_at(k);
if(!((n__14629 == null)))
{return n__14629.val;
} else
{return not_found;
}
});
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var this__14630 = this;
var found__14631 = [null];
var t__14632 = cljs.core.tree_map_add.call(null,this__14630.comp,this__14630.tree,k,v,found__14631);
if((t__14632 == null))
{var found_node__14633 = cljs.core.nth.call(null,found__14631,0);
if(cljs.core._EQ_.call(null,v,found_node__14633.val))
{return coll;
} else
{return (new cljs.core.PersistentTreeMap(this__14630.comp,cljs.core.tree_map_replace.call(null,this__14630.comp,this__14630.tree,k,v),this__14630.cnt,this__14630.meta,null));
}
} else
{return (new cljs.core.PersistentTreeMap(this__14630.comp,t__14632.blacken(),(this__14630.cnt + 1),this__14630.meta,null));
}
});
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var this__14634 = this;
return !((coll.entry_at(k) == null));
});
cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__14668 = null;
var G__14668__2 = (function (this_sym14635,k){
var this__14637 = this;
var this_sym14635__14638 = this;
var coll__14639 = this_sym14635__14638;
return coll__14639.cljs$core$ILookup$_lookup$arity$2(coll__14639,k);
});
var G__14668__3 = (function (this_sym14636,k,not_found){
var this__14637 = this;
var this_sym14636__14640 = this;
var coll__14641 = this_sym14636__14640;
return coll__14641.cljs$core$ILookup$_lookup$arity$3(coll__14641,k,not_found);
});
G__14668 = function(this_sym14636,k,not_found){
switch(arguments.length){
case 2:
return G__14668__2.call(this,this_sym14636,k);
case 3:
return G__14668__3.call(this,this_sym14636,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__14668;
})()
;
cljs.core.PersistentTreeMap.prototype.apply = (function (this_sym14622,args14623){
var this__14642 = this;
return this_sym14622.call.apply(this_sym14622,[this_sym14622].concat(args14623.slice()));
});
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var this__14643 = this;
if(!((this__14643.tree == null)))
{return cljs.core.tree_map_kv_reduce.call(null,this__14643.tree,f,init);
} else
{return init;
}
});
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var this__14644 = this;
if(cljs.core.vector_QMARK_.call(null,entry))
{return coll.cljs$core$IAssociative$_assoc$arity$3(coll,cljs.core._nth.call(null,entry,0),cljs.core._nth.call(null,entry,1));
} else
{return cljs.core.reduce.call(null,cljs.core._conj,coll,entry);
}
});
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var this__14645 = this;
if((this__14645.cnt > 0))
{return cljs.core.create_tree_map_seq.call(null,this__14645.tree,false,this__14645.cnt);
} else
{return null;
}
});
cljs.core.PersistentTreeMap.prototype.toString = (function (){
var this__14646 = this;
var this__14647 = this;
return cljs.core.pr_str.call(null,this__14647);
});
cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var this__14648 = this;
var coll__14649 = this;
var t__14650 = this__14648.tree;
while(true){
if(!((t__14650 == null)))
{var c__14651 = this__14648.comp.call(null,k,t__14650.key);
if((c__14651 === 0))
{return t__14650;
} else
{if((c__14651 < 0))
{{
var G__14669 = t__14650.left;
t__14650 = G__14669;
continue;
}
} else
{if("\uFDD0'else")
{{
var G__14670 = t__14650.right;
t__14650 = G__14670;
continue;
}
} else
{return null;
}
}
}
} else
{return null;
}
break;
}
});
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var this__14652 = this;
if((this__14652.cnt > 0))
{return cljs.core.create_tree_map_seq.call(null,this__14652.tree,ascending_QMARK_,this__14652.cnt);
} else
{return null;
}
});
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var this__14653 = this;
if((this__14653.cnt > 0))
{var stack__14654 = null;
var t__14655 = this__14653.tree;
while(true){
if(!((t__14655 == null)))
{var c__14656 = this__14653.comp.call(null,k,t__14655.key);
if((c__14656 === 0))
{return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.call(null,stack__14654,t__14655),ascending_QMARK_,-1,null));
} else
{if(cljs.core.truth_(ascending_QMARK_))
{if((c__14656 < 0))
{{
var G__14671 = cljs.core.conj.call(null,stack__14654,t__14655);
var G__14672 = t__14655.left;
stack__14654 = G__14671;
t__14655 = G__14672;
continue;
}
} else
{{
var G__14673 = stack__14654;
var G__14674 = t__14655.right;
stack__14654 = G__14673;
t__14655 = G__14674;
continue;
}
}
} else
{if("\uFDD0'else")
{if((c__14656 > 0))
{{
var G__14675 = cljs.core.conj.call(null,stack__14654,t__14655);
var G__14676 = t__14655.right;
stack__14654 = G__14675;
t__14655 = G__14676;
continue;
}
} else
{{
var G__14677 = stack__14654;
var G__14678 = t__14655.left;
stack__14654 = G__14677;
t__14655 = G__14678;
continue;
}
}
} else
{return null;
}
}
}
} else
{if((stack__14654 == null))
{return (new cljs.core.PersistentTreeMapSeq(null,stack__14654,ascending_QMARK_,-1,null));
} else
{return null;
}
}
break;
}
} else
{return null;
}
});
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var this__14657 = this;
return cljs.core.key.call(null,entry);
});
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var this__14658 = this;
return this__14658.comp;
});
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__14659 = this;
if((this__14659.cnt > 0))
{return cljs.core.create_tree_map_seq.call(null,this__14659.tree,true,this__14659.cnt);
} else
{return null;
}
});
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var this__14660 = this;
return this__14660.cnt;
});
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__14661 = this;
return cljs.core.equiv_map.call(null,coll,other);
});
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__14662 = this;
return (new cljs.core.PersistentTreeMap(this__14662.comp,this__14662.tree,this__14662.cnt,meta,this__14662.__hash));
});
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__14663 = this;
return this__14663.meta;
});
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__14664 = this;
return cljs.core.with_meta.call(null,cljs.core.PersistentTreeMap.EMPTY,this__14664.meta);
});
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var this__14665 = this;
var found__14666 = [null];
var t__14667 = cljs.core.tree_map_remove.call(null,this__14665.comp,this__14665.tree,k,found__14666);
if((t__14667 == null))
{if((cljs.core.nth.call(null,found__14666,0) == null))
{return coll;
} else
{return (new cljs.core.PersistentTreeMap(this__14665.comp,null,0,this__14665.meta,null));
}
} else
{return (new cljs.core.PersistentTreeMap(this__14665.comp,t__14667.blacken(),(this__14665.cnt - 1),this__14665.meta,null));
}
});
cljs.core.PersistentTreeMap;
cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,0,null,0));
/**
* keyval => key val
* Returns a new hash map with supplied mappings.
* @param {...*} var_args
*/
cljs.core.hash_map = (function() { 
var hash_map__delegate = function (keyvals){
var in__14681 = cljs.core.seq.call(null,keyvals);
var out__14682 = cljs.core.transient$.call(null,cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in__14681)
{{
var G__14683 = cljs.core.nnext.call(null,in__14681);
var G__14684 = cljs.core.assoc_BANG_.call(null,out__14682,cljs.core.first.call(null,in__14681),cljs.core.second.call(null,in__14681));
in__14681 = G__14683;
out__14682 = G__14684;
continue;
}
} else
{return cljs.core.persistent_BANG_.call(null,out__14682);
}
break;
}
};
var hash_map = function (var_args){
var keyvals = null;
if (goog.isDef(var_args)) {
  keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return hash_map__delegate.call(this, keyvals);
};
hash_map.cljs$lang$maxFixedArity = 0;
hash_map.cljs$lang$applyTo = (function (arglist__14685){
var keyvals = cljs.core.seq(arglist__14685);;
return hash_map__delegate(keyvals);
});
hash_map.cljs$lang$arity$variadic = hash_map__delegate;
return hash_map;
})()
;
/**
* keyval => key val
* Returns a new array map with supplied mappings.
* @param {...*} var_args
*/
cljs.core.array_map = (function() { 
var array_map__delegate = function (keyvals){
return (new cljs.core.PersistentArrayMap(null,cljs.core.quot.call(null,cljs.core.count.call(null,keyvals),2),cljs.core.apply.call(null,cljs.core.array,keyvals),null));
};
var array_map = function (var_args){
var keyvals = null;
if (goog.isDef(var_args)) {
  keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return array_map__delegate.call(this, keyvals);
};
array_map.cljs$lang$maxFixedArity = 0;
array_map.cljs$lang$applyTo = (function (arglist__14686){
var keyvals = cljs.core.seq(arglist__14686);;
return array_map__delegate(keyvals);
});
array_map.cljs$lang$arity$variadic = array_map__delegate;
return array_map;
})()
;
/**
* keyval => key val
* Returns a new object map with supplied mappings.
* @param {...*} var_args
*/
cljs.core.obj_map = (function() { 
var obj_map__delegate = function (keyvals){
var ks__14690 = [];
var obj__14691 = {};
var kvs__14692 = cljs.core.seq.call(null,keyvals);
while(true){
if(kvs__14692)
{ks__14690.push(cljs.core.first.call(null,kvs__14692));
(obj__14691[cljs.core.first.call(null,kvs__14692)] = cljs.core.second.call(null,kvs__14692));
{
var G__14693 = cljs.core.nnext.call(null,kvs__14692);
kvs__14692 = G__14693;
continue;
}
} else
{return cljs.core.ObjMap.fromObject.call(null,ks__14690,obj__14691);
}
break;
}
};
var obj_map = function (var_args){
var keyvals = null;
if (goog.isDef(var_args)) {
  keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return obj_map__delegate.call(this, keyvals);
};
obj_map.cljs$lang$maxFixedArity = 0;
obj_map.cljs$lang$applyTo = (function (arglist__14694){
var keyvals = cljs.core.seq(arglist__14694);;
return obj_map__delegate(keyvals);
});
obj_map.cljs$lang$arity$variadic = obj_map__delegate;
return obj_map;
})()
;
/**
* keyval => key val
* Returns a new sorted map with supplied mappings.
* @param {...*} var_args
*/
cljs.core.sorted_map = (function() { 
var sorted_map__delegate = function (keyvals){
var in__14697 = cljs.core.seq.call(null,keyvals);
var out__14698 = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in__14697)
{{
var G__14699 = cljs.core.nnext.call(null,in__14697);
var G__14700 = cljs.core.assoc.call(null,out__14698,cljs.core.first.call(null,in__14697),cljs.core.second.call(null,in__14697));
in__14697 = G__14699;
out__14698 = G__14700;
continue;
}
} else
{return out__14698;
}
break;
}
};
var sorted_map = function (var_args){
var keyvals = null;
if (goog.isDef(var_args)) {
  keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return sorted_map__delegate.call(this, keyvals);
};
sorted_map.cljs$lang$maxFixedArity = 0;
sorted_map.cljs$lang$applyTo = (function (arglist__14701){
var keyvals = cljs.core.seq(arglist__14701);;
return sorted_map__delegate(keyvals);
});
sorted_map.cljs$lang$arity$variadic = sorted_map__delegate;
return sorted_map;
})()
;
/**
* keyval => key val
* Returns a new sorted map with supplied mappings, using the supplied comparator.
* @param {...*} var_args
*/
cljs.core.sorted_map_by = (function() { 
var sorted_map_by__delegate = function (comparator,keyvals){
var in__14704 = cljs.core.seq.call(null,keyvals);
var out__14705 = (new cljs.core.PersistentTreeMap(comparator,null,0,null,0));
while(true){
if(in__14704)
{{
var G__14706 = cljs.core.nnext.call(null,in__14704);
var G__14707 = cljs.core.assoc.call(null,out__14705,cljs.core.first.call(null,in__14704),cljs.core.second.call(null,in__14704));
in__14704 = G__14706;
out__14705 = G__14707;
continue;
}
} else
{return out__14705;
}
break;
}
};
var sorted_map_by = function (comparator,var_args){
var keyvals = null;
if (goog.isDef(var_args)) {
  keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);
} 
return sorted_map_by__delegate.call(this, comparator, keyvals);
};
sorted_map_by.cljs$lang$maxFixedArity = 1;
sorted_map_by.cljs$lang$applyTo = (function (arglist__14708){
var comparator = cljs.core.first(arglist__14708);
var keyvals = cljs.core.rest(arglist__14708);
return sorted_map_by__delegate(comparator, keyvals);
});
sorted_map_by.cljs$lang$arity$variadic = sorted_map_by__delegate;
return sorted_map_by;
})()
;
/**
* Returns a sequence of the map's keys.
*/
cljs.core.keys = (function keys(hash_map){
return cljs.core.seq.call(null,cljs.core.map.call(null,cljs.core.first,hash_map));
});
/**
* Returns the key of the map entry.
*/
cljs.core.key = (function key(map_entry){
return cljs.core._key.call(null,map_entry);
});
/**
* Returns a sequence of the map's values.
*/
cljs.core.vals = (function vals(hash_map){
return cljs.core.seq.call(null,cljs.core.map.call(null,cljs.core.second,hash_map));
});
/**
* Returns the value in the map entry.
*/
cljs.core.val = (function val(map_entry){
return cljs.core._val.call(null,map_entry);
});
/**
* Returns a map that consists of the rest of the maps conj-ed onto
* the first.  If a key occurs in more than one map, the mapping from
* the latter (left-to-right) will be the mapping in the result.
* @param {...*} var_args
*/
cljs.core.merge = (function() { 
var merge__delegate = function (maps){
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.identity,maps)))
{return cljs.core.reduce.call(null,(function (p1__14709_SHARP_,p2__14710_SHARP_){
return cljs.core.conj.call(null,(function (){var or__3824__auto____14712 = p1__14709_SHARP_;
if(cljs.core.truth_(or__3824__auto____14712))
{return or__3824__auto____14712;
} else
{return cljs.core.ObjMap.EMPTY;
}
})(),p2__14710_SHARP_);
}),maps);
} else
{return null;
}
};
var merge = function (var_args){
var maps = null;
if (goog.isDef(var_args)) {
  maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return merge__delegate.call(this, maps);
};
merge.cljs$lang$maxFixedArity = 0;
merge.cljs$lang$applyTo = (function (arglist__14713){
var maps = cljs.core.seq(arglist__14713);;
return merge__delegate(maps);
});
merge.cljs$lang$arity$variadic = merge__delegate;
return merge;
})()
;
/**
* Returns a map that consists of the rest of the maps conj-ed onto
* the first.  If a key occurs in more than one map, the mapping(s)
* from the latter (left-to-right) will be combined with the mapping in
* the result by calling (f val-in-result val-in-latter).
* @param {...*} var_args
*/
cljs.core.merge_with = (function() { 
var merge_with__delegate = function (f,maps){
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.identity,maps)))
{var merge_entry__14721 = (function (m,e){
var k__14719 = cljs.core.first.call(null,e);
var v__14720 = cljs.core.second.call(null,e);
if(cljs.core.contains_QMARK_.call(null,m,k__14719))
{return cljs.core.assoc.call(null,m,k__14719,f.call(null,cljs.core._lookup.call(null,m,k__14719,null),v__14720));
} else
{return cljs.core.assoc.call(null,m,k__14719,v__14720);
}
});
var merge2__14723 = (function (m1,m2){
return cljs.core.reduce.call(null,merge_entry__14721,(function (){var or__3824__auto____14722 = m1;
if(cljs.core.truth_(or__3824__auto____14722))
{return or__3824__auto____14722;
} else
{return cljs.core.ObjMap.EMPTY;
}
})(),cljs.core.seq.call(null,m2));
});
return cljs.core.reduce.call(null,merge2__14723,maps);
} else
{return null;
}
};
var merge_with = function (f,var_args){
var maps = null;
if (goog.isDef(var_args)) {
  maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);
} 
return merge_with__delegate.call(this, f, maps);
};
merge_with.cljs$lang$maxFixedArity = 1;
merge_with.cljs$lang$applyTo = (function (arglist__14724){
var f = cljs.core.first(arglist__14724);
var maps = cljs.core.rest(arglist__14724);
return merge_with__delegate(f, maps);
});
merge_with.cljs$lang$arity$variadic = merge_with__delegate;
return merge_with;
})()
;
/**
* Returns a map containing only those entries in map whose key is in keys
*/
cljs.core.select_keys = (function select_keys(map,keyseq){
var ret__14729 = cljs.core.ObjMap.EMPTY;
var keys__14730 = cljs.core.seq.call(null,keyseq);
while(true){
if(keys__14730)
{var key__14731 = cljs.core.first.call(null,keys__14730);
var entry__14732 = cljs.core._lookup.call(null,map,key__14731,"\uFDD0'cljs.core/not-found");
{
var G__14733 = ((cljs.core.not_EQ_.call(null,entry__14732,"\uFDD0'cljs.core/not-found"))?cljs.core.assoc.call(null,ret__14729,key__14731,entry__14732):ret__14729);
var G__14734 = cljs.core.next.call(null,keys__14730);
ret__14729 = G__14733;
keys__14730 = G__14734;
continue;
}
} else
{return ret__14729;
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 1;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
})
cljs.core.PersistentHashSet.cljs$lang$type = true;
cljs.core.PersistentHashSet.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/PersistentHashSet");
});
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var this__14738 = this;
return (new cljs.core.TransientHashSet(cljs.core.transient$.call(null,this__14738.hash_map)));
});
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__14739 = this;
var h__4714__auto____14740 = this__14739.__hash;
if(!((h__4714__auto____14740 == null)))
{return h__4714__auto____14740;
} else
{var h__4714__auto____14741 = cljs.core.hash_iset.call(null,coll);
this__14739.__hash = h__4714__auto____14741;
return h__4714__auto____14741;
}
});
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var this__14742 = this;
return coll.cljs$core$ILookup$_lookup$arity$3(coll,v,null);
});
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var this__14743 = this;
if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null,this__14743.hash_map,v)))
{return v;
} else
{return not_found;
}
});
cljs.core.PersistentHashSet.prototype.call = (function() {
var G__14764 = null;
var G__14764__2 = (function (this_sym14744,k){
var this__14746 = this;
var this_sym14744__14747 = this;
var coll__14748 = this_sym14744__14747;
return coll__14748.cljs$core$ILookup$_lookup$arity$2(coll__14748,k);
});
var G__14764__3 = (function (this_sym14745,k,not_found){
var this__14746 = this;
var this_sym14745__14749 = this;
var coll__14750 = this_sym14745__14749;
return coll__14750.cljs$core$ILookup$_lookup$arity$3(coll__14750,k,not_found);
});
G__14764 = function(this_sym14745,k,not_found){
switch(arguments.length){
case 2:
return G__14764__2.call(this,this_sym14745,k);
case 3:
return G__14764__3.call(this,this_sym14745,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__14764;
})()
;
cljs.core.PersistentHashSet.prototype.apply = (function (this_sym14736,args14737){
var this__14751 = this;
return this_sym14736.call.apply(this_sym14736,[this_sym14736].concat(args14737.slice()));
});
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var this__14752 = this;
return (new cljs.core.PersistentHashSet(this__14752.meta,cljs.core.assoc.call(null,this__14752.hash_map,o,null),null));
});
cljs.core.PersistentHashSet.prototype.toString = (function (){
var this__14753 = this;
var this__14754 = this;
return cljs.core.pr_str.call(null,this__14754);
});
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__14755 = this;
return cljs.core.keys.call(null,this__14755.hash_map);
});
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var this__14756 = this;
return (new cljs.core.PersistentHashSet(this__14756.meta,cljs.core.dissoc.call(null,this__14756.hash_map,v),null));
});
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var this__14757 = this;
return cljs.core.count.call(null,cljs.core.seq.call(null,coll));
});
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__14758 = this;
var and__3822__auto____14759 = cljs.core.set_QMARK_.call(null,other);
if(and__3822__auto____14759)
{var and__3822__auto____14760 = (cljs.core.count.call(null,coll) === cljs.core.count.call(null,other));
if(and__3822__auto____14760)
{return cljs.core.every_QMARK_.call(null,(function (p1__14735_SHARP_){
return cljs.core.contains_QMARK_.call(null,coll,p1__14735_SHARP_);
}),other);
} else
{return and__3822__auto____14760;
}
} else
{return and__3822__auto____14759;
}
});
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__14761 = this;
return (new cljs.core.PersistentHashSet(meta,this__14761.hash_map,this__14761.__hash));
});
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__14762 = this;
return this__14762.meta;
});
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__14763 = this;
return cljs.core.with_meta.call(null,cljs.core.PersistentHashSet.EMPTY,this__14763.meta);
});
cljs.core.PersistentHashSet;
cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.hash_map.call(null),0));
cljs.core.PersistentHashSet.fromArray = (function (items){
var len__14765 = cljs.core.count.call(null,items);
var i__14766 = 0;
var out__14767 = cljs.core.transient$.call(null,cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i__14766 < len__14765))
{{
var G__14768 = (i__14766 + 1);
var G__14769 = cljs.core.conj_BANG_.call(null,out__14767,(items[i__14766]));
i__14766 = G__14768;
out__14767 = G__14769;
continue;
}
} else
{return cljs.core.persistent_BANG_.call(null,out__14767);
}
break;
}
});

/**
* @constructor
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 34;
})
cljs.core.TransientHashSet.cljs$lang$type = true;
cljs.core.TransientHashSet.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/TransientHashSet");
});
cljs.core.TransientHashSet.prototype.call = (function() {
var G__14787 = null;
var G__14787__2 = (function (this_sym14773,k){
var this__14775 = this;
var this_sym14773__14776 = this;
var tcoll__14777 = this_sym14773__14776;
if((cljs.core._lookup.call(null,this__14775.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel))
{return null;
} else
{return k;
}
});
var G__14787__3 = (function (this_sym14774,k,not_found){
var this__14775 = this;
var this_sym14774__14778 = this;
var tcoll__14779 = this_sym14774__14778;
if((cljs.core._lookup.call(null,this__14775.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel))
{return not_found;
} else
{return k;
}
});
G__14787 = function(this_sym14774,k,not_found){
switch(arguments.length){
case 2:
return G__14787__2.call(this,this_sym14774,k);
case 3:
return G__14787__3.call(this,this_sym14774,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__14787;
})()
;
cljs.core.TransientHashSet.prototype.apply = (function (this_sym14771,args14772){
var this__14780 = this;
return this_sym14771.call.apply(this_sym14771,[this_sym14771].concat(args14772.slice()));
});
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var this__14781 = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(tcoll,v,null);
});
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var this__14782 = this;
if((cljs.core._lookup.call(null,this__14782.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel))
{return not_found;
} else
{return v;
}
});
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var this__14783 = this;
return cljs.core.count.call(null,this__14783.transient_map);
});
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var this__14784 = this;
this__14784.transient_map = cljs.core.dissoc_BANG_.call(null,this__14784.transient_map,v);
return tcoll;
});
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var this__14785 = this;
this__14785.transient_map = cljs.core.assoc_BANG_.call(null,this__14785.transient_map,o,null);
return tcoll;
});
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var this__14786 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_.call(null,this__14786.transient_map),null));
});
cljs.core.TransientHashSet;

/**
* @constructor
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
})
cljs.core.PersistentTreeSet.cljs$lang$type = true;
cljs.core.PersistentTreeSet.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/PersistentTreeSet");
});
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var this__14790 = this;
var h__4714__auto____14791 = this__14790.__hash;
if(!((h__4714__auto____14791 == null)))
{return h__4714__auto____14791;
} else
{var h__4714__auto____14792 = cljs.core.hash_iset.call(null,coll);
this__14790.__hash = h__4714__auto____14792;
return h__4714__auto____14792;
}
});
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var this__14793 = this;
return coll.cljs$core$ILookup$_lookup$arity$3(coll,v,null);
});
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var this__14794 = this;
if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null,this__14794.tree_map,v)))
{return v;
} else
{return not_found;
}
});
cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__14820 = null;
var G__14820__2 = (function (this_sym14795,k){
var this__14797 = this;
var this_sym14795__14798 = this;
var coll__14799 = this_sym14795__14798;
return coll__14799.cljs$core$ILookup$_lookup$arity$2(coll__14799,k);
});
var G__14820__3 = (function (this_sym14796,k,not_found){
var this__14797 = this;
var this_sym14796__14800 = this;
var coll__14801 = this_sym14796__14800;
return coll__14801.cljs$core$ILookup$_lookup$arity$3(coll__14801,k,not_found);
});
G__14820 = function(this_sym14796,k,not_found){
switch(arguments.length){
case 2:
return G__14820__2.call(this,this_sym14796,k);
case 3:
return G__14820__3.call(this,this_sym14796,k,not_found);
}
throw('Invalid arity: ' + arguments.length);
};
return G__14820;
})()
;
cljs.core.PersistentTreeSet.prototype.apply = (function (this_sym14788,args14789){
var this__14802 = this;
return this_sym14788.call.apply(this_sym14788,[this_sym14788].concat(args14789.slice()));
});
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var this__14803 = this;
return (new cljs.core.PersistentTreeSet(this__14803.meta,cljs.core.assoc.call(null,this__14803.tree_map,o,null),null));
});
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var this__14804 = this;
return cljs.core.map.call(null,cljs.core.key,cljs.core.rseq.call(null,this__14804.tree_map));
});
cljs.core.PersistentTreeSet.prototype.toString = (function (){
var this__14805 = this;
var this__14806 = this;
return cljs.core.pr_str.call(null,this__14806);
});
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var this__14807 = this;
return cljs.core.map.call(null,cljs.core.key,cljs.core._sorted_seq.call(null,this__14807.tree_map,ascending_QMARK_));
});
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var this__14808 = this;
return cljs.core.map.call(null,cljs.core.key,cljs.core._sorted_seq_from.call(null,this__14808.tree_map,k,ascending_QMARK_));
});
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var this__14809 = this;
return entry;
});
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var this__14810 = this;
return cljs.core._comparator.call(null,this__14810.tree_map);
});
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var this__14811 = this;
return cljs.core.keys.call(null,this__14811.tree_map);
});
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var this__14812 = this;
return (new cljs.core.PersistentTreeSet(this__14812.meta,cljs.core.dissoc.call(null,this__14812.tree_map,v),null));
});
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var this__14813 = this;
return cljs.core.count.call(null,this__14813.tree_map);
});
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var this__14814 = this;
var and__3822__auto____14815 = cljs.core.set_QMARK_.call(null,other);
if(and__3822__auto____14815)
{var and__3822__auto____14816 = (cljs.core.count.call(null,coll) === cljs.core.count.call(null,other));
if(and__3822__auto____14816)
{return cljs.core.every_QMARK_.call(null,(function (p1__14770_SHARP_){
return cljs.core.contains_QMARK_.call(null,coll,p1__14770_SHARP_);
}),other);
} else
{return and__3822__auto____14816;
}
} else
{return and__3822__auto____14815;
}
});
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta){
var this__14817 = this;
return (new cljs.core.PersistentTreeSet(meta,this__14817.tree_map,this__14817.__hash));
});
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var this__14818 = this;
return this__14818.meta;
});
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var this__14819 = this;
return cljs.core.with_meta.call(null,cljs.core.PersistentTreeSet.EMPTY,this__14819.meta);
});
cljs.core.PersistentTreeSet;
cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map.call(null),0));
/**
* @param {...*} var_args
*/
cljs.core.hash_set = (function() {
var hash_set = null;
var hash_set__0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
});
var hash_set__1 = (function() { 
var G__14825__delegate = function (keys){
var in__14823 = cljs.core.seq.call(null,keys);
var out__14824 = cljs.core.transient$.call(null,cljs.core.PersistentHashSet.EMPTY);
while(true){
if(cljs.core.seq.call(null,in__14823))
{{
var G__14826 = cljs.core.next.call(null,in__14823);
var G__14827 = cljs.core.conj_BANG_.call(null,out__14824,cljs.core.first.call(null,in__14823));
in__14823 = G__14826;
out__14824 = G__14827;
continue;
}
} else
{return cljs.core.persistent_BANG_.call(null,out__14824);
}
break;
}
};
var G__14825 = function (var_args){
var keys = null;
if (goog.isDef(var_args)) {
  keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return G__14825__delegate.call(this, keys);
};
G__14825.cljs$lang$maxFixedArity = 0;
G__14825.cljs$lang$applyTo = (function (arglist__14828){
var keys = cljs.core.seq(arglist__14828);;
return G__14825__delegate(keys);
});
G__14825.cljs$lang$arity$variadic = G__14825__delegate;
return G__14825;
})()
;
hash_set = function(var_args){
var keys = var_args;
switch(arguments.length){
case 0:
return hash_set__0.call(this);
default:
return hash_set__1.cljs$lang$arity$variadic(cljs.core.array_seq(arguments, 0));
}
throw('Invalid arity: ' + arguments.length);
};
hash_set.cljs$lang$maxFixedArity = 0;
hash_set.cljs$lang$applyTo = hash_set__1.cljs$lang$applyTo;
hash_set.cljs$lang$arity$0 = hash_set__0;
hash_set.cljs$lang$arity$variadic = hash_set__1.cljs$lang$arity$variadic;
return hash_set;
})()
;
/**
* Returns a set of the distinct elements of coll.
*/
cljs.core.set = (function set(coll){
return cljs.core.apply.call(null,cljs.core.hash_set,coll);
});
/**
* Returns a new sorted set with supplied keys.
* @param {...*} var_args
*/
cljs.core.sorted_set = (function() { 
var sorted_set__delegate = function (keys){
return cljs.core.reduce.call(null,cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
};
var sorted_set = function (var_args){
var keys = null;
if (goog.isDef(var_args)) {
  keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return sorted_set__delegate.call(this, keys);
};
sorted_set.cljs$lang$maxFixedArity = 0;
sorted_set.cljs$lang$applyTo = (function (arglist__14829){
var keys = cljs.core.seq(arglist__14829);;
return sorted_set__delegate(keys);
});
sorted_set.cljs$lang$arity$variadic = sorted_set__delegate;
return sorted_set;
})()
;
/**
* Returns a new sorted set with supplied keys, using the supplied comparator.
* @param {...*} var_args
*/
cljs.core.sorted_set_by = (function() { 
var sorted_set_by__delegate = function (comparator,keys){
return cljs.core.reduce.call(null,cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by.call(null,comparator),0)),keys);
};
var sorted_set_by = function (comparator,var_args){
var keys = null;
if (goog.isDef(var_args)) {
  keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);
} 
return sorted_set_by__delegate.call(this, comparator, keys);
};
sorted_set_by.cljs$lang$maxFixedArity = 1;
sorted_set_by.cljs$lang$applyTo = (function (arglist__14831){
var comparator = cljs.core.first(arglist__14831);
var keys = cljs.core.rest(arglist__14831);
return sorted_set_by__delegate(comparator, keys);
});
sorted_set_by.cljs$lang$arity$variadic = sorted_set_by__delegate;
return sorted_set_by;
})()
;
/**
* Given a map of replacement pairs and a vector/collection, returns a
* vector/seq with any elements = a key in smap replaced with the
* corresponding val in smap
*/
cljs.core.replace = (function replace(smap,coll){
if(cljs.core.vector_QMARK_.call(null,coll))
{var n__14837 = cljs.core.count.call(null,coll);
return cljs.core.reduce.call(null,(function (v,i){
var temp__3971__auto____14838 = cljs.core.find.call(null,smap,cljs.core.nth.call(null,v,i));
if(cljs.core.truth_(temp__3971__auto____14838))
{var e__14839 = temp__3971__auto____14838;
return cljs.core.assoc.call(null,v,i,cljs.core.second.call(null,e__14839));
} else
{return v;
}
}),coll,cljs.core.take.call(null,n__14837,cljs.core.iterate.call(null,cljs.core.inc,0)));
} else
{return cljs.core.map.call(null,(function (p1__14830_SHARP_){
var temp__3971__auto____14840 = cljs.core.find.call(null,smap,p1__14830_SHARP_);
if(cljs.core.truth_(temp__3971__auto____14840))
{var e__14841 = temp__3971__auto____14840;
return cljs.core.second.call(null,e__14841);
} else
{return p1__14830_SHARP_;
}
}),coll);
}
});
/**
* Returns a lazy sequence of the elements of coll with duplicates removed
*/
cljs.core.distinct = (function distinct(coll){
var step__14871 = (function step(xs,seen){
return (new cljs.core.LazySeq(null,false,(function (){
return (function (p__14864,seen){
while(true){
var vec__14865__14866 = p__14864;
var f__14867 = cljs.core.nth.call(null,vec__14865__14866,0,null);
var xs__14868 = vec__14865__14866;
var temp__3974__auto____14869 = cljs.core.seq.call(null,xs__14868);
if(temp__3974__auto____14869)
{var s__14870 = temp__3974__auto____14869;
if(cljs.core.contains_QMARK_.call(null,seen,f__14867))
{{
var G__14872 = cljs.core.rest.call(null,s__14870);
var G__14873 = seen;
p__14864 = G__14872;
seen = G__14873;
continue;
}
} else
{return cljs.core.cons.call(null,f__14867,step.call(null,cljs.core.rest.call(null,s__14870),cljs.core.conj.call(null,seen,f__14867)));
}
} else
{return null;
}
break;
}
}).call(null,xs,seen);
}),null));
});
return step__14871.call(null,coll,cljs.core.PersistentHashSet.EMPTY);
});
cljs.core.butlast = (function butlast(s){
var ret__14876 = cljs.core.PersistentVector.EMPTY;
var s__14877 = s;
while(true){
if(cljs.core.next.call(null,s__14877))
{{
var G__14878 = cljs.core.conj.call(null,ret__14876,cljs.core.first.call(null,s__14877));
var G__14879 = cljs.core.next.call(null,s__14877);
ret__14876 = G__14878;
s__14877 = G__14879;
continue;
}
} else
{return cljs.core.seq.call(null,ret__14876);
}
break;
}
});
/**
* Returns the name String of a string, symbol or keyword.
*/
cljs.core.name = (function name(x){
if(cljs.core.string_QMARK_.call(null,x))
{return x;
} else
{if((function (){var or__3824__auto____14882 = cljs.core.keyword_QMARK_.call(null,x);
if(or__3824__auto____14882)
{return or__3824__auto____14882;
} else
{return cljs.core.symbol_QMARK_.call(null,x);
}
})())
{var i__14883 = x.lastIndexOf("/");
if((i__14883 < 0))
{return cljs.core.subs.call(null,x,2);
} else
{return cljs.core.subs.call(null,x,(i__14883 + 1));
}
} else
{if("\uFDD0'else")
{throw (new Error([cljs.core.str("Doesn't support name: "),cljs.core.str(x)].join('')));
} else
{return null;
}
}
}
});
/**
* Returns the namespace String of a symbol or keyword, or nil if not present.
*/
cljs.core.namespace = (function namespace(x){
if((function (){var or__3824__auto____14886 = cljs.core.keyword_QMARK_.call(null,x);
if(or__3824__auto____14886)
{return or__3824__auto____14886;
} else
{return cljs.core.symbol_QMARK_.call(null,x);
}
})())
{var i__14887 = x.lastIndexOf("/");
if((i__14887 > -1))
{return cljs.core.subs.call(null,x,2,i__14887);
} else
{return null;
}
} else
{throw (new Error([cljs.core.str("Doesn't support namespace: "),cljs.core.str(x)].join('')));
}
});
/**
* Returns a map with the keys mapped to the corresponding vals.
*/
cljs.core.zipmap = (function zipmap(keys,vals){
var map__14894 = cljs.core.ObjMap.EMPTY;
var ks__14895 = cljs.core.seq.call(null,keys);
var vs__14896 = cljs.core.seq.call(null,vals);
while(true){
if((function (){var and__3822__auto____14897 = ks__14895;
if(and__3822__auto____14897)
{return vs__14896;
} else
{return and__3822__auto____14897;
}
})())
{{
var G__14898 = cljs.core.assoc.call(null,map__14894,cljs.core.first.call(null,ks__14895),cljs.core.first.call(null,vs__14896));
var G__14899 = cljs.core.next.call(null,ks__14895);
var G__14900 = cljs.core.next.call(null,vs__14896);
map__14894 = G__14898;
ks__14895 = G__14899;
vs__14896 = G__14900;
continue;
}
} else
{return map__14894;
}
break;
}
});
/**
* Returns the x for which (k x), a number, is greatest.
* @param {...*} var_args
*/
cljs.core.max_key = (function() {
var max_key = null;
var max_key__2 = (function (k,x){
return x;
});
var max_key__3 = (function (k,x,y){
if((k.call(null,x) > k.call(null,y)))
{return x;
} else
{return y;
}
});
var max_key__4 = (function() { 
var G__14903__delegate = function (k,x,y,more){
return cljs.core.reduce.call(null,(function (p1__14888_SHARP_,p2__14889_SHARP_){
return max_key.call(null,k,p1__14888_SHARP_,p2__14889_SHARP_);
}),max_key.call(null,k,x,y),more);
};
var G__14903 = function (k,x,y,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__14903__delegate.call(this, k, x, y, more);
};
G__14903.cljs$lang$maxFixedArity = 3;
G__14903.cljs$lang$applyTo = (function (arglist__14904){
var k = cljs.core.first(arglist__14904);
var x = cljs.core.first(cljs.core.next(arglist__14904));
var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__14904)));
var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__14904)));
return G__14903__delegate(k, x, y, more);
});
G__14903.cljs$lang$arity$variadic = G__14903__delegate;
return G__14903;
})()
;
max_key = function(k,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return max_key__2.call(this,k,x);
case 3:
return max_key__3.call(this,k,x,y);
default:
return max_key__4.cljs$lang$arity$variadic(k,x,y, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
max_key.cljs$lang$maxFixedArity = 3;
max_key.cljs$lang$applyTo = max_key__4.cljs$lang$applyTo;
max_key.cljs$lang$arity$2 = max_key__2;
max_key.cljs$lang$arity$3 = max_key__3;
max_key.cljs$lang$arity$variadic = max_key__4.cljs$lang$arity$variadic;
return max_key;
})()
;
/**
* Returns the x for which (k x), a number, is least.
* @param {...*} var_args
*/
cljs.core.min_key = (function() {
var min_key = null;
var min_key__2 = (function (k,x){
return x;
});
var min_key__3 = (function (k,x,y){
if((k.call(null,x) < k.call(null,y)))
{return x;
} else
{return y;
}
});
var min_key__4 = (function() { 
var G__14905__delegate = function (k,x,y,more){
return cljs.core.reduce.call(null,(function (p1__14901_SHARP_,p2__14902_SHARP_){
return min_key.call(null,k,p1__14901_SHARP_,p2__14902_SHARP_);
}),min_key.call(null,k,x,y),more);
};
var G__14905 = function (k,x,y,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__14905__delegate.call(this, k, x, y, more);
};
G__14905.cljs$lang$maxFixedArity = 3;
G__14905.cljs$lang$applyTo = (function (arglist__14906){
var k = cljs.core.first(arglist__14906);
var x = cljs.core.first(cljs.core.next(arglist__14906));
var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__14906)));
var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__14906)));
return G__14905__delegate(k, x, y, more);
});
G__14905.cljs$lang$arity$variadic = G__14905__delegate;
return G__14905;
})()
;
min_key = function(k,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return min_key__2.call(this,k,x);
case 3:
return min_key__3.call(this,k,x,y);
default:
return min_key__4.cljs$lang$arity$variadic(k,x,y, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
min_key.cljs$lang$maxFixedArity = 3;
min_key.cljs$lang$applyTo = min_key__4.cljs$lang$applyTo;
min_key.cljs$lang$arity$2 = min_key__2;
min_key.cljs$lang$arity$3 = min_key__3;
min_key.cljs$lang$arity$variadic = min_key__4.cljs$lang$arity$variadic;
return min_key;
})()
;
/**
* Returns a lazy sequence of lists like partition, but may include
* partitions with fewer than n items at the end.
*/
cljs.core.partition_all = (function() {
var partition_all = null;
var partition_all__2 = (function (n,coll){
return partition_all.call(null,n,n,coll);
});
var partition_all__3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,false,(function (){
var temp__3974__auto____14909 = cljs.core.seq.call(null,coll);
if(temp__3974__auto____14909)
{var s__14910 = temp__3974__auto____14909;
return cljs.core.cons.call(null,cljs.core.take.call(null,n,s__14910),partition_all.call(null,n,step,cljs.core.drop.call(null,step,s__14910)));
} else
{return null;
}
}),null));
});
partition_all = function(n,step,coll){
switch(arguments.length){
case 2:
return partition_all__2.call(this,n,step);
case 3:
return partition_all__3.call(this,n,step,coll);
}
throw('Invalid arity: ' + arguments.length);
};
partition_all.cljs$lang$arity$2 = partition_all__2;
partition_all.cljs$lang$arity$3 = partition_all__3;
return partition_all;
})()
;
/**
* Returns a lazy sequence of successive items from coll while
* (pred item) returns true. pred must be free of side-effects.
*/
cljs.core.take_while = (function take_while(pred,coll){
return (new cljs.core.LazySeq(null,false,(function (){
var temp__3974__auto____14913 = cljs.core.seq.call(null,coll);
if(temp__3974__auto____14913)
{var s__14914 = temp__3974__auto____14913;
if(cljs.core.truth_(pred.call(null,cljs.core.first.call(null,s__14914))))
{return cljs.core.cons.call(null,cljs.core.first.call(null,s__14914),take_while.call(null,pred,cljs.core.rest.call(null,s__14914)));
} else
{return null;
}
} else
{return null;
}
}),null));
});
cljs.core.mk_bound_fn = (function mk_bound_fn(sc,test,key){
return (function (e){
var comp__14916 = cljs.core._comparator.call(null,sc);
return test.call(null,comp__14916.call(null,cljs.core._entry_key.call(null,sc,e),key),0);
});
});
/**
* sc must be a sorted collection, test(s) one of <, <=, > or
* >=. Returns a seq of those entries with keys ek for
* which (test (.. sc comparator (compare ek key)) 0) is true
*/
cljs.core.subseq = (function() {
var subseq = null;
var subseq__3 = (function (sc,test,key){
var include__14928 = cljs.core.mk_bound_fn.call(null,sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_,cljs.core._GT__EQ_]).call(null,test)))
{var temp__3974__auto____14929 = cljs.core._sorted_seq_from.call(null,sc,key,true);
if(cljs.core.truth_(temp__3974__auto____14929))
{var vec__14930__14931 = temp__3974__auto____14929;
var e__14932 = cljs.core.nth.call(null,vec__14930__14931,0,null);
var s__14933 = vec__14930__14931;
if(cljs.core.truth_(include__14928.call(null,e__14932)))
{return s__14933;
} else
{return cljs.core.next.call(null,s__14933);
}
} else
{return null;
}
} else
{return cljs.core.take_while.call(null,include__14928,cljs.core._sorted_seq.call(null,sc,true));
}
});
var subseq__5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__3974__auto____14934 = cljs.core._sorted_seq_from.call(null,sc,start_key,true);
if(cljs.core.truth_(temp__3974__auto____14934))
{var vec__14935__14936 = temp__3974__auto____14934;
var e__14937 = cljs.core.nth.call(null,vec__14935__14936,0,null);
var s__14938 = vec__14935__14936;
return cljs.core.take_while.call(null,cljs.core.mk_bound_fn.call(null,sc,end_test,end_key),(cljs.core.truth_(cljs.core.mk_bound_fn.call(null,sc,start_test,start_key).call(null,e__14937))?s__14938:cljs.core.next.call(null,s__14938)));
} else
{return null;
}
});
subseq = function(sc,start_test,start_key,end_test,end_key){
switch(arguments.length){
case 3:
return subseq__3.call(this,sc,start_test,start_key);
case 5:
return subseq__5.call(this,sc,start_test,start_key,end_test,end_key);
}
throw('Invalid arity: ' + arguments.length);
};
subseq.cljs$lang$arity$3 = subseq__3;
subseq.cljs$lang$arity$5 = subseq__5;
return subseq;
})()
;
/**
* sc must be a sorted collection, test(s) one of <, <=, > or
* >=. Returns a reverse seq of those entries with keys ek for
* which (test (.. sc comparator (compare ek key)) 0) is true
*/
cljs.core.rsubseq = (function() {
var rsubseq = null;
var rsubseq__3 = (function (sc,test,key){
var include__14950 = cljs.core.mk_bound_fn.call(null,sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_,cljs.core._LT__EQ_]).call(null,test)))
{var temp__3974__auto____14951 = cljs.core._sorted_seq_from.call(null,sc,key,false);
if(cljs.core.truth_(temp__3974__auto____14951))
{var vec__14952__14953 = temp__3974__auto____14951;
var e__14954 = cljs.core.nth.call(null,vec__14952__14953,0,null);
var s__14955 = vec__14952__14953;
if(cljs.core.truth_(include__14950.call(null,e__14954)))
{return s__14955;
} else
{return cljs.core.next.call(null,s__14955);
}
} else
{return null;
}
} else
{return cljs.core.take_while.call(null,include__14950,cljs.core._sorted_seq.call(null,sc,false));
}
});
var rsubseq__5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__3974__auto____14956 = cljs.core._sorted_seq_from.call(null,sc,end_key,false);
if(cljs.core.truth_(temp__3974__auto____14956))
{var vec__14957__14958 = temp__3974__auto____14956;
var e__14959 = cljs.core.nth.call(null,vec__14957__14958,0,null);
var s__14960 = vec__14957__14958;
return cljs.core.take_while.call(null,cljs.core.mk_bound_fn.call(null,sc,start_test,start_key),(cljs.core.truth_(cljs.core.mk_bound_fn.call(null,sc,end_test,end_key).call(null,e__14959))?s__14960:cljs.core.next.call(null,s__14960)));
} else
{return null;
}
});
rsubseq = function(sc,start_test,start_key,end_test,end_key){
switch(arguments.length){
case 3:
return rsubseq__3.call(this,sc,start_test,start_key);
case 5:
return rsubseq__5.call(this,sc,start_test,start_key,end_test,end_key);
}
throw('Invalid arity: ' + arguments.length);
};
rsubseq.cljs$lang$arity$3 = rsubseq__3;
rsubseq.cljs$lang$arity$5 = rsubseq__5;
return rsubseq;
})()
;

/**
* @constructor
*/
cljs.core.Range = (function (meta,start,end,step,__hash){
this.meta = meta;
this.start = start;
this.end = end;
this.step = step;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32375006;
})
cljs.core.Range.cljs$lang$type = true;
cljs.core.Range.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/Range");
});
cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = (function (rng){
var this__14961 = this;
var h__4714__auto____14962 = this__14961.__hash;
if(!((h__4714__auto____14962 == null)))
{return h__4714__auto____14962;
} else
{var h__4714__auto____14963 = cljs.core.hash_coll.call(null,rng);
this__14961.__hash = h__4714__auto____14963;
return h__4714__auto____14963;
}
});
cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = (function (rng){
var this__14964 = this;
if((this__14964.step > 0))
{if(((this__14964.start + this__14964.step) < this__14964.end))
{return (new cljs.core.Range(this__14964.meta,(this__14964.start + this__14964.step),this__14964.end,this__14964.step,null));
} else
{return null;
}
} else
{if(((this__14964.start + this__14964.step) > this__14964.end))
{return (new cljs.core.Range(this__14964.meta,(this__14964.start + this__14964.step),this__14964.end,this__14964.step,null));
} else
{return null;
}
}
});
cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = (function (rng,o){
var this__14965 = this;
return cljs.core.cons.call(null,o,rng);
});
cljs.core.Range.prototype.toString = (function (){
var this__14966 = this;
var this__14967 = this;
return cljs.core.pr_str.call(null,this__14967);
});
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (rng,f){
var this__14968 = this;
return cljs.core.ci_reduce.call(null,rng,f);
});
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (rng,f,s){
var this__14969 = this;
return cljs.core.ci_reduce.call(null,rng,f,s);
});
cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (rng){
var this__14970 = this;
if((this__14970.step > 0))
{if((this__14970.start < this__14970.end))
{return rng;
} else
{return null;
}
} else
{if((this__14970.start > this__14970.end))
{return rng;
} else
{return null;
}
}
});
cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = (function (rng){
var this__14971 = this;
if(cljs.core.not.call(null,rng.cljs$core$ISeqable$_seq$arity$1(rng)))
{return 0;
} else
{return Math.ceil(((this__14971.end - this__14971.start) / this__14971.step));
}
});
cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = (function (rng){
var this__14972 = this;
return this__14972.start;
});
cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = (function (rng){
var this__14973 = this;
if(!((rng.cljs$core$ISeqable$_seq$arity$1(rng) == null)))
{return (new cljs.core.Range(this__14973.meta,(this__14973.start + this__14973.step),this__14973.end,this__14973.step,null));
} else
{return cljs.core.List.EMPTY;
}
});
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (rng,other){
var this__14974 = this;
return cljs.core.equiv_sequential.call(null,rng,other);
});
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (rng,meta){
var this__14975 = this;
return (new cljs.core.Range(meta,this__14975.start,this__14975.end,this__14975.step,this__14975.__hash));
});
cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = (function (rng){
var this__14976 = this;
return this__14976.meta;
});
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (rng,n){
var this__14977 = this;
if((n < rng.cljs$core$ICounted$_count$arity$1(rng)))
{return (this__14977.start + (n * this__14977.step));
} else
{if((function (){var and__3822__auto____14978 = (this__14977.start > this__14977.end);
if(and__3822__auto____14978)
{return (this__14977.step === 0);
} else
{return and__3822__auto____14978;
}
})())
{return this__14977.start;
} else
{throw (new Error("Index out of bounds"));
}
}
});
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (rng,n,not_found){
var this__14979 = this;
if((n < rng.cljs$core$ICounted$_count$arity$1(rng)))
{return (this__14979.start + (n * this__14979.step));
} else
{if((function (){var and__3822__auto____14980 = (this__14979.start > this__14979.end);
if(and__3822__auto____14980)
{return (this__14979.step === 0);
} else
{return and__3822__auto____14980;
}
})())
{return this__14979.start;
} else
{return not_found;
}
}
});
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (rng){
var this__14981 = this;
return cljs.core.with_meta.call(null,cljs.core.List.EMPTY,this__14981.meta);
});
cljs.core.Range;
/**
* Returns a lazy seq of nums from start (inclusive) to end
* (exclusive), by step, where start defaults to 0, step to 1,
* and end to infinity.
*/
cljs.core.range = (function() {
var range = null;
var range__0 = (function (){
return range.call(null,0,Number.MAX_VALUE,1);
});
var range__1 = (function (end){
return range.call(null,0,end,1);
});
var range__2 = (function (start,end){
return range.call(null,start,end,1);
});
var range__3 = (function (start,end,step){
return (new cljs.core.Range(null,start,end,step,null));
});
range = function(start,end,step){
switch(arguments.length){
case 0:
return range__0.call(this);
case 1:
return range__1.call(this,start);
case 2:
return range__2.call(this,start,end);
case 3:
return range__3.call(this,start,end,step);
}
throw('Invalid arity: ' + arguments.length);
};
range.cljs$lang$arity$0 = range__0;
range.cljs$lang$arity$1 = range__1;
range.cljs$lang$arity$2 = range__2;
range.cljs$lang$arity$3 = range__3;
return range;
})()
;
/**
* Returns a lazy seq of every nth item in coll.
*/
cljs.core.take_nth = (function take_nth(n,coll){
return (new cljs.core.LazySeq(null,false,(function (){
var temp__3974__auto____14984 = cljs.core.seq.call(null,coll);
if(temp__3974__auto____14984)
{var s__14985 = temp__3974__auto____14984;
return cljs.core.cons.call(null,cljs.core.first.call(null,s__14985),take_nth.call(null,n,cljs.core.drop.call(null,n,s__14985)));
} else
{return null;
}
}),null));
});
/**
* Returns a vector of [(take-while pred coll) (drop-while pred coll)]
*/
cljs.core.split_with = (function split_with(pred,coll){
return cljs.core.PersistentVector.fromArray([cljs.core.take_while.call(null,pred,coll),cljs.core.drop_while.call(null,pred,coll)], true);
});
/**
* Applies f to each value in coll, splitting it each time f returns
* a new value.  Returns a lazy seq of partitions.
*/
cljs.core.partition_by = (function partition_by(f,coll){
return (new cljs.core.LazySeq(null,false,(function (){
var temp__3974__auto____14992 = cljs.core.seq.call(null,coll);
if(temp__3974__auto____14992)
{var s__14993 = temp__3974__auto____14992;
var fst__14994 = cljs.core.first.call(null,s__14993);
var fv__14995 = f.call(null,fst__14994);
var run__14996 = cljs.core.cons.call(null,fst__14994,cljs.core.take_while.call(null,(function (p1__14986_SHARP_){
return cljs.core._EQ_.call(null,fv__14995,f.call(null,p1__14986_SHARP_));
}),cljs.core.next.call(null,s__14993)));
return cljs.core.cons.call(null,run__14996,partition_by.call(null,f,cljs.core.seq.call(null,cljs.core.drop.call(null,cljs.core.count.call(null,run__14996),s__14993))));
} else
{return null;
}
}),null));
});
/**
* Returns a map from distinct items in coll to the number of times
* they appear.
*/
cljs.core.frequencies = (function frequencies(coll){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (counts,x){
return cljs.core.assoc_BANG_.call(null,counts,x,(cljs.core._lookup.call(null,counts,x,0) + 1));
}),cljs.core.transient$.call(null,cljs.core.ObjMap.EMPTY),coll));
});
/**
* Returns a lazy seq of the intermediate values of the reduction (as
* per reduce) of coll by f, starting with init.
*/
cljs.core.reductions = (function() {
var reductions = null;
var reductions__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,false,(function (){
var temp__3971__auto____15011 = cljs.core.seq.call(null,coll);
if(temp__3971__auto____15011)
{var s__15012 = temp__3971__auto____15011;
return reductions.call(null,f,cljs.core.first.call(null,s__15012),cljs.core.rest.call(null,s__15012));
} else
{return cljs.core.list.call(null,f.call(null));
}
}),null));
});
var reductions__3 = (function (f,init,coll){
return cljs.core.cons.call(null,init,(new cljs.core.LazySeq(null,false,(function (){
var temp__3974__auto____15013 = cljs.core.seq.call(null,coll);
if(temp__3974__auto____15013)
{var s__15014 = temp__3974__auto____15013;
return reductions.call(null,f,f.call(null,init,cljs.core.first.call(null,s__15014)),cljs.core.rest.call(null,s__15014));
} else
{return null;
}
}),null)));
});
reductions = function(f,init,coll){
switch(arguments.length){
case 2:
return reductions__2.call(this,f,init);
case 3:
return reductions__3.call(this,f,init,coll);
}
throw('Invalid arity: ' + arguments.length);
};
reductions.cljs$lang$arity$2 = reductions__2;
reductions.cljs$lang$arity$3 = reductions__3;
return reductions;
})()
;
/**
* Takes a set of functions and returns a fn that is the juxtaposition
* of those fns.  The returned fn takes a variable number of args, and
* returns a vector containing the result of applying each fn to the
* args (left-to-right).
* ((juxt a b c) x) => [(a x) (b x) (c x)]
* @param {...*} var_args
*/
cljs.core.juxt = (function() {
var juxt = null;
var juxt__1 = (function (f){
return (function() {
var G__15017 = null;
var G__15017__0 = (function (){
return cljs.core.vector.call(null,f.call(null));
});
var G__15017__1 = (function (x){
return cljs.core.vector.call(null,f.call(null,x));
});
var G__15017__2 = (function (x,y){
return cljs.core.vector.call(null,f.call(null,x,y));
});
var G__15017__3 = (function (x,y,z){
return cljs.core.vector.call(null,f.call(null,x,y,z));
});
var G__15017__4 = (function() { 
var G__15018__delegate = function (x,y,z,args){
return cljs.core.vector.call(null,cljs.core.apply.call(null,f,x,y,z,args));
};
var G__15018 = function (x,y,z,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__15018__delegate.call(this, x, y, z, args);
};
G__15018.cljs$lang$maxFixedArity = 3;
G__15018.cljs$lang$applyTo = (function (arglist__15019){
var x = cljs.core.first(arglist__15019);
var y = cljs.core.first(cljs.core.next(arglist__15019));
var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__15019)));
var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__15019)));
return G__15018__delegate(x, y, z, args);
});
G__15018.cljs$lang$arity$variadic = G__15018__delegate;
return G__15018;
})()
;
G__15017 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__15017__0.call(this);
case 1:
return G__15017__1.call(this,x);
case 2:
return G__15017__2.call(this,x,y);
case 3:
return G__15017__3.call(this,x,y,z);
default:
return G__15017__4.cljs$lang$arity$variadic(x,y,z, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
G__15017.cljs$lang$maxFixedArity = 3;
G__15017.cljs$lang$applyTo = G__15017__4.cljs$lang$applyTo;
return G__15017;
})()
});
var juxt__2 = (function (f,g){
return (function() {
var G__15020 = null;
var G__15020__0 = (function (){
return cljs.core.vector.call(null,f.call(null),g.call(null));
});
var G__15020__1 = (function (x){
return cljs.core.vector.call(null,f.call(null,x),g.call(null,x));
});
var G__15020__2 = (function (x,y){
return cljs.core.vector.call(null,f.call(null,x,y),g.call(null,x,y));
});
var G__15020__3 = (function (x,y,z){
return cljs.core.vector.call(null,f.call(null,x,y,z),g.call(null,x,y,z));
});
var G__15020__4 = (function() { 
var G__15021__delegate = function (x,y,z,args){
return cljs.core.vector.call(null,cljs.core.apply.call(null,f,x,y,z,args),cljs.core.apply.call(null,g,x,y,z,args));
};
var G__15021 = function (x,y,z,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__15021__delegate.call(this, x, y, z, args);
};
G__15021.cljs$lang$maxFixedArity = 3;
G__15021.cljs$lang$applyTo = (function (arglist__15022){
var x = cljs.core.first(arglist__15022);
var y = cljs.core.first(cljs.core.next(arglist__15022));
var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__15022)));
var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__15022)));
return G__15021__delegate(x, y, z, args);
});
G__15021.cljs$lang$arity$variadic = G__15021__delegate;
return G__15021;
})()
;
G__15020 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__15020__0.call(this);
case 1:
return G__15020__1.call(this,x);
case 2:
return G__15020__2.call(this,x,y);
case 3:
return G__15020__3.call(this,x,y,z);
default:
return G__15020__4.cljs$lang$arity$variadic(x,y,z, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
G__15020.cljs$lang$maxFixedArity = 3;
G__15020.cljs$lang$applyTo = G__15020__4.cljs$lang$applyTo;
return G__15020;
})()
});
var juxt__3 = (function (f,g,h){
return (function() {
var G__15023 = null;
var G__15023__0 = (function (){
return cljs.core.vector.call(null,f.call(null),g.call(null),h.call(null));
});
var G__15023__1 = (function (x){
return cljs.core.vector.call(null,f.call(null,x),g.call(null,x),h.call(null,x));
});
var G__15023__2 = (function (x,y){
return cljs.core.vector.call(null,f.call(null,x,y),g.call(null,x,y),h.call(null,x,y));
});
var G__15023__3 = (function (x,y,z){
return cljs.core.vector.call(null,f.call(null,x,y,z),g.call(null,x,y,z),h.call(null,x,y,z));
});
var G__15023__4 = (function() { 
var G__15024__delegate = function (x,y,z,args){
return cljs.core.vector.call(null,cljs.core.apply.call(null,f,x,y,z,args),cljs.core.apply.call(null,g,x,y,z,args),cljs.core.apply.call(null,h,x,y,z,args));
};
var G__15024 = function (x,y,z,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__15024__delegate.call(this, x, y, z, args);
};
G__15024.cljs$lang$maxFixedArity = 3;
G__15024.cljs$lang$applyTo = (function (arglist__15025){
var x = cljs.core.first(arglist__15025);
var y = cljs.core.first(cljs.core.next(arglist__15025));
var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__15025)));
var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__15025)));
return G__15024__delegate(x, y, z, args);
});
G__15024.cljs$lang$arity$variadic = G__15024__delegate;
return G__15024;
})()
;
G__15023 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__15023__0.call(this);
case 1:
return G__15023__1.call(this,x);
case 2:
return G__15023__2.call(this,x,y);
case 3:
return G__15023__3.call(this,x,y,z);
default:
return G__15023__4.cljs$lang$arity$variadic(x,y,z, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
G__15023.cljs$lang$maxFixedArity = 3;
G__15023.cljs$lang$applyTo = G__15023__4.cljs$lang$applyTo;
return G__15023;
})()
});
var juxt__4 = (function() { 
var G__15026__delegate = function (f,g,h,fs){
var fs__15016 = cljs.core.list_STAR_.call(null,f,g,h,fs);
return (function() {
var G__15027 = null;
var G__15027__0 = (function (){
return cljs.core.reduce.call(null,(function (p1__14997_SHARP_,p2__14998_SHARP_){
return cljs.core.conj.call(null,p1__14997_SHARP_,p2__14998_SHARP_.call(null));
}),cljs.core.PersistentVector.EMPTY,fs__15016);
});
var G__15027__1 = (function (x){
return cljs.core.reduce.call(null,(function (p1__14999_SHARP_,p2__15000_SHARP_){
return cljs.core.conj.call(null,p1__14999_SHARP_,p2__15000_SHARP_.call(null,x));
}),cljs.core.PersistentVector.EMPTY,fs__15016);
});
var G__15027__2 = (function (x,y){
return cljs.core.reduce.call(null,(function (p1__15001_SHARP_,p2__15002_SHARP_){
return cljs.core.conj.call(null,p1__15001_SHARP_,p2__15002_SHARP_.call(null,x,y));
}),cljs.core.PersistentVector.EMPTY,fs__15016);
});
var G__15027__3 = (function (x,y,z){
return cljs.core.reduce.call(null,(function (p1__15003_SHARP_,p2__15004_SHARP_){
return cljs.core.conj.call(null,p1__15003_SHARP_,p2__15004_SHARP_.call(null,x,y,z));
}),cljs.core.PersistentVector.EMPTY,fs__15016);
});
var G__15027__4 = (function() { 
var G__15028__delegate = function (x,y,z,args){
return cljs.core.reduce.call(null,(function (p1__15005_SHARP_,p2__15006_SHARP_){
return cljs.core.conj.call(null,p1__15005_SHARP_,cljs.core.apply.call(null,p2__15006_SHARP_,x,y,z,args));
}),cljs.core.PersistentVector.EMPTY,fs__15016);
};
var G__15028 = function (x,y,z,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__15028__delegate.call(this, x, y, z, args);
};
G__15028.cljs$lang$maxFixedArity = 3;
G__15028.cljs$lang$applyTo = (function (arglist__15029){
var x = cljs.core.first(arglist__15029);
var y = cljs.core.first(cljs.core.next(arglist__15029));
var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__15029)));
var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__15029)));
return G__15028__delegate(x, y, z, args);
});
G__15028.cljs$lang$arity$variadic = G__15028__delegate;
return G__15028;
})()
;
G__15027 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__15027__0.call(this);
case 1:
return G__15027__1.call(this,x);
case 2:
return G__15027__2.call(this,x,y);
case 3:
return G__15027__3.call(this,x,y,z);
default:
return G__15027__4.cljs$lang$arity$variadic(x,y,z, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
G__15027.cljs$lang$maxFixedArity = 3;
G__15027.cljs$lang$applyTo = G__15027__4.cljs$lang$applyTo;
return G__15027;
})()
};
var G__15026 = function (f,g,h,var_args){
var fs = null;
if (goog.isDef(var_args)) {
  fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3),0);
} 
return G__15026__delegate.call(this, f, g, h, fs);
};
G__15026.cljs$lang$maxFixedArity = 3;
G__15026.cljs$lang$applyTo = (function (arglist__15030){
var f = cljs.core.first(arglist__15030);
var g = cljs.core.first(cljs.core.next(arglist__15030));
var h = cljs.core.first(cljs.core.next(cljs.core.next(arglist__15030)));
var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__15030)));
return G__15026__delegate(f, g, h, fs);
});
G__15026.cljs$lang$arity$variadic = G__15026__delegate;
return G__15026;
})()
;
juxt = function(f,g,h,var_args){
var fs = var_args;
switch(arguments.length){
case 1:
return juxt__1.call(this,f);
case 2:
return juxt__2.call(this,f,g);
case 3:
return juxt__3.call(this,f,g,h);
default:
return juxt__4.cljs$lang$arity$variadic(f,g,h, cljs.core.array_seq(arguments, 3));
}
throw('Invalid arity: ' + arguments.length);
};
juxt.cljs$lang$maxFixedArity = 3;
juxt.cljs$lang$applyTo = juxt__4.cljs$lang$applyTo;
juxt.cljs$lang$arity$1 = juxt__1;
juxt.cljs$lang$arity$2 = juxt__2;
juxt.cljs$lang$arity$3 = juxt__3;
juxt.cljs$lang$arity$variadic = juxt__4.cljs$lang$arity$variadic;
return juxt;
})()
;
/**
* When lazy sequences are produced via functions that have side
* effects, any effects other than those needed to produce the first
* element in the seq do not occur until the seq is consumed. dorun can
* be used to force any effects. Walks through the successive nexts of
* the seq, does not retain the head and returns nil.
*/
cljs.core.dorun = (function() {
var dorun = null;
var dorun__1 = (function (coll){
while(true){
if(cljs.core.seq.call(null,coll))
{{
var G__15033 = cljs.core.next.call(null,coll);
coll = G__15033;
continue;
}
} else
{return null;
}
break;
}
});
var dorun__2 = (function (n,coll){
while(true){
if(cljs.core.truth_((function (){var and__3822__auto____15032 = cljs.core.seq.call(null,coll);
if(and__3822__auto____15032)
{return (n > 0);
} else
{return and__3822__auto____15032;
}
})()))
{{
var G__15034 = (n - 1);
var G__15035 = cljs.core.next.call(null,coll);
n = G__15034;
coll = G__15035;
continue;
}
} else
{return null;
}
break;
}
});
dorun = function(n,coll){
switch(arguments.length){
case 1:
return dorun__1.call(this,n);
case 2:
return dorun__2.call(this,n,coll);
}
throw('Invalid arity: ' + arguments.length);
};
dorun.cljs$lang$arity$1 = dorun__1;
dorun.cljs$lang$arity$2 = dorun__2;
return dorun;
})()
;
/**
* When lazy sequences are produced via functions that have side
* effects, any effects other than those needed to produce the first
* element in the seq do not occur until the seq is consumed. doall can
* be used to force any effects. Walks through the successive nexts of
* the seq, retains the head and returns it, thus causing the entire
* seq to reside in memory at one time.
*/
cljs.core.doall = (function() {
var doall = null;
var doall__1 = (function (coll){
cljs.core.dorun.call(null,coll);
return coll;
});
var doall__2 = (function (n,coll){
cljs.core.dorun.call(null,n,coll);
return coll;
});
doall = function(n,coll){
switch(arguments.length){
case 1:
return doall__1.call(this,n);
case 2:
return doall__2.call(this,n,coll);
}
throw('Invalid arity: ' + arguments.length);
};
doall.cljs$lang$arity$1 = doall__1;
doall.cljs$lang$arity$2 = doall__2;
return doall;
})()
;
cljs.core.regexp_QMARK_ = (function regexp_QMARK_(o){
return o instanceof RegExp;
});
/**
* Returns the result of (re-find re s) if re fully matches s.
*/
cljs.core.re_matches = (function re_matches(re,s){
var matches__15037 = re.exec(s);
if(cljs.core._EQ_.call(null,cljs.core.first.call(null,matches__15037),s))
{if((cljs.core.count.call(null,matches__15037) === 1))
{return cljs.core.first.call(null,matches__15037);
} else
{return cljs.core.vec.call(null,matches__15037);
}
} else
{return null;
}
});
/**
* Returns the first regex match, if any, of s to re, using
* re.exec(s). Returns a vector, containing first the matching
* substring, then any capturing groups if the regular expression contains
* capturing groups.
*/
cljs.core.re_find = (function re_find(re,s){
var matches__15039 = re.exec(s);
if((matches__15039 == null))
{return null;
} else
{if((cljs.core.count.call(null,matches__15039) === 1))
{return cljs.core.first.call(null,matches__15039);
} else
{return cljs.core.vec.call(null,matches__15039);
}
}
});
/**
* Returns a lazy sequence of successive matches of re in s.
*/
cljs.core.re_seq = (function re_seq(re,s){
var match_data__15044 = cljs.core.re_find.call(null,re,s);
var match_idx__15045 = s.search(re);
var match_str__15046 = ((cljs.core.coll_QMARK_.call(null,match_data__15044))?cljs.core.first.call(null,match_data__15044):match_data__15044);
var post_match__15047 = cljs.core.subs.call(null,s,(match_idx__15045 + cljs.core.count.call(null,match_str__15046)));
if(cljs.core.truth_(match_data__15044))
{return (new cljs.core.LazySeq(null,false,(function (){
return cljs.core.cons.call(null,match_data__15044,re_seq.call(null,re,post_match__15047));
}),null));
} else
{return null;
}
});
/**
* Returns an instance of RegExp which has compiled the provided string.
*/
cljs.core.re_pattern = (function re_pattern(s){
var vec__15054__15055 = cljs.core.re_find.call(null,/^(?:\(\?([idmsux]*)\))?(.*)/,s);
var ___15056 = cljs.core.nth.call(null,vec__15054__15055,0,null);
var flags__15057 = cljs.core.nth.call(null,vec__15054__15055,1,null);
var pattern__15058 = cljs.core.nth.call(null,vec__15054__15055,2,null);
return (new RegExp(pattern__15058,flags__15057));
});
cljs.core.pr_sequential = (function pr_sequential(print_one,begin,sep,end,opts,coll){
return cljs.core.concat.call(null,cljs.core.PersistentVector.fromArray([begin], true),cljs.core.flatten1.call(null,cljs.core.interpose.call(null,cljs.core.PersistentVector.fromArray([sep], true),cljs.core.map.call(null,(function (p1__15048_SHARP_){
return print_one.call(null,p1__15048_SHARP_,opts);
}),coll))),cljs.core.PersistentVector.fromArray([end], true));
});
cljs.core.string_print = (function string_print(x){
cljs.core._STAR_print_fn_STAR_.call(null,x);
return null;
});
cljs.core.flush = (function flush(){
return null;
});
cljs.core.pr_seq = (function pr_seq(obj,opts){
if((obj == null))
{return cljs.core.list.call(null,"nil");
} else
{if((void 0 === obj))
{return cljs.core.list.call(null,"#<undefined>");
} else
{if("\uFDD0'else")
{return cljs.core.concat.call(null,(cljs.core.truth_((function (){var and__3822__auto____15068 = cljs.core._lookup.call(null,opts,"\uFDD0'meta",null);
if(cljs.core.truth_(and__3822__auto____15068))
{var and__3822__auto____15072 = (function (){var G__15069__15070 = obj;
if(G__15069__15070)
{if((function (){var or__3824__auto____15071 = (G__15069__15070.cljs$lang$protocol_mask$partition0$ & 131072);
if(or__3824__auto____15071)
{return or__3824__auto____15071;
} else
{return G__15069__15070.cljs$core$IMeta$;
}
})())
{return true;
} else
{if((!G__15069__15070.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IMeta,G__15069__15070);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IMeta,G__15069__15070);
}
})();
if(cljs.core.truth_(and__3822__auto____15072))
{return cljs.core.meta.call(null,obj);
} else
{return and__3822__auto____15072;
}
} else
{return and__3822__auto____15068;
}
})())?cljs.core.concat.call(null,cljs.core.PersistentVector.fromArray(["^"], true),pr_seq.call(null,cljs.core.meta.call(null,obj),opts),cljs.core.PersistentVector.fromArray([" "], true)):null),(((function (){var and__3822__auto____15073 = !((obj == null));
if(and__3822__auto____15073)
{return obj.cljs$lang$type;
} else
{return and__3822__auto____15073;
}
})())?obj.cljs$lang$ctorPrSeq(obj):(((function (){var G__15074__15075 = obj;
if(G__15074__15075)
{if((function (){var or__3824__auto____15076 = (G__15074__15075.cljs$lang$protocol_mask$partition0$ & 536870912);
if(or__3824__auto____15076)
{return or__3824__auto____15076;
} else
{return G__15074__15075.cljs$core$IPrintable$;
}
})())
{return true;
} else
{if((!G__15074__15075.cljs$lang$protocol_mask$partition0$))
{return cljs.core.type_satisfies_.call(null,cljs.core.IPrintable,G__15074__15075);
} else
{return false;
}
}
} else
{return cljs.core.type_satisfies_.call(null,cljs.core.IPrintable,G__15074__15075);
}
})())?cljs.core._pr_seq.call(null,obj,opts):(cljs.core.truth_(cljs.core.regexp_QMARK_.call(null,obj))?cljs.core.list.call(null,"#\"",obj.source,"\""):(("\uFDD0'else")?cljs.core.list.call(null,"#<",[cljs.core.str(obj)].join(''),">"):null)))));
} else
{return null;
}
}
}
});
cljs.core.pr_sb = (function pr_sb(objs,opts){
var sb__15096 = (new goog.string.StringBuffer());
var G__15097__15098 = cljs.core.seq.call(null,cljs.core.pr_seq.call(null,cljs.core.first.call(null,objs),opts));
if(G__15097__15098)
{var string__15099 = cljs.core.first.call(null,G__15097__15098);
var G__15097__15100 = G__15097__15098;
while(true){
sb__15096.append(string__15099);
var temp__3974__auto____15101 = cljs.core.next.call(null,G__15097__15100);
if(temp__3974__auto____15101)
{var G__15097__15102 = temp__3974__auto____15101;
{
var G__15115 = cljs.core.first.call(null,G__15097__15102);
var G__15116 = G__15097__15102;
string__15099 = G__15115;
G__15097__15100 = G__15116;
continue;
}
} else
{}
break;
}
} else
{}
var G__15103__15104 = cljs.core.seq.call(null,cljs.core.next.call(null,objs));
if(G__15103__15104)
{var obj__15105 = cljs.core.first.call(null,G__15103__15104);
var G__15103__15106 = G__15103__15104;
while(true){
sb__15096.append(" ");
var G__15107__15108 = cljs.core.seq.call(null,cljs.core.pr_seq.call(null,obj__15105,opts));
if(G__15107__15108)
{var string__15109 = cljs.core.first.call(null,G__15107__15108);
var G__15107__15110 = G__15107__15108;
while(true){
sb__15096.append(string__15109);
var temp__3974__auto____15111 = cljs.core.next.call(null,G__15107__15110);
if(temp__3974__auto____15111)
{var G__15107__15112 = temp__3974__auto____15111;
{
var G__15117 = cljs.core.first.call(null,G__15107__15112);
var G__15118 = G__15107__15112;
string__15109 = G__15117;
G__15107__15110 = G__15118;
continue;
}
} else
{}
break;
}
} else
{}
var temp__3974__auto____15113 = cljs.core.next.call(null,G__15103__15106);
if(temp__3974__auto____15113)
{var G__15103__15114 = temp__3974__auto____15113;
{
var G__15119 = cljs.core.first.call(null,G__15103__15114);
var G__15120 = G__15103__15114;
obj__15105 = G__15119;
G__15103__15106 = G__15120;
continue;
}
} else
{}
break;
}
} else
{}
return sb__15096;
});
/**
* Prints a sequence of objects to a string, observing all the
* options given in opts
*/
cljs.core.pr_str_with_opts = (function pr_str_with_opts(objs,opts){
return [cljs.core.str(cljs.core.pr_sb.call(null,objs,opts))].join('');
});
/**
* Same as pr-str-with-opts followed by (newline)
*/
cljs.core.prn_str_with_opts = (function prn_str_with_opts(objs,opts){
var sb__15122 = cljs.core.pr_sb.call(null,objs,opts);
sb__15122.append("\n");
return [cljs.core.str(sb__15122)].join('');
});
/**
* Prints a sequence of objects using string-print, observing all
* the options given in opts
*/
cljs.core.pr_with_opts = (function pr_with_opts(objs,opts){
var G__15141__15142 = cljs.core.seq.call(null,cljs.core.pr_seq.call(null,cljs.core.first.call(null,objs),opts));
if(G__15141__15142)
{var string__15143 = cljs.core.first.call(null,G__15141__15142);
var G__15141__15144 = G__15141__15142;
while(true){
cljs.core.string_print.call(null,string__15143);
var temp__3974__auto____15145 = cljs.core.next.call(null,G__15141__15144);
if(temp__3974__auto____15145)
{var G__15141__15146 = temp__3974__auto____15145;
{
var G__15159 = cljs.core.first.call(null,G__15141__15146);
var G__15160 = G__15141__15146;
string__15143 = G__15159;
G__15141__15144 = G__15160;
continue;
}
} else
{}
break;
}
} else
{}
var G__15147__15148 = cljs.core.seq.call(null,cljs.core.next.call(null,objs));
if(G__15147__15148)
{var obj__15149 = cljs.core.first.call(null,G__15147__15148);
var G__15147__15150 = G__15147__15148;
while(true){
cljs.core.string_print.call(null," ");
var G__15151__15152 = cljs.core.seq.call(null,cljs.core.pr_seq.call(null,obj__15149,opts));
if(G__15151__15152)
{var string__15153 = cljs.core.first.call(null,G__15151__15152);
var G__15151__15154 = G__15151__15152;
while(true){
cljs.core.string_print.call(null,string__15153);
var temp__3974__auto____15155 = cljs.core.next.call(null,G__15151__15154);
if(temp__3974__auto____15155)
{var G__15151__15156 = temp__3974__auto____15155;
{
var G__15161 = cljs.core.first.call(null,G__15151__15156);
var G__15162 = G__15151__15156;
string__15153 = G__15161;
G__15151__15154 = G__15162;
continue;
}
} else
{}
break;
}
} else
{}
var temp__3974__auto____15157 = cljs.core.next.call(null,G__15147__15150);
if(temp__3974__auto____15157)
{var G__15147__15158 = temp__3974__auto____15157;
{
var G__15163 = cljs.core.first.call(null,G__15147__15158);
var G__15164 = G__15147__15158;
obj__15149 = G__15163;
G__15147__15150 = G__15164;
continue;
}
} else
{return null;
}
break;
}
} else
{return null;
}
});
cljs.core.newline = (function newline(opts){
cljs.core.string_print.call(null,"\n");
if(cljs.core.truth_(cljs.core._lookup.call(null,opts,"\uFDD0'flush-on-newline",null)))
{return cljs.core.flush.call(null);
} else
{return null;
}
});
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core.pr_opts = (function pr_opts(){
return cljs.core.ObjMap.fromObject(["\uFDD0'flush-on-newline","\uFDD0'readably","\uFDD0'meta","\uFDD0'dup"],{"\uFDD0'flush-on-newline":cljs.core._STAR_flush_on_newline_STAR_,"\uFDD0'readably":cljs.core._STAR_print_readably_STAR_,"\uFDD0'meta":cljs.core._STAR_print_meta_STAR_,"\uFDD0'dup":cljs.core._STAR_print_dup_STAR_});
});
/**
* pr to a string, returning it. Fundamental entrypoint to IPrintable.
* @param {...*} var_args
*/
cljs.core.pr_str = (function() { 
var pr_str__delegate = function (objs){
return cljs.core.pr_str_with_opts.call(null,objs,cljs.core.pr_opts.call(null));
};
var pr_str = function (var_args){
var objs = null;
if (goog.isDef(var_args)) {
  objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return pr_str__delegate.call(this, objs);
};
pr_str.cljs$lang$maxFixedArity = 0;
pr_str.cljs$lang$applyTo = (function (arglist__15165){
var objs = cljs.core.seq(arglist__15165);;
return pr_str__delegate(objs);
});
pr_str.cljs$lang$arity$variadic = pr_str__delegate;
return pr_str;
})()
;
/**
* Same as pr-str followed by (newline)
* @param {...*} var_args
*/
cljs.core.prn_str = (function() { 
var prn_str__delegate = function (objs){
return cljs.core.prn_str_with_opts.call(null,objs,cljs.core.pr_opts.call(null));
};
var prn_str = function (var_args){
var objs = null;
if (goog.isDef(var_args)) {
  objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return prn_str__delegate.call(this, objs);
};
prn_str.cljs$lang$maxFixedArity = 0;
prn_str.cljs$lang$applyTo = (function (arglist__15166){
var objs = cljs.core.seq(arglist__15166);;
return prn_str__delegate(objs);
});
prn_str.cljs$lang$arity$variadic = prn_str__delegate;
return prn_str;
})()
;
/**
* Prints the object(s) using string-print.  Prints the
* object(s), separated by spaces if there is more than one.
* By default, pr and prn print in a way that objects can be
* read by the reader
* @param {...*} var_args
*/
cljs.core.pr = (function() { 
var pr__delegate = function (objs){
return cljs.core.pr_with_opts.call(null,objs,cljs.core.pr_opts.call(null));
};
var pr = function (var_args){
var objs = null;
if (goog.isDef(var_args)) {
  objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return pr__delegate.call(this, objs);
};
pr.cljs$lang$maxFixedArity = 0;
pr.cljs$lang$applyTo = (function (arglist__15167){
var objs = cljs.core.seq(arglist__15167);;
return pr__delegate(objs);
});
pr.cljs$lang$arity$variadic = pr__delegate;
return pr;
})()
;
/**
* Prints the object(s) using string-print.
* print and println produce output for human consumption.
* @param {...*} var_args
*/
cljs.core.print = (function() { 
var cljs_core_print__delegate = function (objs){
return cljs.core.pr_with_opts.call(null,objs,cljs.core.assoc.call(null,cljs.core.pr_opts.call(null),"\uFDD0'readably",false));
};
var cljs_core_print = function (var_args){
var objs = null;
if (goog.isDef(var_args)) {
  objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return cljs_core_print__delegate.call(this, objs);
};
cljs_core_print.cljs$lang$maxFixedArity = 0;
cljs_core_print.cljs$lang$applyTo = (function (arglist__15168){
var objs = cljs.core.seq(arglist__15168);;
return cljs_core_print__delegate(objs);
});
cljs_core_print.cljs$lang$arity$variadic = cljs_core_print__delegate;
return cljs_core_print;
})()
;
/**
* print to a string, returning it
* @param {...*} var_args
*/
cljs.core.print_str = (function() { 
var print_str__delegate = function (objs){
return cljs.core.pr_str_with_opts.call(null,objs,cljs.core.assoc.call(null,cljs.core.pr_opts.call(null),"\uFDD0'readably",false));
};
var print_str = function (var_args){
var objs = null;
if (goog.isDef(var_args)) {
  objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return print_str__delegate.call(this, objs);
};
print_str.cljs$lang$maxFixedArity = 0;
print_str.cljs$lang$applyTo = (function (arglist__15169){
var objs = cljs.core.seq(arglist__15169);;
return print_str__delegate(objs);
});
print_str.cljs$lang$arity$variadic = print_str__delegate;
return print_str;
})()
;
/**
* Same as print followed by (newline)
* @param {...*} var_args
*/
cljs.core.println = (function() { 
var println__delegate = function (objs){
cljs.core.pr_with_opts.call(null,objs,cljs.core.assoc.call(null,cljs.core.pr_opts.call(null),"\uFDD0'readably",false));
return cljs.core.newline.call(null,cljs.core.pr_opts.call(null));
};
var println = function (var_args){
var objs = null;
if (goog.isDef(var_args)) {
  objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return println__delegate.call(this, objs);
};
println.cljs$lang$maxFixedArity = 0;
println.cljs$lang$applyTo = (function (arglist__15170){
var objs = cljs.core.seq(arglist__15170);;
return println__delegate(objs);
});
println.cljs$lang$arity$variadic = println__delegate;
return println;
})()
;
/**
* println to a string, returning it
* @param {...*} var_args
*/
cljs.core.println_str = (function() { 
var println_str__delegate = function (objs){
return cljs.core.prn_str_with_opts.call(null,objs,cljs.core.assoc.call(null,cljs.core.pr_opts.call(null),"\uFDD0'readably",false));
};
var println_str = function (var_args){
var objs = null;
if (goog.isDef(var_args)) {
  objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return println_str__delegate.call(this, objs);
};
println_str.cljs$lang$maxFixedArity = 0;
println_str.cljs$lang$applyTo = (function (arglist__15171){
var objs = cljs.core.seq(arglist__15171);;
return println_str__delegate(objs);
});
println_str.cljs$lang$arity$variadic = println_str__delegate;
return println_str;
})()
;
/**
* Same as pr followed by (newline).
* @param {...*} var_args
*/
cljs.core.prn = (function() { 
var prn__delegate = function (objs){
cljs.core.pr_with_opts.call(null,objs,cljs.core.pr_opts.call(null));
return cljs.core.newline.call(null,cljs.core.pr_opts.call(null));
};
var prn = function (var_args){
var objs = null;
if (goog.isDef(var_args)) {
  objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return prn__delegate.call(this, objs);
};
prn.cljs$lang$maxFixedArity = 0;
prn.cljs$lang$applyTo = (function (arglist__15172){
var objs = cljs.core.seq(arglist__15172);;
return prn__delegate(objs);
});
prn.cljs$lang$arity$variadic = prn__delegate;
return prn;
})()
;
/**
* Prints formatted output, as per format
* @param {...*} var_args
*/
cljs.core.printf = (function() { 
var printf__delegate = function (fmt,args){
return cljs.core.print.call(null,cljs.core.apply.call(null,cljs.core.format,fmt,args));
};
var printf = function (fmt,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);
} 
return printf__delegate.call(this, fmt, args);
};
printf.cljs$lang$maxFixedArity = 1;
printf.cljs$lang$applyTo = (function (arglist__15173){
var fmt = cljs.core.first(arglist__15173);
var args = cljs.core.rest(arglist__15173);
return printf__delegate(fmt, args);
});
printf.cljs$lang$arity$variadic = printf__delegate;
return printf;
})()
;
cljs.core.HashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.HashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
var pr_pair__15174 = (function (keyval){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,""," ","",opts,keyval);
});
return cljs.core.pr_sequential.call(null,pr_pair__15174,"{",", ","}",opts,coll);
});
(cljs.core.IPrintable["number"] = true);
(cljs.core._pr_seq["number"] = (function (n,opts){
return cljs.core.list.call(null,[cljs.core.str(n)].join(''));
}));
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"("," ",")",opts,coll);
});
cljs.core.Subvec.prototype.cljs$core$IPrintable$ = true;
cljs.core.Subvec.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"["," ","]",opts,coll);
});
cljs.core.ChunkedCons.prototype.cljs$core$IPrintable$ = true;
cljs.core.ChunkedCons.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"("," ",")",opts,coll);
});
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
var pr_pair__15175 = (function (keyval){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,""," ","",opts,keyval);
});
return cljs.core.pr_sequential.call(null,pr_pair__15175,"{",", ","}",opts,coll);
});
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
var pr_pair__15176 = (function (keyval){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,""," ","",opts,keyval);
});
return cljs.core.pr_sequential.call(null,pr_pair__15176,"{",", ","}",opts,coll);
});
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"#queue ["," ","]",opts,cljs.core.seq.call(null,coll));
});
cljs.core.LazySeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.LazySeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"("," ",")",opts,coll);
});
cljs.core.RSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.RSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"("," ",")",opts,coll);
});
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"#{"," ","}",opts,coll);
});
(cljs.core.IPrintable["boolean"] = true);
(cljs.core._pr_seq["boolean"] = (function (bool,opts){
return cljs.core.list.call(null,[cljs.core.str(bool)].join(''));
}));
(cljs.core.IPrintable["string"] = true);
(cljs.core._pr_seq["string"] = (function (obj,opts){
if(cljs.core.keyword_QMARK_.call(null,obj))
{return cljs.core.list.call(null,[cljs.core.str(":"),cljs.core.str((function (){var temp__3974__auto____15177 = cljs.core.namespace.call(null,obj);
if(cljs.core.truth_(temp__3974__auto____15177))
{var nspc__15178 = temp__3974__auto____15177;
return [cljs.core.str(nspc__15178),cljs.core.str("/")].join('');
} else
{return null;
}
})()),cljs.core.str(cljs.core.name.call(null,obj))].join(''));
} else
{if(cljs.core.symbol_QMARK_.call(null,obj))
{return cljs.core.list.call(null,[cljs.core.str((function (){var temp__3974__auto____15179 = cljs.core.namespace.call(null,obj);
if(cljs.core.truth_(temp__3974__auto____15179))
{var nspc__15180 = temp__3974__auto____15179;
return [cljs.core.str(nspc__15180),cljs.core.str("/")].join('');
} else
{return null;
}
})()),cljs.core.str(cljs.core.name.call(null,obj))].join(''));
} else
{if("\uFDD0'else")
{return cljs.core.list.call(null,(cljs.core.truth_((new cljs.core.Keyword("\uFDD0'readably")).call(null,opts))?goog.string.quote(obj):obj));
} else
{return null;
}
}
}
}));
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"("," ",")",opts,coll);
});
cljs.core.RedNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.RedNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"["," ","]",opts,coll);
});
cljs.core.ChunkedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.ChunkedSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"("," ",")",opts,coll);
});
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
var pr_pair__15181 = (function (keyval){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,""," ","",opts,keyval);
});
return cljs.core.pr_sequential.call(null,pr_pair__15181,"{",", ","}",opts,coll);
});
cljs.core.Vector.prototype.cljs$core$IPrintable$ = true;
cljs.core.Vector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"["," ","]",opts,coll);
});
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"#{"," ","}",opts,coll);
});
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"["," ","]",opts,coll);
});
cljs.core.List.prototype.cljs$core$IPrintable$ = true;
cljs.core.List.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"("," ",")",opts,coll);
});
(cljs.core.IPrintable["array"] = true);
(cljs.core._pr_seq["array"] = (function (a,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"#<Array [",", ","]>",opts,a);
}));
(cljs.core.IPrintable["function"] = true);
(cljs.core._pr_seq["function"] = (function (this$){
return cljs.core.list.call(null,"#<",[cljs.core.str(this$)].join(''),">");
}));
cljs.core.EmptyList.prototype.cljs$core$IPrintable$ = true;
cljs.core.EmptyList.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.list.call(null,"()");
});
cljs.core.BlackNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.BlackNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"["," ","]",opts,coll);
});
Date.prototype.cljs$core$IPrintable$ = true;
Date.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (d,_){
var normalize__15183 = (function (n,len){
var ns__15182 = [cljs.core.str(n)].join('');
while(true){
if((cljs.core.count.call(null,ns__15182) < len))
{{
var G__15185 = [cljs.core.str("0"),cljs.core.str(ns__15182)].join('');
ns__15182 = G__15185;
continue;
}
} else
{return ns__15182;
}
break;
}
});
return cljs.core.list.call(null,[cljs.core.str("#inst \""),cljs.core.str(d.getUTCFullYear()),cljs.core.str("-"),cljs.core.str(normalize__15183.call(null,(d.getUTCMonth() + 1),2)),cljs.core.str("-"),cljs.core.str(normalize__15183.call(null,d.getUTCDate(),2)),cljs.core.str("T"),cljs.core.str(normalize__15183.call(null,d.getUTCHours(),2)),cljs.core.str(":"),cljs.core.str(normalize__15183.call(null,d.getUTCMinutes(),2)),cljs.core.str(":"),cljs.core.str(normalize__15183.call(null,d.getUTCSeconds(),2)),cljs.core.str("."),cljs.core.str(normalize__15183.call(null,d.getUTCMilliseconds(),3)),cljs.core.str("-"),cljs.core.str("00:00\"")].join(''));
});
cljs.core.Cons.prototype.cljs$core$IPrintable$ = true;
cljs.core.Cons.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"("," ",")",opts,coll);
});
cljs.core.Range.prototype.cljs$core$IPrintable$ = true;
cljs.core.Range.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"("," ",")",opts,coll);
});
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"("," ",")",opts,coll);
});
cljs.core.ObjMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.ObjMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
var pr_pair__15184 = (function (keyval){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,""," ","",opts,keyval);
});
return cljs.core.pr_sequential.call(null,pr_pair__15184,"{",", ","}",opts,coll);
});
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (coll,opts){
return cljs.core.pr_sequential.call(null,cljs.core.pr_seq,"("," ",")",opts,coll);
});
cljs.core.PersistentVector.prototype.cljs$core$IComparable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
return cljs.core.compare_indexed.call(null,x,y);
});

/**
* @constructor
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2690809856;
})
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/Atom");
});
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this__15186 = this;
return goog.getUid(this$);
});
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var this__15187 = this;
var G__15188__15189 = cljs.core.seq.call(null,this__15187.watches);
if(G__15188__15189)
{var G__15191__15193 = cljs.core.first.call(null,G__15188__15189);
var vec__15192__15194 = G__15191__15193;
var key__15195 = cljs.core.nth.call(null,vec__15192__15194,0,null);
var f__15196 = cljs.core.nth.call(null,vec__15192__15194,1,null);
var G__15188__15197 = G__15188__15189;
var G__15191__15198 = G__15191__15193;
var G__15188__15199 = G__15188__15197;
while(true){
var vec__15200__15201 = G__15191__15198;
var key__15202 = cljs.core.nth.call(null,vec__15200__15201,0,null);
var f__15203 = cljs.core.nth.call(null,vec__15200__15201,1,null);
var G__15188__15204 = G__15188__15199;
f__15203.call(null,key__15202,this$,oldval,newval);
var temp__3974__auto____15205 = cljs.core.next.call(null,G__15188__15204);
if(temp__3974__auto____15205)
{var G__15188__15206 = temp__3974__auto____15205;
{
var G__15213 = cljs.core.first.call(null,G__15188__15206);
var G__15214 = G__15188__15206;
G__15191__15198 = G__15213;
G__15188__15199 = G__15214;
continue;
}
} else
{return null;
}
break;
}
} else
{return null;
}
});
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var this__15207 = this;
return this$.watches = cljs.core.assoc.call(null,this__15207.watches,key,f);
});
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var this__15208 = this;
return this$.watches = cljs.core.dissoc.call(null,this__15208.watches,key);
});
cljs.core.Atom.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (a,opts){
var this__15209 = this;
return cljs.core.concat.call(null,cljs.core.PersistentVector.fromArray(["#<Atom: "], true),cljs.core._pr_seq.call(null,this__15209.state,opts),">");
});
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var this__15210 = this;
return this__15210.meta;
});
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var this__15211 = this;
return this__15211.state;
});
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var this__15212 = this;
return (o === other);
});
cljs.core.Atom;
/**
* Creates and returns an Atom with an initial value of x and zero or
* more options (in any order):
* 
* :meta metadata-map
* 
* :validator validate-fn
* 
* If metadata-map is supplied, it will be come the metadata on the
* atom. validate-fn must be nil or a side-effect-free fn of one
* argument, which will be passed the intended new state on any state
* change. If the new state is unacceptable, the validate-fn should
* return false or throw an Error.  If either of these error conditions
* occur, then the value of the atom will not change.
* @param {...*} var_args
*/
cljs.core.atom = (function() {
var atom = null;
var atom__1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
});
var atom__2 = (function() { 
var G__15226__delegate = function (x,p__15215){
var map__15221__15222 = p__15215;
var map__15221__15223 = ((cljs.core.seq_QMARK_.call(null,map__15221__15222))?cljs.core.apply.call(null,cljs.core.hash_map,map__15221__15222):map__15221__15222);
var validator__15224 = cljs.core._lookup.call(null,map__15221__15223,"\uFDD0'validator",null);
var meta__15225 = cljs.core._lookup.call(null,map__15221__15223,"\uFDD0'meta",null);
return (new cljs.core.Atom(x,meta__15225,validator__15224,null));
};
var G__15226 = function (x,var_args){
var p__15215 = null;
if (goog.isDef(var_args)) {
  p__15215 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);
} 
return G__15226__delegate.call(this, x, p__15215);
};
G__15226.cljs$lang$maxFixedArity = 1;
G__15226.cljs$lang$applyTo = (function (arglist__15227){
var x = cljs.core.first(arglist__15227);
var p__15215 = cljs.core.rest(arglist__15227);
return G__15226__delegate(x, p__15215);
});
G__15226.cljs$lang$arity$variadic = G__15226__delegate;
return G__15226;
})()
;
atom = function(x,var_args){
var p__15215 = var_args;
switch(arguments.length){
case 1:
return atom__1.call(this,x);
default:
return atom__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1));
}
throw('Invalid arity: ' + arguments.length);
};
atom.cljs$lang$maxFixedArity = 1;
atom.cljs$lang$applyTo = atom__2.cljs$lang$applyTo;
atom.cljs$lang$arity$1 = atom__1;
atom.cljs$lang$arity$variadic = atom__2.cljs$lang$arity$variadic;
return atom;
})()
;
/**
* Sets the value of atom to newval without regard for the
* current value. Returns newval.
*/
cljs.core.reset_BANG_ = (function reset_BANG_(a,new_value){
var temp__3974__auto____15231 = a.validator;
if(cljs.core.truth_(temp__3974__auto____15231))
{var validate__15232 = temp__3974__auto____15231;
if(cljs.core.truth_(validate__15232.call(null,new_value)))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Validator rejected reference state"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.with_meta(cljs.core.list("\uFDD1'validate","\uFDD1'new-value"),cljs.core.hash_map("\uFDD0'line",6440))))].join('')));
}
} else
{}
var old_value__15233 = a.state;
a.state = new_value;
cljs.core._notify_watches.call(null,a,old_value__15233,new_value);
return new_value;
});
/**
* Atomically swaps the value of atom to be:
* (apply f current-value-of-atom args). Note that f may be called
* multiple times, and thus should be free of side effects.  Returns
* the value that was swapped in.
* @param {...*} var_args
*/
cljs.core.swap_BANG_ = (function() {
var swap_BANG_ = null;
var swap_BANG___2 = (function (a,f){
return cljs.core.reset_BANG_.call(null,a,f.call(null,a.state));
});
var swap_BANG___3 = (function (a,f,x){
return cljs.core.reset_BANG_.call(null,a,f.call(null,a.state,x));
});
var swap_BANG___4 = (function (a,f,x,y){
return cljs.core.reset_BANG_.call(null,a,f.call(null,a.state,x,y));
});
var swap_BANG___5 = (function (a,f,x,y,z){
return cljs.core.reset_BANG_.call(null,a,f.call(null,a.state,x,y,z));
});
var swap_BANG___6 = (function() { 
var G__15234__delegate = function (a,f,x,y,z,more){
return cljs.core.reset_BANG_.call(null,a,cljs.core.apply.call(null,f,a.state,x,y,z,more));
};
var G__15234 = function (a,f,x,y,z,var_args){
var more = null;
if (goog.isDef(var_args)) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5),0);
} 
return G__15234__delegate.call(this, a, f, x, y, z, more);
};
G__15234.cljs$lang$maxFixedArity = 5;
G__15234.cljs$lang$applyTo = (function (arglist__15235){
var a = cljs.core.first(arglist__15235);
var f = cljs.core.first(cljs.core.next(arglist__15235));
var x = cljs.core.first(cljs.core.next(cljs.core.next(arglist__15235)));
var y = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__15235))));
var z = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__15235)))));
var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__15235)))));
return G__15234__delegate(a, f, x, y, z, more);
});
G__15234.cljs$lang$arity$variadic = G__15234__delegate;
return G__15234;
})()
;
swap_BANG_ = function(a,f,x,y,z,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return swap_BANG___2.call(this,a,f);
case 3:
return swap_BANG___3.call(this,a,f,x);
case 4:
return swap_BANG___4.call(this,a,f,x,y);
case 5:
return swap_BANG___5.call(this,a,f,x,y,z);
default:
return swap_BANG___6.cljs$lang$arity$variadic(a,f,x,y,z, cljs.core.array_seq(arguments, 5));
}
throw('Invalid arity: ' + arguments.length);
};
swap_BANG_.cljs$lang$maxFixedArity = 5;
swap_BANG_.cljs$lang$applyTo = swap_BANG___6.cljs$lang$applyTo;
swap_BANG_.cljs$lang$arity$2 = swap_BANG___2;
swap_BANG_.cljs$lang$arity$3 = swap_BANG___3;
swap_BANG_.cljs$lang$arity$4 = swap_BANG___4;
swap_BANG_.cljs$lang$arity$5 = swap_BANG___5;
swap_BANG_.cljs$lang$arity$variadic = swap_BANG___6.cljs$lang$arity$variadic;
return swap_BANG_;
})()
;
/**
* Atomically sets the value of atom to newval if and only if the
* current value of the atom is identical to oldval. Returns true if
* set happened, else false.
*/
cljs.core.compare_and_set_BANG_ = (function compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.call(null,a.state,oldval))
{cljs.core.reset_BANG_.call(null,a,newval);
return true;
} else
{return false;
}
});
cljs.core.deref = (function deref(o){
return cljs.core._deref.call(null,o);
});
/**
* Sets the validator-fn for an atom. validator-fn must be nil or a
* side-effect-free fn of one argument, which will be passed the intended
* new state on any state change. If the new state is unacceptable, the
* validator-fn should return false or throw an Error. If the current state
* is not acceptable to the new validator, an Error will be thrown and the
* validator will not be changed.
*/
cljs.core.set_validator_BANG_ = (function set_validator_BANG_(iref,val){
return iref.validator = val;
});
/**
* Gets the validator-fn for a var/ref/agent/atom.
*/
cljs.core.get_validator = (function get_validator(iref){
return iref.validator;
});
/**
* Atomically sets the metadata for a namespace/var/ref/agent/atom to be:
* 
* (apply f its-current-meta args)
* 
* f must be free of side-effects
* @param {...*} var_args
*/
cljs.core.alter_meta_BANG_ = (function() { 
var alter_meta_BANG___delegate = function (iref,f,args){
return iref.meta = cljs.core.apply.call(null,f,iref.meta,args);
};
var alter_meta_BANG_ = function (iref,f,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);
} 
return alter_meta_BANG___delegate.call(this, iref, f, args);
};
alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
alter_meta_BANG_.cljs$lang$applyTo = (function (arglist__15236){
var iref = cljs.core.first(arglist__15236);
var f = cljs.core.first(cljs.core.next(arglist__15236));
var args = cljs.core.rest(cljs.core.next(arglist__15236));
return alter_meta_BANG___delegate(iref, f, args);
});
alter_meta_BANG_.cljs$lang$arity$variadic = alter_meta_BANG___delegate;
return alter_meta_BANG_;
})()
;
/**
* Atomically resets the metadata for an atom
*/
cljs.core.reset_meta_BANG_ = (function reset_meta_BANG_(iref,m){
return iref.meta = m;
});
/**
* Alpha - subject to change.
* 
* Adds a watch function to an atom reference. The watch fn must be a
* fn of 4 args: a key, the reference, its old-state, its
* new-state. Whenever the reference's state might have been changed,
* any registered watches will have their functions called. The watch
* fn will be called synchronously. Note that an atom's state
* may have changed again prior to the fn call, so use old/new-state
* rather than derefing the reference. Keys must be unique per
* reference, and can be used to remove the watch with remove-watch,
* but are otherwise considered opaque by the watch mechanism.  Bear in
* mind that regardless of the result or action of the watch fns the
* atom's value will change.  Example:
* 
* (def a (atom 0))
* (add-watch a :inc (fn [k r o n] (assert (== 0 n))))
* (swap! a inc)
* ;; Assertion Error
* (deref a)
* ;=> 1
*/
cljs.core.add_watch = (function add_watch(iref,key,f){
return cljs.core._add_watch.call(null,iref,key,f);
});
/**
* Alpha - subject to change.
* 
* Removes a watch (set by add-watch) from a reference
*/
cljs.core.remove_watch = (function remove_watch(iref,key){
return cljs.core._remove_watch.call(null,iref,key);
});
cljs.core.gensym_counter = null;
/**
* Returns a new symbol with a unique name. If a prefix string is
* supplied, the name is prefix# where # is some unique number. If
* prefix is not supplied, the prefix is 'G__'.
*/
cljs.core.gensym = (function() {
var gensym = null;
var gensym__0 = (function (){
return gensym.call(null,"G__");
});
var gensym__1 = (function (prefix_string){
if((cljs.core.gensym_counter == null))
{cljs.core.gensym_counter = cljs.core.atom.call(null,0);
} else
{}
return cljs.core.symbol.call(null,[cljs.core.str(prefix_string),cljs.core.str(cljs.core.swap_BANG_.call(null,cljs.core.gensym_counter,cljs.core.inc))].join(''));
});
gensym = function(prefix_string){
switch(arguments.length){
case 0:
return gensym__0.call(this);
case 1:
return gensym__1.call(this,prefix_string);
}
throw('Invalid arity: ' + arguments.length);
};
gensym.cljs$lang$arity$0 = gensym__0;
gensym.cljs$lang$arity$1 = gensym__1;
return gensym;
})()
;
cljs.core.fixture1 = 1;
cljs.core.fixture2 = 2;

/**
* @constructor
*/
cljs.core.Delay = (function (state,f){
this.state = state;
this.f = f;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 1073774592;
})
cljs.core.Delay.cljs$lang$type = true;
cljs.core.Delay.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/Delay");
});
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (d){
var this__15237 = this;
return (new cljs.core.Keyword("\uFDD0'done")).call(null,cljs.core.deref.call(null,this__15237.state));
});
cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var this__15238 = this;
return (new cljs.core.Keyword("\uFDD0'value")).call(null,cljs.core.swap_BANG_.call(null,this__15238.state,(function (p__15239){
var map__15240__15241 = p__15239;
var map__15240__15242 = ((cljs.core.seq_QMARK_.call(null,map__15240__15241))?cljs.core.apply.call(null,cljs.core.hash_map,map__15240__15241):map__15240__15241);
var curr_state__15243 = map__15240__15242;
var done__15244 = cljs.core._lookup.call(null,map__15240__15242,"\uFDD0'done",null);
if(cljs.core.truth_(done__15244))
{return curr_state__15243;
} else
{return cljs.core.ObjMap.fromObject(["\uFDD0'done","\uFDD0'value"],{"\uFDD0'done":true,"\uFDD0'value":this__15238.f.call(null)});
}
})));
});
cljs.core.Delay;
/**
* returns true if x is a Delay created with delay
*/
cljs.core.delay_QMARK_ = (function delay_QMARK_(x){
return cljs.core.instance_QMARK_.call(null,cljs.core.Delay,x);
});
/**
* If x is a Delay, returns the (possibly cached) value of its expression, else returns x
*/
cljs.core.force = (function force(x){
if(cljs.core.delay_QMARK_.call(null,x))
{return cljs.core.deref.call(null,x);
} else
{return x;
}
});
/**
* Returns true if a value has been produced for a promise, delay, future or lazy sequence.
*/
cljs.core.realized_QMARK_ = (function realized_QMARK_(d){
return cljs.core._realized_QMARK_.call(null,d);
});
/**
* Recursively transforms JavaScript arrays into ClojureScript
* vectors, and JavaScript objects into ClojureScript maps.  With
* option ':keywordize-keys true' will convert object fields from
* strings to keywords.
* @param {...*} var_args
*/
cljs.core.js__GT_clj = (function() { 
var js__GT_clj__delegate = function (x,options){
var map__15265__15266 = options;
var map__15265__15267 = ((cljs.core.seq_QMARK_.call(null,map__15265__15266))?cljs.core.apply.call(null,cljs.core.hash_map,map__15265__15266):map__15265__15266);
var keywordize_keys__15268 = cljs.core._lookup.call(null,map__15265__15267,"\uFDD0'keywordize-keys",null);
var keyfn__15269 = (cljs.core.truth_(keywordize_keys__15268)?cljs.core.keyword:cljs.core.str);
var f__15284 = (function thisfn(x){
if(cljs.core.seq_QMARK_.call(null,x))
{return cljs.core.doall.call(null,cljs.core.map.call(null,thisfn,x));
} else
{if(cljs.core.coll_QMARK_.call(null,x))
{return cljs.core.into.call(null,cljs.core.empty.call(null,x),cljs.core.map.call(null,thisfn,x));
} else
{if(cljs.core.truth_(goog.isArray(x)))
{return cljs.core.vec.call(null,cljs.core.map.call(null,thisfn,x));
} else
{if((cljs.core.type.call(null,x) === Object))
{return cljs.core.into.call(null,cljs.core.ObjMap.EMPTY,(function (){var iter__4984__auto____15283 = (function iter__15277(s__15278){
return (new cljs.core.LazySeq(null,false,(function (){
var s__15278__15281 = s__15278;
while(true){
if(cljs.core.seq.call(null,s__15278__15281))
{var k__15282 = cljs.core.first.call(null,s__15278__15281);
return cljs.core.cons.call(null,cljs.core.PersistentVector.fromArray([keyfn__15269.call(null,k__15282),thisfn.call(null,(x[k__15282]))], true),iter__15277.call(null,cljs.core.rest.call(null,s__15278__15281)));
} else
{return null;
}
break;
}
}),null));
});
return iter__4984__auto____15283.call(null,cljs.core.js_keys.call(null,x));
})());
} else
{if("\uFDD0'else")
{return x;
} else
{return null;
}
}
}
}
}
});
return f__15284.call(null,x);
};
var js__GT_clj = function (x,var_args){
var options = null;
if (goog.isDef(var_args)) {
  options = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);
} 
return js__GT_clj__delegate.call(this, x, options);
};
js__GT_clj.cljs$lang$maxFixedArity = 1;
js__GT_clj.cljs$lang$applyTo = (function (arglist__15285){
var x = cljs.core.first(arglist__15285);
var options = cljs.core.rest(arglist__15285);
return js__GT_clj__delegate(x, options);
});
js__GT_clj.cljs$lang$arity$variadic = js__GT_clj__delegate;
return js__GT_clj;
})()
;
/**
* Returns a memoized version of a referentially transparent function. The
* memoized version of the function keeps a cache of the mapping from arguments
* to results and, when calls with the same arguments are repeated often, has
* higher performance at the expense of higher memory use.
*/
cljs.core.memoize = (function memoize(f){
var mem__15290 = cljs.core.atom.call(null,cljs.core.ObjMap.EMPTY);
return (function() { 
var G__15294__delegate = function (args){
var temp__3971__auto____15291 = cljs.core._lookup.call(null,cljs.core.deref.call(null,mem__15290),args,null);
if(cljs.core.truth_(temp__3971__auto____15291))
{var v__15292 = temp__3971__auto____15291;
return v__15292;
} else
{var ret__15293 = cljs.core.apply.call(null,f,args);
cljs.core.swap_BANG_.call(null,mem__15290,cljs.core.assoc,args,ret__15293);
return ret__15293;
}
};
var G__15294 = function (var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return G__15294__delegate.call(this, args);
};
G__15294.cljs$lang$maxFixedArity = 0;
G__15294.cljs$lang$applyTo = (function (arglist__15295){
var args = cljs.core.seq(arglist__15295);;
return G__15294__delegate(args);
});
G__15294.cljs$lang$arity$variadic = G__15294__delegate;
return G__15294;
})()
;
});
/**
* trampoline can be used to convert algorithms requiring mutual
* recursion without stack consumption. Calls f with supplied args, if
* any. If f returns a fn, calls that fn with no arguments, and
* continues to repeat, until the return value is not a fn, then
* returns that non-fn value. Note that if you want to return a fn as a
* final value, you must wrap it in some data structure and unpack it
* after trampoline returns.
* @param {...*} var_args
*/
cljs.core.trampoline = (function() {
var trampoline = null;
var trampoline__1 = (function (f){
while(true){
var ret__15297 = f.call(null);
if(cljs.core.fn_QMARK_.call(null,ret__15297))
{{
var G__15298 = ret__15297;
f = G__15298;
continue;
}
} else
{return ret__15297;
}
break;
}
});
var trampoline__2 = (function() { 
var G__15299__delegate = function (f,args){
return trampoline.call(null,(function (){
return cljs.core.apply.call(null,f,args);
}));
};
var G__15299 = function (f,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);
} 
return G__15299__delegate.call(this, f, args);
};
G__15299.cljs$lang$maxFixedArity = 1;
G__15299.cljs$lang$applyTo = (function (arglist__15300){
var f = cljs.core.first(arglist__15300);
var args = cljs.core.rest(arglist__15300);
return G__15299__delegate(f, args);
});
G__15299.cljs$lang$arity$variadic = G__15299__delegate;
return G__15299;
})()
;
trampoline = function(f,var_args){
var args = var_args;
switch(arguments.length){
case 1:
return trampoline__1.call(this,f);
default:
return trampoline__2.cljs$lang$arity$variadic(f, cljs.core.array_seq(arguments, 1));
}
throw('Invalid arity: ' + arguments.length);
};
trampoline.cljs$lang$maxFixedArity = 1;
trampoline.cljs$lang$applyTo = trampoline__2.cljs$lang$applyTo;
trampoline.cljs$lang$arity$1 = trampoline__1;
trampoline.cljs$lang$arity$variadic = trampoline__2.cljs$lang$arity$variadic;
return trampoline;
})()
;
/**
* Returns a random floating point number between 0 (inclusive) and
* n (default 1) (exclusive).
*/
cljs.core.rand = (function() {
var rand = null;
var rand__0 = (function (){
return rand.call(null,1);
});
var rand__1 = (function (n){
return (Math.random.call(null) * n);
});
rand = function(n){
switch(arguments.length){
case 0:
return rand__0.call(this);
case 1:
return rand__1.call(this,n);
}
throw('Invalid arity: ' + arguments.length);
};
rand.cljs$lang$arity$0 = rand__0;
rand.cljs$lang$arity$1 = rand__1;
return rand;
})()
;
/**
* Returns a random integer between 0 (inclusive) and n (exclusive).
*/
cljs.core.rand_int = (function rand_int(n){
return Math.floor.call(null,(Math.random.call(null) * n));
});
/**
* Return a random element of the (sequential) collection. Will have
* the same performance characteristics as nth for the given
* collection.
*/
cljs.core.rand_nth = (function rand_nth(coll){
return cljs.core.nth.call(null,coll,cljs.core.rand_int.call(null,cljs.core.count.call(null,coll)));
});
/**
* Returns a map of the elements of coll keyed by the result of
* f on each element. The value at each key will be a vector of the
* corresponding elements, in the order they appeared in coll.
*/
cljs.core.group_by = (function group_by(f,coll){
return cljs.core.reduce.call(null,(function (ret,x){
var k__15302 = f.call(null,x);
return cljs.core.assoc.call(null,ret,k__15302,cljs.core.conj.call(null,cljs.core._lookup.call(null,ret,k__15302,cljs.core.PersistentVector.EMPTY),x));
}),cljs.core.ObjMap.EMPTY,coll);
});
/**
* Creates a hierarchy object for use with derive, isa? etc.
*/
cljs.core.make_hierarchy = (function make_hierarchy(){
return cljs.core.ObjMap.fromObject(["\uFDD0'parents","\uFDD0'descendants","\uFDD0'ancestors"],{"\uFDD0'parents":cljs.core.ObjMap.EMPTY,"\uFDD0'descendants":cljs.core.ObjMap.EMPTY,"\uFDD0'ancestors":cljs.core.ObjMap.EMPTY});
});
cljs.core.global_hierarchy = cljs.core.atom.call(null,cljs.core.make_hierarchy.call(null));
/**
* Returns true if (= child parent), or child is directly or indirectly derived from
* parent, either via a JavaScript type inheritance relationship or a
* relationship established via derive. h must be a hierarchy obtained
* from make-hierarchy, if not supplied defaults to the global
* hierarchy
*/
cljs.core.isa_QMARK_ = (function() {
var isa_QMARK_ = null;
var isa_QMARK___2 = (function (child,parent){
return isa_QMARK_.call(null,cljs.core.deref.call(null,cljs.core.global_hierarchy),child,parent);
});
var isa_QMARK___3 = (function (h,child,parent){
var or__3824__auto____15311 = cljs.core._EQ_.call(null,child,parent);
if(or__3824__auto____15311)
{return or__3824__auto____15311;
} else
{var or__3824__auto____15312 = cljs.core.contains_QMARK_.call(null,(new cljs.core.Keyword("\uFDD0'ancestors")).call(null,h).call(null,child),parent);
if(or__3824__auto____15312)
{return or__3824__auto____15312;
} else
{var and__3822__auto____15313 = cljs.core.vector_QMARK_.call(null,parent);
if(and__3822__auto____15313)
{var and__3822__auto____15314 = cljs.core.vector_QMARK_.call(null,child);
if(and__3822__auto____15314)
{var and__3822__auto____15315 = (cljs.core.count.call(null,parent) === cljs.core.count.call(null,child));
if(and__3822__auto____15315)
{var ret__15316 = true;
var i__15317 = 0;
while(true){
if((function (){var or__3824__auto____15318 = cljs.core.not.call(null,ret__15316);
if(or__3824__auto____15318)
{return or__3824__auto____15318;
} else
{return (i__15317 === cljs.core.count.call(null,parent));
}
})())
{return ret__15316;
} else
{{
var G__15319 = isa_QMARK_.call(null,h,child.call(null,i__15317),parent.call(null,i__15317));
var G__15320 = (i__15317 + 1);
ret__15316 = G__15319;
i__15317 = G__15320;
continue;
}
}
break;
}
} else
{return and__3822__auto____15315;
}
} else
{return and__3822__auto____15314;
}
} else
{return and__3822__auto____15313;
}
}
}
});
isa_QMARK_ = function(h,child,parent){
switch(arguments.length){
case 2:
return isa_QMARK___2.call(this,h,child);
case 3:
return isa_QMARK___3.call(this,h,child,parent);
}
throw('Invalid arity: ' + arguments.length);
};
isa_QMARK_.cljs$lang$arity$2 = isa_QMARK___2;
isa_QMARK_.cljs$lang$arity$3 = isa_QMARK___3;
return isa_QMARK_;
})()
;
/**
* Returns the immediate parents of tag, either via a JavaScript type
* inheritance relationship or a relationship established via derive. h
* must be a hierarchy obtained from make-hierarchy, if not supplied
* defaults to the global hierarchy
*/
cljs.core.parents = (function() {
var parents = null;
var parents__1 = (function (tag){
return parents.call(null,cljs.core.deref.call(null,cljs.core.global_hierarchy),tag);
});
var parents__2 = (function (h,tag){
return cljs.core.not_empty.call(null,cljs.core._lookup.call(null,(new cljs.core.Keyword("\uFDD0'parents")).call(null,h),tag,null));
});
parents = function(h,tag){
switch(arguments.length){
case 1:
return parents__1.call(this,h);
case 2:
return parents__2.call(this,h,tag);
}
throw('Invalid arity: ' + arguments.length);
};
parents.cljs$lang$arity$1 = parents__1;
parents.cljs$lang$arity$2 = parents__2;
return parents;
})()
;
/**
* Returns the immediate and indirect parents of tag, either via a JavaScript type
* inheritance relationship or a relationship established via derive. h
* must be a hierarchy obtained from make-hierarchy, if not supplied
* defaults to the global hierarchy
*/
cljs.core.ancestors = (function() {
var ancestors = null;
var ancestors__1 = (function (tag){
return ancestors.call(null,cljs.core.deref.call(null,cljs.core.global_hierarchy),tag);
});
var ancestors__2 = (function (h,tag){
return cljs.core.not_empty.call(null,cljs.core._lookup.call(null,(new cljs.core.Keyword("\uFDD0'ancestors")).call(null,h),tag,null));
});
ancestors = function(h,tag){
switch(arguments.length){
case 1:
return ancestors__1.call(this,h);
case 2:
return ancestors__2.call(this,h,tag);
}
throw('Invalid arity: ' + arguments.length);
};
ancestors.cljs$lang$arity$1 = ancestors__1;
ancestors.cljs$lang$arity$2 = ancestors__2;
return ancestors;
})()
;
/**
* Returns the immediate and indirect children of tag, through a
* relationship established via derive. h must be a hierarchy obtained
* from make-hierarchy, if not supplied defaults to the global
* hierarchy. Note: does not work on JavaScript type inheritance
* relationships.
*/
cljs.core.descendants = (function() {
var descendants = null;
var descendants__1 = (function (tag){
return descendants.call(null,cljs.core.deref.call(null,cljs.core.global_hierarchy),tag);
});
var descendants__2 = (function (h,tag){
return cljs.core.not_empty.call(null,cljs.core._lookup.call(null,(new cljs.core.Keyword("\uFDD0'descendants")).call(null,h),tag,null));
});
descendants = function(h,tag){
switch(arguments.length){
case 1:
return descendants__1.call(this,h);
case 2:
return descendants__2.call(this,h,tag);
}
throw('Invalid arity: ' + arguments.length);
};
descendants.cljs$lang$arity$1 = descendants__1;
descendants.cljs$lang$arity$2 = descendants__2;
return descendants;
})()
;
/**
* Establishes a parent/child relationship between parent and
* tag. Parent must be a namespace-qualified symbol or keyword and
* child can be either a namespace-qualified symbol or keyword or a
* class. h must be a hierarchy obtained from make-hierarchy, if not
* supplied defaults to, and modifies, the global hierarchy.
*/
cljs.core.derive = (function() {
var derive = null;
var derive__2 = (function (tag,parent){
if(cljs.core.truth_(cljs.core.namespace.call(null,parent)))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.with_meta(cljs.core.list("\uFDD1'namespace","\uFDD1'parent"),cljs.core.hash_map("\uFDD0'line",6724))))].join('')));
}
cljs.core.swap_BANG_.call(null,cljs.core.global_hierarchy,derive,tag,parent);
return null;
});
var derive__3 = (function (h,tag,parent){
if(cljs.core.not_EQ_.call(null,tag,parent))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.with_meta(cljs.core.list("\uFDD1'not=","\uFDD1'tag","\uFDD1'parent"),cljs.core.hash_map("\uFDD0'line",6728))))].join('')));
}
var tp__15329 = (new cljs.core.Keyword("\uFDD0'parents")).call(null,h);
var td__15330 = (new cljs.core.Keyword("\uFDD0'descendants")).call(null,h);
var ta__15331 = (new cljs.core.Keyword("\uFDD0'ancestors")).call(null,h);
var tf__15332 = (function (m,source,sources,target,targets){
return cljs.core.reduce.call(null,(function (ret,k){
return cljs.core.assoc.call(null,ret,k,cljs.core.reduce.call(null,cljs.core.conj,cljs.core._lookup.call(null,targets,k,cljs.core.PersistentHashSet.EMPTY),cljs.core.cons.call(null,target,targets.call(null,target))));
}),m,cljs.core.cons.call(null,source,sources.call(null,source)));
});
var or__3824__auto____15333 = ((cljs.core.contains_QMARK_.call(null,tp__15329.call(null,tag),parent))?null:(function (){if(cljs.core.contains_QMARK_.call(null,ta__15331.call(null,tag),parent))
{throw (new Error([cljs.core.str(tag),cljs.core.str("already has"),cljs.core.str(parent),cljs.core.str("as ancestor")].join('')));
} else
{}
if(cljs.core.contains_QMARK_.call(null,ta__15331.call(null,parent),tag))
{throw (new Error([cljs.core.str("Cyclic derivation:"),cljs.core.str(parent),cljs.core.str("has"),cljs.core.str(tag),cljs.core.str("as ancestor")].join('')));
} else
{}
return cljs.core.ObjMap.fromObject(["\uFDD0'parents","\uFDD0'ancestors","\uFDD0'descendants"],{"\uFDD0'parents":cljs.core.assoc.call(null,(new cljs.core.Keyword("\uFDD0'parents")).call(null,h),tag,cljs.core.conj.call(null,cljs.core._lookup.call(null,tp__15329,tag,cljs.core.PersistentHashSet.EMPTY),parent)),"\uFDD0'ancestors":tf__15332.call(null,(new cljs.core.Keyword("\uFDD0'ancestors")).call(null,h),tag,td__15330,parent,ta__15331),"\uFDD0'descendants":tf__15332.call(null,(new cljs.core.Keyword("\uFDD0'descendants")).call(null,h),parent,ta__15331,tag,td__15330)});
})());
if(cljs.core.truth_(or__3824__auto____15333))
{return or__3824__auto____15333;
} else
{return h;
}
});
derive = function(h,tag,parent){
switch(arguments.length){
case 2:
return derive__2.call(this,h,tag);
case 3:
return derive__3.call(this,h,tag,parent);
}
throw('Invalid arity: ' + arguments.length);
};
derive.cljs$lang$arity$2 = derive__2;
derive.cljs$lang$arity$3 = derive__3;
return derive;
})()
;
/**
* Removes a parent/child relationship between parent and
* tag. h must be a hierarchy obtained from make-hierarchy, if not
* supplied defaults to, and modifies, the global hierarchy.
*/
cljs.core.underive = (function() {
var underive = null;
var underive__2 = (function (tag,parent){
cljs.core.swap_BANG_.call(null,cljs.core.global_hierarchy,underive,tag,parent);
return null;
});
var underive__3 = (function (h,tag,parent){
var parentMap__15338 = (new cljs.core.Keyword("\uFDD0'parents")).call(null,h);
var childsParents__15339 = (cljs.core.truth_(parentMap__15338.call(null,tag))?cljs.core.disj.call(null,parentMap__15338.call(null,tag),parent):cljs.core.PersistentHashSet.EMPTY);
var newParents__15340 = (cljs.core.truth_(cljs.core.not_empty.call(null,childsParents__15339))?cljs.core.assoc.call(null,parentMap__15338,tag,childsParents__15339):cljs.core.dissoc.call(null,parentMap__15338,tag));
var deriv_seq__15341 = cljs.core.flatten.call(null,cljs.core.map.call(null,(function (p1__15321_SHARP_){
return cljs.core.cons.call(null,cljs.core.first.call(null,p1__15321_SHARP_),cljs.core.interpose.call(null,cljs.core.first.call(null,p1__15321_SHARP_),cljs.core.second.call(null,p1__15321_SHARP_)));
}),cljs.core.seq.call(null,newParents__15340)));
if(cljs.core.contains_QMARK_.call(null,parentMap__15338.call(null,tag),parent))
{return cljs.core.reduce.call(null,(function (p1__15322_SHARP_,p2__15323_SHARP_){
return cljs.core.apply.call(null,cljs.core.derive,p1__15322_SHARP_,p2__15323_SHARP_);
}),cljs.core.make_hierarchy.call(null),cljs.core.partition.call(null,2,deriv_seq__15341));
} else
{return h;
}
});
underive = function(h,tag,parent){
switch(arguments.length){
case 2:
return underive__2.call(this,h,tag);
case 3:
return underive__3.call(this,h,tag,parent);
}
throw('Invalid arity: ' + arguments.length);
};
underive.cljs$lang$arity$2 = underive__2;
underive.cljs$lang$arity$3 = underive__3;
return underive;
})()
;
cljs.core.reset_cache = (function reset_cache(method_cache,method_table,cached_hierarchy,hierarchy){
cljs.core.swap_BANG_.call(null,method_cache,(function (_){
return cljs.core.deref.call(null,method_table);
}));
return cljs.core.swap_BANG_.call(null,cached_hierarchy,(function (_){
return cljs.core.deref.call(null,hierarchy);
}));
});
cljs.core.prefers_STAR_ = (function prefers_STAR_(x,y,prefer_table){
var xprefs__15349 = cljs.core.deref.call(null,prefer_table).call(null,x);
var or__3824__auto____15351 = (cljs.core.truth_((function (){var and__3822__auto____15350 = xprefs__15349;
if(cljs.core.truth_(and__3822__auto____15350))
{return xprefs__15349.call(null,y);
} else
{return and__3822__auto____15350;
}
})())?true:null);
if(cljs.core.truth_(or__3824__auto____15351))
{return or__3824__auto____15351;
} else
{var or__3824__auto____15353 = (function (){var ps__15352 = cljs.core.parents.call(null,y);
while(true){
if((cljs.core.count.call(null,ps__15352) > 0))
{if(cljs.core.truth_(prefers_STAR_.call(null,x,cljs.core.first.call(null,ps__15352),prefer_table)))
{} else
{}
{
var G__15356 = cljs.core.rest.call(null,ps__15352);
ps__15352 = G__15356;
continue;
}
} else
{return null;
}
break;
}
})();
if(cljs.core.truth_(or__3824__auto____15353))
{return or__3824__auto____15353;
} else
{var or__3824__auto____15355 = (function (){var ps__15354 = cljs.core.parents.call(null,x);
while(true){
if((cljs.core.count.call(null,ps__15354) > 0))
{if(cljs.core.truth_(prefers_STAR_.call(null,cljs.core.first.call(null,ps__15354),y,prefer_table)))
{} else
{}
{
var G__15357 = cljs.core.rest.call(null,ps__15354);
ps__15354 = G__15357;
continue;
}
} else
{return null;
}
break;
}
})();
if(cljs.core.truth_(or__3824__auto____15355))
{return or__3824__auto____15355;
} else
{return false;
}
}
}
});
cljs.core.dominates = (function dominates(x,y,prefer_table){
var or__3824__auto____15359 = cljs.core.prefers_STAR_.call(null,x,y,prefer_table);
if(cljs.core.truth_(or__3824__auto____15359))
{return or__3824__auto____15359;
} else
{return cljs.core.isa_QMARK_.call(null,x,y);
}
});
cljs.core.find_and_cache_best_method = (function find_and_cache_best_method(name,dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy){
var best_entry__15377 = cljs.core.reduce.call(null,(function (be,p__15369){
var vec__15370__15371 = p__15369;
var k__15372 = cljs.core.nth.call(null,vec__15370__15371,0,null);
var ___15373 = cljs.core.nth.call(null,vec__15370__15371,1,null);
var e__15374 = vec__15370__15371;
if(cljs.core.isa_QMARK_.call(null,dispatch_val,k__15372))
{var be2__15376 = (cljs.core.truth_((function (){var or__3824__auto____15375 = (be == null);
if(or__3824__auto____15375)
{return or__3824__auto____15375;
} else
{return cljs.core.dominates.call(null,k__15372,cljs.core.first.call(null,be),prefer_table);
}
})())?e__15374:be);
if(cljs.core.truth_(cljs.core.dominates.call(null,cljs.core.first.call(null,be2__15376),k__15372,prefer_table)))
{} else
{throw (new Error([cljs.core.str("Multiple methods in multimethod '"),cljs.core.str(name),cljs.core.str("' match dispatch value: "),cljs.core.str(dispatch_val),cljs.core.str(" -> "),cljs.core.str(k__15372),cljs.core.str(" and "),cljs.core.str(cljs.core.first.call(null,be2__15376)),cljs.core.str(", and neither is preferred")].join('')));
}
return be2__15376;
} else
{return be;
}
}),null,cljs.core.deref.call(null,method_table));
if(cljs.core.truth_(best_entry__15377))
{if(cljs.core._EQ_.call(null,cljs.core.deref.call(null,cached_hierarchy),cljs.core.deref.call(null,hierarchy)))
{cljs.core.swap_BANG_.call(null,method_cache,cljs.core.assoc,dispatch_val,cljs.core.second.call(null,best_entry__15377));
return cljs.core.second.call(null,best_entry__15377);
} else
{cljs.core.reset_cache.call(null,method_cache,method_table,cached_hierarchy,hierarchy);
return find_and_cache_best_method.call(null,name,dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy);
}
} else
{return null;
}
});
cljs.core.IMultiFn = {};
cljs.core._reset = (function _reset(mf){
if((function (){var and__3822__auto____15382 = mf;
if(and__3822__auto____15382)
{return mf.cljs$core$IMultiFn$_reset$arity$1;
} else
{return and__3822__auto____15382;
}
})())
{return mf.cljs$core$IMultiFn$_reset$arity$1(mf);
} else
{var x__4885__auto____15383 = (((mf == null))?null:mf);
return (function (){var or__3824__auto____15384 = (cljs.core._reset[goog.typeOf(x__4885__auto____15383)]);
if(or__3824__auto____15384)
{return or__3824__auto____15384;
} else
{var or__3824__auto____15385 = (cljs.core._reset["_"]);
if(or__3824__auto____15385)
{return or__3824__auto____15385;
} else
{throw cljs.core.missing_protocol.call(null,"IMultiFn.-reset",mf);
}
}
})().call(null,mf);
}
});
cljs.core._add_method = (function _add_method(mf,dispatch_val,method){
if((function (){var and__3822__auto____15390 = mf;
if(and__3822__auto____15390)
{return mf.cljs$core$IMultiFn$_add_method$arity$3;
} else
{return and__3822__auto____15390;
}
})())
{return mf.cljs$core$IMultiFn$_add_method$arity$3(mf,dispatch_val,method);
} else
{var x__4885__auto____15391 = (((mf == null))?null:mf);
return (function (){var or__3824__auto____15392 = (cljs.core._add_method[goog.typeOf(x__4885__auto____15391)]);
if(or__3824__auto____15392)
{return or__3824__auto____15392;
} else
{var or__3824__auto____15393 = (cljs.core._add_method["_"]);
if(or__3824__auto____15393)
{return or__3824__auto____15393;
} else
{throw cljs.core.missing_protocol.call(null,"IMultiFn.-add-method",mf);
}
}
})().call(null,mf,dispatch_val,method);
}
});
cljs.core._remove_method = (function _remove_method(mf,dispatch_val){
if((function (){var and__3822__auto____15398 = mf;
if(and__3822__auto____15398)
{return mf.cljs$core$IMultiFn$_remove_method$arity$2;
} else
{return and__3822__auto____15398;
}
})())
{return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf,dispatch_val);
} else
{var x__4885__auto____15399 = (((mf == null))?null:mf);
return (function (){var or__3824__auto____15400 = (cljs.core._remove_method[goog.typeOf(x__4885__auto____15399)]);
if(or__3824__auto____15400)
{return or__3824__auto____15400;
} else
{var or__3824__auto____15401 = (cljs.core._remove_method["_"]);
if(or__3824__auto____15401)
{return or__3824__auto____15401;
} else
{throw cljs.core.missing_protocol.call(null,"IMultiFn.-remove-method",mf);
}
}
})().call(null,mf,dispatch_val);
}
});
cljs.core._prefer_method = (function _prefer_method(mf,dispatch_val,dispatch_val_y){
if((function (){var and__3822__auto____15406 = mf;
if(and__3822__auto____15406)
{return mf.cljs$core$IMultiFn$_prefer_method$arity$3;
} else
{return and__3822__auto____15406;
}
})())
{return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf,dispatch_val,dispatch_val_y);
} else
{var x__4885__auto____15407 = (((mf == null))?null:mf);
return (function (){var or__3824__auto____15408 = (cljs.core._prefer_method[goog.typeOf(x__4885__auto____15407)]);
if(or__3824__auto____15408)
{return or__3824__auto____15408;
} else
{var or__3824__auto____15409 = (cljs.core._prefer_method["_"]);
if(or__3824__auto____15409)
{return or__3824__auto____15409;
} else
{throw cljs.core.missing_protocol.call(null,"IMultiFn.-prefer-method",mf);
}
}
})().call(null,mf,dispatch_val,dispatch_val_y);
}
});
cljs.core._get_method = (function _get_method(mf,dispatch_val){
if((function (){var and__3822__auto____15414 = mf;
if(and__3822__auto____15414)
{return mf.cljs$core$IMultiFn$_get_method$arity$2;
} else
{return and__3822__auto____15414;
}
})())
{return mf.cljs$core$IMultiFn$_get_method$arity$2(mf,dispatch_val);
} else
{var x__4885__auto____15415 = (((mf == null))?null:mf);
return (function (){var or__3824__auto____15416 = (cljs.core._get_method[goog.typeOf(x__4885__auto____15415)]);
if(or__3824__auto____15416)
{return or__3824__auto____15416;
} else
{var or__3824__auto____15417 = (cljs.core._get_method["_"]);
if(or__3824__auto____15417)
{return or__3824__auto____15417;
} else
{throw cljs.core.missing_protocol.call(null,"IMultiFn.-get-method",mf);
}
}
})().call(null,mf,dispatch_val);
}
});
cljs.core._methods = (function _methods(mf){
if((function (){var and__3822__auto____15422 = mf;
if(and__3822__auto____15422)
{return mf.cljs$core$IMultiFn$_methods$arity$1;
} else
{return and__3822__auto____15422;
}
})())
{return mf.cljs$core$IMultiFn$_methods$arity$1(mf);
} else
{var x__4885__auto____15423 = (((mf == null))?null:mf);
return (function (){var or__3824__auto____15424 = (cljs.core._methods[goog.typeOf(x__4885__auto____15423)]);
if(or__3824__auto____15424)
{return or__3824__auto____15424;
} else
{var or__3824__auto____15425 = (cljs.core._methods["_"]);
if(or__3824__auto____15425)
{return or__3824__auto____15425;
} else
{throw cljs.core.missing_protocol.call(null,"IMultiFn.-methods",mf);
}
}
})().call(null,mf);
}
});
cljs.core._prefers = (function _prefers(mf){
if((function (){var and__3822__auto____15430 = mf;
if(and__3822__auto____15430)
{return mf.cljs$core$IMultiFn$_prefers$arity$1;
} else
{return and__3822__auto____15430;
}
})())
{return mf.cljs$core$IMultiFn$_prefers$arity$1(mf);
} else
{var x__4885__auto____15431 = (((mf == null))?null:mf);
return (function (){var or__3824__auto____15432 = (cljs.core._prefers[goog.typeOf(x__4885__auto____15431)]);
if(or__3824__auto____15432)
{return or__3824__auto____15432;
} else
{var or__3824__auto____15433 = (cljs.core._prefers["_"]);
if(or__3824__auto____15433)
{return or__3824__auto____15433;
} else
{throw cljs.core.missing_protocol.call(null,"IMultiFn.-prefers",mf);
}
}
})().call(null,mf);
}
});
cljs.core._dispatch = (function _dispatch(mf,args){
if((function (){var and__3822__auto____15438 = mf;
if(and__3822__auto____15438)
{return mf.cljs$core$IMultiFn$_dispatch$arity$2;
} else
{return and__3822__auto____15438;
}
})())
{return mf.cljs$core$IMultiFn$_dispatch$arity$2(mf,args);
} else
{var x__4885__auto____15439 = (((mf == null))?null:mf);
return (function (){var or__3824__auto____15440 = (cljs.core._dispatch[goog.typeOf(x__4885__auto____15439)]);
if(or__3824__auto____15440)
{return or__3824__auto____15440;
} else
{var or__3824__auto____15441 = (cljs.core._dispatch["_"]);
if(or__3824__auto____15441)
{return or__3824__auto____15441;
} else
{throw cljs.core.missing_protocol.call(null,"IMultiFn.-dispatch",mf);
}
}
})().call(null,mf,args);
}
});
cljs.core.do_dispatch = (function do_dispatch(mf,dispatch_fn,args){
var dispatch_val__15444 = cljs.core.apply.call(null,dispatch_fn,args);
var target_fn__15445 = cljs.core._get_method.call(null,mf,dispatch_val__15444);
if(cljs.core.truth_(target_fn__15445))
{} else
{throw (new Error([cljs.core.str("No method in multimethod '"),cljs.core.str(cljs.core.name),cljs.core.str("' for dispatch value: "),cljs.core.str(dispatch_val__15444)].join('')));
}
return cljs.core.apply.call(null,target_fn__15445,args);
});

/**
* @constructor
*/
cljs.core.MultiFn = (function (name,dispatch_fn,default_dispatch_val,hierarchy,method_table,prefer_table,method_cache,cached_hierarchy){
this.name = name;
this.dispatch_fn = dispatch_fn;
this.default_dispatch_val = default_dispatch_val;
this.hierarchy = hierarchy;
this.method_table = method_table;
this.prefer_table = prefer_table;
this.method_cache = method_cache;
this.cached_hierarchy = cached_hierarchy;
this.cljs$lang$protocol_mask$partition0$ = 4194304;
this.cljs$lang$protocol_mask$partition1$ = 64;
})
cljs.core.MultiFn.cljs$lang$type = true;
cljs.core.MultiFn.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/MultiFn");
});
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this__15446 = this;
return goog.getUid(this$);
});
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset$arity$1 = (function (mf){
var this__15447 = this;
cljs.core.swap_BANG_.call(null,this__15447.method_table,(function (mf){
return cljs.core.ObjMap.EMPTY;
}));
cljs.core.swap_BANG_.call(null,this__15447.method_cache,(function (mf){
return cljs.core.ObjMap.EMPTY;
}));
cljs.core.swap_BANG_.call(null,this__15447.prefer_table,(function (mf){
return cljs.core.ObjMap.EMPTY;
}));
cljs.core.swap_BANG_.call(null,this__15447.cached_hierarchy,(function (mf){
return null;
}));
return mf;
});
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method$arity$3 = (function (mf,dispatch_val,method){
var this__15448 = this;
cljs.core.swap_BANG_.call(null,this__15448.method_table,cljs.core.assoc,dispatch_val,method);
cljs.core.reset_cache.call(null,this__15448.method_cache,this__15448.method_table,this__15448.cached_hierarchy,this__15448.hierarchy);
return mf;
});
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method$arity$2 = (function (mf,dispatch_val){
var this__15449 = this;
cljs.core.swap_BANG_.call(null,this__15449.method_table,cljs.core.dissoc,dispatch_val);
cljs.core.reset_cache.call(null,this__15449.method_cache,this__15449.method_table,this__15449.cached_hierarchy,this__15449.hierarchy);
return mf;
});
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method$arity$2 = (function (mf,dispatch_val){
var this__15450 = this;
if(cljs.core._EQ_.call(null,cljs.core.deref.call(null,this__15450.cached_hierarchy),cljs.core.deref.call(null,this__15450.hierarchy)))
{} else
{cljs.core.reset_cache.call(null,this__15450.method_cache,this__15450.method_table,this__15450.cached_hierarchy,this__15450.hierarchy);
}
var temp__3971__auto____15451 = cljs.core.deref.call(null,this__15450.method_cache).call(null,dispatch_val);
if(cljs.core.truth_(temp__3971__auto____15451))
{var target_fn__15452 = temp__3971__auto____15451;
return target_fn__15452;
} else
{var temp__3971__auto____15453 = cljs.core.find_and_cache_best_method.call(null,this__15450.name,dispatch_val,this__15450.hierarchy,this__15450.method_table,this__15450.prefer_table,this__15450.method_cache,this__15450.cached_hierarchy);
if(cljs.core.truth_(temp__3971__auto____15453))
{var target_fn__15454 = temp__3971__auto____15453;
return target_fn__15454;
} else
{return cljs.core.deref.call(null,this__15450.method_table).call(null,this__15450.default_dispatch_val);
}
}
});
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method$arity$3 = (function (mf,dispatch_val_x,dispatch_val_y){
var this__15455 = this;
if(cljs.core.truth_(cljs.core.prefers_STAR_.call(null,dispatch_val_x,dispatch_val_y,this__15455.prefer_table)))
{throw (new Error([cljs.core.str("Preference conflict in multimethod '"),cljs.core.str(this__15455.name),cljs.core.str("': "),cljs.core.str(dispatch_val_y),cljs.core.str(" is already preferred to "),cljs.core.str(dispatch_val_x)].join('')));
} else
{}
cljs.core.swap_BANG_.call(null,this__15455.prefer_table,(function (old){
return cljs.core.assoc.call(null,old,dispatch_val_x,cljs.core.conj.call(null,cljs.core._lookup.call(null,old,dispatch_val_x,cljs.core.PersistentHashSet.EMPTY),dispatch_val_y));
}));
return cljs.core.reset_cache.call(null,this__15455.method_cache,this__15455.method_table,this__15455.cached_hierarchy,this__15455.hierarchy);
});
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods$arity$1 = (function (mf){
var this__15456 = this;
return cljs.core.deref.call(null,this__15456.method_table);
});
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers$arity$1 = (function (mf){
var this__15457 = this;
return cljs.core.deref.call(null,this__15457.prefer_table);
});
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_dispatch$arity$2 = (function (mf,args){
var this__15458 = this;
return cljs.core.do_dispatch.call(null,mf,this__15458.dispatch_fn,args);
});
cljs.core.MultiFn;
cljs.core.MultiFn.prototype.call = (function() { 
var G__15460__delegate = function (_,args){
var self__15459 = this;
return cljs.core._dispatch.call(null,self__15459,args);
};
var G__15460 = function (_,var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);
} 
return G__15460__delegate.call(this, _, args);
};
G__15460.cljs$lang$maxFixedArity = 1;
G__15460.cljs$lang$applyTo = (function (arglist__15461){
var _ = cljs.core.first(arglist__15461);
var args = cljs.core.rest(arglist__15461);
return G__15460__delegate(_, args);
});
G__15460.cljs$lang$arity$variadic = G__15460__delegate;
return G__15460;
})()
;
cljs.core.MultiFn.prototype.apply = (function (_,args){
var self__15462 = this;
return cljs.core._dispatch.call(null,self__15462,args);
});
/**
* Removes all of the methods of multimethod.
*/
cljs.core.remove_all_methods = (function remove_all_methods(multifn){
return cljs.core._reset.call(null,multifn);
});
/**
* Removes the method of multimethod associated with dispatch-value.
*/
cljs.core.remove_method = (function remove_method(multifn,dispatch_val){
return cljs.core._remove_method.call(null,multifn,dispatch_val);
});
/**
* Causes the multimethod to prefer matches of dispatch-val-x over dispatch-val-y
* when there is a conflict
*/
cljs.core.prefer_method = (function prefer_method(multifn,dispatch_val_x,dispatch_val_y){
return cljs.core._prefer_method.call(null,multifn,dispatch_val_x,dispatch_val_y);
});
/**
* Given a multimethod, returns a map of dispatch values -> dispatch fns
*/
cljs.core.methods$ = (function methods$(multifn){
return cljs.core._methods.call(null,multifn);
});
/**
* Given a multimethod and a dispatch value, returns the dispatch fn
* that would apply to that value, or nil if none apply and no default
*/
cljs.core.get_method = (function get_method(multifn,dispatch_val){
return cljs.core._get_method.call(null,multifn,dispatch_val);
});
/**
* Given a multimethod, returns a map of preferred value -> set of other values
*/
cljs.core.prefers = (function prefers(multifn){
return cljs.core._prefers.call(null,multifn);
});

/**
* @constructor
*/
cljs.core.UUID = (function (uuid){
this.uuid = uuid;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 543162368;
})
cljs.core.UUID.cljs$lang$type = true;
cljs.core.UUID.cljs$lang$ctorPrSeq = (function (this__4831__auto__){
return cljs.core.list.call(null,"cljs.core/UUID");
});
cljs.core.UUID.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var this__15463 = this;
return goog.string.hashCode(cljs.core.pr_str.call(null,this$));
});
cljs.core.UUID.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = (function (_15465,_){
var this__15464 = this;
return cljs.core.list.call(null,[cljs.core.str("#uuid \""),cljs.core.str(this__15464.uuid),cljs.core.str("\"")].join(''));
});
cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var this__15466 = this;
var and__3822__auto____15467 = cljs.core.instance_QMARK_.call(null,cljs.core.UUID,other);
if(and__3822__auto____15467)
{return (this__15466.uuid === other.uuid);
} else
{return and__3822__auto____15467;
}
});
cljs.core.UUID.prototype.toString = (function (){
var this__15468 = this;
var this__15469 = this;
return cljs.core.pr_str.call(null,this__15469);
});
cljs.core.UUID;
