(defproject {{name}} "0.1.0-SNAPSHOT"
  :description "FIXME: write this!"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :url "http://exampl.com/FIXME"
  :dependencies [[org.clojure/clojure "1.4.0"]
                 [compojure "1.1.3"]
                 [hiccup "1.0.2"]
                 [ring "1.1.6"]
                 [prismatic/dommy "0.0.2"]
                 [korma "0.3.0-RC4"]
                 [drift "1.4.5"]
                 [org.clojure/java.jdbc "0.2.3"]
                 [mysql/mysql-connector-java "5.1.6"]
                 [jayq "0.1.0-alpha4"]
                 [com.cemerick/shoreleave-remote-ring "0.0.2"]
                 [lib-noir "0.3.8"]]
  :plugins [[lein-ring "0.7.5"]
            [lein-cljsbuild "0.3.0"]
            [lein-pprint "1.1.1"]
            [lein-ninja "0.1.0-SNAPSHOT"]]
  :ring {:handler {{name}}.core/ring-app*}
  :source-paths ["src/clj"]
  :main {{name}}.core
  :ninja {
    :git {:username "username"
          :password "password"
          :repository "git@git:repo"}
    :ssh {:username "ssh-user"
          :password "ssh-password"
          :url "server-url"
          :port 25000
          :src-directory "ninja-apps-dir/"}}
  :cljsbuild
    {:builds
     [{:source-paths ["src/cljs"],
       :id "dev",
       :output-dir "resources/public/scripts/gen/dev",
       :compiler
       {:pretty-print true,
        :output-to "resources/public/scripts/gen/dev/main-debug.js",
        :optimizations :whitespace}}
      {:source-paths ["src/cljs"],
       :id "production",
       :compiler
       {:pretty-print false,
        :output-to "resources/public/scripts/gen/dev/main.js",
        :optimizations :advanced}}]})

