goog.provide('crate.element');
goog.require('cljs.core');
goog.require('crate.util');
goog.require('clojure.string');
goog.require('crate.compiler');
goog.require('crate.util');
/**
* Wrap the supplied javascript up in script tags and a CDATA section.
*/
crate.element.javascript_tag = (function javascript_tag(script){
return cljs.core.PersistentVector.fromArray(["\uFDD0'script",cljs.core.ObjMap.fromObject(["\uFDD0'type"],{"\uFDD0'type":"text/javascript"}),[cljs.core.str("//<![CDATA[\n"),cljs.core.str(script),cljs.core.str("\n//]]>")].join('')], true);
});
var func__6156__auto____16395 = (function() { 
var G__16396__delegate = function (url,content){
return cljs.core.PersistentVector.fromArray(["\uFDD0'a",cljs.core.ObjMap.fromObject(["\uFDD0'href"],{"\uFDD0'href":crate.util.to_uri.call(null,url)}),content], true);
};
var G__16396 = function (url,var_args){
var content = null;
if (goog.isDef(var_args)) {
  content = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);
} 
return G__16396__delegate.call(this, url, content);
};
G__16396.cljs$lang$maxFixedArity = 1;
G__16396.cljs$lang$applyTo = (function (arglist__16397){
var url = cljs.core.first(arglist__16397);
var content = cljs.core.rest(arglist__16397);
return G__16396__delegate(url, content);
});
G__16396.cljs$lang$arity$variadic = G__16396__delegate;
return G__16396;
})()
;
crate.element.link_to = crate.compiler.add_optional_attrs.call(null,func__6156__auto____16395);
var func__6156__auto____16403 = (function() { 
var G__16404__delegate = function (e_mail,p__16398){
var vec__16399__16400 = p__16398;
var content__16401 = cljs.core.nth.call(null,vec__16399__16400,0,null);
return cljs.core.PersistentVector.fromArray(["\uFDD0'a",cljs.core.ObjMap.fromObject(["\uFDD0'href"],{"\uFDD0'href":[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')}),(function (){var or__3824__auto____16402 = content__16401;
if(cljs.core.truth_(or__3824__auto____16402))
{return or__3824__auto____16402;
} else
{return e_mail;
}
})()], true);
};
var G__16404 = function (e_mail,var_args){
var p__16398 = null;
if (goog.isDef(var_args)) {
  p__16398 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);
} 
return G__16404__delegate.call(this, e_mail, p__16398);
};
G__16404.cljs$lang$maxFixedArity = 1;
G__16404.cljs$lang$applyTo = (function (arglist__16405){
var e_mail = cljs.core.first(arglist__16405);
var p__16398 = cljs.core.rest(arglist__16405);
return G__16404__delegate(e_mail, p__16398);
});
G__16404.cljs$lang$arity$variadic = G__16404__delegate;
return G__16404;
})()
;
crate.element.mail_to = crate.compiler.add_optional_attrs.call(null,func__6156__auto____16403);
var func__6156__auto____16413 = (function (coll){
return cljs.core.PersistentVector.fromArray(["\uFDD0'ul",(function (){var iter__4984__auto____16412 = (function iter__16406(s__16407){
return (new cljs.core.LazySeq(null,false,(function (){
var s__16407__16410 = s__16407;
while(true){
if(cljs.core.seq.call(null,s__16407__16410))
{var x__16411 = cljs.core.first.call(null,s__16407__16410);
return cljs.core.cons.call(null,cljs.core.PersistentVector.fromArray(["\uFDD0'li",x__16411], true),iter__16406.call(null,cljs.core.rest.call(null,s__16407__16410)));
} else
{return null;
}
break;
}
}),null));
});
return iter__4984__auto____16412.call(null,coll);
})()], true);
});
crate.element.unordered_list = crate.compiler.add_optional_attrs.call(null,func__6156__auto____16413);
var func__6156__auto____16421 = (function (coll){
return cljs.core.PersistentVector.fromArray(["\uFDD0'ol",(function (){var iter__4984__auto____16420 = (function iter__16414(s__16415){
return (new cljs.core.LazySeq(null,false,(function (){
var s__16415__16418 = s__16415;
while(true){
if(cljs.core.seq.call(null,s__16415__16418))
{var x__16419 = cljs.core.first.call(null,s__16415__16418);
return cljs.core.cons.call(null,cljs.core.PersistentVector.fromArray(["\uFDD0'li",x__16419], true),iter__16414.call(null,cljs.core.rest.call(null,s__16415__16418)));
} else
{return null;
}
break;
}
}),null));
});
return iter__4984__auto____16420.call(null,coll);
})()], true);
});
crate.element.ordered_list = crate.compiler.add_optional_attrs.call(null,func__6156__auto____16421);
var func__6156__auto____16422 = (function() {
var G__16423 = null;
var G__16423__1 = (function (src){
return cljs.core.PersistentVector.fromArray(["\uFDD0'img",cljs.core.ObjMap.fromObject(["\uFDD0'src"],{"\uFDD0'src":crate.util.to_uri.call(null,src)})], true);
});
var G__16423__2 = (function (src,alt){
return cljs.core.PersistentVector.fromArray(["\uFDD0'img",cljs.core.ObjMap.fromObject(["\uFDD0'src","\uFDD0'alt"],{"\uFDD0'src":crate.util.to_uri.call(null,src),"\uFDD0'alt":alt})], true);
});
G__16423 = function(src,alt){
switch(arguments.length){
case 1:
return G__16423__1.call(this,src);
case 2:
return G__16423__2.call(this,src,alt);
}
throw('Invalid arity: ' + arguments.length);
};
return G__16423;
})()
;
crate.element.image = crate.compiler.add_optional_attrs.call(null,func__6156__auto____16422);
