goog.provide('crate.compiler');
goog.require('cljs.core');
goog.require('crate.binding');
goog.require('clojure.string');
goog.require('goog.style');
goog.require('goog.dom');
crate.compiler.xmlns = cljs.core.ObjMap.fromObject(["\uFDD0'xhtml","\uFDD0'svg"],{"\uFDD0'xhtml":"http://www.w3.org/1999/xhtml","\uFDD0'svg":"http://www.w3.org/2000/svg"});
crate.compiler.group_id = cljs.core.atom.call(null,0);
crate.compiler.bindings = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
crate.compiler.capture_binding = (function capture_binding(tag,b){
return cljs.core.swap_BANG_.call(null,crate.compiler.bindings,cljs.core.conj,cljs.core.PersistentVector.fromArray([tag,b], true));
});
crate.compiler.as_content = (function as_content(parent,content){
var G__15651__15652 = cljs.core.seq.call(null,content);
if(G__15651__15652)
{var c__15653 = cljs.core.first.call(null,G__15651__15652);
var G__15651__15654 = G__15651__15652;
while(true){
var child__15655 = (((c__15653 == null))?null:((cljs.core.map_QMARK_.call(null,c__15653))?(function(){throw "Maps cannot be used as content"})():((cljs.core.string_QMARK_.call(null,c__15653))?goog.dom.createTextNode(c__15653):((cljs.core.vector_QMARK_.call(null,c__15653))?crate.compiler.elem_factory.call(null,c__15653):((cljs.core.seq_QMARK_.call(null,c__15653))?as_content.call(null,parent,c__15653):(cljs.core.truth_(crate.binding.binding_coll_QMARK_.call(null,c__15653))?(function (){crate.compiler.capture_binding.call(null,"\uFDD0'coll",c__15653);
return as_content.call(null,parent,cljs.core.PersistentVector.fromArray([crate.binding.value.call(null,c__15653)], true));
})():(cljs.core.truth_(crate.binding.binding_QMARK_.call(null,c__15653))?(function (){crate.compiler.capture_binding.call(null,"\uFDD0'text",c__15653);
return as_content.call(null,parent,cljs.core.PersistentVector.fromArray([crate.binding.value.call(null,c__15653)], true));
})():(cljs.core.truth_(c__15653.nodeName)?c__15653:(cljs.core.truth_(c__15653.get)?c__15653.get(0):(("\uFDD0'else")?goog.dom.createTextNode([cljs.core.str(c__15653)].join('')):null))))))))));
if(cljs.core.truth_(child__15655))
{goog.dom.appendChild(parent,child__15655);
} else
{}
var temp__3974__auto____15656 = cljs.core.next.call(null,G__15651__15654);
if(temp__3974__auto____15656)
{var G__15651__15657 = temp__3974__auto____15656;
{
var G__15658 = cljs.core.first.call(null,G__15651__15657);
var G__15659 = G__15651__15657;
c__15653 = G__15658;
G__15651__15654 = G__15659;
continue;
}
} else
{return null;
}
break;
}
} else
{return null;
}
});
crate.compiler.dom_binding = (function (){var method_table__5059__auto____15660 = cljs.core.atom.call(null,cljs.core.ObjMap.EMPTY);
var prefer_table__5060__auto____15661 = cljs.core.atom.call(null,cljs.core.ObjMap.EMPTY);
var method_cache__5061__auto____15662 = cljs.core.atom.call(null,cljs.core.ObjMap.EMPTY);
var cached_hierarchy__5062__auto____15663 = cljs.core.atom.call(null,cljs.core.ObjMap.EMPTY);
var hierarchy__5063__auto____15664 = cljs.core._lookup.call(null,cljs.core.ObjMap.EMPTY,"\uFDD0'hierarchy",cljs.core.global_hierarchy);
return (new cljs.core.MultiFn("dom-binding",(function (type,_15665,_){
return type;
}),"\uFDD0'default",hierarchy__5063__auto____15664,method_table__5059__auto____15660,prefer_table__5060__auto____15661,method_cache__5061__auto____15662,cached_hierarchy__5062__auto____15663));
})();
cljs.core._add_method.call(null,crate.compiler.dom_binding,"\uFDD0'text",(function (_,b,elem){
return crate.binding.on_change.call(null,b,(function (v){
goog.dom.removeChildren(elem);
return crate.compiler.as_content.call(null,elem,cljs.core.PersistentVector.fromArray([v], true));
}));
}));
cljs.core._add_method.call(null,crate.compiler.dom_binding,"\uFDD0'attr",(function (_,p__15666,elem){
var vec__15667__15668 = p__15666;
var k__15669 = cljs.core.nth.call(null,vec__15667__15668,0,null);
var b__15670 = cljs.core.nth.call(null,vec__15667__15668,1,null);
return crate.binding.on_change.call(null,b__15670,(function (v){
return crate.compiler.dom_attr.call(null,elem,k__15669,v);
}));
}));
cljs.core._add_method.call(null,crate.compiler.dom_binding,"\uFDD0'style",(function (_,p__15671,elem){
var vec__15672__15673 = p__15671;
var k__15674 = cljs.core.nth.call(null,vec__15672__15673,0,null);
var b__15675 = cljs.core.nth.call(null,vec__15672__15673,1,null);
return crate.binding.on_change.call(null,b__15675,(function (v){
if(cljs.core.truth_(k__15674))
{return crate.compiler.dom_style.call(null,elem,k__15674,v);
} else
{return crate.compiler.dom_style.call(null,elem,v);
}
}));
}));
crate.compiler.dom_add = (function dom_add(bc,parent,elem,v){
var temp__3971__auto____15678 = crate.binding.opt.call(null,bc,"\uFDD0'add");
if(cljs.core.truth_(temp__3971__auto____15678))
{var adder__15679 = temp__3971__auto____15678;
return adder__15679.call(null,parent,elem,v);
} else
{return goog.dom.appendChild(parent,elem);
}
});
crate.compiler.dom_remove = (function dom_remove(bc,elem){
var temp__3971__auto____15682 = crate.binding.opt.call(null,bc,"\uFDD0'remove");
if(cljs.core.truth_(temp__3971__auto____15682))
{var remover__15683 = temp__3971__auto____15682;
return remover__15683.call(null,elem);
} else
{return goog.dom.removeNode(elem);
}
});
cljs.core._add_method.call(null,crate.compiler.dom_binding,"\uFDD0'coll",(function (_,bc,parent){
return crate.binding.on_change.call(null,bc,(function (type,elem,v){
var pred__15684__15687 = cljs.core._EQ_;
var expr__15685__15688 = type;
if(pred__15684__15687.call(null,"\uFDD0'add",expr__15685__15688))
{return crate.compiler.dom_add.call(null,bc,parent,elem,v);
} else
{if(pred__15684__15687.call(null,"\uFDD0'remove",expr__15685__15688))
{return crate.compiler.dom_remove.call(null,bc,elem);
} else
{throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__15685__15688)].join('')));
}
}
}));
}));
crate.compiler.handle_bindings = (function handle_bindings(bs,elem){
var G__15708__15709 = cljs.core.seq.call(null,bs);
if(G__15708__15709)
{var G__15711__15713 = cljs.core.first.call(null,G__15708__15709);
var vec__15712__15714 = G__15711__15713;
var type__15715 = cljs.core.nth.call(null,vec__15712__15714,0,null);
var b__15716 = cljs.core.nth.call(null,vec__15712__15714,1,null);
var G__15708__15717 = G__15708__15709;
var G__15711__15718 = G__15711__15713;
var G__15708__15719 = G__15708__15717;
while(true){
var vec__15720__15721 = G__15711__15718;
var type__15722 = cljs.core.nth.call(null,vec__15720__15721,0,null);
var b__15723 = cljs.core.nth.call(null,vec__15720__15721,1,null);
var G__15708__15724 = G__15708__15719;
crate.compiler.dom_binding.call(null,type__15722,b__15723,elem);
var temp__3974__auto____15725 = cljs.core.next.call(null,G__15708__15724);
if(temp__3974__auto____15725)
{var G__15708__15726 = temp__3974__auto____15725;
{
var G__15727 = cljs.core.first.call(null,G__15708__15726);
var G__15728 = G__15708__15726;
G__15711__15718 = G__15727;
G__15708__15719 = G__15728;
continue;
}
} else
{return null;
}
break;
}
} else
{return null;
}
});
crate.compiler.dom_style = (function() {
var dom_style = null;
var dom_style__2 = (function (elem,v){
if(cljs.core.string_QMARK_.call(null,v))
{elem.setAttribute("style",v);
} else
{if(cljs.core.map_QMARK_.call(null,v))
{var G__15749__15750 = cljs.core.seq.call(null,v);
if(G__15749__15750)
{var G__15752__15754 = cljs.core.first.call(null,G__15749__15750);
var vec__15753__15755 = G__15752__15754;
var k__15756 = cljs.core.nth.call(null,vec__15753__15755,0,null);
var v__15757 = cljs.core.nth.call(null,vec__15753__15755,1,null);
var G__15749__15758 = G__15749__15750;
var G__15752__15759 = G__15752__15754;
var G__15749__15760 = G__15749__15758;
while(true){
var vec__15761__15762 = G__15752__15759;
var k__15763 = cljs.core.nth.call(null,vec__15761__15762,0,null);
var v__15764 = cljs.core.nth.call(null,vec__15761__15762,1,null);
var G__15749__15765 = G__15749__15760;
dom_style.call(null,elem,k__15763,v__15764);
var temp__3974__auto____15766 = cljs.core.next.call(null,G__15749__15765);
if(temp__3974__auto____15766)
{var G__15749__15767 = temp__3974__auto____15766;
{
var G__15769 = cljs.core.first.call(null,G__15749__15767);
var G__15770 = G__15749__15767;
G__15752__15759 = G__15769;
G__15749__15760 = G__15770;
continue;
}
} else
{}
break;
}
} else
{}
} else
{if(cljs.core.truth_(crate.binding.binding_QMARK_.call(null,v)))
{crate.compiler.capture_binding.call(null,"\uFDD0'style",cljs.core.PersistentVector.fromArray([null,v], true));
dom_style.call(null,elem,crate.binding.value.call(null,v));
} else
{}
}
}
return elem;
});
var dom_style__3 = (function (elem,k,v){
var v__15768 = (cljs.core.truth_(crate.binding.binding_QMARK_.call(null,v))?(function (){crate.compiler.capture_binding.call(null,"\uFDD0'style",cljs.core.PersistentVector.fromArray([k,v], true));
return crate.binding.value.call(null,v);
})():v);
return goog.style.setStyle(elem,cljs.core.name.call(null,k),v__15768);
});
dom_style = function(elem,k,v){
switch(arguments.length){
case 2:
return dom_style__2.call(this,elem,k);
case 3:
return dom_style__3.call(this,elem,k,v);
}
throw('Invalid arity: ' + arguments.length);
};
dom_style.cljs$lang$arity$2 = dom_style__2;
dom_style.cljs$lang$arity$3 = dom_style__3;
return dom_style;
})()
;
crate.compiler.dom_attr = (function() {
var dom_attr = null;
var dom_attr__2 = (function (elem,attrs){
if(cljs.core.truth_(elem))
{if(!(cljs.core.map_QMARK_.call(null,attrs)))
{return elem.getAttribute(cljs.core.name.call(null,attrs));
} else
{var G__15791__15792 = cljs.core.seq.call(null,attrs);
if(G__15791__15792)
{var G__15794__15796 = cljs.core.first.call(null,G__15791__15792);
var vec__15795__15797 = G__15794__15796;
var k__15798 = cljs.core.nth.call(null,vec__15795__15797,0,null);
var v__15799 = cljs.core.nth.call(null,vec__15795__15797,1,null);
var G__15791__15800 = G__15791__15792;
var G__15794__15801 = G__15794__15796;
var G__15791__15802 = G__15791__15800;
while(true){
var vec__15803__15804 = G__15794__15801;
var k__15805 = cljs.core.nth.call(null,vec__15803__15804,0,null);
var v__15806 = cljs.core.nth.call(null,vec__15803__15804,1,null);
var G__15791__15807 = G__15791__15802;
dom_attr.call(null,elem,k__15805,v__15806);
var temp__3974__auto____15808 = cljs.core.next.call(null,G__15791__15807);
if(temp__3974__auto____15808)
{var G__15791__15809 = temp__3974__auto____15808;
{
var G__15811 = cljs.core.first.call(null,G__15791__15809);
var G__15812 = G__15791__15809;
G__15794__15801 = G__15811;
G__15791__15802 = G__15812;
continue;
}
} else
{}
break;
}
} else
{}
return elem;
}
} else
{return null;
}
});
var dom_attr__3 = (function (elem,k,v){
if(cljs.core._EQ_.call(null,k,"\uFDD0'style"))
{crate.compiler.dom_style.call(null,elem,v);
} else
{var v__15810 = (cljs.core.truth_(crate.binding.binding_QMARK_.call(null,v))?(function (){crate.compiler.capture_binding.call(null,"\uFDD0'attr",cljs.core.PersistentVector.fromArray([k,v], true));
return crate.binding.value.call(null,v);
})():v);
elem.setAttribute(cljs.core.name.call(null,k),v__15810);
}
return elem;
});
dom_attr = function(elem,k,v){
switch(arguments.length){
case 2:
return dom_attr__2.call(this,elem,k);
case 3:
return dom_attr__3.call(this,elem,k,v);
}
throw('Invalid arity: ' + arguments.length);
};
dom_attr.cljs$lang$arity$2 = dom_attr__2;
dom_attr.cljs$lang$arity$3 = dom_attr__3;
return dom_attr;
})()
;
/**
* Regular expression that parses a CSS-style id and class from a tag name.
*/
crate.compiler.re_tag = /([^\s\.#]+)(?:#([^\s\.#]+))?(?:\.([^\s#]+))?/;
crate.compiler.normalize_map_attrs = (function normalize_map_attrs(map_attrs){
return cljs.core.into.call(null,cljs.core.ObjMap.EMPTY,cljs.core.map.call(null,(function (p__15819){
var vec__15820__15821 = p__15819;
var n__15822 = cljs.core.nth.call(null,vec__15820__15821,0,null);
var v__15823 = cljs.core.nth.call(null,vec__15820__15821,1,null);
if(v__15823 === true)
{return cljs.core.PersistentVector.fromArray([n__15822,cljs.core.name.call(null,n__15822)], true);
} else
{return cljs.core.PersistentVector.fromArray([n__15822,v__15823], true);
}
}),cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.boolean$,cljs.core.second),map_attrs)));
});
/**
* Ensure a tag vector is of the form [tag-name attrs content].
*/
crate.compiler.normalize_element = (function normalize_element(p__15824){
var vec__15850__15851 = p__15824;
var tag__15852 = cljs.core.nth.call(null,vec__15850__15851,0,null);
var content__15853 = cljs.core.nthnext.call(null,vec__15850__15851,1);
if(!((function (){var or__3824__auto____15854 = cljs.core.keyword_QMARK_.call(null,tag__15852);
if(or__3824__auto____15854)
{return or__3824__auto____15854;
} else
{var or__3824__auto____15855 = cljs.core.symbol_QMARK_.call(null,tag__15852);
if(or__3824__auto____15855)
{return or__3824__auto____15855;
} else
{return cljs.core.string_QMARK_.call(null,tag__15852);
}
}
})()))
{throw [cljs.core.str(tag__15852),cljs.core.str(" is not a valid tag name.")].join('');
} else
{}
var vec__15856__15858 = cljs.core.re_matches.call(null,crate.compiler.re_tag,cljs.core.name.call(null,tag__15852));
var ___15859 = cljs.core.nth.call(null,vec__15856__15858,0,null);
var tag__15860 = cljs.core.nth.call(null,vec__15856__15858,1,null);
var id__15861 = cljs.core.nth.call(null,vec__15856__15858,2,null);
var class__15862 = cljs.core.nth.call(null,vec__15856__15858,3,null);
var vec__15857__15869 = (function (){var vec__15863__15864 = clojure.string.split.call(null,tag__15860,/:/);
var nsp__15865 = cljs.core.nth.call(null,vec__15863__15864,0,null);
var t__15866 = cljs.core.nth.call(null,vec__15863__15864,1,null);
var ns_xmlns__15867 = crate.compiler.xmlns.call(null,cljs.core.keyword.call(null,nsp__15865));
if(cljs.core.truth_(t__15866))
{return cljs.core.PersistentVector.fromArray([(function (){var or__3824__auto____15868 = ns_xmlns__15867;
if(cljs.core.truth_(or__3824__auto____15868))
{return or__3824__auto____15868;
} else
{return nsp__15865;
}
})(),t__15866], true);
} else
{return cljs.core.PersistentVector.fromArray([(new cljs.core.Keyword("\uFDD0'xhtml")).call(null,crate.compiler.xmlns),nsp__15865], true);
}
})();
var nsp__15870 = cljs.core.nth.call(null,vec__15857__15869,0,null);
var tag__15871 = cljs.core.nth.call(null,vec__15857__15869,1,null);
var tag_attrs__15873 = cljs.core.into.call(null,cljs.core.ObjMap.EMPTY,cljs.core.filter.call(null,(function (p1__15813_SHARP_){
return !((cljs.core.second.call(null,p1__15813_SHARP_) == null));
}),cljs.core.ObjMap.fromObject(["\uFDD0'id","\uFDD0'class"],{"\uFDD0'id":(function (){var or__3824__auto____15872 = id__15861;
if(cljs.core.truth_(or__3824__auto____15872))
{return or__3824__auto____15872;
} else
{return null;
}
})(),"\uFDD0'class":(cljs.core.truth_(class__15862)?clojure.string.replace.call(null,class__15862,/\./," "):null)})));
var map_attrs__15874 = cljs.core.first.call(null,content__15853);
if(cljs.core.map_QMARK_.call(null,map_attrs__15874))
{return cljs.core.PersistentVector.fromArray([nsp__15870,tag__15871,cljs.core.merge.call(null,tag_attrs__15873,crate.compiler.normalize_map_attrs.call(null,map_attrs__15874)),cljs.core.next.call(null,content__15853)], true);
} else
{return cljs.core.PersistentVector.fromArray([nsp__15870,tag__15871,tag_attrs__15873,content__15853], true);
}
});
crate.compiler.parse_content = (function parse_content(elem,content){
var attrs__15876 = cljs.core.first.call(null,content);
if(cljs.core.map_QMARK_.call(null,attrs__15876))
{crate.compiler.dom_attr.call(null,elem,attrs__15876);
return cljs.core.rest.call(null,content);
} else
{return content;
}
});
crate.compiler.create_elem = (cljs.core.truth_(document.createElementNS)?(function (nsp,tag){
return document.createElementNS(nsp,tag);
}):(function (_,tag){
return document.createElement(tag);
}));
crate.compiler.elem_factory = (function elem_factory(tag_def){
var bindings15887__15888 = crate.compiler.bindings;
try{crate.compiler.bindings = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
var vec__15890__15891 = crate.compiler.normalize_element.call(null,tag_def);
var nsp__15892 = cljs.core.nth.call(null,vec__15890__15891,0,null);
var tag__15893 = cljs.core.nth.call(null,vec__15890__15891,1,null);
var attrs__15894 = cljs.core.nth.call(null,vec__15890__15891,2,null);
var content__15895 = cljs.core.nth.call(null,vec__15890__15891,3,null);
var elem__15896 = crate.compiler.create_elem.call(null,nsp__15892,tag__15893);
crate.compiler.dom_attr.call(null,elem__15896,attrs__15894);
crate.compiler.as_content.call(null,elem__15896,content__15895);
crate.compiler.handle_bindings.call(null,cljs.core.deref.call(null,crate.compiler.bindings),elem__15896);
return elem__15896;
}finally {crate.compiler.bindings = bindings15887__15888;
}});
/**
* Add an optional attribute argument to a function that returns a vector tag.
*/
crate.compiler.add_optional_attrs = (function add_optional_attrs(func){
return (function() { 
var G__15905__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args)))
{var vec__15901__15902 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var tag__15903 = cljs.core.nth.call(null,vec__15901__15902,0,null);
var body__15904 = cljs.core.nthnext.call(null,vec__15901__15902,1);
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body__15904)))
{return cljs.core.apply.call(null,cljs.core.vector,tag__15903,cljs.core.merge.call(null,cljs.core.first.call(null,body__15904),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body__15904));
} else
{return cljs.core.apply.call(null,cljs.core.vector,tag__15903,cljs.core.first.call(null,args),body__15904);
}
} else
{return cljs.core.apply.call(null,func,args);
}
};
var G__15905 = function (var_args){
var args = null;
if (goog.isDef(var_args)) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);
} 
return G__15905__delegate.call(this, args);
};
G__15905.cljs$lang$maxFixedArity = 0;
G__15905.cljs$lang$applyTo = (function (arglist__15906){
var args = cljs.core.seq(arglist__15906);;
return G__15905__delegate(args);
});
G__15905.cljs$lang$arity$variadic = G__15905__delegate;
return G__15905;
})()
;
});
