(ns leiningen.new.ninja
  (:use [leiningen.new.templates :only [renderer name-to-path ->files]]))

(def render (renderer "ninja"))

(defn ninja
  "Ninja template files."
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (->files data
             ;; Server files
             ["src/clj/{{sanitized}}/core.clj" (render "src/clj/ninja/core.clj" data)]
             ;; Crossover files
             ["src/clj/{{sanitized}}/crossover/views/layout/application.clj" (render "src/clj/ninja/crossover/views/layout/application.clj" data)]
             ["src/clj/{{sanitized}}/crossover/views/helpers.clj" (render "src/clj/ninja/crossover/views/helpers.clj" data)]
             ["src/clj/{{sanitized}}/crossover/config.clj" (render "src/clj/ninja/crossover/config.clj" data)]
             ;; Client files
             ["src/cljs/{{sanitized}}/client.cljs" (render "src/cljs/ninja/client.clj" data)]
             ;; Resource files
             ["resources/public/css/style.css" (render "resources/public/css/style.css" data)]
             ;; Config files
             [".lein-ninja/deploy.clj" (render "src/deploy.clj" data)]
             ;; Project files
             ["README.md" (render "README.md" data)]
             ["project.clj" (render "project.clj" data)])))
