;;;;
;; Copyright © 2019-2020 anywhere.ninja. All rights reserved.
;; The use and distribution terms for this software are covered by the license which
;; can be found in the file license at the root of this distribution.
;; By using this software in any fashion, you are agreeing to be bound by the terms
;; of this license. You must not remove this notice, or any other, from this software.
;;;;

(ns ninja.unifier.helpers
  "Unifier helper functions.")


(defn cljs?
  "Checks &env in macro and returns `true` if that cljs env. Otherwise `false`."
  {:added "0.0.1"}
  [env]
  (boolean (:ns env)))


(defmacro try-or
  "Extended version of try-catch.
  Usage:
   * (try-or (/ 1 0))                        ;; => nil
   * (try-or (/ 1 0) false)                  ;; => false
   * (try-or (/ 1 0) #(prn (.getMessage %))) ;; => \"Divide by zero\""
  {:added "0.0.1"}
  ([body]
   `(try-or ~body nil))

  ([body res]
   `(try
      ~body
      (catch ~(if-not (cljs? &env) 'Exception :default) error#
        (when-some [res# ~res]
          (cond
            (boolean? res#) res#
            (fn? res#) (res# error#)
            :else error#))))))
