# better-record

A Clojure library that extends records to include options for default values, value transforms, and validations.

## Usage

`better-record` provides a macro `defrecord*` that works like `defrecord` with the additional ability to specify default values, value transforms, and validations.  The following options are available:

Option       | Description
-------------|--------------------
`:default`   | Specify a default value to be used if another is not provided.
`:transform` | Specify a value transform to be applied to a field when a record is created.
`:valid`     | Specify a validation to be applied to a field when a record is created.

Additionally, there are some shortcuts available:

Shortcut     | Equivalent
-------------|--------------------
`:not-nil`   | `:valid (complement nil?)`
`:not-empty` | `:valid seq`
`:not-zero`  | `:valid #(not (or (nil? %) (zero? %)))`
`:trim`      | `:transform clojure.string/trim`


Only one default, one transform, and one validation can be specified for a given field.  Shortcuts count toward those limits.  If a transform and a validation are both specified for a field, the transform is applied before the validation is checked.  Transforms will not be applied to `nil` values.  If a validation fails, an `IllegalArgumentException` is thrown.

When a record `Rec` is declared with `defrecord*`, a method `Rec*` is created that takes 0, 1, or 2 hash-map or record arguments.  With no arguments, the method will return a new `Rec` with default values where specified, and `nil` values for all other fields.  If a single argument is provided, a `Rec` will be returned with the values specified in the argument, and defaults and `nil` values for those fields not specified.  If two arguments are provided, the two arguments will be merged with fields specified in the second argument overriding fields specified in the first argument, and then the result of that merge will be applied as if it were passed to `Rec*` as a single argument.

## Example

To create a record type `Rec`:

```
(defrecord* Rec [string-field :trim :not-empty
                 int-field :default 0 :valid #(< % 5)
                 normal-field])

(Rec* {:string-field "     a "})

;; => Rec{:string-field "a", :int-field 0, :normal-field nil}
```

## License

Copyright © 2018 Niels Paulson

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
