/*
 * Decompiled with CFR 0.152.
 */
package com.nicheware.maven;

import java.util.Properties;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.providers.http.HttpWagon;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;

public class LeinGitlabWagon
extends HttpWagon {
    private static String GITLAB_SCHEME = "gitlab:";
    private static String REPOSITORY_SCHEME = "https:";

    public void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        if (repository.getUrl().startsWith(GITLAB_SCHEME)) {
            repository.setUrl(this.correctUrl(repository));
            this.setHttpHeadersForAuthentication(authenticationInfo);
            super.connect(repository, null, proxyInfoProvider);
        } else {
            super.connect(repository, authenticationInfo, proxyInfoProvider);
        }
    }

    private String correctUrl(Repository repository) {
        return repository.getUrl().replace(GITLAB_SCHEME, REPOSITORY_SCHEME);
    }

    private void setHttpHeadersForAuthentication(AuthenticationInfo authenticationInfo) throws AuthenticationException {
        String token;
        Properties headerProperties = new Properties();
        String tokenName = authenticationInfo.getUserName() != null ? authenticationInfo.getUserName() : "Private-Token";
        String string = token = authenticationInfo.getPassword() != null ? authenticationInfo.getPassword() : authenticationInfo.getPassphrase();
        if (token == null || token.isEmpty()) {
            throw new AuthenticationException("No password or passphrase defined for GitLab token");
        }
        headerProperties.setProperty(tokenName, token);
        this.setHttpHeaders(headerProperties);
    }
}

