// Compiled by ClojureScript 1.9.562 {}
goog.provide('plumbing.core');
goog.require('cljs.core');
goog.require('schema.utils');
goog.require('plumbing.fnk.schema');
/**
 * A sentinel value representing missing portions of the input data.
 */
plumbing.core._PLUS_none_PLUS_ = new cljs.core.Keyword("plumbing.core","missing","plumbing.core/missing",1721767298);
/**
 * Updates the value in map m at k with the function f.
 * 
 *  Like update-in, but for updating a single top-level key.
 *  Any additional args will be passed to f after the value.
 * 
 *  WARNING As of Clojure 1.7 this function exists in clojure.core and
 *  will not be exported by this namespace.
 */
plumbing.core.update = (function plumbing$core$update(var_args){
var args17081 = [];
var len__8628__auto___17090 = arguments.length;
var i__8629__auto___17091 = (0);
while(true){
if((i__8629__auto___17091 < len__8628__auto___17090)){
args17081.push((arguments[i__8629__auto___17091]));

var G__17092 = (i__8629__auto___17091 + (1));
i__8629__auto___17091 = G__17092;
continue;
} else {
}
break;
}

var G__17089 = args17081.length;
switch (G__17089) {
case 3:
return plumbing.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return plumbing.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return plumbing.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var argseq__8651__auto__ = (new cljs.core.IndexedSeq(args17081.slice((5)),(0),null));
return plumbing.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__8651__auto__);

}
});

plumbing.core.update.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k)));
});

plumbing.core.update.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,x1){
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),x1));
});

plumbing.core.update.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,x1,x2){
return cljs.core.assoc.call(null,m,k,f.call(null,cljs.core.get.call(null,m,k),x1,x2));
});

plumbing.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,x1,x2,xs){
return cljs.core.assoc.call(null,m,k,cljs.core.apply.call(null,f,cljs.core.get.call(null,m,k),x1,x2,xs));
});

plumbing.core.update.cljs$lang$applyTo = (function (seq17082){
var G__17083 = cljs.core.first.call(null,seq17082);
var seq17082__$1 = cljs.core.next.call(null,seq17082);
var G__17084 = cljs.core.first.call(null,seq17082__$1);
var seq17082__$2 = cljs.core.next.call(null,seq17082__$1);
var G__17085 = cljs.core.first.call(null,seq17082__$2);
var seq17082__$3 = cljs.core.next.call(null,seq17082__$2);
var G__17086 = cljs.core.first.call(null,seq17082__$3);
var seq17082__$4 = cljs.core.next.call(null,seq17082__$3);
var G__17087 = cljs.core.first.call(null,seq17082__$4);
var seq17082__$5 = cljs.core.next.call(null,seq17082__$4);
return plumbing.core.update.cljs$core$IFn$_invoke$arity$variadic(G__17083,G__17084,G__17085,G__17086,G__17087,seq17082__$5);
});

plumbing.core.update.cljs$lang$maxFixedArity = (5);

/**
 * Build map k -> (f v) for [k v] in map, preserving the initial type
 */
plumbing.core.map_vals = (function plumbing$core$map_vals(f,m){
if(cljs.core.sorted_QMARK_.call(null,m)){
return cljs.core.reduce_kv.call(null,(function (out_m,k,v){
return cljs.core.assoc.call(null,out_m,k,f.call(null,v));
}),cljs.core.sorted_map.call(null),m);
} else {
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,(function (out_m,k,v){
return cljs.core.assoc_BANG_.call(null,out_m,k,f.call(null,v));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),m));
} else {
var m_atom__16787__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__17106_17116 = cljs.core.seq.call(null,m);
var chunk__17107_17117 = null;
var count__17108_17118 = (0);
var i__17109_17119 = (0);
while(true){
if((i__17109_17119 < count__17108_17118)){
var vec__17110_17120 = cljs.core._nth.call(null,chunk__17107_17117,i__17109_17119);
var k_17121 = cljs.core.nth.call(null,vec__17110_17120,(0),null);
var v_17122 = cljs.core.nth.call(null,vec__17110_17120,(1),null);
var m17105_17123 = cljs.core.deref.call(null,m_atom__16787__auto__);
cljs.core.reset_BANG_.call(null,m_atom__16787__auto__,cljs.core.assoc_BANG_.call(null,m17105_17123,k_17121,f.call(null,v_17122)));

var G__17124 = seq__17106_17116;
var G__17125 = chunk__17107_17117;
var G__17126 = count__17108_17118;
var G__17127 = (i__17109_17119 + (1));
seq__17106_17116 = G__17124;
chunk__17107_17117 = G__17125;
count__17108_17118 = G__17126;
i__17109_17119 = G__17127;
continue;
} else {
var temp__5278__auto___17128 = cljs.core.seq.call(null,seq__17106_17116);
if(temp__5278__auto___17128){
var seq__17106_17129__$1 = temp__5278__auto___17128;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__17106_17129__$1)){
var c__8318__auto___17130 = cljs.core.chunk_first.call(null,seq__17106_17129__$1);
var G__17131 = cljs.core.chunk_rest.call(null,seq__17106_17129__$1);
var G__17132 = c__8318__auto___17130;
var G__17133 = cljs.core.count.call(null,c__8318__auto___17130);
var G__17134 = (0);
seq__17106_17116 = G__17131;
chunk__17107_17117 = G__17132;
count__17108_17118 = G__17133;
i__17109_17119 = G__17134;
continue;
} else {
var vec__17113_17135 = cljs.core.first.call(null,seq__17106_17129__$1);
var k_17136 = cljs.core.nth.call(null,vec__17113_17135,(0),null);
var v_17137 = cljs.core.nth.call(null,vec__17113_17135,(1),null);
var m17105_17138 = cljs.core.deref.call(null,m_atom__16787__auto__);
cljs.core.reset_BANG_.call(null,m_atom__16787__auto__,cljs.core.assoc_BANG_.call(null,m17105_17138,k_17136,f.call(null,v_17137)));

var G__17139 = cljs.core.next.call(null,seq__17106_17129__$1);
var G__17140 = null;
var G__17141 = (0);
var G__17142 = (0);
seq__17106_17116 = G__17139;
chunk__17107_17117 = G__17140;
count__17108_17118 = G__17141;
i__17109_17119 = G__17142;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16787__auto__));

}
}
});
/**
 * Build map (f k) -> v for [k v] in map m
 */
plumbing.core.map_keys = (function plumbing$core$map_keys(f,m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce_kv.call(null,(function (out_m,k,v){
return cljs.core.assoc_BANG_.call(null,out_m,f.call(null,k),v);
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),m));
} else {
var m_atom__16787__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__17155_17165 = cljs.core.seq.call(null,m);
var chunk__17156_17166 = null;
var count__17157_17167 = (0);
var i__17158_17168 = (0);
while(true){
if((i__17158_17168 < count__17157_17167)){
var vec__17159_17169 = cljs.core._nth.call(null,chunk__17156_17166,i__17158_17168);
var k_17170 = cljs.core.nth.call(null,vec__17159_17169,(0),null);
var v_17171 = cljs.core.nth.call(null,vec__17159_17169,(1),null);
var m17154_17172 = cljs.core.deref.call(null,m_atom__16787__auto__);
cljs.core.reset_BANG_.call(null,m_atom__16787__auto__,cljs.core.assoc_BANG_.call(null,m17154_17172,f.call(null,k_17170),v_17171));

var G__17173 = seq__17155_17165;
var G__17174 = chunk__17156_17166;
var G__17175 = count__17157_17167;
var G__17176 = (i__17158_17168 + (1));
seq__17155_17165 = G__17173;
chunk__17156_17166 = G__17174;
count__17157_17167 = G__17175;
i__17158_17168 = G__17176;
continue;
} else {
var temp__5278__auto___17177 = cljs.core.seq.call(null,seq__17155_17165);
if(temp__5278__auto___17177){
var seq__17155_17178__$1 = temp__5278__auto___17177;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__17155_17178__$1)){
var c__8318__auto___17179 = cljs.core.chunk_first.call(null,seq__17155_17178__$1);
var G__17180 = cljs.core.chunk_rest.call(null,seq__17155_17178__$1);
var G__17181 = c__8318__auto___17179;
var G__17182 = cljs.core.count.call(null,c__8318__auto___17179);
var G__17183 = (0);
seq__17155_17165 = G__17180;
chunk__17156_17166 = G__17181;
count__17157_17167 = G__17182;
i__17158_17168 = G__17183;
continue;
} else {
var vec__17162_17184 = cljs.core.first.call(null,seq__17155_17178__$1);
var k_17185 = cljs.core.nth.call(null,vec__17162_17184,(0),null);
var v_17186 = cljs.core.nth.call(null,vec__17162_17184,(1),null);
var m17154_17187 = cljs.core.deref.call(null,m_atom__16787__auto__);
cljs.core.reset_BANG_.call(null,m_atom__16787__auto__,cljs.core.assoc_BANG_.call(null,m17154_17187,f.call(null,k_17185),v_17186));

var G__17188 = cljs.core.next.call(null,seq__17155_17178__$1);
var G__17189 = null;
var G__17190 = (0);
var G__17191 = (0);
seq__17155_17165 = G__17188;
chunk__17156_17166 = G__17189;
count__17157_17167 = G__17190;
i__17158_17168 = G__17191;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16787__auto__));
}
});
/**
 * Build map k -> (f k) for keys in ks
 */
plumbing.core.map_from_keys = (function plumbing$core$map_from_keys(f,ks){
var m_atom__16787__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__17198_17202 = cljs.core.seq.call(null,ks);
var chunk__17199_17203 = null;
var count__17200_17204 = (0);
var i__17201_17205 = (0);
while(true){
if((i__17201_17205 < count__17200_17204)){
var k_17206 = cljs.core._nth.call(null,chunk__17199_17203,i__17201_17205);
var m17197_17207 = cljs.core.deref.call(null,m_atom__16787__auto__);
cljs.core.reset_BANG_.call(null,m_atom__16787__auto__,cljs.core.assoc_BANG_.call(null,m17197_17207,k_17206,f.call(null,k_17206)));

var G__17208 = seq__17198_17202;
var G__17209 = chunk__17199_17203;
var G__17210 = count__17200_17204;
var G__17211 = (i__17201_17205 + (1));
seq__17198_17202 = G__17208;
chunk__17199_17203 = G__17209;
count__17200_17204 = G__17210;
i__17201_17205 = G__17211;
continue;
} else {
var temp__5278__auto___17212 = cljs.core.seq.call(null,seq__17198_17202);
if(temp__5278__auto___17212){
var seq__17198_17213__$1 = temp__5278__auto___17212;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__17198_17213__$1)){
var c__8318__auto___17214 = cljs.core.chunk_first.call(null,seq__17198_17213__$1);
var G__17215 = cljs.core.chunk_rest.call(null,seq__17198_17213__$1);
var G__17216 = c__8318__auto___17214;
var G__17217 = cljs.core.count.call(null,c__8318__auto___17214);
var G__17218 = (0);
seq__17198_17202 = G__17215;
chunk__17199_17203 = G__17216;
count__17200_17204 = G__17217;
i__17201_17205 = G__17218;
continue;
} else {
var k_17219 = cljs.core.first.call(null,seq__17198_17213__$1);
var m17197_17220 = cljs.core.deref.call(null,m_atom__16787__auto__);
cljs.core.reset_BANG_.call(null,m_atom__16787__auto__,cljs.core.assoc_BANG_.call(null,m17197_17220,k_17219,f.call(null,k_17219)));

var G__17221 = cljs.core.next.call(null,seq__17198_17213__$1);
var G__17222 = null;
var G__17223 = (0);
var G__17224 = (0);
seq__17198_17202 = G__17221;
chunk__17199_17203 = G__17222;
count__17200_17204 = G__17223;
i__17201_17205 = G__17224;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16787__auto__));
});
/**
 * Build map (f v) -> v for vals in vs
 */
plumbing.core.map_from_vals = (function plumbing$core$map_from_vals(f,vs){
var m_atom__16787__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__17231_17235 = cljs.core.seq.call(null,vs);
var chunk__17232_17236 = null;
var count__17233_17237 = (0);
var i__17234_17238 = (0);
while(true){
if((i__17234_17238 < count__17233_17237)){
var v_17239 = cljs.core._nth.call(null,chunk__17232_17236,i__17234_17238);
var m17230_17240 = cljs.core.deref.call(null,m_atom__16787__auto__);
cljs.core.reset_BANG_.call(null,m_atom__16787__auto__,cljs.core.assoc_BANG_.call(null,m17230_17240,f.call(null,v_17239),v_17239));

var G__17241 = seq__17231_17235;
var G__17242 = chunk__17232_17236;
var G__17243 = count__17233_17237;
var G__17244 = (i__17234_17238 + (1));
seq__17231_17235 = G__17241;
chunk__17232_17236 = G__17242;
count__17233_17237 = G__17243;
i__17234_17238 = G__17244;
continue;
} else {
var temp__5278__auto___17245 = cljs.core.seq.call(null,seq__17231_17235);
if(temp__5278__auto___17245){
var seq__17231_17246__$1 = temp__5278__auto___17245;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__17231_17246__$1)){
var c__8318__auto___17247 = cljs.core.chunk_first.call(null,seq__17231_17246__$1);
var G__17248 = cljs.core.chunk_rest.call(null,seq__17231_17246__$1);
var G__17249 = c__8318__auto___17247;
var G__17250 = cljs.core.count.call(null,c__8318__auto___17247);
var G__17251 = (0);
seq__17231_17235 = G__17248;
chunk__17232_17236 = G__17249;
count__17233_17237 = G__17250;
i__17234_17238 = G__17251;
continue;
} else {
var v_17252 = cljs.core.first.call(null,seq__17231_17246__$1);
var m17230_17253 = cljs.core.deref.call(null,m_atom__16787__auto__);
cljs.core.reset_BANG_.call(null,m_atom__16787__auto__,cljs.core.assoc_BANG_.call(null,m17230_17253,f.call(null,v_17252),v_17252));

var G__17254 = cljs.core.next.call(null,seq__17231_17246__$1);
var G__17255 = null;
var G__17256 = (0);
var G__17257 = (0);
seq__17231_17235 = G__17254;
chunk__17232_17236 = G__17255;
count__17233_17237 = G__17256;
i__17234_17238 = G__17257;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16787__auto__));
});
/**
 * Dissociate this keyseq from m, removing any empty maps created as a result
 * (including at the top-level).
 */
plumbing.core.dissoc_in = (function plumbing$core$dissoc_in(m,p__17258){
var vec__17262 = p__17258;
var seq__17263 = cljs.core.seq.call(null,vec__17262);
var first__17264 = cljs.core.first.call(null,seq__17263);
var seq__17263__$1 = cljs.core.next.call(null,seq__17263);
var k = first__17264;
var ks = seq__17263__$1;
if(cljs.core.truth_(m)){
var temp__5276__auto__ = (function (){var and__7395__auto__ = ks;
if(and__7395__auto__){
return plumbing.core.dissoc_in.call(null,cljs.core.get.call(null,m,k),ks);
} else {
return and__7395__auto__;
}
})();
if(cljs.core.truth_(temp__5276__auto__)){
var res = temp__5276__auto__;
return cljs.core.assoc.call(null,m,k,res);
} else {
var res = cljs.core.dissoc.call(null,m,k);
if(cljs.core.empty_QMARK_.call(null,res)){
return null;
} else {
return res;
}
}
} else {
return null;
}
});
/**
 * DEPRECATED.  prefer clojure.walk/keywordize-keys.
 * 
 * Recursively convert maps in m (including itself)
 * to have keyword keys instead of string
 */
plumbing.core.keywordize_map = (function plumbing$core$keywordize_map(x){
if(cljs.core.map_QMARK_.call(null,x)){
var m_atom__16787__auto__ = cljs.core.atom.call(null,cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY));
var seq__17277_17287 = cljs.core.seq.call(null,x);
var chunk__17278_17288 = null;
var count__17279_17289 = (0);
var i__17280_17290 = (0);
while(true){
if((i__17280_17290 < count__17279_17289)){
var vec__17281_17291 = cljs.core._nth.call(null,chunk__17278_17288,i__17280_17290);
var k_17292 = cljs.core.nth.call(null,vec__17281_17291,(0),null);
var v_17293 = cljs.core.nth.call(null,vec__17281_17291,(1),null);
var m17276_17294 = cljs.core.deref.call(null,m_atom__16787__auto__);
cljs.core.reset_BANG_.call(null,m_atom__16787__auto__,cljs.core.assoc_BANG_.call(null,m17276_17294,((typeof k_17292 === 'string')?cljs.core.keyword.call(null,k_17292):k_17292),plumbing.core.keywordize_map.call(null,v_17293)));

var G__17295 = seq__17277_17287;
var G__17296 = chunk__17278_17288;
var G__17297 = count__17279_17289;
var G__17298 = (i__17280_17290 + (1));
seq__17277_17287 = G__17295;
chunk__17278_17288 = G__17296;
count__17279_17289 = G__17297;
i__17280_17290 = G__17298;
continue;
} else {
var temp__5278__auto___17299 = cljs.core.seq.call(null,seq__17277_17287);
if(temp__5278__auto___17299){
var seq__17277_17300__$1 = temp__5278__auto___17299;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__17277_17300__$1)){
var c__8318__auto___17301 = cljs.core.chunk_first.call(null,seq__17277_17300__$1);
var G__17302 = cljs.core.chunk_rest.call(null,seq__17277_17300__$1);
var G__17303 = c__8318__auto___17301;
var G__17304 = cljs.core.count.call(null,c__8318__auto___17301);
var G__17305 = (0);
seq__17277_17287 = G__17302;
chunk__17278_17288 = G__17303;
count__17279_17289 = G__17304;
i__17280_17290 = G__17305;
continue;
} else {
var vec__17284_17306 = cljs.core.first.call(null,seq__17277_17300__$1);
var k_17307 = cljs.core.nth.call(null,vec__17284_17306,(0),null);
var v_17308 = cljs.core.nth.call(null,vec__17284_17306,(1),null);
var m17276_17309 = cljs.core.deref.call(null,m_atom__16787__auto__);
cljs.core.reset_BANG_.call(null,m_atom__16787__auto__,cljs.core.assoc_BANG_.call(null,m17276_17309,((typeof k_17307 === 'string')?cljs.core.keyword.call(null,k_17307):k_17307),plumbing.core.keywordize_map.call(null,v_17308)));

var G__17310 = cljs.core.next.call(null,seq__17277_17300__$1);
var G__17311 = null;
var G__17312 = (0);
var G__17313 = (0);
seq__17277_17287 = G__17310;
chunk__17278_17288 = G__17311;
count__17279_17289 = G__17312;
i__17280_17290 = G__17313;
continue;
}
} else {
}
}
break;
}

return cljs.core.persistent_BANG_.call(null,cljs.core.deref.call(null,m_atom__16787__auto__));
} else {
if(cljs.core.seq_QMARK_.call(null,x)){
return cljs.core.map.call(null,plumbing.core.keywordize_map,x);
} else {
if(cljs.core.vector_QMARK_.call(null,x)){
return cljs.core.mapv.call(null,plumbing.core.keywordize_map,x);
} else {
return x;

}
}
}
});
/**
 * Like get but throw an exception if not found
 */
plumbing.core.safe_get = (function plumbing$core$safe_get(m,k){
var temp__5276__auto__ = cljs.core.find.call(null,m,k);
if(cljs.core.truth_(temp__5276__auto__)){
var pair__16877__auto__ = temp__5276__auto__;
return cljs.core.val.call(null,pair__16877__auto__);
} else {
throw (new Error(schema.utils.format_STAR_.call(null,"Key %s not found in %s",k,cljs.core.mapv.call(null,cljs.core.key,m))));

}
});
/**
 * Like get-in but throws exception if not found
 */
plumbing.core.safe_get_in = (function plumbing$core$safe_get_in(m,ks){
while(true){
if(cljs.core.seq.call(null,ks)){
var G__17314 = plumbing.core.safe_get.call(null,m,cljs.core.first.call(null,ks));
var G__17315 = cljs.core.next.call(null,ks);
m = G__17314;
ks = G__17315;
continue;
} else {
return m;
}
break;
}
});
/**
 * Like assoc but only assocs when value is truthy
 */
plumbing.core.assoc_when = (function plumbing$core$assoc_when(var_args){
var args__8635__auto__ = [];
var len__8628__auto___17334 = arguments.length;
var i__8629__auto___17335 = (0);
while(true){
if((i__8629__auto___17335 < len__8628__auto___17334)){
args__8635__auto__.push((arguments[i__8629__auto___17335]));

var G__17336 = (i__8629__auto___17335 + (1));
i__8629__auto___17335 = G__17336;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((1) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((1)),(0),null)):null);
return plumbing.core.assoc_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8636__auto__);
});

plumbing.core.assoc_when.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if(cljs.core.even_QMARK_.call(null,cljs.core.count.call(null,kvs))){
} else {
throw (new Error("Assert failed: (even? (count kvs))"));
}

return cljs.core.into.call(null,(function (){var or__7407__auto__ = m;
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__8269__auto__ = (function plumbing$core$iter__17318(s__17319){
return (new cljs.core.LazySeq(null,(function (){
var s__17319__$1 = s__17319;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__17319__$1);
if(temp__5278__auto__){
var s__17319__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__17319__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__17319__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__17321 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__17320 = (0);
while(true){
if((i__17320 < size__8268__auto__)){
var vec__17328 = cljs.core._nth.call(null,c__8267__auto__,i__17320);
var k = cljs.core.nth.call(null,vec__17328,(0),null);
var v = cljs.core.nth.call(null,vec__17328,(1),null);
if(cljs.core.truth_(v)){
cljs.core.chunk_append.call(null,b__17321,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__17337 = (i__17320 + (1));
i__17320 = G__17337;
continue;
} else {
var G__17338 = (i__17320 + (1));
i__17320 = G__17338;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17321),plumbing$core$iter__17318.call(null,cljs.core.chunk_rest.call(null,s__17319__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17321),null);
}
} else {
var vec__17331 = cljs.core.first.call(null,s__17319__$2);
var k = cljs.core.nth.call(null,vec__17331,(0),null);
var v = cljs.core.nth.call(null,vec__17331,(1),null);
if(cljs.core.truth_(v)){
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),plumbing$core$iter__17318.call(null,cljs.core.rest.call(null,s__17319__$2)));
} else {
var G__17339 = cljs.core.rest.call(null,s__17319__$2);
s__17319__$1 = G__17339;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8269__auto__.call(null,cljs.core.partition.call(null,(2),kvs));
})());
});

plumbing.core.assoc_when.cljs$lang$maxFixedArity = (1);

plumbing.core.assoc_when.cljs$lang$applyTo = (function (seq17316){
var G__17317 = cljs.core.first.call(null,seq17316);
var seq17316__$1 = cljs.core.next.call(null,seq17316);
return plumbing.core.assoc_when.cljs$core$IFn$_invoke$arity$variadic(G__17317,seq17316__$1);
});

/**
 * Like update-in but returns m unchanged if key-seq is not present.
 */
plumbing.core.update_in_when = (function plumbing$core$update_in_when(var_args){
var args__8635__auto__ = [];
var len__8628__auto___17344 = arguments.length;
var i__8629__auto___17345 = (0);
while(true){
if((i__8629__auto___17345 < len__8628__auto___17344)){
args__8635__auto__.push((arguments[i__8629__auto___17345]));

var G__17346 = (i__8629__auto___17345 + (1));
i__8629__auto___17345 = G__17346;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((3) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((3)),(0),null)):null);
return plumbing.core.update_in_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8636__auto__);
});

plumbing.core.update_in_when.cljs$core$IFn$_invoke$arity$variadic = (function (m,key_seq,f,args){
var found = cljs.core.get_in.call(null,m,key_seq,plumbing.core._PLUS_none_PLUS_);
if(!((plumbing.core._PLUS_none_PLUS_ === found))){
return cljs.core.assoc_in.call(null,m,key_seq,cljs.core.apply.call(null,f,found,args));
} else {
return m;
}
});

plumbing.core.update_in_when.cljs$lang$maxFixedArity = (3);

plumbing.core.update_in_when.cljs$lang$applyTo = (function (seq17340){
var G__17341 = cljs.core.first.call(null,seq17340);
var seq17340__$1 = cljs.core.next.call(null,seq17340);
var G__17342 = cljs.core.first.call(null,seq17340__$1);
var seq17340__$2 = cljs.core.next.call(null,seq17340__$1);
var G__17343 = cljs.core.first.call(null,seq17340__$2);
var seq17340__$3 = cljs.core.next.call(null,seq17340__$2);
return plumbing.core.update_in_when.cljs$core$IFn$_invoke$arity$variadic(G__17341,G__17342,G__17343,seq17340__$3);
});

/**
 * Like group-by, but accepts a map-fn that is applied to values before
 * collected.
 */
plumbing.core.grouped_map = (function plumbing$core$grouped_map(key_fn,map_fn,coll){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (ret,x){
var k = key_fn.call(null,x);
return cljs.core.assoc_BANG_.call(null,ret,k,cljs.core.conj.call(null,cljs.core.get.call(null,ret,k,cljs.core.PersistentVector.EMPTY),map_fn.call(null,x)));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Like (apply concat s) but lazier (and shorter) 
 */
plumbing.core.aconcat = (function plumbing$core$aconcat(s){
return cljs.core.concat.call(null,(new cljs.core.LazySeq(null,(function (){
return cljs.core.first.call(null,s);
}),null,null)),(new cljs.core.LazySeq(null,(function (){
var temp__5278__auto__ = cljs.core.next.call(null,s);
if(temp__5278__auto__){
var n = temp__5278__auto__;
return plumbing.core.aconcat.call(null,n);
} else {
return null;
}
}),null,null)));
});
/**
 * Takes a seqable and returns a lazy sequence that
 * is maximally lazy and doesn't realize elements due to either
 * chunking or apply.
 * 
 * Useful when you don't want chunking, for instance,
 * (first awesome-website? (map slurp +a-bunch-of-urls+))
 * may slurp up to 31 unneed webpages, wherease
 * (first awesome-website? (map slurp (unchunk +a-bunch-of-urls+)))
 * is guaranteed to stop slurping after the first awesome website.
 * 
 *   Taken from http://stackoverflow.com/questions/3407876/how-do-i-avoid-clojures-chunking-behavior-for-lazy-seqs-that-i-want-to-short-ci
 */
plumbing.core.unchunk = (function plumbing$core$unchunk(s){
if(cljs.core.seq.call(null,s)){
return cljs.core.cons.call(null,cljs.core.first.call(null,s),(new cljs.core.LazySeq(null,(function (){
return plumbing.core.unchunk.call(null,cljs.core.rest.call(null,s));
}),null,null)));
} else {
return null;
}
});
/**
 * Return sum of (f x) for each x in xs
 */
plumbing.core.sum = (function plumbing$core$sum(var_args){
var args17347 = [];
var len__8628__auto___17350 = arguments.length;
var i__8629__auto___17351 = (0);
while(true){
if((i__8629__auto___17351 < len__8628__auto___17350)){
args17347.push((arguments[i__8629__auto___17351]));

var G__17352 = (i__8629__auto___17351 + (1));
i__8629__auto___17351 = G__17352;
continue;
} else {
}
break;
}

var G__17349 = args17347.length;
switch (G__17349) {
case 2:
return plumbing.core.sum.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return plumbing.core.sum.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17347.length)].join('')));

}
});

plumbing.core.sum.cljs$core$IFn$_invoke$arity$2 = (function (f,xs){
return cljs.core.reduce.call(null,cljs.core._PLUS_,cljs.core.map.call(null,f,xs));
});

plumbing.core.sum.cljs$core$IFn$_invoke$arity$1 = (function (xs){
return cljs.core.reduce.call(null,cljs.core._PLUS_,xs);
});

plumbing.core.sum.cljs$lang$maxFixedArity = 2;

/**
 * returns (first xs) when xs has only 1 element
 */
plumbing.core.singleton = (function plumbing$core$singleton(xs){
var temp__5278__auto__ = cljs.core.seq.call(null,xs);
if(temp__5278__auto__){
var xs__$1 = temp__5278__auto__;
if(cljs.core.next.call(null,xs__$1)){
return null;
} else {
return cljs.core.first.call(null,xs__$1);
}
} else {
return null;
}
});
/**
 * Returns [idx x] for x in seqable s
 */
plumbing.core.indexed = (function plumbing$core$indexed(s){
return cljs.core.map_indexed.call(null,cljs.core.vector,s);
});
/**
 * Returns indices idx of sequence s where (f (nth s idx))
 */
plumbing.core.positions = (function plumbing$core$positions(f,s){
return cljs.core.keep_indexed.call(null,(function (i,x){
if(cljs.core.truth_(f.call(null,x))){
return i;
} else {
return null;
}
}),s);
});
/**
 * Returns elements of xs which return unique
 * values according to f. If multiple elements of xs return the same
 * value under f, the first is returned
 */
plumbing.core.distinct_by = (function plumbing$core$distinct_by(f,xs){
var s = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
var iter__8269__auto__ = ((function (s){
return (function plumbing$core$distinct_by_$_iter__17358(s__17359){
return (new cljs.core.LazySeq(null,((function (s){
return (function (){
var s__17359__$1 = s__17359;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__17359__$1);
if(temp__5278__auto__){
var s__17359__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__17359__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__17359__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__17361 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__17360 = (0);
while(true){
if((i__17360 < size__8268__auto__)){
var x = cljs.core._nth.call(null,c__8267__auto__,i__17360);
var id = f.call(null,x);
if(!(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,s),id))){
cljs.core.chunk_append.call(null,b__17361,(function (){
cljs.core.swap_BANG_.call(null,s,cljs.core.conj,id);

return x;
})()
);

var G__17362 = (i__17360 + (1));
i__17360 = G__17362;
continue;
} else {
var G__17363 = (i__17360 + (1));
i__17360 = G__17363;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17361),plumbing$core$distinct_by_$_iter__17358.call(null,cljs.core.chunk_rest.call(null,s__17359__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__17361),null);
}
} else {
var x = cljs.core.first.call(null,s__17359__$2);
var id = f.call(null,x);
if(!(cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,s),id))){
return cljs.core.cons.call(null,(function (){
cljs.core.swap_BANG_.call(null,s,cljs.core.conj,id);

return x;
})()
,plumbing$core$distinct_by_$_iter__17358.call(null,cljs.core.rest.call(null,s__17359__$2)));
} else {
var G__17364 = cljs.core.rest.call(null,s__17359__$2);
s__17359__$1 = G__17364;
continue;
}
}
} else {
return null;
}
break;
}
});})(s))
,null,null));
});})(s))
;
return iter__8269__auto__.call(null,xs);
});
/**
 * Analogy: partition:partition-all :: interleave:interleave-all
 */
plumbing.core.interleave_all = (function plumbing$core$interleave_all(var_args){
var args__8635__auto__ = [];
var len__8628__auto___17366 = arguments.length;
var i__8629__auto___17367 = (0);
while(true){
if((i__8629__auto___17367 < len__8628__auto___17366)){
args__8635__auto__.push((arguments[i__8629__auto___17367]));

var G__17368 = (i__8629__auto___17367 + (1));
i__8629__auto___17367 = G__17368;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((0) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((0)),(0),null)):null);
return plumbing.core.interleave_all.cljs$core$IFn$_invoke$arity$variadic(argseq__8636__auto__);
});

plumbing.core.interleave_all.cljs$core$IFn$_invoke$arity$variadic = (function (colls){
return (new cljs.core.LazySeq(null,(function (){
return (function plumbing$core$helper(seqs){
if(cljs.core.seq.call(null,seqs)){
return cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.first,seqs),(new cljs.core.LazySeq(null,(function (){
return plumbing$core$helper.call(null,cljs.core.keep.call(null,cljs.core.next,seqs));
}),null,null)));
} else {
return null;
}
}).call(null,cljs.core.keep.call(null,cljs.core.seq,colls));
}),null,null));
});

plumbing.core.interleave_all.cljs$lang$maxFixedArity = (0);

plumbing.core.interleave_all.cljs$lang$applyTo = (function (seq17365){
return plumbing.core.interleave_all.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq17365));
});

/**
 * Returns # of elements of xs where pred holds
 */
plumbing.core.count_when = (function plumbing$core$count_when(pred,xs){
return cljs.core.count.call(null,cljs.core.filter.call(null,pred,xs));
});
/**
 * Like conj but ignores non-truthy values
 */
plumbing.core.conj_when = (function plumbing$core$conj_when(var_args){
var args17369 = [];
var len__8628__auto___17375 = arguments.length;
var i__8629__auto___17376 = (0);
while(true){
if((i__8629__auto___17376 < len__8628__auto___17375)){
args17369.push((arguments[i__8629__auto___17376]));

var G__17377 = (i__8629__auto___17376 + (1));
i__8629__auto___17376 = G__17377;
continue;
} else {
}
break;
}

var G__17374 = args17369.length;
switch (G__17374) {
case 2:
return plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8651__auto__ = (new cljs.core.IndexedSeq(args17369.slice((2)),(0),null));
return plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8651__auto__);

}
});

plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
if(cljs.core.truth_(x)){
return cljs.core.conj.call(null,coll,x);
} else {
return coll;
}
});

plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$variadic = (function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__17379 = plumbing.core.conj_when.call(null,coll,x);
var G__17380 = cljs.core.first.call(null,xs);
var G__17381 = cljs.core.next.call(null,xs);
coll = G__17379;
x = G__17380;
xs = G__17381;
continue;
} else {
return plumbing.core.conj_when.call(null,coll,x);
}
break;
}
});

plumbing.core.conj_when.cljs$lang$applyTo = (function (seq17370){
var G__17371 = cljs.core.first.call(null,seq17370);
var seq17370__$1 = cljs.core.next.call(null,seq17370);
var G__17372 = cljs.core.first.call(null,seq17370__$1);
var seq17370__$2 = cljs.core.next.call(null,seq17370__$1);
return plumbing.core.conj_when.cljs$core$IFn$_invoke$arity$variadic(G__17371,G__17372,seq17370__$2);
});

plumbing.core.conj_when.cljs$lang$maxFixedArity = (2);

/**
 * Like cons but does nothing if x is non-truthy.
 */
plumbing.core.cons_when = (function plumbing$core$cons_when(x,s){
if(cljs.core.truth_(x)){
return cljs.core.cons.call(null,x,s);
} else {
return s;
}
});
/**
 * Like sort-by, but prefers higher values rather than lower ones.
 */
plumbing.core.rsort_by = cljs.core.comp.call(null,cljs.core.reverse,cljs.core.sort_by);
/**
 * Like swap! but returns a pair [old-val new-val]
 */
plumbing.core.swap_pair_BANG_ = (function plumbing$core$swap_pair_BANG_(var_args){
var args17383 = [];
var len__8628__auto___17389 = arguments.length;
var i__8629__auto___17390 = (0);
while(true){
if((i__8629__auto___17390 < len__8628__auto___17389)){
args17383.push((arguments[i__8629__auto___17390]));

var G__17391 = (i__8629__auto___17390 + (1));
i__8629__auto___17390 = G__17391;
continue;
} else {
}
break;
}

var G__17388 = args17383.length;
switch (G__17388) {
case 2:
return plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8651__auto__ = (new cljs.core.IndexedSeq(args17383.slice((2)),(0),null));
return plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8651__auto__);

}
});

plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
while(true){
var old_val = cljs.core.deref.call(null,a);
var new_val = f.call(null,old_val);
if(cljs.core.truth_(cljs.core.compare_and_set_BANG_.call(null,a,old_val,new_val))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_val,new_val], null);
} else {
continue;
}
break;
}
});

plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,args){
return plumbing.core.swap_pair_BANG_.call(null,a,(function (p1__17382_SHARP_){
return cljs.core.apply.call(null,f,p1__17382_SHARP_,args);
}));
});

plumbing.core.swap_pair_BANG_.cljs$lang$applyTo = (function (seq17384){
var G__17385 = cljs.core.first.call(null,seq17384);
var seq17384__$1 = cljs.core.next.call(null,seq17384);
var G__17386 = cljs.core.first.call(null,seq17384__$1);
var seq17384__$2 = cljs.core.next.call(null,seq17384__$1);
return plumbing.core.swap_pair_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17385,G__17386,seq17384__$2);
});

plumbing.core.swap_pair_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Like reset! but returns old-val
 */
plumbing.core.get_and_set_BANG_ = (function plumbing$core$get_and_set_BANG_(a,new_val){
return cljs.core.first.call(null,plumbing.core.swap_pair_BANG_.call(null,a,cljs.core.constantly.call(null,new_val)));
});
plumbing.core.millis = (function plumbing$core$millis(){
return (new Date()).getTime();
});
/**
 * Like apply, but applies a map to a function with positional map
 *   arguments. Can take optional initial args just like apply.
 */
plumbing.core.mapply = (function plumbing$core$mapply(var_args){
var args17393 = [];
var len__8628__auto___17399 = arguments.length;
var i__8629__auto___17400 = (0);
while(true){
if((i__8629__auto___17400 < len__8628__auto___17399)){
args17393.push((arguments[i__8629__auto___17400]));

var G__17401 = (i__8629__auto___17400 + (1));
i__8629__auto___17400 = G__17401;
continue;
} else {
}
break;
}

var G__17398 = args17393.length;
switch (G__17398) {
case 2:
return plumbing.core.mapply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8651__auto__ = (new cljs.core.IndexedSeq(args17393.slice((2)),(0),null));
return plumbing.core.mapply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8651__auto__);

}
});

plumbing.core.mapply.cljs$core$IFn$_invoke$arity$2 = (function (f,m){
return cljs.core.apply.call(null,f,cljs.core.apply.call(null,cljs.core.concat,m));
});

plumbing.core.mapply.cljs$core$IFn$_invoke$arity$variadic = (function (f,arg,args){
return cljs.core.apply.call(null,f,arg,cljs.core.concat.call(null,cljs.core.butlast.call(null,args),cljs.core.apply.call(null,cljs.core.concat,cljs.core.last.call(null,args))));
});

plumbing.core.mapply.cljs$lang$applyTo = (function (seq17394){
var G__17395 = cljs.core.first.call(null,seq17394);
var seq17394__$1 = cljs.core.next.call(null,seq17394);
var G__17396 = cljs.core.first.call(null,seq17394__$1);
var seq17394__$2 = cljs.core.next.call(null,seq17394__$1);
return plumbing.core.mapply.cljs$core$IFn$_invoke$arity$variadic(G__17395,G__17396,seq17394__$2);
});

plumbing.core.mapply.cljs$lang$maxFixedArity = (2);


//# sourceMappingURL=core.js.map