// Compiled by ClojureScript 1.9.562 {}
goog.provide('nicheware.platform.utilities.common.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.reader');
/**
 * Determines a valid start end index for the given connection, error correcting the given range.
 * It will correct errors if start is before first index or end is after the last,
 * but nil for all other errors.
 *   
 */
nicheware.platform.utilities.common.core.compute_start_end = (function nicheware$platform$utilities$common$core$compute_start_end(coll,p__35247){
var map__35250 = p__35247;
var map__35250__$1 = ((((!((map__35250 == null)))?((((map__35250.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35250.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35250):map__35250);
var slice_range = map__35250__$1;
var start = cljs.core.get.call(null,map__35250__$1,new cljs.core.Keyword(null,"start","start",-355208981),(0));
var end = cljs.core.get.call(null,map__35250__$1,new cljs.core.Keyword(null,"end","end",-268185958));
var coll_length = cljs.core.count.call(null,coll);
var end_range = (function (){var or__7407__auto__ = end;
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return (coll_length - (1));
}
})();
if(((start > end_range)) || ((end_range < (0))) || ((start >= coll_length))){
return null;
} else {
var valid_start = (((start < (0)))?(0):start);
var valid_end = (((end_range >= coll_length))?(coll_length - (1)):end_range);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"start","start",-355208981),valid_start,new cljs.core.Keyword(null,"end","end",-268185958),valid_end], null);
}
});
/**
 * Returns map of valid start, end and subset count
 */
nicheware.platform.utilities.common.core.compute_start_end_count = (function nicheware$platform$utilities$common$core$compute_start_end_count(var_args){
var args35252 = [];
var len__8628__auto___35260 = arguments.length;
var i__8629__auto___35261 = (0);
while(true){
if((i__8629__auto___35261 < len__8628__auto___35260)){
args35252.push((arguments[i__8629__auto___35261]));

var G__35262 = (i__8629__auto___35261 + (1));
i__8629__auto___35261 = G__35262;
continue;
} else {
}
break;
}

var G__35254 = args35252.length;
switch (G__35254) {
case 1:
return nicheware.platform.utilities.common.core.compute_start_end_count.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return nicheware.platform.utilities.common.core.compute_start_end_count.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35252.length)].join('')));

}
});

nicheware.platform.utilities.common.core.compute_start_end_count.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return nicheware.platform.utilities.common.core.compute_start_end_count.call(null,coll,null);
});

nicheware.platform.utilities.common.core.compute_start_end_count.cljs$core$IFn$_invoke$arity$2 = (function (coll,p__35255){
var map__35256 = p__35255;
var map__35256__$1 = ((((!((map__35256 == null)))?((((map__35256.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35256.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35256):map__35256);
var slice_range = map__35256__$1;
var subset_count = cljs.core.get.call(null,map__35256__$1,new cljs.core.Keyword(null,"subset-count","subset-count",-403545496));
var map__35258 = nicheware.platform.utilities.common.core.compute_start_end.call(null,coll,slice_range);
var map__35258__$1 = ((((!((map__35258 == null)))?((((map__35258.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35258.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35258):map__35258);
var start_end = map__35258__$1;
var start = cljs.core.get.call(null,map__35258__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var end = cljs.core.get.call(null,map__35258__$1,new cljs.core.Keyword(null,"end","end",-268185958));
var subset = (function (){var or__7407__auto__ = subset_count;
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return ((end - start) + (1));
}
})();
return cljs.core.assoc.call(null,start_end,new cljs.core.Keyword(null,"subset-count","subset-count",-403545496),subset);
});

nicheware.platform.utilities.common.core.compute_start_end_count.cljs$lang$maxFixedArity = 2;

/**
 * Select the elements from the collection based on the supplied start and end range.
 * start and end  are 0 based and inclusive.
 * 
 * - coll:  Collection to be sliced
 * - range: 2 arity argument, either a map ```{:start <default 0> :end <default end-coll>}``` or vector ```[start end]```
 * - start: 3 arity argument, start index of slice.
 * - end: 3 arity argument, end index of slice.
 * - returns: lazy sequence from start to end
 * 
 * It will attempt to make a valid start and end (eg set start to 0 if < 1 and end to last index in the collection if too large).
 * If range is not able to be made valid, returns nil.
 * 
 * eg:
 * ```clojure
 * (slice [0 1 2 3 4] 1 3)  => (1 2 3)
 * (slice [0 1 2 3 4] {:start 3})  => (3 4)
 * (slice [0 1 2 3 4] [1 7])  => (1 2 3 4)
 * (slice [0 1 2 3 4] {:start 1 :end 7})  => (1 2 3 4)
 * (slice [0 1 2 3 4] {:start 3 :end 2}) => nil
 * ```
 * 
 *   
 */
nicheware.platform.utilities.common.core.slice = (function nicheware$platform$utilities$common$core$slice(var_args){
var args35264 = [];
var len__8628__auto___35269 = arguments.length;
var i__8629__auto___35270 = (0);
while(true){
if((i__8629__auto___35270 < len__8628__auto___35269)){
args35264.push((arguments[i__8629__auto___35270]));

var G__35271 = (i__8629__auto___35270 + (1));
i__8629__auto___35270 = G__35271;
continue;
} else {
}
break;
}

var G__35266 = args35264.length;
switch (G__35266) {
case 3:
return nicheware.platform.utilities.common.core.slice.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return nicheware.platform.utilities.common.core.slice.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35264.length)].join('')));

}
});

nicheware.platform.utilities.common.core.slice.cljs$core$IFn$_invoke$arity$3 = (function (coll,start,end){
return nicheware.platform.utilities.common.core.slice.call(null,coll,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
});

nicheware.platform.utilities.common.core.slice.cljs$core$IFn$_invoke$arity$2 = (function (coll,range){
if(cljs.core.vector_QMARK_.call(null,range)){
return nicheware.platform.utilities.common.core.slice.call(null,coll,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"start","start",-355208981),cljs.core.first.call(null,range),new cljs.core.Keyword(null,"end","end",-268185958),cljs.core.last.call(null,range)], null));
} else {
var map__35267 = nicheware.platform.utilities.common.core.compute_start_end.call(null,coll,range);
var map__35267__$1 = ((((!((map__35267 == null)))?((((map__35267.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35267.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35267):map__35267);
var range__$1 = map__35267__$1;
var start = cljs.core.get.call(null,map__35267__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var end = cljs.core.get.call(null,map__35267__$1,new cljs.core.Keyword(null,"end","end",-268185958));
if((range__$1 == null)){
return null;
} else {
return cljs.core.drop.call(null,start,cljs.core.drop_last.call(null,((cljs.core.count.call(null,coll) - end) - (1)),coll));
}
}
});

nicheware.platform.utilities.common.core.slice.cljs$lang$maxFixedArity = 3;

/**
 * Removes the slice specified by ```{:start :end}``` with same defaults and
 *   semantics as described for [[slice]].
 * 
 *   If range is not able to be clamped to be valid, returns original collection.
 * 
 *   - coll: Collection to be sliced.
 *   - remove-range: 2 arity argument, either a map ```{:start <default 0> :end <default end-coll>}``` or vector ```[start end]```
 *   - start: 3 arity argument, index (0 based) of inclusive start of slice to remove.
 *   - end: 3 arity argument, index (0 based) of inclusive end of slice to remove
 *   - returns: lazy sequence with slice removed.
 * 
 * eg:
 * ```clojure
 * (remove-slice [0 1 2 3 4] 1 3)  => (0 4)
 * (remove-slice [0 1 2 3 4] {:start 3})  => (0 1 2)
 * (remove-slice [0 1 2 3 4] {:start 1 :end 7})  => (0)
 * (remove-slice [0 1 2 3 4] [1 3])  => (0 4)
 * (remove-slice [0 1 2 3 4] {:start 3 :end 2}) => nil
 * ```
 */
nicheware.platform.utilities.common.core.remove_slice = (function nicheware$platform$utilities$common$core$remove_slice(var_args){
var args35273 = [];
var len__8628__auto___35278 = arguments.length;
var i__8629__auto___35279 = (0);
while(true){
if((i__8629__auto___35279 < len__8628__auto___35278)){
args35273.push((arguments[i__8629__auto___35279]));

var G__35280 = (i__8629__auto___35279 + (1));
i__8629__auto___35279 = G__35280;
continue;
} else {
}
break;
}

var G__35275 = args35273.length;
switch (G__35275) {
case 3:
return nicheware.platform.utilities.common.core.remove_slice.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return nicheware.platform.utilities.common.core.remove_slice.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35273.length)].join('')));

}
});

nicheware.platform.utilities.common.core.remove_slice.cljs$core$IFn$_invoke$arity$3 = (function (coll,start,end){
return nicheware.platform.utilities.common.core.remove_slice.call(null,coll,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
});

nicheware.platform.utilities.common.core.remove_slice.cljs$core$IFn$_invoke$arity$2 = (function (coll,remove_range){
var map__35276 = nicheware.platform.utilities.common.core.compute_start_end.call(null,coll,remove_range);
var map__35276__$1 = ((((!((map__35276 == null)))?((((map__35276.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35276.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35276):map__35276);
var range = map__35276__$1;
var start = cljs.core.get.call(null,map__35276__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var end = cljs.core.get.call(null,map__35276__$1,new cljs.core.Keyword(null,"end","end",-268185958));
if((range == null)){
return coll;
} else {
return cljs.core.concat.call(null,nicheware.platform.utilities.common.core.slice.call(null,coll,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"start","start",-355208981),(0),new cljs.core.Keyword(null,"end","end",-268185958),(start - (1))], null)),nicheware.platform.utilities.common.core.slice.call(null,coll,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"start","start",-355208981),(end + (1))], null)));
}
});

nicheware.platform.utilities.common.core.remove_slice.cljs$lang$maxFixedArity = 3;

/**
 * Performs a slice but handles wrapping around the vector if the start is after end.
 * 
 *   See [[slice]] for details on arguments.
 * 
 *   eg:
 * ```clojure
 * (slice-wrap [0 1 2 3 4] {:start 3 :end 1}) => (3 4 0 1)
 * ```
 */
nicheware.platform.utilities.common.core.slice_wrap = (function nicheware$platform$utilities$common$core$slice_wrap(var_args){
var args35282 = [];
var len__8628__auto___35287 = arguments.length;
var i__8629__auto___35288 = (0);
while(true){
if((i__8629__auto___35288 < len__8628__auto___35287)){
args35282.push((arguments[i__8629__auto___35288]));

var G__35289 = (i__8629__auto___35288 + (1));
i__8629__auto___35288 = G__35289;
continue;
} else {
}
break;
}

var G__35284 = args35282.length;
switch (G__35284) {
case 3:
return nicheware.platform.utilities.common.core.slice_wrap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return nicheware.platform.utilities.common.core.slice_wrap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35282.length)].join('')));

}
});

nicheware.platform.utilities.common.core.slice_wrap.cljs$core$IFn$_invoke$arity$3 = (function (coll,start,end){
return nicheware.platform.utilities.common.core.slice_wrap.call(null,coll,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
});

nicheware.platform.utilities.common.core.slice_wrap.cljs$core$IFn$_invoke$arity$2 = (function (coll,range){
if(cljs.core.vector_QMARK_.call(null,range)){
return nicheware.platform.utilities.common.core.slice_wrap.call(null,coll,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"start","start",-355208981),cljs.core.first.call(null,range),new cljs.core.Keyword(null,"end","end",-268185958),cljs.core.second.call(null,range)], null));
} else {
var map__35285 = range;
var map__35285__$1 = ((((!((map__35285 == null)))?((((map__35285.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35285.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35285):map__35285);
var start = cljs.core.get.call(null,map__35285__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var end = cljs.core.get.call(null,map__35285__$1,new cljs.core.Keyword(null,"end","end",-268185958));
if((!((end == null))) && ((start > end))){
return cljs.core.concat.call(null,nicheware.platform.utilities.common.core.slice.call(null,coll,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"start","start",-355208981),start], null)),nicheware.platform.utilities.common.core.slice.call(null,coll,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"start","start",-355208981),(0),new cljs.core.Keyword(null,"end","end",-268185958),end], null)));
} else {
return nicheware.platform.utilities.common.core.slice.call(null,coll,range);
}
}
});

nicheware.platform.utilities.common.core.slice_wrap.cljs$lang$maxFixedArity = 3;

/**
 * Removes the slice but handles wrapping, so that start can be greater than end, in  which
 *   case it removes from start to last of vec and from beginning of vec to end.
 * 
 *   See [[remove-slice]] for details on arguments.
 * eg:
 * 
 * ```clojure
 * (remove-slice-wrap [0 1 2 3 4] {:start 3 :end 1}) => (2)
 * ```
 */
nicheware.platform.utilities.common.core.remove_slice_wrap = (function nicheware$platform$utilities$common$core$remove_slice_wrap(var_args){
var args35291 = [];
var len__8628__auto___35296 = arguments.length;
var i__8629__auto___35297 = (0);
while(true){
if((i__8629__auto___35297 < len__8628__auto___35296)){
args35291.push((arguments[i__8629__auto___35297]));

var G__35298 = (i__8629__auto___35297 + (1));
i__8629__auto___35297 = G__35298;
continue;
} else {
}
break;
}

var G__35293 = args35291.length;
switch (G__35293) {
case 3:
return nicheware.platform.utilities.common.core.remove_slice_wrap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 2:
return nicheware.platform.utilities.common.core.remove_slice_wrap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35291.length)].join('')));

}
});

nicheware.platform.utilities.common.core.remove_slice_wrap.cljs$core$IFn$_invoke$arity$3 = (function (coll,start,end){
return nicheware.platform.utilities.common.core.remove_slice_wrap.call(null,coll,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"start","start",-355208981),start,new cljs.core.Keyword(null,"end","end",-268185958),end], null));
});

nicheware.platform.utilities.common.core.remove_slice_wrap.cljs$core$IFn$_invoke$arity$2 = (function (coll,range){
if(cljs.core.vector_QMARK_.call(null,range)){
return nicheware.platform.utilities.common.core.remove_slice_wrap.call(null,coll,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"start","start",-355208981),cljs.core.first.call(null,range),new cljs.core.Keyword(null,"end","end",-268185958),cljs.core.second.call(null,range)], null));
} else {
var map__35294 = range;
var map__35294__$1 = ((((!((map__35294 == null)))?((((map__35294.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35294.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35294):map__35294);
var start = cljs.core.get.call(null,map__35294__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var end = cljs.core.get.call(null,map__35294__$1,new cljs.core.Keyword(null,"end","end",-268185958));
if((!((end == null))) && ((start > end))){
return nicheware.platform.utilities.common.core.remove_slice.call(null,nicheware.platform.utilities.common.core.remove_slice.call(null,coll,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"start","start",-355208981),start], null)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"start","start",-355208981),(0),new cljs.core.Keyword(null,"end","end",-268185958),end], null));
} else {
return nicheware.platform.utilities.common.core.remove_slice.call(null,coll,range);
}
}
});

nicheware.platform.utilities.common.core.remove_slice_wrap.cljs$lang$maxFixedArity = 3;

/**
 * Take exactly count elements from the collection, including first and last
 * as well as [count - 2] from the remaining collection elements, skipping elements as evenly as possible.
 * 
 * - coll: Collection to filter from
 * - n: Number of elements to extract from collection.
 * - returns: lazy sequence with n elements extracted from coll.
 * 
 * eg:
 * ```clojure
 * (filter-count [1 2 3 4 5 6 7] 4)  =>  [1 3 5 7]
 * ```
 */
nicheware.platform.utilities.common.core.filter_count = (function nicheware$platform$utilities$common$core$filter_count(coll,n){
var G__35301 = n;
switch (G__35301) {
case (1):
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,coll)], null);

break;
case (2):
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,coll),cljs.core.last.call(null,coll)], null);

break;
default:
var size = cljs.core.count.call(null,coll);
var step = (Math.ceil(((size - (1)) / (n - (1)))) | (0));
var initial_coll = cljs.core.take_nth.call(null,step,cljs.core.butlast.call(null,coll));
var size_initial = cljs.core.count.call(null,initial_coll);
var remaining = ((n - (1)) - size_initial);
var taken = ((1) + (step * (size_initial - (1))));
var extra = cljs.core.take.call(null,remaining,cljs.core.drop.call(null,taken,coll))
;
var last_element = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.last.call(null,coll)], null);
return cljs.core.concat.call(null,initial_coll,extra,last_element);

}
});
/**
 * Selects all the given indexes from the supplied collection.
 * 
 *   - coll: Collection from which to extract indexed elements.
 *   - indexes: collection of indexes. Each is used to extract the nth element from coll
 *   - returns: lazy-sequence of elements extracted from coll
 */
nicheware.platform.utilities.common.core.nth_items = (function nicheware$platform$utilities$common$core$nth_items(coll,indexes){
return cljs.core.map.call(null,(function (p1__35303_SHARP_){
return cljs.core.nth.call(null,coll,p1__35303_SHARP_);
}),indexes);
});
/**
 * Insert the given list into the position just before the specified 0-based index.
 * To prepend to list use 0. To append to list use list length or more.
 * 
 *   - coll: Collection to be inserted into.
 *   - ins-before: Index of element in coll that elements will be inserted before. (0 based)
 *   - elements: collection of elements to be inserted
 *   - returns: lazy sequence consisting of coll with elements inserted as specified.
 */
nicheware.platform.utilities.common.core.insert_before = (function nicheware$platform$utilities$common$core$insert_before(coll,ins_before,elements){
return cljs.core.concat.call(null,nicheware.platform.utilities.common.core.slice.call(null,coll,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"start","start",-355208981),(0),new cljs.core.Keyword(null,"end","end",-268185958),(ins_before - (1))], null)),elements,nicheware.platform.utilities.common.core.slice.call(null,coll,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"start","start",-355208981),ins_before], null)));
});
/**
 * Insert the given list after the 0-based index. To insert at the start of the list use
 * -1 or insert-before.
 * 
 *   - coll: Collection to be inserted into.
 *   - ins-after: Index of element in coll that elements will be inserted after. (0 based)
 *   - elements: collection of elements to be inserted
 *   - returns: lazy sequence consisting of coll with elements inserted as specified.
 */
nicheware.platform.utilities.common.core.insert_after = (function nicheware$platform$utilities$common$core$insert_after(coll,ins_after,elements){
return nicheware.platform.utilities.common.core.insert_before.call(null,coll,(ins_after + (1)),elements);
});
/**
 * Replaces all elements starting at the given element with the new elements.
 *   May extend the sequence if the new elements run longer then the existing sequence.
 * 
 *   - coll: Collection containing elements to be replaced into
 *   - rep-at: Index of element in coll that replacement to start (0 based)
 *   - elements: Elements to be used to replace existing elements in coll
 *   - returns: lazy sequence with coll elements replaced by elements as specified.
 * 
 * eg:
 * ```clojure
 *   (replace-at [1 2 3 4] 3 [5 6 7]) =>  (1 2 3 5 6 7)
 * ```
 */
nicheware.platform.utilities.common.core.replace_at = (function nicheware$platform$utilities$common$core$replace_at(coll,rep_at,elements){
return cljs.core.concat.call(null,nicheware.platform.utilities.common.core.slice.call(null,coll,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"end","end",-268185958),(rep_at - (1))], null)),elements,nicheware.platform.utilities.common.core.slice.call(null,coll,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"start","start",-355208981),(rep_at + cljs.core.count.call(null,elements))], null)));
});
/**
 * Replaces elements in the given collection with the new elements, starting at the given index.
 * If the number of new elements would extend past the end of the collection, the replacement wraps,
 * starting at the beginning of the collection.
 * 
 * See [[replace-at]] for details on arguments.
 * eg
 * ```clojure
 * (replace-at-wrap [1 2 3 4] 3 [5 6 7]) =>  (6 7 3 5)
 * ```
 */
nicheware.platform.utilities.common.core.replace_at_wrap = (function nicheware$platform$utilities$common$core$replace_at_wrap(coll,rep_at,elements){
var size = cljs.core.count.call(null,coll);
var additional_size = cljs.core.count.call(null,elements);
var first_size = (size - rep_at);
if((first_size < additional_size)){
return nicheware.platform.utilities.common.core.replace_at.call(null,nicheware.platform.utilities.common.core.replace_at.call(null,coll,rep_at,cljs.core.take.call(null,first_size,elements)),(0),cljs.core.drop.call(null,first_size,elements));
} else {
return nicheware.platform.utilities.common.core.replace_at.call(null,coll,rep_at,elements);
}
});
/**
 * Returns a lazy clojure range using the given ```{:start ... :end}``` range map
 *   where the values are inclusive (unlike Clojure range which is exclusive of the end)
 * 
 *   - range-spec: ```{:start <range-start-inclusive> :end <range-end-inclusive}```
 *   - returns: lazy sequence from start to end inclusive. Empty if either start or end missing.
 */
nicheware.platform.utilities.common.core.range_of_range = (function nicheware$platform$utilities$common$core$range_of_range(p__35304){
var map__35307 = p__35304;
var map__35307__$1 = ((((!((map__35307 == null)))?((((map__35307.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35307.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35307):map__35307);
var range_spec = map__35307__$1;
var start = cljs.core.get.call(null,map__35307__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var end = cljs.core.get.call(null,map__35307__$1,new cljs.core.Keyword(null,"end","end",-268185958));
if(!(((start == null)) || ((end == null)))){
return cljs.core.range.call(null,start,(end + (1)));
} else {
return cljs.core.PersistentVector.EMPTY;
}
});
/**
 * Negate the number (int or real)
 * 
 *   - number: Int or real number to be negated.
 *   - returns: negated number.
 */
nicheware.platform.utilities.common.core.negate = (function nicheware$platform$utilities$common$core$negate(number){
return ((0) - number);
});
/**
 * Snaps the number to its biggest magnitude from 0. This means a ceiling for positive
 * numbers and a floor for negative numbers
 * 
 *   - number: integer to be snapped.
 *   - returns: snapped integer
 */
nicheware.platform.utilities.common.core.snap = (function nicheware$platform$utilities$common$core$snap(number){
return ((((number > (0)))?Math.ceil(number):Math.floor(number)) | (0));
});
/**
 * Rotates the collection so that the selected index is the new first item in the collection.
 * 
 *   - index: 0 based index at which rotation to start in coll
 *   - coll: collection to be rotated.
 *   - returns: lazy sequence of rotated collection. Maps will return list of [key, value] vectors.
 * 
 * eg:
 * ```clojure
 *   (rotate-seq 2 [0 1 2 3 4 5]) => (2 3 4 5 0 1)
 * ```
 */
nicheware.platform.utilities.common.core.rotate_seq = (function nicheware$platform$utilities$common$core$rotate_seq(index,coll){
return cljs.core.concat.call(null,cljs.core.drop.call(null,index,coll),cljs.core.take.call(null,index,coll));
});
/**
 * Creates a lazy sequence filled with the given value n times.
 * 
 *   - value: Value to be repeated.
 *   - n: Number of times to repeat value
 *   - returns: Lazy sequence with value repeated n times.
 */
nicheware.platform.utilities.common.core.seq_of = (function nicheware$platform$utilities$common$core$seq_of(value,n){
return cljs.core.take.call(null,n,cljs.core.repeatedly.call(null,(function (){
return cljs.core.identity.call(null,value);
})));
});
/**
 * Pads the collection with the given value to make up to the final count.
 * 
 *   - seq: Collection to be padded.
 *   - value: Value to pad with.
 *   - new-size: New size of seq, to be padded to this size using value.
 *   - returns: Newly padded lazy sequence. Original collection returned if new-size less than or equal to current seq size.
 *  Maps will return a sequence of vectors with [key value] then padded with the pad value.
 * 
 * eg:
 * ```clojure
 * (pad-with [1 2 3] 0 6) => (1 2 3 0 0 0)
 * ```
 */
nicheware.platform.utilities.common.core.pad_with = (function nicheware$platform$utilities$common$core$pad_with(seq,value,new_size){
var size = cljs.core.count.call(null,seq);
if((size >= new_size)){
return seq;
} else {
return cljs.core.concat.call(null,seq,nicheware.platform.utilities.common.core.seq_of.call(null,value,(new_size - size)));
}
});
/**
 * Accept two collections and a truthy collection, all with the same number of values
 * and replaces the first with the second, only if the matching selection sequence has is true. Otherwise retains the
 * first collection.
 * 
 *   - fst: First collection, values will be used if selection entry is false.
 *   - snd: Second collection, values will be used if selection entry is true.
 *   - selections: Same size as fst and snd, with true, false values, used as described above.
 *   - returns: lazy sequence, same size as fst and snd, with merged values according to selections.
 *  Maps will retrurn elements as [key value] vectors in the lazy sequence.
 * 
 * eg:
 * ```clojure
 * (selective-merge [1 2 3 4] [5 6 7 8] [true false true false]) => (5 2 7 4)
 * ```
 */
nicheware.platform.utilities.common.core.selective_merge = (function nicheware$platform$utilities$common$core$selective_merge(fst,snd,selections){
return cljs.core.map.call(null,(function (p1__35311_SHARP_,p2__35310_SHARP_,p3__35309_SHARP_){
var or__7407__auto__ = (function (){var and__7395__auto__ = p3__35309_SHARP_;
if(cljs.core.truth_(and__7395__auto__)){
return p2__35310_SHARP_;
} else {
return and__7395__auto__;
}
})();
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return p1__35311_SHARP_;
}
}),fst,snd,selections);
});
/**
 * Returns true for nil or empty collection. Any non-seqable data type will not be true.
 * 
 *   - v: data element to be tested.
 *   - returns: true if v is nil or empty collection. False also if non-seqable data type.
 */
nicheware.platform.utilities.common.core.is_empty_QMARK_ = (function nicheware$platform$utilities$common$core$is_empty_QMARK_(v){
return ((v == null)) || ((cljs.core.seqable_QMARK_.call(null,v)) && (cljs.core.empty_QMARK_.call(null,v)));
});
/**
 * Create a predicate function to ensure maximum length of string or collection is max.
 * 
 *   - max: Integer value to be used in predicate as max length.
 *   - returns: predicate function accepting a countable data structure, returning true if count is less than or equal to max.
 * 
 * eg:
 * ```clojure
 * (filter (max-length 5) ["123456" "123"]) => ("123")
 * ```
 */
nicheware.platform.utilities.common.core.max_length = (function nicheware$platform$utilities$common$core$max_length(max){
return (function (str){
return (cljs.core.count.call(null,str) <= max);
});
});
/**
 * Create a predicate function to ensure minimum length of string or collection is min.
 * 
 *   - min: Integer value to be used in predicate as min length.
 *   - returns: predicate function accepting a countable data structure, returning true if count is greater than or equal to min.
 * 
 * 
 * eg:
 * ```clojure
 * (filter (min-length 5) ["123456" "123"]) => ("123456")
 * ```
 */
nicheware.platform.utilities.common.core.min_length = (function nicheware$platform$utilities$common$core$min_length(min){
return (function (str){
return (cljs.core.count.call(null,str) >= min);
});
});
/**
 * Find first value that satisfies predicate.
 * 
 *   - coll: Collection to be searched.
 *   - pred: Predicate function accepting a value from coll, returning true if matches required condition.
 *   - returns: First element from coll that matches the predicate. nil if nothing found.
 */
nicheware.platform.utilities.common.core.find_first = (function nicheware$platform$utilities$common$core$find_first(coll,pred){
return cljs.core.first.call(null,cljs.core.filter.call(null,pred,coll));
});
/**
 * Find last value that satisfies predicate.
 * 
 *   - coll: Collection to be searched.
 *   - pred: Predicate function accepting a value from coll, returning true if matches required condition.
 *   - returns: Last element from coll that matches the predicate. Will examine all elements in coll. nil if no match.
 */
nicheware.platform.utilities.common.core.find_last = (function nicheware$platform$utilities$common$core$find_last(coll,pred){
return cljs.core.last.call(null,cljs.core.filter.call(null,pred,coll));
});
/**
 * Find all the indexes of the elements in the collection matching the given predicate.
 * 
 *   - coll: Collection to be searched.
 *   - pred: Predicate function accepting a value from coll, returning true if matches required condition.
 *   - returns: Lazy sequence of indexes of elements from coll that match the predicate. Empty sequence if no match.
 */
nicheware.platform.utilities.common.core.find_indexes_by_pred = (function nicheware$platform$utilities$common$core$find_indexes_by_pred(coll,pred){
return cljs.core.keep_indexed.call(null,(function (p1__35313_SHARP_,p2__35312_SHARP_){
if(cljs.core.truth_(pred.call(null,p2__35312_SHARP_))){
return p1__35313_SHARP_;
} else {
return null;
}
}),coll);
});
/**
 * Find the first index of the element in the collection, using the given predicate.
 * 
 *   - coll: Collection to be searched.
 *   - pred: Predicate function accepting a value from coll, returning true if matches required condition.
 *   - returns: Index of first element from coll that matches the predicate. nil if no match.
 */
nicheware.platform.utilities.common.core.find_index_by_pred = (function nicheware$platform$utilities$common$core$find_index_by_pred(coll,pred){
return cljs.core.first.call(null,nicheware.platform.utilities.common.core.find_indexes_by_pred.call(null,coll,pred));
});
/**
 * Find the first index of the given element in the collection, using the given compare-fn (which defaults to equality).
 * 
 *   - coll: Collection to be searched.
 *   - element: Element to compare to elements in collection until match is found.
 *   - compare-fn: Optional 3-arity argument. Function used to match element with those in coll. It should take two args, which will be the item in the list and the element to match.
 *  If not present, then an equality comparison is performed.
 *   - returns: The index of the first element in coll which results in true from the compare-fn. nil if no match.
 * 
 * eg:
 * 
 * ```clojure
 * (find-index [10 20 30 40] 30)  => 2
 * ```
 */
nicheware.platform.utilities.common.core.find_index = (function nicheware$platform$utilities$common$core$find_index(var_args){
var args35317 = [];
var len__8628__auto___35320 = arguments.length;
var i__8629__auto___35321 = (0);
while(true){
if((i__8629__auto___35321 < len__8628__auto___35320)){
args35317.push((arguments[i__8629__auto___35321]));

var G__35322 = (i__8629__auto___35321 + (1));
i__8629__auto___35321 = G__35322;
continue;
} else {
}
break;
}

var G__35319 = args35317.length;
switch (G__35319) {
case 2:
return nicheware.platform.utilities.common.core.find_index.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return nicheware.platform.utilities.common.core.find_index.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35317.length)].join('')));

}
});

nicheware.platform.utilities.common.core.find_index.cljs$core$IFn$_invoke$arity$2 = (function (coll,element){
return nicheware.platform.utilities.common.core.find_index.call(null,coll,element,(function (p1__35314_SHARP_,p2__35315_SHARP_){
return cljs.core._EQ_.call(null,p1__35314_SHARP_,p2__35315_SHARP_);
}));
});

nicheware.platform.utilities.common.core.find_index.cljs$core$IFn$_invoke$arity$3 = (function (coll,element,compare_fn){
return nicheware.platform.utilities.common.core.find_index_by_pred.call(null,coll,(function (p1__35316_SHARP_){
return compare_fn.call(null,p1__35316_SHARP_,element);
}));
});

nicheware.platform.utilities.common.core.find_index.cljs$lang$maxFixedArity = 3;

/**
 * Find the all indexes of the element in the collection, using the given compare-fn (which defaults to equality)
 * 
 *   - coll: Collection to be searched.
 *   - element: Element to compare to elements in collection.
 *   - compare-fn: Optional 3-arity argument. Function used to match element with those in coll. It should take two args, which will be the item in the list and the element to match.
 *  If not present, then an equality comparison is performed.
 *   - returns: Lazy sequence of all the indexes of elements in coll which result in true from the compare-fn. Empty sequence if no match.
 * 
 *   eg:
 *   ```clojure
 *   (find-index [10 20 30 40 30] 30)  => (2, 4)
 *   ```
 */
nicheware.platform.utilities.common.core.find_indexes = (function nicheware$platform$utilities$common$core$find_indexes(var_args){
var args35327 = [];
var len__8628__auto___35330 = arguments.length;
var i__8629__auto___35331 = (0);
while(true){
if((i__8629__auto___35331 < len__8628__auto___35330)){
args35327.push((arguments[i__8629__auto___35331]));

var G__35332 = (i__8629__auto___35331 + (1));
i__8629__auto___35331 = G__35332;
continue;
} else {
}
break;
}

var G__35329 = args35327.length;
switch (G__35329) {
case 2:
return nicheware.platform.utilities.common.core.find_indexes.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return nicheware.platform.utilities.common.core.find_indexes.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35327.length)].join('')));

}
});

nicheware.platform.utilities.common.core.find_indexes.cljs$core$IFn$_invoke$arity$2 = (function (coll,element){
return nicheware.platform.utilities.common.core.find_indexes.call(null,coll,element,(function (p1__35324_SHARP_,p2__35325_SHARP_){
return cljs.core._EQ_.call(null,p1__35324_SHARP_,p2__35325_SHARP_);
}));
});

nicheware.platform.utilities.common.core.find_indexes.cljs$core$IFn$_invoke$arity$3 = (function (coll,element,compare_fn){
return nicheware.platform.utilities.common.core.find_indexes_by_pred.call(null,coll,(function (p1__35326_SHARP_){
return compare_fn.call(null,p1__35326_SHARP_,element);
}));
});

nicheware.platform.utilities.common.core.find_indexes.cljs$lang$maxFixedArity = 3;

/**
 * Find the index of the matching element in the collection, using the given compare-fn (which default to equality)
 * 
 *   - coll: Collection to be searched.
 *   - element: Element to compare to elements in collection for match.
 *   - compare-fn: Optional 3-arity argument. Function used to match element with those in coll. It should take two args, which will be the item in the list and other the element to match.
 *  If not present, then an equality comparison is performed.
 *   - returns: The index of the last element in coll which results in true from the compare-fn. nil if no match.
 * 
 * 
 * ```clojure
 * (find-last-index [10 20 30 40 30] 30)  => 4
 * ```
 */
nicheware.platform.utilities.common.core.find_last_index = (function nicheware$platform$utilities$common$core$find_last_index(var_args){
var args35338 = [];
var len__8628__auto___35341 = arguments.length;
var i__8629__auto___35342 = (0);
while(true){
if((i__8629__auto___35342 < len__8628__auto___35341)){
args35338.push((arguments[i__8629__auto___35342]));

var G__35343 = (i__8629__auto___35342 + (1));
i__8629__auto___35342 = G__35343;
continue;
} else {
}
break;
}

var G__35340 = args35338.length;
switch (G__35340) {
case 2:
return nicheware.platform.utilities.common.core.find_last_index.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return nicheware.platform.utilities.common.core.find_last_index.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35338.length)].join('')));

}
});

nicheware.platform.utilities.common.core.find_last_index.cljs$core$IFn$_invoke$arity$2 = (function (coll,element){
return nicheware.platform.utilities.common.core.find_last_index.call(null,coll,element,(function (p1__35334_SHARP_,p2__35335_SHARP_){
return cljs.core._EQ_.call(null,p1__35334_SHARP_,p2__35335_SHARP_);
}));
});

nicheware.platform.utilities.common.core.find_last_index.cljs$core$IFn$_invoke$arity$3 = (function (coll,element,compare_fn){
return cljs.core.last.call(null,cljs.core.keep_indexed.call(null,(function (p1__35337_SHARP_,p2__35336_SHARP_){
if(cljs.core.truth_(compare_fn.call(null,p2__35336_SHARP_,element))){
return p1__35337_SHARP_;
} else {
return null;
}
}),coll));
});

nicheware.platform.utilities.common.core.find_last_index.cljs$lang$maxFixedArity = 3;

/**
 * Find the last index of the element in the collection, using the given predicate.
 * 
 *   - coll: Collection to be searched.
 *   - pred: Predicate function accepting a value from coll, returning true if matches required condition.
 *   - returns: Last index of first element from coll that matches the predicate. nil if no match.
 */
nicheware.platform.utilities.common.core.find_last_index_by_pred = (function nicheware$platform$utilities$common$core$find_last_index_by_pred(coll,pred){
return cljs.core.last.call(null,cljs.core.keep_indexed.call(null,(function (p1__35346_SHARP_,p2__35345_SHARP_){
if(cljs.core.truth_(pred.call(null,p2__35345_SHARP_))){
return p1__35346_SHARP_;
} else {
return null;
}
}),coll));
});
/**
 * Will return nth element of sequence, or return nil if the index is < 0 or >= number elements, rather than exception
 * returned by clojure core nth.
 * 
 *   - seq: sequence to access. Must return true to sequential?
 *   - index: 0 based index of element in seq to return.
 *   - returns: nth element in sequence or nil if invalid index.
 */
nicheware.platform.utilities.common.core.find_nth = (function nicheware$platform$utilities$common$core$find_nth(seq,index){
if(((index < (0))) || ((index > cljs.core.count.call(null,seq)))){
return null;
} else {
return cljs.core.nth.call(null,seq,index);
}
});
/**
 * Replaces all leading nils in the collection with the given value.
 * 
 *   - coll: Collection to be examined for nils.
 *   - val: Value to replace leading nils with.
 *   - return: vector of values in collection with leading nils replaced by val.
 *  If coll is a map it  will return a vector of vectors [key value], with no replacements.
 * 
 * eg
 * ```clojure
 * (replace-leading-nils [nil nil 1 2 3] 0) => [0 0 1 2 3]
 * ```
 */
nicheware.platform.utilities.common.core.replace_leading_nils = (function nicheware$platform$utilities$common$core$replace_leading_nils(coll,val){
var result = cljs.core.PersistentVector.EMPTY;
var col = coll;
var found_non_nil = false;
var v = val;
while(true){
if(cljs.core.empty_QMARK_.call(null,col)){
return result;
} else {
var curr = cljs.core.first.call(null,col);
var non_nil = (found_non_nil) || (!((curr == null)));
var new_val = ((non_nil)?curr:v);
var new_result = cljs.core.conj.call(null,result,new_val);
var G__35347 = new_result;
var G__35348 = cljs.core.rest.call(null,col);
var G__35349 = non_nil;
var G__35350 = v;
result = G__35347;
col = G__35348;
found_non_nil = G__35349;
v = G__35350;
continue;
}
break;
}
});
/**
 * Replaces all trailing nils in the collection with the given value.
 * 
 *   - coll: Collection to be examined for nils.
 *   - val: Value to replace trailing nils with.
 *   - return: vector of values in collection with trailing nils replaced by val.
 *  If coll is a map it will return a vector of vectors [key value], with no replacements.
 * 
 * eg:
 * ```clojure
 *   (replace-trailing-nils [1 2 3 nil nil] 0) => (1 2 3 0 0)
 * ```
 */
nicheware.platform.utilities.common.core.replace_trailing_nils = (function nicheware$platform$utilities$common$core$replace_trailing_nils(coll,val){
return cljs.core.reverse.call(null,nicheware.platform.utilities.common.core.replace_leading_nils.call(null,cljs.core.reverse.call(null,coll),val));
});
/**
 * Performs a dissoc of the nested key. It only removes the last key in the path of keys.
 * 
 * - hmap: Map to be modified.
 * - key-path: Sequence of keys, defining nested path in map.
 * - returns: New map where final key in key-path has been removed.
 * 
 * eg:
 * ```clojure
 * (dissoc-in {:one {:two {:three 3 :four 4}}} [:one :two :three]) =>   {:one {:two {:four 4}}}
 * ```
 */
nicheware.platform.utilities.common.core.dissoc_in = (function nicheware$platform$utilities$common$core$dissoc_in(hmap,key_path){
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,key_path))){
return cljs.core.dissoc.call(null,hmap,cljs.core.first.call(null,key_path));
} else {
var updated = cljs.core.update_in.call(null,hmap,cljs.core.butlast.call(null,key_path),cljs.core.dissoc,cljs.core.last.call(null,key_path));
return updated;
}
});
/**
 * Version of assoc-in for use with ->> where the collection must be the last item.  Just does a simple reordering of the arguments.
 * 
 * - keys: Sequence of keys identifying new key path to add to map.
 * - value: New value to be associated with final key in the path.
 * - hash-map: Existing map that key to be added to.
 * - returns: New map with addition of specified nested key and value.
 */
nicheware.platform.utilities.common.core.assoc_in_thread_last = (function nicheware$platform$utilities$common$core$assoc_in_thread_last(keys,value,hash_map){
return cljs.core.assoc_in.call(null,hash_map,keys,value);
});
/**
 * Like merge, but merges maps recursively. At each level in any nested maps, keys in the initial map will be replaced
 * by keys from subsequent maps.
 * 
 * - Variable number of arguments, each being a map to be merged from left-to-right
 * - returns: New map which is deep merge of all argument maps.
 * 
 * eg:
 * ```clojure
 * (deep-merge {:one 1 :two 2 :nested {:three 3 :nested {:four 4 :five 5}}}
 *          {:two 4 :nested {:three 4 :nested {:four 5}}})
 * 
 * =>
 * 
 * {:one 1 :two 4 :nested {:three 4 :nested {:four 5 :five 5}}
 * ```
 */
nicheware.platform.utilities.common.core.deep_merge = (function nicheware$platform$utilities$common$core$deep_merge(var_args){
var args__8635__auto__ = [];
var len__8628__auto___35352 = arguments.length;
var i__8629__auto___35353 = (0);
while(true){
if((i__8629__auto___35353 < len__8628__auto___35352)){
args__8635__auto__.push((arguments[i__8629__auto___35353]));

var G__35354 = (i__8629__auto___35353 + (1));
i__8629__auto___35353 = G__35354;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((0) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((0)),(0),null)):null);
return nicheware.platform.utilities.common.core.deep_merge.cljs$core$IFn$_invoke$arity$variadic(argseq__8636__auto__);
});

nicheware.platform.utilities.common.core.deep_merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
if(cljs.core.every_QMARK_.call(null,cljs.core.map_QMARK_,maps)){
return cljs.core.apply.call(null,cljs.core.merge_with,nicheware.platform.utilities.common.core.deep_merge,maps);
} else {
return cljs.core.last.call(null,maps);
}
});

nicheware.platform.utilities.common.core.deep_merge.cljs$lang$maxFixedArity = (0);

nicheware.platform.utilities.common.core.deep_merge.cljs$lang$applyTo = (function (seq35351){
return nicheware.platform.utilities.common.core.deep_merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq35351));
});

/**
 * Generates a map indexed by the value identified by the key applied to each element in the collection.
 * Can be used to convert a vector of maps to a map indexed by a specific key by supplying the
 * key as the function. (from juxt doc examples)
 * 
 * - coll: Collection of maps.
 * - key-fn: Fn used to select an element from each map in the collection. eg Could be just a key.
 * - returns: New map with an entry for each element in coll, where the key is the key of the attribute selected by key-fn and the value is the original map.
 * 
 * eg:
 * ```clojure
 * (index-by [{:id 1} {:id 2}] :id) => {1 {:id 1} 2 {:id 2}}
 * ```
 */
nicheware.platform.utilities.common.core.index_by = (function nicheware$platform$utilities$common$core$index_by(coll,key_fn){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,cljs.core.juxt.call(null,key_fn,cljs.core.identity),coll));
});
/**
 * Transforms the top-level keys in the map using the given function.
 *   Uses for-map. (14.564 usec).
 * 
 *   - fn: Function used to transform the keys. Takes a single argument, the existing key, returning a new key value.
 *   - value-map: Map to be transformed.
 *   - returns: New map, with all top-level keys in value-map transformed by fn.
 *  Handles nil value-map, returning nil
 */
nicheware.platform.utilities.common.core.map_keys = (function nicheware$platform$utilities$common$core$map_keys(map_fn,value_map){
if(cljs.core.empty_QMARK_.call(null,value_map)){
return value_map;
} else {
return cljs.core.reduce_kv.call(null,(function (modified_map,k,value){
return cljs.core.assoc.call(null,modified_map,map_fn.call(null,k),value);
}),cljs.core.PersistentArrayMap.EMPTY,value_map);
}
});
/**
 * Transforms the keys in the map and nested maps using the given function.
 * 
 *   - fn: Function used to transform the keys. Takes a single argument, the existing key,  returning a new key value.
 *   - value-map: Map to be transformed.
 *   - returns: New map, with all keys, including keys in nested maps, transformed by fn.
 *  Handles nil value-map, returning nil
 */
nicheware.platform.utilities.common.core.map_all_keys = (function nicheware$platform$utilities$common$core$map_all_keys(map_fn,value_map){
if(cljs.core.empty_QMARK_.call(null,value_map)){
return value_map;
} else {
return cljs.core.reduce_kv.call(null,(function (modified_map,k,value){
return cljs.core.assoc.call(null,modified_map,map_fn.call(null,k),((cljs.core.map_QMARK_.call(null,value))?nicheware.platform.utilities.common.core.map_all_keys.call(null,map_fn,value):value));
}),cljs.core.PersistentArrayMap.EMPTY,value_map);
}
});
/**
 * Peforms a map over the values of the hash-map, returning a new hashmap with same keys and updated values.
 * 
 * - map-fn: Function to be applied to all values in the hash-map. Should accept a single argument (value) and return new value.
 * - hmap: The hash-map to be traversed
 * - returns: New hash map with all values modified by the map-fn.
 */
nicheware.platform.utilities.common.core.map_values = (function nicheware$platform$utilities$common$core$map_values(map_fn,hmap){
return cljs.core.reduce_kv.call(null,(function (modified_map,k,value){
return cljs.core.assoc.call(null,modified_map,k,map_fn.call(null,value));
}),cljs.core.PersistentArrayMap.EMPTY,hmap);
});
/**
 * Returns a map with only the entries where (fn value) is true.
 * 
 *   - fn: Function which should accept a single argument (the value of each map entry) and return boolean true if entry to be kept.
 *   - value-map: Hash map to be filtered.
 *   - returns: New map containing only entries where (fn value) is true.
 */
nicheware.platform.utilities.common.core.filter_val = (function nicheware$platform$utilities$common$core$filter_val(fn,value_map){
return cljs.core.select_keys.call(null,value_map,(function (){var iter__8269__auto__ = (function nicheware$platform$utilities$common$core$filter_val_$_iter__35371(s__35372){
return (new cljs.core.LazySeq(null,(function (){
var s__35372__$1 = s__35372;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__35372__$1);
if(temp__5278__auto__){
var s__35372__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__35372__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__35372__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__35374 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__35373 = (0);
while(true){
if((i__35373 < size__8268__auto__)){
var vec__35381 = cljs.core._nth.call(null,c__8267__auto__,i__35373);
var key = cljs.core.nth.call(null,vec__35381,(0),null);
var value = cljs.core.nth.call(null,vec__35381,(1),null);
if(cljs.core.truth_(fn.call(null,value))){
cljs.core.chunk_append.call(null,b__35374,key);

var G__35387 = (i__35373 + (1));
i__35373 = G__35387;
continue;
} else {
var G__35388 = (i__35373 + (1));
i__35373 = G__35388;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__35374),nicheware$platform$utilities$common$core$filter_val_$_iter__35371.call(null,cljs.core.chunk_rest.call(null,s__35372__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__35374),null);
}
} else {
var vec__35384 = cljs.core.first.call(null,s__35372__$2);
var key = cljs.core.nth.call(null,vec__35384,(0),null);
var value = cljs.core.nth.call(null,vec__35384,(1),null);
if(cljs.core.truth_(fn.call(null,value))){
return cljs.core.cons.call(null,key,nicheware$platform$utilities$common$core$filter_val_$_iter__35371.call(null,cljs.core.rest.call(null,s__35372__$2)));
} else {
var G__35389 = cljs.core.rest.call(null,s__35372__$2);
s__35372__$1 = G__35389;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8269__auto__.call(null,value_map);
})());
});
/**
 * Returns a map with only the entries where (fn key) is true.
 * 
 *   - fn: Function which should accept a single argument (the key of each map entry) and return boolean true if entry to be kept.
 *   - value-map: Hash map to be filtered.
 *   - returns: New map containing only entries where (fn key) is true.
 */
nicheware.platform.utilities.common.core.filter_key = (function nicheware$platform$utilities$common$core$filter_key(fn,value_map){
return cljs.core.select_keys.call(null,value_map,(function (){var iter__8269__auto__ = (function nicheware$platform$utilities$common$core$filter_key_$_iter__35406(s__35407){
return (new cljs.core.LazySeq(null,(function (){
var s__35407__$1 = s__35407;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__35407__$1);
if(temp__5278__auto__){
var s__35407__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__35407__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__35407__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__35409 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__35408 = (0);
while(true){
if((i__35408 < size__8268__auto__)){
var vec__35416 = cljs.core._nth.call(null,c__8267__auto__,i__35408);
var key = cljs.core.nth.call(null,vec__35416,(0),null);
var value = cljs.core.nth.call(null,vec__35416,(1),null);
if(cljs.core.truth_(fn.call(null,key))){
cljs.core.chunk_append.call(null,b__35409,key);

var G__35422 = (i__35408 + (1));
i__35408 = G__35422;
continue;
} else {
var G__35423 = (i__35408 + (1));
i__35408 = G__35423;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__35409),nicheware$platform$utilities$common$core$filter_key_$_iter__35406.call(null,cljs.core.chunk_rest.call(null,s__35407__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__35409),null);
}
} else {
var vec__35419 = cljs.core.first.call(null,s__35407__$2);
var key = cljs.core.nth.call(null,vec__35419,(0),null);
var value = cljs.core.nth.call(null,vec__35419,(1),null);
if(cljs.core.truth_(fn.call(null,key))){
return cljs.core.cons.call(null,key,nicheware$platform$utilities$common$core$filter_key_$_iter__35406.call(null,cljs.core.rest.call(null,s__35407__$2)));
} else {
var G__35424 = cljs.core.rest.call(null,s__35407__$2);
s__35407__$1 = G__35424;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8269__auto__.call(null,value_map);
})());
});
/**
 * Returns a map where any key where (fn val) is true, is removed (0.8 usec)
 * 
 *   - fn: Function which should accept a single argument (the value of each map entry) and return boolean true if entry to be removed.
 *   - value-map: Hash map to be filtered.
 *   - returns: New map containing only entries where (fn value) is false.
 */
nicheware.platform.utilities.common.core.filter_remove_val = (function nicheware$platform$utilities$common$core$filter_remove_val(fn,value_map){
return cljs.core.apply.call(null,cljs.core.dissoc,value_map,(function (){var iter__8269__auto__ = (function nicheware$platform$utilities$common$core$filter_remove_val_$_iter__35441(s__35442){
return (new cljs.core.LazySeq(null,(function (){
var s__35442__$1 = s__35442;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__35442__$1);
if(temp__5278__auto__){
var s__35442__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__35442__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__35442__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__35444 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__35443 = (0);
while(true){
if((i__35443 < size__8268__auto__)){
var vec__35451 = cljs.core._nth.call(null,c__8267__auto__,i__35443);
var key = cljs.core.nth.call(null,vec__35451,(0),null);
var value = cljs.core.nth.call(null,vec__35451,(1),null);
if(cljs.core.truth_(fn.call(null,value))){
cljs.core.chunk_append.call(null,b__35444,key);

var G__35457 = (i__35443 + (1));
i__35443 = G__35457;
continue;
} else {
var G__35458 = (i__35443 + (1));
i__35443 = G__35458;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__35444),nicheware$platform$utilities$common$core$filter_remove_val_$_iter__35441.call(null,cljs.core.chunk_rest.call(null,s__35442__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__35444),null);
}
} else {
var vec__35454 = cljs.core.first.call(null,s__35442__$2);
var key = cljs.core.nth.call(null,vec__35454,(0),null);
var value = cljs.core.nth.call(null,vec__35454,(1),null);
if(cljs.core.truth_(fn.call(null,value))){
return cljs.core.cons.call(null,key,nicheware$platform$utilities$common$core$filter_remove_val_$_iter__35441.call(null,cljs.core.rest.call(null,s__35442__$2)));
} else {
var G__35459 = cljs.core.rest.call(null,s__35442__$2);
s__35442__$1 = G__35459;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8269__auto__.call(null,value_map);
})());
});
/**
 * Returns a map where any key where (fn key) is true, is removed (0.8 usec)
 * 
 *   - fn: Function which should accept a single argument (the key of each map entry) and return boolean true if entry to be removed.
 *   - value-map: Hash map to be filtered.
 *   - returns: New map containing only entries where (fn key) is false.
 */
nicheware.platform.utilities.common.core.filter_remove_key = (function nicheware$platform$utilities$common$core$filter_remove_key(fn,value_map){
return cljs.core.apply.call(null,cljs.core.dissoc,value_map,(function (){var iter__8269__auto__ = (function nicheware$platform$utilities$common$core$filter_remove_key_$_iter__35476(s__35477){
return (new cljs.core.LazySeq(null,(function (){
var s__35477__$1 = s__35477;
while(true){
var temp__5278__auto__ = cljs.core.seq.call(null,s__35477__$1);
if(temp__5278__auto__){
var s__35477__$2 = temp__5278__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__35477__$2)){
var c__8267__auto__ = cljs.core.chunk_first.call(null,s__35477__$2);
var size__8268__auto__ = cljs.core.count.call(null,c__8267__auto__);
var b__35479 = cljs.core.chunk_buffer.call(null,size__8268__auto__);
if((function (){var i__35478 = (0);
while(true){
if((i__35478 < size__8268__auto__)){
var vec__35486 = cljs.core._nth.call(null,c__8267__auto__,i__35478);
var key = cljs.core.nth.call(null,vec__35486,(0),null);
var value = cljs.core.nth.call(null,vec__35486,(1),null);
if(cljs.core.truth_(fn.call(null,key))){
cljs.core.chunk_append.call(null,b__35479,key);

var G__35492 = (i__35478 + (1));
i__35478 = G__35492;
continue;
} else {
var G__35493 = (i__35478 + (1));
i__35478 = G__35493;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__35479),nicheware$platform$utilities$common$core$filter_remove_key_$_iter__35476.call(null,cljs.core.chunk_rest.call(null,s__35477__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__35479),null);
}
} else {
var vec__35489 = cljs.core.first.call(null,s__35477__$2);
var key = cljs.core.nth.call(null,vec__35489,(0),null);
var value = cljs.core.nth.call(null,vec__35489,(1),null);
if(cljs.core.truth_(fn.call(null,key))){
return cljs.core.cons.call(null,key,nicheware$platform$utilities$common$core$filter_remove_key_$_iter__35476.call(null,cljs.core.rest.call(null,s__35477__$2)));
} else {
var G__35494 = cljs.core.rest.call(null,s__35477__$2);
s__35477__$1 = G__35494;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8269__auto__.call(null,value_map);
})());
});
/**
 * Removes all top-level entries with nil values from the map.
 * Uses dissoc, so reuse of map data will be maximised (.8 usec)
 * 
 * - value-map: Map for which entries with nil values to be removed.
 * - returns: New map with no nil value entries.
 */
nicheware.platform.utilities.common.core.remove_nil = (function nicheware$platform$utilities$common$core$remove_nil(value_map){
return nicheware.platform.utilities.common.core.filter_remove_val.call(null,cljs.core.nil_QMARK_,value_map);
});
/**
 * Removes all top-level entries which are empty collections or nil values from the map.
 * Uses dissoc, so reuse of map data will be maximised (.8 usec).
 * 
 * Uses the is-empty? function from this lib, so will retain values which are non-seqable.
 * 
 * - value-map: Map for which entries with empty values to be removed.
 * - returns: New map with no empty value entries.
 */
nicheware.platform.utilities.common.core.remove_empty = (function nicheware$platform$utilities$common$core$remove_empty(value_map){
return nicheware.platform.utilities.common.core.filter_remove_val.call(null,nicheware.platform.utilities.common.core.is_empty_QMARK_,value_map);
});
/**
 * Removes all top-level entries with nil values from the map.
 * Uses dissoc, so reuse of map data will be maximised (.8 usec).
 * 
 * Alternate name for remove-nil for backwards compatibility.
 */
nicheware.platform.utilities.common.core.map_remove_nil = (function nicheware$platform$utilities$common$core$map_remove_nil(value_map){
return nicheware.platform.utilities.common.core.remove_nil.call(null,value_map);
});
/**
 * Removes any entries that are nil from given vector, returning a vector.
 * 
 *   - vec: Vector to have nils removed.
 *   - returns: new vector containing only the original non-nil values.
 * 
 * eg:
 * ```clojure
 * (vec-remove-nil [1 nil 3 nil 4]) => [1 3 4]
 * ```
 */
nicheware.platform.utilities.common.core.vec_remove_nil = (function nicheware$platform$utilities$common$core$vec_remove_nil(vec){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.filter.call(null,(function (p1__35495_SHARP_){
return !((p1__35495_SHARP_ == null));
}),vec));
});
/**
 * Finds and returns the first element in the collection that satisfies the given predicate.
 * 
 *   - coll: Collection to be searched.
 *   - pred: function which accepts a single value (an element from the collection) and returning true for the required element.
 *   - returns: The first element from the collection that matches the predicate.
 *  Maps will be tested and returned as vector elements of the form [key value]
 *  nil if nothing found.
 */
nicheware.platform.utilities.common.core.find_by_pred = (function nicheware$platform$utilities$common$core$find_by_pred(coll,pred){
return cljs.core.first.call(null,cljs.core.filter.call(null,pred,coll));
});
/**
 * Finds the element in the collection of maps, which has the specified value for the given key.
 * 
 * - coll: Collection of maps to be searched.
 * - id-key: Key to access in each map of the collection.
 * - id: Expected value of the key in map of matching element.
 * - returns: Map from coll that has id-key with value of id. nil if not found.
 * 
 * eg:
 * 
 * ```clojure
 * (find-element [{:id 1 :value 10} {:id 2 :value 100}] :id 1) => {:id 1 :value 10}
 * ```
 */
nicheware.platform.utilities.common.core.find_element = (function nicheware$platform$utilities$common$core$find_element(coll,id_key,id){
return nicheware.platform.utilities.common.core.find_by_pred.call(null,coll,(function (p1__35496_SHARP_){
return cljs.core._EQ_.call(null,id,cljs.core.get.call(null,p1__35496_SHARP_,id_key));
}));
});
/**
 * Replaces an element of a vector, given a new one and a predicate fn that must return true on the element to be replaced.
 * Will only replace the first element matched.
 * 
 * - vec: Vector to have element replaced
 * - replacement-element: New element to replace the found element.
 * - pred: Function taking a single argument (element in the vec), returning true if it is the one to replace.
 * - returns: new vector with first matching element replaced by replacement-element. Same as original vector if no match.
 * 
 *   
 */
nicheware.platform.utilities.common.core.replace_element_by_pred = (function nicheware$platform$utilities$common$core$replace_element_by_pred(vec,replacement_element,pred){
var index = nicheware.platform.utilities.common.core.find_index_by_pred.call(null,vec,pred);
if(cljs.core.truth_(index)){
return cljs.core.assoc.call(null,vec,index,replacement_element);
} else {
return vec;
}
});
/**
 * Replaces a map element of a vector, given a new one and the keyword of the unique identifying attribute in the map.
 * 
 * - vec: vector in which element is to be replaced.
 * - replacement-element: New element to put into vector
 * - id-key: The key in the element which is to be used as the matching unique identifier.
 * - id: Optional id, identifying the element to be replaced. If not supplied will use the id-key value from the given replacement-element.
 * 
 * eg:
 * ```clojure
 * (replace-element [{:id 1 :value 100} {:id 2 :value 200}] {:id 1 :value 1000} :id)
 *   => [{:id 1 :value 1000} {:id 2 :value 200}]
 * 
 * (replace-element [{:id 1 :value 100} {:id 2 :value 200}] {:id 1 :value 1000} :id 2)
 *   => [{:id 1 :value 100} {:id 1 :value 1000}]
 * ```
 */
nicheware.platform.utilities.common.core.replace_element = (function nicheware$platform$utilities$common$core$replace_element(var_args){
var args35498 = [];
var len__8628__auto___35501 = arguments.length;
var i__8629__auto___35502 = (0);
while(true){
if((i__8629__auto___35502 < len__8628__auto___35501)){
args35498.push((arguments[i__8629__auto___35502]));

var G__35503 = (i__8629__auto___35502 + (1));
i__8629__auto___35502 = G__35503;
continue;
} else {
}
break;
}

var G__35500 = args35498.length;
switch (G__35500) {
case 3:
return nicheware.platform.utilities.common.core.replace_element.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return nicheware.platform.utilities.common.core.replace_element.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args35498.length)].join('')));

}
});

nicheware.platform.utilities.common.core.replace_element.cljs$core$IFn$_invoke$arity$3 = (function (vec,replacement_element,id_key){
return nicheware.platform.utilities.common.core.replace_element.call(null,vec,replacement_element,id_key,cljs.core.get.call(null,replacement_element,id_key));
});

nicheware.platform.utilities.common.core.replace_element.cljs$core$IFn$_invoke$arity$4 = (function (vec,replacement_element,id_key,id){
return nicheware.platform.utilities.common.core.replace_element_by_pred.call(null,vec,replacement_element,(function (p1__35497_SHARP_){
return cljs.core._EQ_.call(null,id,cljs.core.get.call(null,p1__35497_SHARP_,id_key));
}));
});

nicheware.platform.utilities.common.core.replace_element.cljs$lang$maxFixedArity = 4;

/**
 * Performs a compose of the functions in a given collection. It will execute
 * the functions in order of first to last in the collection (which is different from the clojure
 * compose which executes from right to left.)
 * 
 *   - coll-fns: Collection of functions to be composed, left to right.
 *   - returns: single function equivalent to composition of given functions.
 * 
 * eg:
 * ```clojure
 *   ((compose-fns [inc #(Mth.abs %)]) -1)  => 0
 * ```
 */
nicheware.platform.utilities.common.core.compose_fns = (function nicheware$platform$utilities$common$core$compose_fns(coll_fns){
return cljs.core.reduce.call(null,cljs.core.comp,cljs.core.reverse.call(null,coll_fns));
});
/**
 * Returns the substring after the first occurrence of the given substring.
 * 
 *   - strn: String to be examined.
 *   - after-value: Substring within strn to search for.
 *   - returns: substring after 'after-value' or nil if not found.
 * 
 *   eg:
 * ```clojure
 *   (after "prefix-end-suffix" "-end-")  =>  "suffix"
 * ```
 */
nicheware.platform.utilities.common.core.after = (function nicheware$platform$utilities$common$core$after(strn,after_value){
var G__35506 = after_value;
var G__35506__$1 = (((G__35506 == null))?null:clojure.string.index_of.call(null,strn,G__35506));
var G__35506__$2 = (((G__35506__$1 == null))?null:(cljs.core.count.call(null,after_value) + G__35506__$1));
if((G__35506__$2 == null)){
return null;
} else {
return cljs.core.subs.call(null,strn,G__35506__$2);
}
});
/**
 * Returns the substring before the first occurrence of the given substring.
 * 
 *   - strn: String to be examined.
 *   - before-value: Substring within strn to search for.
 *   - returns: substring before 'before-value' or nil if not found.
 * 
 *   eg:
 * ```clojure
 *   (before "prefix-end-next-end" "-end")  =>  "prefix"
 * ```
 */
nicheware.platform.utilities.common.core.before = (function nicheware$platform$utilities$common$core$before(strn,before_value){
var G__35508 = before_value;
var G__35508__$1 = (((G__35508 == null))?null:clojure.string.index_of.call(null,strn,G__35508));
if((G__35508__$1 == null)){
return null;
} else {
return cljs.core.subs.call(null,strn,(0),G__35508__$1);
}
});
/**
 * Returns the substring before the last occurrence of the given substring.
 * 
 *   - strn: String to be examined.
 *   - before-value: Substring within strn to search for.
 *   - returns: last substring before 'before-value' or nil if not found.
 * 
 * 
 *   eg:
 * ```clojure
 *   (before-last "prefix-end-next-end" "-end")  =>  "prefix-end-next"
 * ```
 */
nicheware.platform.utilities.common.core.before_last = (function nicheware$platform$utilities$common$core$before_last(strn,before_value){
var G__35510 = before_value;
var G__35510__$1 = (((G__35510 == null))?null:clojure.string.last_index_of.call(null,strn,G__35510));
if((G__35510__$1 == null)){
return null;
} else {
return cljs.core.subs.call(null,strn,(0),G__35510__$1);
}
});
/**
 * Platform independent uuid generator.
 *   java.util.UUID/randomUUID for Clojure and random-uuid for ClojureScript.
 * 
 *   - returns: random integer
 */
nicheware.platform.utilities.common.core.rand_uuid = (function nicheware$platform$utilities$common$core$rand_uuid(){
return cljs.core.random_uuid.call(null);
});
/**
 * Platform independent int parser.
 * 
 * Will fail on invalid characters, including digits
 * with trailing non-digits, which standard Javascript does not.
 * 
 * - string-int: String representation of integer
 * - returns: integer version of string. If no valid integer
 *   returns nil
 * 
 * uses:
 * 
 * - Integer/parseInt for Clojure
 * - js/parseInt for ClojureScript.
 */
nicheware.platform.utilities.common.core.parse_int = (function nicheware$platform$utilities$common$core$parse_int(string_int){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^(-|\+)?(\d+|Infinity)$/,string_int))){
var result = parseInt(string_int);
if(cljs.core.truth_(isNaN(result))){
return null;
} else {
return result;
}
} else {
return null;
}
});
/**
 * Returns the given string value as an integer, using the platform specific parseInt.
 * Returns nil if any format errors.
 * 
 * Alternate name for [[parse-int]].
 * 
 *   - string-value: Value to be converted to an integer
 *   - returns: Integer value of string, or nil on format errors.
 */
nicheware.platform.utilities.common.core.str_to_int = (function nicheware$platform$utilities$common$core$str_to_int(string_value){
return nicheware.platform.utilities.common.core.parse_int.call(null,string_value);
});
/**
 * Returns the current time in millis, as appropriate for the platform.
 */
nicheware.platform.utilities.common.core.current_time_millis = (function nicheware$platform$utilities$common$core$current_time_millis(){
return (new Date()).getTime();
});
/**
 * Cross platform edn string reader.
 * 
 *   - str: edn formatted string to be parsed.
 *   - returns: Clojure data read from edn string.
 */
nicheware.platform.utilities.common.core.edn_read = (function nicheware$platform$utilities$common$core$edn_read(str){
return cljs.reader.read_string.call(null,str);
});
var ret__8673__auto___35512 = /**
 * Macro for use in threading (as expr in ->). It allows a mapping function to be conditionally applied if the predicate function is true.
 * 
 * - val - value to be tested - will come from the threading macro
 * - pred-fn - predicate function which will be given val, or it could be any non-function expression - which would be tested for truthy
 * - map-fn - Executed on the value if the pred-fn or expression is true and then returned as threading value.
 * 
 * Otherwise val returned untouched.
 * 
 *   eg:
 * ```clojure
 *   (-> end
 *    (cond-t #(> start %) inc)
 *    ...)
 * ```
 */
nicheware.platform.utilities.common.core.cond_t = (function nicheware$platform$utilities$common$core$cond_t(_AMPERSAND_form,_AMPERSAND_env,val,pred_fn,map_fn){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null)),(function (){var x__8341__auto__ = cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"pred-val__35511__auto__","pred-val__35511__auto__",795434122,null)),(function (){var x__8341__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),(function (){var x__8341__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cljs.core","fn?","cljs.core/fn?",71876239,null)),(function (){var x__8341__auto__ = pred_fn;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),(function (){var x__8341__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__8341__auto__ = pred_fn;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),(function (){var x__8341__auto__ = val;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),(function (){var x__8341__auto__ = pred_fn;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),(function (){var x__8341__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"if","if",1181717262,null)),cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"pred-val__35511__auto__","pred-val__35511__auto__",795434122,null)),(function (){var x__8341__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__8341__auto__ = map_fn;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),(function (){var x__8341__auto__ = val;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})(),(function (){var x__8341__auto__ = val;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__8341__auto__);
})())));
});
nicheware.platform.utilities.common.core.cond_t.cljs$lang$macro = true;

/**
 * Throws an IllegalArgumentException, as appropriate for the platform.
 * 
 *   - message: Message to be included as part of response.
 *   - throws for Clojure: java.lang.IllegalArgumentException
 *   - throws for ClojureSciprt: js/Error with the string "IllegalArgumentException" in the message.
 */
nicheware.platform.utilities.common.core.throw_illegal_arg = (function nicheware$platform$utilities$common$core$throw_illegal_arg(message){
throw Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("IllegalArgumentException: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''));
});

//# sourceMappingURL=core.js.map