// Compiled by ClojureScript 1.9.562 {}
goog.provide('nicheware.platform.utilities.common.config');
goog.require('cljs.core');
goog.require('promesa.core');
goog.require('kvlt.core');
goog.require('cljstache.core');
goog.require('nicheware.platform.utilities.common.core');
goog.require('clojure.string');
nicheware.platform.utilities.common.config.base_opts = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"env-file-name","env-file-name",890535931),"env-config.edn",new cljs.core.Keyword(null,"common-file-name","common-file-name",182379595),"config.edn",new cljs.core.Keyword(null,"resolve-vars","resolve-vars",1598451048),true], null);
nicheware.platform.utilities.common.config.re_mustache_match = /\{\{[^{}]*\}\}/;
/**
 * Execute the given function on the string used in a render, rendering the string before hand
 */
nicheware.platform.utilities.common.config.make_render_fn = (function nicheware$platform$utilities$common$config$make_render_fn(str_fn){
return (function (text){
return (function (render_fn){
return str_fn.call(null,render_fn.call(null,text));
});
});
});
nicheware.platform.utilities.common.config.render_fns = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"upper","upper",246243906),nicheware.platform.utilities.common.config.make_render_fn.call(null,clojure.string.upper_case),new cljs.core.Keyword(null,"lower","lower",1120320821),nicheware.platform.utilities.common.config.make_render_fn.call(null,clojure.string.lower_case),new cljs.core.Keyword(null,"capitalize","capitalize",511160605),nicheware.platform.utilities.common.config.make_render_fn.call(null,clojure.string.capitalize)], null);
/**
 * Render the given string using the provided map as value to be substituted for mustach style variables.
 * Include a list of standard functions as part of the map. These include: upper, capatilize, lower
 * 
 * use functions as {{#upper}}My-{{env}}{{/upper}}}}
 */
nicheware.platform.utilities.common.config.render = (function nicheware$platform$utilities$common$config$render(str,val_map){
return cljstache.core.render.call(null,str,cljs.core.merge.call(null,nicheware.platform.utilities.common.config.render_fns,val_map));
});
/**
 * Resolves any template variables in a given map.
 * Transforms to a string then feeds the map as the parameter resolver.
 *  Will recurse until no unresolved mustache variables.
 */
nicheware.platform.utilities.common.config.resolve_template_vars = (function nicheware$platform$utilities$common$config$resolve_template_vars(val_map){
cljs.core.println.call(null,"resolve-template-vars(), val-map: ",val_map);

var vmap = val_map;
while(true){
var map_str = cljs.core.pr_str.call(null,vmap);
var resolved_str = nicheware.platform.utilities.common.config.render.call(null,map_str,vmap);
var resolved_map = nicheware.platform.utilities.common.core.edn_read.call(null,resolved_str);
var match_mustache = cljs.core.re_find.call(null,nicheware.platform.utilities.common.config.re_mustache_match,resolved_str);
if((match_mustache == null)){
return resolved_map;
} else {
var G__41034 = resolved_map;
vmap = G__41034;
continue;
}
break;
}
});
/**
 * Builds config option from the given options passed in
 */
nicheware.platform.utilities.common.config.build_config_options = (function nicheware$platform$utilities$common$config$build_config_options(config_path,opts){
var map__41037 = cljs.core.merge.call(null,nicheware.platform.utilities.common.config.base_opts,opts);
var map__41037__$1 = ((((!((map__41037 == null)))?((((map__41037.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41037.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41037):map__41037);
var initial_opts = map__41037__$1;
var env_file_name = cljs.core.get.call(null,map__41037__$1,new cljs.core.Keyword(null,"env-file-name","env-file-name",890535931));
var common_file_name = cljs.core.get.call(null,map__41037__$1,new cljs.core.Keyword(null,"common-file-name","common-file-name",182379595));
var path_opts = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"env-path","env-path",-736729873),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(config_path),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(env_file_name)].join(''),new cljs.core.Keyword(null,"common-path","common-path",271944963),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(config_path),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_file_name)].join('')], null);
return cljs.core.merge.call(null,path_opts,initial_opts);
});
/**
 * Reads via http from the default server location (usually resources/public) the
 * specified config-file at the given path.
 * 
 * - config-url:  eg ```yourapp/config.edn```
 * - returns: a promesa promise that resolves to the map of config values read.
 *   
 */
nicheware.platform.utilities.common.config.read_http_config = (function nicheware$platform$utilities$common$config$read_http_config(config_url){
cljs.core.println.call(null,"read-http-config(), config-url: ",config_url);

return promesa.core.then.call(null,kvlt.core.request_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),config_url,new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Keyword(null,"edn","edn",1317840885)], null)),new cljs.core.Keyword(null,"body","body",-2049205669));
});
/**
 * Loads config from server, merging the current environment config with the base application configuration.
 * 
 * As the server instance represents the environment, it is up to the deployment build process to ensure the appropriate config.edn and env-config.edn
 * is deployed, typically from ```resources/public/<app-prefix>/config.edn``` and ```env/<environment>/resources/public/<app-prefix>/env-config.edn```.
 * 
 * - config-path: eg ```yourapp```  will look for ```/yourapp/config.edn``` and ```/yourapp/env-config.edn```
 * - opts:        optional override of default values ```{:env-file-name :env-path :common-file-name :common-path :resolve-vars}```
 * - returns:     A promesa promise that resolves to the merged config map
 */
nicheware.platform.utilities.common.config.load_http_config = (function nicheware$platform$utilities$common$config$load_http_config(var_args){
var args41039 = [];
var len__8628__auto___41049 = arguments.length;
var i__8629__auto___41050 = (0);
while(true){
if((i__8629__auto___41050 < len__8628__auto___41049)){
args41039.push((arguments[i__8629__auto___41050]));

var G__41051 = (i__8629__auto___41050 + (1));
i__8629__auto___41050 = G__41051;
continue;
} else {
}
break;
}

var G__41041 = args41039.length;
switch (G__41041) {
case 1:
return nicheware.platform.utilities.common.config.load_http_config.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return nicheware.platform.utilities.common.config.load_http_config.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args41039.length)].join('')));

}
});

nicheware.platform.utilities.common.config.load_http_config.cljs$core$IFn$_invoke$arity$1 = (function (config_path){
return nicheware.platform.utilities.common.config.load_http_config.call(null,config_path,cljs.core.PersistentArrayMap.EMPTY);
});

nicheware.platform.utilities.common.config.load_http_config.cljs$core$IFn$_invoke$arity$2 = (function (config_path,opts){
var map__41042 = nicheware.platform.utilities.common.config.build_config_options.call(null,config_path,opts);
var map__41042__$1 = ((((!((map__41042 == null)))?((((map__41042.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41042.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41042):map__41042);
var env_path = cljs.core.get.call(null,map__41042__$1,new cljs.core.Keyword(null,"env-path","env-path",-736729873));
var common_path = cljs.core.get.call(null,map__41042__$1,new cljs.core.Keyword(null,"common-path","common-path",271944963));
var resolve_vars = cljs.core.get.call(null,map__41042__$1,new cljs.core.Keyword(null,"resolve-vars","resolve-vars",1598451048));
cljs.core.println.call(null,"load-http-config(), env-path: ",env_path," common-path: ",common_path);

return promesa.core.then.call(null,promesa.core.all.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [nicheware.platform.utilities.common.config.read_http_config.call(null,env_path),nicheware.platform.utilities.common.config.read_http_config.call(null,common_path)], null)),((function (map__41042,map__41042__$1,env_path,common_path,resolve_vars){
return (function (p__41044){
var vec__41045 = p__41044;
var env_config = cljs.core.nth.call(null,vec__41045,(0),null);
var common_config = cljs.core.nth.call(null,vec__41045,(1),null);
cljs.core.println.call(null,"load-http-config(): all complete, env-config: ",env_config," common-config: ",common_config);

var G__41048 = common_config;
var G__41048__$1 = nicheware.platform.utilities.common.core.deep_merge.call(null,G__41048,env_config)
;
if(cljs.core.truth_(resolve_vars)){
return nicheware.platform.utilities.common.config.resolve_template_vars.call(null,G__41048__$1);
} else {
return G__41048__$1;
}
});})(map__41042,map__41042__$1,env_path,common_path,resolve_vars))
);
});

nicheware.platform.utilities.common.config.load_http_config.cljs$lang$maxFixedArity = 2;


//# sourceMappingURL=config.js.map