// Compiled by ClojureScript 1.9.562 {}
goog.provide('kvlt.middleware.params');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('kvlt.middleware.util');
goog.require('kvlt.platform.util');
kvlt.middleware.params.query_string_PLUS_encoding = (function kvlt$middleware$params$query_string_PLUS_encoding(params,encoding){
return clojure.string.join.call(null,"&",cljs.core.mapcat.call(null,(function (p__40968){
var vec__40969 = p__40968;
var k = cljs.core.nth.call(null,vec__40969,(0),null);
var v = cljs.core.nth.call(null,vec__40969,(1),null);
if(cljs.core.sequential_QMARK_.call(null,v)){
return cljs.core.map.call(null,((function (vec__40969,k,v){
return (function (p1__40962_SHARP_,p2__40963_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(kvlt.middleware.util.url_encode.call(null,cljs.core.name.call(null,p1__40962_SHARP_),encoding)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(kvlt.middleware.util.url_encode.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__40963_SHARP_)].join(''),encoding))].join('');
});})(vec__40969,k,v))
,cljs.core.repeat.call(null,k),v);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(kvlt.middleware.util.url_encode.call(null,cljs.core.name.call(null,k),encoding)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(kvlt.middleware.util.url_encode.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join(''),encoding))].join('')], null);
}
}),params));
});
kvlt.middleware.params.query_string = (function kvlt$middleware$params$query_string(var_args){
var args__8635__auto__ = [];
var len__8628__auto___40978 = arguments.length;
var i__8629__auto___40979 = (0);
while(true){
if((i__8629__auto___40979 < len__8628__auto___40978)){
args__8635__auto__.push((arguments[i__8629__auto___40979]));

var G__40980 = (i__8629__auto___40979 + (1));
i__8629__auto___40979 = G__40980;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((1) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((1)),(0),null)):null);
return kvlt.middleware.params.query_string.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8636__auto__);
});

kvlt.middleware.params.query_string.cljs$core$IFn$_invoke$arity$variadic = (function (params,p__40974){
var vec__40975 = p__40974;
var content_type = cljs.core.nth.call(null,vec__40975,(0),null);
var encoding = kvlt.middleware.util.charset.call(null,content_type);
return kvlt.middleware.params.query_string_PLUS_encoding.call(null,params,encoding);
});

kvlt.middleware.params.query_string.cljs$lang$maxFixedArity = (1);

kvlt.middleware.params.query_string.cljs$lang$applyTo = (function (seq40972){
var G__40973 = cljs.core.first.call(null,seq40972);
var seq40972__$1 = cljs.core.next.call(null,seq40972);
return kvlt.middleware.params.query_string.cljs$core$IFn$_invoke$arity$variadic(G__40973,seq40972__$1);
});

/**
 * Rename request's `:query` key to `:query-params`
 */
kvlt.middleware.params.short_query = kvlt.middleware.util.__GT_mw.call(null,new cljs.core.Keyword(null,"short-query","short-query",1146323267),cljs.core.with_meta((function (p__40981){
var map__40982 = p__40981;
var map__40982__$1 = ((((!((map__40982 == null)))?((((map__40982.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40982.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40982):map__40982);
var m = map__40982__$1;
var query = cljs.core.get.call(null,map__40982__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"query-params","query-params",900640534),query);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"has","has",1466247447),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"removing","removing",1104822312),new cljs.core.Keyword(null,"query","query",-1288509510)], null)),null);
/**
 * Given a request having a `:query-params` map, append to the URL's
 *   query (`:query-string`) its URL-encoded string representation. 
 */
kvlt.middleware.params.query = kvlt.middleware.util.__GT_mw.call(null,new cljs.core.Keyword(null,"query","query",-1288509510),(function (p__40984){
var map__40985 = p__40984;
var map__40985__$1 = ((((!((map__40985 == null)))?((((map__40985.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40985.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40985):map__40985);
var req = map__40985__$1;
var query_params = cljs.core.get.call(null,map__40985__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
var content_type = cljs.core.get.call(null,map__40985__$1,new cljs.core.Keyword(null,"content-type","content-type",-508222634),new cljs.core.Keyword(null,"x-www-form-urlencoded","x-www-form-urlencoded",-297860611));
var G__40987 = req;
if(cljs.core.truth_(query_params)){
return cljs.core.update.call(null,cljs.core.dissoc.call(null,G__40987,new cljs.core.Keyword(null,"query-params","query-params",900640534)),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),((function (G__40987,map__40985,map__40985__$1,req,query_params,content_type){
return (function (old,new$){
if(!(cljs.core.empty_QMARK_.call(null,old))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(old),cljs.core.str.cljs$core$IFn$_invoke$arity$1("&"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new$)].join('');
} else {
return new$;
}
});})(G__40987,map__40985,map__40985__$1,req,query_params,content_type))
,kvlt.middleware.params.query_string.call(null,query_params,kvlt.middleware.util.__GT_content_type.call(null,content_type)));
} else {
return G__40987;
}
}),null);
if(typeof kvlt.middleware.params.coerce_form_params !== 'undefined'){
} else {
/**
 * Turn a `:form-params` map into a string request body, dispatching
 *   on the qualified content type, as a namespaced
 *   keyword (e.g. `:application/edn`).
 * 
 *   The baseline implementation (for
 *   `:application/x-www-form-urlencoded`) looks at the request's
 *   `:form-param-encoding` to determine the character set of the output
 *   string, on platforms where this is supported.
 */
kvlt.middleware.params.coerce_form_params = (function (){var method_table__8438__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__8439__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__8440__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__8441__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__8442__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"kvlt.middleware.params","coerce-form-params"),((function (method_table__8438__auto__,prefer_table__8439__auto__,method_cache__8440__auto__,cached_hierarchy__8441__auto__,hierarchy__8442__auto__){
return (function (p__40988){
var map__40989 = p__40988;
var map__40989__$1 = ((((!((map__40989 == null)))?((((map__40989.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40989.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40989):map__40989);
var content_type = cljs.core.get.call(null,map__40989__$1,new cljs.core.Keyword(null,"content-type","content-type",-508222634));
return cljs.core.keyword.call(null,kvlt.middleware.util.__GT_content_type.call(null,content_type));
});})(method_table__8438__auto__,prefer_table__8439__auto__,method_cache__8440__auto__,cached_hierarchy__8441__auto__,hierarchy__8442__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__8442__auto__,method_table__8438__auto__,prefer_table__8439__auto__,method_cache__8440__auto__,cached_hierarchy__8441__auto__));
})();
}
cljs.core._add_method.call(null,kvlt.middleware.params.coerce_form_params,new cljs.core.Keyword("application","x-www-form-urlencoded","application/x-www-form-urlencoded",-1692717907),(function (p__40991){
var map__40992 = p__40991;
var map__40992__$1 = ((((!((map__40992 == null)))?((((map__40992.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40992.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40992):map__40992);
var content_type = cljs.core.get.call(null,map__40992__$1,new cljs.core.Keyword(null,"content-type","content-type",-508222634));
var form_params = cljs.core.get.call(null,map__40992__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
var form_param_encoding = cljs.core.get.call(null,map__40992__$1,new cljs.core.Keyword(null,"form-param-encoding","form-param-encoding",1350836033));
if(cljs.core.truth_(form_param_encoding)){
return kvlt.middleware.params.query_string_PLUS_encoding.call(null,form_params,form_param_encoding);
} else {
return kvlt.middleware.params.query_string.call(null,form_params,kvlt.middleware.util.__GT_content_type.call(null,content_type));
}
}));
cljs.core._add_method.call(null,kvlt.middleware.params.coerce_form_params,new cljs.core.Keyword("application","edn","application/edn",-63927515),(function (p__40994){
var map__40995 = p__40994;
var map__40995__$1 = ((((!((map__40995 == null)))?((((map__40995.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40995.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40995):map__40995);
var form_params = cljs.core.get.call(null,map__40995__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
return cljs.core.pr_str.call(null,form_params);
}));
cljs.core._add_method.call(null,kvlt.middleware.params.coerce_form_params,new cljs.core.Keyword("application","json","application/json",1747896298),(function (p__40997){
var map__40998 = p__40997;
var map__40998__$1 = ((((!((map__40998 == null)))?((((map__40998.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40998.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__40998):map__40998);
var form_params = cljs.core.get.call(null,map__40998__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
return kvlt.platform.util.encode_json.call(null,form_params);
}));
/**
 * Rename request's `:form` key to `:form-params`
 */
kvlt.middleware.params.short_form = kvlt.middleware.util.__GT_mw.call(null,new cljs.core.Keyword(null,"short-form","short-form",-316565438),cljs.core.with_meta((function (p__41000){
var map__41001 = p__41000;
var map__41001__$1 = ((((!((map__41001 == null)))?((((map__41001.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41001.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41001):map__41001);
var m = map__41001__$1;
var form = cljs.core.get.call(null,map__41001__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"form-params","form-params",1884296467),form);
}),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"has","has",1466247447),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword(null,"removing","removing",1104822312),new cljs.core.Keyword(null,"form","form",-1624062471)], null)),null);
/**
 * Given a request having a `:form-params` map and a method of `POST`,
 *   `PUT` or `PATCH`, use [[coerce-form-params]] to generate a request
 *   body.  If no content type is supplied, a default of
 *   `application/x-www-form-urlencoded` is associated with the request,
 *   and passed to [[coerce-form-params]].
 * 
 *   Assumes placement after [[kvlt.middleware/method]]
 */
kvlt.middleware.params.form = kvlt.middleware.util.__GT_mw.call(null,new cljs.core.Keyword(null,"form","form",-1624062471),(function (p__41003){
var map__41004 = p__41003;
var map__41004__$1 = ((((!((map__41004 == null)))?((((map__41004.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41004.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41004):map__41004);
var req = map__41004__$1;
var form_params = cljs.core.get.call(null,map__41004__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
var content_type = cljs.core.get.call(null,map__41004__$1,new cljs.core.Keyword(null,"content-type","content-type",-508222634),new cljs.core.Keyword(null,"x-www-form-urlencoded","x-www-form-urlencoded",-297860611));
var request_method = cljs.core.get.call(null,map__41004__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core.truth_((function (){var and__7395__auto__ = form_params;
if(cljs.core.truth_(and__7395__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__7395__auto__;
}
})())){
var content_type__$1 = kvlt.middleware.util.__GT_content_type.call(null,content_type);
var req__$1 = cljs.core.assoc.call(null,req,new cljs.core.Keyword(null,"content-type","content-type",-508222634),content_type__$1);
return cljs.core.assoc.call(null,req__$1,new cljs.core.Keyword(null,"body","body",-2049205669),kvlt.middleware.params.coerce_form_params.call(null,req__$1));
} else {
return req;
}
}),null);

//# sourceMappingURL=params.js.map