// Compiled by ClojureScript 1.9.562 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args10543 = [];
var len__8628__auto___10549 = arguments.length;
var i__8629__auto___10550 = (0);
while(true){
if((i__8629__auto___10550 < len__8628__auto___10549)){
args10543.push((arguments[i__8629__auto___10550]));

var G__10551 = (i__8629__auto___10550 + (1));
i__8629__auto___10550 = G__10551;
continue;
} else {
}
break;
}

var G__10545 = args10543.length;
switch (G__10545) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10543.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async10546 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10546 = (function (f,blockable,meta10547){
this.f = f;
this.blockable = blockable;
this.meta10547 = meta10547;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async10546.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10548,meta10547__$1){
var self__ = this;
var _10548__$1 = this;
return (new cljs.core.async.t_cljs$core$async10546(self__.f,self__.blockable,meta10547__$1));
});

cljs.core.async.t_cljs$core$async10546.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10548){
var self__ = this;
var _10548__$1 = this;
return self__.meta10547;
});

cljs.core.async.t_cljs$core$async10546.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10546.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async10546.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async10546.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async10546.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta10547","meta10547",-331751593,null)], null);
});

cljs.core.async.t_cljs$core$async10546.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10546.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10546";

cljs.core.async.t_cljs$core$async10546.cljs$lang$ctorPrWriter = (function (this__8064__auto__,writer__8065__auto__,opt__8066__auto__){
return cljs.core._write.call(null,writer__8065__auto__,"cljs.core.async/t_cljs$core$async10546");
});

cljs.core.async.__GT_t_cljs$core$async10546 = (function cljs$core$async$__GT_t_cljs$core$async10546(f__$1,blockable__$1,meta10547){
return (new cljs.core.async.t_cljs$core$async10546(f__$1,blockable__$1,meta10547));
});

}

return (new cljs.core.async.t_cljs$core$async10546(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args10555 = [];
var len__8628__auto___10558 = arguments.length;
var i__8629__auto___10559 = (0);
while(true){
if((i__8629__auto___10559 < len__8628__auto___10558)){
args10555.push((arguments[i__8629__auto___10559]));

var G__10560 = (i__8629__auto___10559 + (1));
i__8629__auto___10559 = G__10560;
continue;
} else {
}
break;
}

var G__10557 = args10555.length;
switch (G__10557) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10555.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args10562 = [];
var len__8628__auto___10565 = arguments.length;
var i__8629__auto___10566 = (0);
while(true){
if((i__8629__auto___10566 < len__8628__auto___10565)){
args10562.push((arguments[i__8629__auto___10566]));

var G__10567 = (i__8629__auto___10566 + (1));
i__8629__auto___10566 = G__10567;
continue;
} else {
}
break;
}

var G__10564 = args10562.length;
switch (G__10564) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10562.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args10569 = [];
var len__8628__auto___10572 = arguments.length;
var i__8629__auto___10573 = (0);
while(true){
if((i__8629__auto___10573 < len__8628__auto___10572)){
args10569.push((arguments[i__8629__auto___10573]));

var G__10574 = (i__8629__auto___10573 + (1));
i__8629__auto___10573 = G__10574;
continue;
} else {
}
break;
}

var G__10571 = args10569.length;
switch (G__10571) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10569.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_10576 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_10576);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_10576,ret){
return (function (){
return fn1.call(null,val_10576);
});})(val_10576,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args10577 = [];
var len__8628__auto___10580 = arguments.length;
var i__8629__auto___10581 = (0);
while(true){
if((i__8629__auto___10581 < len__8628__auto___10580)){
args10577.push((arguments[i__8629__auto___10581]));

var G__10582 = (i__8629__auto___10581 + (1));
i__8629__auto___10581 = G__10582;
continue;
} else {
}
break;
}

var G__10579 = args10577.length;
switch (G__10579) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10577.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5276__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5276__auto__)){
var ret = temp__5276__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5276__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5276__auto__)){
var retb = temp__5276__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5276__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5276__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__8428__auto___10584 = n;
var x_10585 = (0);
while(true){
if((x_10585 < n__8428__auto___10584)){
(a[x_10585] = (0));

var G__10586 = (x_10585 + (1));
x_10585 = G__10586;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__10587 = (i + (1));
i = G__10587;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async10591 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10591 = (function (flag,meta10592){
this.flag = flag;
this.meta10592 = meta10592;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async10591.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_10593,meta10592__$1){
var self__ = this;
var _10593__$1 = this;
return (new cljs.core.async.t_cljs$core$async10591(self__.flag,meta10592__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async10591.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_10593){
var self__ = this;
var _10593__$1 = this;
return self__.meta10592;
});})(flag))
;

cljs.core.async.t_cljs$core$async10591.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10591.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async10591.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async10591.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async10591.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta10592","meta10592",1613379088,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async10591.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10591.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10591";

cljs.core.async.t_cljs$core$async10591.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__8064__auto__,writer__8065__auto__,opt__8066__auto__){
return cljs.core._write.call(null,writer__8065__auto__,"cljs.core.async/t_cljs$core$async10591");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async10591 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async10591(flag__$1,meta10592){
return (new cljs.core.async.t_cljs$core$async10591(flag__$1,meta10592));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async10591(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async10597 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10597 = (function (flag,cb,meta10598){
this.flag = flag;
this.cb = cb;
this.meta10598 = meta10598;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async10597.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10599,meta10598__$1){
var self__ = this;
var _10599__$1 = this;
return (new cljs.core.async.t_cljs$core$async10597(self__.flag,self__.cb,meta10598__$1));
});

cljs.core.async.t_cljs$core$async10597.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10599){
var self__ = this;
var _10599__$1 = this;
return self__.meta10598;
});

cljs.core.async.t_cljs$core$async10597.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10597.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async10597.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async10597.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async10597.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta10598","meta10598",407319358,null)], null);
});

cljs.core.async.t_cljs$core$async10597.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10597.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10597";

cljs.core.async.t_cljs$core$async10597.cljs$lang$ctorPrWriter = (function (this__8064__auto__,writer__8065__auto__,opt__8066__auto__){
return cljs.core._write.call(null,writer__8065__auto__,"cljs.core.async/t_cljs$core$async10597");
});

cljs.core.async.__GT_t_cljs$core$async10597 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async10597(flag__$1,cb__$1,meta10598){
return (new cljs.core.async.t_cljs$core$async10597(flag__$1,cb__$1,meta10598));
});

}

return (new cljs.core.async.t_cljs$core$async10597(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__10600_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__10600_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__10601_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__10601_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__7407__auto__ = wport;
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return port;
}
})()], null));
} else {
var G__10602 = (i + (1));
i = G__10602;
continue;
}
} else {
return null;
}
break;
}
})();
var or__7407__auto__ = ret;
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5278__auto__ = (function (){var and__7395__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__7395__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__7395__auto__;
}
})();
if(cljs.core.truth_(temp__5278__auto__)){
var got = temp__5278__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__8635__auto__ = [];
var len__8628__auto___10608 = arguments.length;
var i__8629__auto___10609 = (0);
while(true){
if((i__8629__auto___10609 < len__8628__auto___10608)){
args__8635__auto__.push((arguments[i__8629__auto___10609]));

var G__10610 = (i__8629__auto___10609 + (1));
i__8629__auto___10609 = G__10610;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((1) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8636__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__10605){
var map__10606 = p__10605;
var map__10606__$1 = ((((!((map__10606 == null)))?((((map__10606.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__10606.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__10606):map__10606);
var opts = map__10606__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq10603){
var G__10604 = cljs.core.first.call(null,seq10603);
var seq10603__$1 = cljs.core.next.call(null,seq10603);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__10604,seq10603__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args10611 = [];
var len__8628__auto___10661 = arguments.length;
var i__8629__auto___10662 = (0);
while(true){
if((i__8629__auto___10662 < len__8628__auto___10661)){
args10611.push((arguments[i__8629__auto___10662]));

var G__10663 = (i__8629__auto___10662 + (1));
i__8629__auto___10662 = G__10663;
continue;
} else {
}
break;
}

var G__10613 = args10611.length;
switch (G__10613) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10611.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__10484__auto___10665 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto___10665){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto___10665){
return (function (state_10637){
var state_val_10638 = (state_10637[(1)]);
if((state_val_10638 === (7))){
var inst_10633 = (state_10637[(2)]);
var state_10637__$1 = state_10637;
var statearr_10639_10666 = state_10637__$1;
(statearr_10639_10666[(2)] = inst_10633);

(statearr_10639_10666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10638 === (1))){
var state_10637__$1 = state_10637;
var statearr_10640_10667 = state_10637__$1;
(statearr_10640_10667[(2)] = null);

(statearr_10640_10667[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10638 === (4))){
var inst_10616 = (state_10637[(7)]);
var inst_10616__$1 = (state_10637[(2)]);
var inst_10617 = (inst_10616__$1 == null);
var state_10637__$1 = (function (){var statearr_10641 = state_10637;
(statearr_10641[(7)] = inst_10616__$1);

return statearr_10641;
})();
if(cljs.core.truth_(inst_10617)){
var statearr_10642_10668 = state_10637__$1;
(statearr_10642_10668[(1)] = (5));

} else {
var statearr_10643_10669 = state_10637__$1;
(statearr_10643_10669[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10638 === (13))){
var state_10637__$1 = state_10637;
var statearr_10644_10670 = state_10637__$1;
(statearr_10644_10670[(2)] = null);

(statearr_10644_10670[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10638 === (6))){
var inst_10616 = (state_10637[(7)]);
var state_10637__$1 = state_10637;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10637__$1,(11),to,inst_10616);
} else {
if((state_val_10638 === (3))){
var inst_10635 = (state_10637[(2)]);
var state_10637__$1 = state_10637;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10637__$1,inst_10635);
} else {
if((state_val_10638 === (12))){
var state_10637__$1 = state_10637;
var statearr_10645_10671 = state_10637__$1;
(statearr_10645_10671[(2)] = null);

(statearr_10645_10671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10638 === (2))){
var state_10637__$1 = state_10637;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10637__$1,(4),from);
} else {
if((state_val_10638 === (11))){
var inst_10626 = (state_10637[(2)]);
var state_10637__$1 = state_10637;
if(cljs.core.truth_(inst_10626)){
var statearr_10646_10672 = state_10637__$1;
(statearr_10646_10672[(1)] = (12));

} else {
var statearr_10647_10673 = state_10637__$1;
(statearr_10647_10673[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10638 === (9))){
var state_10637__$1 = state_10637;
var statearr_10648_10674 = state_10637__$1;
(statearr_10648_10674[(2)] = null);

(statearr_10648_10674[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10638 === (5))){
var state_10637__$1 = state_10637;
if(cljs.core.truth_(close_QMARK_)){
var statearr_10649_10675 = state_10637__$1;
(statearr_10649_10675[(1)] = (8));

} else {
var statearr_10650_10676 = state_10637__$1;
(statearr_10650_10676[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10638 === (14))){
var inst_10631 = (state_10637[(2)]);
var state_10637__$1 = state_10637;
var statearr_10651_10677 = state_10637__$1;
(statearr_10651_10677[(2)] = inst_10631);

(statearr_10651_10677[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10638 === (10))){
var inst_10623 = (state_10637[(2)]);
var state_10637__$1 = state_10637;
var statearr_10652_10678 = state_10637__$1;
(statearr_10652_10678[(2)] = inst_10623);

(statearr_10652_10678[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10638 === (8))){
var inst_10620 = cljs.core.async.close_BANG_.call(null,to);
var state_10637__$1 = state_10637;
var statearr_10653_10679 = state_10637__$1;
(statearr_10653_10679[(2)] = inst_10620);

(statearr_10653_10679[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10484__auto___10665))
;
return ((function (switch__10370__auto__,c__10484__auto___10665){
return (function() {
var cljs$core$async$state_machine__10371__auto__ = null;
var cljs$core$async$state_machine__10371__auto____0 = (function (){
var statearr_10657 = [null,null,null,null,null,null,null,null];
(statearr_10657[(0)] = cljs$core$async$state_machine__10371__auto__);

(statearr_10657[(1)] = (1));

return statearr_10657;
});
var cljs$core$async$state_machine__10371__auto____1 = (function (state_10637){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_10637);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e10658){if((e10658 instanceof Object)){
var ex__10374__auto__ = e10658;
var statearr_10659_10680 = state_10637;
(statearr_10659_10680[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10637);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10658;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10681 = state_10637;
state_10637 = G__10681;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$state_machine__10371__auto__ = function(state_10637){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10371__auto____1.call(this,state_10637);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10371__auto____0;
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10371__auto____1;
return cljs$core$async$state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto___10665))
})();
var state__10486__auto__ = (function (){var statearr_10660 = f__10485__auto__.call(null);
(statearr_10660[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto___10665);

return statearr_10660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto___10665))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__10869){
var vec__10870 = p__10869;
var v = cljs.core.nth.call(null,vec__10870,(0),null);
var p = cljs.core.nth.call(null,vec__10870,(1),null);
var job = vec__10870;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__10484__auto___11056 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto___11056,res,vec__10870,v,p,job,jobs,results){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto___11056,res,vec__10870,v,p,job,jobs,results){
return (function (state_10877){
var state_val_10878 = (state_10877[(1)]);
if((state_val_10878 === (1))){
var state_10877__$1 = state_10877;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10877__$1,(2),res,v);
} else {
if((state_val_10878 === (2))){
var inst_10874 = (state_10877[(2)]);
var inst_10875 = cljs.core.async.close_BANG_.call(null,res);
var state_10877__$1 = (function (){var statearr_10879 = state_10877;
(statearr_10879[(7)] = inst_10874);

return statearr_10879;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10877__$1,inst_10875);
} else {
return null;
}
}
});})(c__10484__auto___11056,res,vec__10870,v,p,job,jobs,results))
;
return ((function (switch__10370__auto__,c__10484__auto___11056,res,vec__10870,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____0 = (function (){
var statearr_10883 = [null,null,null,null,null,null,null,null];
(statearr_10883[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__);

(statearr_10883[(1)] = (1));

return statearr_10883;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____1 = (function (state_10877){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_10877);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e10884){if((e10884 instanceof Object)){
var ex__10374__auto__ = e10884;
var statearr_10885_11057 = state_10877;
(statearr_10885_11057[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10877);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10884;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11058 = state_10877;
state_10877 = G__11058;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__ = function(state_10877){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____1.call(this,state_10877);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto___11056,res,vec__10870,v,p,job,jobs,results))
})();
var state__10486__auto__ = (function (){var statearr_10886 = f__10485__auto__.call(null);
(statearr_10886[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto___11056);

return statearr_10886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto___11056,res,vec__10870,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__10887){
var vec__10888 = p__10887;
var v = cljs.core.nth.call(null,vec__10888,(0),null);
var p = cljs.core.nth.call(null,vec__10888,(1),null);
var job = vec__10888;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__8428__auto___11059 = n;
var __11060 = (0);
while(true){
if((__11060 < n__8428__auto___11059)){
var G__10891_11061 = type;
var G__10891_11062__$1 = (((G__10891_11061 instanceof cljs.core.Keyword))?G__10891_11061.fqn:null);
switch (G__10891_11062__$1) {
case "compute":
var c__10484__auto___11064 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11060,c__10484__auto___11064,G__10891_11061,G__10891_11062__$1,n__8428__auto___11059,jobs,results,process,async){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (__11060,c__10484__auto___11064,G__10891_11061,G__10891_11062__$1,n__8428__auto___11059,jobs,results,process,async){
return (function (state_10904){
var state_val_10905 = (state_10904[(1)]);
if((state_val_10905 === (1))){
var state_10904__$1 = state_10904;
var statearr_10906_11065 = state_10904__$1;
(statearr_10906_11065[(2)] = null);

(statearr_10906_11065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10905 === (2))){
var state_10904__$1 = state_10904;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10904__$1,(4),jobs);
} else {
if((state_val_10905 === (3))){
var inst_10902 = (state_10904[(2)]);
var state_10904__$1 = state_10904;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10904__$1,inst_10902);
} else {
if((state_val_10905 === (4))){
var inst_10894 = (state_10904[(2)]);
var inst_10895 = process.call(null,inst_10894);
var state_10904__$1 = state_10904;
if(cljs.core.truth_(inst_10895)){
var statearr_10907_11066 = state_10904__$1;
(statearr_10907_11066[(1)] = (5));

} else {
var statearr_10908_11067 = state_10904__$1;
(statearr_10908_11067[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10905 === (5))){
var state_10904__$1 = state_10904;
var statearr_10909_11068 = state_10904__$1;
(statearr_10909_11068[(2)] = null);

(statearr_10909_11068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10905 === (6))){
var state_10904__$1 = state_10904;
var statearr_10910_11069 = state_10904__$1;
(statearr_10910_11069[(2)] = null);

(statearr_10910_11069[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10905 === (7))){
var inst_10900 = (state_10904[(2)]);
var state_10904__$1 = state_10904;
var statearr_10911_11070 = state_10904__$1;
(statearr_10911_11070[(2)] = inst_10900);

(statearr_10911_11070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11060,c__10484__auto___11064,G__10891_11061,G__10891_11062__$1,n__8428__auto___11059,jobs,results,process,async))
;
return ((function (__11060,switch__10370__auto__,c__10484__auto___11064,G__10891_11061,G__10891_11062__$1,n__8428__auto___11059,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____0 = (function (){
var statearr_10915 = [null,null,null,null,null,null,null];
(statearr_10915[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__);

(statearr_10915[(1)] = (1));

return statearr_10915;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____1 = (function (state_10904){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_10904);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e10916){if((e10916 instanceof Object)){
var ex__10374__auto__ = e10916;
var statearr_10917_11071 = state_10904;
(statearr_10917_11071[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10904);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10916;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11072 = state_10904;
state_10904 = G__11072;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__ = function(state_10904){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____1.call(this,state_10904);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__;
})()
;})(__11060,switch__10370__auto__,c__10484__auto___11064,G__10891_11061,G__10891_11062__$1,n__8428__auto___11059,jobs,results,process,async))
})();
var state__10486__auto__ = (function (){var statearr_10918 = f__10485__auto__.call(null);
(statearr_10918[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto___11064);

return statearr_10918;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(__11060,c__10484__auto___11064,G__10891_11061,G__10891_11062__$1,n__8428__auto___11059,jobs,results,process,async))
);


break;
case "async":
var c__10484__auto___11073 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11060,c__10484__auto___11073,G__10891_11061,G__10891_11062__$1,n__8428__auto___11059,jobs,results,process,async){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (__11060,c__10484__auto___11073,G__10891_11061,G__10891_11062__$1,n__8428__auto___11059,jobs,results,process,async){
return (function (state_10931){
var state_val_10932 = (state_10931[(1)]);
if((state_val_10932 === (1))){
var state_10931__$1 = state_10931;
var statearr_10933_11074 = state_10931__$1;
(statearr_10933_11074[(2)] = null);

(statearr_10933_11074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10932 === (2))){
var state_10931__$1 = state_10931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10931__$1,(4),jobs);
} else {
if((state_val_10932 === (3))){
var inst_10929 = (state_10931[(2)]);
var state_10931__$1 = state_10931;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10931__$1,inst_10929);
} else {
if((state_val_10932 === (4))){
var inst_10921 = (state_10931[(2)]);
var inst_10922 = async.call(null,inst_10921);
var state_10931__$1 = state_10931;
if(cljs.core.truth_(inst_10922)){
var statearr_10934_11075 = state_10931__$1;
(statearr_10934_11075[(1)] = (5));

} else {
var statearr_10935_11076 = state_10931__$1;
(statearr_10935_11076[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10932 === (5))){
var state_10931__$1 = state_10931;
var statearr_10936_11077 = state_10931__$1;
(statearr_10936_11077[(2)] = null);

(statearr_10936_11077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10932 === (6))){
var state_10931__$1 = state_10931;
var statearr_10937_11078 = state_10931__$1;
(statearr_10937_11078[(2)] = null);

(statearr_10937_11078[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10932 === (7))){
var inst_10927 = (state_10931[(2)]);
var state_10931__$1 = state_10931;
var statearr_10938_11079 = state_10931__$1;
(statearr_10938_11079[(2)] = inst_10927);

(statearr_10938_11079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11060,c__10484__auto___11073,G__10891_11061,G__10891_11062__$1,n__8428__auto___11059,jobs,results,process,async))
;
return ((function (__11060,switch__10370__auto__,c__10484__auto___11073,G__10891_11061,G__10891_11062__$1,n__8428__auto___11059,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____0 = (function (){
var statearr_10942 = [null,null,null,null,null,null,null];
(statearr_10942[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__);

(statearr_10942[(1)] = (1));

return statearr_10942;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____1 = (function (state_10931){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_10931);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e10943){if((e10943 instanceof Object)){
var ex__10374__auto__ = e10943;
var statearr_10944_11080 = state_10931;
(statearr_10944_11080[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10931);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10943;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11081 = state_10931;
state_10931 = G__11081;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__ = function(state_10931){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____1.call(this,state_10931);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__;
})()
;})(__11060,switch__10370__auto__,c__10484__auto___11073,G__10891_11061,G__10891_11062__$1,n__8428__auto___11059,jobs,results,process,async))
})();
var state__10486__auto__ = (function (){var statearr_10945 = f__10485__auto__.call(null);
(statearr_10945[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto___11073);

return statearr_10945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(__11060,c__10484__auto___11073,G__10891_11061,G__10891_11062__$1,n__8428__auto___11059,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__10891_11062__$1)].join('')));

}

var G__11082 = (__11060 + (1));
__11060 = G__11082;
continue;
} else {
}
break;
}

var c__10484__auto___11083 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto___11083,jobs,results,process,async){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto___11083,jobs,results,process,async){
return (function (state_10967){
var state_val_10968 = (state_10967[(1)]);
if((state_val_10968 === (1))){
var state_10967__$1 = state_10967;
var statearr_10969_11084 = state_10967__$1;
(statearr_10969_11084[(2)] = null);

(statearr_10969_11084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10968 === (2))){
var state_10967__$1 = state_10967;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10967__$1,(4),from);
} else {
if((state_val_10968 === (3))){
var inst_10965 = (state_10967[(2)]);
var state_10967__$1 = state_10967;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10967__$1,inst_10965);
} else {
if((state_val_10968 === (4))){
var inst_10948 = (state_10967[(7)]);
var inst_10948__$1 = (state_10967[(2)]);
var inst_10949 = (inst_10948__$1 == null);
var state_10967__$1 = (function (){var statearr_10970 = state_10967;
(statearr_10970[(7)] = inst_10948__$1);

return statearr_10970;
})();
if(cljs.core.truth_(inst_10949)){
var statearr_10971_11085 = state_10967__$1;
(statearr_10971_11085[(1)] = (5));

} else {
var statearr_10972_11086 = state_10967__$1;
(statearr_10972_11086[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10968 === (5))){
var inst_10951 = cljs.core.async.close_BANG_.call(null,jobs);
var state_10967__$1 = state_10967;
var statearr_10973_11087 = state_10967__$1;
(statearr_10973_11087[(2)] = inst_10951);

(statearr_10973_11087[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10968 === (6))){
var inst_10953 = (state_10967[(8)]);
var inst_10948 = (state_10967[(7)]);
var inst_10953__$1 = cljs.core.async.chan.call(null,(1));
var inst_10954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_10955 = [inst_10948,inst_10953__$1];
var inst_10956 = (new cljs.core.PersistentVector(null,2,(5),inst_10954,inst_10955,null));
var state_10967__$1 = (function (){var statearr_10974 = state_10967;
(statearr_10974[(8)] = inst_10953__$1);

return statearr_10974;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10967__$1,(8),jobs,inst_10956);
} else {
if((state_val_10968 === (7))){
var inst_10963 = (state_10967[(2)]);
var state_10967__$1 = state_10967;
var statearr_10975_11088 = state_10967__$1;
(statearr_10975_11088[(2)] = inst_10963);

(statearr_10975_11088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10968 === (8))){
var inst_10953 = (state_10967[(8)]);
var inst_10958 = (state_10967[(2)]);
var state_10967__$1 = (function (){var statearr_10976 = state_10967;
(statearr_10976[(9)] = inst_10958);

return statearr_10976;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10967__$1,(9),results,inst_10953);
} else {
if((state_val_10968 === (9))){
var inst_10960 = (state_10967[(2)]);
var state_10967__$1 = (function (){var statearr_10977 = state_10967;
(statearr_10977[(10)] = inst_10960);

return statearr_10977;
})();
var statearr_10978_11089 = state_10967__$1;
(statearr_10978_11089[(2)] = null);

(statearr_10978_11089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__10484__auto___11083,jobs,results,process,async))
;
return ((function (switch__10370__auto__,c__10484__auto___11083,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____0 = (function (){
var statearr_10982 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_10982[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__);

(statearr_10982[(1)] = (1));

return statearr_10982;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____1 = (function (state_10967){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_10967);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e10983){if((e10983 instanceof Object)){
var ex__10374__auto__ = e10983;
var statearr_10984_11090 = state_10967;
(statearr_10984_11090[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10967);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10983;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11091 = state_10967;
state_10967 = G__11091;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__ = function(state_10967){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____1.call(this,state_10967);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto___11083,jobs,results,process,async))
})();
var state__10486__auto__ = (function (){var statearr_10985 = f__10485__auto__.call(null);
(statearr_10985[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto___11083);

return statearr_10985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto___11083,jobs,results,process,async))
);


var c__10484__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto__,jobs,results,process,async){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto__,jobs,results,process,async){
return (function (state_11023){
var state_val_11024 = (state_11023[(1)]);
if((state_val_11024 === (7))){
var inst_11019 = (state_11023[(2)]);
var state_11023__$1 = state_11023;
var statearr_11025_11092 = state_11023__$1;
(statearr_11025_11092[(2)] = inst_11019);

(statearr_11025_11092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11024 === (20))){
var state_11023__$1 = state_11023;
var statearr_11026_11093 = state_11023__$1;
(statearr_11026_11093[(2)] = null);

(statearr_11026_11093[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11024 === (1))){
var state_11023__$1 = state_11023;
var statearr_11027_11094 = state_11023__$1;
(statearr_11027_11094[(2)] = null);

(statearr_11027_11094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11024 === (4))){
var inst_10988 = (state_11023[(7)]);
var inst_10988__$1 = (state_11023[(2)]);
var inst_10989 = (inst_10988__$1 == null);
var state_11023__$1 = (function (){var statearr_11028 = state_11023;
(statearr_11028[(7)] = inst_10988__$1);

return statearr_11028;
})();
if(cljs.core.truth_(inst_10989)){
var statearr_11029_11095 = state_11023__$1;
(statearr_11029_11095[(1)] = (5));

} else {
var statearr_11030_11096 = state_11023__$1;
(statearr_11030_11096[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11024 === (15))){
var inst_11001 = (state_11023[(8)]);
var state_11023__$1 = state_11023;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11023__$1,(18),to,inst_11001);
} else {
if((state_val_11024 === (21))){
var inst_11014 = (state_11023[(2)]);
var state_11023__$1 = state_11023;
var statearr_11031_11097 = state_11023__$1;
(statearr_11031_11097[(2)] = inst_11014);

(statearr_11031_11097[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11024 === (13))){
var inst_11016 = (state_11023[(2)]);
var state_11023__$1 = (function (){var statearr_11032 = state_11023;
(statearr_11032[(9)] = inst_11016);

return statearr_11032;
})();
var statearr_11033_11098 = state_11023__$1;
(statearr_11033_11098[(2)] = null);

(statearr_11033_11098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11024 === (6))){
var inst_10988 = (state_11023[(7)]);
var state_11023__$1 = state_11023;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11023__$1,(11),inst_10988);
} else {
if((state_val_11024 === (17))){
var inst_11009 = (state_11023[(2)]);
var state_11023__$1 = state_11023;
if(cljs.core.truth_(inst_11009)){
var statearr_11034_11099 = state_11023__$1;
(statearr_11034_11099[(1)] = (19));

} else {
var statearr_11035_11100 = state_11023__$1;
(statearr_11035_11100[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11024 === (3))){
var inst_11021 = (state_11023[(2)]);
var state_11023__$1 = state_11023;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11023__$1,inst_11021);
} else {
if((state_val_11024 === (12))){
var inst_10998 = (state_11023[(10)]);
var state_11023__$1 = state_11023;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11023__$1,(14),inst_10998);
} else {
if((state_val_11024 === (2))){
var state_11023__$1 = state_11023;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11023__$1,(4),results);
} else {
if((state_val_11024 === (19))){
var state_11023__$1 = state_11023;
var statearr_11036_11101 = state_11023__$1;
(statearr_11036_11101[(2)] = null);

(statearr_11036_11101[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11024 === (11))){
var inst_10998 = (state_11023[(2)]);
var state_11023__$1 = (function (){var statearr_11037 = state_11023;
(statearr_11037[(10)] = inst_10998);

return statearr_11037;
})();
var statearr_11038_11102 = state_11023__$1;
(statearr_11038_11102[(2)] = null);

(statearr_11038_11102[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11024 === (9))){
var state_11023__$1 = state_11023;
var statearr_11039_11103 = state_11023__$1;
(statearr_11039_11103[(2)] = null);

(statearr_11039_11103[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11024 === (5))){
var state_11023__$1 = state_11023;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11040_11104 = state_11023__$1;
(statearr_11040_11104[(1)] = (8));

} else {
var statearr_11041_11105 = state_11023__$1;
(statearr_11041_11105[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11024 === (14))){
var inst_11003 = (state_11023[(11)]);
var inst_11001 = (state_11023[(8)]);
var inst_11001__$1 = (state_11023[(2)]);
var inst_11002 = (inst_11001__$1 == null);
var inst_11003__$1 = cljs.core.not.call(null,inst_11002);
var state_11023__$1 = (function (){var statearr_11042 = state_11023;
(statearr_11042[(11)] = inst_11003__$1);

(statearr_11042[(8)] = inst_11001__$1);

return statearr_11042;
})();
if(inst_11003__$1){
var statearr_11043_11106 = state_11023__$1;
(statearr_11043_11106[(1)] = (15));

} else {
var statearr_11044_11107 = state_11023__$1;
(statearr_11044_11107[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11024 === (16))){
var inst_11003 = (state_11023[(11)]);
var state_11023__$1 = state_11023;
var statearr_11045_11108 = state_11023__$1;
(statearr_11045_11108[(2)] = inst_11003);

(statearr_11045_11108[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11024 === (10))){
var inst_10995 = (state_11023[(2)]);
var state_11023__$1 = state_11023;
var statearr_11046_11109 = state_11023__$1;
(statearr_11046_11109[(2)] = inst_10995);

(statearr_11046_11109[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11024 === (18))){
var inst_11006 = (state_11023[(2)]);
var state_11023__$1 = state_11023;
var statearr_11047_11110 = state_11023__$1;
(statearr_11047_11110[(2)] = inst_11006);

(statearr_11047_11110[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11024 === (8))){
var inst_10992 = cljs.core.async.close_BANG_.call(null,to);
var state_11023__$1 = state_11023;
var statearr_11048_11111 = state_11023__$1;
(statearr_11048_11111[(2)] = inst_10992);

(statearr_11048_11111[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10484__auto__,jobs,results,process,async))
;
return ((function (switch__10370__auto__,c__10484__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____0 = (function (){
var statearr_11052 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11052[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__);

(statearr_11052[(1)] = (1));

return statearr_11052;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____1 = (function (state_11023){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_11023);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e11053){if((e11053 instanceof Object)){
var ex__10374__auto__ = e11053;
var statearr_11054_11112 = state_11023;
(statearr_11054_11112[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11023);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11053;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11113 = state_11023;
state_11023 = G__11113;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__ = function(state_11023){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____1.call(this,state_11023);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10371__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto__,jobs,results,process,async))
})();
var state__10486__auto__ = (function (){var statearr_11055 = f__10485__auto__.call(null);
(statearr_11055[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto__);

return statearr_11055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto__,jobs,results,process,async))
);

return c__10484__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args11114 = [];
var len__8628__auto___11117 = arguments.length;
var i__8629__auto___11118 = (0);
while(true){
if((i__8629__auto___11118 < len__8628__auto___11117)){
args11114.push((arguments[i__8629__auto___11118]));

var G__11119 = (i__8629__auto___11118 + (1));
i__8629__auto___11118 = G__11119;
continue;
} else {
}
break;
}

var G__11116 = args11114.length;
switch (G__11116) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11114.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args11121 = [];
var len__8628__auto___11124 = arguments.length;
var i__8629__auto___11125 = (0);
while(true){
if((i__8629__auto___11125 < len__8628__auto___11124)){
args11121.push((arguments[i__8629__auto___11125]));

var G__11126 = (i__8629__auto___11125 + (1));
i__8629__auto___11125 = G__11126;
continue;
} else {
}
break;
}

var G__11123 = args11121.length;
switch (G__11123) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11121.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args11128 = [];
var len__8628__auto___11181 = arguments.length;
var i__8629__auto___11182 = (0);
while(true){
if((i__8629__auto___11182 < len__8628__auto___11181)){
args11128.push((arguments[i__8629__auto___11182]));

var G__11183 = (i__8629__auto___11182 + (1));
i__8629__auto___11182 = G__11183;
continue;
} else {
}
break;
}

var G__11130 = args11128.length;
switch (G__11130) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11128.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__10484__auto___11185 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto___11185,tc,fc){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto___11185,tc,fc){
return (function (state_11156){
var state_val_11157 = (state_11156[(1)]);
if((state_val_11157 === (7))){
var inst_11152 = (state_11156[(2)]);
var state_11156__$1 = state_11156;
var statearr_11158_11186 = state_11156__$1;
(statearr_11158_11186[(2)] = inst_11152);

(statearr_11158_11186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11157 === (1))){
var state_11156__$1 = state_11156;
var statearr_11159_11187 = state_11156__$1;
(statearr_11159_11187[(2)] = null);

(statearr_11159_11187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11157 === (4))){
var inst_11133 = (state_11156[(7)]);
var inst_11133__$1 = (state_11156[(2)]);
var inst_11134 = (inst_11133__$1 == null);
var state_11156__$1 = (function (){var statearr_11160 = state_11156;
(statearr_11160[(7)] = inst_11133__$1);

return statearr_11160;
})();
if(cljs.core.truth_(inst_11134)){
var statearr_11161_11188 = state_11156__$1;
(statearr_11161_11188[(1)] = (5));

} else {
var statearr_11162_11189 = state_11156__$1;
(statearr_11162_11189[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11157 === (13))){
var state_11156__$1 = state_11156;
var statearr_11163_11190 = state_11156__$1;
(statearr_11163_11190[(2)] = null);

(statearr_11163_11190[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11157 === (6))){
var inst_11133 = (state_11156[(7)]);
var inst_11139 = p.call(null,inst_11133);
var state_11156__$1 = state_11156;
if(cljs.core.truth_(inst_11139)){
var statearr_11164_11191 = state_11156__$1;
(statearr_11164_11191[(1)] = (9));

} else {
var statearr_11165_11192 = state_11156__$1;
(statearr_11165_11192[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11157 === (3))){
var inst_11154 = (state_11156[(2)]);
var state_11156__$1 = state_11156;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11156__$1,inst_11154);
} else {
if((state_val_11157 === (12))){
var state_11156__$1 = state_11156;
var statearr_11166_11193 = state_11156__$1;
(statearr_11166_11193[(2)] = null);

(statearr_11166_11193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11157 === (2))){
var state_11156__$1 = state_11156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11156__$1,(4),ch);
} else {
if((state_val_11157 === (11))){
var inst_11133 = (state_11156[(7)]);
var inst_11143 = (state_11156[(2)]);
var state_11156__$1 = state_11156;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11156__$1,(8),inst_11143,inst_11133);
} else {
if((state_val_11157 === (9))){
var state_11156__$1 = state_11156;
var statearr_11167_11194 = state_11156__$1;
(statearr_11167_11194[(2)] = tc);

(statearr_11167_11194[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11157 === (5))){
var inst_11136 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11137 = cljs.core.async.close_BANG_.call(null,fc);
var state_11156__$1 = (function (){var statearr_11168 = state_11156;
(statearr_11168[(8)] = inst_11136);

return statearr_11168;
})();
var statearr_11169_11195 = state_11156__$1;
(statearr_11169_11195[(2)] = inst_11137);

(statearr_11169_11195[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11157 === (14))){
var inst_11150 = (state_11156[(2)]);
var state_11156__$1 = state_11156;
var statearr_11170_11196 = state_11156__$1;
(statearr_11170_11196[(2)] = inst_11150);

(statearr_11170_11196[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11157 === (10))){
var state_11156__$1 = state_11156;
var statearr_11171_11197 = state_11156__$1;
(statearr_11171_11197[(2)] = fc);

(statearr_11171_11197[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11157 === (8))){
var inst_11145 = (state_11156[(2)]);
var state_11156__$1 = state_11156;
if(cljs.core.truth_(inst_11145)){
var statearr_11172_11198 = state_11156__$1;
(statearr_11172_11198[(1)] = (12));

} else {
var statearr_11173_11199 = state_11156__$1;
(statearr_11173_11199[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10484__auto___11185,tc,fc))
;
return ((function (switch__10370__auto__,c__10484__auto___11185,tc,fc){
return (function() {
var cljs$core$async$state_machine__10371__auto__ = null;
var cljs$core$async$state_machine__10371__auto____0 = (function (){
var statearr_11177 = [null,null,null,null,null,null,null,null,null];
(statearr_11177[(0)] = cljs$core$async$state_machine__10371__auto__);

(statearr_11177[(1)] = (1));

return statearr_11177;
});
var cljs$core$async$state_machine__10371__auto____1 = (function (state_11156){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_11156);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e11178){if((e11178 instanceof Object)){
var ex__10374__auto__ = e11178;
var statearr_11179_11200 = state_11156;
(statearr_11179_11200[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11156);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11178;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11201 = state_11156;
state_11156 = G__11201;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$state_machine__10371__auto__ = function(state_11156){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10371__auto____1.call(this,state_11156);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10371__auto____0;
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10371__auto____1;
return cljs$core$async$state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto___11185,tc,fc))
})();
var state__10486__auto__ = (function (){var statearr_11180 = f__10485__auto__.call(null);
(statearr_11180[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto___11185);

return statearr_11180;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto___11185,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__10484__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto__){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto__){
return (function (state_11265){
var state_val_11266 = (state_11265[(1)]);
if((state_val_11266 === (7))){
var inst_11261 = (state_11265[(2)]);
var state_11265__$1 = state_11265;
var statearr_11267_11288 = state_11265__$1;
(statearr_11267_11288[(2)] = inst_11261);

(statearr_11267_11288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11266 === (1))){
var inst_11245 = init;
var state_11265__$1 = (function (){var statearr_11268 = state_11265;
(statearr_11268[(7)] = inst_11245);

return statearr_11268;
})();
var statearr_11269_11289 = state_11265__$1;
(statearr_11269_11289[(2)] = null);

(statearr_11269_11289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11266 === (4))){
var inst_11248 = (state_11265[(8)]);
var inst_11248__$1 = (state_11265[(2)]);
var inst_11249 = (inst_11248__$1 == null);
var state_11265__$1 = (function (){var statearr_11270 = state_11265;
(statearr_11270[(8)] = inst_11248__$1);

return statearr_11270;
})();
if(cljs.core.truth_(inst_11249)){
var statearr_11271_11290 = state_11265__$1;
(statearr_11271_11290[(1)] = (5));

} else {
var statearr_11272_11291 = state_11265__$1;
(statearr_11272_11291[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11266 === (6))){
var inst_11252 = (state_11265[(9)]);
var inst_11245 = (state_11265[(7)]);
var inst_11248 = (state_11265[(8)]);
var inst_11252__$1 = f.call(null,inst_11245,inst_11248);
var inst_11253 = cljs.core.reduced_QMARK_.call(null,inst_11252__$1);
var state_11265__$1 = (function (){var statearr_11273 = state_11265;
(statearr_11273[(9)] = inst_11252__$1);

return statearr_11273;
})();
if(inst_11253){
var statearr_11274_11292 = state_11265__$1;
(statearr_11274_11292[(1)] = (8));

} else {
var statearr_11275_11293 = state_11265__$1;
(statearr_11275_11293[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11266 === (3))){
var inst_11263 = (state_11265[(2)]);
var state_11265__$1 = state_11265;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11265__$1,inst_11263);
} else {
if((state_val_11266 === (2))){
var state_11265__$1 = state_11265;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11265__$1,(4),ch);
} else {
if((state_val_11266 === (9))){
var inst_11252 = (state_11265[(9)]);
var inst_11245 = inst_11252;
var state_11265__$1 = (function (){var statearr_11276 = state_11265;
(statearr_11276[(7)] = inst_11245);

return statearr_11276;
})();
var statearr_11277_11294 = state_11265__$1;
(statearr_11277_11294[(2)] = null);

(statearr_11277_11294[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11266 === (5))){
var inst_11245 = (state_11265[(7)]);
var state_11265__$1 = state_11265;
var statearr_11278_11295 = state_11265__$1;
(statearr_11278_11295[(2)] = inst_11245);

(statearr_11278_11295[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11266 === (10))){
var inst_11259 = (state_11265[(2)]);
var state_11265__$1 = state_11265;
var statearr_11279_11296 = state_11265__$1;
(statearr_11279_11296[(2)] = inst_11259);

(statearr_11279_11296[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11266 === (8))){
var inst_11252 = (state_11265[(9)]);
var inst_11255 = cljs.core.deref.call(null,inst_11252);
var state_11265__$1 = state_11265;
var statearr_11280_11297 = state_11265__$1;
(statearr_11280_11297[(2)] = inst_11255);

(statearr_11280_11297[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__10484__auto__))
;
return ((function (switch__10370__auto__,c__10484__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__10371__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10371__auto____0 = (function (){
var statearr_11284 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11284[(0)] = cljs$core$async$reduce_$_state_machine__10371__auto__);

(statearr_11284[(1)] = (1));

return statearr_11284;
});
var cljs$core$async$reduce_$_state_machine__10371__auto____1 = (function (state_11265){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_11265);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e11285){if((e11285 instanceof Object)){
var ex__10374__auto__ = e11285;
var statearr_11286_11298 = state_11265;
(statearr_11286_11298[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11265);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11285;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11299 = state_11265;
state_11265 = G__11299;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10371__auto__ = function(state_11265){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10371__auto____1.call(this,state_11265);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10371__auto____0;
cljs$core$async$reduce_$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10371__auto____1;
return cljs$core$async$reduce_$_state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto__))
})();
var state__10486__auto__ = (function (){var statearr_11287 = f__10485__auto__.call(null);
(statearr_11287[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto__);

return statearr_11287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto__))
);

return c__10484__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__10484__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto__,f__$1){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto__,f__$1){
return (function (state_11319){
var state_val_11320 = (state_11319[(1)]);
if((state_val_11320 === (1))){
var inst_11314 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_11319__$1 = state_11319;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11319__$1,(2),inst_11314);
} else {
if((state_val_11320 === (2))){
var inst_11316 = (state_11319[(2)]);
var inst_11317 = f__$1.call(null,inst_11316);
var state_11319__$1 = state_11319;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11319__$1,inst_11317);
} else {
return null;
}
}
});})(c__10484__auto__,f__$1))
;
return ((function (switch__10370__auto__,c__10484__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__10371__auto__ = null;
var cljs$core$async$transduce_$_state_machine__10371__auto____0 = (function (){
var statearr_11324 = [null,null,null,null,null,null,null];
(statearr_11324[(0)] = cljs$core$async$transduce_$_state_machine__10371__auto__);

(statearr_11324[(1)] = (1));

return statearr_11324;
});
var cljs$core$async$transduce_$_state_machine__10371__auto____1 = (function (state_11319){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_11319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e11325){if((e11325 instanceof Object)){
var ex__10374__auto__ = e11325;
var statearr_11326_11328 = state_11319;
(statearr_11326_11328[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11319);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11325;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11329 = state_11319;
state_11319 = G__11329;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__10371__auto__ = function(state_11319){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__10371__auto____1.call(this,state_11319);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__10371__auto____0;
cljs$core$async$transduce_$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__10371__auto____1;
return cljs$core$async$transduce_$_state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto__,f__$1))
})();
var state__10486__auto__ = (function (){var statearr_11327 = f__10485__auto__.call(null);
(statearr_11327[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto__);

return statearr_11327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto__,f__$1))
);

return c__10484__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args11330 = [];
var len__8628__auto___11382 = arguments.length;
var i__8629__auto___11383 = (0);
while(true){
if((i__8629__auto___11383 < len__8628__auto___11382)){
args11330.push((arguments[i__8629__auto___11383]));

var G__11384 = (i__8629__auto___11383 + (1));
i__8629__auto___11383 = G__11384;
continue;
} else {
}
break;
}

var G__11332 = args11330.length;
switch (G__11332) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11330.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__10484__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto__){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto__){
return (function (state_11357){
var state_val_11358 = (state_11357[(1)]);
if((state_val_11358 === (7))){
var inst_11339 = (state_11357[(2)]);
var state_11357__$1 = state_11357;
var statearr_11359_11386 = state_11357__$1;
(statearr_11359_11386[(2)] = inst_11339);

(statearr_11359_11386[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11358 === (1))){
var inst_11333 = cljs.core.seq.call(null,coll);
var inst_11334 = inst_11333;
var state_11357__$1 = (function (){var statearr_11360 = state_11357;
(statearr_11360[(7)] = inst_11334);

return statearr_11360;
})();
var statearr_11361_11387 = state_11357__$1;
(statearr_11361_11387[(2)] = null);

(statearr_11361_11387[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11358 === (4))){
var inst_11334 = (state_11357[(7)]);
var inst_11337 = cljs.core.first.call(null,inst_11334);
var state_11357__$1 = state_11357;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11357__$1,(7),ch,inst_11337);
} else {
if((state_val_11358 === (13))){
var inst_11351 = (state_11357[(2)]);
var state_11357__$1 = state_11357;
var statearr_11362_11388 = state_11357__$1;
(statearr_11362_11388[(2)] = inst_11351);

(statearr_11362_11388[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11358 === (6))){
var inst_11342 = (state_11357[(2)]);
var state_11357__$1 = state_11357;
if(cljs.core.truth_(inst_11342)){
var statearr_11363_11389 = state_11357__$1;
(statearr_11363_11389[(1)] = (8));

} else {
var statearr_11364_11390 = state_11357__$1;
(statearr_11364_11390[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11358 === (3))){
var inst_11355 = (state_11357[(2)]);
var state_11357__$1 = state_11357;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11357__$1,inst_11355);
} else {
if((state_val_11358 === (12))){
var state_11357__$1 = state_11357;
var statearr_11365_11391 = state_11357__$1;
(statearr_11365_11391[(2)] = null);

(statearr_11365_11391[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11358 === (2))){
var inst_11334 = (state_11357[(7)]);
var state_11357__$1 = state_11357;
if(cljs.core.truth_(inst_11334)){
var statearr_11366_11392 = state_11357__$1;
(statearr_11366_11392[(1)] = (4));

} else {
var statearr_11367_11393 = state_11357__$1;
(statearr_11367_11393[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11358 === (11))){
var inst_11348 = cljs.core.async.close_BANG_.call(null,ch);
var state_11357__$1 = state_11357;
var statearr_11368_11394 = state_11357__$1;
(statearr_11368_11394[(2)] = inst_11348);

(statearr_11368_11394[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11358 === (9))){
var state_11357__$1 = state_11357;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11369_11395 = state_11357__$1;
(statearr_11369_11395[(1)] = (11));

} else {
var statearr_11370_11396 = state_11357__$1;
(statearr_11370_11396[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11358 === (5))){
var inst_11334 = (state_11357[(7)]);
var state_11357__$1 = state_11357;
var statearr_11371_11397 = state_11357__$1;
(statearr_11371_11397[(2)] = inst_11334);

(statearr_11371_11397[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11358 === (10))){
var inst_11353 = (state_11357[(2)]);
var state_11357__$1 = state_11357;
var statearr_11372_11398 = state_11357__$1;
(statearr_11372_11398[(2)] = inst_11353);

(statearr_11372_11398[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11358 === (8))){
var inst_11334 = (state_11357[(7)]);
var inst_11344 = cljs.core.next.call(null,inst_11334);
var inst_11334__$1 = inst_11344;
var state_11357__$1 = (function (){var statearr_11373 = state_11357;
(statearr_11373[(7)] = inst_11334__$1);

return statearr_11373;
})();
var statearr_11374_11399 = state_11357__$1;
(statearr_11374_11399[(2)] = null);

(statearr_11374_11399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10484__auto__))
;
return ((function (switch__10370__auto__,c__10484__auto__){
return (function() {
var cljs$core$async$state_machine__10371__auto__ = null;
var cljs$core$async$state_machine__10371__auto____0 = (function (){
var statearr_11378 = [null,null,null,null,null,null,null,null];
(statearr_11378[(0)] = cljs$core$async$state_machine__10371__auto__);

(statearr_11378[(1)] = (1));

return statearr_11378;
});
var cljs$core$async$state_machine__10371__auto____1 = (function (state_11357){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_11357);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e11379){if((e11379 instanceof Object)){
var ex__10374__auto__ = e11379;
var statearr_11380_11400 = state_11357;
(statearr_11380_11400[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11357);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11379;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11401 = state_11357;
state_11357 = G__11401;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$state_machine__10371__auto__ = function(state_11357){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10371__auto____1.call(this,state_11357);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10371__auto____0;
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10371__auto____1;
return cljs$core$async$state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto__))
})();
var state__10486__auto__ = (function (){var statearr_11381 = f__10485__auto__.call(null);
(statearr_11381[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto__);

return statearr_11381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto__))
);

return c__10484__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__8125__auto__ = (((_ == null))?null:_);
var m__8126__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__8125__auto__)]);
if(!((m__8126__auto__ == null))){
return m__8126__auto__.call(null,_);
} else {
var m__8126__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__8126__auto____$1 == null))){
return m__8126__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__8125__auto__ = (((m == null))?null:m);
var m__8126__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__8125__auto__)]);
if(!((m__8126__auto__ == null))){
return m__8126__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__8126__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__8126__auto____$1 == null))){
return m__8126__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__8125__auto__ = (((m == null))?null:m);
var m__8126__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__8125__auto__)]);
if(!((m__8126__auto__ == null))){
return m__8126__auto__.call(null,m,ch);
} else {
var m__8126__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__8126__auto____$1 == null))){
return m__8126__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__8125__auto__ = (((m == null))?null:m);
var m__8126__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__8125__auto__)]);
if(!((m__8126__auto__ == null))){
return m__8126__auto__.call(null,m);
} else {
var m__8126__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__8126__auto____$1 == null))){
return m__8126__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async11627 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11627 = (function (ch,cs,meta11628){
this.ch = ch;
this.cs = cs;
this.meta11628 = meta11628;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11627.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_11629,meta11628__$1){
var self__ = this;
var _11629__$1 = this;
return (new cljs.core.async.t_cljs$core$async11627(self__.ch,self__.cs,meta11628__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async11627.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_11629){
var self__ = this;
var _11629__$1 = this;
return self__.meta11628;
});})(cs))
;

cljs.core.async.t_cljs$core$async11627.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async11627.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async11627.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async11627.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async11627.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async11627.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async11627.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta11628","meta11628",-1905251884,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async11627.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11627.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11627";

cljs.core.async.t_cljs$core$async11627.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__8064__auto__,writer__8065__auto__,opt__8066__auto__){
return cljs.core._write.call(null,writer__8065__auto__,"cljs.core.async/t_cljs$core$async11627");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async11627 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async11627(ch__$1,cs__$1,meta11628){
return (new cljs.core.async.t_cljs$core$async11627(ch__$1,cs__$1,meta11628));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async11627(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__10484__auto___11852 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto___11852,cs,m,dchan,dctr,done){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto___11852,cs,m,dchan,dctr,done){
return (function (state_11764){
var state_val_11765 = (state_11764[(1)]);
if((state_val_11765 === (7))){
var inst_11760 = (state_11764[(2)]);
var state_11764__$1 = state_11764;
var statearr_11766_11853 = state_11764__$1;
(statearr_11766_11853[(2)] = inst_11760);

(statearr_11766_11853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (20))){
var inst_11663 = (state_11764[(7)]);
var inst_11675 = cljs.core.first.call(null,inst_11663);
var inst_11676 = cljs.core.nth.call(null,inst_11675,(0),null);
var inst_11677 = cljs.core.nth.call(null,inst_11675,(1),null);
var state_11764__$1 = (function (){var statearr_11767 = state_11764;
(statearr_11767[(8)] = inst_11676);

return statearr_11767;
})();
if(cljs.core.truth_(inst_11677)){
var statearr_11768_11854 = state_11764__$1;
(statearr_11768_11854[(1)] = (22));

} else {
var statearr_11769_11855 = state_11764__$1;
(statearr_11769_11855[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (27))){
var inst_11705 = (state_11764[(9)]);
var inst_11712 = (state_11764[(10)]);
var inst_11632 = (state_11764[(11)]);
var inst_11707 = (state_11764[(12)]);
var inst_11712__$1 = cljs.core._nth.call(null,inst_11705,inst_11707);
var inst_11713 = cljs.core.async.put_BANG_.call(null,inst_11712__$1,inst_11632,done);
var state_11764__$1 = (function (){var statearr_11770 = state_11764;
(statearr_11770[(10)] = inst_11712__$1);

return statearr_11770;
})();
if(cljs.core.truth_(inst_11713)){
var statearr_11771_11856 = state_11764__$1;
(statearr_11771_11856[(1)] = (30));

} else {
var statearr_11772_11857 = state_11764__$1;
(statearr_11772_11857[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (1))){
var state_11764__$1 = state_11764;
var statearr_11773_11858 = state_11764__$1;
(statearr_11773_11858[(2)] = null);

(statearr_11773_11858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (24))){
var inst_11663 = (state_11764[(7)]);
var inst_11682 = (state_11764[(2)]);
var inst_11683 = cljs.core.next.call(null,inst_11663);
var inst_11641 = inst_11683;
var inst_11642 = null;
var inst_11643 = (0);
var inst_11644 = (0);
var state_11764__$1 = (function (){var statearr_11774 = state_11764;
(statearr_11774[(13)] = inst_11643);

(statearr_11774[(14)] = inst_11641);

(statearr_11774[(15)] = inst_11644);

(statearr_11774[(16)] = inst_11642);

(statearr_11774[(17)] = inst_11682);

return statearr_11774;
})();
var statearr_11775_11859 = state_11764__$1;
(statearr_11775_11859[(2)] = null);

(statearr_11775_11859[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (39))){
var state_11764__$1 = state_11764;
var statearr_11779_11860 = state_11764__$1;
(statearr_11779_11860[(2)] = null);

(statearr_11779_11860[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (4))){
var inst_11632 = (state_11764[(11)]);
var inst_11632__$1 = (state_11764[(2)]);
var inst_11633 = (inst_11632__$1 == null);
var state_11764__$1 = (function (){var statearr_11780 = state_11764;
(statearr_11780[(11)] = inst_11632__$1);

return statearr_11780;
})();
if(cljs.core.truth_(inst_11633)){
var statearr_11781_11861 = state_11764__$1;
(statearr_11781_11861[(1)] = (5));

} else {
var statearr_11782_11862 = state_11764__$1;
(statearr_11782_11862[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (15))){
var inst_11643 = (state_11764[(13)]);
var inst_11641 = (state_11764[(14)]);
var inst_11644 = (state_11764[(15)]);
var inst_11642 = (state_11764[(16)]);
var inst_11659 = (state_11764[(2)]);
var inst_11660 = (inst_11644 + (1));
var tmp11776 = inst_11643;
var tmp11777 = inst_11641;
var tmp11778 = inst_11642;
var inst_11641__$1 = tmp11777;
var inst_11642__$1 = tmp11778;
var inst_11643__$1 = tmp11776;
var inst_11644__$1 = inst_11660;
var state_11764__$1 = (function (){var statearr_11783 = state_11764;
(statearr_11783[(13)] = inst_11643__$1);

(statearr_11783[(14)] = inst_11641__$1);

(statearr_11783[(18)] = inst_11659);

(statearr_11783[(15)] = inst_11644__$1);

(statearr_11783[(16)] = inst_11642__$1);

return statearr_11783;
})();
var statearr_11784_11863 = state_11764__$1;
(statearr_11784_11863[(2)] = null);

(statearr_11784_11863[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (21))){
var inst_11686 = (state_11764[(2)]);
var state_11764__$1 = state_11764;
var statearr_11788_11864 = state_11764__$1;
(statearr_11788_11864[(2)] = inst_11686);

(statearr_11788_11864[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (31))){
var inst_11712 = (state_11764[(10)]);
var inst_11716 = done.call(null,null);
var inst_11717 = cljs.core.async.untap_STAR_.call(null,m,inst_11712);
var state_11764__$1 = (function (){var statearr_11789 = state_11764;
(statearr_11789[(19)] = inst_11716);

return statearr_11789;
})();
var statearr_11790_11865 = state_11764__$1;
(statearr_11790_11865[(2)] = inst_11717);

(statearr_11790_11865[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (32))){
var inst_11706 = (state_11764[(20)]);
var inst_11705 = (state_11764[(9)]);
var inst_11704 = (state_11764[(21)]);
var inst_11707 = (state_11764[(12)]);
var inst_11719 = (state_11764[(2)]);
var inst_11720 = (inst_11707 + (1));
var tmp11785 = inst_11706;
var tmp11786 = inst_11705;
var tmp11787 = inst_11704;
var inst_11704__$1 = tmp11787;
var inst_11705__$1 = tmp11786;
var inst_11706__$1 = tmp11785;
var inst_11707__$1 = inst_11720;
var state_11764__$1 = (function (){var statearr_11791 = state_11764;
(statearr_11791[(20)] = inst_11706__$1);

(statearr_11791[(9)] = inst_11705__$1);

(statearr_11791[(22)] = inst_11719);

(statearr_11791[(21)] = inst_11704__$1);

(statearr_11791[(12)] = inst_11707__$1);

return statearr_11791;
})();
var statearr_11792_11866 = state_11764__$1;
(statearr_11792_11866[(2)] = null);

(statearr_11792_11866[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (40))){
var inst_11732 = (state_11764[(23)]);
var inst_11736 = done.call(null,null);
var inst_11737 = cljs.core.async.untap_STAR_.call(null,m,inst_11732);
var state_11764__$1 = (function (){var statearr_11793 = state_11764;
(statearr_11793[(24)] = inst_11736);

return statearr_11793;
})();
var statearr_11794_11867 = state_11764__$1;
(statearr_11794_11867[(2)] = inst_11737);

(statearr_11794_11867[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (33))){
var inst_11723 = (state_11764[(25)]);
var inst_11725 = cljs.core.chunked_seq_QMARK_.call(null,inst_11723);
var state_11764__$1 = state_11764;
if(inst_11725){
var statearr_11795_11868 = state_11764__$1;
(statearr_11795_11868[(1)] = (36));

} else {
var statearr_11796_11869 = state_11764__$1;
(statearr_11796_11869[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (13))){
var inst_11653 = (state_11764[(26)]);
var inst_11656 = cljs.core.async.close_BANG_.call(null,inst_11653);
var state_11764__$1 = state_11764;
var statearr_11797_11870 = state_11764__$1;
(statearr_11797_11870[(2)] = inst_11656);

(statearr_11797_11870[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (22))){
var inst_11676 = (state_11764[(8)]);
var inst_11679 = cljs.core.async.close_BANG_.call(null,inst_11676);
var state_11764__$1 = state_11764;
var statearr_11798_11871 = state_11764__$1;
(statearr_11798_11871[(2)] = inst_11679);

(statearr_11798_11871[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (36))){
var inst_11723 = (state_11764[(25)]);
var inst_11727 = cljs.core.chunk_first.call(null,inst_11723);
var inst_11728 = cljs.core.chunk_rest.call(null,inst_11723);
var inst_11729 = cljs.core.count.call(null,inst_11727);
var inst_11704 = inst_11728;
var inst_11705 = inst_11727;
var inst_11706 = inst_11729;
var inst_11707 = (0);
var state_11764__$1 = (function (){var statearr_11799 = state_11764;
(statearr_11799[(20)] = inst_11706);

(statearr_11799[(9)] = inst_11705);

(statearr_11799[(21)] = inst_11704);

(statearr_11799[(12)] = inst_11707);

return statearr_11799;
})();
var statearr_11800_11872 = state_11764__$1;
(statearr_11800_11872[(2)] = null);

(statearr_11800_11872[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (41))){
var inst_11723 = (state_11764[(25)]);
var inst_11739 = (state_11764[(2)]);
var inst_11740 = cljs.core.next.call(null,inst_11723);
var inst_11704 = inst_11740;
var inst_11705 = null;
var inst_11706 = (0);
var inst_11707 = (0);
var state_11764__$1 = (function (){var statearr_11801 = state_11764;
(statearr_11801[(20)] = inst_11706);

(statearr_11801[(9)] = inst_11705);

(statearr_11801[(21)] = inst_11704);

(statearr_11801[(12)] = inst_11707);

(statearr_11801[(27)] = inst_11739);

return statearr_11801;
})();
var statearr_11802_11873 = state_11764__$1;
(statearr_11802_11873[(2)] = null);

(statearr_11802_11873[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (43))){
var state_11764__$1 = state_11764;
var statearr_11803_11874 = state_11764__$1;
(statearr_11803_11874[(2)] = null);

(statearr_11803_11874[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (29))){
var inst_11748 = (state_11764[(2)]);
var state_11764__$1 = state_11764;
var statearr_11804_11875 = state_11764__$1;
(statearr_11804_11875[(2)] = inst_11748);

(statearr_11804_11875[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (44))){
var inst_11757 = (state_11764[(2)]);
var state_11764__$1 = (function (){var statearr_11805 = state_11764;
(statearr_11805[(28)] = inst_11757);

return statearr_11805;
})();
var statearr_11806_11876 = state_11764__$1;
(statearr_11806_11876[(2)] = null);

(statearr_11806_11876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (6))){
var inst_11696 = (state_11764[(29)]);
var inst_11695 = cljs.core.deref.call(null,cs);
var inst_11696__$1 = cljs.core.keys.call(null,inst_11695);
var inst_11697 = cljs.core.count.call(null,inst_11696__$1);
var inst_11698 = cljs.core.reset_BANG_.call(null,dctr,inst_11697);
var inst_11703 = cljs.core.seq.call(null,inst_11696__$1);
var inst_11704 = inst_11703;
var inst_11705 = null;
var inst_11706 = (0);
var inst_11707 = (0);
var state_11764__$1 = (function (){var statearr_11807 = state_11764;
(statearr_11807[(30)] = inst_11698);

(statearr_11807[(20)] = inst_11706);

(statearr_11807[(9)] = inst_11705);

(statearr_11807[(21)] = inst_11704);

(statearr_11807[(12)] = inst_11707);

(statearr_11807[(29)] = inst_11696__$1);

return statearr_11807;
})();
var statearr_11808_11877 = state_11764__$1;
(statearr_11808_11877[(2)] = null);

(statearr_11808_11877[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (28))){
var inst_11723 = (state_11764[(25)]);
var inst_11704 = (state_11764[(21)]);
var inst_11723__$1 = cljs.core.seq.call(null,inst_11704);
var state_11764__$1 = (function (){var statearr_11809 = state_11764;
(statearr_11809[(25)] = inst_11723__$1);

return statearr_11809;
})();
if(inst_11723__$1){
var statearr_11810_11878 = state_11764__$1;
(statearr_11810_11878[(1)] = (33));

} else {
var statearr_11811_11879 = state_11764__$1;
(statearr_11811_11879[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (25))){
var inst_11706 = (state_11764[(20)]);
var inst_11707 = (state_11764[(12)]);
var inst_11709 = (inst_11707 < inst_11706);
var inst_11710 = inst_11709;
var state_11764__$1 = state_11764;
if(cljs.core.truth_(inst_11710)){
var statearr_11812_11880 = state_11764__$1;
(statearr_11812_11880[(1)] = (27));

} else {
var statearr_11813_11881 = state_11764__$1;
(statearr_11813_11881[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (34))){
var state_11764__$1 = state_11764;
var statearr_11814_11882 = state_11764__$1;
(statearr_11814_11882[(2)] = null);

(statearr_11814_11882[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (17))){
var state_11764__$1 = state_11764;
var statearr_11815_11883 = state_11764__$1;
(statearr_11815_11883[(2)] = null);

(statearr_11815_11883[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (3))){
var inst_11762 = (state_11764[(2)]);
var state_11764__$1 = state_11764;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11764__$1,inst_11762);
} else {
if((state_val_11765 === (12))){
var inst_11691 = (state_11764[(2)]);
var state_11764__$1 = state_11764;
var statearr_11816_11884 = state_11764__$1;
(statearr_11816_11884[(2)] = inst_11691);

(statearr_11816_11884[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (2))){
var state_11764__$1 = state_11764;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11764__$1,(4),ch);
} else {
if((state_val_11765 === (23))){
var state_11764__$1 = state_11764;
var statearr_11817_11885 = state_11764__$1;
(statearr_11817_11885[(2)] = null);

(statearr_11817_11885[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (35))){
var inst_11746 = (state_11764[(2)]);
var state_11764__$1 = state_11764;
var statearr_11818_11886 = state_11764__$1;
(statearr_11818_11886[(2)] = inst_11746);

(statearr_11818_11886[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (19))){
var inst_11663 = (state_11764[(7)]);
var inst_11667 = cljs.core.chunk_first.call(null,inst_11663);
var inst_11668 = cljs.core.chunk_rest.call(null,inst_11663);
var inst_11669 = cljs.core.count.call(null,inst_11667);
var inst_11641 = inst_11668;
var inst_11642 = inst_11667;
var inst_11643 = inst_11669;
var inst_11644 = (0);
var state_11764__$1 = (function (){var statearr_11819 = state_11764;
(statearr_11819[(13)] = inst_11643);

(statearr_11819[(14)] = inst_11641);

(statearr_11819[(15)] = inst_11644);

(statearr_11819[(16)] = inst_11642);

return statearr_11819;
})();
var statearr_11820_11887 = state_11764__$1;
(statearr_11820_11887[(2)] = null);

(statearr_11820_11887[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (11))){
var inst_11641 = (state_11764[(14)]);
var inst_11663 = (state_11764[(7)]);
var inst_11663__$1 = cljs.core.seq.call(null,inst_11641);
var state_11764__$1 = (function (){var statearr_11821 = state_11764;
(statearr_11821[(7)] = inst_11663__$1);

return statearr_11821;
})();
if(inst_11663__$1){
var statearr_11822_11888 = state_11764__$1;
(statearr_11822_11888[(1)] = (16));

} else {
var statearr_11823_11889 = state_11764__$1;
(statearr_11823_11889[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (9))){
var inst_11693 = (state_11764[(2)]);
var state_11764__$1 = state_11764;
var statearr_11824_11890 = state_11764__$1;
(statearr_11824_11890[(2)] = inst_11693);

(statearr_11824_11890[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (5))){
var inst_11639 = cljs.core.deref.call(null,cs);
var inst_11640 = cljs.core.seq.call(null,inst_11639);
var inst_11641 = inst_11640;
var inst_11642 = null;
var inst_11643 = (0);
var inst_11644 = (0);
var state_11764__$1 = (function (){var statearr_11825 = state_11764;
(statearr_11825[(13)] = inst_11643);

(statearr_11825[(14)] = inst_11641);

(statearr_11825[(15)] = inst_11644);

(statearr_11825[(16)] = inst_11642);

return statearr_11825;
})();
var statearr_11826_11891 = state_11764__$1;
(statearr_11826_11891[(2)] = null);

(statearr_11826_11891[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (14))){
var state_11764__$1 = state_11764;
var statearr_11827_11892 = state_11764__$1;
(statearr_11827_11892[(2)] = null);

(statearr_11827_11892[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (45))){
var inst_11754 = (state_11764[(2)]);
var state_11764__$1 = state_11764;
var statearr_11828_11893 = state_11764__$1;
(statearr_11828_11893[(2)] = inst_11754);

(statearr_11828_11893[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (26))){
var inst_11696 = (state_11764[(29)]);
var inst_11750 = (state_11764[(2)]);
var inst_11751 = cljs.core.seq.call(null,inst_11696);
var state_11764__$1 = (function (){var statearr_11829 = state_11764;
(statearr_11829[(31)] = inst_11750);

return statearr_11829;
})();
if(inst_11751){
var statearr_11830_11894 = state_11764__$1;
(statearr_11830_11894[(1)] = (42));

} else {
var statearr_11831_11895 = state_11764__$1;
(statearr_11831_11895[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (16))){
var inst_11663 = (state_11764[(7)]);
var inst_11665 = cljs.core.chunked_seq_QMARK_.call(null,inst_11663);
var state_11764__$1 = state_11764;
if(inst_11665){
var statearr_11832_11896 = state_11764__$1;
(statearr_11832_11896[(1)] = (19));

} else {
var statearr_11833_11897 = state_11764__$1;
(statearr_11833_11897[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (38))){
var inst_11743 = (state_11764[(2)]);
var state_11764__$1 = state_11764;
var statearr_11834_11898 = state_11764__$1;
(statearr_11834_11898[(2)] = inst_11743);

(statearr_11834_11898[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (30))){
var state_11764__$1 = state_11764;
var statearr_11835_11899 = state_11764__$1;
(statearr_11835_11899[(2)] = null);

(statearr_11835_11899[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (10))){
var inst_11644 = (state_11764[(15)]);
var inst_11642 = (state_11764[(16)]);
var inst_11652 = cljs.core._nth.call(null,inst_11642,inst_11644);
var inst_11653 = cljs.core.nth.call(null,inst_11652,(0),null);
var inst_11654 = cljs.core.nth.call(null,inst_11652,(1),null);
var state_11764__$1 = (function (){var statearr_11836 = state_11764;
(statearr_11836[(26)] = inst_11653);

return statearr_11836;
})();
if(cljs.core.truth_(inst_11654)){
var statearr_11837_11900 = state_11764__$1;
(statearr_11837_11900[(1)] = (13));

} else {
var statearr_11838_11901 = state_11764__$1;
(statearr_11838_11901[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (18))){
var inst_11689 = (state_11764[(2)]);
var state_11764__$1 = state_11764;
var statearr_11839_11902 = state_11764__$1;
(statearr_11839_11902[(2)] = inst_11689);

(statearr_11839_11902[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (42))){
var state_11764__$1 = state_11764;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11764__$1,(45),dchan);
} else {
if((state_val_11765 === (37))){
var inst_11723 = (state_11764[(25)]);
var inst_11732 = (state_11764[(23)]);
var inst_11632 = (state_11764[(11)]);
var inst_11732__$1 = cljs.core.first.call(null,inst_11723);
var inst_11733 = cljs.core.async.put_BANG_.call(null,inst_11732__$1,inst_11632,done);
var state_11764__$1 = (function (){var statearr_11840 = state_11764;
(statearr_11840[(23)] = inst_11732__$1);

return statearr_11840;
})();
if(cljs.core.truth_(inst_11733)){
var statearr_11841_11903 = state_11764__$1;
(statearr_11841_11903[(1)] = (39));

} else {
var statearr_11842_11904 = state_11764__$1;
(statearr_11842_11904[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11765 === (8))){
var inst_11643 = (state_11764[(13)]);
var inst_11644 = (state_11764[(15)]);
var inst_11646 = (inst_11644 < inst_11643);
var inst_11647 = inst_11646;
var state_11764__$1 = state_11764;
if(cljs.core.truth_(inst_11647)){
var statearr_11843_11905 = state_11764__$1;
(statearr_11843_11905[(1)] = (10));

} else {
var statearr_11844_11906 = state_11764__$1;
(statearr_11844_11906[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10484__auto___11852,cs,m,dchan,dctr,done))
;
return ((function (switch__10370__auto__,c__10484__auto___11852,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__10371__auto__ = null;
var cljs$core$async$mult_$_state_machine__10371__auto____0 = (function (){
var statearr_11848 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11848[(0)] = cljs$core$async$mult_$_state_machine__10371__auto__);

(statearr_11848[(1)] = (1));

return statearr_11848;
});
var cljs$core$async$mult_$_state_machine__10371__auto____1 = (function (state_11764){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_11764);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e11849){if((e11849 instanceof Object)){
var ex__10374__auto__ = e11849;
var statearr_11850_11907 = state_11764;
(statearr_11850_11907[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11764);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11849;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11908 = state_11764;
state_11764 = G__11908;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10371__auto__ = function(state_11764){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10371__auto____1.call(this,state_11764);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10371__auto____0;
cljs$core$async$mult_$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10371__auto____1;
return cljs$core$async$mult_$_state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto___11852,cs,m,dchan,dctr,done))
})();
var state__10486__auto__ = (function (){var statearr_11851 = f__10485__auto__.call(null);
(statearr_11851[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto___11852);

return statearr_11851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto___11852,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args11909 = [];
var len__8628__auto___11912 = arguments.length;
var i__8629__auto___11913 = (0);
while(true){
if((i__8629__auto___11913 < len__8628__auto___11912)){
args11909.push((arguments[i__8629__auto___11913]));

var G__11914 = (i__8629__auto___11913 + (1));
i__8629__auto___11913 = G__11914;
continue;
} else {
}
break;
}

var G__11911 = args11909.length;
switch (G__11911) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11909.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__8125__auto__ = (((m == null))?null:m);
var m__8126__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__8125__auto__)]);
if(!((m__8126__auto__ == null))){
return m__8126__auto__.call(null,m,ch);
} else {
var m__8126__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__8126__auto____$1 == null))){
return m__8126__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__8125__auto__ = (((m == null))?null:m);
var m__8126__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__8125__auto__)]);
if(!((m__8126__auto__ == null))){
return m__8126__auto__.call(null,m,ch);
} else {
var m__8126__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__8126__auto____$1 == null))){
return m__8126__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__8125__auto__ = (((m == null))?null:m);
var m__8126__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__8125__auto__)]);
if(!((m__8126__auto__ == null))){
return m__8126__auto__.call(null,m);
} else {
var m__8126__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__8126__auto____$1 == null))){
return m__8126__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__8125__auto__ = (((m == null))?null:m);
var m__8126__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__8125__auto__)]);
if(!((m__8126__auto__ == null))){
return m__8126__auto__.call(null,m,state_map);
} else {
var m__8126__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__8126__auto____$1 == null))){
return m__8126__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__8125__auto__ = (((m == null))?null:m);
var m__8126__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__8125__auto__)]);
if(!((m__8126__auto__ == null))){
return m__8126__auto__.call(null,m,mode);
} else {
var m__8126__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__8126__auto____$1 == null))){
return m__8126__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__8635__auto__ = [];
var len__8628__auto___11926 = arguments.length;
var i__8629__auto___11927 = (0);
while(true){
if((i__8629__auto___11927 < len__8628__auto___11926)){
args__8635__auto__.push((arguments[i__8629__auto___11927]));

var G__11928 = (i__8629__auto___11927 + (1));
i__8629__auto___11927 = G__11928;
continue;
} else {
}
break;
}

var argseq__8636__auto__ = ((((3) < args__8635__auto__.length))?(new cljs.core.IndexedSeq(args__8635__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8636__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__11920){
var map__11921 = p__11920;
var map__11921__$1 = ((((!((map__11921 == null)))?((((map__11921.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11921.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11921):map__11921);
var opts = map__11921__$1;
var statearr_11923_11929 = state;
(statearr_11923_11929[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__5278__auto__ = cljs.core.async.do_alts.call(null,((function (map__11921,map__11921__$1,opts){
return (function (val){
var statearr_11924_11930 = state;
(statearr_11924_11930[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__11921,map__11921__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5278__auto__)){
var cb = temp__5278__auto__;
var statearr_11925_11931 = state;
(statearr_11925_11931[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq11916){
var G__11917 = cljs.core.first.call(null,seq11916);
var seq11916__$1 = cljs.core.next.call(null,seq11916);
var G__11918 = cljs.core.first.call(null,seq11916__$1);
var seq11916__$2 = cljs.core.next.call(null,seq11916__$1);
var G__11919 = cljs.core.first.call(null,seq11916__$2);
var seq11916__$3 = cljs.core.next.call(null,seq11916__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11917,G__11918,G__11919,seq11916__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12099 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12099 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta12100){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta12100 = meta12100;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12099.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12101,meta12100__$1){
var self__ = this;
var _12101__$1 = this;
return (new cljs.core.async.t_cljs$core$async12099(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta12100__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12099.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12101){
var self__ = this;
var _12101__$1 = this;
return self__.meta12100;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12099.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12099.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12099.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12099.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12099.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12099.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12099.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12099.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12099.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta12100","meta12100",1287286001,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12099.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12099.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12099";

cljs.core.async.t_cljs$core$async12099.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__8064__auto__,writer__8065__auto__,opt__8066__auto__){
return cljs.core._write.call(null,writer__8065__auto__,"cljs.core.async/t_cljs$core$async12099");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async12099 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async12099(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta12100){
return (new cljs.core.async.t_cljs$core$async12099(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta12100));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async12099(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__10484__auto___12266 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto___12266,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto___12266,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_12203){
var state_val_12204 = (state_12203[(1)]);
if((state_val_12204 === (7))){
var inst_12118 = (state_12203[(2)]);
var state_12203__$1 = state_12203;
var statearr_12205_12267 = state_12203__$1;
(statearr_12205_12267[(2)] = inst_12118);

(statearr_12205_12267[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (20))){
var inst_12130 = (state_12203[(7)]);
var state_12203__$1 = state_12203;
var statearr_12206_12268 = state_12203__$1;
(statearr_12206_12268[(2)] = inst_12130);

(statearr_12206_12268[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (27))){
var state_12203__$1 = state_12203;
var statearr_12207_12269 = state_12203__$1;
(statearr_12207_12269[(2)] = null);

(statearr_12207_12269[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (1))){
var inst_12105 = (state_12203[(8)]);
var inst_12105__$1 = calc_state.call(null);
var inst_12107 = (inst_12105__$1 == null);
var inst_12108 = cljs.core.not.call(null,inst_12107);
var state_12203__$1 = (function (){var statearr_12208 = state_12203;
(statearr_12208[(8)] = inst_12105__$1);

return statearr_12208;
})();
if(inst_12108){
var statearr_12209_12270 = state_12203__$1;
(statearr_12209_12270[(1)] = (2));

} else {
var statearr_12210_12271 = state_12203__$1;
(statearr_12210_12271[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (24))){
var inst_12154 = (state_12203[(9)]);
var inst_12177 = (state_12203[(10)]);
var inst_12163 = (state_12203[(11)]);
var inst_12177__$1 = inst_12154.call(null,inst_12163);
var state_12203__$1 = (function (){var statearr_12211 = state_12203;
(statearr_12211[(10)] = inst_12177__$1);

return statearr_12211;
})();
if(cljs.core.truth_(inst_12177__$1)){
var statearr_12212_12272 = state_12203__$1;
(statearr_12212_12272[(1)] = (29));

} else {
var statearr_12213_12273 = state_12203__$1;
(statearr_12213_12273[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (4))){
var inst_12121 = (state_12203[(2)]);
var state_12203__$1 = state_12203;
if(cljs.core.truth_(inst_12121)){
var statearr_12214_12274 = state_12203__$1;
(statearr_12214_12274[(1)] = (8));

} else {
var statearr_12215_12275 = state_12203__$1;
(statearr_12215_12275[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (15))){
var inst_12148 = (state_12203[(2)]);
var state_12203__$1 = state_12203;
if(cljs.core.truth_(inst_12148)){
var statearr_12216_12276 = state_12203__$1;
(statearr_12216_12276[(1)] = (19));

} else {
var statearr_12217_12277 = state_12203__$1;
(statearr_12217_12277[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (21))){
var inst_12153 = (state_12203[(12)]);
var inst_12153__$1 = (state_12203[(2)]);
var inst_12154 = cljs.core.get.call(null,inst_12153__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12155 = cljs.core.get.call(null,inst_12153__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12156 = cljs.core.get.call(null,inst_12153__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12203__$1 = (function (){var statearr_12218 = state_12203;
(statearr_12218[(9)] = inst_12154);

(statearr_12218[(12)] = inst_12153__$1);

(statearr_12218[(13)] = inst_12155);

return statearr_12218;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_12203__$1,(22),inst_12156);
} else {
if((state_val_12204 === (31))){
var inst_12185 = (state_12203[(2)]);
var state_12203__$1 = state_12203;
if(cljs.core.truth_(inst_12185)){
var statearr_12219_12278 = state_12203__$1;
(statearr_12219_12278[(1)] = (32));

} else {
var statearr_12220_12279 = state_12203__$1;
(statearr_12220_12279[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (32))){
var inst_12162 = (state_12203[(14)]);
var state_12203__$1 = state_12203;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12203__$1,(35),out,inst_12162);
} else {
if((state_val_12204 === (33))){
var inst_12153 = (state_12203[(12)]);
var inst_12130 = inst_12153;
var state_12203__$1 = (function (){var statearr_12221 = state_12203;
(statearr_12221[(7)] = inst_12130);

return statearr_12221;
})();
var statearr_12222_12280 = state_12203__$1;
(statearr_12222_12280[(2)] = null);

(statearr_12222_12280[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (13))){
var inst_12130 = (state_12203[(7)]);
var inst_12137 = inst_12130.cljs$lang$protocol_mask$partition0$;
var inst_12138 = (inst_12137 & (64));
var inst_12139 = inst_12130.cljs$core$ISeq$;
var inst_12140 = (cljs.core.PROTOCOL_SENTINEL === inst_12139);
var inst_12141 = (inst_12138) || (inst_12140);
var state_12203__$1 = state_12203;
if(cljs.core.truth_(inst_12141)){
var statearr_12223_12281 = state_12203__$1;
(statearr_12223_12281[(1)] = (16));

} else {
var statearr_12224_12282 = state_12203__$1;
(statearr_12224_12282[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (22))){
var inst_12163 = (state_12203[(11)]);
var inst_12162 = (state_12203[(14)]);
var inst_12161 = (state_12203[(2)]);
var inst_12162__$1 = cljs.core.nth.call(null,inst_12161,(0),null);
var inst_12163__$1 = cljs.core.nth.call(null,inst_12161,(1),null);
var inst_12164 = (inst_12162__$1 == null);
var inst_12165 = cljs.core._EQ_.call(null,inst_12163__$1,change);
var inst_12166 = (inst_12164) || (inst_12165);
var state_12203__$1 = (function (){var statearr_12225 = state_12203;
(statearr_12225[(11)] = inst_12163__$1);

(statearr_12225[(14)] = inst_12162__$1);

return statearr_12225;
})();
if(cljs.core.truth_(inst_12166)){
var statearr_12226_12283 = state_12203__$1;
(statearr_12226_12283[(1)] = (23));

} else {
var statearr_12227_12284 = state_12203__$1;
(statearr_12227_12284[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (36))){
var inst_12153 = (state_12203[(12)]);
var inst_12130 = inst_12153;
var state_12203__$1 = (function (){var statearr_12228 = state_12203;
(statearr_12228[(7)] = inst_12130);

return statearr_12228;
})();
var statearr_12229_12285 = state_12203__$1;
(statearr_12229_12285[(2)] = null);

(statearr_12229_12285[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (29))){
var inst_12177 = (state_12203[(10)]);
var state_12203__$1 = state_12203;
var statearr_12230_12286 = state_12203__$1;
(statearr_12230_12286[(2)] = inst_12177);

(statearr_12230_12286[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (6))){
var state_12203__$1 = state_12203;
var statearr_12231_12287 = state_12203__$1;
(statearr_12231_12287[(2)] = false);

(statearr_12231_12287[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (28))){
var inst_12173 = (state_12203[(2)]);
var inst_12174 = calc_state.call(null);
var inst_12130 = inst_12174;
var state_12203__$1 = (function (){var statearr_12232 = state_12203;
(statearr_12232[(15)] = inst_12173);

(statearr_12232[(7)] = inst_12130);

return statearr_12232;
})();
var statearr_12233_12288 = state_12203__$1;
(statearr_12233_12288[(2)] = null);

(statearr_12233_12288[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (25))){
var inst_12199 = (state_12203[(2)]);
var state_12203__$1 = state_12203;
var statearr_12234_12289 = state_12203__$1;
(statearr_12234_12289[(2)] = inst_12199);

(statearr_12234_12289[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (34))){
var inst_12197 = (state_12203[(2)]);
var state_12203__$1 = state_12203;
var statearr_12235_12290 = state_12203__$1;
(statearr_12235_12290[(2)] = inst_12197);

(statearr_12235_12290[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (17))){
var state_12203__$1 = state_12203;
var statearr_12236_12291 = state_12203__$1;
(statearr_12236_12291[(2)] = false);

(statearr_12236_12291[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (3))){
var state_12203__$1 = state_12203;
var statearr_12237_12292 = state_12203__$1;
(statearr_12237_12292[(2)] = false);

(statearr_12237_12292[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (12))){
var inst_12201 = (state_12203[(2)]);
var state_12203__$1 = state_12203;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12203__$1,inst_12201);
} else {
if((state_val_12204 === (2))){
var inst_12105 = (state_12203[(8)]);
var inst_12110 = inst_12105.cljs$lang$protocol_mask$partition0$;
var inst_12111 = (inst_12110 & (64));
var inst_12112 = inst_12105.cljs$core$ISeq$;
var inst_12113 = (cljs.core.PROTOCOL_SENTINEL === inst_12112);
var inst_12114 = (inst_12111) || (inst_12113);
var state_12203__$1 = state_12203;
if(cljs.core.truth_(inst_12114)){
var statearr_12238_12293 = state_12203__$1;
(statearr_12238_12293[(1)] = (5));

} else {
var statearr_12239_12294 = state_12203__$1;
(statearr_12239_12294[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (23))){
var inst_12162 = (state_12203[(14)]);
var inst_12168 = (inst_12162 == null);
var state_12203__$1 = state_12203;
if(cljs.core.truth_(inst_12168)){
var statearr_12240_12295 = state_12203__$1;
(statearr_12240_12295[(1)] = (26));

} else {
var statearr_12241_12296 = state_12203__$1;
(statearr_12241_12296[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (35))){
var inst_12188 = (state_12203[(2)]);
var state_12203__$1 = state_12203;
if(cljs.core.truth_(inst_12188)){
var statearr_12242_12297 = state_12203__$1;
(statearr_12242_12297[(1)] = (36));

} else {
var statearr_12243_12298 = state_12203__$1;
(statearr_12243_12298[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (19))){
var inst_12130 = (state_12203[(7)]);
var inst_12150 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12130);
var state_12203__$1 = state_12203;
var statearr_12244_12299 = state_12203__$1;
(statearr_12244_12299[(2)] = inst_12150);

(statearr_12244_12299[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (11))){
var inst_12130 = (state_12203[(7)]);
var inst_12134 = (inst_12130 == null);
var inst_12135 = cljs.core.not.call(null,inst_12134);
var state_12203__$1 = state_12203;
if(inst_12135){
var statearr_12245_12300 = state_12203__$1;
(statearr_12245_12300[(1)] = (13));

} else {
var statearr_12246_12301 = state_12203__$1;
(statearr_12246_12301[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (9))){
var inst_12105 = (state_12203[(8)]);
var state_12203__$1 = state_12203;
var statearr_12247_12302 = state_12203__$1;
(statearr_12247_12302[(2)] = inst_12105);

(statearr_12247_12302[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (5))){
var state_12203__$1 = state_12203;
var statearr_12248_12303 = state_12203__$1;
(statearr_12248_12303[(2)] = true);

(statearr_12248_12303[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (14))){
var state_12203__$1 = state_12203;
var statearr_12249_12304 = state_12203__$1;
(statearr_12249_12304[(2)] = false);

(statearr_12249_12304[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (26))){
var inst_12163 = (state_12203[(11)]);
var inst_12170 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_12163);
var state_12203__$1 = state_12203;
var statearr_12250_12305 = state_12203__$1;
(statearr_12250_12305[(2)] = inst_12170);

(statearr_12250_12305[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (16))){
var state_12203__$1 = state_12203;
var statearr_12251_12306 = state_12203__$1;
(statearr_12251_12306[(2)] = true);

(statearr_12251_12306[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (38))){
var inst_12193 = (state_12203[(2)]);
var state_12203__$1 = state_12203;
var statearr_12252_12307 = state_12203__$1;
(statearr_12252_12307[(2)] = inst_12193);

(statearr_12252_12307[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (30))){
var inst_12154 = (state_12203[(9)]);
var inst_12155 = (state_12203[(13)]);
var inst_12163 = (state_12203[(11)]);
var inst_12180 = cljs.core.empty_QMARK_.call(null,inst_12154);
var inst_12181 = inst_12155.call(null,inst_12163);
var inst_12182 = cljs.core.not.call(null,inst_12181);
var inst_12183 = (inst_12180) && (inst_12182);
var state_12203__$1 = state_12203;
var statearr_12253_12308 = state_12203__$1;
(statearr_12253_12308[(2)] = inst_12183);

(statearr_12253_12308[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (10))){
var inst_12105 = (state_12203[(8)]);
var inst_12126 = (state_12203[(2)]);
var inst_12127 = cljs.core.get.call(null,inst_12126,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12128 = cljs.core.get.call(null,inst_12126,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12129 = cljs.core.get.call(null,inst_12126,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12130 = inst_12105;
var state_12203__$1 = (function (){var statearr_12254 = state_12203;
(statearr_12254[(16)] = inst_12128);

(statearr_12254[(17)] = inst_12129);

(statearr_12254[(7)] = inst_12130);

(statearr_12254[(18)] = inst_12127);

return statearr_12254;
})();
var statearr_12255_12309 = state_12203__$1;
(statearr_12255_12309[(2)] = null);

(statearr_12255_12309[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (18))){
var inst_12145 = (state_12203[(2)]);
var state_12203__$1 = state_12203;
var statearr_12256_12310 = state_12203__$1;
(statearr_12256_12310[(2)] = inst_12145);

(statearr_12256_12310[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (37))){
var state_12203__$1 = state_12203;
var statearr_12257_12311 = state_12203__$1;
(statearr_12257_12311[(2)] = null);

(statearr_12257_12311[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12204 === (8))){
var inst_12105 = (state_12203[(8)]);
var inst_12123 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12105);
var state_12203__$1 = state_12203;
var statearr_12258_12312 = state_12203__$1;
(statearr_12258_12312[(2)] = inst_12123);

(statearr_12258_12312[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10484__auto___12266,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__10370__auto__,c__10484__auto___12266,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__10371__auto__ = null;
var cljs$core$async$mix_$_state_machine__10371__auto____0 = (function (){
var statearr_12262 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12262[(0)] = cljs$core$async$mix_$_state_machine__10371__auto__);

(statearr_12262[(1)] = (1));

return statearr_12262;
});
var cljs$core$async$mix_$_state_machine__10371__auto____1 = (function (state_12203){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_12203);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e12263){if((e12263 instanceof Object)){
var ex__10374__auto__ = e12263;
var statearr_12264_12313 = state_12203;
(statearr_12264_12313[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12203);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12263;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12314 = state_12203;
state_12203 = G__12314;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10371__auto__ = function(state_12203){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10371__auto____1.call(this,state_12203);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10371__auto____0;
cljs$core$async$mix_$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10371__auto____1;
return cljs$core$async$mix_$_state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto___12266,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__10486__auto__ = (function (){var statearr_12265 = f__10485__auto__.call(null);
(statearr_12265[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto___12266);

return statearr_12265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto___12266,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__8125__auto__ = (((p == null))?null:p);
var m__8126__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__8125__auto__)]);
if(!((m__8126__auto__ == null))){
return m__8126__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__8126__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__8126__auto____$1 == null))){
return m__8126__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__8125__auto__ = (((p == null))?null:p);
var m__8126__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__8125__auto__)]);
if(!((m__8126__auto__ == null))){
return m__8126__auto__.call(null,p,v,ch);
} else {
var m__8126__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__8126__auto____$1 == null))){
return m__8126__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args12315 = [];
var len__8628__auto___12318 = arguments.length;
var i__8629__auto___12319 = (0);
while(true){
if((i__8629__auto___12319 < len__8628__auto___12318)){
args12315.push((arguments[i__8629__auto___12319]));

var G__12320 = (i__8629__auto___12319 + (1));
i__8629__auto___12319 = G__12320;
continue;
} else {
}
break;
}

var G__12317 = args12315.length;
switch (G__12317) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12315.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__8125__auto__ = (((p == null))?null:p);
var m__8126__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8125__auto__)]);
if(!((m__8126__auto__ == null))){
return m__8126__auto__.call(null,p);
} else {
var m__8126__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8126__auto____$1 == null))){
return m__8126__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__8125__auto__ = (((p == null))?null:p);
var m__8126__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8125__auto__)]);
if(!((m__8126__auto__ == null))){
return m__8126__auto__.call(null,p,v);
} else {
var m__8126__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8126__auto____$1 == null))){
return m__8126__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args12323 = [];
var len__8628__auto___12448 = arguments.length;
var i__8629__auto___12449 = (0);
while(true){
if((i__8629__auto___12449 < len__8628__auto___12448)){
args12323.push((arguments[i__8629__auto___12449]));

var G__12450 = (i__8629__auto___12449 + (1));
i__8629__auto___12449 = G__12450;
continue;
} else {
}
break;
}

var G__12325 = args12323.length;
switch (G__12325) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12323.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__7407__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__7407__auto__,mults){
return (function (p1__12322_SHARP_){
if(cljs.core.truth_(p1__12322_SHARP_.call(null,topic))){
return p1__12322_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12322_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__7407__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async12326 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12326 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12327){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12327 = meta12327;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12326.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_12328,meta12327__$1){
var self__ = this;
var _12328__$1 = this;
return (new cljs.core.async.t_cljs$core$async12326(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12327__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12326.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_12328){
var self__ = this;
var _12328__$1 = this;
return self__.meta12327;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12326.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12326.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12326.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12326.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12326.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5278__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5278__auto__)){
var m = temp__5278__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12326.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12326.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12326.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12327","meta12327",-1215025459,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12326.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12326.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12326";

cljs.core.async.t_cljs$core$async12326.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__8064__auto__,writer__8065__auto__,opt__8066__auto__){
return cljs.core._write.call(null,writer__8065__auto__,"cljs.core.async/t_cljs$core$async12326");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async12326 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async12326(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12327){
return (new cljs.core.async.t_cljs$core$async12326(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12327));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async12326(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__10484__auto___12452 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto___12452,mults,ensure_mult,p){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto___12452,mults,ensure_mult,p){
return (function (state_12400){
var state_val_12401 = (state_12400[(1)]);
if((state_val_12401 === (7))){
var inst_12396 = (state_12400[(2)]);
var state_12400__$1 = state_12400;
var statearr_12402_12453 = state_12400__$1;
(statearr_12402_12453[(2)] = inst_12396);

(statearr_12402_12453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (20))){
var state_12400__$1 = state_12400;
var statearr_12403_12454 = state_12400__$1;
(statearr_12403_12454[(2)] = null);

(statearr_12403_12454[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (1))){
var state_12400__$1 = state_12400;
var statearr_12404_12455 = state_12400__$1;
(statearr_12404_12455[(2)] = null);

(statearr_12404_12455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (24))){
var inst_12379 = (state_12400[(7)]);
var inst_12388 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12379);
var state_12400__$1 = state_12400;
var statearr_12405_12456 = state_12400__$1;
(statearr_12405_12456[(2)] = inst_12388);

(statearr_12405_12456[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (4))){
var inst_12331 = (state_12400[(8)]);
var inst_12331__$1 = (state_12400[(2)]);
var inst_12332 = (inst_12331__$1 == null);
var state_12400__$1 = (function (){var statearr_12406 = state_12400;
(statearr_12406[(8)] = inst_12331__$1);

return statearr_12406;
})();
if(cljs.core.truth_(inst_12332)){
var statearr_12407_12457 = state_12400__$1;
(statearr_12407_12457[(1)] = (5));

} else {
var statearr_12408_12458 = state_12400__$1;
(statearr_12408_12458[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (15))){
var inst_12373 = (state_12400[(2)]);
var state_12400__$1 = state_12400;
var statearr_12409_12459 = state_12400__$1;
(statearr_12409_12459[(2)] = inst_12373);

(statearr_12409_12459[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (21))){
var inst_12393 = (state_12400[(2)]);
var state_12400__$1 = (function (){var statearr_12410 = state_12400;
(statearr_12410[(9)] = inst_12393);

return statearr_12410;
})();
var statearr_12411_12460 = state_12400__$1;
(statearr_12411_12460[(2)] = null);

(statearr_12411_12460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (13))){
var inst_12355 = (state_12400[(10)]);
var inst_12357 = cljs.core.chunked_seq_QMARK_.call(null,inst_12355);
var state_12400__$1 = state_12400;
if(inst_12357){
var statearr_12412_12461 = state_12400__$1;
(statearr_12412_12461[(1)] = (16));

} else {
var statearr_12413_12462 = state_12400__$1;
(statearr_12413_12462[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (22))){
var inst_12385 = (state_12400[(2)]);
var state_12400__$1 = state_12400;
if(cljs.core.truth_(inst_12385)){
var statearr_12414_12463 = state_12400__$1;
(statearr_12414_12463[(1)] = (23));

} else {
var statearr_12415_12464 = state_12400__$1;
(statearr_12415_12464[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (6))){
var inst_12379 = (state_12400[(7)]);
var inst_12381 = (state_12400[(11)]);
var inst_12331 = (state_12400[(8)]);
var inst_12379__$1 = topic_fn.call(null,inst_12331);
var inst_12380 = cljs.core.deref.call(null,mults);
var inst_12381__$1 = cljs.core.get.call(null,inst_12380,inst_12379__$1);
var state_12400__$1 = (function (){var statearr_12416 = state_12400;
(statearr_12416[(7)] = inst_12379__$1);

(statearr_12416[(11)] = inst_12381__$1);

return statearr_12416;
})();
if(cljs.core.truth_(inst_12381__$1)){
var statearr_12417_12465 = state_12400__$1;
(statearr_12417_12465[(1)] = (19));

} else {
var statearr_12418_12466 = state_12400__$1;
(statearr_12418_12466[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (25))){
var inst_12390 = (state_12400[(2)]);
var state_12400__$1 = state_12400;
var statearr_12419_12467 = state_12400__$1;
(statearr_12419_12467[(2)] = inst_12390);

(statearr_12419_12467[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (17))){
var inst_12355 = (state_12400[(10)]);
var inst_12364 = cljs.core.first.call(null,inst_12355);
var inst_12365 = cljs.core.async.muxch_STAR_.call(null,inst_12364);
var inst_12366 = cljs.core.async.close_BANG_.call(null,inst_12365);
var inst_12367 = cljs.core.next.call(null,inst_12355);
var inst_12341 = inst_12367;
var inst_12342 = null;
var inst_12343 = (0);
var inst_12344 = (0);
var state_12400__$1 = (function (){var statearr_12420 = state_12400;
(statearr_12420[(12)] = inst_12343);

(statearr_12420[(13)] = inst_12342);

(statearr_12420[(14)] = inst_12366);

(statearr_12420[(15)] = inst_12344);

(statearr_12420[(16)] = inst_12341);

return statearr_12420;
})();
var statearr_12421_12468 = state_12400__$1;
(statearr_12421_12468[(2)] = null);

(statearr_12421_12468[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (3))){
var inst_12398 = (state_12400[(2)]);
var state_12400__$1 = state_12400;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12400__$1,inst_12398);
} else {
if((state_val_12401 === (12))){
var inst_12375 = (state_12400[(2)]);
var state_12400__$1 = state_12400;
var statearr_12422_12469 = state_12400__$1;
(statearr_12422_12469[(2)] = inst_12375);

(statearr_12422_12469[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (2))){
var state_12400__$1 = state_12400;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12400__$1,(4),ch);
} else {
if((state_val_12401 === (23))){
var state_12400__$1 = state_12400;
var statearr_12423_12470 = state_12400__$1;
(statearr_12423_12470[(2)] = null);

(statearr_12423_12470[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (19))){
var inst_12381 = (state_12400[(11)]);
var inst_12331 = (state_12400[(8)]);
var inst_12383 = cljs.core.async.muxch_STAR_.call(null,inst_12381);
var state_12400__$1 = state_12400;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12400__$1,(22),inst_12383,inst_12331);
} else {
if((state_val_12401 === (11))){
var inst_12355 = (state_12400[(10)]);
var inst_12341 = (state_12400[(16)]);
var inst_12355__$1 = cljs.core.seq.call(null,inst_12341);
var state_12400__$1 = (function (){var statearr_12424 = state_12400;
(statearr_12424[(10)] = inst_12355__$1);

return statearr_12424;
})();
if(inst_12355__$1){
var statearr_12425_12471 = state_12400__$1;
(statearr_12425_12471[(1)] = (13));

} else {
var statearr_12426_12472 = state_12400__$1;
(statearr_12426_12472[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (9))){
var inst_12377 = (state_12400[(2)]);
var state_12400__$1 = state_12400;
var statearr_12427_12473 = state_12400__$1;
(statearr_12427_12473[(2)] = inst_12377);

(statearr_12427_12473[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (5))){
var inst_12338 = cljs.core.deref.call(null,mults);
var inst_12339 = cljs.core.vals.call(null,inst_12338);
var inst_12340 = cljs.core.seq.call(null,inst_12339);
var inst_12341 = inst_12340;
var inst_12342 = null;
var inst_12343 = (0);
var inst_12344 = (0);
var state_12400__$1 = (function (){var statearr_12428 = state_12400;
(statearr_12428[(12)] = inst_12343);

(statearr_12428[(13)] = inst_12342);

(statearr_12428[(15)] = inst_12344);

(statearr_12428[(16)] = inst_12341);

return statearr_12428;
})();
var statearr_12429_12474 = state_12400__$1;
(statearr_12429_12474[(2)] = null);

(statearr_12429_12474[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (14))){
var state_12400__$1 = state_12400;
var statearr_12433_12475 = state_12400__$1;
(statearr_12433_12475[(2)] = null);

(statearr_12433_12475[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (16))){
var inst_12355 = (state_12400[(10)]);
var inst_12359 = cljs.core.chunk_first.call(null,inst_12355);
var inst_12360 = cljs.core.chunk_rest.call(null,inst_12355);
var inst_12361 = cljs.core.count.call(null,inst_12359);
var inst_12341 = inst_12360;
var inst_12342 = inst_12359;
var inst_12343 = inst_12361;
var inst_12344 = (0);
var state_12400__$1 = (function (){var statearr_12434 = state_12400;
(statearr_12434[(12)] = inst_12343);

(statearr_12434[(13)] = inst_12342);

(statearr_12434[(15)] = inst_12344);

(statearr_12434[(16)] = inst_12341);

return statearr_12434;
})();
var statearr_12435_12476 = state_12400__$1;
(statearr_12435_12476[(2)] = null);

(statearr_12435_12476[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (10))){
var inst_12343 = (state_12400[(12)]);
var inst_12342 = (state_12400[(13)]);
var inst_12344 = (state_12400[(15)]);
var inst_12341 = (state_12400[(16)]);
var inst_12349 = cljs.core._nth.call(null,inst_12342,inst_12344);
var inst_12350 = cljs.core.async.muxch_STAR_.call(null,inst_12349);
var inst_12351 = cljs.core.async.close_BANG_.call(null,inst_12350);
var inst_12352 = (inst_12344 + (1));
var tmp12430 = inst_12343;
var tmp12431 = inst_12342;
var tmp12432 = inst_12341;
var inst_12341__$1 = tmp12432;
var inst_12342__$1 = tmp12431;
var inst_12343__$1 = tmp12430;
var inst_12344__$1 = inst_12352;
var state_12400__$1 = (function (){var statearr_12436 = state_12400;
(statearr_12436[(12)] = inst_12343__$1);

(statearr_12436[(17)] = inst_12351);

(statearr_12436[(13)] = inst_12342__$1);

(statearr_12436[(15)] = inst_12344__$1);

(statearr_12436[(16)] = inst_12341__$1);

return statearr_12436;
})();
var statearr_12437_12477 = state_12400__$1;
(statearr_12437_12477[(2)] = null);

(statearr_12437_12477[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (18))){
var inst_12370 = (state_12400[(2)]);
var state_12400__$1 = state_12400;
var statearr_12438_12478 = state_12400__$1;
(statearr_12438_12478[(2)] = inst_12370);

(statearr_12438_12478[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12401 === (8))){
var inst_12343 = (state_12400[(12)]);
var inst_12344 = (state_12400[(15)]);
var inst_12346 = (inst_12344 < inst_12343);
var inst_12347 = inst_12346;
var state_12400__$1 = state_12400;
if(cljs.core.truth_(inst_12347)){
var statearr_12439_12479 = state_12400__$1;
(statearr_12439_12479[(1)] = (10));

} else {
var statearr_12440_12480 = state_12400__$1;
(statearr_12440_12480[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10484__auto___12452,mults,ensure_mult,p))
;
return ((function (switch__10370__auto__,c__10484__auto___12452,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__10371__auto__ = null;
var cljs$core$async$state_machine__10371__auto____0 = (function (){
var statearr_12444 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12444[(0)] = cljs$core$async$state_machine__10371__auto__);

(statearr_12444[(1)] = (1));

return statearr_12444;
});
var cljs$core$async$state_machine__10371__auto____1 = (function (state_12400){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_12400);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e12445){if((e12445 instanceof Object)){
var ex__10374__auto__ = e12445;
var statearr_12446_12481 = state_12400;
(statearr_12446_12481[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12400);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12445;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12482 = state_12400;
state_12400 = G__12482;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$state_machine__10371__auto__ = function(state_12400){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10371__auto____1.call(this,state_12400);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10371__auto____0;
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10371__auto____1;
return cljs$core$async$state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto___12452,mults,ensure_mult,p))
})();
var state__10486__auto__ = (function (){var statearr_12447 = f__10485__auto__.call(null);
(statearr_12447[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto___12452);

return statearr_12447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto___12452,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args12483 = [];
var len__8628__auto___12486 = arguments.length;
var i__8629__auto___12487 = (0);
while(true){
if((i__8629__auto___12487 < len__8628__auto___12486)){
args12483.push((arguments[i__8629__auto___12487]));

var G__12488 = (i__8629__auto___12487 + (1));
i__8629__auto___12487 = G__12488;
continue;
} else {
}
break;
}

var G__12485 = args12483.length;
switch (G__12485) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12483.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args12490 = [];
var len__8628__auto___12493 = arguments.length;
var i__8629__auto___12494 = (0);
while(true){
if((i__8629__auto___12494 < len__8628__auto___12493)){
args12490.push((arguments[i__8629__auto___12494]));

var G__12495 = (i__8629__auto___12494 + (1));
i__8629__auto___12494 = G__12495;
continue;
} else {
}
break;
}

var G__12492 = args12490.length;
switch (G__12492) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12490.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args12497 = [];
var len__8628__auto___12568 = arguments.length;
var i__8629__auto___12569 = (0);
while(true){
if((i__8629__auto___12569 < len__8628__auto___12568)){
args12497.push((arguments[i__8629__auto___12569]));

var G__12570 = (i__8629__auto___12569 + (1));
i__8629__auto___12569 = G__12570;
continue;
} else {
}
break;
}

var G__12499 = args12497.length;
switch (G__12499) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12497.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__10484__auto___12572 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto___12572,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto___12572,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_12538){
var state_val_12539 = (state_12538[(1)]);
if((state_val_12539 === (7))){
var state_12538__$1 = state_12538;
var statearr_12540_12573 = state_12538__$1;
(statearr_12540_12573[(2)] = null);

(statearr_12540_12573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12539 === (1))){
var state_12538__$1 = state_12538;
var statearr_12541_12574 = state_12538__$1;
(statearr_12541_12574[(2)] = null);

(statearr_12541_12574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12539 === (4))){
var inst_12502 = (state_12538[(7)]);
var inst_12504 = (inst_12502 < cnt);
var state_12538__$1 = state_12538;
if(cljs.core.truth_(inst_12504)){
var statearr_12542_12575 = state_12538__$1;
(statearr_12542_12575[(1)] = (6));

} else {
var statearr_12543_12576 = state_12538__$1;
(statearr_12543_12576[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12539 === (15))){
var inst_12534 = (state_12538[(2)]);
var state_12538__$1 = state_12538;
var statearr_12544_12577 = state_12538__$1;
(statearr_12544_12577[(2)] = inst_12534);

(statearr_12544_12577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12539 === (13))){
var inst_12527 = cljs.core.async.close_BANG_.call(null,out);
var state_12538__$1 = state_12538;
var statearr_12545_12578 = state_12538__$1;
(statearr_12545_12578[(2)] = inst_12527);

(statearr_12545_12578[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12539 === (6))){
var state_12538__$1 = state_12538;
var statearr_12546_12579 = state_12538__$1;
(statearr_12546_12579[(2)] = null);

(statearr_12546_12579[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12539 === (3))){
var inst_12536 = (state_12538[(2)]);
var state_12538__$1 = state_12538;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12538__$1,inst_12536);
} else {
if((state_val_12539 === (12))){
var inst_12524 = (state_12538[(8)]);
var inst_12524__$1 = (state_12538[(2)]);
var inst_12525 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_12524__$1);
var state_12538__$1 = (function (){var statearr_12547 = state_12538;
(statearr_12547[(8)] = inst_12524__$1);

return statearr_12547;
})();
if(cljs.core.truth_(inst_12525)){
var statearr_12548_12580 = state_12538__$1;
(statearr_12548_12580[(1)] = (13));

} else {
var statearr_12549_12581 = state_12538__$1;
(statearr_12549_12581[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12539 === (2))){
var inst_12501 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_12502 = (0);
var state_12538__$1 = (function (){var statearr_12550 = state_12538;
(statearr_12550[(9)] = inst_12501);

(statearr_12550[(7)] = inst_12502);

return statearr_12550;
})();
var statearr_12551_12582 = state_12538__$1;
(statearr_12551_12582[(2)] = null);

(statearr_12551_12582[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12539 === (11))){
var inst_12502 = (state_12538[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_12538,(10),Object,null,(9));
var inst_12511 = chs__$1.call(null,inst_12502);
var inst_12512 = done.call(null,inst_12502);
var inst_12513 = cljs.core.async.take_BANG_.call(null,inst_12511,inst_12512);
var state_12538__$1 = state_12538;
var statearr_12552_12583 = state_12538__$1;
(statearr_12552_12583[(2)] = inst_12513);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12538__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12539 === (9))){
var inst_12502 = (state_12538[(7)]);
var inst_12515 = (state_12538[(2)]);
var inst_12516 = (inst_12502 + (1));
var inst_12502__$1 = inst_12516;
var state_12538__$1 = (function (){var statearr_12553 = state_12538;
(statearr_12553[(10)] = inst_12515);

(statearr_12553[(7)] = inst_12502__$1);

return statearr_12553;
})();
var statearr_12554_12584 = state_12538__$1;
(statearr_12554_12584[(2)] = null);

(statearr_12554_12584[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12539 === (5))){
var inst_12522 = (state_12538[(2)]);
var state_12538__$1 = (function (){var statearr_12555 = state_12538;
(statearr_12555[(11)] = inst_12522);

return statearr_12555;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12538__$1,(12),dchan);
} else {
if((state_val_12539 === (14))){
var inst_12524 = (state_12538[(8)]);
var inst_12529 = cljs.core.apply.call(null,f,inst_12524);
var state_12538__$1 = state_12538;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12538__$1,(16),out,inst_12529);
} else {
if((state_val_12539 === (16))){
var inst_12531 = (state_12538[(2)]);
var state_12538__$1 = (function (){var statearr_12556 = state_12538;
(statearr_12556[(12)] = inst_12531);

return statearr_12556;
})();
var statearr_12557_12585 = state_12538__$1;
(statearr_12557_12585[(2)] = null);

(statearr_12557_12585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12539 === (10))){
var inst_12506 = (state_12538[(2)]);
var inst_12507 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_12538__$1 = (function (){var statearr_12558 = state_12538;
(statearr_12558[(13)] = inst_12506);

return statearr_12558;
})();
var statearr_12559_12586 = state_12538__$1;
(statearr_12559_12586[(2)] = inst_12507);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12538__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12539 === (8))){
var inst_12520 = (state_12538[(2)]);
var state_12538__$1 = state_12538;
var statearr_12560_12587 = state_12538__$1;
(statearr_12560_12587[(2)] = inst_12520);

(statearr_12560_12587[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10484__auto___12572,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__10370__auto__,c__10484__auto___12572,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__10371__auto__ = null;
var cljs$core$async$state_machine__10371__auto____0 = (function (){
var statearr_12564 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12564[(0)] = cljs$core$async$state_machine__10371__auto__);

(statearr_12564[(1)] = (1));

return statearr_12564;
});
var cljs$core$async$state_machine__10371__auto____1 = (function (state_12538){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_12538);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e12565){if((e12565 instanceof Object)){
var ex__10374__auto__ = e12565;
var statearr_12566_12588 = state_12538;
(statearr_12566_12588[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12538);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12565;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12589 = state_12538;
state_12538 = G__12589;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$state_machine__10371__auto__ = function(state_12538){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10371__auto____1.call(this,state_12538);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10371__auto____0;
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10371__auto____1;
return cljs$core$async$state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto___12572,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__10486__auto__ = (function (){var statearr_12567 = f__10485__auto__.call(null);
(statearr_12567[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto___12572);

return statearr_12567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto___12572,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args12591 = [];
var len__8628__auto___12649 = arguments.length;
var i__8629__auto___12650 = (0);
while(true){
if((i__8629__auto___12650 < len__8628__auto___12649)){
args12591.push((arguments[i__8629__auto___12650]));

var G__12651 = (i__8629__auto___12650 + (1));
i__8629__auto___12650 = G__12651;
continue;
} else {
}
break;
}

var G__12593 = args12591.length;
switch (G__12593) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12591.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10484__auto___12653 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto___12653,out){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto___12653,out){
return (function (state_12625){
var state_val_12626 = (state_12625[(1)]);
if((state_val_12626 === (7))){
var inst_12605 = (state_12625[(7)]);
var inst_12604 = (state_12625[(8)]);
var inst_12604__$1 = (state_12625[(2)]);
var inst_12605__$1 = cljs.core.nth.call(null,inst_12604__$1,(0),null);
var inst_12606 = cljs.core.nth.call(null,inst_12604__$1,(1),null);
var inst_12607 = (inst_12605__$1 == null);
var state_12625__$1 = (function (){var statearr_12627 = state_12625;
(statearr_12627[(7)] = inst_12605__$1);

(statearr_12627[(9)] = inst_12606);

(statearr_12627[(8)] = inst_12604__$1);

return statearr_12627;
})();
if(cljs.core.truth_(inst_12607)){
var statearr_12628_12654 = state_12625__$1;
(statearr_12628_12654[(1)] = (8));

} else {
var statearr_12629_12655 = state_12625__$1;
(statearr_12629_12655[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12626 === (1))){
var inst_12594 = cljs.core.vec.call(null,chs);
var inst_12595 = inst_12594;
var state_12625__$1 = (function (){var statearr_12630 = state_12625;
(statearr_12630[(10)] = inst_12595);

return statearr_12630;
})();
var statearr_12631_12656 = state_12625__$1;
(statearr_12631_12656[(2)] = null);

(statearr_12631_12656[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12626 === (4))){
var inst_12595 = (state_12625[(10)]);
var state_12625__$1 = state_12625;
return cljs.core.async.ioc_alts_BANG_.call(null,state_12625__$1,(7),inst_12595);
} else {
if((state_val_12626 === (6))){
var inst_12621 = (state_12625[(2)]);
var state_12625__$1 = state_12625;
var statearr_12632_12657 = state_12625__$1;
(statearr_12632_12657[(2)] = inst_12621);

(statearr_12632_12657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12626 === (3))){
var inst_12623 = (state_12625[(2)]);
var state_12625__$1 = state_12625;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12625__$1,inst_12623);
} else {
if((state_val_12626 === (2))){
var inst_12595 = (state_12625[(10)]);
var inst_12597 = cljs.core.count.call(null,inst_12595);
var inst_12598 = (inst_12597 > (0));
var state_12625__$1 = state_12625;
if(cljs.core.truth_(inst_12598)){
var statearr_12634_12658 = state_12625__$1;
(statearr_12634_12658[(1)] = (4));

} else {
var statearr_12635_12659 = state_12625__$1;
(statearr_12635_12659[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12626 === (11))){
var inst_12595 = (state_12625[(10)]);
var inst_12614 = (state_12625[(2)]);
var tmp12633 = inst_12595;
var inst_12595__$1 = tmp12633;
var state_12625__$1 = (function (){var statearr_12636 = state_12625;
(statearr_12636[(10)] = inst_12595__$1);

(statearr_12636[(11)] = inst_12614);

return statearr_12636;
})();
var statearr_12637_12660 = state_12625__$1;
(statearr_12637_12660[(2)] = null);

(statearr_12637_12660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12626 === (9))){
var inst_12605 = (state_12625[(7)]);
var state_12625__$1 = state_12625;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12625__$1,(11),out,inst_12605);
} else {
if((state_val_12626 === (5))){
var inst_12619 = cljs.core.async.close_BANG_.call(null,out);
var state_12625__$1 = state_12625;
var statearr_12638_12661 = state_12625__$1;
(statearr_12638_12661[(2)] = inst_12619);

(statearr_12638_12661[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12626 === (10))){
var inst_12617 = (state_12625[(2)]);
var state_12625__$1 = state_12625;
var statearr_12639_12662 = state_12625__$1;
(statearr_12639_12662[(2)] = inst_12617);

(statearr_12639_12662[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12626 === (8))){
var inst_12595 = (state_12625[(10)]);
var inst_12605 = (state_12625[(7)]);
var inst_12606 = (state_12625[(9)]);
var inst_12604 = (state_12625[(8)]);
var inst_12609 = (function (){var cs = inst_12595;
var vec__12600 = inst_12604;
var v = inst_12605;
var c = inst_12606;
return ((function (cs,vec__12600,v,c,inst_12595,inst_12605,inst_12606,inst_12604,state_val_12626,c__10484__auto___12653,out){
return (function (p1__12590_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__12590_SHARP_);
});
;})(cs,vec__12600,v,c,inst_12595,inst_12605,inst_12606,inst_12604,state_val_12626,c__10484__auto___12653,out))
})();
var inst_12610 = cljs.core.filterv.call(null,inst_12609,inst_12595);
var inst_12595__$1 = inst_12610;
var state_12625__$1 = (function (){var statearr_12640 = state_12625;
(statearr_12640[(10)] = inst_12595__$1);

return statearr_12640;
})();
var statearr_12641_12663 = state_12625__$1;
(statearr_12641_12663[(2)] = null);

(statearr_12641_12663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__10484__auto___12653,out))
;
return ((function (switch__10370__auto__,c__10484__auto___12653,out){
return (function() {
var cljs$core$async$state_machine__10371__auto__ = null;
var cljs$core$async$state_machine__10371__auto____0 = (function (){
var statearr_12645 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12645[(0)] = cljs$core$async$state_machine__10371__auto__);

(statearr_12645[(1)] = (1));

return statearr_12645;
});
var cljs$core$async$state_machine__10371__auto____1 = (function (state_12625){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_12625);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e12646){if((e12646 instanceof Object)){
var ex__10374__auto__ = e12646;
var statearr_12647_12664 = state_12625;
(statearr_12647_12664[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12625);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12646;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12665 = state_12625;
state_12625 = G__12665;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$state_machine__10371__auto__ = function(state_12625){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10371__auto____1.call(this,state_12625);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10371__auto____0;
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10371__auto____1;
return cljs$core$async$state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto___12653,out))
})();
var state__10486__auto__ = (function (){var statearr_12648 = f__10485__auto__.call(null);
(statearr_12648[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto___12653);

return statearr_12648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto___12653,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args12666 = [];
var len__8628__auto___12715 = arguments.length;
var i__8629__auto___12716 = (0);
while(true){
if((i__8629__auto___12716 < len__8628__auto___12715)){
args12666.push((arguments[i__8629__auto___12716]));

var G__12717 = (i__8629__auto___12716 + (1));
i__8629__auto___12716 = G__12717;
continue;
} else {
}
break;
}

var G__12668 = args12666.length;
switch (G__12668) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12666.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10484__auto___12719 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto___12719,out){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto___12719,out){
return (function (state_12692){
var state_val_12693 = (state_12692[(1)]);
if((state_val_12693 === (7))){
var inst_12674 = (state_12692[(7)]);
var inst_12674__$1 = (state_12692[(2)]);
var inst_12675 = (inst_12674__$1 == null);
var inst_12676 = cljs.core.not.call(null,inst_12675);
var state_12692__$1 = (function (){var statearr_12694 = state_12692;
(statearr_12694[(7)] = inst_12674__$1);

return statearr_12694;
})();
if(inst_12676){
var statearr_12695_12720 = state_12692__$1;
(statearr_12695_12720[(1)] = (8));

} else {
var statearr_12696_12721 = state_12692__$1;
(statearr_12696_12721[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12693 === (1))){
var inst_12669 = (0);
var state_12692__$1 = (function (){var statearr_12697 = state_12692;
(statearr_12697[(8)] = inst_12669);

return statearr_12697;
})();
var statearr_12698_12722 = state_12692__$1;
(statearr_12698_12722[(2)] = null);

(statearr_12698_12722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12693 === (4))){
var state_12692__$1 = state_12692;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12692__$1,(7),ch);
} else {
if((state_val_12693 === (6))){
var inst_12687 = (state_12692[(2)]);
var state_12692__$1 = state_12692;
var statearr_12699_12723 = state_12692__$1;
(statearr_12699_12723[(2)] = inst_12687);

(statearr_12699_12723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12693 === (3))){
var inst_12689 = (state_12692[(2)]);
var inst_12690 = cljs.core.async.close_BANG_.call(null,out);
var state_12692__$1 = (function (){var statearr_12700 = state_12692;
(statearr_12700[(9)] = inst_12689);

return statearr_12700;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12692__$1,inst_12690);
} else {
if((state_val_12693 === (2))){
var inst_12669 = (state_12692[(8)]);
var inst_12671 = (inst_12669 < n);
var state_12692__$1 = state_12692;
if(cljs.core.truth_(inst_12671)){
var statearr_12701_12724 = state_12692__$1;
(statearr_12701_12724[(1)] = (4));

} else {
var statearr_12702_12725 = state_12692__$1;
(statearr_12702_12725[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12693 === (11))){
var inst_12669 = (state_12692[(8)]);
var inst_12679 = (state_12692[(2)]);
var inst_12680 = (inst_12669 + (1));
var inst_12669__$1 = inst_12680;
var state_12692__$1 = (function (){var statearr_12703 = state_12692;
(statearr_12703[(8)] = inst_12669__$1);

(statearr_12703[(10)] = inst_12679);

return statearr_12703;
})();
var statearr_12704_12726 = state_12692__$1;
(statearr_12704_12726[(2)] = null);

(statearr_12704_12726[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12693 === (9))){
var state_12692__$1 = state_12692;
var statearr_12705_12727 = state_12692__$1;
(statearr_12705_12727[(2)] = null);

(statearr_12705_12727[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12693 === (5))){
var state_12692__$1 = state_12692;
var statearr_12706_12728 = state_12692__$1;
(statearr_12706_12728[(2)] = null);

(statearr_12706_12728[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12693 === (10))){
var inst_12684 = (state_12692[(2)]);
var state_12692__$1 = state_12692;
var statearr_12707_12729 = state_12692__$1;
(statearr_12707_12729[(2)] = inst_12684);

(statearr_12707_12729[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12693 === (8))){
var inst_12674 = (state_12692[(7)]);
var state_12692__$1 = state_12692;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12692__$1,(11),out,inst_12674);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__10484__auto___12719,out))
;
return ((function (switch__10370__auto__,c__10484__auto___12719,out){
return (function() {
var cljs$core$async$state_machine__10371__auto__ = null;
var cljs$core$async$state_machine__10371__auto____0 = (function (){
var statearr_12711 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12711[(0)] = cljs$core$async$state_machine__10371__auto__);

(statearr_12711[(1)] = (1));

return statearr_12711;
});
var cljs$core$async$state_machine__10371__auto____1 = (function (state_12692){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_12692);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e12712){if((e12712 instanceof Object)){
var ex__10374__auto__ = e12712;
var statearr_12713_12730 = state_12692;
(statearr_12713_12730[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12692);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12712;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12731 = state_12692;
state_12692 = G__12731;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$state_machine__10371__auto__ = function(state_12692){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10371__auto____1.call(this,state_12692);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10371__auto____0;
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10371__auto____1;
return cljs$core$async$state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto___12719,out))
})();
var state__10486__auto__ = (function (){var statearr_12714 = f__10485__auto__.call(null);
(statearr_12714[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto___12719);

return statearr_12714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto___12719,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async12739 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12739 = (function (f,ch,meta12740){
this.f = f;
this.ch = ch;
this.meta12740 = meta12740;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12739.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12741,meta12740__$1){
var self__ = this;
var _12741__$1 = this;
return (new cljs.core.async.t_cljs$core$async12739(self__.f,self__.ch,meta12740__$1));
});

cljs.core.async.t_cljs$core$async12739.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12741){
var self__ = this;
var _12741__$1 = this;
return self__.meta12740;
});

cljs.core.async.t_cljs$core$async12739.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12739.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12739.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12739.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12739.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async12742 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12742 = (function (f,ch,meta12740,_,fn1,meta12743){
this.f = f;
this.ch = ch;
this.meta12740 = meta12740;
this._ = _;
this.fn1 = fn1;
this.meta12743 = meta12743;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12742.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_12744,meta12743__$1){
var self__ = this;
var _12744__$1 = this;
return (new cljs.core.async.t_cljs$core$async12742(self__.f,self__.ch,self__.meta12740,self__._,self__.fn1,meta12743__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async12742.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_12744){
var self__ = this;
var _12744__$1 = this;
return self__.meta12743;
});})(___$1))
;

cljs.core.async.t_cljs$core$async12742.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12742.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async12742.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async12742.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__12732_SHARP_){
return f1.call(null,(((p1__12732_SHARP_ == null))?null:self__.f.call(null,p1__12732_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async12742.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12740","meta12740",1048228168,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async12739","cljs.core.async/t_cljs$core$async12739",813095641,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta12743","meta12743",-1606280522,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async12742.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12742.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12742";

cljs.core.async.t_cljs$core$async12742.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__8064__auto__,writer__8065__auto__,opt__8066__auto__){
return cljs.core._write.call(null,writer__8065__auto__,"cljs.core.async/t_cljs$core$async12742");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async12742 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12742(f__$1,ch__$1,meta12740__$1,___$2,fn1__$1,meta12743){
return (new cljs.core.async.t_cljs$core$async12742(f__$1,ch__$1,meta12740__$1,___$2,fn1__$1,meta12743));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async12742(self__.f,self__.ch,self__.meta12740,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__7395__auto__ = ret;
if(cljs.core.truth_(and__7395__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__7395__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async12739.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12739.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async12739.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12740","meta12740",1048228168,null)], null);
});

cljs.core.async.t_cljs$core$async12739.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12739.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12739";

cljs.core.async.t_cljs$core$async12739.cljs$lang$ctorPrWriter = (function (this__8064__auto__,writer__8065__auto__,opt__8066__auto__){
return cljs.core._write.call(null,writer__8065__auto__,"cljs.core.async/t_cljs$core$async12739");
});

cljs.core.async.__GT_t_cljs$core$async12739 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12739(f__$1,ch__$1,meta12740){
return (new cljs.core.async.t_cljs$core$async12739(f__$1,ch__$1,meta12740));
});

}

return (new cljs.core.async.t_cljs$core$async12739(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async12748 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12748 = (function (f,ch,meta12749){
this.f = f;
this.ch = ch;
this.meta12749 = meta12749;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12748.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12750,meta12749__$1){
var self__ = this;
var _12750__$1 = this;
return (new cljs.core.async.t_cljs$core$async12748(self__.f,self__.ch,meta12749__$1));
});

cljs.core.async.t_cljs$core$async12748.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12750){
var self__ = this;
var _12750__$1 = this;
return self__.meta12749;
});

cljs.core.async.t_cljs$core$async12748.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12748.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12748.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12748.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async12748.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12748.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async12748.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12749","meta12749",1093038844,null)], null);
});

cljs.core.async.t_cljs$core$async12748.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12748.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12748";

cljs.core.async.t_cljs$core$async12748.cljs$lang$ctorPrWriter = (function (this__8064__auto__,writer__8065__auto__,opt__8066__auto__){
return cljs.core._write.call(null,writer__8065__auto__,"cljs.core.async/t_cljs$core$async12748");
});

cljs.core.async.__GT_t_cljs$core$async12748 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async12748(f__$1,ch__$1,meta12749){
return (new cljs.core.async.t_cljs$core$async12748(f__$1,ch__$1,meta12749));
});

}

return (new cljs.core.async.t_cljs$core$async12748(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async12754 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12754 = (function (p,ch,meta12755){
this.p = p;
this.ch = ch;
this.meta12755 = meta12755;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12754.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12756,meta12755__$1){
var self__ = this;
var _12756__$1 = this;
return (new cljs.core.async.t_cljs$core$async12754(self__.p,self__.ch,meta12755__$1));
});

cljs.core.async.t_cljs$core$async12754.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12756){
var self__ = this;
var _12756__$1 = this;
return self__.meta12755;
});

cljs.core.async.t_cljs$core$async12754.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12754.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12754.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12754.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12754.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async12754.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12754.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async12754.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12755","meta12755",-2034253633,null)], null);
});

cljs.core.async.t_cljs$core$async12754.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12754.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12754";

cljs.core.async.t_cljs$core$async12754.cljs$lang$ctorPrWriter = (function (this__8064__auto__,writer__8065__auto__,opt__8066__auto__){
return cljs.core._write.call(null,writer__8065__auto__,"cljs.core.async/t_cljs$core$async12754");
});

cljs.core.async.__GT_t_cljs$core$async12754 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async12754(p__$1,ch__$1,meta12755){
return (new cljs.core.async.t_cljs$core$async12754(p__$1,ch__$1,meta12755));
});

}

return (new cljs.core.async.t_cljs$core$async12754(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args12757 = [];
var len__8628__auto___12801 = arguments.length;
var i__8629__auto___12802 = (0);
while(true){
if((i__8629__auto___12802 < len__8628__auto___12801)){
args12757.push((arguments[i__8629__auto___12802]));

var G__12803 = (i__8629__auto___12802 + (1));
i__8629__auto___12802 = G__12803;
continue;
} else {
}
break;
}

var G__12759 = args12757.length;
switch (G__12759) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12757.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10484__auto___12805 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto___12805,out){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto___12805,out){
return (function (state_12780){
var state_val_12781 = (state_12780[(1)]);
if((state_val_12781 === (7))){
var inst_12776 = (state_12780[(2)]);
var state_12780__$1 = state_12780;
var statearr_12782_12806 = state_12780__$1;
(statearr_12782_12806[(2)] = inst_12776);

(statearr_12782_12806[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12781 === (1))){
var state_12780__$1 = state_12780;
var statearr_12783_12807 = state_12780__$1;
(statearr_12783_12807[(2)] = null);

(statearr_12783_12807[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12781 === (4))){
var inst_12762 = (state_12780[(7)]);
var inst_12762__$1 = (state_12780[(2)]);
var inst_12763 = (inst_12762__$1 == null);
var state_12780__$1 = (function (){var statearr_12784 = state_12780;
(statearr_12784[(7)] = inst_12762__$1);

return statearr_12784;
})();
if(cljs.core.truth_(inst_12763)){
var statearr_12785_12808 = state_12780__$1;
(statearr_12785_12808[(1)] = (5));

} else {
var statearr_12786_12809 = state_12780__$1;
(statearr_12786_12809[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12781 === (6))){
var inst_12762 = (state_12780[(7)]);
var inst_12767 = p.call(null,inst_12762);
var state_12780__$1 = state_12780;
if(cljs.core.truth_(inst_12767)){
var statearr_12787_12810 = state_12780__$1;
(statearr_12787_12810[(1)] = (8));

} else {
var statearr_12788_12811 = state_12780__$1;
(statearr_12788_12811[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12781 === (3))){
var inst_12778 = (state_12780[(2)]);
var state_12780__$1 = state_12780;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12780__$1,inst_12778);
} else {
if((state_val_12781 === (2))){
var state_12780__$1 = state_12780;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12780__$1,(4),ch);
} else {
if((state_val_12781 === (11))){
var inst_12770 = (state_12780[(2)]);
var state_12780__$1 = state_12780;
var statearr_12789_12812 = state_12780__$1;
(statearr_12789_12812[(2)] = inst_12770);

(statearr_12789_12812[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12781 === (9))){
var state_12780__$1 = state_12780;
var statearr_12790_12813 = state_12780__$1;
(statearr_12790_12813[(2)] = null);

(statearr_12790_12813[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12781 === (5))){
var inst_12765 = cljs.core.async.close_BANG_.call(null,out);
var state_12780__$1 = state_12780;
var statearr_12791_12814 = state_12780__$1;
(statearr_12791_12814[(2)] = inst_12765);

(statearr_12791_12814[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12781 === (10))){
var inst_12773 = (state_12780[(2)]);
var state_12780__$1 = (function (){var statearr_12792 = state_12780;
(statearr_12792[(8)] = inst_12773);

return statearr_12792;
})();
var statearr_12793_12815 = state_12780__$1;
(statearr_12793_12815[(2)] = null);

(statearr_12793_12815[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12781 === (8))){
var inst_12762 = (state_12780[(7)]);
var state_12780__$1 = state_12780;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12780__$1,(11),out,inst_12762);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__10484__auto___12805,out))
;
return ((function (switch__10370__auto__,c__10484__auto___12805,out){
return (function() {
var cljs$core$async$state_machine__10371__auto__ = null;
var cljs$core$async$state_machine__10371__auto____0 = (function (){
var statearr_12797 = [null,null,null,null,null,null,null,null,null];
(statearr_12797[(0)] = cljs$core$async$state_machine__10371__auto__);

(statearr_12797[(1)] = (1));

return statearr_12797;
});
var cljs$core$async$state_machine__10371__auto____1 = (function (state_12780){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_12780);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e12798){if((e12798 instanceof Object)){
var ex__10374__auto__ = e12798;
var statearr_12799_12816 = state_12780;
(statearr_12799_12816[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12780);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12798;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12817 = state_12780;
state_12780 = G__12817;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$state_machine__10371__auto__ = function(state_12780){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10371__auto____1.call(this,state_12780);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10371__auto____0;
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10371__auto____1;
return cljs$core$async$state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto___12805,out))
})();
var state__10486__auto__ = (function (){var statearr_12800 = f__10485__auto__.call(null);
(statearr_12800[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto___12805);

return statearr_12800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto___12805,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args12818 = [];
var len__8628__auto___12821 = arguments.length;
var i__8629__auto___12822 = (0);
while(true){
if((i__8629__auto___12822 < len__8628__auto___12821)){
args12818.push((arguments[i__8629__auto___12822]));

var G__12823 = (i__8629__auto___12822 + (1));
i__8629__auto___12822 = G__12823;
continue;
} else {
}
break;
}

var G__12820 = args12818.length;
switch (G__12820) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12818.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__10484__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto__){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto__){
return (function (state_12990){
var state_val_12991 = (state_12990[(1)]);
if((state_val_12991 === (7))){
var inst_12986 = (state_12990[(2)]);
var state_12990__$1 = state_12990;
var statearr_12992_13033 = state_12990__$1;
(statearr_12992_13033[(2)] = inst_12986);

(statearr_12992_13033[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (20))){
var inst_12956 = (state_12990[(7)]);
var inst_12967 = (state_12990[(2)]);
var inst_12968 = cljs.core.next.call(null,inst_12956);
var inst_12942 = inst_12968;
var inst_12943 = null;
var inst_12944 = (0);
var inst_12945 = (0);
var state_12990__$1 = (function (){var statearr_12993 = state_12990;
(statearr_12993[(8)] = inst_12967);

(statearr_12993[(9)] = inst_12945);

(statearr_12993[(10)] = inst_12944);

(statearr_12993[(11)] = inst_12942);

(statearr_12993[(12)] = inst_12943);

return statearr_12993;
})();
var statearr_12994_13034 = state_12990__$1;
(statearr_12994_13034[(2)] = null);

(statearr_12994_13034[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (1))){
var state_12990__$1 = state_12990;
var statearr_12995_13035 = state_12990__$1;
(statearr_12995_13035[(2)] = null);

(statearr_12995_13035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (4))){
var inst_12931 = (state_12990[(13)]);
var inst_12931__$1 = (state_12990[(2)]);
var inst_12932 = (inst_12931__$1 == null);
var state_12990__$1 = (function (){var statearr_12996 = state_12990;
(statearr_12996[(13)] = inst_12931__$1);

return statearr_12996;
})();
if(cljs.core.truth_(inst_12932)){
var statearr_12997_13036 = state_12990__$1;
(statearr_12997_13036[(1)] = (5));

} else {
var statearr_12998_13037 = state_12990__$1;
(statearr_12998_13037[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (15))){
var state_12990__$1 = state_12990;
var statearr_13002_13038 = state_12990__$1;
(statearr_13002_13038[(2)] = null);

(statearr_13002_13038[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (21))){
var state_12990__$1 = state_12990;
var statearr_13003_13039 = state_12990__$1;
(statearr_13003_13039[(2)] = null);

(statearr_13003_13039[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (13))){
var inst_12945 = (state_12990[(9)]);
var inst_12944 = (state_12990[(10)]);
var inst_12942 = (state_12990[(11)]);
var inst_12943 = (state_12990[(12)]);
var inst_12952 = (state_12990[(2)]);
var inst_12953 = (inst_12945 + (1));
var tmp12999 = inst_12944;
var tmp13000 = inst_12942;
var tmp13001 = inst_12943;
var inst_12942__$1 = tmp13000;
var inst_12943__$1 = tmp13001;
var inst_12944__$1 = tmp12999;
var inst_12945__$1 = inst_12953;
var state_12990__$1 = (function (){var statearr_13004 = state_12990;
(statearr_13004[(14)] = inst_12952);

(statearr_13004[(9)] = inst_12945__$1);

(statearr_13004[(10)] = inst_12944__$1);

(statearr_13004[(11)] = inst_12942__$1);

(statearr_13004[(12)] = inst_12943__$1);

return statearr_13004;
})();
var statearr_13005_13040 = state_12990__$1;
(statearr_13005_13040[(2)] = null);

(statearr_13005_13040[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (22))){
var state_12990__$1 = state_12990;
var statearr_13006_13041 = state_12990__$1;
(statearr_13006_13041[(2)] = null);

(statearr_13006_13041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (6))){
var inst_12931 = (state_12990[(13)]);
var inst_12940 = f.call(null,inst_12931);
var inst_12941 = cljs.core.seq.call(null,inst_12940);
var inst_12942 = inst_12941;
var inst_12943 = null;
var inst_12944 = (0);
var inst_12945 = (0);
var state_12990__$1 = (function (){var statearr_13007 = state_12990;
(statearr_13007[(9)] = inst_12945);

(statearr_13007[(10)] = inst_12944);

(statearr_13007[(11)] = inst_12942);

(statearr_13007[(12)] = inst_12943);

return statearr_13007;
})();
var statearr_13008_13042 = state_12990__$1;
(statearr_13008_13042[(2)] = null);

(statearr_13008_13042[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (17))){
var inst_12956 = (state_12990[(7)]);
var inst_12960 = cljs.core.chunk_first.call(null,inst_12956);
var inst_12961 = cljs.core.chunk_rest.call(null,inst_12956);
var inst_12962 = cljs.core.count.call(null,inst_12960);
var inst_12942 = inst_12961;
var inst_12943 = inst_12960;
var inst_12944 = inst_12962;
var inst_12945 = (0);
var state_12990__$1 = (function (){var statearr_13009 = state_12990;
(statearr_13009[(9)] = inst_12945);

(statearr_13009[(10)] = inst_12944);

(statearr_13009[(11)] = inst_12942);

(statearr_13009[(12)] = inst_12943);

return statearr_13009;
})();
var statearr_13010_13043 = state_12990__$1;
(statearr_13010_13043[(2)] = null);

(statearr_13010_13043[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (3))){
var inst_12988 = (state_12990[(2)]);
var state_12990__$1 = state_12990;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12990__$1,inst_12988);
} else {
if((state_val_12991 === (12))){
var inst_12976 = (state_12990[(2)]);
var state_12990__$1 = state_12990;
var statearr_13011_13044 = state_12990__$1;
(statearr_13011_13044[(2)] = inst_12976);

(statearr_13011_13044[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (2))){
var state_12990__$1 = state_12990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12990__$1,(4),in$);
} else {
if((state_val_12991 === (23))){
var inst_12984 = (state_12990[(2)]);
var state_12990__$1 = state_12990;
var statearr_13012_13045 = state_12990__$1;
(statearr_13012_13045[(2)] = inst_12984);

(statearr_13012_13045[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (19))){
var inst_12971 = (state_12990[(2)]);
var state_12990__$1 = state_12990;
var statearr_13013_13046 = state_12990__$1;
(statearr_13013_13046[(2)] = inst_12971);

(statearr_13013_13046[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (11))){
var inst_12956 = (state_12990[(7)]);
var inst_12942 = (state_12990[(11)]);
var inst_12956__$1 = cljs.core.seq.call(null,inst_12942);
var state_12990__$1 = (function (){var statearr_13014 = state_12990;
(statearr_13014[(7)] = inst_12956__$1);

return statearr_13014;
})();
if(inst_12956__$1){
var statearr_13015_13047 = state_12990__$1;
(statearr_13015_13047[(1)] = (14));

} else {
var statearr_13016_13048 = state_12990__$1;
(statearr_13016_13048[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (9))){
var inst_12978 = (state_12990[(2)]);
var inst_12979 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_12990__$1 = (function (){var statearr_13017 = state_12990;
(statearr_13017[(15)] = inst_12978);

return statearr_13017;
})();
if(cljs.core.truth_(inst_12979)){
var statearr_13018_13049 = state_12990__$1;
(statearr_13018_13049[(1)] = (21));

} else {
var statearr_13019_13050 = state_12990__$1;
(statearr_13019_13050[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (5))){
var inst_12934 = cljs.core.async.close_BANG_.call(null,out);
var state_12990__$1 = state_12990;
var statearr_13020_13051 = state_12990__$1;
(statearr_13020_13051[(2)] = inst_12934);

(statearr_13020_13051[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (14))){
var inst_12956 = (state_12990[(7)]);
var inst_12958 = cljs.core.chunked_seq_QMARK_.call(null,inst_12956);
var state_12990__$1 = state_12990;
if(inst_12958){
var statearr_13021_13052 = state_12990__$1;
(statearr_13021_13052[(1)] = (17));

} else {
var statearr_13022_13053 = state_12990__$1;
(statearr_13022_13053[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (16))){
var inst_12974 = (state_12990[(2)]);
var state_12990__$1 = state_12990;
var statearr_13023_13054 = state_12990__$1;
(statearr_13023_13054[(2)] = inst_12974);

(statearr_13023_13054[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12991 === (10))){
var inst_12945 = (state_12990[(9)]);
var inst_12943 = (state_12990[(12)]);
var inst_12950 = cljs.core._nth.call(null,inst_12943,inst_12945);
var state_12990__$1 = state_12990;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12990__$1,(13),out,inst_12950);
} else {
if((state_val_12991 === (18))){
var inst_12956 = (state_12990[(7)]);
var inst_12965 = cljs.core.first.call(null,inst_12956);
var state_12990__$1 = state_12990;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12990__$1,(20),out,inst_12965);
} else {
if((state_val_12991 === (8))){
var inst_12945 = (state_12990[(9)]);
var inst_12944 = (state_12990[(10)]);
var inst_12947 = (inst_12945 < inst_12944);
var inst_12948 = inst_12947;
var state_12990__$1 = state_12990;
if(cljs.core.truth_(inst_12948)){
var statearr_13024_13055 = state_12990__$1;
(statearr_13024_13055[(1)] = (10));

} else {
var statearr_13025_13056 = state_12990__$1;
(statearr_13025_13056[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10484__auto__))
;
return ((function (switch__10370__auto__,c__10484__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10371__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10371__auto____0 = (function (){
var statearr_13029 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13029[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10371__auto__);

(statearr_13029[(1)] = (1));

return statearr_13029;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10371__auto____1 = (function (state_12990){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_12990);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e13030){if((e13030 instanceof Object)){
var ex__10374__auto__ = e13030;
var statearr_13031_13057 = state_12990;
(statearr_13031_13057[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12990);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13030;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13058 = state_12990;
state_12990 = G__13058;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10371__auto__ = function(state_12990){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10371__auto____1.call(this,state_12990);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10371__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10371__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto__))
})();
var state__10486__auto__ = (function (){var statearr_13032 = f__10485__auto__.call(null);
(statearr_13032[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto__);

return statearr_13032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto__))
);

return c__10484__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args13059 = [];
var len__8628__auto___13062 = arguments.length;
var i__8629__auto___13063 = (0);
while(true){
if((i__8629__auto___13063 < len__8628__auto___13062)){
args13059.push((arguments[i__8629__auto___13063]));

var G__13064 = (i__8629__auto___13063 + (1));
i__8629__auto___13063 = G__13064;
continue;
} else {
}
break;
}

var G__13061 = args13059.length;
switch (G__13061) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13059.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args13066 = [];
var len__8628__auto___13069 = arguments.length;
var i__8629__auto___13070 = (0);
while(true){
if((i__8629__auto___13070 < len__8628__auto___13069)){
args13066.push((arguments[i__8629__auto___13070]));

var G__13071 = (i__8629__auto___13070 + (1));
i__8629__auto___13070 = G__13071;
continue;
} else {
}
break;
}

var G__13068 = args13066.length;
switch (G__13068) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13066.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args13073 = [];
var len__8628__auto___13124 = arguments.length;
var i__8629__auto___13125 = (0);
while(true){
if((i__8629__auto___13125 < len__8628__auto___13124)){
args13073.push((arguments[i__8629__auto___13125]));

var G__13126 = (i__8629__auto___13125 + (1));
i__8629__auto___13125 = G__13126;
continue;
} else {
}
break;
}

var G__13075 = args13073.length;
switch (G__13075) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13073.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10484__auto___13128 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto___13128,out){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto___13128,out){
return (function (state_13099){
var state_val_13100 = (state_13099[(1)]);
if((state_val_13100 === (7))){
var inst_13094 = (state_13099[(2)]);
var state_13099__$1 = state_13099;
var statearr_13101_13129 = state_13099__$1;
(statearr_13101_13129[(2)] = inst_13094);

(statearr_13101_13129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13100 === (1))){
var inst_13076 = null;
var state_13099__$1 = (function (){var statearr_13102 = state_13099;
(statearr_13102[(7)] = inst_13076);

return statearr_13102;
})();
var statearr_13103_13130 = state_13099__$1;
(statearr_13103_13130[(2)] = null);

(statearr_13103_13130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13100 === (4))){
var inst_13079 = (state_13099[(8)]);
var inst_13079__$1 = (state_13099[(2)]);
var inst_13080 = (inst_13079__$1 == null);
var inst_13081 = cljs.core.not.call(null,inst_13080);
var state_13099__$1 = (function (){var statearr_13104 = state_13099;
(statearr_13104[(8)] = inst_13079__$1);

return statearr_13104;
})();
if(inst_13081){
var statearr_13105_13131 = state_13099__$1;
(statearr_13105_13131[(1)] = (5));

} else {
var statearr_13106_13132 = state_13099__$1;
(statearr_13106_13132[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13100 === (6))){
var state_13099__$1 = state_13099;
var statearr_13107_13133 = state_13099__$1;
(statearr_13107_13133[(2)] = null);

(statearr_13107_13133[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13100 === (3))){
var inst_13096 = (state_13099[(2)]);
var inst_13097 = cljs.core.async.close_BANG_.call(null,out);
var state_13099__$1 = (function (){var statearr_13108 = state_13099;
(statearr_13108[(9)] = inst_13096);

return statearr_13108;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13099__$1,inst_13097);
} else {
if((state_val_13100 === (2))){
var state_13099__$1 = state_13099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13099__$1,(4),ch);
} else {
if((state_val_13100 === (11))){
var inst_13079 = (state_13099[(8)]);
var inst_13088 = (state_13099[(2)]);
var inst_13076 = inst_13079;
var state_13099__$1 = (function (){var statearr_13109 = state_13099;
(statearr_13109[(7)] = inst_13076);

(statearr_13109[(10)] = inst_13088);

return statearr_13109;
})();
var statearr_13110_13134 = state_13099__$1;
(statearr_13110_13134[(2)] = null);

(statearr_13110_13134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13100 === (9))){
var inst_13079 = (state_13099[(8)]);
var state_13099__$1 = state_13099;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13099__$1,(11),out,inst_13079);
} else {
if((state_val_13100 === (5))){
var inst_13079 = (state_13099[(8)]);
var inst_13076 = (state_13099[(7)]);
var inst_13083 = cljs.core._EQ_.call(null,inst_13079,inst_13076);
var state_13099__$1 = state_13099;
if(inst_13083){
var statearr_13112_13135 = state_13099__$1;
(statearr_13112_13135[(1)] = (8));

} else {
var statearr_13113_13136 = state_13099__$1;
(statearr_13113_13136[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13100 === (10))){
var inst_13091 = (state_13099[(2)]);
var state_13099__$1 = state_13099;
var statearr_13114_13137 = state_13099__$1;
(statearr_13114_13137[(2)] = inst_13091);

(statearr_13114_13137[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13100 === (8))){
var inst_13076 = (state_13099[(7)]);
var tmp13111 = inst_13076;
var inst_13076__$1 = tmp13111;
var state_13099__$1 = (function (){var statearr_13115 = state_13099;
(statearr_13115[(7)] = inst_13076__$1);

return statearr_13115;
})();
var statearr_13116_13138 = state_13099__$1;
(statearr_13116_13138[(2)] = null);

(statearr_13116_13138[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__10484__auto___13128,out))
;
return ((function (switch__10370__auto__,c__10484__auto___13128,out){
return (function() {
var cljs$core$async$state_machine__10371__auto__ = null;
var cljs$core$async$state_machine__10371__auto____0 = (function (){
var statearr_13120 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13120[(0)] = cljs$core$async$state_machine__10371__auto__);

(statearr_13120[(1)] = (1));

return statearr_13120;
});
var cljs$core$async$state_machine__10371__auto____1 = (function (state_13099){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_13099);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e13121){if((e13121 instanceof Object)){
var ex__10374__auto__ = e13121;
var statearr_13122_13139 = state_13099;
(statearr_13122_13139[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13099);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13121;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13140 = state_13099;
state_13099 = G__13140;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$state_machine__10371__auto__ = function(state_13099){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10371__auto____1.call(this,state_13099);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10371__auto____0;
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10371__auto____1;
return cljs$core$async$state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto___13128,out))
})();
var state__10486__auto__ = (function (){var statearr_13123 = f__10485__auto__.call(null);
(statearr_13123[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto___13128);

return statearr_13123;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto___13128,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args13141 = [];
var len__8628__auto___13211 = arguments.length;
var i__8629__auto___13212 = (0);
while(true){
if((i__8629__auto___13212 < len__8628__auto___13211)){
args13141.push((arguments[i__8629__auto___13212]));

var G__13213 = (i__8629__auto___13212 + (1));
i__8629__auto___13212 = G__13213;
continue;
} else {
}
break;
}

var G__13143 = args13141.length;
switch (G__13143) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13141.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10484__auto___13215 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto___13215,out){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto___13215,out){
return (function (state_13181){
var state_val_13182 = (state_13181[(1)]);
if((state_val_13182 === (7))){
var inst_13177 = (state_13181[(2)]);
var state_13181__$1 = state_13181;
var statearr_13183_13216 = state_13181__$1;
(statearr_13183_13216[(2)] = inst_13177);

(statearr_13183_13216[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (1))){
var inst_13144 = (new Array(n));
var inst_13145 = inst_13144;
var inst_13146 = (0);
var state_13181__$1 = (function (){var statearr_13184 = state_13181;
(statearr_13184[(7)] = inst_13146);

(statearr_13184[(8)] = inst_13145);

return statearr_13184;
})();
var statearr_13185_13217 = state_13181__$1;
(statearr_13185_13217[(2)] = null);

(statearr_13185_13217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (4))){
var inst_13149 = (state_13181[(9)]);
var inst_13149__$1 = (state_13181[(2)]);
var inst_13150 = (inst_13149__$1 == null);
var inst_13151 = cljs.core.not.call(null,inst_13150);
var state_13181__$1 = (function (){var statearr_13186 = state_13181;
(statearr_13186[(9)] = inst_13149__$1);

return statearr_13186;
})();
if(inst_13151){
var statearr_13187_13218 = state_13181__$1;
(statearr_13187_13218[(1)] = (5));

} else {
var statearr_13188_13219 = state_13181__$1;
(statearr_13188_13219[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (15))){
var inst_13171 = (state_13181[(2)]);
var state_13181__$1 = state_13181;
var statearr_13189_13220 = state_13181__$1;
(statearr_13189_13220[(2)] = inst_13171);

(statearr_13189_13220[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (13))){
var state_13181__$1 = state_13181;
var statearr_13190_13221 = state_13181__$1;
(statearr_13190_13221[(2)] = null);

(statearr_13190_13221[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (6))){
var inst_13146 = (state_13181[(7)]);
var inst_13167 = (inst_13146 > (0));
var state_13181__$1 = state_13181;
if(cljs.core.truth_(inst_13167)){
var statearr_13191_13222 = state_13181__$1;
(statearr_13191_13222[(1)] = (12));

} else {
var statearr_13192_13223 = state_13181__$1;
(statearr_13192_13223[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (3))){
var inst_13179 = (state_13181[(2)]);
var state_13181__$1 = state_13181;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13181__$1,inst_13179);
} else {
if((state_val_13182 === (12))){
var inst_13145 = (state_13181[(8)]);
var inst_13169 = cljs.core.vec.call(null,inst_13145);
var state_13181__$1 = state_13181;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13181__$1,(15),out,inst_13169);
} else {
if((state_val_13182 === (2))){
var state_13181__$1 = state_13181;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13181__$1,(4),ch);
} else {
if((state_val_13182 === (11))){
var inst_13161 = (state_13181[(2)]);
var inst_13162 = (new Array(n));
var inst_13145 = inst_13162;
var inst_13146 = (0);
var state_13181__$1 = (function (){var statearr_13193 = state_13181;
(statearr_13193[(10)] = inst_13161);

(statearr_13193[(7)] = inst_13146);

(statearr_13193[(8)] = inst_13145);

return statearr_13193;
})();
var statearr_13194_13224 = state_13181__$1;
(statearr_13194_13224[(2)] = null);

(statearr_13194_13224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (9))){
var inst_13145 = (state_13181[(8)]);
var inst_13159 = cljs.core.vec.call(null,inst_13145);
var state_13181__$1 = state_13181;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13181__$1,(11),out,inst_13159);
} else {
if((state_val_13182 === (5))){
var inst_13146 = (state_13181[(7)]);
var inst_13145 = (state_13181[(8)]);
var inst_13149 = (state_13181[(9)]);
var inst_13154 = (state_13181[(11)]);
var inst_13153 = (inst_13145[inst_13146] = inst_13149);
var inst_13154__$1 = (inst_13146 + (1));
var inst_13155 = (inst_13154__$1 < n);
var state_13181__$1 = (function (){var statearr_13195 = state_13181;
(statearr_13195[(12)] = inst_13153);

(statearr_13195[(11)] = inst_13154__$1);

return statearr_13195;
})();
if(cljs.core.truth_(inst_13155)){
var statearr_13196_13225 = state_13181__$1;
(statearr_13196_13225[(1)] = (8));

} else {
var statearr_13197_13226 = state_13181__$1;
(statearr_13197_13226[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (14))){
var inst_13174 = (state_13181[(2)]);
var inst_13175 = cljs.core.async.close_BANG_.call(null,out);
var state_13181__$1 = (function (){var statearr_13199 = state_13181;
(statearr_13199[(13)] = inst_13174);

return statearr_13199;
})();
var statearr_13200_13227 = state_13181__$1;
(statearr_13200_13227[(2)] = inst_13175);

(statearr_13200_13227[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (10))){
var inst_13165 = (state_13181[(2)]);
var state_13181__$1 = state_13181;
var statearr_13201_13228 = state_13181__$1;
(statearr_13201_13228[(2)] = inst_13165);

(statearr_13201_13228[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13182 === (8))){
var inst_13145 = (state_13181[(8)]);
var inst_13154 = (state_13181[(11)]);
var tmp13198 = inst_13145;
var inst_13145__$1 = tmp13198;
var inst_13146 = inst_13154;
var state_13181__$1 = (function (){var statearr_13202 = state_13181;
(statearr_13202[(7)] = inst_13146);

(statearr_13202[(8)] = inst_13145__$1);

return statearr_13202;
})();
var statearr_13203_13229 = state_13181__$1;
(statearr_13203_13229[(2)] = null);

(statearr_13203_13229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10484__auto___13215,out))
;
return ((function (switch__10370__auto__,c__10484__auto___13215,out){
return (function() {
var cljs$core$async$state_machine__10371__auto__ = null;
var cljs$core$async$state_machine__10371__auto____0 = (function (){
var statearr_13207 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13207[(0)] = cljs$core$async$state_machine__10371__auto__);

(statearr_13207[(1)] = (1));

return statearr_13207;
});
var cljs$core$async$state_machine__10371__auto____1 = (function (state_13181){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_13181);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e13208){if((e13208 instanceof Object)){
var ex__10374__auto__ = e13208;
var statearr_13209_13230 = state_13181;
(statearr_13209_13230[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13181);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13208;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13231 = state_13181;
state_13181 = G__13231;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$state_machine__10371__auto__ = function(state_13181){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10371__auto____1.call(this,state_13181);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10371__auto____0;
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10371__auto____1;
return cljs$core$async$state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto___13215,out))
})();
var state__10486__auto__ = (function (){var statearr_13210 = f__10485__auto__.call(null);
(statearr_13210[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto___13215);

return statearr_13210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto___13215,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args13232 = [];
var len__8628__auto___13306 = arguments.length;
var i__8629__auto___13307 = (0);
while(true){
if((i__8629__auto___13307 < len__8628__auto___13306)){
args13232.push((arguments[i__8629__auto___13307]));

var G__13308 = (i__8629__auto___13307 + (1));
i__8629__auto___13307 = G__13308;
continue;
} else {
}
break;
}

var G__13234 = args13232.length;
switch (G__13234) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13232.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10484__auto___13310 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10484__auto___13310,out){
return (function (){
var f__10485__auto__ = (function (){var switch__10370__auto__ = ((function (c__10484__auto___13310,out){
return (function (state_13276){
var state_val_13277 = (state_13276[(1)]);
if((state_val_13277 === (7))){
var inst_13272 = (state_13276[(2)]);
var state_13276__$1 = state_13276;
var statearr_13278_13311 = state_13276__$1;
(statearr_13278_13311[(2)] = inst_13272);

(statearr_13278_13311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13277 === (1))){
var inst_13235 = [];
var inst_13236 = inst_13235;
var inst_13237 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13276__$1 = (function (){var statearr_13279 = state_13276;
(statearr_13279[(7)] = inst_13236);

(statearr_13279[(8)] = inst_13237);

return statearr_13279;
})();
var statearr_13280_13312 = state_13276__$1;
(statearr_13280_13312[(2)] = null);

(statearr_13280_13312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13277 === (4))){
var inst_13240 = (state_13276[(9)]);
var inst_13240__$1 = (state_13276[(2)]);
var inst_13241 = (inst_13240__$1 == null);
var inst_13242 = cljs.core.not.call(null,inst_13241);
var state_13276__$1 = (function (){var statearr_13281 = state_13276;
(statearr_13281[(9)] = inst_13240__$1);

return statearr_13281;
})();
if(inst_13242){
var statearr_13282_13313 = state_13276__$1;
(statearr_13282_13313[(1)] = (5));

} else {
var statearr_13283_13314 = state_13276__$1;
(statearr_13283_13314[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13277 === (15))){
var inst_13266 = (state_13276[(2)]);
var state_13276__$1 = state_13276;
var statearr_13284_13315 = state_13276__$1;
(statearr_13284_13315[(2)] = inst_13266);

(statearr_13284_13315[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13277 === (13))){
var state_13276__$1 = state_13276;
var statearr_13285_13316 = state_13276__$1;
(statearr_13285_13316[(2)] = null);

(statearr_13285_13316[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13277 === (6))){
var inst_13236 = (state_13276[(7)]);
var inst_13261 = inst_13236.length;
var inst_13262 = (inst_13261 > (0));
var state_13276__$1 = state_13276;
if(cljs.core.truth_(inst_13262)){
var statearr_13286_13317 = state_13276__$1;
(statearr_13286_13317[(1)] = (12));

} else {
var statearr_13287_13318 = state_13276__$1;
(statearr_13287_13318[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13277 === (3))){
var inst_13274 = (state_13276[(2)]);
var state_13276__$1 = state_13276;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13276__$1,inst_13274);
} else {
if((state_val_13277 === (12))){
var inst_13236 = (state_13276[(7)]);
var inst_13264 = cljs.core.vec.call(null,inst_13236);
var state_13276__$1 = state_13276;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13276__$1,(15),out,inst_13264);
} else {
if((state_val_13277 === (2))){
var state_13276__$1 = state_13276;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13276__$1,(4),ch);
} else {
if((state_val_13277 === (11))){
var inst_13244 = (state_13276[(10)]);
var inst_13240 = (state_13276[(9)]);
var inst_13254 = (state_13276[(2)]);
var inst_13255 = [];
var inst_13256 = inst_13255.push(inst_13240);
var inst_13236 = inst_13255;
var inst_13237 = inst_13244;
var state_13276__$1 = (function (){var statearr_13288 = state_13276;
(statearr_13288[(11)] = inst_13256);

(statearr_13288[(7)] = inst_13236);

(statearr_13288[(8)] = inst_13237);

(statearr_13288[(12)] = inst_13254);

return statearr_13288;
})();
var statearr_13289_13319 = state_13276__$1;
(statearr_13289_13319[(2)] = null);

(statearr_13289_13319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13277 === (9))){
var inst_13236 = (state_13276[(7)]);
var inst_13252 = cljs.core.vec.call(null,inst_13236);
var state_13276__$1 = state_13276;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13276__$1,(11),out,inst_13252);
} else {
if((state_val_13277 === (5))){
var inst_13237 = (state_13276[(8)]);
var inst_13244 = (state_13276[(10)]);
var inst_13240 = (state_13276[(9)]);
var inst_13244__$1 = f.call(null,inst_13240);
var inst_13245 = cljs.core._EQ_.call(null,inst_13244__$1,inst_13237);
var inst_13246 = cljs.core.keyword_identical_QMARK_.call(null,inst_13237,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_13247 = (inst_13245) || (inst_13246);
var state_13276__$1 = (function (){var statearr_13290 = state_13276;
(statearr_13290[(10)] = inst_13244__$1);

return statearr_13290;
})();
if(cljs.core.truth_(inst_13247)){
var statearr_13291_13320 = state_13276__$1;
(statearr_13291_13320[(1)] = (8));

} else {
var statearr_13292_13321 = state_13276__$1;
(statearr_13292_13321[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13277 === (14))){
var inst_13269 = (state_13276[(2)]);
var inst_13270 = cljs.core.async.close_BANG_.call(null,out);
var state_13276__$1 = (function (){var statearr_13294 = state_13276;
(statearr_13294[(13)] = inst_13269);

return statearr_13294;
})();
var statearr_13295_13322 = state_13276__$1;
(statearr_13295_13322[(2)] = inst_13270);

(statearr_13295_13322[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13277 === (10))){
var inst_13259 = (state_13276[(2)]);
var state_13276__$1 = state_13276;
var statearr_13296_13323 = state_13276__$1;
(statearr_13296_13323[(2)] = inst_13259);

(statearr_13296_13323[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13277 === (8))){
var inst_13236 = (state_13276[(7)]);
var inst_13244 = (state_13276[(10)]);
var inst_13240 = (state_13276[(9)]);
var inst_13249 = inst_13236.push(inst_13240);
var tmp13293 = inst_13236;
var inst_13236__$1 = tmp13293;
var inst_13237 = inst_13244;
var state_13276__$1 = (function (){var statearr_13297 = state_13276;
(statearr_13297[(7)] = inst_13236__$1);

(statearr_13297[(8)] = inst_13237);

(statearr_13297[(14)] = inst_13249);

return statearr_13297;
})();
var statearr_13298_13324 = state_13276__$1;
(statearr_13298_13324[(2)] = null);

(statearr_13298_13324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10484__auto___13310,out))
;
return ((function (switch__10370__auto__,c__10484__auto___13310,out){
return (function() {
var cljs$core$async$state_machine__10371__auto__ = null;
var cljs$core$async$state_machine__10371__auto____0 = (function (){
var statearr_13302 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13302[(0)] = cljs$core$async$state_machine__10371__auto__);

(statearr_13302[(1)] = (1));

return statearr_13302;
});
var cljs$core$async$state_machine__10371__auto____1 = (function (state_13276){
while(true){
var ret_value__10372__auto__ = (function (){try{while(true){
var result__10373__auto__ = switch__10370__auto__.call(null,state_13276);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10373__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10373__auto__;
}
break;
}
}catch (e13303){if((e13303 instanceof Object)){
var ex__10374__auto__ = e13303;
var statearr_13304_13325 = state_13276;
(statearr_13304_13325[(5)] = ex__10374__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13276);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13303;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10372__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13326 = state_13276;
state_13276 = G__13326;
continue;
} else {
return ret_value__10372__auto__;
}
break;
}
});
cljs$core$async$state_machine__10371__auto__ = function(state_13276){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10371__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10371__auto____1.call(this,state_13276);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10371__auto____0;
cljs$core$async$state_machine__10371__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10371__auto____1;
return cljs$core$async$state_machine__10371__auto__;
})()
;})(switch__10370__auto__,c__10484__auto___13310,out))
})();
var state__10486__auto__ = (function (){var statearr_13305 = f__10485__auto__.call(null);
(statearr_13305[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10484__auto___13310);

return statearr_13305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10486__auto__);
});})(c__10484__auto___13310,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map