(ns nha.lein
  (:require [boot.core :as core :refer [deftask with-pre-wrap]]
            [boot.util]))

(defn- generate-lein-project-file!
  "Generates leiningen project file."
  []
  (require 'clojure.java.io)
  (let [pfile ((resolve 'clojure.java.io/file) "project.clj")
        ; Only works when pom options are set using task-options!
        {:keys [project version]} (:task-options (meta #'boot.task.built-in/pom))
        prop #(when-let [x (core/get-env %2)] [%1 x])
        head (list* 'defproject (or project 'boot-project) (or version "0.0.0-SNAPSHOT")
               (concat
                 (prop :url :url)
                 (prop :license :license)
                 (prop :description :description)
                 [:dependencies (core/get-env :dependencies)
                  :source-paths (vec (concat (core/get-env :source-paths)
                                             (core/get-env :resource-paths)))
                  :repositories (core/get-env :repositories)]))
        proj (boot.util/pp-str head)]
      ;;(.deleteOnExit pfile)
      (spit pfile proj)))

(deftask lein-generate
  "Generate a leiningen `project.clj` file.
   This task generates a leiningen `project.clj` file based on the boot
   environment configuration, including project name and version (generated
   if not present), dependencies, and source paths. Additional keys may be added
   to the generated `project.clj` file by specifying a `:lein` key in the boot
   environment whose value is a map of keys-value pairs to add to `project.clj`."
  []
  (with-pre-wrap fileset
    (boot.util/info "Regenerating project clj...\n")
    (generate-lein-project-file! :keep-project true)
    fileset))
