/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Selector;
import nginx.clojure.NginxHttpServerChannel;
import org.apache.coyote.http11.NginxEndpoint;
import org.apache.tomcat.util.net.SecureNioChannel;
import org.apache.tomcat.util.res.StringManager;

public class NginxChannel
implements ByteChannel {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.net.res");
    protected static ByteBuffer emptyBuf = ByteBuffer.allocate(0);
    protected NginxHttpServerChannel sc = null;
    protected NginxEndpoint.KeyAttachment attachment;
    protected SecureNioChannel.ApplicationBufferHandler bufHandler;
    protected NginxEndpoint.SendfileData sendfileData = null;
    protected boolean sendFile = false;
    protected boolean ignoreNginxFilter = false;
    boolean closed = false;

    public NginxChannel(NginxHttpServerChannel channel, SecureNioChannel.ApplicationBufferHandler bufHandler, boolean ignoreNginxFilter) {
        this.sc = channel;
        this.bufHandler = bufHandler;
        this.ignoreNginxFilter = ignoreNginxFilter;
    }

    public void reset() throws IOException {
        this.bufHandler.getReadBuffer().clear();
        this.bufHandler.getWriteBuffer().clear();
        this.sendFile = false;
        this.sendfileData = null;
        this.closed = false;
    }

    public int getBufferSize() {
        if (this.bufHandler == null) {
            return 0;
        }
        int size = 0;
        size += this.bufHandler.getReadBuffer() != null ? this.bufHandler.getReadBuffer().capacity() : 0;
        return size += this.bufHandler.getWriteBuffer() != null ? this.bufHandler.getWriteBuffer().capacity() : 0;
    }

    public boolean flush(boolean block, Selector s, long timeout) throws IOException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        NginxChannel nginxChannel = this;
        synchronized (nginxChannel) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.getIOChannel().close();
    }

    public void close(boolean force) throws IOException {
        if (this.isOpen() || force) {
            this.close();
        }
    }

    @Override
    public boolean isOpen() {
        return !this.sc.isClosed();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.checkInterruptStatus();
        return (int)this.sc.write(src);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return (int)this.sc.read(dst);
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public SecureNioChannel.ApplicationBufferHandler getBufHandler() {
        return this.bufHandler;
    }

    public NginxHttpServerChannel getIOChannel() {
        return this.sc;
    }

    public boolean isClosing() {
        return false;
    }

    public boolean isHandshakeComplete() {
        return true;
    }

    public int handshake(boolean read, boolean write) throws IOException {
        return 0;
    }

    public void setIOChannel(NginxHttpServerChannel IOChannel) {
        this.sc = IOChannel;
    }

    public String toString() {
        return super.toString() + ":" + this.sc.toString();
    }

    public int getOutboundRemaining() {
        return 0;
    }

    public boolean flushOutbound() throws IOException {
        return false;
    }

    public boolean isSendFile() {
        return this.sendFile;
    }

    public void setSendFile(boolean s) {
        this.sendFile = s;
    }

    protected void checkInterruptStatus() throws IOException {
        if (Thread.interrupted()) {
            throw new IOException(sm.getString("channel.nio.interrupted"));
        }
    }
}

