/*
 * Decompiled with CFR 0.152.
 */
package nginx.clojure.tomcat8;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import nginx.clojure.NginxClojureRT;
import nginx.clojure.bridge.NginxBridge;
import nginx.clojure.java.NginxJavaRequest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.security.SecurityClassLoad;
import org.apache.catalina.startup.Bootstrap;
import org.apache.catalina.startup.Catalina;
import org.apache.coyote.http11.NginxDirectProtocol;
import org.apache.coyote.http11.NginxEndpoint;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class NginxTomcatBridge
extends Catalina
implements NginxBridge {
    protected NginxDirectProtocol nginxDirectProtocol;
    protected static final Log log = LogFactory.getLog(NginxTomcatBridge.class);
    protected boolean ignoreNginxFilter = false;
    protected boolean dispatch = false;
    protected ClassLoader bootLoader;
    int i = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initWithoutStartServer() {
        File file;
        InputStream inputStream;
        InputSource inputSource;
        Digester digester;
        block29: {
            block28: {
                block27: {
                    this.initDirs();
                    this.initNaming();
                    digester = this.createStartDigester();
                    inputSource = null;
                    inputStream = null;
                    file = null;
                    try {
                        file = this.configFile();
                        inputStream = new FileInputStream(file);
                        inputSource = new InputSource(file.toURI().toURL().toString());
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block27;
                        log.debug((Object)sm.getString("catalina.configFail", new Object[]{file}), (Throwable)e);
                    }
                }
                if (inputStream == null) {
                    try {
                        inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.getConfigFile());
                        inputSource = new InputSource(((Object)((Object)this)).getClass().getClassLoader().getResource(this.getConfigFile()).toString());
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block28;
                        log.debug((Object)sm.getString("catalina.configFail", new Object[]{this.getConfigFile()}), (Throwable)e);
                    }
                }
            }
            if (inputStream == null) {
                try {
                    inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("server-embed.xml");
                    inputSource = new InputSource(((Object)((Object)this)).getClass().getClassLoader().getResource("server-embed.xml").toString());
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block29;
                    log.debug((Object)sm.getString("catalina.configFail", new Object[]{"server-embed.xml"}), (Throwable)e);
                }
            }
        }
        if (inputStream == null || inputSource == null) {
            if (file == null) {
                log.warn((Object)sm.getString("catalina.configFail", new Object[]{this.getConfigFile() + "] or [server-embed.xml]"}));
            } else {
                log.warn((Object)sm.getString("catalina.configFail", new Object[]{file.getAbsolutePath()}));
                if (file.exists() && !file.canRead()) {
                    log.warn((Object)"Permissions incorrect, read permission is not allowed on the file.");
                }
            }
            return;
        }
        try {
            inputSource.setByteStream(inputStream);
            digester.push((Object)this);
            digester.parse(inputSource);
        }
        catch (SAXParseException spe) {
            log.warn((Object)("Catalina.start using " + this.getConfigFile() + ": " + spe.getMessage()));
            return;
        }
        catch (Exception e) {
            log.warn((Object)("Catalina.start using " + this.getConfigFile() + ": "), (Throwable)e);
            return;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.getServer().setCatalina((Catalina)this);
        this.getServer().setCatalinaHome(new File(Bootstrap.getCatalinaHome()));
        this.getServer().setCatalinaBase(new File(Bootstrap.getCatalinaBase()));
        this.initStreams();
    }

    public void boot(Map<String, String> properties, ClassLoader loader) {
        if (this.nginxDirectProtocol != null) {
            return;
        }
        this.bootLoader = loader;
        long t1 = System.nanoTime();
        try {
            Field urlFactory = URL.class.getDeclaredField("factory");
            Object base = NginxClojureRT.UNSAFE.staticFieldBase(urlFactory);
            NginxClojureRT.UNSAFE.putObject(base, NginxClojureRT.UNSAFE.staticFieldOffset(urlFactory), null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        String tomcatHome = System.getProperty("catalina.home");
        if (tomcatHome == null) {
            NginxClojureRT.getLog().error((Object)"system.catalina.home should be set!");
            return;
        }
        Log log = LogFactory.getLog(Catalina.class);
        log.info((Object)("tomcatHome=" + tomcatHome + ", conf=" + this.configFile));
        try {
            String dispatchStr;
            String ignoreNginxFilterStr;
            ClassLoader catalinaLoader = ((Object)((Object)this)).getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(catalinaLoader);
            SecurityClassLoad.securityClassLoad((ClassLoader)catalinaLoader);
            this.initWithoutStartServer();
            Field protocolHandlerField = Connector.class.getDeclaredField("protocolHandler");
            protocolHandlerField.setAccessible(true);
            Connector httpConnector = null;
            Service httpService = null;
            Server server = this.getServer();
            for (Service s : server.findServices()) {
                for (Connector c : s.findConnectors()) {
                    if (c.getProtocol().equals("HTTP/1.1")) {
                        httpConnector = c;
                        httpService = s;
                        this.nginxDirectProtocol = new NginxDirectProtocol();
                        this.nginxDirectProtocol.setAdapter(c.getProtocolHandler().getAdapter());
                        c.setProtocol(NginxDirectProtocol.class.getName());
                        protocolHandlerField.set(c, (Object)this.nginxDirectProtocol);
                        continue;
                    }
                    s.removeConnector(c);
                }
            }
            try {
                this.getServer().init();
            }
            catch (LifecycleException e) {
                if (Boolean.getBoolean("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE")) {
                    throw new Error(e);
                }
                log.error((Object)"Catalina.start", (Throwable)e);
            }
            this.start();
            this.nginxDirectProtocol = (NginxDirectProtocol)httpConnector.getProtocolHandler();
            long t2 = System.nanoTime();
            if (log.isInfoEnabled()) {
                log.info((Object)("Initialization processed in " + (t2 - t1) / 1000000L + " ms"));
            }
            if ((ignoreNginxFilterStr = properties.get("ignoreNginxFilter")) != null) {
                this.ignoreNginxFilter = Boolean.parseBoolean(ignoreNginxFilterStr);
            }
            if ((dispatchStr = properties.get("dispatch")) != null) {
                this.dispatch = Boolean.parseBoolean(dispatchStr);
            }
        }
        catch (Throwable t) {
            NginxClojureRT.getLog().error((Object)"can not start tomcat server", t);
            return;
        }
    }

    public ClassLoader getClassLoader() {
        return this.bootLoader;
    }

    public Object[] handle(NginxJavaRequest req) throws IOException {
        NginxEndpoint nginxEndpoint = this.nginxDirectProtocol.getEndpoint();
        req.get((Object)"body");
        req.get((Object)"remote-addr");
        nginxEndpoint.accept(req, this.ignoreNginxFilter, this.dispatch);
        return null;
    }
}

