/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpUpgradeHandler;
import nginx.clojure.ChannelListener;
import nginx.clojure.NginxHttpServerChannel;
import org.apache.coyote.AbstractProcessor;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.coyote.http11.NginxChannel;
import org.apache.coyote.http11.NginxEndpoint;
import org.apache.coyote.http11.NginxTomcatHttp11Processor;
import org.apache.coyote.http11.upgrade.NginxUpgradeProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class NginxDirectProtocol
extends AbstractHttp11JsseProtocol<NginxChannel> {
    private static final Log log = LogFactory.getLog(NginxDirectProtocol.class);
    private final Http11ConnectionHandler cHandler;

    public NginxDirectProtocol() {
        this.endpoint = new NginxEndpoint();
        this.endpoint.setMaxConnections(-1);
        this.cHandler = new Http11ConnectionHandler(this);
        ((NginxEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
    }

    public NginxEndpoint getEndpoint() {
        return (NginxEndpoint)this.endpoint;
    }

    protected Log getLog() {
        return log;
    }

    protected String getNamePrefix() {
        return "http-nginx";
    }

    protected NginxEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    protected static class Http11ConnectionHandler
    extends AbstractProtocol.AbstractConnectionHandler<NginxChannel, NginxTomcatHttp11Processor>
    implements NginxEndpoint.Handler {
        protected NginxDirectProtocol proto;

        Http11ConnectionHandler(NginxDirectProtocol proto) {
            this.proto = proto;
        }

        protected AbstractProtocol<NginxChannel> getProtocol() {
            return this.proto;
        }

        protected Log getLog() {
            return log;
        }

        @Override
        public void release(NginxHttpServerChannel socket) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Iterating through our connections to release a socket channel:" + socket));
            }
            boolean released = false;
            Iterator it = this.connections.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (((NginxChannel)entry.getKey()).getIOChannel() != socket) continue;
                it.remove();
                Processor result = (Processor)entry.getValue();
                result.recycle(true);
                this.unregister(result);
                released = true;
                break;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Done iterating through our connections to release a socket channel:" + socket + " released:" + released));
            }
        }

        @Override
        public void release(SocketWrapper<NginxChannel> socket) {
            Processor processor = (Processor)this.connections.remove(socket.getSocket());
            if (processor != null) {
                processor.recycle(true);
                this.recycledProcessors.push(processor);
            }
        }

        @Override
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<NginxChannel> socket, SocketStatus status) {
            return super.process(socket, status);
        }

        public void release(SocketWrapper<NginxChannel> socket, Processor<NginxChannel> processor, boolean isSocketClosing, boolean addToPoller) {
            processor.recycle(isSocketClosing);
            this.recycledProcessors.push(processor);
        }

        protected void initSsl(SocketWrapper<NginxChannel> socket, Processor<NginxChannel> processor) {
        }

        protected void longPoll(SocketWrapper<NginxChannel> socket, Processor<NginxChannel> processor) {
            if (processor.isAsync()) {
                socket.setAsync(true);
            }
        }

        public NginxTomcatHttp11Processor createProcessor() {
            NginxTomcatHttp11Processor processor = new NginxTomcatHttp11Processor(this.proto.getMaxHttpHeaderSize(), (NginxEndpoint)this.proto.endpoint, this.proto.getMaxTrailerSize(), this.proto.getAllowedTrailerHeadersAsSet(), this.proto.getMaxExtensionSize(), this.proto.getMaxSwallowSize());
            this.proto.configureProcessor(processor);
            this.register((AbstractProcessor)processor);
            return processor;
        }

        protected Processor<NginxChannel> createUpgradeProcessor(SocketWrapper<NginxChannel> socket, ByteBuffer leftoverInput, HttpUpgradeHandler httpUpgradeProcessor) throws IOException {
            NginxUpgradeProcessor processor = new NginxUpgradeProcessor(socket, leftoverInput, httpUpgradeProcessor);
            if (((NginxChannel)socket.getSocket()).ignoreNginxFilter) {
                ((NginxChannel)socket.getSocket()).getIOChannel().turnOnEventHandler(true, true, true);
            }
            ((NginxChannel)socket.getSocket()).getIOChannel().addListener(socket, (ChannelListener)((NginxEndpoint)this.proto.endpoint));
            return processor;
        }
    }
}

