/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.NginxChannel;
import org.apache.coyote.http11.NginxEndpoint;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;

public class InternalNginxOutputBuffer
extends AbstractOutputBuffer<NginxChannel> {
    protected NginxChannel socket;
    protected volatile boolean flipped = false;

    protected InternalNginxOutputBuffer(Response response, int headerBufferSize) {
        super(response, headerBufferSize);
        this.outputStreamOutputBuffer = new HttpChannelOutputBuffer();
    }

    public void init(SocketWrapper<NginxChannel> socketWrapper, AbstractEndpoint<NginxChannel> endpoint) throws IOException {
        this.socket = (NginxChannel)socketWrapper.getSocket();
    }

    public void addActiveFilter(OutputFilter filter) {
        if (this.socket.ignoreNginxFilter) {
            super.addActiveFilter(filter);
        }
    }

    public void sendAck() throws IOException {
        if (!this.committed) {
            this.socket.getBufHandler().getWriteBuffer().put(Constants.ACK_BYTES, 0, Constants.ACK_BYTES.length);
            int result = this.writeToSocket(this.socket.getBufHandler().getWriteBuffer(), true, true);
            if (result < 0) {
                throw new IOException(sm.getString("iob.failedwrite.ack"));
            }
        }
    }

    protected synchronized int writeToSocket(byte[] buf, int pos, int len) throws IOException {
        try {
            this.socket.getIOChannel().send(buf, pos, len, true, false);
        }
        catch (RuntimeException e) {
            throw new IOException(e.getMessage(), e);
        }
        return len;
    }

    protected synchronized int writeToSocket(ByteBuffer bytebuffer, boolean block, boolean flip) throws IOException {
        if (flip) {
            bytebuffer.flip();
            this.flipped = true;
        }
        int written = bytebuffer.remaining();
        NginxEndpoint.KeyAttachment att = (NginxEndpoint.KeyAttachment)((Object)this.socket.getAttachment());
        if (att == null) {
            throw new IOException("Key must be cancelled");
        }
        this.socket.getIOChannel().send(bytebuffer, true, false);
        if (block || bytebuffer.remaining() == 0) {
            bytebuffer.clear();
            this.flipped = false;
        }
        return written;
    }

    protected void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0 && (!this.socket.isSendFile() || this.socket.getIOChannel().isIgnoreFilter())) {
            this.socket.getIOChannel().sendHeader(this.headerBuffer, 0, this.pos, true, false);
        }
    }

    public void endRequest() throws IOException {
        if (this.finished) {
            return;
        }
        super.endRequest();
        if (!this.socket.isSendFile() || this.socket.getIOChannel().isIgnoreFilter()) {
            this.socket.close();
        }
    }

    protected boolean hasMoreDataToFlush() {
        return false;
    }

    protected void registerWriteInterest() throws IOException {
    }

    protected boolean flushBuffer(boolean block) throws IOException {
        try {
            this.socket.getIOChannel().flush();
        }
        catch (RuntimeException e) {
            throw new IOException(e.getMessage(), e);
        }
        return false;
    }

    protected class HttpChannelOutputBuffer
    implements OutputBuffer {
        public long getBytesWritten() {
            return InternalNginxOutputBuffer.this.byteCount;
        }

        public int doWrite(ByteChunk chunk, Response response) throws IOException {
            int c = InternalNginxOutputBuffer.this.writeToSocket(chunk.getBuffer(), chunk.getStart(), chunk.getLength());
            InternalNginxOutputBuffer.this.byteCount += (long)c;
            return c;
        }
    }
}

