/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpUpgradeHandler;
import nginx.clojure.MiniConstants;
import org.apache.coyote.http11.NginxChannel;
import org.apache.coyote.http11.upgrade.AbstractProcessor;
import org.apache.coyote.http11.upgrade.AbstractServletInputStream;
import org.apache.coyote.http11.upgrade.AbstractServletOutputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SocketWrapper;

public class NginxUpgradeProcessor
extends AbstractProcessor<NginxChannel> {
    protected NginxChannel channel;
    protected WebConnectionInputStream inputStream = (WebConnectionInputStream)this.getInputStream();
    protected WebConnectionOutputStream outputStream = (WebConnectionOutputStream)this.getOutputStream();
    protected static final Log log = LogFactory.getLog(NginxUpgradeProcessor.class);

    public NginxUpgradeProcessor(SocketWrapper<NginxChannel> socket, ByteBuffer leftoverInput, HttpUpgradeHandler httpUpgradeProcessor) throws IOException {
        super(httpUpgradeProcessor, (AbstractServletInputStream)new WebConnectionInputStream((NginxChannel)socket.getSocket()), (AbstractServletOutputStream)new WebConnectionOutputStream(socket));
        this.channel = (NginxChannel)socket.getSocket();
        ByteBuffer readBuffer = ((NginxChannel)socket.getSocket()).getBufHandler().getReadBuffer();
        if (leftoverInput != null) {
            if (readBuffer.remaining() > 0) {
                readBuffer.flip();
            } else {
                readBuffer.clear();
            }
            readBuffer.put(leftoverInput);
            readBuffer.flip();
        } else {
            readBuffer.flip();
        }
    }

    protected Log getLog() {
        return log;
    }

    public void close() throws Exception {
        this.channel.close();
    }

    public static class WebConnectionOutputStream
    extends AbstractServletOutputStream<NginxChannel> {
        protected NginxChannel channel;
        protected WriteListener listener;
        protected boolean eof = false;
        protected int maxWrite;

        public WebConnectionOutputStream(SocketWrapper<NginxChannel> socket) {
            super(socket, MiniConstants.NGINX_CLOJURE_CORE_CLIENT_HEADER_MAX_SIZE);
            this.channel = (NginxChannel)socket.getSocket();
            this.maxWrite = ((NginxChannel)socket.getSocket()).getBufHandler().getWriteBuffer().capacity();
        }

        protected int doWrite(boolean block, byte[] b, int off, int len) throws IOException {
            int writtenThisLoop;
            int count = 0;
            int offset = off;
            for (int leftToWrite = len; leftToWrite > 0; leftToWrite -= writtenThisLoop) {
                int writeThisLoop = leftToWrite > this.maxWrite ? this.maxWrite : leftToWrite;
                writtenThisLoop = this.doWriteInternal(block, b, offset, writeThisLoop);
                count += writtenThisLoop;
                offset += writtenThisLoop;
                if (writtenThisLoop != 0) continue;
                break;
            }
            return count;
        }

        private int doWriteInternal(boolean block, byte[] b, int off, int len) throws IOException {
            this.channel.getBufHandler().getWriteBuffer().clear();
            this.channel.getBufHandler().getWriteBuffer().put(b, off, len);
            this.channel.getBufHandler().getWriteBuffer().flip();
            return this.channel.write(this.channel.getBufHandler().getWriteBuffer());
        }

        protected void doClose() throws IOException {
            this.eof = true;
            this.channel.close();
        }

        protected void doFlush() throws IOException {
        }
    }

    public static class SimpleBufferChain {
        public ByteBuffer buffer;
        public SimpleBufferChain next;
    }

    protected static class WebConnectionInputStream
    extends AbstractServletInputStream {
        protected NginxChannel channel;
        protected boolean eof = false;

        public WebConnectionInputStream(NginxChannel channel) {
            this.channel = channel;
        }

        protected void onClose() {
            if (this.eof) {
                return;
            }
            this.eof = true;
        }

        protected boolean doIsReady() throws IOException {
            ByteBuffer buffer = this.channel.getBufHandler().getReadBuffer();
            if (buffer.remaining() > 0) {
                return true;
            }
            buffer.clear();
            this.channel.read(buffer);
            boolean isReady = buffer.position() > 0;
            buffer.flip();
            return isReady;
        }

        protected int doRead(boolean block, byte[] b, int off, int len) throws IOException {
            ByteBuffer buffer = this.channel.getBufHandler().getReadBuffer();
            int remaining = buffer.remaining();
            if (remaining >= len) {
                buffer.get(b, off, len);
                return len;
            }
            int leftToWrite = len;
            int newOffset = off;
            if (remaining > 0) {
                buffer.get(b, off, remaining);
                leftToWrite -= remaining;
                newOffset += remaining;
            }
            buffer.clear();
            int nRead = this.channel.read(buffer);
            if (nRead > 0) {
                buffer.flip();
                if (nRead > leftToWrite) {
                    buffer.get(b, newOffset, leftToWrite);
                    leftToWrite = 0;
                } else {
                    buffer.get(b, newOffset, nRead);
                    leftToWrite -= nRead;
                }
            } else if (nRead == 0) {
                buffer.flip();
            }
            return len - leftToWrite;
        }

        protected void doClose() throws IOException {
            this.eof = true;
            this.channel.close();
        }
    }
}

