/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import nginx.clojure.MiniConstants;
import nginx.clojure.java.NginxJavaRequest;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ErrorState;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.InternalNginxInputBuffer;
import org.apache.coyote.http11.InternalNginxOutputBuffer;
import org.apache.coyote.http11.NginxChannel;
import org.apache.coyote.http11.NginxEndpoint;
import org.apache.coyote.http11.OutputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class NginxTomcatHttp11Processor
extends AbstractHttp11Processor<NginxChannel> {
    protected static final Log log = LogFactory.getLog(NginxTomcatHttp11Processor.class);
    protected NginxEndpoint.SendfileData sendfileData = null;

    public NginxTomcatHttp11Processor(int maxHttpHeaderSize, NginxEndpoint endpoint, int maxTrailerSize, int maxExtensionSize, int maxSwallowSize) {
        super((AbstractEndpoint)endpoint);
        this.inputBuffer = new InternalNginxInputBuffer(this.request, maxHttpHeaderSize);
        this.request.setInputBuffer((InputBuffer)this.inputBuffer);
        this.outputBuffer = new InternalNginxOutputBuffer(this.response, maxHttpHeaderSize);
        this.response.setOutputBuffer((OutputBuffer)this.outputBuffer);
        this.initializeFilters(maxTrailerSize, maxExtensionSize, maxSwallowSize);
    }

    public void setSslSupport(SSLSupport sslSupport) {
    }

    protected AbstractInputBuffer<NginxChannel> getInputBuffer() {
        return this.inputBuffer;
    }

    protected AbstractOutputBuffer<NginxChannel> getOutputBuffer() {
        return this.outputBuffer;
    }

    void actionInternal(ActionCode actionCode, Object param) {
        switch (actionCode) {
            case REQ_HOST_ADDR_ATTRIBUTE: {
                if (this.socketWrapper == null) {
                    this.request.remoteAddr().recycle();
                    break;
                }
                if (this.socketWrapper.getRemoteAddr() == null) {
                    NginxJavaRequest nreq = (NginxJavaRequest)((NginxChannel)this.socketWrapper.getSocket()).getIOChannel().request();
                    this.socketWrapper.setRemoteAddr((String)nreq.get((Object)"remote-addr"));
                }
                this.request.remoteAddr().setString(this.socketWrapper.getRemoteAddr());
                break;
            }
            case REQ_LOCAL_NAME_ATTRIBUTE: {
                if (this.socketWrapper == null) {
                    this.request.localName().recycle();
                    break;
                }
                if (this.socketWrapper.getLocalName() == null) {
                    NginxJavaRequest nreq = (NginxJavaRequest)((NginxChannel)this.socketWrapper.getSocket()).getIOChannel().request();
                    String serverAddr = nreq.getVariable("server_addr");
                    InetAddress inetAddr = null;
                    try {
                        inetAddr = InetAddress.getByName(serverAddr);
                    }
                    catch (UnknownHostException e) {
                        log.error((Object)"can not get local server name", (Throwable)e);
                    }
                    if (inetAddr != null) {
                        this.socketWrapper.setLocalName(inetAddr.getHostName());
                    }
                }
                this.request.localName().setString(this.socketWrapper.getLocalName());
                break;
            }
            case REQ_HOST_ATTRIBUTE: {
                if (this.socketWrapper == null) {
                    this.request.remoteHost().recycle();
                    break;
                }
                if (this.socketWrapper.getRemoteHost() == null && this.socketWrapper.getRemoteHost() == null) {
                    if (this.socketWrapper.getRemoteAddr() == null) {
                        NginxJavaRequest nreq = (NginxJavaRequest)((NginxChannel)this.socketWrapper.getSocket()).getIOChannel().request();
                        this.socketWrapper.setRemoteAddr((String)nreq.get((Object)"remote-addr"));
                    }
                    if (this.socketWrapper.getRemoteAddr() != null) {
                        this.socketWrapper.setRemoteHost(this.socketWrapper.getRemoteAddr());
                    }
                }
                this.request.remoteHost().setString(this.socketWrapper.getRemoteHost());
                break;
            }
            case REQ_LOCAL_ADDR_ATTRIBUTE: {
                if (this.socketWrapper == null) {
                    this.request.localAddr().recycle();
                    break;
                }
                if (this.socketWrapper.getLocalAddr() == null) {
                    NginxJavaRequest nreq = (NginxJavaRequest)((NginxChannel)this.socketWrapper.getSocket()).getIOChannel().request();
                    String serverAddr = nreq.getVariable("server_addr");
                    this.socketWrapper.setLocalAddr(serverAddr);
                }
                this.request.localAddr().setString(this.socketWrapper.getLocalAddr());
                break;
            }
            case REQ_REMOTEPORT_ATTRIBUTE: {
                if (this.socketWrapper == null) {
                    this.request.setRemotePort(0);
                    break;
                }
                if (this.socketWrapper.getRemotePort() == -1) {
                    NginxJavaRequest nreq = (NginxJavaRequest)((NginxChannel)this.socketWrapper.getSocket()).getIOChannel().request();
                    String remotePort = nreq.getVariable("remote_port");
                    this.socketWrapper.setRemotePort(Integer.parseInt(remotePort));
                }
                this.request.setRemotePort(this.socketWrapper.getRemotePort());
                break;
            }
            case REQ_LOCALPORT_ATTRIBUTE: {
                if (this.socketWrapper == null) {
                    this.request.setLocalPort(0);
                    break;
                }
                if (this.socketWrapper.getLocalPort() == -1) {
                    NginxJavaRequest nreq = (NginxJavaRequest)((NginxChannel)this.socketWrapper.getSocket()).getIOChannel().request();
                    String localPort = nreq.getVariable("server_port");
                    this.socketWrapper.setLocalPort(Integer.parseInt(localPort));
                }
                this.request.setLocalPort(this.socketWrapper.getLocalPort());
                break;
            }
            case REQ_SSL_ATTRIBUTE: {
                break;
            }
            case REQ_SSL_CERTIFICATE: {
                break;
            }
            case COMET_BEGIN: {
                this.comet = true;
                break;
            }
            case COMET_END: {
                this.comet = false;
                break;
            }
            case COMET_CLOSE: {
                if (this.socketWrapper == null || ((NginxChannel)this.socketWrapper.getSocket()).getAttachment() == null) {
                    return;
                }
                RequestInfo rp = this.request.getRequestProcessor();
                if (rp.getStage() == 3) break;
                throw new UnsupportedOperationException("not support COMET_CLOSE yet!");
            }
            case COMET_SETTIMEOUT: {
                if (param == null) {
                    return;
                }
                if (this.socketWrapper == null || ((NginxChannel)this.socketWrapper.getSocket()).getAttachment() == null) {
                    return;
                }
                NioEndpoint.KeyAttachment attach = (NioEndpoint.KeyAttachment)((NginxChannel)this.socketWrapper.getSocket()).getAttachment();
                long timeout = (Long)param;
                RequestInfo rp = this.request.getRequestProcessor();
                if (rp.getStage() == 3) break;
                attach.setTimeout(timeout);
                break;
            }
        }
    }

    protected boolean disableKeepAlive() {
        return false;
    }

    protected void setRequestLineReadTimeout() throws IOException {
    }

    protected boolean handleIncompleteRequestLineRead() {
        throw new IllegalStateException("nginx tomat won't have incomplete request line to read");
    }

    protected void setSocketTimeout(int timeout) throws IOException {
        ((NginxChannel)this.socketWrapper.getSocket()).getIOChannel().setAsyncTimeout((long)timeout);
    }

    protected boolean breakKeepAliveLoop(SocketWrapper<NginxChannel> socketWrapper) {
        if (this.sendfileData != null && !this.getErrorState().isError()) {
            try {
                ((NginxChannel)socketWrapper.getSocket()).getIOChannel().sendResponse((Object)new Object[]{MiniConstants.NGX_HTTP_OK, null, new File(this.sendfileData.fileName)});
                this.sendfileInProgress = true;
            }
            catch (IOException e) {
                this.setErrorState(ErrorState.CLOSE_NOW, e);
            }
        }
        return true;
    }

    protected void prepareRequestInternal() {
    }

    boolean prepareSendfile(OutputFilter[] outputFilters) {
        String fileName = (String)this.request.getAttribute("org.apache.tomcat.sendfile.filename");
        if (fileName != null) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
            this.sendfileData = new NginxEndpoint.SendfileData();
            this.sendfileData.fileName = fileName;
            this.sendfileData.pos = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.start");
            this.sendfileData.length = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.end") - this.sendfileData.pos;
            ((NginxChannel)this.socketWrapper.getSocket()).setSendFile(true);
            return true;
        }
        return false;
    }

    protected void resetTimeouts() {
    }

    protected void setCometTimeouts(SocketWrapper<NginxChannel> socketWrapper) {
    }

    protected void recycleInternal() {
        this.socketWrapper = null;
        this.sendfileData = null;
    }

    public AbstractEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        long soTimeout = this.endpoint.getSoTimeout();
        RequestInfo rp = this.request.getRequestProcessor();
        NginxEndpoint.KeyAttachment attach = (NginxEndpoint.KeyAttachment)((Object)((NginxChannel)this.socketWrapper.getSocket()).getAttachment());
        try {
            rp.setStage(3);
            if (!this.getAdapter().event(this.request, this.response, status)) {
                this.setErrorState(ErrorState.CLOSE_NOW, null);
            }
            if (!this.getErrorState().isError() && attach != null) {
                attach.setComet(this.comet);
                if (this.comet) {
                    Integer comettimeout = (Integer)this.request.getAttribute("org.apache.tomcat.comet.timeout");
                    if (comettimeout != null) {
                        attach.setTimeout(comettimeout.longValue());
                    }
                } else if (this.keepAlive) {
                    attach.setTimeout(this.keepAliveTimeout);
                } else {
                    attach.setTimeout(soTimeout);
                }
            }
        }
        catch (InterruptedIOException e) {
            this.setErrorState(ErrorState.CLOSE_NOW, e);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.response.setStatus(500);
            this.setErrorState(ErrorState.CLOSE_NOW, t);
            log.error((Object)sm.getString("http11processor.request.process"), t);
            this.getAdapter().log(this.request, this.response, 0L);
        }
        rp.setStage(7);
        if (this.getErrorState().isError() || status == SocketStatus.STOP) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (!this.comet) {
            if (this.keepAlive) {
                this.inputBuffer.nextRequest();
                this.outputBuffer.nextRequest();
                return AbstractEndpoint.Handler.SocketState.OPEN;
            }
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.LONG;
    }

    protected void registerForEvent(boolean read, boolean write) {
    }

    protected Log getLog() {
        return log;
    }
}

