/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import nginx.clojure.ChannelListener;
import nginx.clojure.NginxHttpServerChannel;
import nginx.clojure.java.NginxJavaRequest;
import org.apache.coyote.http11.NginxChannel;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SecureNioChannel;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class NginxEndpoint
extends AbstractEndpoint<NginxChannel>
implements ChannelListener<SocketWrapper<NginxChannel>> {
    private static final Log log = LogFactory.getLog(NginxEndpoint.class);
    protected SynchronizedStack<NginxChannel> nginxChannels;
    private SynchronizedStack<SocketProcessor> processorCache;
    private SynchronizedStack<KeyAttachment> keyCache;
    private int oomParachute = 0x100000;
    private byte[] oomParachuteData = null;
    private static final String oomParachuteMsg = "SEVERE:Memory usage is low, parachute is non existent, your system may start failing.";
    private long lastParachuteCheck = System.currentTimeMillis();
    private Handler handler = null;

    public int getLocalPort() {
        return 0;
    }

    protected boolean getDeferAccept() {
        return false;
    }

    public void processSocket(SocketWrapper<NginxChannel> socketWrapper, SocketStatus socketStatus, boolean dispatch) {
        NginxChannel channel = (NginxChannel)socketWrapper.getSocket();
        if (channel.isOpen() && dispatch && socketStatus == SocketStatus.OPEN_READ) {
            KeyAttachment ka = (KeyAttachment)socketWrapper;
            ka.setCometNotify(true);
            if (!this.processSocket(ka, SocketStatus.OPEN_READ, true)) {
                this.processSocket(ka, SocketStatus.DISCONNECT, true);
            }
        } else {
            this.processSocket((KeyAttachment)socketWrapper, socketStatus, dispatch);
        }
    }

    protected boolean processSocket(KeyAttachment attachment, SocketStatus status, boolean dispatch) {
        try {
            if (attachment == null) {
                return false;
            }
            attachment.setCometNotify(false);
            SocketProcessor sc = (SocketProcessor)this.processorCache.pop();
            if (sc == null) {
                sc = new SocketProcessor(attachment, status);
            } else {
                sc.reset(attachment, status);
            }
            Executor executor = this.getExecutor();
            if (dispatch && executor != null) {
                executor.execute(sc);
            } else {
                sc.run();
            }
        }
        catch (RejectedExecutionException ree) {
            log.warn((Object)sm.getString("endpoint.executor.fail", new Object[]{attachment.getSocket()}), (Throwable)ree);
            return false;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            log.error((Object)sm.getString("endpoint.process.fail"), t);
            return false;
        }
        return true;
    }

    public void bind() throws Exception {
        log.info((Object)"skip bind because nginx has already done it.");
    }

    public void unbind() throws Exception {
        log.info((Object)"skip unbind because nginx will do it.");
    }

    public void startInternal() throws Exception {
        if (!this.running) {
            this.running = true;
            this.paused = false;
            this.nginxChannels = new SynchronizedStack(128, -1);
            this.processorCache = new SynchronizedStack(128, -1);
            this.keyCache = new SynchronizedStack(128, -1);
            this.acceptors = new AbstractEndpoint.Acceptor[0];
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
        }
    }

    public void stopInternal() throws Exception {
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.keyCache.clear();
            this.nginxChannels.clear();
            this.processorCache.clear();
        }
    }

    protected AbstractEndpoint.Acceptor createAcceptor() {
        throw new UnsupportedOperationException("createAcceptor");
    }

    protected Log getLog() {
        return log;
    }

    public boolean getUseSendfile() {
        return true;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public boolean getUseComet() {
        return false;
    }

    public boolean getUseCometTimeout() {
        return false;
    }

    public boolean getUsePolling() {
        return true;
    }

    public String[] getCiphersUsed() {
        return null;
    }

    protected void checkParachute() {
        boolean para = this.reclaimParachute(false);
        if (!para && System.currentTimeMillis() - this.lastParachuteCheck > 10000L) {
            try {
                log.fatal((Object)oomParachuteMsg);
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                System.err.println(oomParachuteMsg);
            }
            this.lastParachuteCheck = System.currentTimeMillis();
        }
    }

    protected boolean reclaimParachute(boolean force) {
        if (this.oomParachuteData != null) {
            return true;
        }
        if (this.oomParachute > 0 && (force || Runtime.getRuntime().freeMemory() > (long)(this.oomParachute * 2))) {
            this.oomParachuteData = new byte[this.oomParachute];
        }
        return this.oomParachuteData != null;
    }

    protected void releaseCaches() {
        this.keyCache.clear();
        this.nginxChannels.clear();
        this.processorCache.clear();
        if (this.handler != null) {
            this.handler.recycle();
        }
    }

    public void register(NginxChannel socket, boolean dispatch) {
        KeyAttachment key = (KeyAttachment)((Object)this.keyCache.pop());
        KeyAttachment ka = key != null ? key : new KeyAttachment(socket);
        ka.setDispatch(dispatch);
        ka.reset(socket, (long)this.getSocketProperties().getSoTimeout());
        ka.setKeepAliveLeft(this.getMaxKeepAliveRequests());
        ka.setSecure(this.isSSLEnabled());
        this.processSocket(ka, SocketStatus.OPEN_READ, dispatch);
    }

    public KeyAttachment cancelledKey(KeyAttachment ka, SocketStatus status) {
        block16: {
            try {
                block15: {
                    block14: {
                        if (ka != null && ka.isComet() && status != null) {
                            ka.setComet(false);
                            if (status == SocketStatus.TIMEOUT) {
                                if (this.processSocket(ka, status, true)) {
                                    return null;
                                }
                            } else {
                                this.processSocket(ka, status, false);
                            }
                        }
                        if (ka != null) {
                            this.handler.release(ka);
                        }
                        if (((NginxChannel)ka.getSocket()).isOpen()) {
                            try {
                                ((NginxChannel)ka.getSocket()).close();
                            }
                            catch (Exception e) {
                                if (!log.isDebugEnabled()) break block14;
                                log.debug((Object)sm.getString("endpoint.debug.channelCloseFail"), (Throwable)e);
                            }
                        }
                    }
                    try {
                        if (ka != null) {
                            ((NginxChannel)ka.getSocket()).close(true);
                        }
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block15;
                        log.debug((Object)sm.getString("endpoint.debug.socketCloseFail"), (Throwable)e);
                    }
                }
                if (ka != null) {
                    ka.reset();
                    this.countDownConnection();
                }
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable((Throwable)e);
                if (!log.isDebugEnabled()) break block16;
                log.error((Object)"", e);
            }
        }
        return ka;
    }

    public void accept(NginxJavaRequest req, boolean ignoreNginxFilter, boolean dispatch) throws IOException {
        NginxHttpServerChannel ioChannel = req.hijack(ignoreNginxFilter);
        NginxChannel channel = (NginxChannel)this.nginxChannels.pop();
        if (channel == null) {
            channel = new NginxChannel(ioChannel, new NginxBufferHandler(this.socketProperties.getAppReadBufSize(), this.socketProperties.getAppWriteBufSize(), false), ignoreNginxFilter);
        } else {
            channel.setIOChannel(ioChannel);
            channel.reset();
        }
        this.register(channel, dispatch);
    }

    public void onClose(SocketWrapper<NginxChannel> data) throws IOException {
        if (data.getSocket() == null) {
            return;
        }
        this.processSocket(data, SocketStatus.CLOSE_NOW, ((KeyAttachment)data).dispatch);
    }

    public void onConnect(long status, SocketWrapper<NginxChannel> data) throws IOException {
    }

    public void onRead(long status, SocketWrapper<NginxChannel> data) throws IOException {
        if (data.getSocket() == null) {
            return;
        }
        if (status == 0L) {
            this.processSocket(data, SocketStatus.OPEN_READ, ((KeyAttachment)data).dispatch);
        } else {
            this.processSocket(data, SocketStatus.ASYNC_READ_ERROR, ((KeyAttachment)data).dispatch);
        }
    }

    public void onWrite(long status, SocketWrapper<NginxChannel> data) throws IOException {
        if (data.getSocket() == null) {
            return;
        }
        if (status == 0L) {
            this.processSocket(data, SocketStatus.OPEN_WRITE, ((KeyAttachment)data).dispatch);
        } else {
            this.processSocket(data, SocketStatus.ASYNC_WRITE_ERROR, ((KeyAttachment)data).dispatch);
        }
    }

    static /* synthetic */ byte[] access$702(NginxEndpoint x0, byte[] x1) {
        x0.oomParachuteData = x1;
        return x1;
    }

    public static class SendfileData {
        public volatile String fileName;
        public volatile long pos;
        public volatile long length;
    }

    public static class KeyAttachment
    extends SocketWrapper<NginxChannel> {
        private boolean cometNotify = false;
        private boolean dispatch = false;
        private volatile SendfileData sendfileData = null;

        public KeyAttachment(NginxChannel channel) {
            super((Object)channel);
        }

        public void reset(NginxChannel channel, long soTimeout) {
            super.reset((Object)channel, soTimeout);
            this.cometNotify = false;
            this.sendfileData = null;
        }

        public void reset() {
            this.reset(null, -1L);
        }

        public void setCometNotify(boolean notify) {
            this.cometNotify = notify;
        }

        public boolean getCometNotify() {
            return this.cometNotify;
        }

        public void setSendfileData(SendfileData sf) {
            this.sendfileData = sf;
        }

        public SendfileData getSendfileData() {
            return this.sendfileData;
        }

        public void setDispatch(boolean dispatch) {
            this.dispatch = dispatch;
        }

        public boolean getDispatch() {
            return this.dispatch;
        }
    }

    protected class SocketProcessor
    implements Runnable {
        private KeyAttachment ka = null;
        private SocketStatus status = null;

        public SocketProcessor(KeyAttachment ka, SocketStatus status) {
            this.reset(ka, status);
        }

        public void reset(KeyAttachment ka, SocketStatus status) {
            this.ka = ka;
            this.status = status;
        }

        @Override
        public void run() {
            this.doRun(this.ka);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun(KeyAttachment ka) {
            NginxChannel socket = (NginxChannel)ka.getSocket();
            try {
                AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.OPEN;
                state = this.status == null ? NginxEndpoint.this.handler.process(ka, SocketStatus.OPEN_READ) : NginxEndpoint.this.handler.process(ka, this.status);
                if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                    try {
                        ka.setComet(false);
                        if (NginxEndpoint.this.cancelledKey(ka, SocketStatus.ERROR) != null) {
                            if (NginxEndpoint.this.running && !NginxEndpoint.this.paused) {
                                NginxEndpoint.this.nginxChannels.push((Object)socket);
                            }
                            socket = null;
                            if (NginxEndpoint.this.running && !NginxEndpoint.this.paused) {
                                NginxEndpoint.this.keyCache.push((Object)ka);
                            }
                        }
                        ka = null;
                    }
                    catch (Exception x) {
                        log.error((Object)"", (Throwable)x);
                    }
                }
            }
            catch (OutOfMemoryError oom) {
                try {
                    NginxEndpoint.access$702(NginxEndpoint.this, null);
                    log.error((Object)"", (Throwable)oom);
                    if (socket != null) {
                        NginxEndpoint.this.cancelledKey(ka, SocketStatus.ERROR);
                    }
                    NginxEndpoint.this.releaseCaches();
                }
                catch (Throwable oomt) {
                    try {
                        System.err.println(NginxEndpoint.oomParachuteMsg);
                        oomt.printStackTrace();
                    }
                    catch (Throwable letsHopeWeDontGetHere) {
                        ExceptionUtils.handleThrowable((Throwable)letsHopeWeDontGetHere);
                    }
                }
            }
            catch (VirtualMachineError vme) {
                ExceptionUtils.handleThrowable((Throwable)vme);
            }
            catch (Throwable t) {
                log.error((Object)"", t);
                if (socket != null) {
                    NginxEndpoint.this.cancelledKey(ka, SocketStatus.ERROR);
                }
            }
            finally {
                socket = null;
                this.status = null;
                if (NginxEndpoint.this.running && !NginxEndpoint.this.paused) {
                    NginxEndpoint.this.processorCache.push((Object)this);
                }
            }
        }
    }

    public static interface Handler
    extends AbstractEndpoint.Handler {
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<NginxChannel> var1, SocketStatus var2);

        public void release(SocketWrapper<NginxChannel> var1);

        public void release(NginxHttpServerChannel var1);
    }

    public static class NginxBufferHandler
    implements SecureNioChannel.ApplicationBufferHandler {
        private ByteBuffer readbuf = null;
        private ByteBuffer writebuf = null;

        public NginxBufferHandler(int readsize, int writesize, boolean direct) {
            if (direct) {
                this.readbuf = ByteBuffer.allocateDirect(readsize);
                this.writebuf = ByteBuffer.allocateDirect(writesize);
            } else {
                this.readbuf = ByteBuffer.allocate(readsize);
                this.writebuf = ByteBuffer.allocate(writesize);
            }
        }

        public ByteBuffer expand(ByteBuffer buffer, int remaining) {
            return buffer;
        }

        public ByteBuffer getReadBuffer() {
            return this.readbuf;
        }

        public ByteBuffer getWriteBuffer() {
            return this.writebuf;
        }
    }
}

