/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import nginx.clojure.MiniConstants;
import nginx.clojure.NginxClojureRT;
import nginx.clojure.java.NginxJavaRequest;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.AbstractNioInputBuffer;
import org.apache.coyote.http11.NginxChannel;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;

public class InternalNginxInputBuffer
extends AbstractNioInputBuffer<NginxChannel> {
    private static final Log log = LogFactory.getLog(InternalNginxInputBuffer.class);
    protected InputStream body;
    protected NginxChannel socket;

    public InternalNginxInputBuffer(Request request, int headerBufferSize) {
        super(request, headerBufferSize);
        this.inputStreamInputBuffer = new SocketInputBuffer();
    }

    protected boolean fill(boolean block) throws IOException {
        if (!this.parsingHeader) {
            this.lastValid = this.pos = this.end;
        }
        int nRead = 0;
        ByteBuffer readBuffer = this.socket.getBufHandler().getReadBuffer();
        readBuffer.clear();
        int n = nRead = this.body == null ? -1 : this.body.read(readBuffer.array(), 0, readBuffer.limit());
        if (nRead > 0) {
            readBuffer.flip();
            readBuffer.limit(nRead);
            this.expand(nRead + this.pos);
            readBuffer.get(this.buf, this.pos, nRead);
            this.lastValid = this.pos + nRead;
        } else if (nRead == -1) {
            throw new EOFException(sm.getString("iib.eof.error"));
        }
        return nRead > 0;
    }

    public boolean isFinished() {
        if (this.lastValid > this.pos) {
            return false;
        }
        try {
            return this.body == null || this.body.available() == 0;
        }
        catch (IOException e) {
            return true;
        }
    }

    protected void init(NginxChannel sc) throws IOException {
        this.socket = sc;
        NginxJavaRequest jreq = (NginxJavaRequest)sc.getIOChannel().request();
        if (this.buf == null) {
            this.buf = new byte[this.headerBufferSize * 2];
        }
        this.body = (InputStream)jreq.get((Object)"body");
        this.lastValid = (int)NginxClojureRT.ngx_http_clojure_mem_copy_header_buf((long)jreq.nativeRequest(), (Object)this.buf, (long)MiniConstants.BYTE_ARRAY_OFFSET, (long)this.headerBufferSize);
    }

    protected void init(SocketWrapper<NginxChannel> socketWrapper, AbstractEndpoint<NginxChannel> endpoint) throws IOException {
        this.init((NginxChannel)socketWrapper.getSocket());
    }

    protected Log getLog() {
        return log;
    }

    public int doRead(ByteChunk chunk, Request request) throws IOException {
        if (this.body == null) {
            return -1;
        }
        this.lastValid = this.pos = this.end;
        int len = this.body.read(this.buf, this.lastValid, this.buf.length - this.lastValid);
        if (len == 0) {
            return -1;
        }
        chunk.setBytes(this.buf, this.lastValid, len);
        return len;
    }

    public void recycle() {
        super.recycle();
        this.body = null;
    }

    protected class SocketInputBuffer
    implements InputBuffer {
        protected SocketInputBuffer() {
        }

        public int doRead(ByteChunk chunk, Request req) throws IOException {
            if (InternalNginxInputBuffer.this.pos >= InternalNginxInputBuffer.this.lastValid && !InternalNginxInputBuffer.this.fill(true)) {
                return -1;
            }
            int length = InternalNginxInputBuffer.this.lastValid - InternalNginxInputBuffer.this.pos;
            chunk.setBytes(InternalNginxInputBuffer.this.buf, InternalNginxInputBuffer.this.pos, length);
            InternalNginxInputBuffer.this.pos = InternalNginxInputBuffer.this.lastValid;
            return length;
        }
    }
}

