(ns boot.new.nf-template-cljs
  (:require
   [boot.new.templates :as tpl]
   [me.raynes.fs :as fs]))

(defn ->files [name renderer-name lst]
  (let [data {:name name
              :sanitized (tpl/name-to-path name)}
        renderer  (tpl/renderer renderer-name)]
    (apply tpl/->files
           data
           (->> lst (map #(list % (renderer % data)))))))

(defn nf-template-cljs
  "FIXME: write documentation"
  [name]
  (println "Generating fresh 'boot new' nf-template-cljs project.")
  (->files
   name
   "nf-template-cljs"
   [
    ;; root
    "README.md"
    "boot.properties"
    "build.boot"
    ".gitignore"

    ;; src
    "src/{{sanitized}}/core.cljs"

    ;; resources
    "resources/index.html"
    "resources/js/core.cljs.edn"
    ]))
