/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.newt;

import com.sun.javafx.newt.Insets;
import com.sun.javafx.newt.KeyEvent;
import com.sun.javafx.newt.KeyListener;
import com.sun.javafx.newt.MouseEvent;
import com.sun.javafx.newt.MouseListener;
import com.sun.javafx.newt.PaintEvent;
import com.sun.javafx.newt.PaintListener;
import com.sun.javafx.newt.Screen;
import com.sun.javafx.newt.WindowEvent;
import com.sun.javafx.newt.WindowListener;
import com.sun.javafx.newt.impl.Debug;
import com.sun.nativewindow.impl.NWReflection;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;

public abstract class Window
implements NativeWindow {
    public static final boolean DEBUG_MOUSE_EVENT = Debug.debug("Window.MouseEvent");
    public static final boolean DEBUG_KEY_EVENT = Debug.debug("Window.KeyEvent");
    public static final boolean DEBUG_WINDOW_EVENT = Debug.debug("Window.WindowEvent");
    public static final boolean DEBUG_IMPLEMENTATION = Debug.debug("Window");
    protected Screen screen;
    protected AbstractGraphicsConfiguration config;
    protected long windowHandle;
    protected Exception lockedStack = null;
    protected boolean fullscreen;
    protected boolean visible;
    protected int width;
    protected int height;
    protected int x;
    protected int y;
    protected int eventMask;
    protected String title = "Newt Window";
    protected boolean undecorated = false;
    private boolean autoDrawableMember = false;
    private ArrayList mouseListeners = new ArrayList();
    private int mouseButtonPressed = 0;
    private long lastMousePressed = 0L;
    private int lastMouseClickCount = 0;
    public static final int ClickTimeout = 300;
    private ArrayList keyListeners = new ArrayList();
    private ArrayList windowListeners = new ArrayList();
    private ArrayList paintListeners = new ArrayList();

    static void init(String string) {
        if ("MacOSX".equals(string)) {
            try {
                Window.getWindowClass(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static Class getWindowClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        if ("EGL".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.opengl.kd.KDWindow");
        } else if ("Windows".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.windows.WindowsWindow");
        } else if ("MacOSX".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.macosx.MacWindow");
        } else if ("X11".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.x11.X11Window");
        } else if ("AWT".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.awt.AWTWindow");
        } else if ("BroadcomEGL".equals(string)) {
            clazz = Class.forName("com.sun.javafx.newt.opengl.broadcom.BCEGLWindow");
        } else {
            throw new NativeWindowException("Unknown window type \"" + string + "\"");
        }
        return clazz;
    }

    protected static Window create(String string, long l, Screen screen, Capabilities capabilities, boolean bl) {
        try {
            Class clazz = Window.getWindowClass(string);
            Window window = (Window)clazz.newInstance();
            window.invalidate();
            window.screen = screen;
            window.setUndecorated(bl || 0L != l);
            window.createNative(l, capabilities);
            return window;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new NativeWindowException(throwable);
        }
    }

    protected static Window create(String string, Object[] objectArray, Screen screen, Capabilities capabilities, boolean bl) {
        try {
            Class clazz = Window.getWindowClass(string);
            Class[] classArray = Window.getCustomConstructorArgumentTypes(clazz);
            if (null == classArray) {
                throw new NativeWindowException("WindowClass " + clazz + " doesn't support custom arguments in constructor");
            }
            int n = Window.verifyConstructorArgumentTypes(classArray, objectArray);
            if (n < objectArray.length) {
                throw new NativeWindowException("WindowClass " + clazz + " constructor mismatch at argument #" + n + "; Constructor: " + Window.getTypeStrList(classArray) + ", arguments: " + Window.getArgsStrList(objectArray));
            }
            Window window = (Window)NWReflection.createInstance((Class)clazz, (Class[])classArray, (Object[])objectArray);
            window.invalidate();
            window.screen = screen;
            window.setUndecorated(bl);
            window.createNative(0L, capabilities);
            return window;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new NativeWindowException(throwable);
        }
    }

    protected static Window wrapHandle(String string, Screen screen, AbstractGraphicsConfiguration abstractGraphicsConfiguration, long l, boolean bl, boolean bl2, int n, int n2, int n3, int n4) {
        try {
            Class clazz = Window.getWindowClass(string);
            Window window = (Window)clazz.newInstance();
            window.invalidate();
            window.screen = screen;
            window.config = abstractGraphicsConfiguration;
            window.windowHandle = l;
            window.fullscreen = bl;
            window.visible = bl2;
            window.x = n;
            window.y = n2;
            window.width = n3;
            window.height = n4;
            return window;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new NativeWindowException(throwable);
        }
    }

    protected abstract void createNative(long var1, Capabilities var3);

    protected abstract void closeNative();

    public Screen getScreen() {
        return this.screen;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NEWT-Window[config " + this.config + ", windowHandle 0x" + Long.toHexString(this.getWindowHandle()) + ", surfaceHandle 0x" + Long.toHexString(this.getSurfaceHandle()) + ", pos " + this.getX() + "/" + this.getY() + ", size " + this.getWidth() + "x" + this.getHeight() + ", visible " + this.isVisible() + ", undecorated " + this.undecorated + ", fullscreen " + this.fullscreen + ", " + this.screen + ", wrappedWindow " + this.getWrappedWindow());
        stringBuffer.append(", WindowListeners num " + this.windowListeners.size() + " [");
        Iterator iterator = this.windowListeners.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next() + ", ");
        }
        stringBuffer.append("], MouseListeners num " + this.mouseListeners.size() + " [");
        iterator = this.mouseListeners.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next() + ", ");
        }
        stringBuffer.append("], KeyListeners num " + this.keyListeners.size() + " [");
        iterator = this.keyListeners.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next() + ", ");
        }
        stringBuffer.append("] ]");
        return stringBuffer.toString();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setUndecorated(boolean bl) {
        this.undecorated = bl;
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void requestFocus() {
    }

    public synchronized int lockSurface() throws NativeWindowException {
        if (null != this.lockedStack) {
            this.lockedStack.printStackTrace();
            throw new NativeWindowException("NEWT Surface already locked - " + Thread.currentThread().getName() + " " + this);
        }
        this.lockedStack = new Exception("NEWT Surface previously locked by " + Thread.currentThread().getName());
        return 3;
    }

    public synchronized void unlockSurface() {
        if (null == this.lockedStack) {
            throw new NativeWindowException("NEWT Surface not locked");
        }
        this.lockedStack = null;
    }

    public synchronized boolean isSurfaceLocked() {
        return null != this.lockedStack;
    }

    public synchronized Exception getLockedStack() {
        return this.lockedStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        if (DEBUG_WINDOW_EVENT) {
            System.out.println("Window.destroy() start " + Thread.currentThread().getName());
        }
        ArrayList arrayList = this.windowListeners;
        synchronized (arrayList) {
            this.windowListeners = new ArrayList();
        }
        arrayList = this.mouseListeners;
        synchronized (arrayList) {
            this.mouseListeners = new ArrayList();
        }
        arrayList = this.keyListeners;
        synchronized (arrayList) {
            this.keyListeners = new ArrayList();
        }
        this.closeNative();
        this.invalidate();
        if (DEBUG_WINDOW_EVENT) {
            System.out.println("Window.destroy() end " + Thread.currentThread().getName());
        }
    }

    public void invalidate() {
        if (DEBUG_IMPLEMENTATION || DEBUG_WINDOW_EVENT) {
            Exception exception = new Exception("!!! Window Invalidate " + Thread.currentThread().getName());
            exception.printStackTrace();
        }
        this.screen = null;
        this.windowHandle = 0L;
        this.fullscreen = false;
        this.visible = false;
        this.eventMask = 0;
        this.width = 100;
        this.height = 100;
        this.x = 0;
        this.y = 0;
    }

    public boolean surfaceSwap() {
        return false;
    }

    public void surfaceUpdated() {
    }

    protected void clearEventMask() {
        this.eventMask = 0;
    }

    public long getDisplayHandle() {
        return this.screen.getDisplay().getHandle();
    }

    public int getScreenIndex() {
        return this.screen.getIndex();
    }

    public long getWindowHandle() {
        return this.windowHandle;
    }

    public long getSurfaceHandle() {
        return this.windowHandle;
    }

    public void disposeSurfaceHandle() {
    }

    public AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.config;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public Object getWrappedWindow() {
        return null;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public boolean hasDeviceChanged() {
        return false;
    }

    public void setAutoDrawableClient(boolean bl) {
        this.autoDrawableMember = bl;
    }

    protected void windowDestroyNotify() {
        if (DEBUG_WINDOW_EVENT) {
            System.out.println("Window.windowDestroyeNotify start " + Thread.currentThread().getName());
        }
        this.sendWindowEvent(102);
        if (!this.autoDrawableMember) {
            this.destroy();
        }
        if (DEBUG_WINDOW_EVENT) {
            System.out.println("Window.windowDestroyeNotify end " + Thread.currentThread().getName());
        }
    }

    protected void windowDestroyed() {
        if (DEBUG_WINDOW_EVENT) {
            System.out.println("Window.windowDestroyed " + Thread.currentThread().getName());
        }
        this.invalidate();
    }

    public abstract void setVisible(boolean var1);

    public abstract void setSize(int var1, int var2);

    public abstract void setPosition(int var1, int var2);

    public abstract boolean setFullscreen(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        ArrayList arrayList = this.mouseListeners;
        synchronized (arrayList) {
            ArrayList arrayList2 = (ArrayList)this.mouseListeners.clone();
            arrayList2.add(mouseListener);
            this.mouseListeners = arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        ArrayList arrayList = this.mouseListeners;
        synchronized (arrayList) {
            ArrayList arrayList2 = (ArrayList)this.mouseListeners.clone();
            arrayList2.remove(mouseListener);
            this.mouseListeners = arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MouseListener[] getMouseListeners() {
        ArrayList arrayList = this.mouseListeners;
        synchronized (arrayList) {
            return (MouseListener[])this.mouseListeners.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMouseEvent(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 < 0 || n4 < 0 || n3 >= this.width || n4 >= this.height) {
            return;
        }
        if (DEBUG_MOUSE_EVENT) {
            System.out.println("sendMouseEvent: " + MouseEvent.getEventTypeString(n) + ", mod " + n2 + ", pos " + n3 + "/" + n4 + ", button " + n5);
        }
        if (n5 < 0 || n5 > 6) {
            throw new NativeWindowException("Invalid mouse button number" + n5);
        }
        long l = System.currentTimeMillis();
        MouseEvent mouseEvent = null;
        MouseEvent mouseEvent2 = null;
        if (203 == n) {
            this.lastMouseClickCount = l - this.lastMousePressed < 300L ? ++this.lastMouseClickCount : 1;
            this.lastMousePressed = l;
            this.mouseButtonPressed = n5;
            mouseEvent2 = new MouseEvent(true, n, this, l, n2, n3, n4, this.lastMouseClickCount, n5, 0);
        } else if (204 == n) {
            mouseEvent2 = new MouseEvent(true, n, this, l, n2, n3, n4, this.lastMouseClickCount, n5, 0);
            if (l - this.lastMousePressed < 300L) {
                mouseEvent = new MouseEvent(true, 200, this, l, n2, n3, n4, this.lastMouseClickCount, n5, 0);
            } else {
                this.lastMouseClickCount = 0;
                this.lastMousePressed = 0L;
            }
            this.mouseButtonPressed = 0;
        } else {
            mouseEvent2 = 205 == n ? (this.mouseButtonPressed > 0 ? new MouseEvent(true, 206, this, l, n2, n3, n4, 1, this.mouseButtonPressed, 0) : new MouseEvent(true, n, this, l, n2, n3, n4, 0, n5, 0)) : (207 == n ? new MouseEvent(true, n, this, l, n2, n3, n4, 0, n5, n6) : new MouseEvent(true, n, this, l, n2, n3, n4, 0, n5, 0));
        }
        if (DEBUG_MOUSE_EVENT) {
            System.out.println("sendMouseEvent: event:         " + mouseEvent2);
            if (null != mouseEvent) {
                System.out.println("sendMouseEvent: event Clicked: " + mouseEvent);
            }
        }
        ArrayList arrayList = null;
        Object object = this.mouseListeners;
        synchronized (object) {
            arrayList = this.mouseListeners;
        }
        object = arrayList.iterator();
        block13: while (object.hasNext()) {
            MouseListener mouseListener = (MouseListener)object.next();
            switch (mouseEvent2.getEventType()) {
                case 200: {
                    mouseListener.mouseClicked(mouseEvent2);
                    continue block13;
                }
                case 201: {
                    mouseListener.mouseEntered(mouseEvent2);
                    continue block13;
                }
                case 202: {
                    mouseListener.mouseExited(mouseEvent2);
                    continue block13;
                }
                case 203: {
                    mouseListener.mousePressed(mouseEvent2);
                    continue block13;
                }
                case 204: {
                    mouseListener.mouseReleased(mouseEvent2);
                    if (null == mouseEvent) continue block13;
                    mouseListener.mouseClicked(mouseEvent);
                    continue block13;
                }
                case 205: {
                    mouseListener.mouseMoved(mouseEvent2);
                    continue block13;
                }
                case 206: {
                    mouseListener.mouseDragged(mouseEvent2);
                    continue block13;
                }
                case 207: {
                    mouseListener.mouseWheelMoved(mouseEvent2);
                    continue block13;
                }
            }
            throw new NativeWindowException("Unexpected mouse event type " + mouseEvent2.getEventType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        ArrayList arrayList = this.keyListeners;
        synchronized (arrayList) {
            ArrayList arrayList2 = (ArrayList)this.keyListeners.clone();
            arrayList2.add(keyListener);
            this.keyListeners = arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        ArrayList arrayList = this.keyListeners;
        synchronized (arrayList) {
            ArrayList arrayList2 = (ArrayList)this.keyListeners.clone();
            arrayList2.remove(keyListener);
            this.keyListeners = arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyListener[] getKeyListeners() {
        ArrayList arrayList = this.keyListeners;
        synchronized (arrayList) {
            return (KeyListener[])this.keyListeners.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendKeyEvent(int n, int n2, int n3, char c) {
        KeyEvent keyEvent = new KeyEvent(true, n, this, System.currentTimeMillis(), n2, n3, c);
        if (DEBUG_KEY_EVENT) {
            System.out.println("sendKeyEvent: " + keyEvent);
        }
        ArrayList arrayList = null;
        Object object = this.keyListeners;
        synchronized (object) {
            arrayList = this.keyListeners;
        }
        object = arrayList.iterator();
        block8: while (object.hasNext()) {
            KeyListener keyListener = (KeyListener)object.next();
            switch (n) {
                case 300: {
                    keyListener.keyPressed(keyEvent);
                    continue block8;
                }
                case 301: {
                    keyListener.keyReleased(keyEvent);
                    continue block8;
                }
                case 302: {
                    keyListener.keyTyped(keyEvent);
                    continue block8;
                }
            }
            throw new NativeWindowException("Unexpected key event type " + keyEvent.getEventType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindowListener(WindowListener windowListener) {
        if (windowListener == null) {
            return;
        }
        ArrayList arrayList = this.windowListeners;
        synchronized (arrayList) {
            ArrayList arrayList2 = (ArrayList)this.windowListeners.clone();
            arrayList2.add(windowListener);
            this.windowListeners = arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindowListener(WindowListener windowListener) {
        if (windowListener == null) {
            return;
        }
        ArrayList arrayList = this.windowListeners;
        synchronized (arrayList) {
            ArrayList arrayList2 = (ArrayList)this.windowListeners.clone();
            arrayList2.remove(windowListener);
            this.windowListeners = arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowListener[] getWindowListeners() {
        ArrayList arrayList = this.windowListeners;
        synchronized (arrayList) {
            return (WindowListener[])this.windowListeners.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendWindowEvent(int n) {
        WindowEvent windowEvent = new WindowEvent(true, n, this, System.currentTimeMillis());
        if (DEBUG_WINDOW_EVENT) {
            System.out.println("sendWindowEvent: " + windowEvent);
        }
        ArrayList arrayList = null;
        Object object = this.windowListeners;
        synchronized (object) {
            arrayList = this.windowListeners;
        }
        object = arrayList.iterator();
        block10: while (object.hasNext()) {
            WindowListener windowListener = (WindowListener)object.next();
            switch (n) {
                case 100: {
                    windowListener.windowResized(windowEvent);
                    continue block10;
                }
                case 101: {
                    windowListener.windowMoved(windowEvent);
                    continue block10;
                }
                case 102: {
                    windowListener.windowDestroyNotify(windowEvent);
                    continue block10;
                }
                case 103: {
                    windowListener.windowGainedFocus(windowEvent);
                    continue block10;
                }
                case 104: {
                    windowListener.windowLostFocus(windowEvent);
                    continue block10;
                }
            }
            throw new NativeWindowException("Unexpected window event type " + windowEvent.getEventType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPaintListener(PaintListener paintListener) {
        if (paintListener == null) {
            return;
        }
        ArrayList arrayList = this.paintListeners;
        synchronized (arrayList) {
            ArrayList arrayList2 = (ArrayList)this.paintListeners.clone();
            arrayList2.add(paintListener);
            this.paintListeners = arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePaintListener(PaintListener paintListener) {
        if (paintListener == null) {
            return;
        }
        ArrayList arrayList = this.paintListeners;
        synchronized (arrayList) {
            ArrayList arrayList2 = (ArrayList)this.paintListeners.clone();
            arrayList2.remove(paintListener);
            this.paintListeners = arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPaintEvent(int n, int n2, int n3, int n4, int n5) {
        PaintEvent paintEvent = new PaintEvent(n, this, System.currentTimeMillis(), n2, n3, n4, n5);
        ArrayList arrayList = null;
        Object object = this.paintListeners;
        synchronized (object) {
            arrayList = this.paintListeners;
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            PaintListener paintListener = (PaintListener)object.next();
            paintListener.exposed(paintEvent);
        }
    }

    private static Class[] getCustomConstructorArgumentTypes(Class clazz) {
        Class[] classArray = null;
        try {
            Method method = clazz.getDeclaredMethod("getCustomConstructorArgumentTypes", new Class[0]);
            classArray = (Class[])method.invoke(null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return classArray;
    }

    private static int verifyConstructorArgumentTypes(Class[] classArray, Object[] objectArray) {
        if (classArray.length != objectArray.length) {
            return -1;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (classArray[i].isInstance(objectArray[i])) continue;
            return i;
        }
        return objectArray.length;
    }

    private static String getArgsStrList(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(objectArray[i].getClass());
            if (i >= objectArray.length) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private static String getTypeStrList(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(classArray[i]);
            if (i >= classArray.length) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }
}

