/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.newt.windows;

import com.sun.javafx.newt.Insets;
import com.sun.javafx.newt.Window;
import com.sun.javafx.newt.windows.WindowsDisplay;
import com.sun.javafx.newt.windows.WindowsScreen;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;

public class WindowsWindow
extends Window {
    private long hmon;
    private long hdc;
    private long windowHandleClose;
    private long parentWindowHandle;
    private int nfs_width;
    private int nfs_height;
    private int nfs_x;
    private int nfs_y;
    private final Insets insets = new Insets(0, 0, 0, 0);

    public long getSurfaceHandle() {
        if (this.hdc == 0L && 0L != this.windowHandle) {
            this.hdc = this.GetDC(this.windowHandle);
            this.hmon = this.MonitorFromWindow(this.windowHandle);
            if (DEBUG_IMPLEMENTATION || DEBUG_WINDOW_EVENT) {
                Exception exception = new Exception("!!! Window new surface handle " + Thread.currentThread().getName() + ", HWND 0x" + Long.toHexString(this.windowHandle) + ", HDC 0x" + Long.toHexString(this.hdc) + ", HMON 0x" + Long.toHexString(this.hmon));
                exception.printStackTrace();
            }
        }
        return this.hdc;
    }

    public boolean hasDeviceChanged() {
        long l;
        if (0L != this.windowHandle && this.hmon != (l = this.MonitorFromWindow(this.windowHandle))) {
            if (DEBUG_IMPLEMENTATION || DEBUG_WINDOW_EVENT) {
                Exception exception = new Exception("!!! Window Device Changed " + Thread.currentThread().getName() + ", HMON 0x" + Long.toHexString(this.hmon) + " -> 0x" + Long.toHexString(l));
                exception.printStackTrace();
            }
            this.hmon = l;
            return true;
        }
        return false;
    }

    public void disposeSurfaceHandle() {
        if (0L != this.hdc && 0L != this.windowHandle) {
            this.ReleaseDC(this.windowHandle, this.hdc);
            this.hdc = 0L;
            if (DEBUG_IMPLEMENTATION || DEBUG_WINDOW_EVENT) {
                Exception exception = new Exception("!!! Window surface handle disposed " + Thread.currentThread().getName());
                exception.printStackTrace();
            }
        }
    }

    protected void createNative(long l, Capabilities capabilities) {
        WindowsScreen windowsScreen = (WindowsScreen)this.getScreen();
        WindowsDisplay windowsDisplay = (WindowsDisplay)windowsScreen.getDisplay();
        this.config = GraphicsConfigurationFactory.getFactory((AbstractGraphicsDevice)windowsDisplay.getGraphicsDevice()).chooseGraphicsConfiguration(capabilities, null, windowsScreen.getGraphicsScreen());
        if (this.config == null) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        this.windowHandle = this.CreateWindow(l, windowsDisplay.getWindowClassAtom(), "NewtWindowClass", windowsDisplay.getHInstance(), 0L, this.undecorated, this.x, this.y, this.width, this.height);
        if (this.windowHandle == 0L) {
            throw new NativeWindowException("Error creating window");
        }
        this.parentWindowHandle = l;
        this.windowHandleClose = this.windowHandle;
        if (DEBUG_IMPLEMENTATION || DEBUG_WINDOW_EVENT) {
            Exception exception = new Exception("!!! Window new window handle " + Thread.currentThread().getName() + ", HWND 0x" + Long.toHexString(this.windowHandle));
            exception.printStackTrace();
        }
    }

    protected void closeNative() {
        if (this.hdc != 0L) {
            if (this.windowHandleClose != 0L) {
                this.ReleaseDC(this.windowHandleClose, this.hdc);
            }
            this.hdc = 0L;
        }
        if (this.windowHandleClose != 0L) {
            this.DestroyWindow(this.windowHandleClose);
            this.windowHandleClose = 0L;
        }
    }

    protected void windowDestroyed() {
        this.windowHandleClose = 0L;
        super.windowDestroyed();
    }

    public void setVisible(boolean bl) {
        if (this.visible != bl && 0L != this.windowHandle) {
            this.visible = bl;
            WindowsWindow.setVisible0(this.windowHandle, bl);
        }
    }

    public void setSize(int n, int n2) {
        if (0L != this.windowHandle && (n != this.width || this.height != n2)) {
            if (!this.fullscreen) {
                this.nfs_width = n;
                this.nfs_height = n2;
            }
            this.width = n;
            this.height = n2;
            this.setSize0(this.parentWindowHandle, this.windowHandle, this.x, this.y, n, n2);
        }
    }

    public void setPosition(int n, int n2) {
        if (0L != this.windowHandle && (this.x != n || this.y != n2)) {
            if (!this.fullscreen) {
                this.nfs_x = n;
                this.nfs_y = n2;
            }
            this.x = n;
            this.y = n2;
            this.setPosition(this.parentWindowHandle, this.windowHandle, n, n2);
        }
    }

    public boolean setFullscreen(boolean bl) {
        if (0L != this.windowHandle && this.fullscreen != bl) {
            int n;
            int n2;
            int n3;
            int n4;
            this.fullscreen = bl;
            if (bl) {
                n4 = 0;
                n3 = 0;
                n2 = this.screen.getWidth();
                n = this.screen.getHeight();
            } else {
                n4 = this.nfs_x;
                n3 = this.nfs_y;
                n2 = this.nfs_width;
                n = this.nfs_height;
            }
            if (DEBUG_IMPLEMENTATION || DEBUG_WINDOW_EVENT) {
                System.err.println("WindowsWindow fs: " + bl + " " + n4 + "/" + n3 + " " + n2 + "x" + n);
            }
            this.setFullscreen0(this.parentWindowHandle, this.windowHandle, n4, n3, n2, n, this.undecorated, bl);
        }
        return bl;
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.windowHandle != 0L) {
            WindowsWindow.requestFocus(this.windowHandle);
        }
    }

    public void setTitle(String string) {
        if (string == null) {
            string = "";
        }
        if (0L != this.windowHandle && !string.equals(this.getTitle())) {
            super.setTitle(string);
            WindowsWindow.setTitle(this.windowHandle, string);
        }
    }

    public Insets getInsets() {
        return (Insets)this.insets.clone();
    }

    protected static native boolean initIDs();

    private native long CreateWindow(long var1, int var3, String var4, long var5, long var7, boolean var9, int var10, int var11, int var12, int var13);

    private native void DestroyWindow(long var1);

    private native long GetDC(long var1);

    private native void ReleaseDC(long var1, long var3);

    private native long MonitorFromWindow(long var1);

    private static native void setVisible0(long var0, boolean var2);

    private native void setSize0(long var1, long var3, int var5, int var6, int var7, int var8);

    private native void setPosition(long var1, long var3, int var5, int var6);

    private native void setFullscreen0(long var1, long var3, int var5, int var6, int var7, int var8, boolean var9, boolean var10);

    private static native void setTitle(long var0, String var2);

    private static native void requestFocus(long var0);

    private void insetsChanged(int n, int n2, int n3, int n4) {
        if (n != -1 && n2 != -1 && n3 != -1 && n4 != -1) {
            this.insets.left = n;
            this.insets.top = n2;
            this.insets.right = n3;
            this.insets.bottom = n4;
        }
    }

    private void sizeChanged(int n, int n2) {
        this.width = n;
        this.height = n2;
        if (!this.fullscreen) {
            this.nfs_width = this.width;
            this.nfs_height = this.height;
        }
        this.sendWindowEvent(100);
    }

    private void positionChanged(int n, int n2) {
        this.x = n;
        this.y = n2;
        if (!this.fullscreen) {
            this.nfs_x = this.x;
            this.nfs_y = this.y;
        }
        this.sendWindowEvent(101);
    }

    private void focusChanged(long l, boolean bl) {
        if (bl) {
            this.sendWindowEvent(103);
        } else {
            this.sendWindowEvent(104);
        }
    }

    static {
        WindowsDisplay.initSingleton();
    }
}

