(ns cljpyoung.sign.middleware.destructure
  (:refer-clojure :exclude [destructure]))

(defn destructure [var-route]
  (let [&message->args (atom nil)]
    (fn [message]
      (if-let [message->args @&message->args]
        (apply var-route (message->args message))
        (do (->> var-route
                 (meta)
                 :arglists
                 (first)
                 (map keyword)
                 (apply juxt)
                 (reset! &message->args))
            (recur message))))))
