(ns cljpyoung.sign.default
  (:require [taoensso.timbre :as log])
  (:require [cljpyoung.sign.protocol
             [i-app :as i-app]
             [i-route :as i-route]
             [i-router :as i-router]])
  (:require [cljpyoung.sign.middleware
             [normal :as middleware.normal]
             [destructure :as middleware.destructure]]))

;; TODO(pyoung): exclude key from clojure
;; (ns-unalias *ns* 'i-app)
;; (ns-unalias *ns* 'i-router)

(defn var->keyword [var]
  (let [meta (meta var)]
    (keyword (str (:ns meta) "/" (:name meta)))))

;; ==============================================================
;; Route
;; ==============================================================
(defn route
  ([var-route handler]
   (route var-route handler nil))
  ([var-route handler key]
   (let [key (or key (var->keyword var-route))
         handler (handler var-route)]
     (reify i-route/IRoute
       (get-var [this] var-route)
       (get-key [this] key)
       (process [this message]
         (handler message))))))

;; (defn get-route [var-route]
;;   (let [_gen-dic {::mello gen-handler}
;;         meta (meta var-route)
;;         meta-key (first (filter namespace (keys meta)))]
;;     (if-let [x (get _gen-dic meta-key)]
;;       (route var-route x)
;;       (route var-route normal-handler))))

;; (i-route/process (get-route (var helloworld)) "hello")
;; (i-route/process (get-route (var helloworld2)) {:a 1 :b 2 :c 30})


;; ==============================================================
;; Router
;; ==============================================================
(deftype Router
    [_name
     ^:unsynchronized-mutable _dic
     ^:unsynchronized-mutable _gen-dic]

  i-router/IRouter
  (name [this]
    _name)
  (dic [this]
    _dic)
  (get-route [this var-route]
    (let [meta (meta var-route)
          meta-key (first (filter namespace (keys meta)))]
      (route var-route (get _gen-dic meta-key middleware.normal/normal))))
  (add [this var-route]
    (->> (i-router/get-route this var-route)
         (delay)
         (assoc _dic (var->keyword var-route))
         (set! _dic))
    this)
  (dispatch! [this key message]
    (if-let [route (i-router/dispatch this key message)]
      (i-route/process route message)
      ::not-found))
  (dispatch [this key message]
    (if-let [&route (get _dic key)]
      @&route)))

;; (i-router/name (->Router :a {} {::mello gen-handler}))

;; (i-router/add (->Router :a {} {::mello gen-handler}) helloworld2)

;; (i-router/dispatch (i-router/add (->Router :a {} {::mello gen-handler}) (var helloworld2)) ::helloworld2 {:a 1 :b 2 :c 30})

;; (i-router/dispatch (i-router/add (->Router :a {} {::mello gen-handler}) (var helloworld)) ::helloworld "message")

(defn new-app []
  (->Router :a {} {::middleware.destructure/destructure middleware.destructure/destructure}))


;; ==============================================================
;; App
;; ==============================================================
;; (defrecord App [_router]
;;   i-app/IApp
;;   (add [this route]
;;     (i-router/add _router route))
;;   (dispatch [this key message]
;;     (i-router/dispatch _router key message)))

;; (def app (->App router))


;;   (fn [message]
;;     (handler message)))
