(ns cljpyoung.sign
  (:require [cljpyoung.sign.default :as default])
  (:require [cljpyoung.sign.protocol
             [i-route :as i-route]
             [i-router :as app]])
  (:refer-clojure :exclude [reset!]))

(def func-new-default-app default/new-app)

(def default-app (func-new-default-app))

(def ^:dynamic *app* default-app)

(defmacro route
  ([route-symbol] `(route *app* ~route-symbol))
  ([app route-symbol]
   `(do
      (declare ~route-symbol)
      (app/add ~app (var ~route-symbol)))))

(defn dispatch
  ([key message]
   (dispatch *app* key message))
  ([app key message]
   (app/dispatch app key message)))

(defn dispatch!
  ([key message]
   (dispatch! *app* key message))
  ([app key message]
   (app/dispatch! app key message)))

(defn reset!
  ([] (reset! default/new-app))
  ([new-default-app]
   (alter-var-root #'func-new-default-app (fn [_] new-default-app))
   (alter-var-root #'default-app (fn [_] (func-new-default-app)))
   (alter-var-root #'*app* (constantly default-app))))

#_(defn migration-app!
    [from-app to-app]
    (let [routes (vals @(:&route-dic from-app))]
      (doseq [route routes]
        (app/add-route to-app route)))
    (alter-var-root #'*app* (constantly to-app))
    to-app)
