package net.willcohen.proj;

public class Enums {
    enum PJ_LOG_LEVEL {
        PJ_LOG_NONE,
        PJ_LOG_ERROR,
        PJ_LOG_DEBUG,
        PJ_LOG_TRACE,
        PJ_LOG_TELL
    }

    enum PJ_DIRECTION {
        PJ_FWD(1),
        PJ_IDENT(0),
        PJ_INV(-1);

        private int value;
        private PJ_DIRECTION(int value) {
            this.value = value;
        }

        public int getValue() {
            return value;
        }
    }

    enum PJ_GUESSED_WKT_DIALECT {
        PJ_GUESSED_WKT2_2019,
        PJ_GUESSED_WKT2_2015,
        PJ_GUESSED_WKT1_GDAL,
        PJ_GUESSED_WKT1_ESRI,
        PJ_GUESSED_NOT_WKT
    }

    enum PJ_CATEGORY {
        PJ_CATEGORY_ELLIPSOID,
        PJ_CATEGORY_PRIME_MERIDIAN,
        PJ_CATEGORY_DATUM,
        PJ_CATEGORY_CRS,
        PJ_CATEGORY_COORDINATE_OPERATION,
        PJ_CATEGORY_DATUM_ENSEMBLE
    }

    enum PJ_TYPE {
        PJ_TYPE_UNKNOWN,
        PJ_TYPE_ELLIPSOID,
        PJ_TYPE_PRIME_MERIDIAN,
        PJ_TYPE_GEODETIC_REFERENCE_FRAME,
        PJ_TYPE_DYNAMIC_GEODETIC_REFERENCE_FRAME,
        PJ_TYPE_VERTICAL_REFERENCE_FRAME,
        PJ_TYPE_DYNAMIC_VERTICAL_REFERENCE_FRAME,
        PJ_TYPE_DATUM_ENSEMBLE,
        PJ_TYPE_CRS,
        PJ_TYPE_GEODETIC_CRS,
        PJ_TYPE_GEOCENTRIC_CRS,
        PJ_TYPE_GEOGRAPHIC_CRS,
        PJ_TYPE_GEOGRAPHIC_2D_CRS,
        PJ_TYPE_GEOGRAPHIC_3D_CRS,
        PJ_TYPE_VERTICAL_CRS,
        PJ_TYPE_PROJECTED_CRS,
        PJ_TYPE_COMPOUND_CRS,
        PJ_TYPE_TEMPORAL_CRS,
        PJ_TYPE_ENGINEERING_CRS,
        PJ_TYPE_BOUND_CRS,
        PJ_TYPE_OTHER_CRS,
        PJ_TYPE_CONVERSION,
        PJ_TYPE_TRANSFORMATION,
        PJ_TYPE_CONCATENATED_OPERATION,
        PJ_TYPE_OTHER_COORDINATE_OPERATION,
        PJ_TYPE_TEMPORAL_DATUM,
        PJ_TYPE_ENGINEERING_DATUM,
        PJ_TYPE_PARAMETRIC_DATUM
    }

    enum PJ_COMPARISON_CRITERION {
        PJ_COMP_STRICT,
        PJ_COMP_EQUIVALENT,
        PJ_COMP_EQUIVALENT_EXCEPT_AXIS_ORDER_GEOGCRS
    }

    enum PJ_WKT_TYPE {
        PJ_WKT2_2015,
        PJ_WKT2_2015_SIMPLIFIED,
        PJ_WKT2_2019,
        PJ_WKT2_2019_SIMPLIFIED,
        PJ_WKT1_GDAL,
        PJ_WKT1_ESRI
    }

    enum PJ_PROJ_STRING_TYPE {
        PJ_PROJ_5,
        PJ_PROJ_4
    }

    enum PJ_COORDINATE_SYSTEM_TYPE {
        PJ_CS_TYPE_UNKNOWN,
        PJ_CS_TYPE_CARTESIAN,
        PJ_CS_TYPE_ELLIPSOIDAL,
        PJ_CS_TYPE_VERTICAL,
        PJ_CS_TYPE_SPHERICAL,
        PJ_CS_TYPE_ORDINAL,
        PJ_CS_TYPE_PARAMETRIC,
        PJ_CS_TYPE_DATETIMETEMPORAL,
        PJ_CS_TYPE_TEMPORALCOUNT,
        PJ_CS_TYPE_TEMPORALMEASURE
    }

    enum PROJ_CRS_EXTENT_USE {
        PJ_CRS_EXTENT_NONE,
        PJ_CRS_EXTENT_BOTH,
        PJ_CRS_EXTENT_INTERSECTION,
        PJ_CRS_EXTENT_SMALLEST
    }

    enum PROJ_GRID_AVAILABILITY_USE {
        PROJ_GRID_AVAILABILITY_USED_FOR_SORTING,
        PROJ_GRID_AVAILABILITY_DISCARD_OPERATION_IF_MISSING_GRID,
        PROJ_GRID_AVAILABILITY_IGNORED,
        PROJ_GRID_AVAILABILITY_KNOWN_AVAILABLE
    }

    enum PROJ_SPATIAL_CRITERION {
        PROJ_SPATIAL_CRITERION_STRICT_CONTAINMENT,
        PROJ_SPATIAL_CRITERION_PARTIAL_INTERSECTION
    }

    enum PROJ_INTERMEDIATE_CRS_USE {
        PROJ_INTERMEDIATE_CRS_USE_ALWAYS,
        PROJ_INTERMEDIATE_CRS_USE_IF_NO_DIRECT_TRANSFORMATION
    }
}
