# art-cli Ash Ra Template CLI Library



[![License](https://img.shields.io/badge/license-Apache%202-blue.svg?style=flat-square)](LICENSE.txt)
[![Current version](https://img.shields.io/clojars/v/net.vivid-inc/art-cli.svg?color=blue&style=flat-square)](https://clojars.org/net.vivid-inc/art-cli)

`art-cli` aggregates code common to the translation and processing of [Ash Ra Template](https://github.com/vivid-inc/ash-ra-template) build tool and command line arguments into parameters for ART's Clojure API.

_This API is in flux; please don't expect to be able to rely on a stable API until the 1.0 release._

- [Rendering and options](#rendering-and-options)
    - [External ``:dependencies``](#dependencies)

<a name="rendering-and-options"></a>
## Rendering and options

`art-cli` adds additional processing capability to `vivid.art/render` to handle render options.

<a name="dependencies"></a>
### External ``:dependencies``
`art-cli` provides the `vivid.art/render` rendering option `:dependencies`.
Instead of ensuring that the relevant Maven-style dependencies are configured in the runtime that also hosts ART, this option allows you to specify your own set of dependencies.
Doing so activates sandboxing, and the rules change:
- _Sandboxed execution_: The entire template and its embedded Clojure code is evaluated within a sandboxed Clojure runtime courtesy of [ShimDandy](https://github.com/projectodd/shimdandy).
- _Degraded performance_: A new Clojure runtime is instantiated within the current JVM for each template evaluation; this can take on the order of 1 second.
- _Restricted bindings_: Only certain data types that can be serialized to textual Clojure code and reconstituted to their original values can be used as bindings, due to how the ShimDandy bridge functions.

Given a template that ``require``s namespaces from external dependencies in Clojure, such as:
```clojure
<(
(require '[hiccup.core])

(def ^:const toc-headings [{:id 739 :text "Move wing assembly into place"}
                           {:id 740 :text "Connect fuel lines and hydraulics"}
                           {:id 741 :text "Attach wing assembly to fuselage"}])

(defn toc-entry [heading]
  (hiccup.core/html [:li
    [:a#link
      {:href (str "#" (heading :id))}
      (heading :text)]]))
)>
<(= (apply str (map toc-entry toc-headings)) )>
```
The template's external dependencies can be specified as a Clojure deps [lib map](https://clojure.org/reference/deps_and_cli) with `:dependencies` in the option map argument:
```clojure
(vivid.art/render template
                  {:dependencies {'hiccup {:mvn/version "1.0.5"}}})
```
Dependencies are resolved prior to template rendering using Clojure's ``org.clojure/tools.deps.alpha``.

As an implicit dependency, the template execution environment provides ART's minimum supported version of Clojure, version 1.10.0, but this can be overridden using the same mechanism by supplying the `org.clojure/clojure` dependency with a different version:
```clojure
                  {:dependencies {'org.clojure/clojure {:mvn/version "1.10.3"}}}
```

The Maven repositories for dependency resolution are hard-coded:
```clojure
{"central" {:url "https://repo.maven.apache.org/maven2"},
 "clojars" {:url "https://clojars.org/repo/"}}
```
The base (or default) dependencies are:
```clojure
{org.clojure/clojure                     {:mvn/version "1.10.0"},
 org.projectodd.shimdandy/shimdandy-api  {:mvn/version "1.2.1"},
 org.projectodd.shimdandy/shimdandy-impl {:mvn/version "1.2.1"}}
```
If `:dependencies` is supplied as an option to `(vivid.art/render)`, its map will be merged into the base dependency map, overwriting duplicate keys.

Note: The project maintainers are greatly interested in learning about faster ways to dynamically add dependencies to a self-contained Clojure runtime dedicated to rendering a batch of templates without impacting the current env; if you know of a better way or have ideas, please contact us.
