(ns net.vemv.reloaded.browser-refresh.impl
  (:require
   [compojure.core :as compojure]
   [net.vemv.reloaded.browser-refresh.impl.script :as script]
   [ring.middleware.params]))

(defn source-changed-route [^Long last-modified]
  (compojure/GET "/____source_changed" [^String since]
    (-> since
        Long.
        (< last-modified)
        (str))))

(defn wrap-refresh
  [handler last-modified]
  (->> (script/wrap-with-script handler script/refresh-script)
       (compojure/routes (source-changed-route last-modified))
       (ring.middleware.params/wrap-params)))
