(ns net.vemv.reloaded.browser-refresh.component
  (:require
   [com.stuartsierra.component :as component]
   [net.vemv.reloaded.browser-refresh.impl :as impl])
  (:import
   (java.util Date)))

(defn start [this]
  (let [now (-> (Date.) .getTime)
        wrap-fn (fn [app]
                  (impl/wrap-refresh app now))]
    (assoc this ::wrap-fn wrap-fn)))

(defn stop [this]
  {})

(defn new
  "With this component, HTML responses will be injected a JS script
  which automatically refreshes the browser as you issue a `reset`.

  Only successful responses from GET requests will be modified."
  []
  ^{`component/start start
    `component/stop  stop}
  {})
