/*
 * Decompiled with CFR 0.152.
 */
package zlib_tiny;

import java.util.zip.Checksum;

public final class CRC32C
implements Checksum {
    private static final long[] CRC_TABLE = new long[]{0L, -227835133L, -516198153L, 324072436L, -946170081L, 904991772L, 648144872L, -724933397L, -1965467441L, 2024987596L, 1809983544L, -1719030981L, 1296289744L, -1087877933L, -1401372889L, 1578318884L, 274646895L, -499825556L, -244992104L, 51262619L, -675000208L, 632279923L, 922689671L, -996891772L, -1702387808L, 1760304291L, 2075979607L, -1982370732L, 1562183871L, -1351185476L, -1138329528L, 1313733451L, 549293790L, -757723683L, -1048117719L, 871202090L, -416867903L, 357341890L, 102525238L, -193467851L, -1436232175L, 1477399826L, 1264559846L, -1187764763L, 1845379342L, -1617575411L, -1933233671L, 2125378298L, 820201905L, -1031222606L, -774358714L, 598981189L, -143008082L, 85089709L, 373468761L, -467063462L, -1170599554L, 1213305469L, 1526817161L, -1452612982L, 2107672161L, -1882520222L, -1667500394L, 1861252501L, 1098587580L, -1290756417L, -1606390453L, 1378610760L, -2032039261L, 1955203488L, 1742404180L, -1783531177L, -878557837L, 969524848L, 714683780L, -655182201L, 205050476L, -28094097L, -318528869L, 526918040L, 1361435347L, -1555146288L, -1340167644L, 1114974503L, -1765847604L, 1691668175L, 2005155131L, -2047885768L, -604208612L, 697762079L, 986182379L, -928222744L, 476452099L, -301099520L, -44210700L, 255256311L, 1640403810L, -1817374623L, -2130844779L, 1922457750L, -1503918979L, 1412925310L, 1197962378L, -1257441399L, -350237779L, 427051182L, 170179418L, -129025959L, 746937522L, -554770511L, -843174843L, 1070968646L, 1905808397L, -2081171698L, -1868356358L, 1657317369L, -1241332974L, 1147748369L, 1463399397L, -1521340186L, -79622974L, 153784257L, 444234805L, -401473738L, 1021025245L, -827320098L, -572462294L, 797665321L, -2097792136L, 1889384571L, 1674398607L, -1851340660L, 1164749927L, -1224265884L, -1537745776L, 1446797203L, 137323447L, -96149324L, -384560320L, 461344835L, -810158936L, 1037989803L, 781091935L, -588970148L, -1834419177L, 1623424788L, 1939049696L, -2114449437L, 1429367560L, -1487280117L, -1274471425L, 1180866812L, 410100952L, -367384613L, -112536529L, 186734380L, -538233913L, 763408580L, 1053836080L, -860110797L, -1572096602L, 1344288421L, 1131464017L, -1323612590L, 1708204729L, -1749376582L, -2065018290L, 1988219213L, 680717673L, -621187478L, -911630946L, 1002577565L, -284657034L, 493091189L, 238226049L, -61306494L, -1307217207L, 1082061258L, 1395524158L, -1589280451L, 1972364758L, -2015074603L, -1800104671L, 1725896226L, 952904198L, -894981883L, -638100751L, 731699698L, -11092711L, 222117402L, 510512622L, -335130899L, -1014159676L, 837199303L, 582374963L, -790768336L, 68661723L, -159632680L, -450051796L, 390545967L, 1230274059L, -1153434360L, -1469116676L, 1510247935L, -1899042540L, 2091215383L, 1878366691L, -1650582816L, -741088853L, 565732008L, 854102364L, -1065151905L, 340358836L, -433916489L, -177076669L, 119113024L, 1493875044L, -1419691417L, -1204696685L, 1247431312L, -1634718085L, 1828433272L, 2141937292L, -1916740209L, -483350502L, 291187481L, 34330861L, -262120466L, 615137029L, -691946490L, -980332558L, 939183345L, 1776939221L, -1685949482L, -1999470558L, 2058945313L, -1368168502L, 1545135305L, 1330124605L, -1121741762L, -210866315L, 17165430L, 307568514L, -532767615L, 888469610L, -962626711L, -707819363L, 665062302L, 2042050490L, -1948470087L, -1735637171L, 1793573966L, -1104306011L, 1279665062L, 1595330642L, -1384295599L};
    private static final long LONG_MASK = 0xFFFFFFFFL;
    private static final long BYTE_MASK = 255L;
    private long crc = 0L;

    @Override
    public void update(int n) {
        long l = this.crc ^ 0xFFFFFFFFL;
        l = this.updateByte((byte)n, l);
        this.crc = l ^ 0xFFFFFFFFL;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        int n3;
        long l = this.crc ^ 0xFFFFFFFFL;
        int n4 = n + n2;
        int n5 = n4 - 7;
        for (n3 = n; n3 < n5; n3 += 8) {
            for (int i = 0; i < 8; ++i) {
                l = this.updateByte(byArray[n3 + i], l);
            }
        }
        while (n3 < n4) {
            l = this.updateByte(byArray[n3], l);
            ++n3;
        }
        this.crc = l ^ 0xFFFFFFFFL;
    }

    @Override
    public long getValue() {
        return this.crc;
    }

    @Override
    public void reset() {
        this.crc = 0L;
    }

    private long updateByte(byte by, long l) {
        byte by2 = (byte)((long)by & 0xFFL);
        int n = (int)((l ^ (long)by2) & 0xFFL);
        return (CRC_TABLE[n] ^ l >> 8) & 0xFFFFFFFFL;
    }
}

