/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.couch;

import java.util.Iterator;
import net.spy.memcached.CouchbaseClient;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.internal.HttpFuture;
import net.spy.memcached.protocol.couch.Query;
import net.spy.memcached.protocol.couch.View;
import net.spy.memcached.protocol.couch.ViewResponse;
import net.spy.memcached.protocol.couch.ViewRow;

public class Paginator
extends SpyObject
implements Iterator<ViewRow> {
    private static final int MIN_RESULTS = 15;
    private final CouchbaseClient client;
    private final Query query;
    private final View view;
    private final int docsPerPage;
    private ViewResponse page;
    private Iterator<ViewRow> pageItr;
    private ViewRow lastRow;
    private int rowsIterated;

    public Paginator(CouchbaseClient client, View view, Query query, int numDocs) {
        this.client = client;
        this.view = view;
        this.query = query.copy();
        this.docsPerPage = 15 > numDocs ? 15 : numDocs;
        this.getNextPage(this.query.setLimit(this.docsPerPage + 1));
    }

    @Override
    public boolean hasNext() {
        if (!this.pageItr.hasNext() && this.page.size() < this.docsPerPage) {
            return false;
        }
        if (this.rowsIterated >= this.docsPerPage) {
            this.lastRow = this.pageItr.next();
            this.query.setStartkeyDocID(this.lastRow.getId());
            this.query.setRangeStart(this.lastRow.getKey());
            this.getNextPage(this.query);
        }
        return true;
    }

    @Override
    public ViewRow next() {
        if (this.rowsIterated <= this.docsPerPage) {
            ++this.rowsIterated;
            this.lastRow = this.pageItr.next();
            return this.lastRow;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is unsupported");
    }

    private HttpFuture<ViewResponse> getNextPage(Query q) {
        if (this.query.willReduce()) {
            throw new RuntimeException("Pagination is not supported for reduced views");
        }
        this.page = this.client.query(this.view, q);
        this.pageItr = this.page.iterator();
        this.rowsIterated = 0;
        return null;
    }
}

