/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.KetamaNodeLocator;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.PlainCallbackHandler;
import net.spy.memcached.vbucket.ConfigurationException;
import net.spy.memcached.vbucket.ConfigurationProvider;
import net.spy.memcached.vbucket.ConfigurationProviderHTTP;
import net.spy.memcached.vbucket.VBucketNodeLocator;
import net.spy.memcached.vbucket.config.Bucket;
import net.spy.memcached.vbucket.config.Config;
import net.spy.memcached.vbucket.config.ConfigType;

public class MembaseConnectionFactory
extends BinaryConnectionFactory {
    public static final FailureMode DEFAULT_FAILURE_MODE = FailureMode.Retry;
    public static final HashAlgorithm DEFAULT_HASH = DefaultHashAlgorithm.KETAMA_HASH;
    public static final int DEFAULT_OP_QUEUE_LEN = 16384;
    private final ConnectionFactoryBuilder.Locator locator;
    private final AuthDescriptor ad;
    private final ConfigurationProvider configurationProvider;
    private final Config vbConfig;
    private final String bucketName;

    public MembaseConnectionFactory(List<URI> baseList, String bucketName, String usr, String pwd) throws IOException {
        for (URI bu : baseList) {
            if (bu.isAbsolute()) continue;
            throw new IllegalArgumentException("The base URI must be absolute");
        }
        this.bucketName = bucketName;
        this.configurationProvider = new ConfigurationProviderHTTP(baseList, usr, pwd);
        Bucket bucket = this.configurationProvider.getBucketConfiguration(bucketName);
        Config config = bucket.getConfig();
        if (config.getConfigType() == ConfigType.MEMBASE) {
            this.locator = ConnectionFactoryBuilder.Locator.VBUCKET;
            this.vbConfig = bucket.getConfig();
        } else if (config.getConfigType() == ConfigType.MEMCACHE) {
            this.locator = ConnectionFactoryBuilder.Locator.CONSISTENT;
            this.vbConfig = null;
        } else {
            this.locator = null;
            this.vbConfig = null;
            throw new ConfigurationException("Bucket type not supported or JSON response unexpected");
        }
        this.ad = !this.configurationProvider.getAnonymousAuthBucket().equals(bucketName) && usr != null ? new AuthDescriptor(new String[]{"PLAIN"}, new PlainCallbackHandler(usr, pwd)) : null;
    }

    @Override
    public NodeLocator createLocator(List<MemcachedNode> nodes) {
        switch (this.locator) {
            case CONSISTENT: {
                return new KetamaNodeLocator(nodes, this.getHashAlg());
            }
            case VBUCKET: {
                return new VBucketNodeLocator(nodes, this.getVBucketConfig());
            }
        }
        throw new IllegalStateException("Unhandled locator type: " + (Object)((Object)this.locator));
    }

    @Override
    public AuthDescriptor getAuthDescriptor() {
        return this.ad;
    }

    public Config getVBucketConfig() {
        return this.vbConfig;
    }

    public String getBucket() {
        return this.bucketName;
    }

    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public ConnectionFactoryBuilder.Locator getLocator() {
        return this.locator;
    }
}

