/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.CouchbaseClientIF;
import net.spy.memcached.CouchbaseConnection;
import net.spy.memcached.CouchbaseConnectionFactory;
import net.spy.memcached.MembaseClient;
import net.spy.memcached.internal.HttpFuture;
import net.spy.memcached.internal.ViewFuture;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.couch.DocsOperationImpl;
import net.spy.memcached.protocol.couch.HttpOperation;
import net.spy.memcached.protocol.couch.NoDocsOperationImpl;
import net.spy.memcached.protocol.couch.Paginator;
import net.spy.memcached.protocol.couch.Query;
import net.spy.memcached.protocol.couch.ReducedOperationImpl;
import net.spy.memcached.protocol.couch.View;
import net.spy.memcached.protocol.couch.ViewFetcherOperation;
import net.spy.memcached.protocol.couch.ViewFetcherOperationImpl;
import net.spy.memcached.protocol.couch.ViewOperation;
import net.spy.memcached.protocol.couch.ViewResponse;
import net.spy.memcached.protocol.couch.ViewRow;
import net.spy.memcached.protocol.couch.ViewsFetcherOperation;
import net.spy.memcached.protocol.couch.ViewsFetcherOperationImpl;
import net.spy.memcached.vbucket.config.Bucket;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.message.BasicHttpRequest;

public class CouchbaseClient
extends MembaseClient
implements CouchbaseClientIF {
    private static final String MODE_PRODUCTION = "production";
    private static final String MODE_DEVELOPMENT = "development";
    private static final String DEV_PREFIX = "dev_";
    private static final String PROD_PREFIX = "";
    public static final String MODE_PREFIX;
    private static final String MODE_ERROR;
    private CouchbaseConnection cconn;
    private final String bucketName;

    public CouchbaseClient(List<URI> baseList, String bucketName, String pwd) throws IOException {
        this(baseList, bucketName, bucketName, pwd);
    }

    public CouchbaseClient(List<URI> baseList, String bucketName, String usr, String pwd) throws IOException {
        super(new CouchbaseConnectionFactory(baseList, bucketName, usr, pwd), false);
        this.bucketName = bucketName;
        CouchbaseConnectionFactory cf = (CouchbaseConnectionFactory)this.connFactory;
        List<InetSocketAddress> addrs = AddrUtil.getAddresses(cf.getVBucketConfig().getServers());
        LinkedList<InetSocketAddress> conv = new LinkedList<InetSocketAddress>();
        while (!addrs.isEmpty()) {
            conv.add(addrs.remove(0));
        }
        while (!conv.isEmpty()) {
            addrs.add(new InetSocketAddress(((InetSocketAddress)conv.remove(0)).getHostName(), 5984));
        }
        this.getLogger().info(MODE_ERROR);
        this.cconn = cf.createCouchDBConnection(addrs);
        cf.getConfigurationProvider().subscribe(cf.getBucket(), this);
    }

    @Override
    public HttpFuture<View> asyncGetView(String designDocumentName, String viewName) {
        designDocumentName = MODE_PREFIX + designDocumentName;
        String uri = "/" + this.bucketName + "/_design/" + designDocumentName;
        final CountDownLatch couchLatch = new CountDownLatch(1);
        final HttpFuture<View> crv = new HttpFuture<View>(couchLatch, 60000L);
        BasicHttpRequest request = new BasicHttpRequest("GET", uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
        ViewFetcherOperationImpl op = new ViewFetcherOperationImpl((HttpRequest)request, this.bucketName, designDocumentName, viewName, new ViewFetcherOperation.ViewFetcherCallback(){
            private View view = null;

            @Override
            public void receivedStatus(OperationStatus status) {
                crv.set(this.view, status);
            }

            @Override
            public void complete() {
                couchLatch.countDown();
            }

            @Override
            public void gotData(View v) {
                this.view = v;
            }
        });
        crv.setOperation(op);
        this.addOp(op);
        return crv;
    }

    @Override
    public HttpFuture<List<View>> asyncGetViews(String designDocumentName) {
        designDocumentName = MODE_PREFIX + designDocumentName;
        String uri = "/" + this.bucketName + "/_design/" + designDocumentName;
        final CountDownLatch couchLatch = new CountDownLatch(1);
        final HttpFuture<List<View>> crv = new HttpFuture<List<View>>(couchLatch, 60000L);
        BasicHttpRequest request = new BasicHttpRequest("GET", uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
        ViewsFetcherOperationImpl op = new ViewsFetcherOperationImpl((HttpRequest)request, this.bucketName, designDocumentName, new ViewsFetcherOperation.ViewsFetcherCallback(){
            private List<View> views = null;

            @Override
            public void receivedStatus(OperationStatus status) {
                crv.set(this.views, status);
            }

            @Override
            public void complete() {
                couchLatch.countDown();
            }

            @Override
            public void gotData(List<View> v) {
                this.views = v;
            }
        });
        crv.setOperation(op);
        this.addOp(op);
        return crv;
    }

    @Override
    public View getView(String designDocumentName, String viewName) {
        try {
            return this.asyncGetView(designDocumentName, viewName).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted getting views", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed getting views", e);
        }
    }

    @Override
    public List<View> getViews(String designDocumentName) {
        try {
            return this.asyncGetViews(designDocumentName).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted getting views", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed getting views", e);
        }
    }

    @Override
    public HttpFuture<ViewResponse> asyncQuery(View view, Query query) {
        if (query.willReduce()) {
            return this.asyncQueryAndReduce(view, query);
        }
        if (query.willIncludeDocs()) {
            return this.asyncQueryAndIncludeDocs(view, query);
        }
        return this.asyncQueryAndExcludeDocs(view, query);
    }

    private HttpFuture<ViewResponse> asyncQueryAndIncludeDocs(View view, Query query) {
        String uri = view.getURI() + query.toString();
        final CountDownLatch couchLatch = new CountDownLatch(1);
        final ViewFuture crv = new ViewFuture(couchLatch, 60000L);
        BasicHttpRequest request = new BasicHttpRequest("GET", uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
        DocsOperationImpl op = new DocsOperationImpl((HttpRequest)request, new ViewOperation.ViewCallback(){
            private ViewResponse vr = null;

            @Override
            public void receivedStatus(OperationStatus status) {
                if (this.vr != null) {
                    LinkedList<String> ids = new LinkedList<String>();
                    Iterator<ViewRow> itr = this.vr.iterator();
                    while (itr.hasNext()) {
                        ids.add(itr.next().getId());
                    }
                    crv.set(this.vr, CouchbaseClient.this.asyncGetBulk(ids), status);
                } else {
                    crv.set(null, null, status);
                }
            }

            @Override
            public void complete() {
                couchLatch.countDown();
            }

            @Override
            public void gotData(ViewResponse response) {
                this.vr = response;
            }
        });
        crv.setOperation(op);
        this.addOp(op);
        return crv;
    }

    private HttpFuture<ViewResponse> asyncQueryAndExcludeDocs(View view, Query query) {
        String uri = view.getURI() + query.toString();
        final CountDownLatch couchLatch = new CountDownLatch(1);
        final HttpFuture<ViewResponse> crv = new HttpFuture<ViewResponse>(couchLatch, 60000L);
        BasicHttpRequest request = new BasicHttpRequest("GET", uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
        NoDocsOperationImpl op = new NoDocsOperationImpl((HttpRequest)request, new ViewOperation.ViewCallback(){
            private ViewResponse vr = null;

            @Override
            public void receivedStatus(OperationStatus status) {
                crv.set(this.vr, status);
            }

            @Override
            public void complete() {
                couchLatch.countDown();
            }

            @Override
            public void gotData(ViewResponse response) {
                this.vr = response;
            }
        });
        crv.setOperation(op);
        this.addOp(op);
        return crv;
    }

    private HttpFuture<ViewResponse> asyncQueryAndReduce(View view, Query query) {
        if (!view.hasReduce()) {
            throw new RuntimeException("This view doesn't contain a reduce function");
        }
        String uri = view.getURI() + query.toString();
        final CountDownLatch couchLatch = new CountDownLatch(1);
        final HttpFuture<ViewResponse> crv = new HttpFuture<ViewResponse>(couchLatch, 60000L);
        BasicHttpRequest request = new BasicHttpRequest("GET", uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
        ReducedOperationImpl op = new ReducedOperationImpl((HttpRequest)request, new ViewOperation.ViewCallback(){
            private ViewResponse vr = null;

            @Override
            public void receivedStatus(OperationStatus status) {
                crv.set(this.vr, status);
            }

            @Override
            public void complete() {
                couchLatch.countDown();
            }

            @Override
            public void gotData(ViewResponse response) {
                this.vr = response;
            }
        });
        crv.setOperation(op);
        this.addOp(op);
        return crv;
    }

    @Override
    public ViewResponse query(View view, Query query) {
        try {
            return this.asyncQuery(view, query).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while accessing the view", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to access the view", e);
        }
    }

    public Paginator paginatedQuery(View view, Query query, int docsPerPage) {
        return new Paginator(this, view, query, 10);
    }

    public void addOp(HttpOperation op) {
        this.cconn.checkState();
        this.cconn.addOp(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconfigure(Bucket bucket) {
        this.reconfiguring = true;
        try {
            this.mconn.reconfigure(bucket);
            this.cconn.reconfigure(bucket);
        }
        catch (IllegalArgumentException ex) {
            this.getLogger().warn((Object)"Failed to reconfigure client, staying with previous configuration.", ex);
        }
        finally {
            this.reconfiguring = false;
        }
    }

    @Override
    public void shutdown() {
        this.shutdown(-1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean shutdown(long duration, TimeUnit units) {
        try {
            return super.shutdown(duration, units) && this.cconn.shutdown();
        }
        catch (IOException e) {
            this.getLogger().error("Error shutting down CouchbaseClient");
            return false;
        }
    }

    static {
        Properties properties = new Properties(System.getProperties());
        String viewmode = properties.getProperty("viewmode", null);
        if (viewmode == null) {
            try {
                URL url = ClassLoader.getSystemResource("cbclient.properties");
                if (url != null) {
                    properties.load(new FileInputStream(new File(url.getFile())));
                }
                viewmode = properties.getProperty("viewmode");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (viewmode == null) {
            MODE_ERROR = "viewmode property isn't defined. Setting viewmode to production mode";
            MODE_PREFIX = PROD_PREFIX;
        } else if (viewmode.equals(MODE_PRODUCTION)) {
            MODE_ERROR = "viewmode set to production mode";
            MODE_PREFIX = PROD_PREFIX;
        } else if (viewmode.equals(MODE_DEVELOPMENT)) {
            MODE_ERROR = "viewmode set to development mode";
            MODE_PREFIX = DEV_PREFIX;
        } else {
            MODE_ERROR = "unknown value \"" + viewmode + "\" for property viewmode" + " Setting to production mode";
            MODE_PREFIX = PROD_PREFIX;
        }
    }
}

