/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.barbecue;

import java.util.Arrays;
import net.sourceforge.barbecue.output.AbstractOutput;

public class Module {
    protected final int[] bars;
    private String symbol;

    public Module(int[] nArray) {
        this.bars = nArray;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String string) {
        this.symbol = string;
    }

    public int widthInBars() {
        int n = 0;
        for (int i = 0; i < this.bars.length; ++i) {
            n += this.bars[i];
        }
        return n;
    }

    protected double draw(AbstractOutput abstractOutput, double d, double d2) {
        double d3 = 0.0;
        for (int i = 0; i < this.bars.length; ++i) {
            int n = this.bars[i];
            double d4 = (double)n * abstractOutput.getBarWidth();
            d3 += d4;
            abstractOutput.drawBar((int)d, (int)d2, (int)d4, (int)abstractOutput.getBarHeight(), i % 2 == 0);
            d += d4;
        }
        return d3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Module)) {
            return false;
        }
        Module module = (Module)object;
        return Arrays.equals(this.bars, module.bars);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.bars.length; ++i) {
            n += (i + 1) * this.bars[i];
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.bars.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.bars[i]);
        }
        return stringBuffer.toString();
    }
}

