/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ghost4j.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DiskStore {
    public static final String ROOT_PATH = System.getProperty("java.io.tmpdir") + File.separator + "ghost4j";
    private static DiskStore instance;
    private Map<String, File> map = new HashMap<String, File>();

    public static synchronized DiskStore getInstance() {
        if (instance == null) {
            instance = new DiskStore();
        }
        return instance;
    }

    private DiskStore() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                super.run();
                DiskStore diskStore = DiskStore.getInstance();
                try {
                    for (String key : DiskStore.this.map.keySet()) {
                        diskStore.removeFile(key);
                    }
                    new File(ROOT_PATH).delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public synchronized File getFile(String key) {
        return this.map.get(key);
    }

    public synchronized void removeFile(String key) throws IOException {
        File file = this.getFile(key);
        if (file != null) {
            if (!file.delete()) {
                throw new IOException("Temporary file " + file.getAbsolutePath() + " cannot be deleted");
            }
            this.map.remove(key);
        }
    }

    public synchronized File addFile(String key) {
        File file = new File(ROOT_PATH, key);
        file.getParentFile().mkdirs();
        this.map.put(key, file);
        return file;
    }
}

