/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ghost4j.renderer;

import java.io.IOException;
import java.util.List;
import net.sf.ghost4j.Ghostscript;
import net.sf.ghost4j.GhostscriptException;
import net.sf.ghost4j.display.PageRaster;
import net.sf.ghost4j.display.PageRasterDisplayCallback;
import net.sf.ghost4j.document.Document;
import net.sf.ghost4j.document.DocumentException;
import net.sf.ghost4j.document.PDFDocument;
import net.sf.ghost4j.document.PSDocument;
import net.sf.ghost4j.renderer.AbstractRemoteRenderer;
import net.sf.ghost4j.renderer.RendererException;
import net.sf.ghost4j.util.DiskStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRenderer
extends AbstractRemoteRenderer {
    private int resolution = 75;

    public SimpleRenderer() {
        this.supportedDocumentClasses = new Class[2];
        this.supportedDocumentClasses[0] = PDFDocument.class;
        this.supportedDocumentClasses[1] = PSDocument.class;
    }

    public static void main(String[] args) throws RendererException {
        SimpleRenderer.startRemoteRenderer(new SimpleRenderer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PageRaster> run(Document document, int begin, int end) throws IOException, RendererException, DocumentException {
        this.assertDocumentSupported(document);
        Ghostscript gs = Ghostscript.getInstance();
        DiskStore diskStore = DiskStore.getInstance();
        String inputDiskStoreKey = document.toString() + String.valueOf(System.currentTimeMillis() + String.valueOf((int)(Math.random() * 1000.0)));
        document.write(diskStore.addFile(inputDiskStoreKey));
        PageRasterDisplayCallback displayCallback = new PageRasterDisplayCallback();
        String[] gsArgs = new String[]{"-dQUIET", "-dNOPAUSE", "-dBATCH", "-dSAFER", "-dFirstPage=" + (begin + 1), "-dLastPage=" + (end + 1), "-sDEVICE=display", "-sDisplayHandle=0", "-dDisplayFormat=16#804", "-r" + this.getResolution(), "-f", diskStore.getFile(inputDiskStoreKey).getAbsolutePath()};
        try {
            try {
                Ghostscript ghostscript = gs;
                synchronized (ghostscript) {
                    gs.setDisplayCallback(displayCallback);
                    gs.initialize(gsArgs);
                    gs.exit();
                }
            }
            catch (GhostscriptException e) {
                throw new RendererException(e);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException e) {
                throw new RendererException(e);
            }
            diskStore.removeFile(inputDiskStoreKey);
            throw throwable;
        }
        try {}
        catch (GhostscriptException e) {
            throw new RendererException(e);
        }
        Ghostscript.deleteInstance();
        diskStore.removeFile(inputDiskStoreKey);
        return displayCallback.getRasters();
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }
}

