/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ghost4j;

import gnu.cajo.invoke.Remote;
import java.io.IOException;
import java.util.HashMap;
import net.sf.ghost4j.AbstractComponent;
import net.sf.ghost4j.util.JavaFork;
import net.sf.ghost4j.util.NetworkUtil;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemoteComponent
extends AbstractComponent {
    private Logger logger = Logger.getLogger((String)AbstractRemoteComponent.class.getName());
    protected int maxProcessCount = 0;
    protected int processCount = 0;

    public void waitForFreeProcess() {
        while (this.processCount >= this.maxProcessCount) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
    }

    public boolean isStandAloneModeSupported() {
        try {
            this.getClass().getMethod("main", String[].class);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected synchronized int startRemoteServer(JavaFork fork) throws IOException {
        int cajoPort = NetworkUtil.findAvailablePort("127.0.0.1", 5000, 6000);
        if (cajoPort == 0) {
            throw new IOException("No port available to start remote component");
        }
        this.logger.debug((Object)(Thread.currentThread() + " uses " + cajoPort + " as server port"));
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put("cajo.port", String.valueOf(cajoPort));
        fork.setEnvironment(environment);
        fork.start();
        NetworkUtil.waitUntilPortListening("127.0.0.1", cajoPort, 10000);
        return cajoPort;
    }

    protected synchronized Object getRemoteComponent(int serverPort, Class<?> clazz) throws Exception {
        return Remote.getItem("//127.0.0.1:" + serverPort + "/" + clazz.getCanonicalName());
    }

    protected JavaFork buildJavaFork() {
        JavaFork fork = new JavaFork();
        fork.setRedirectStreams(true);
        fork.setWaitBeforeExiting(false);
        fork.setStartClass(this.getClass());
        return fork;
    }

    public int getMaxProcessCount() {
        return this.maxProcessCount;
    }

    public void setMaxProcessCount(int maxProcessCount) {
        this.maxProcessCount = maxProcessCount;
    }

    public int getProcessCount() {
        return this.processCount;
    }
}

